.tr ~
.SA 0
.TL
X11 INPUT SYNTHESIS EXTENSION PROPOSAL
.AF "Hewlett Packard"
.ds ZZ Corvallis~Workstation~Operation
.AU "Larry Woestman" "" ZZ
.AT "Member of Technical Staff"
.AS
This is a proposal for an extension to the X11 server and Xlib.
It provides two capabilities:
.BL
.LI
It allows a client to generate user input actions in the server without
requiring a user to be present.
.LI
It also allows a client to control the
handling of user input actions by the server.
.LE
.P
The capability
to allow a client to generate user input actions in the server
will be used by some of the X Testing Consortium Xlib tests.
Both capabilities will be used by the X Testing Consortium client exerciser
program.
These capabilities may also be useful in other programs.
.P
This extension requires modification to device-dependent code in the
server.  Therefore it is not a `portable' extension as defined by the
X11 Server Extensions document.  However, the majority of the code
and functionality of this extension will be implementation-independent.
.AE
.MT 4
.nr Cl 4
.PH "'X11 Input Synthesis Extension Proposal''Page \\\\nP'"
.PF "''\\\\*(DT''"
.SK 1
.H 1 Conventions~Used~In~This~Document
The naming conventions used in the Xlib documentation are followed 
with these additions:
.BL
.LI
The names of all functions defined in this extension begin with `XTest',
with the first letter of each additional word capitalized.
.LI
The names of the protocol request structures follow the Xlib convention
of `x<name>Req'.
.LI
The names of the protocol request minor type codes follow the Xlib convention
of `X_<name>'.
.LI
The names of all other constants defined in this extension begin with `XTest',
with the rest of the name in upper case letters.
.LI
All constants and structures defined in this extension will have their
values specified in the `xtestext1.h' file (listed in section 5).
.LE
.H 1 Definition~Of~Terms
.H 2 Input~Actions
Input actions are pointer movements, button presses and releases,
and key presses and releases.  They can be generated by a user or by a client
(using functions in this extension).
.H 2 User~Input~Actions
User input actions are input actions that are generated by the user
moving a pointing device (typically a mouse), pressing and releasing buttons on
the pointing device, and pressing and releasing keys on the keyboard.
.SK
.H 1 What~Does~This~Extension~Do?
Without this extension, user input actions are processed by the server,
and are converted into normal X events that are sent to the
appropriate client or clients.
.P
This extension adds the following capabilities:
.BL
.LI
Input actions may be sent from a client to the server to be
processed just as if the user had physically performed them.
The input actions are provided to the server in the form of X protocol
requests defined by this extension.
The information provided to the server includes what action should be
performed, and how long to delay before processing the action in the server.
.LI
User input actions may be diverted to a client before being processed by the
server.
The effect on the server is as if the user had performed no input action.
The user input actions are provided to the client in the form of X events
defined by this extension.
The information provided to the client includes what user input action
occurred and the delay between this user input action and the previous user
input action.
The client may then do anything it wishes with this information.
.LI
User input actions may be copied, with one copy going to the server in the
normal way, and the other copy being sent to a client as described above.
.LE
.SK
.H 1 Functions~In~This~Extension
.H 2 High~Level~Functions
These functions are built on top of the low level functions described later.
.H 3 XTestMovePointer
.DS
int
XTestMovePointer(\fIdisplay\fR, \fIdevice_id\fR, \fIdelay\fR, \fIx\fR, \fIy\fR, \fIcount\fR)
        Display \(**\fIdisplay\fR;
        int \fIdevice_id\fR;
        unsigned long \fIdelay\fR[];
        int \fIx\fR[];
        int \fIy\fR[];
        unsigned int \fIcount\fR;
.DE
.VL 11 "" 1
.LI ~
.LI \fIdisplay\fR
Specifies the connection to the X server.
.LI ~
.LI \fIdevice_id\fR
Specifies which pointer device was supposed to have caused the input action.
This is a provision for future support of multiple (distinguishable) pointer
devices, and should always be set to 0 for now.
.LI ~
.LI \fIdelay\fR
Specifies the time (in milliseconds) to wait before each movement
of the pointer.
.LI ~
.LI \fIx\fR
.LI \fIy\fR
Specifies the x and y coordinates to move the pointer to relative to the
root window for the specified display.
.LI ~
.LI \fIcount\fR
Specifies the number of `delay, x, y' triplets contained in the \fIdelay\fR,
\fIx\fR and \fIy\fR arrays.
.LE
.P
The
.I XTestMovePointer
function creates input actions to be sent to the the server.
The input actions will be accumulated in a request defined by this extension
until the request is full or the XTestFlush function is called.
They will then be sent to the server.
When the input actions are sent to the server, the input actions will cause
the server to think that the pointer was moved to the specified position(s),
with the specified delay before each input action.
.P
The
.I XTestMovePointer
function will return -1 if there is an error, and 0 otherwise.
.SK
.H 3 XTestPressButton
.DS
int
XTestPressButton(\fIdisplay\fR, \fIdevice_id\fR, \fIdelay\fR, \fIbutton_number\fR,
                 \fIbutton_action\fR)
        Display \(**\fIdisplay\fR;
        int \fIdevice_id\fR;
        unsigned long \fIdelay\fR;
        unsigned int \fIbutton_number\fR;
        unsigned int \fIbutton_action\fR;
.DE
.VL 15
.LI \fIdisplay\fR
Specifies the connection to the X server.
.LI \fIdevice_id\fR
Specifies which button device was supposed to have caused the input action.
This is a provision for future support of multiple (distinguishable) button
devices, and should always be set to 0 for now.
.LI \fIdelay\fR
Specifies the time (in milliseconds) to wait before the input action.
.LI \fIbutton_number\fR
Specifies which button is being acted upon.
.LI \fIbutton_action\fR
Specifies the action to be performed (one of 
\fIXTestPRESS\fR, \fIXTestRELEASE\fR, or \fIXTestSTROKE\fR).
.LE
.P
The
.I XTestPressButton
function creates input actions to be sent to the the server.
The input actions will be accumulated in a request defined by this extension
until the request is full or the XTestFlush function is called.
They will then be sent to the server.
When the input actions are sent to the server, the input actions will cause
the server to think that the specified button was moved as specified.
.P
The
.I XTestPressButton
function will return -1 if there is an error, and 0 otherwise.
.SK
.H 3 XTestPressKey
.DS
int
XTestPressKey(\fIdisplay\fR, \fIdevice_id\fR, \fIdelay\fR, \fIkeycode\fR, \fIkey_action\fR)
        Display \(**\fIdisplay\fR;
        int \fIdevice_id\fR;
        unsigned long \fIdelay\fR;
        unsigned int \fIkeycode\fR;
        unsigned int \fIkey_action\fR;
.DE
.VL 12
.LI \fIdisplay\fR
Specifies the connection to the X server.
.LI \fIdevice_id\fR
Specifies which keyboard device was supposed to have caused the input action.
This is a provision for future support of multiple (distinguishable) keyboard
devices, and should always be set to 0 for now.
.LI \fIdelay\fR
Specifies the time (in milliseconds) to wait before the input action.
.LI \fIkeycode\fR
Specifies which keycode is being acted upon.
.LI \fIkey_action\fR
Specifies the action to be performed (one of 
\fIXTestPRESS\fR, \fIXTestRELEASE\fR, or \fIXTestSTROKE\fR).
.LE
.P
The
.I XTestPressKey
function creates input actions to be sent to the the server.
The input actions will be accumulated in a request defined by this extension
until the request is full or the XTestFlush function is called.
They will then be sent to the server.
When the input actions are sent to the server, the input actions will cause
the server to think that the specified key on the keyboard was moved as
specified.
.P
The
.I XTestPressKey
function will return -1 if there is an error, and 0 otherwise.
.SK
.H 3 XTestFlush
.DS
int
XTestFlush(\fIdisplay\fR)
        Display \(**\fIdisplay\fR;
.DE
.VL 9
.LI \fIdisplay\fR
Specifies the connection to the X server.
.LE
.P
The
.I XTestFlush
will send any remaining input actions to the server.
.P
The
.I XTestFlush
function will return -1 if there is an error, and 0 otherwise.
.SK
.H 2 Low~Level~Functions
.H 3 XTestGetInput
.DS
int
XTestGetInput(\fIdisplay\fR, \fIaction_handling\fR)
        Display \(**\fIdisplay\fR;
        int \fIaction_handling\fR;
.DE
.VL 17
.LI \fIdisplay\fR
Specifies the connection to the X server.
.LI \fIaction_handling\fR
Specifies to the server what to do with the user input actions.  (one of
0, \fIXTestPACKED_MOTION\fR or \fIXTestPACKED_ACTIONS\fR; optionally `or'ed
with \fIXTestEXCLUSIVE\fR).
.LE
.P
The
.I XTestGetInput
function tells the server to begin putting information about user input actions
into events to be sent to the client that called this function.  These events
can be read via the Xlib \fIXNextEvent\fR function.
.P
The server assigns an event type of \fIXTestInputActionType\fR to these events
to distinguish them from other events. 
Since the actual value of the event type may vary depending on how many
extensions are included with an X11 implementation,
\fIXTestInputActionType\fR is a variable that will be contained in the Xlib
part of this extension.  It may be referenced as follows:
.DS
extern int XTestInputActionType;
.DE
.P
An \fIaction_handling\fR value of 0 causes the server
to send one user input action in each \fIXTestInputActionType\fR event.
This can sometimes cause performance problems.
.P
An \fIaction_handling\fR value of \fIXTestPACKED_ACTIONS\fR causes the server
to pack as many user input actions as possible into a
\fIXTestInputActionType\fR event.
This is needed if user input actions are happening rapidly (such as
when the user moves the pointer) to keep performance at a reasonable level.
.P
An \fIaction_handling\fR value of \fIXTestPACKED_MOTION\fR causes the server
to pack only user input actions associated with moving the pointer.
This allows the
client to receive button and key motions as they happen without waiting for the
event to fill up, while still keeping performance at a reasonable level.
.P
An \fIaction_handling\fR value with \fIXTestEXCLUSIVE\fR `or'ed in 
causes the server to send user input actions only to the client.
The effect on the server is as if the user had performed no input actions.
.P
An \fIaction_handling\fR value without \fIXTestEXCLUSIVE\fR
causes the server to copy user input actions, sending one copy to the 
client, and handling the other copy normally (as it would if this extension
were not installed).
.P
There are four types of input actions that are passed from the server
to the client.  They are:
.VL 25
.LI key/button~state~change
This type of input action contains the keycode of the key or button that
changed state;
whether the key or button is up or down,
and the time delay between this input action and the previous input action.
.LI pointer~motions
This type of input action contains information about the motion of the
pointer when the pointer has only moved a short distance.
If the pointer has moved a long distance,
the pointer jump input action is used.
.LI pointer~jumps
This type of input action contains information about the motion of the
pointer when the pointer has moved a long distance.
.LI delays
This type of input action is used when the delay between input actions is too
large to be held in the other input actions.
.LE
.P
The
.I XTestGetInput
function will return -1 if there is an error, and 0 otherwise.
.P
An error code of \fIBadAccess\fR means that another client has already
requested that user input actions be sent to it.
.SK
.H 3 XTestStopInput
.DS
int
XTestStopInput(\fIdisplay\fR)
        Display \(**\fIdisplay\fR;
.DE
.VL 9
.LI \fIdisplay\fR
Specifies the connection to the X server.
.LE
.P
The
.I XTestStopInput
function tells the server to stop putting information about user input actions
into events.
The server will process user input actions normally (as it would
if this extension were not in the server).
.P
The
.I XTestStopInput
function will return -1 if there is an error, and 0 otherwise.
.P
An error code of \fIBadAccess\fR means that a request was made to stop input
when input has never been started.
.SK
.H 3 XTestFakeInput
.DS
int
XTestFakeInput(\fIdisplay\fR, \fIaction_list_addr\fR, \fIaction_list_size\fR,
	       \fIack_flag\fR)
        Display \(**\fIdisplay\fR;
	char \(**\fIaction_list_addr\fR;
        int \fIaction_list_size\fR;
        int \fIack_flag\fR;
.DE
.VL 18
.LI \fIdisplay\fR
Specifies the connection to the X server.
.LI \fIaction_list_addr\fR
Specifies the address of an list of input actions to be sent to the server.
.LI \fIaction_list_size\fR
Specifies the size (in bytes) of the list of input actions.
It may be no larger than \fIXTestMAX_ACTION_LIST_SIZE\fR bytes.
.LI \fIack_flag\fR
Specifies whether the server needs to send an event to indicate that its
input action buffer is empty (one of
\fIXTestFAKE_ACK_NOT_NEEDED\fR or \fIXTestFAKE_ACK_REQUEST\fR).
.LE
.P
The
.I XTestFakeInput
function tells the server to take the specified user input actions and process
them as if the user had physically performed them.  
.P
The server can only accept a limited number of input actions at one
time.  This limit can be determined by the \fIXTestQueryInputSize\fR function
in this extension.
.P
The client should set \fIack_flag\fR to \fIXTestFAKE_ACK_NOT_NEEDED\fR
on calls to \fIXTestFakeInput\fR that do not reach this limit.
.P
The client should set \fIack_flag\fR to \fIXTestFAKE_ACK_REQUEST\fR
on the call to \fIXTestFakeInput\fR that reaches this limit.
.P
When the server sees an \fIack_flag\fR value of \fIXTestFAKE_ACK_REQUEST\fR
it finishes processing its input action buffer, then sends an event with
type \fIXTestFakeAckType\fR to the client.
When the client reads this event, it knows that it is safe to resume
sending input actions to the server.
.P
Since the actual value of the event type may vary depending on how many
extensions are included with an X11 implementation,
\fIXTestFakeAckType\fR is a variable that is contained in the Xlib part of
this extension.  It may be referenced as follows:
.DS
extern int XTestFakeAckType;
.DE
.P
There are four types of input actions that are passed from the client
to the server.  They are:
.VL 25
.LI key/button~state~change
This type of input action contains the keycode of the key or button that
is to change state;
whether the key or button is to be up or down,
and the time to delay before changing the state of the key or button.
.LI pointer~motions
This type of input action contains information about the motion of the
pointer when the pointer is to be moved a short distance,
and the time to delay before moving the pointer.
If the pointer is to be moved a long distance,
the pointer jump input action must be used.
.LI pointer~jumps
This type of input action contains information about the motion of the
pointer when the pointer is to be moved a long distance,
and the time to delay before moving the pointer.
.LI delays
This type of input action is used when the delay between input actions is too
large to be held in the other input actions.
.LE
.P
The
.I XTestFakeInput
function will return -1 if there is an error, and 0 otherwise.
.P
An error code of \fIBadAccess\fR means that another client has already
sent user input actions to the server, and the server has not finished
processing the user input actions.
.SK
.H 3 XTestQueryInputSize
.DS
int
XTestQueryInputSize(\fIdisplay\fR, \fIsize_return\fR)
        Display \(**\fIdisplay\fR;
        unsigned long \(**\fIsize_return\fR;
.DE
.VL 13
.LI \fIdisplay\fR
Specifies the connection to the X server.
.LI \fIsize_return\fR
Returns the number of input actions that the server's input action buffer can
hold.
.LE
.P
The
.I XTestQueryInputSize
function asks the server to return the number of input actions that it can hold
in its input action buffer in the unsigned long pointed to by \fIsize_return\fR.
.P
The
.I XTestQueryInputSize
function will return -1 if there is an error, and 0 otherwise.
.SK
.H 3 XTestReset
.DS
int
XTestReset(\fIdisplay\fR)
        Display \(**\fIdisplay\fR;
.DE
.VL 9
.LI \fIdisplay\fR
Specifies the connection to the X server.
.LE
.P
The
.I XTestReset
function tells the server to set everything having to do with this extension
back to its initial state.  After this call the server will act as if this
extension were not installed until one of the extension functions is called by
a client.  This function is not normally needed, but is included in case a
client wishes to clean up the server state, such as after a serious error.
.P
The
.I XTestReset
function will return -1 if there is an error, and 0 otherwise.
.SK
.H 1 `xtestext1.h'~File~Listing
.DS
.so xtestext1.h
.DE
.TC 1 1 4
