# RPM spec file for Beep

%{?_with_alsa:  %define alsa 1}
%{!?_with_alsa: %define alsa 0}
%{?_with_mp3:   %define mp3  1}
%{!?_with_mp3:  %define mp3  0}

Summary:	Beep Media Player
Name:		bmp
Version:	0.9.6.1
Release:	2
Copyright:	GPL
Group:		Applications/Multimedia
Vendor:		Beep Development Team
Url:		http://beepmp.sourceforge.net
Source:		%{name}-%{version}.tar.gz
BuildRoot:	%{_tmppath}/%{name}-%{version}-root

Requires:	gtk2 >= 2.0
BuildRequires:  gtk2-devel >= 2.0

%description 
Beep Media Player(BMP) is a GTK2 port of the popular X Multimedia
System(XMMS) and more.

Build options:
--with: alsa mp3

%package	devel
Summary:	Beep - Static libraries and header files.
Group:		Applications/Multimedia
Requires:	%{name} = %{version}

%description	devel
Static libraries and header files required for compiling BMP plugins.

%if %{mp3}
%package	mp3
Summary:	Beep - MP3 output plugin
Group:		Applications/Multimedia
Requires:	%{name} >= %{version}

%description	mp3
MP3 input plugin for Beep.
%endif

%if %{alsa}
%package	alsa
Summary:	Beep - ALSA output plugin
Group:		Applications/Multimedia
Requires:	%{name} >= %{version}
Requires:	alsa-lib >= 0.9.0
BuildRequires:	alsa-lib-devel >= 0.9.0

%description	alsa
Output plugin for Beep to use with the Advanced Linux Sound
Architecture (ALSA).
%endif

%prep
%setup -q

%build
%configure \
	--disable-opengl \
	%{!?_with_alsa:--disable-alsa}
make

%install
rm -rf ${RPM_BUILD_ROOT}
make install DESTDIR=${RPM_BUILD_ROOT}

%post	-p /sbin/ldconfig
%postun -p /sbin/ldconfig

%clean
rm -rf ${RPM_BUILD_ROOT};

%files
%defattr(-, root, root)
%doc AUTHORS COPYING ChangeLog INSTALL NEWS README
%{_bindir}/beep-media-player
%{_datadir}/bmp/*
%{_datadir}/applications/beep.desktop
%{_libdir}/libbeep.so.*
%{_libdir}/bmp/Input/libwav.so
%{_libdir}/bmp/Input/libcdaudio.so
%{_libdir}/bmp/Input/libvorbis.so
%{_libdir}/bmp/Output/libOSS.so
%{_libdir}/bmp/Output/libesdout.so
%{_libdir}/bmp/Visualization/libbscope*
#%{_libdir}/bmp/Effect/*
%{_mandir}/*
%{_datadir}/locale/*/LC_MESSAGES/bmp.mo
#%{_datadir}/pixmaps/beep*.xpm

%files devel
%defattr(-, root, root)
%{_bindir}/beep-config
%{_libdir}/pkgconfig/beep.pc
%{_libdir}/lib*.so
%{_libdir}/lib*.a
%{_libdir}/lib*.la
%{_includedir}/*
%{_datadir}/aclocal/beep.m4

%if %{alsa}
%files alsa
%defattr(-, root, root)
%{_libdir}/bmp/Output/libALSA*
%endif

%if %{mp3}
%files mp3
%defattr(-, root, root)
%{_libdir}/bmp/Input/libmpg123*
%endif


%changelog
* Wed Dec 24 2003 Chong Kai Xiong <descender@phreaker.net> 0.9.6-2
- first fully usable version

* Tue Nov 29 2003 Chong Kai Xiong <descender@phreaker.net> 0.9.6-1
- added support for --with switches

* Tue Nov 11 2003 Chong Kai Xiong <descender@phreaker.net> 1.0.0pre6
- initial build
