/***********************************************************************

Original Developed by:

	2002/10/25 start
	Copyright (C) 2002 I-O DATA DEVICE,INC.

Abstract:

	CFXGA driver for ZAURUS(Linux)

Revision History:

	2002/11/25	Ver1.00	
	2003/01/08	Ver1.01	Support SWIVEL_180 and SWIVEL_270.
	2003/01/14	Ver1.01	Add BLTS_TIMEOUT define.

***********************************************************************/

#ifndef _MEMORY_CS_H
#define	_MEMORY_CS_H
//----------------------------------------------------------------------
//include
//----------------------------------------------------------------------
#include <linux/ioctl.h>

//----------------------------------------------------------------------
//driver version	[100 -> 1.00]
//----------------------------------------------------------------------
#define	DRVIER_VERSION	101

//----------------------------------------------------------------------
//define
//----------------------------------------------------------------------
#define	RESO_256		0			//1: 256 color support 
#define	MEM_SPEED		250			//
#define	BUSY_TIMEOUT	0x1000000	//
#define	FIFO_TIMEOUT	0x1000		//
#define	BLTS_TIMEOUT	0x100		//(Ver1.01)

//----------------------------------------------------------------------
//ioctl commmand No.
//----------------------------------------------------------------------
#define	CFXGA_MAGIC_NO		'c'
#define	CFXGA_GET_STATUS	_IOR(CFXGA_MAGIC_NO, 1, struct status_t)
#define	CFXGA_GET_RESONUM	_IOR(CFXGA_MAGIC_NO, 2, unsigned int)
#define	CFXGA_GET_RESOINFO	_IOR(CFXGA_MAGIC_NO, 3, struct reso_info_t)
#define	CFXGA_SET_RESO		_IOW(CFXGA_MAGIC_NO, 4, unsigned int)
#define	CFXGA_COPY_FB		_IOW(CFXGA_MAGIC_NO, 5, struct copy_info_t)
#define	CFXGA_COPY_FB2		_IOW(CFXGA_MAGIC_NO, 6, struct copy2_info_t)
#define	CFXGA_CLEAR_SCREEN	 _IO(CFXGA_MAGIC_NO, 7)
#define	CFXGA_SCREEN_OFF	 _IO(CFXGA_MAGIC_NO, 8)

//----------------------------------------------------------------------
//structure
//----------------------------------------------------------------------
typedef struct reso_t {
	int		cx;		//resolution x
	int		cy;		//resolution y
	u_int	ref;	//refresh rate (Hz)
	u_int	bpp;	//color depth (bits/pixel)
	u_int	dclk;	//dot clock (kHz)
	u_int	flags;	//resolution flags
} reso_t;
//resolution flags
#define	MODE_VGA		0x00000001
#define	MODE_NTSC		0x00000002
#define	MODE_PAL		0x00000004
#define	OUT_VGA			0x00000010
#define	OUT_COMPOSITE	0x00000020
#define	OUT_SVIDEO		0x00000040

typedef struct status_t {
	int		version;	//[OUT]	driver version (100 = 1.00)
	int		flags;		//[OUT]	status flags
} status_t;
//status flags
#define	CFXGA_INSTALLED	0x00000001
#define	CFXGA_BUSY		0x00000002		//reserved
#define	CFXGA_SCREEN_ON	0x00000004

typedef struct reso_info_t {
	u_int	mode_no;	//[IN]	mode no. 
	reso_t	reso;		//[OUT]	resolution infomation
} reso_info_t;

typedef struct copy_info_t {
	int		x;			//[IN]	destnation x org
	int		y;			//[IN]	destnation y org
	int		w;			//[IN]	width
	int		h;			//[IN]	height
	int		bpp;		//[IN]	src bpp
	int		stride;		//[IN]	src screen stride
	void	*adr;		//[IN]	src data start address
} copy_info_t;

typedef struct copy2_info_t {
	int		x;			//[IN]	destnation x org
	int		y;			//[IN]	destnation y org
	int		w;			//[IN]	width
	int		h;			//[IN]	height
	int		bpp;		//[IN]	src bpp
	int		stride;		//[IN]	src screen stride
	u_long	phys_adr;	//[IN]	src screen physical address
	u_long	size;		//[IN]	src screen physical address size (bytes)
	u_long	offset;		//[IN]	src date offset
	u_int	swivel;		//[IN]	swivel level
} copy2_info_t;
//swivel level
#define	SWIVEL_0	0	//NOMAL
#define	SWIVEL_90	1	//LEFT  90 degree
#define	SWIVEL_180	2	//LEFT 180 degree
#define	SWIVEL_270	3	//LEFT 270 degree

#define	MAX_REG	11
typedef struct DefReso {
	reso_t	reso;
	u_short	reg[MAX_REG * 2];
} DefReso, *pDefReso;


//----------------------------------------------------------------------
//resolution data tatble
//----------------------------------------------------------------------
static u_short common_reg[] = 
{
		//Clock
		0x10,0x0002,
		0x14,0x0000,
		0x1c,0x0002,
		//Mem Config
		0x20,0x0380,
		0x2a,0x0100,
		//CRT,TV
		0x62,0x0000,
		0x64,0x0000,
		0x68,0x0000,
		0x6a,0x0000,
		//CRT,TV Cursor
		0x80,0x0000,
		0x82,0x0259,
		0x84,0x0190,
		0x86,0x0000,
		0x88,0x0000,
		0x8a,0x3f1f,
		0x8c,0x001f,
		0x8e,0x0000,
		//other
		0x01f0,0x0210,
		0x01f4,0x0000,
		//end flag
		0xffff,0xffff,
};

static DefReso crt_640x480x72x16 =
{
	{640,480,72,16,31500, MODE_VGA | OUT_VGA},
	{
		//GPIO
		0x04,0x0007,
		0x08,0x1ffe,
		//Clock
		0x18,0x0000,
		0x1e,0x0002,
		//CRT,TV
		0x50,0x004f,
		0x52,0x0217,
		0x54,0x0004,
		0x56,0x01df,
		0x58,0x0827,
		0x5a,0x1202,
		//end flag
		0xffff,0xffff,
    },
};

static DefReso crt_640x480x85x16 =
{
	{640,480,85,16,36000, MODE_VGA | OUT_VGA},
	{
		//GPIO
		0x04,0x0007,
		0x08,0x1fff,
		//Clock
		0x18,0x0011,
		0x1e,0x0002,
		//CRT,TV
		0x50,0x004f,
		0x52,0x0617,
		0x54,0x0006,
		0x56,0x01df,
		0x58,0x001c,
		0x5a,0x1202,
		//end flag
		0xffff,0xffff
	},
};

static DefReso crt_848x480x60x16 =
{
	{848,480,60,16,33333, MODE_VGA | OUT_VGA},
	{
		//GPIO
		0x04,0x0007,
		0x08,0x1ffc,
		//Clock
		0x18,0x00a3,
		0x1e,0x0002,
		//CRT,TV
		0x50,0x0069,
		0x52,0x011b,
		0x54,0x008d,
		0x56,0x01df,
		0x58,0x05a4,
		0x5a,0x1287,
		//end flag
		0xffff,0xffff
	},
};

#if 0
static DefReso crt_800x600x60x16 =
{
	{800,640,60,16,40000, MODE_VGA | OUT_VGA},
	{
		//GPIO
		0x04,0x0007,
		0x08,0x1ffd,
		//Clock
		0x18,0x0000,
		0x1e,0x0002,
		//CRT,TV
		0x50,0x0063,
		0x52,0x041f,
		0x54,0x008f,
		0x56,0x027f,
		0x58,0x001b,
		0x5a,0x1283,
		//end flag
		0xffff,0xffff
	},
};
#else
static DefReso crt_800x600x60x16 =
{
	{800,600,60,16,40000, MODE_VGA | OUT_VGA},
	{
		//GPIO
		0x04,0x0007,
		0x08,0x1ffd,
		//Clock
		0x18,0x0000,
		0x1e,0x0002,
		//CRT,TV
		0x50,0x0063,
		0x52,0x041f,
		0x54,0x008f,
		0x56,0x0257,
		0x58,0x001b,
		0x5a,0x1283,
		//end flag
		0xffff,0xffff
	},
};
#endif

static DefReso ntsc_comp_640x480x16 =
{
	{640,480,00,16,17734, MODE_NTSC | OUT_COMPOSITE},
	{
		//GPIO
		0x04,0x0007,
		0x08,0x1fff,
		//Clock
		0x18,0x0082,
		0x1e,0x0001,
		//CRT,TV
		0x50,0x004f,
		0x52,0x0921,
		0x54,0x0000,
		0x56,0x01df,
		0x58,0x0015,
		0x5a,0x0000,
		//end flag
		0xffff,0xffff
	},
};

static DefReso ntsc_comp_696x436x16 =
{
	{696,436,00,16,17734, MODE_NTSC | OUT_COMPOSITE},
	{
		//GPIO
		0x04,0x0007,
		0x08,0x1fff,
		//Clock
		0x18,0x0082,
		0x1e,0x0001,
		//CRT,TV
		0x50,0x0056,
		0x52,0x041a,
		0x54,0x0000,
		0x56,0x01b3,
		0x58,0x0c2b,
		0x5a,0x0000,
		//end flag
		0xffff,0xffff
	},
};

static DefReso ntsc_svideo_640x480x16 =
{
	{640,480,00,16,17734, MODE_NTSC | OUT_SVIDEO},
	{
		//GPIO
		0x04,0x0007,
		0x08,0x1fff,
		//Clock
		0x18,0x0082,
		0x1e,0x0001,
		//CRT,TV
		0x50,0x004f,
		0x52,0x0921,
		0x54,0x0000,
		0x56,0x01df,
		0x58,0x0015,
		0x5a,0x0200,
		//end flag
		0xffff,0xffff
	},
};

static DefReso ntsc_svideo_696x436x16 =
{
	{696,436,00,16,17734, MODE_NTSC | OUT_SVIDEO},
	{
		//GPIO
		0x04,0x0007,
		0x08,0x1fff,
		//Clock
		0x18,0x0082,
		0x1e,0x0001,
		//CRT,TV
		0x50,0x0056,
		0x52,0x041a,
		0x54,0x0000,
		0x56,0x01b3,
		0x58,0x0c2b,
		0x5a,0x0200,
		//end flag
		0xffff,0xffff
	},
};

static DefReso pal_comp_640x480x16 =
{
	{640,480,00,16,17734, MODE_PAL | OUT_COMPOSITE},
	{
		//GPIO
		0x04,0x0007,
		0x08,0x1fff,
		//Clock
		0x18,0x0080,
		0x1e,0x0001,
		//CRT,TV
		0x50,0x004f,
		0x52,0x153d,
		0x54,0x0000,
		0x56,0x01df,
		0x58,0x1747,
		0x5a,0x0100,
		//end flag
		0xffff,0xffff
	},
};

static DefReso pal_comp_800x572x16 =
{
	{800,572,00,16,17734, MODE_PAL | OUT_COMPOSITE},
	{
		//GPIO
		0x04,0x0007,
		0x08,0x1fff,
		//Clock
		0x18,0x0080,
		0x1e,0x0001,
		//CRT,TV
		0x50,0x0063,
		0x52,0x0929,
		0x54,0x0000,
		0x56,0x023b,
		0x58,0x0010,
		0x5a,0x0100,
		//end flag
		0xffff,0xffff
	},
};

static DefReso pal_svideo_640x480x16 =
{
	{640,480,00,16,17734, MODE_PAL | OUT_SVIDEO},
	{
		//GPIO
		0x04,0x0007,
		0x08,0x1fff,
		//Clock
		0x18,0x0080,
		0x1e,0x0001,
		//CRT,TV
		0x50,0x004f,
		0x52,0x153d,
		0x54,0x0000,
		0x56,0x01df,
		0x58,0x1747,
		0x5a,0x0300,
		//end flag
		0xffff,0xffff
	},
};

static DefReso pal_svideo_800x572x16 =
{
	{800,572,00,16,17734, MODE_PAL | OUT_SVIDEO},
	{
		//GPIO
		0x04,0x0007,
		0x08,0x1fff,
		//Clock
		0x18,0x0080,
		0x1e,0x0001,
		//CRT,TV
		0x50,0x0063,
		0x52,0x0929,
		0x54,0x0000,
		0x56,0x023b,
		0x58,0x0010,
		0x5a,0x0300,
		//end flag
		0xffff,0xffff
	},
};


#if RESO_256

static DefReso crt_640x480x72x8 =
{
	{640,480,72,8,31500, MODE_VGA | OUT_VGA},
	{
		//GPIO
		0x04,0x0007,
		0x08,0x1ffe,
		//Clock
		0x18,0x0000,
		0x1e,0x0002,
		//CRT,TV
		0x50,0x004f,
		0x52,0x0217,
		0x54,0x0004,
		0x56,0x01df,
		0x58,0x0827,
		0x5a,0x1202,
		//end flag
		0xffff,0xffff,
    },
};

static DefReso crt_640x480x85x8 =
{
	{640,480,85,8,36000, MODE_VGA | OUT_VGA},
	{
		//GPIO
		0x04,0x0007,
		0x08,0x1fff,
		//Clock
		0x18,0x0011,
		0x1e,0x0002,
		//CRT,TV
		0x50,0x004f,
		0x52,0x0617,
		0x54,0x0006,
		0x56,0x01df,
		0x58,0x001c,
		0x5a,0x1202,
		//end flag
		0xffff,0xffff
	},
};

static DefReso crt_848x480x60x8 =
{
	{848,480,60,8,33333, MODE_VGA | OUT_VGA},
	{
		//GPIO
		0x04,0x0007,
		0x08,0x1ffc,
		//Clock
		0x18,0x00a3,
		0x1e,0x0002,
		//CRT,TV
		0x50,0x0069,
		0x52,0x011b,
		0x54,0x008d,
		0x56,0x01df,
		0x58,0x05a4,
		0x5a,0x1287,
		//end flag
		0xffff,0xffff
	},
};

static DefReso crt_800x600x60x8 =
{
	{800,600,60,8,40000, MODE_VGA | OUT_VGA},
	{
		//GPIO
		0x04,0x0007,
		0x08,0x1ffd,
		//Clock
		0x18,0x0000,
		0x1e,0x0002,
		//CRT,TV
		0x50,0x0063,
		0x52,0x041f,
		0x54,0x008f,
		0x56,0x0257,
		0x58,0x001b,
		0x5a,0x1283,
		//end flag
		0xffff,0xffff
	},
};

static DefReso crt_800x600x72x8 =
{
	{800,600,72,8,40000, MODE_VGA | OUT_VGA},
	{
		//GPIO
		0x04,0x0007,
		0x08,0x1fff,
		//Clock
		0x18,0x0003,
		0x1e,0x0002,
		//CRT,TV
		0x50,0x0063,
		0x52,0x061d,
		0x54,0x008e,
		0x56,0x0257,
		0x58,0x1d41,
		0x5a,0x1285,
		//end flag
		0xffff,0xffff
	},
};

static DefReso crt_1024x768x60x8 =
{
	{1024,768,60,8,65000, MODE_VGA | OUT_VGA},
	{
		//GPIO
		0x04,0x0007,
		0x08,0x1ffc,
		//Clock
		0x18,0x0000,
		0x1e,0x0001,
		//CRT,TV
		0x50,0x007f,
		0x52,0x0227,
		0x54,0x008f,
		0x56,0x02ff,
		0x58,0x0027,
		0x5a,0x1285,
		//end flag
		0xffff,0xffff
	},
};

static DefReso ntsc_comp_640x480x8 =
{
	{640,480,00,8,17734, MODE_NTSC | OUT_COMPOSITE},
	{
		//GPIO
		0x04,0x0007,
		0x08,0x1fff,
		//Clock
		0x18,0x0082,
		0x1e,0x0001,
		//CRT,TV
		0x50,0x004f,
		0x52,0x0921,
		0x54,0x0000,
		0x56,0x01df,
		0x58,0x0015,
		0x5a,0x0000,
		//end flag
		0xffff,0xffff
	},
};

static DefReso ntsc_comp_696x436x8 =
{
	{696,436,00,8,17734, MODE_NTSC | OUT_COMPOSITE},
	{
		//GPIO
		0x04,0x0007,
		0x08,0x1fff,
		//Clock
		0x18,0x0082,
		0x1e,0x0001,
		//CRT,TV
		0x50,0x0056,
		0x52,0x041a,
		0x54,0x0000,
		0x56,0x01b3,
		0x58,0x0c2b,
		0x5a,0x0000,
		//end flag
		0xffff,0xffff
	},
};

static DefReso ntsc_svideo_640x480x8 =
{
	{640,480,00,8,17734, MODE_NTSC | OUT_SVIDEO},
	{
		//GPIO
		0x04,0x0007,
		0x08,0x1fff,
		//Clock
		0x18,0x0082,
		0x1e,0x0001,
		//CRT,TV
		0x50,0x004f,
		0x52,0x0921,
		0x54,0x0000,
		0x56,0x01df,
		0x58,0x0015,
		0x5a,0x0200,
		//end flag
		0xffff,0xffff
	},
};

static DefReso ntsc_svideo_696x436x8 =
{
	{696,436,00,8,17734, MODE_NTSC | OUT_SVIDEO},
	{
		//GPIO
		0x04,0x0007,
		0x08,0x1fff,
		//Clock
		0x18,0x0082,
		0x1e,0x0001,
		//CRT,TV
		0x50,0x0056,
		0x52,0x041a,
		0x54,0x0000,
		0x56,0x01b3,
		0x58,0x0c2b,
		0x5a,0x0200,
		//end flag
		0xffff,0xffff
	},
};

static DefReso pal_comp_640x480x8 =
{
	{640,480,00,8,17734, MODE_PAL | OUT_COMPOSITE},
	{
		//GPIO
		0x04,0x0007,
		0x08,0x1fff,
		//Clock
		0x18,0x0080,
		0x1e,0x0001,
		//CRT,TV
		0x50,0x004f,
		0x52,0x153d,
		0x54,0x0000,
		0x56,0x01df,
		0x58,0x1747,
		0x5a,0x0100,
		//end flag
		0xffff,0xffff
	},
};

static DefReso pal_comp_800x572x8 =
{
	{800,572,00,8,17734, MODE_PAL | OUT_COMPOSITE},
	{
		//GPIO
		0x04,0x0007,
		0x08,0x1fff,
		//Clock
		0x18,0x0080,
		0x1e,0x0001,
		//CRT,TV
		0x50,0x0063,
		0x52,0x0929,
		0x54,0x0000,
		0x56,0x023b,
		0x58,0x0010,
		0x5a,0x0100,
		//end flag
		0xffff,0xffff
	},
};

static DefReso pal_svideo_640x480x8 =
{
	{640,480,00,8,17734, MODE_PAL | OUT_SVIDEO},
	{
		//GPIO
		0x04,0x0007,
		0x08,0x1fff,
		//Clock
		0x18,0x0080,
		0x1e,0x0001,
		//CRT,TV
		0x50,0x004f,
		0x52,0x153d,
		0x54,0x0000,
		0x56,0x01df,
		0x58,0x1747,
		0x5a,0x0300,
		//end flag
		0xffff,0xffff
	},
};

static DefReso pal_svideo_800x572x8 =
{
	{800,572,00,8,17734, MODE_PAL | OUT_SVIDEO},
	{
		//GPIO
		0x04,0x0007,
		0x08,0x1fff,
		//Clock
		0x18,0x0080,
		0x1e,0x0001,
		//CRT,TV
		0x50,0x0063,
		0x52,0x0929,
		0x54,0x0000,
		0x56,0x023b,
		0x58,0x0010,
		0x5a,0x0300,
		//end flag
		0xffff,0xffff
	},
};

#endif

//-------------------------------------------------------------
//resolution table
//-------------------------------------------------------------
static pDefReso	reso_tbl[] = 
{
	&crt_640x480x72x16,
	&crt_640x480x85x16,
	&crt_848x480x60x16,
	&crt_800x600x60x16,
	&ntsc_comp_640x480x16,
	&ntsc_comp_696x436x16,
	&ntsc_svideo_640x480x16,
	&ntsc_svideo_696x436x16,
	&pal_comp_640x480x16,
	&pal_comp_800x572x16,
	&pal_svideo_640x480x16,
	&pal_svideo_800x572x16,
#if RESO_256
	&crt_640x480x72x8,
	&crt_640x480x85x8,
	&crt_848x480x60x8,
	&crt_800x600x60x8,
	&crt_800x600x72x8,
	&crt_1024x768x60x8,
	&ntsc_comp_640x480x8,
	&ntsc_comp_696x436x8,
	&ntsc_svideo_640x480x8,
	&ntsc_svideo_696x436x8,
	&pal_comp_640x480x8,
	&pal_comp_800x572x8,
	&pal_svideo_640x480x8,
	&pal_svideo_800x572x8,
#endif
};

#define	CFXGA_RESONUM	(sizeof(reso_tbl) / sizeof(pDefReso))



#endif	//_MEMORY_CS_H
