/*
 * gdict Dictionary for UNIX
 * Copyright (C) 2003 Alexander Zapjagaev <frustum@frustum.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "transwindow.h"

static GtkWidget *window = NULL;
static GtkWidget *label_word = NULL;
static GtkWidget *label_trans = NULL;

/*  
 */
static void trans_window_destroy_signal(GtkWidget *widget,GtkWidget **win) {
	gtk_widget_destroy(widget);
	window = NULL;
	label_word = NULL;
	label_trans = NULL;
}

/*
 */
static int trans_window_press_event(GtkWidget *widget,GdkEventKey *event,GtkWidget *window) {
	if(event->keyval == GDK_Escape) {
		trans_window_destroy();
		return 1;
	}
	return 0;
}

/*    
 */
void trans_window_create(char *word,char *trans) {
	GtkWidget *vbox;
	GtkWidget *separator;
	
	char *word_utf8 = g_convert(word,-1,"UTF-8",LOCALE,NULL,NULL,NULL);
	char *trans_utf8 = g_convert(trans,-1,"UTF-8",LOCALE,NULL,NULL,NULL);
	
	if(window) {
		/*  */
		gtk_label_set_text(GTK_LABEL(label_word),word_utf8);
		gtk_label_set_text(GTK_LABEL(label_trans),trans_utf8);
		
	} else {
		/* window */
		window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
		gtk_window_set_title(GTK_WINDOW(window),_("Translation"));
		gtk_window_set_policy(GTK_WINDOW(window),0,0,0);
		gtk_signal_connect(GTK_OBJECT(window),"destroy",
			GTK_SIGNAL_FUNC(trans_window_destroy_signal),&window);
		
		gtk_signal_connect(GTK_OBJECT(window),"key_press_event",
			GTK_SIGNAL_FUNC(trans_window_press_event),window);
		
		/* vbox */
		vbox = gtk_vbox_new(FALSE,0);
		gtk_container_set_border_width(GTK_CONTAINER(window),10);
		gtk_container_add(GTK_CONTAINER(window),vbox);
		
		/* word */
		label_word = gtk_label_new(word_utf8);
		gtk_label_set_selectable(GTK_LABEL(label_word),TRUE);
		gtk_box_pack_start(GTK_BOX(vbox),label_word,TRUE,TRUE,0);
		
		/* separator */
		separator = gtk_hseparator_new();
		gtk_box_pack_start(GTK_BOX(vbox),separator,FALSE,TRUE,0);
		
		/* trans */
		label_trans = gtk_label_new(trans_utf8);
		gtk_label_set_selectable(GTK_LABEL(label_trans),TRUE);
		gtk_box_pack_start(GTK_BOX(vbox),label_trans,TRUE,TRUE,0);
		
		gtk_widget_show_all(window);
	}
	
	g_free(word_utf8);
	g_free(trans_utf8);
}

/*
 */
void trans_window_change(char *word,char *trans) {
	if(window) {
		char *word_utf8 = g_convert(word,-1,"UTF-8",LOCALE,NULL,NULL,NULL);
		char *trans_utf8 = g_convert(trans,-1,"UTF-8",LOCALE,NULL,NULL,NULL);
		
		gtk_label_set_text(GTK_LABEL(label_word),word_utf8);
		gtk_label_set_text(GTK_LABEL(label_trans),trans_utf8);
		
		g_free(word_utf8);
		g_free(trans_utf8);
	}
}

/*
 */
void trans_window_destroy() {
	if(window) {
		gtk_widget_destroy(window);
		window = NULL;
		label_word = NULL;
		label_trans = NULL;
	}
}
