/******************************************************************************
//               INTEL CORPORATION PROPRIETARY INFORMATION
//  This software is supplied under the terms of a license agreement or
//  nondisclosure agreement with Intel Corporation and may not be copied
//  or disclosed except in accordance with the terms of that agreement.
//        Copyright (c) 2001 Intel Corporation. All Rights Reserved.
//
//  VSS:
//		$Workfile: oscr.c $
//      $Revision: 1 $
//      $Date: 05-02-28 16:03 $
//      $Archive: /ipp/branch/5_0/beta/install/bulverde/primitive/arm_linux/sample/OSCRTimer/oscr.c $
//
//  Description:
//      OSCR timer interface
//
******************************************************************************/

/* Standard definitions */
#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/mman.h>
#include <time.h>
#include <errno.h>

#define GET_OSCR 21
static  int fd=0;          /* file descriptor */
static  int refer=0;       /* fd reference counter */

/* OSCR interface definitions */
#include "oscr.h"

/* Booleans */
#define		TRUE 1
#define		FALSE 0

/* Symbolic name of the linux device that is mapped to the OSCR register */
//#ifdef COTULLA
static char  *oscrdev="/dev/ixs_oscr"; 
//#endif

//#ifdef SA1110  
//static char  *oscrdev="/dev/satimer"; 
//#endif


/***************************************************************************
// Name:             ixs_open_OSCR
// Description:      open the linux device mapped to the oscr timer 
//
// Input Arguments:
//
// Output Arguments:
// Returns:        TRUE  : open successfully
//                 FALSE : open failed
//
*****************************************************************************/
int ixs_open_OSCR()
{
  errno = 0;
  if (!fd && (fd=open(oscrdev,O_RDWR)) < 0 )
  {
     perror ("OSCR error: unable to open device\n");
     fd = 0;
     return FALSE;
  }
  refer ++;
  return TRUE;
}

/***************************************************************************
// Name:             ixs_get_OSCR_val
// Description:      read the current value of the oscr 
//
// Input Arguments:
//        pticks     pointer to buffer that will be used to save the
//                   oscr counter
//
// Output Arguments:
// Returns:        TRUE  : operate successfully
//                 FALSE : operate failed.
//
*****************************************************************************/
int ixs_get_OSCR_val(unsigned long *pticks)
{
	if (!fd)
	{
		printf ("OSCR error: unable to access device\n");
		return FALSE;
	}
	if ( ioctl(fd,GET_OSCR,pticks) < 0 )
	{
		perror("OSCR error: ioctl GET_OSCR failed\n");
		return FALSE;
	}
	return TRUE;
}

/***************************************************************************
// Name:             ixs_close_OSCR
// Description:      close the linux device mapped to the oscr timer 
//
// Input Arguments:
//
// Output Arguments:
// Returns:
//
*****************************************************************************/
int ixs_close_OSCR()
{
  if ( fd ) {
    if ( --refer == 0 )
	{
      close(fd); 
      fd = 0;
    }
    return TRUE;
  }
  return FALSE;
}
