
// CHANGED 2004-08-06 Lutz Rogowski
#include <qlabel.h>
#include <qvbox.h>
#include <qheader.h>
#include <qtimer.h>
#include <qlayout.h>
#include <kdialog.h>
#include <kiconloader.h>
#include <kapplication.h>

#ifndef DESKTOP_VERSION
#include <qpe/qpeapplication.h>
#endif
#include "defines.h"
#include "mainwindow.h"
#include <KDGanttMinimizeSplitter.h>


#include <kabc/stdaddressbook.h>

MainWindow::MainWindow( QWidget *parent, const char *name, WFlags flags )
    : QMainWindow( parent, name ) //, flags )
{
    setCaption( tr( "KOpieMail/Pi" ) );
    setToolBarsMovable( false ); 
    //KABC::StdAddressBook::self();
    toolBar = new QToolBar( this );
    menuBar = new QPEMenuBar( toolBar );
    mailMenu = new QPopupMenu( menuBar );
    menuBar->insertItem( tr( "Mail" ), mailMenu );
    settingsMenu = new QPopupMenu( menuBar );
    menuBar->insertItem( tr( "Settings" ), settingsMenu );

    addToolBar( toolBar );
    toolBar->setHorizontalStretchable( true );

    QAction* getMail = new QAction( tr( "Get new mail" ), SmallIcon("add"),
                               0, 0, this );
    getMail->addTo( toolBar );
    getMail->addTo( mailMenu );
    connect(getMail, SIGNAL( activated() ),
            SLOT( slotGetMail() ) );

    composeMail = new QAction( tr( "Compose new mail" ), SmallIcon("composemail"),
                               0, 0, this );
    composeMail->addTo( toolBar );
    composeMail->addTo( mailMenu );

    sendQueued = new QAction( tr( "Send queued mails" ), SmallIcon("sendqueued") ,
                              0, 0, this );
    sendQueued->addTo( toolBar );
    sendQueued->addTo( mailMenu );

    /*
    syncFolders = new QAction( tr( "Sync mailfolders" ), ICON_SYNC,
                               0, 0, this );
    syncFolders->addTo( toolBar );
    syncFolders->addTo( mailMenu );
    */

    showFolders = new QAction( tr( "Show/Hide folders" ), SmallIcon("showfolders") ,
                               0, 0, this, 0, true );
    showFolders->addTo( toolBar );
    showFolders->addTo( mailMenu );
    showFolders->setOn( true );
    connect(showFolders, SIGNAL( toggled(bool) ),
            SLOT( slotShowFolders(bool) ) );

    /*
      searchMails = new QAction( tr( "Search mails" ), SmallIcon("find") ),
                               0, 0, this );
    searchMails->addTo( toolBar );
    searchMails->addTo( mailMenu );
    */

    deleteMails = new QAction(tr("Delete Mail"),  SmallIcon("trash"), 0, 0, this);
    deleteMails->addTo( toolBar );
    deleteMails->addTo( mailMenu );
    connect( deleteMails, SIGNAL( activated() ),
             SLOT( slotDeleteMail() ) );

    editSettings = new QAction( tr( "Edit settings" ), SmallIcon("SettingsIcon")  ,
                                0, 0, this );
    editSettings->addTo( settingsMenu );
    connect( editSettings, SIGNAL( activated() ),
             SLOT( slotEditSettings() ) );
    editAccounts = new QAction( tr( "Configure accounts" ),  SmallIcon("editaccounts")  ,
                                0, 0, this );
    editAccounts->addTo( settingsMenu );

    //setCentralWidget( view );

    QVBox* wrapperBox = new QVBox( this );
    setCentralWidget( wrapperBox );

    // QWidget *view = new QWidget( wrapperBox );
    KDGanttMinimizeSplitter* split = new KDGanttMinimizeSplitter( Qt::Horizontal, wrapperBox);
    split->setMinimizeDirection( KDGanttMinimizeSplitter::Left);
    //layout = new QBoxLayout ( split, QBoxLayout::LeftToRight );

    folderView = new AccountView( split );
    folderView->header()->hide();
    folderView->setRootIsDecorated( false );
    folderView->addColumn( tr( "Mailbox" ) );

    //layout->addWidget( folderView );

    mailView = new QListView( split );
    mailView->addColumn( tr( " " ) );
    mailView->addColumn( tr( "Subject" ),QListView::Manual );
    mailView->addColumn( tr( "Sender" ),QListView::Manual );
    mailView->addColumn( tr( "Size" ),QListView::Manual);
    mailView->addColumn( tr( "Date" ),QListView::Manual);
    mailView->setAllColumnsShowFocus(true);
    //mailView->setSorting(-1);
    mailView->setRootIsDecorated( false );
    statusWidget = new StatusWidget( wrapperBox );
    statusWidget->hide();

    //layout->addWidget( mailView );
    //layout->setStretchFactor( folderView, 1 );
    //layout->setStretchFactor( mailView, 2 );

    slotAdjustLayout();
#ifndef DESKTOP_VERSION
    QPEApplication::setStylusOperation( mailView->viewport(),QPEApplication::RightOnHold);
    QPEApplication::setStylusOperation( folderView->viewport(),QPEApplication::RightOnHold);
#endif
    connect( mailView, SIGNAL(  doubleClicked (QListViewItem* )),this,
             SLOT( mailLeftClicked(QListViewItem*) ) );
    connect( mailView, SIGNAL(  returnPressed (QListViewItem* )),this,
             SLOT( mailLeftClicked(QListViewItem*) ) );
    connect( mailView, SIGNAL( mouseButtonPressed(int,QListViewItem*,const QPoint&,int) ),this,
             SLOT( mailHold(int,QListViewItem*,const QPoint&,int) ) );
    connect(folderView, SIGNAL(refreshMailview(const QValueList<RecMailP>&)),
            this,SLOT(refreshMailView(const QValueList<RecMailP>&)));
    connect( composeMail, SIGNAL( activated() ), SLOT( slotComposeMail() ) );
    connect( sendQueued, SIGNAL( activated() ), SLOT( slotSendQueued() ) );
//    connect( searchMails, SIGNAL( activated() ), SLOT( slotSearchMails() ) );
    connect( editAccounts, SIGNAL( activated() ), SLOT( slotEditAccounts() ) );
    //mailView->setMultiSelection ( true );
    mailView->setSelectionMode( QListView::Extended );
    QValueList<int> list;
    int fw = 100;
    if ( QApplication::desktop()->width() > 320 )
        fw = 50;
    list.append( fw );
    list.append( 100 );
    split->setSizes( list );
    QTimer::singleShot( 1000, this, SLOT( slotAdjustColumns() ) );
    mailView->setShowSortIndicator ( true ); 
    QLabel *spacer = new QLabel( toolBar );
    spacer->setBackgroundMode( QWidget::PaletteButton );
    toolBar->setStretchableWidget( spacer );

    QAction* closeMail = new QAction(tr("Close"),SmallIcon("exit"), 0, 0, this); 
    connect( closeMail, SIGNAL( activated() ), SLOT( close() ) );
    if ( QApplication::desktop()->width() > 320 )
        closeMail->addTo(toolBar);
	closeMail->addTo(mailMenu);


   QPopupMenu* helpMenu = new QPopupMenu( menuBar );
   menuBar->insertItem( tr( "Help" ), helpMenu ); 
   QAction* li = new QAction(tr("About"), QPixmap(), 0, 0, this); 
   connect( li, SIGNAL( activated() ), SLOT( showAbout()) );
   li->addTo(helpMenu);
   li = new QAction(tr("Licence"),QPixmap(), 0, 0, this); 
   connect( li, SIGNAL( activated() ), SLOT( showLicence()) );
   li->addTo(helpMenu); 
   li = new QAction(tr("LibEtPan Licence"), QPixmap(), 0, 0, this); 
   connect( li, SIGNAL( activated() ), SLOT( showEtpanLicence()) );
   li->addTo(helpMenu);
}

MainWindow::~MainWindow()
{
}

void  MainWindow::showLicence()
{
    KApplication::showLicence();
}
void  MainWindow::showAbout()
{
    QString version;
#include <../version>

    QString cap = "About KOpieMail/Pi";
	QString text =	i18n("KOpieMail/Platform-independent\n") +
                        "(OM/Pi) " + version + " - "
                      
#ifdef DESKTOP_VERSION
                        "Desktop Edition\n"
#else
                       "PDA-Edition\nfor: Zaurus 5x00 / 7x0 / 8x0\n"
#endif
		"www.pi-sync.net\n\n"



"Copyright (c) 2004 Lutz Rogowski <lutz@pi-sync.net>\n"
		"KOpieMail/Pi is based on Opie Mail\n"
		"Copyright (c) Rajko Albrecht and the Opie team\n"
		"KOpieMail/Pi is licensed under the GPL\n"
		"\n"
		"KOpieMail/Pi uses LibEtPan - a mail stuff library\n"
        "Copyright (C) 2001, 2002 - DINH Viet Hoa\n"
		"libEtPan has its own licence - see LibEtPan licence\n";

    KApplication::showText( cap, text );
}
void  MainWindow::showEtpanLicence()
{
    KApplication::showFile( "LibEtPan licence", "kdepim/kopiemail/COPYRIGHTlibetpan" );

} 
void MainWindow::appMessage(const QCString &, const QByteArray &)
{
    qDebug("appMessage implemented by subclass");
}

void MainWindow::slotAdjustLayout() {

    /*
  QWidget *d = QApplication::desktop();

  if ( d->width() < d->height() ) {
    layout->setDirection( QBoxLayout::TopToBottom );
    } else {
    layout->setDirection( QBoxLayout::LeftToRight );
  }
    */
}

void MainWindow::slotAdjustColumns()
{
    bool hidden = folderView->isHidden();
    if ( hidden ) folderView->show();
    folderView->setColumnWidth( 0, folderView->visibleWidth() );
    if ( hidden ) folderView->hide();

    mailView->setColumnWidth( 0, 10 );
    mailView->setColumnWidth( 1, 100 );
    mailView->setColumnWidth( 2, 100 );
    mailView->setColumnWidth( 3, 50 );
    mailView->setColumnWidth( 4, 120 );
}

void MainWindow::slotEditSettings()
{
}

void MainWindow::slotShowFolders( bool )
{
    qDebug("not implemented:  ");
}

void MainWindow::refreshMailView(const QValueList<RecMailP>&)
{ 
    qDebug("not implemented:  ");
}

void MainWindow::mailLeftClicked(QListViewItem * )
{
    qDebug("not implemented:  ");
}

void MainWindow::displayMail()
{
    qDebug("not implemented:  ");
}

void MainWindow::slotDeleteMail()
{
    qDebug("not implemented:  ");
}

void MainWindow::mailHold(int, QListViewItem *,const QPoint&,int  )
{
    qDebug("not implemented:  ");
}

void MainWindow::slotSendQueued()
{
    qDebug("not implemented:  ");
}

void MainWindow::slotEditAccounts()
{
    qDebug("not implemented:  ");
}

void MainWindow::slotComposeMail()
{
    qDebug("not implemented:  ");
}
