/*
    This file is part of libkdepim.

    Copyright (c) 2003 Tobias Koenig <tokoe@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#include <kabc/address.h>
#include <kabc/addressee.h>
#include <kabc/phonenumber.h>
#include <kglobal.h>
//US#include <kglobalsettings.h>
#include <kiconloader.h>
#include <klocale.h>
//US #include <kstringhandler.h>
#include <qscrollview.h>
#include <qregexp.h>
#include <qfile.h>
#include <qapplication.h>


#include "externalapphandler.h"
#include "addresseeview.h"


//US #ifndef DESKTOP_VERSION
//US #include <qtopia/qcopenvelope_qws.h>
//US #include <qpe/qpeapplication.h>
//US #endif

//US static int kphoneInstalled = 0;

using namespace KPIM;

AddresseeView::AddresseeView( QWidget *parent, const char *name )
//US  : KTextBrowser( parent, name )
  : QTextBrowser( parent, name )


{
//US  setWrapPolicy( QTextEdit::AtWordBoundary );
  setLinkUnderline( false );
  // setVScrollBarMode( QScrollView::AlwaysOff );
  //setHScrollBarMode( QScrollView::AlwaysOff );

//US  QStyleSheet *sheet = styleSheet();
//US  QStyleSheetItem *link = sheet->item( "a" );
//US  link->setColor( KGlobalSettings::linkColor() );

}

void AddresseeView::setSource(const QString& n)
{
  qDebug("********AddresseeView::setSource %s", n.latin1());

  if ( n.left( 6 ) == "mailto" )
    ExternalAppHandler::instance()->mailToOneContact( n.mid(7) );
  else if ( n.left( 7 ) == "phoneto" )
    ExternalAppHandler::instance()->callByPhone(  n.mid(8) );
  else if ( n.left( 5 ) == "faxto" )
    ExternalAppHandler::instance()->callByFax(  n.mid(6) );
  else if ( n.left( 5 ) == "smsto" )
    ExternalAppHandler::instance()->callBySMS(  n.mid(6) );
  else if ( n.left( 7 ) == "pagerto" )
    ExternalAppHandler::instance()->callByPager(  n.mid(8) );

}
void AddresseeView::setAddressee( const KABC::Addressee& addr )
{
  ExternalAppHandler* eah = ExternalAppHandler::instance();
  bool kemailAvail = eah->isEmailAppAvailable();
  bool kphoneAvail = eah->isPhoneAppAvailable();
  bool kfaxAvail = eah->isFaxAppAvailable();
  bool ksmsAvail = eah->isSMSAppAvailable();
  bool kpagerAvail = eah->isPagerAppAvailable();


  mAddressee = addr;
  // clear view
  setText( QString::null );

  if ( mAddressee.isEmpty() )
    return;

  QString name = ( mAddressee.assembledName().isEmpty() ?
                   mAddressee.formattedName() : mAddressee.assembledName() );

  QString dynamicPart;

  QStringList emails = mAddressee.emails();
  QStringList::ConstIterator emailIt;
  QString type = i18n( "Email" );
  emailIt = emails.begin();
  if ( emailIt != emails.end() ) {
    if ( kemailAvail ) {
      dynamicPart += QString(
            "<tr><td align=\"right\"><b>%1</b></td>"
           "<td align=\"left\"><a href=\"mailto:%2 <%3> \">%4</a></td></tr>" )
          .arg( type )
          .arg( name )
          .arg( *emailIt )
          .arg( *emailIt );
      ++emailIt;
    } else {
      dynamicPart += QString(
            "<tr><td align=\"right\"><b>%1</b></td>"
           "<td align=\"left\">%2</td></tr>" )
          .arg( type )
          .arg( *emailIt );
      ++emailIt;
    }
  }

  KABC::PhoneNumber::List phones = mAddressee.phoneNumbers();
  KABC::PhoneNumber::List::ConstIterator phoneIt;
  QString extension;
  int phonetype;
  QString sms;
  for ( phoneIt = phones.begin(); phoneIt != phones.end(); ++phoneIt ) {
    phonetype = (*phoneIt).type();
    if (ksmsAvail &&
        (
		 ((phonetype & KABC::PhoneNumber::Car) == KABC::PhoneNumber::Car) ||
         ((phonetype & KABC::PhoneNumber::Cell) == KABC::PhoneNumber::Cell)
        )
       )
    {
      sms = QString("<a href=\"smsto:%1  \">(sms)</a>" )
              .arg( (*phoneIt).number() );

    }
    else
      sms = "";

    extension = QString::null;
    if ((phonetype & KABC::PhoneNumber::Fax) == KABC::PhoneNumber::Fax) {
      if (kfaxAvail) extension = "faxto:";
    }
    else if ((phonetype & KABC::PhoneNumber::Pager) == KABC::PhoneNumber::Pager) {
      if (kpagerAvail) extension = "pagerto:";
    }
    else if (kphoneAvail) {
      extension = "phoneto:";
    }
    else
      extension = QString::null;

      if ( !extension.isEmpty() ) {
          dynamicPart += QString(
                                 "<tr><td align=\"right\"><b>%1</b></td>"
           "<td align=\"left\"><a href=\"%2%3  \">%4</a> %5</td></tr>" )
              .arg( KABC::PhoneNumber::typeLabel( phonetype ) )
              .arg( extension )
              .arg( (*phoneIt).number() )
              .arg( (*phoneIt).number() )
              .arg( sms );

      } else {
          dynamicPart += QString(
                                 "<tr><td align=\"right\"><b>%1</b></td>"
                                 "<td align=\"left\">%2 %3</td></tr>" )
              .arg( KABC::PhoneNumber::typeLabel( phonetype ) )
              .arg( (*phoneIt).number() )
              .arg( sms );
      }
  }


  for ( ; emailIt != emails.end(); ++emailIt ) {
    if ( kemailAvail ) {
      dynamicPart += QString(
        "<tr><td align=\"right\"><b>%1</b></td>"
        "<td align=\"left\"><a href=\"mailto:%2 <%3> \">%4</a></td></tr>" )
        .arg( type )
        .arg( name )
        .arg( *emailIt )
        .arg( *emailIt );
	} else {
      dynamicPart += QString(
        "<tr><td align=\"right\"><b>%1</b></td>"
        "<td align=\"left\">%2</td></tr>" )
        .arg( type )
        .arg( *emailIt );
    }
  }

  if ( !mAddressee.url().url().isEmpty() ) {
    dynamicPart += QString(
      "<tr><td align=\"right\"><b>%1</b></td>"
      "<td align=\"left\">%2</td></tr>" )
      .arg( i18n( "Homepage" ) )
//US      .arg( KStringHandler::tagURLs( mAddressee.url().url() ) );
      .arg( mAddressee.url().url() );
    //qDebug("AddresseeView::setAddressee has to be verified.");
  }

  KABC::Address::List addresses = mAddressee.addresses();
  KABC::Address::List::ConstIterator addrIt;
  for ( addrIt = addresses.begin(); addrIt != addresses.end(); ++addrIt ) {
      if ( true /*(*addrIt).label().isEmpty()*/ ) {
      QString formattedAddress = (*addrIt).formattedAddress().stripWhiteSpace();
//US      formattedAddress = formattedAddress.replace( '\n', "<br>" );
      //qDebug("adresss %s ",formattedAddress.latin1() );
       formattedAddress = formattedAddress.replace( QRegExp("\n"), "<br>" );
       //qDebug("AddresseeView::setAddressee has to be verified.");

      dynamicPart += QString(
        "<tr><td align=\"right\"><b>%1</b></td>"
        "<td align=\"left\">%2</td></tr>" )
        .arg( KABC::Address::typeLabel( (*addrIt).type() ) )
        .arg( formattedAddress );
    } else {

      dynamicPart += QString(
        "<tr><td align=\"right\"><b>%1</b></td>"
        "<td align=\"left\">%2</td></tr>" )
        .arg( KABC::Address::typeLabel( (*addrIt).type() ) )
//US        .arg( (*addrIt).label().replace( '\n', "<br>" ) );
          .arg( (*addrIt).label() /*replace( QRegExp("\n"), "<br>" )*/ );

    }
  }

  QString notes;
  if ( !mAddressee.note().isEmpty() ) {
    notes = QString(
      "<tr>"
      "<td align=\"right\" valign=\"top\"><b>%1</b></td>"  // note label
      "<td align=\"left\">%2</td>"  // note
      "</tr>" ).arg( i18n( "Notes" ) )
//US      .arg( mAddressee.note().replace( '\n', "<br>" ) );
      .arg( mAddressee.note().replace( QRegExp("\n"), "<br>" ) );
    //qDebug("AddresseeView::setAddressee has to be verified.");
  }

  QString aRole = "";
  QString aOrga = "";
  if ( true /*!mAddressee.role().isEmpty()*/ ) {
      aRole = "<tr>"
          "<td align=\"left\">" + mAddressee.role() + "</td>"
          "</tr>";
  }
  if ( true /*!mAddressee.organization().isEmpty()*/ ) {
      aOrga = "<tr>"
          "<td align=\"left\">" + mAddressee.organization() + "</td>" ;
          "</tr>";
  }
  mText = "";
  QString picString = "";
  KABC::Picture picture = mAddressee.photo();
  bool picAvailintern = false;
  bool picAvailUrl = false;
  if (! picture.undefined() ) {
      picAvailintern = (picture.isIntern() && !picture.data().isNull());
      picAvailUrl = !picture.isIntern() &&  QFile::exists(picture.url() );
  }
  if ( picAvailUrl || picAvailintern || QApplication::desktop()->width() > 320 ) {
      if (  picAvailintern ) {
          QMimeSourceFactory::defaultFactory()->setImage( "myimage", picture.data() );
      } else {
          if ( picAvailUrl ) {
              QMimeSourceFactory::defaultFactory()->setPixmap( "myimage", QPixmap( picture.url() ));
          } else {
          QMimeSourceFactory::defaultFactory()->setPixmap( "myimage", KGlobal::iconLoader()->loadIcon( "package_toys", KIcon::Desktop, 128 ) );
          }
      }
      picString =  "<img src=\"myimage\" width=\"50\" height=\"70\">";
    mText = QString::fromLatin1(
  "<html>"
  "<body text=\"%1\" bgcolor=\"%2\">" // text and background color
  "<table>"
  "<tr>"
  "<td rowspan=\"3\" align=\"right\" valign=\"top\">"
  "%3"
  "</td>"
  "<td align=\"left\"><font size=\"+2\"><b>%4</b></font></td>"  // name
  "</tr>"
  "%5"  // role
  "%6"  // organization
  "<td colspan=\"2\">&nbsp;</td>"
  "%7"  // dynamic part
  "%8"  // notes
  "</table>"
  "</body>"
  "</html>")
//US
  .arg( /*KGlobalSettings::textColor().name()*/ "black" )
//US
  .arg( /*KGlobalSettings::baseColor().name()*/ "white" )
  .arg( picString )
  .arg( name )
  .arg( aRole )
  .arg( aOrga )
  .arg( dynamicPart )
  .arg( notes );

  } else { // no picture!

mText = "<table width=\"100%\">\n";
    //mText += "<tr bgcolor=\"#3679AD\"><td><h2>";
#ifdef DESKTOP_VERSION
    mText += "<tr bgcolor=\"#5699CD\"><td align=\"left\"><h1>";
#else
    mText += "<tr bgcolor=\"#5699CD\"><td align=\"left\"><h2>";
#endif

#ifdef DESKTOP_VERSION
    mText += "<font color=\"#FFFFFF\"> <em>" +  name+"</em></font></h1>";
#else
    mText += "<font color=\"#FFFFFF\"> <em>" +  name +"</em></font></h2>";
#endif
    mText += "</td></tr>\n<tr  bgcolor=\"#EAF8FA\"><td>";

    mText += "<table><td colspan=\"2\">&nbsp;</td>";
    /*
      mText += QString("<tr><td align=\"right\"><b2>%1</b2></td>"
        "<td align=\"left\"><b>%2</b></td></tr>" )
          .arg( i18n(" ") )
        .arg( name );
    */
      if ( ! mAddressee.role().isEmpty() )
      mText += QString("<tr><td align=\"right\"><b>%1</b></td>"
        "<td align=\"left\">%2</td></tr>" )
          .arg( i18n(" ") )
        .arg( mAddressee.role());
      if ( ! mAddressee.organization().isEmpty() )
      mText += QString("<tr><td align=\"right\"><b>%1</b></td>"
        "<td align=\"left\">%2</td></tr>" )
          .arg( i18n(" ") )
        .arg( mAddressee.organization());
      mText += dynamicPart;
      mText += notes;
      mText += "</table>";

 }

  // at last display it...
  setText( mText );

}

KABC::Addressee AddresseeView::addressee() const
{
  return mAddressee;
}
void AddresseeView::addTag(const QString & tag,const QString & text)
{
    if ( text.isEmpty() )
        return;
    int number=text.contains("\n");
    QString str = "<" + tag + ">";
    QString tmpText=text;
    QString tmpStr=str;
    if(number !=-1)
        {
            if (number > 0) {
                int pos=0;
                QString tmp;
                for(int i=0;i<=number;i++) {
                    pos=tmpText.find("\n");
                    tmp=tmpText.left(pos);
                    tmpText=tmpText.right(tmpText.length()-pos-1);
                    tmpStr+=tmp+"<br>";
                }
            }
            else tmpStr += tmpText;
            tmpStr+="</" + tag + ">";
            mText.append(tmpStr);
        }
    else
        {
            str += text + "</" + tag + ">";
            mText.append(str);
        }
}
