/*
    This file is part of libkdepim.
    Copyright (c) 2002 Cornelius Schumacher <schumacher@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

    As a special exception, permission is given to link this program
    with any edition of Qt, and distribute the resulting executable,
    without including the source code for Qt in the source distribution.
*/

/*
Enhanced Version of the file for platform independent KDE tools.
Copyright (c) 2004 Ulf Schenk

$Id: kpimglobalprefs.cpp,v 1.2 2004/09/07 23:33:28 zautrix Exp $
*/

#include <kglobal.h>
#include <kconfig.h>
#include <klocale.h>
#include <kdebug.h>
#include <kstaticdeleter.h>

#include "kpimglobalprefs.h"

KPimGlobalPrefs *KPimGlobalPrefs::sInstance = 0;
static KStaticDeleter<KPimGlobalPrefs> staticDeleter;


KPimGlobalPrefs::KPimGlobalPrefs( const QString &name )
  : KPrefs("kkdepimrc")
{
  KPrefs::setCurrentGroup( "ExternalApplications" );

  addItemInt( "EmailChannelType", &mEmailClient, OMPI_EMC );
  addItemString( "EmailChannel", &mEmailOtherChannel, "" );
  addItemString( "EmailChannelMessage", &mEmailOtherMessage, "" );
  addItemString( "EmailChannelParameters", &mEmailOtherMessageParameters, "" );
  addItemString( "EmailChannelMessage2", &mEmailOtherMessage2, "" );
  addItemString( "EmailChannelParameters2", &mEmailOtherMessageParameters2, "" );

  addItemInt( "PhoneChannelType", &mPhoneClient, KPPI_PHC );
  addItemString( "PhoneChannel", &mPhoneOtherChannel, "" );
  addItemString( "PhoneChannelMessage", &mPhoneOtherMessage, "" );
  addItemString( "PhoneChannelParameters", &mPhoneOtherMessageParameters, "" );

  addItemInt( "FaxChannelType", &mFaxClient, NONE_FAC );
  addItemString( "FaxChannel", &mFaxOtherChannel, "" );
  addItemString( "FaxChannelMessage", &mFaxOtherMessage, "" );
  addItemString( "FaxChannelParameters", &mFaxOtherMessageParameters, "" );

  addItemInt( "SMSChannelType", &mSMSClient, NONE_SMC );
  addItemString( "SMSChannel", &mSMSOtherChannel, "" );
  addItemString( "SMSChannelMessage", &mSMSOtherMessage, "" );
  addItemString( "SMSChannelParameters", &mSMSOtherMessageParameters, "" );

  addItemInt( "PagerChannelType", &mPagerClient, NONE_PAC );
  addItemString( "PagerChannel", &mPagerOtherChannel, "" );
  addItemString( "PagerChannelMessage", &mPagerOtherMessage, "" );
  addItemString( "PagerChannelParameters", &mPagerOtherMessageParameters, "" );

}

KPimGlobalPrefs::~KPimGlobalPrefs()
{
}

KPimGlobalPrefs *KPimGlobalPrefs::instance()
{
  if ( !sInstance ) {
    sInstance = staticDeleter.setObject( new KPimGlobalPrefs() );
    sInstance->readConfig();
  }

  return sInstance;
}
