/*  This file is part of the KDE project
    Copyright (C) 2000 Simon Hausmann <hausmann@kde.org>
    Copyright (C) 2003 Luciano Montanaro <mikelima@cirulla.net>
    Copyright (C) 2004 Fastweb SpA

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef __kiconloader_h__
#define __kiconloader_h__

#include <qpixmap.h>
#include <qstring.h>
#include <qmap.h>
#include <qiconset.h>

#include <kiconeffect.h>
#include <kicontheme.h>

class KInstance;

// ###
static inline QPixmap BarIcon( const QString & ) { return QPixmap(); }

class KIconLoader
{
public:
    KIconLoader() {}
    ~KIconLoader() {}

    QPixmap loadIcon( const QString &name, int = 0, int = 0, int = 0, QString* = NULL, bool = false );

    // extension
    void registerIcon( const QString &name, const QPixmap &pix );

    static KIconLoader *self();

    // Needed by kdelibs 3.2
    int currentSize(KIcon::Group /* group */) const { return 16; }

private:
    static KIconLoader *s_self;

    QMap<QString,QPixmap> m_pixmaps;
};

inline QPixmap SmallIcon( const QString & ) { return QPixmap(); }
inline QPixmap SmallIcon( const QString &, KInstance * ) { return QPixmap(); }
// Needed by kdelibs 3.5
inline QPixmap MainBarIcon( const QString &, KInstance * = NULL ) { return QPixmap(); }
inline QIconSet SmallIconSet( const char * ) { return QIconSet(QPixmap()); }

#endif
