/*  This file is part of the KDE project
    Copyright (C) 2000 Simon Hausmann <hausmann@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef __kinstance_h__
#define __kinstance_h__

// dummy

class KStandardDirs;
class KConfig;
class KAboutData;

#include <kiconloader.h>

class KInstance
{
    friend class KStandardDirs;
public:
    KInstance( KAboutData *data );
    KInstance( const char *name );
    ~KInstance();

    KStandardDirs *dirs() const { return m_dirs; }

    KConfig *config() const;

    QCString instanceName() const { return m_name; }

    KIconLoader *iconLoader() const { return KIconLoader::self(); }

private:
    void init();

    KStandardDirs *m_dirs;
    mutable KConfig *_config;
    QCString m_name;
};

#endif
