/*
 *  linux/include/asm-arm/arch-lh79520/irqs.h
 *
 *  Copyright (C) 2002 Lineo, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */

#ifndef __ASM_ARCH_IRQS_H
#define __ASM_ARCH_IRQS_H

#define NR_IRQS			32

#if defined(CONFIG_LH79520_EVB)
#define	IRQ_ETHERNET	0
#define	IRQ_CF		1
#define	IRQ_CPLD	2
#define	IRQ_PWM0SYNC	3
#define	IRQ_PWM0	4
#define	IRQ_DREQ1	5
#define	IRQ_LCDVD10	6
#define	IRQ_LCDVD11	7
#endif
#if defined(CONFIG_LPD_79520_10)
/* external interrupts 0-7 are mapped to, surprise, 0-7 */
/* we split irq4 into IRQ_ETHERNET & IRQ_TOUCH */
#define	IRQ_ETHERNET	4
#define	IRQ_TOUCH		5
#define	IRQ_CPLD	x
#define IRQ_blah	x
#endif
#define	IRQ_spare_i0	8	/* spare internal */
#define	IRQ_spare_i1	9	/* spare internal */
#define	IRQ_spare_i2	10	/* spare internal */
#define	IRQ_SPEXTINT3	11
#define	IRQ_LCD		12
#define	IRQ_SSPTXINTR	13
#define	IRQ_SSPRXINTR	14
#define	IRQ_SSPRORINTR	15
#define	IRQ_SSPINTR	16
#define	IRQ_TIMER0	17
#define	IRQ_TIMER1	18
#define	IRQ_TIMER2	19
#define	IRQ_TIMER3	20
#define	IRQ_UART0_RX	21
#define	IRQ_UART0_TX	22
#define	IRQ_UART0	23
#define	IRQ_UART1	24
#define	IRQ_UART2	25
#define	IRQ_DMA		26	/* all DMA channels */
#define	IRQ_spare_i4	27	/* spare internal */
#define	IRQ_spare_i5	28	/* spare internal */
#define	IRQ_spare_i6	29	/* spare internal */
#define	IRQ_RTC		30
#define	IRQ_WDT		31

#endif
