/*
 *  linux/arch/arm/mach-s3c2410/arch.c
 *
 *  Copyright (C) 2002 SAMSUNG ELECTRONICS 
 *                        SW.LEE (hitchcar@sec.samsung.com)
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include <linux/config.h>
#include <linux/types.h>
#include <linux/sched.h>
#include <linux/interrupt.h>
#include <linux/init.h>

#include <asm/hardware.h>
#include <asm/irq.h>
#include <asm/setup.h>
#include <asm/mach-types.h>



#include <asm/mach/arch.h>
#include <asm/mach/map.h>

extern void __init HWs3c2410_map_io(void);
extern void __init s3c2410_init_irq(void);

static void __init
fixup_s3c2410(struct machine_desc *desc, struct param_struct *params,
	     char **cmdline, struct meminfo *mi)
{
/********* 
 *	nGCS6 0 (SDRAM Bank 1) has one memory bank at  start address 0x30000000 
 *      Memory Size 64Mbye and
 *      becasue nCCS7 (SDRAM Bank 2) has a flexible start address , 
 *      we don't need bank[].node if we would use 128Mbyte Memory 
 *     
 */  
	mi->bank[0].start = PA_SDRAM_BASE;
	mi->bank[0].size =  S3C2410_MEM_SIZE;
	mi->bank[0].node =  0;
	mi->nr_banks = 1;

	ROOT_DEV = MKDEV(RAMDISK_MAJOR,0);

#ifdef CONFIG_BLK_DEV_RAM_SIZE
	setup_ramdisk( 1, 0, 0, CONFIG_BLK_DEV_RAM_SIZE);
#else
	setup_ramdisk( 1, 0, 0, BLK_DEV_RAM_SIZE);
#endif
	setup_initrd( __phys_to_virt(RAMDISK_DN_ADDR), ZIP_RAMDISK_SIZE);
}

static void __init s3c2410_map_io(void)
{
	HWs3c2410_map_io();
}


MACHINE_START(S3C2410, "SAMSUNG ELECTRONICS Co., Ltd")
	MAINTAINER("SW.LEE (hitchcar@sec.samsung.com)")
	BOOT_MEM(PA_SDRAM_BASE,PA_UART_BASE,VA_UART_BASE)
	//BOOT_PARAMS(PA_SDRAM_BASE+0x100)
	FIXUP(fixup_s3c2410)
	MAPIO(s3c2410_map_io)
	INITIRQ(s3c2410_init_irq)
MACHINE_END
