/*
 *  linux/arch/arm/mach-omap/warmstart_detect.c
 *
 * BRIEF MODULE DESCRIPTION
 *   report OMAP die ID
 *
 * Copyright (C) 2004 Archos SA.
 * Author:
 *         Niklas Schroeter <schoeter@archos.com>
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <linux/config.h>
#include <linux/init.h>
#include <linux/proc_fs.h>

#include <asm/hardware.h>
#include <asm/io.h>

#ifdef CONFIG_PROC_FS

/* OMAP RTC register access macros: */

#define CMOS_READ(addr)         *((volatile u8 *)(addr))
#define CMOS_WRITE(val, addr)   *((volatile u8 *)(addr)) = val

static int is_warmstart = 1;

static int warmstart_read_proc(char *page, char **start, off_t off,
                         int count, int *eof, void *data)
{
        
	int len;

	len = sprintf(page, "%d\n", is_warmstart);
	
        if (len <= off+count) *eof = 1;
        *start = page + off;
        len -= off;
        if (len>count) len = count;
        if (len<0) len = 0;
        return len;
}
#endif


int __init omap1510_warmstart_detect_init(void)
{

#ifdef CONFIG_PROC_FS
        create_proc_read_entry ("cpu/warmstart", 0, 0, warmstart_read_proc, NULL);
#endif
        if (CMOS_READ(OMAP_RTC_STATUS_REG) & OMAP_RTC_STATUS_POWER_UP) {
                printk(KERN_WARNING "power up reset detected.\n");
                /* Clear OMAP_RTC_STATUS_POWER_UP */
                is_warmstart = 0;
		CMOS_WRITE(OMAP_RTC_STATUS_POWER_UP, OMAP_RTC_STATUS_REG);
        }

	printk(KERN_INFO "OMAP1510 warmstart detection initialized\n");

	return 0;
}

__initcall(omap1510_warmstart_detect_init);
