/*
 * setup-s3c2410.c
 *
 * BRIEF MODULE DESCRIPTION
 *   This has additional initialiation needed by the S3C2410 and DSC25.
 *
 * Copyright (C) 2003 LSE GmbH.
 * Author: LSE GmbH
 *          mwelwarsky@web.de
 *
 */

#include <asm/system.h>
#include <asm/arch/hardware.h>
#include <asm/io.h>
#include <asm/arch/dsc25def.h>

static void s3c2410_external_bus_init(void)
{
	unsigned long val;
	unsigned short buf0, buf1, buf2;
	
	/* initialize external bus */
  
	/* BANK5: 16 bit access, WAIT disabled, no UB/LB */
	val = rBWSCON;
	val &= ~(unsigned long)(0xf<<20);
	val |= (1<<20);
	rBWSCON = val;
	
	/* GPA bit 16: BANK5 chip select */
	rGPACON |= (1<<16);

	/* external bus access timings */
	rBANKCON5 = (0x1 << 13) | // T_acs 1 clocks
		    (0x0 << 11) | // T_cos 0 clocks
		    (0x7 <<  8) | // T_acc 14 clocks
		    (0x0 <<  6) | // T_coh 0 clocks
		    (0x0 <<  4);  // T_cah 0 clocks

	/* initialize DSC25 */
	printk("external bus init: DSC25 chip revision %04x\n", BUSC_REVR);
	
	// start read on falling edge of nOE
	BUSC_RTRGSEL = 0x0001;

#if 1
	// use WAIT signal
	BUSC_EMWAITEN = 0x0001;
	rBWSCON      |= (1<<22);
#endif
#if 1
	rBANKCON5 = (0x2 << 13) | // T_acs 1 clocks
		    (0x0 << 11) | // T_cos 0 clocks
		    (0x7 <<  8) | // T_acc 14 clocks min.,  controlled by WAIT
		    (0x0 <<  6) | // T_coh 0 clocks
		    (0x0 <<  4);  // T_cah 0 clocks
#endif

	// program PLLs
	CLOCKC_CLKC   = 0x0001;
	CLOCKC_BYP    = 0x0007;
#if 1
	CLOCKC_PLLARM = 0x0021;
	CLOCKC_PLLDSP = 0x0031;
	CLOCKC_PLLSDR = 0x00b0;

	// wait for PLL lock signal
	do { 
		buf0 = CLOCKC_PLLARM & 0x8000;
		buf1 = CLOCKC_PLLDSP & 0x8000;
		buf2 = CLOCKC_PLLSDR & 0x8000;
	} while( !buf0 || !buf1 || !buf2 );

	CLOCKC_DIV  = 0x0000;
	CLOCKC_BYP  = 0x0000;
#endif
	
	CLOCKC_MOD1 = 0x82FF;
	CLOCKC_MOD2 = 0xFFFF;

	// initialize DSC25 SDRAM controller
	SDRAM_MODE   = 0x1900;
	SDRAM_REFCTL = 0x1140;
	SDRAM_MODE   = 0x1902; // precharge
	SDRAM_MODE   = 0x1904; // autorefresh x 8
	SDRAM_MODE   = 0x1904;
	SDRAM_MODE   = 0x1904;
	SDRAM_MODE   = 0x1904;
	SDRAM_MODE   = 0x1904;
	SDRAM_MODE   = 0x1904;
	SDRAM_MODE   = 0x1904;
	SDRAM_MODE   = 0x1904;
	SDRAM_MODE   = 0x1901; // mrs
	
	udelay(10);
	
// 	while(1) {
// 		volatile unsigned short* sdram = (volatile unsigned short*)(VA_DSC25_BASE+0x00555555);
// 		volatile unsigned short dummy;
// 		
// 		dummy = *sdram;
// 	}
}

void s3c2410_setup(void)
{
	s3c2410_external_bus_init();
}
