/*
 * av500_hd.h - hard disk access
 *
 * Author: Niklas Schroeter
 * <niki@nikishome.de>
 * Date: 11.06.2003
 *
 */

#include <linux/blkdev.h>
 
#ifndef __AV500_HD_H
#define __AV500_HD_H

#ifdef CONFIG_AV500_REV10

#define HD_BASE         hd_base                        /* 0x08080000 */
/* read register */
#define HD_ALTSTATUS	HD_BASE + (0x0000006 << 1)     /* 0x0808000C */
#define HD_DATA		HD_BASE + (0x0040000 << 1)     /* 0x08100000 */
#define HD_ERROR	HD_BASE + (0x0040001 << 1)     /* 0x08100002 */
#define HD_NSECTOR	HD_BASE + (0x0040002 << 1)     /* 0x08100004 */
#define HD_SECTOR	HD_BASE + (0x0040003 << 1)     /* 0x08100006 */
#define HD_LCYL		HD_BASE + (0x0040004 << 1)     /* 0x08100008 */
#define HD_HCYL		HD_BASE + (0x0040005 << 1)     /* 0x0810000a */
#define HD_DEV_HEAD	HD_BASE + (0x0040006 << 1)     /* 0x0810000c */
#define HD_STATUS	HD_BASE + (0x0040007 << 1)     /* 0x0810000e */
#define HD_RESET	HD_BASE + (0x0080000 << 1)     /* 0x08180000 */

#define HD_RESET_0      HD_BASE + (0x0080000 << 1)     /* 0x08180000 */
#define HD_RESET_1      HD_BASE + (0x0080001 << 1)     /* 0x08180002 */
#define HD_SWITCH_0	HD_BASE + (0x0080002 << 1)     /* 0x08180004 */
#define HD_SWITCH_1     HD_BASE + (0x0080003 << 1)     /* 0x08180006 */
#define USB_SWITCH_0    HD_BASE + (0x0080004 << 1)
#define USB_SWITCH_1    HD_BASE + (0x0080005 << 1)
/* DMA Acknowledge enable*/
#define DMA_ACK_0	HD_BASE + (0x0080006 << 1)     /* 0x0818000c */
#define DMA_ACK_1	HD_BASE + (0x0080007 << 1)     /* 0x0818000e */

#define HD_PHYS_DATA    (HD_PHYS_BASE + (0x0040000 << 1))

/* DMA Acknowledge */
#define DMA_ACK_0	HD_BASE + (0x0080006 << 1)     /* 0x0818000c */
#define DMA_ACK_1	HD_BASE + (0x0080007 << 1)     /* 0x0818000e */

#else

#define HD_BASE         hd_base                        /* 0x08002000 */
/* read register */
#define HD_ALTSTATUS	HD_BASE + (0x0000006 << 1)     /* 0x0800200C */
#define HD_DATA		HD_BASE + (0x0001000 << 1)     /* 0x08004000 */
#define HD_ERROR	HD_BASE + (0x0001001 << 1)     /* 0x08004002 */
#define HD_NSECTOR	HD_BASE + (0x0001002 << 1)     /* 0x08004004 */
#define HD_SECTOR	HD_BASE + (0x0001003 << 1)     /* 0x08004006 */
#define HD_LCYL		HD_BASE + (0x0001004 << 1)     /* 0x08004008 */
#define HD_HCYL		HD_BASE + (0x0001005 << 1)     /* 0x0800400a */
#define HD_DEV_HEAD	HD_BASE + (0x0001006 << 1)     /* 0x0800400c */
#define HD_STATUS	HD_BASE + (0x0001007 << 1)     /* 0x0800400e */
#define HD_RESET	HD_BASE + (0x0002000 << 1)     /* 0x08006000 */

#define HD_RESET_0      HD_BASE + (0x0002000 << 1)     /* 0x08006000 */
#define HD_RESET_1      HD_BASE + (0x0002001 << 1)     /* 0x08006002 */
#define HD_SWITCH_0	HD_BASE + (0x0002002 << 1)     /* 0x08006004 */
#define HD_SWITCH_1     HD_BASE + (0x0002003 << 1)     /* 0x08006006 */
#define USB_SWITCH_0    HD_BASE + (0x0002004 << 1)     /* 0x08006008 */
#define USB_SWITCH_1    HD_BASE + (0x0002005 << 1)     /* 0x0800600a */

#define HD_PHYS_DATA    (HD_PHYS_BASE + (0x0001000 << 1))     /* 0x08004000 */

/* DMA Acknowledge */
#define DMA_ACK_0	HD_BASE + (0x0002006 << 1)     /* 0x0800600c */
#define DMA_ACK_1	HD_BASE + (0x0002007 << 1)     /* 0x0800600e */

#endif

extern void av500_ide_next_request(struct request* req);

extern int av500_hd_read_sectors(struct request* req, unsigned long part_offset);
extern int av500_hd_write_sectors(struct request* req, unsigned long part_offset);
extern int av500_hd_identify(unsigned long long *max_sectors);

extern int av500_hd_init(void);
extern void av500_hd_release(void);
extern void av500_hd_hw_reset(void);
extern void av500_hd_reset(void);
extern int av500_hd_standby(void);
extern int av500_hd_idle(void);
extern int av500_hd_sleep(void);
extern void av500_hd_set_features(void);
extern void av500_hd_set_multcount(int);

extern int av500_hd_multcount;
extern unsigned long hd_base;

static inline void hd_reset(int status)
{
	if (status)
		writew(0, HD_RESET_1);
	else
		writew(0, HD_RESET_0);
}

static inline void switch_usb(int status)
{
	extern void av500_report_hdpower(int);

	if (status)
		writew(0, USB_SWITCH_1);
	else
		writew(0, USB_SWITCH_0);
	av500_report_hdpower(status);
}

static inline void switch_hd(int status)
{
	if (status)
		writew(0, HD_SWITCH_1);
	else
		writew(0, HD_SWITCH_0);
}

static inline void usb2_reset(int status)
{
	if (status)
		omap_gpio_set(15);
	else
		omap_gpio_clr(15);
}

static inline void usb2_enable(int status)
{
	if (status)
		omap_gpio_set(14);
	else
		omap_gpio_clr(14);
}

static inline void hd_led_force_on(void)
{
	omap_gpio_dir(9, GPIO_DIR_OUT);
	omap_gpio_clr(9);
}

static inline void hd_led_force_off(void)
{
	omap_gpio_dir(9, GPIO_DIR_OUT);
	omap_gpio_set(9);
}

static inline void hd_led_tristate(void)
{
	omap_gpio_dir(9, GPIO_DIR_IN);
}

#ifdef DEBUG_HD
void hd_memdump(unsigned char* buf, unsigned int count);
#endif

#if defined(CONFIG_OMAP_INNOVATOR)

#define HD_PHYS_BASE    0x08080000
#define BUS_CONFIG_REG  EMIFS_CS2_CONFIG

#else /* real AV500 hardware */

#ifdef CONFIG_AV500_REV10
#define HD_PHYS_BASE    0x0c080000
#else
#define HD_PHYS_BASE	0x0c002000
#endif

#define HD_IRQ          INT_GPIO8
#define BUS_CONFIG_REG  EMIFS_CS3_CONFIG

#endif /* CONFIG_OMAP_INNOVATOR */
#endif
