// -*- C++ -*-
/**
 * \file GUrl.h
 * This file is part of LyX, the document processor.
 * Licence details can be found in the file COPYING.
 *
 * \author Baruch Even
 * \author Michael Koziarski
 *
 * Full author contact details are available in file CREDITS
 */

#ifndef GURL_H
#define GURL_H

#ifdef __GNUG__
#pragma interface
#endif

#include "ControlUrl.h"
#include "GnomeBase.h"

namespace Gtk {
class Button;
class CheckButton;
class Entry;
}

/**
 * This class implements the dialog to insert/modify urls.
 */
class GUrl : public GnomeCB<ControlUrl> {
public:
	///
	GUrl(ControlUrl & c);
	///
	~GUrl();

	void apply();
	void update();

private:
	/// Build the dialog
	void build();

	/// Returns true if the dialog input is in a valid state.
	bool validate() const;

	/// Do the connection of signals
	void connect_signals();
	/// Disconnect the signals.
	void disconnect_signals();

	/// generated by accessors.py
	Gtk::Button * restore_btn() const;
	/// gene rated by accessors.py
	Gtk::Button * ok_btn() const;
	/// generated by accessors.py
	Gtk::Button * apply_btn() const;
	/// generated by accessors.py
	Gtk::Button * cancel_btn() const;
	/// generated by accessors.py
	Gtk::Entry * url() const;
	/// generated by accessors.py
	Gtk::Entry * name() const;
	/// generated by accessors.py
	Gtk::CheckButton * html_cb() const;

	/// Keeps the connection to the input validator.
	SigC::Connection slot_url_;
	SigC::Connection slot_name_;
	SigC::Connection slot_html_;
};

#endif
