#ifndef __ETHADDR_H
#define __ETHADDR_H


#include <sys/socket.h>		// AF_INET & struct sockaddr
#include <string.h>		// memcpy


class EthAddr {
public:
	static const unsigned int eth_size=6;
	unsigned char hwaddr[eth_size];

	EthAddr() {
	}

	EthAddr( const struct sockaddr s ) {
		memcpy( hwaddr, s.sa_data, eth_size );
	}

	friend bool
  	operator<(const EthAddr& lv, const EthAddr& rv) {
		unsigned int i;
		/*
		printf("%02X:%02X:%02X:%02X:%02X:%02X", lv.hwaddr[0], lv.hwaddr[1], lv.hwaddr[2], 			lv.hwaddr[3], lv.hwaddr[4], lv.hwaddr[5]);
		printf(" < ");
		printf("%02X:%02X:%02X:%02X:%02X:%02X", rv.hwaddr[0], rv.hwaddr[1], rv.hwaddr[2], 			rv.hwaddr[3], rv.hwaddr[4], rv.hwaddr[5]);
		printf(" ?\n");
		*/

		for (i=0; i<eth_size; i++)  {
			//printf("%x - %x\n", lv.hwaddr[i], rv.hwaddr[i] );
			if (lv.hwaddr[i] < rv.hwaddr[i]) {
				// less than <
				//printf("<: true\n");
				return true;
			} else if (lv.hwaddr[i] > rv.hwaddr[i]) {
				// bigger >
				//printf("<: true\n");
				return false;
			}
		}
		// equals ==
		//printf("<: false\n");
		return false;
	}

	friend bool
	operator==(const EthAddr& lv, const EthAddr& rv) {
		unsigned int i;
		for (i=0; i<eth_size; i++)  {
			if (lv.hwaddr[i] != rv.hwaddr[i]) {
				return false;
			}
		}
		return true;
	}

	struct sockaddr getSockaddr() {
		struct sockaddr sa;
		sa.sa_family=0;
		memcpy( sa.sa_data, hwaddr, eth_size );
		return sa;
	}
};

#endif
