/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: main.c,v 3.8 2003/04/20 21:34:07 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>
#include	<stdlib.h>
#include	<unistd.h>

#include	"murasaki.h"

int flag_debug = DEBUG_NONE;	/* debug flag */
int flag_beep = ARG_ON;

static void
set_flag_and_log(struct mu_op *opp)
{
	char *ptr;

	if ((ptr = getenv("MURASAKI_DEBUG")) != NULL)
		flag_debug = atoi(ptr);
	if (flag_debug > DEBUG_TRACE)
		openlog(opp->command,LOG_PID|LOG_CONS,LOG_DAEMON);
	else
		openlog(opp->command,LOG_PID,LOG_DAEMON);
	/* check beep on/off */
	switch(check_config("beep")) {
	case INVALID:
	case ARG_ON:
		break;	/* it may a problem */
	case ARG_OFF:
		flag_beep = 0;
		break;
	}
}

/*
 * This is common main routine
 *
 * mu_op must be each object. Don't make common main.o.
 */
int
main(int argc,char **argv)
{
	struct mu_op *opp = &mu_op;

	if (argc > 1) {
		fprintf(stderr,"%s version %s\n",MU_MURASAKI,MU_VERSION);
		exit(0);
	}

	set_flag_and_log(opp);

	DPRINTF(LOG_CONS,"PATH = \"%s\"",getenv("PATH"));
	if (opp->get_info)
		opp->get_info();
	if (get_action(opp) == INVALID) {
		syslog(LOG_LEVEL,"The action is invalid");
		exit(1);
	}
	/* build module list */
	if (opp->get_list && opp->get_list(opp) == INVALID)
		exit(1);
	/* pre-call */
	if (opp->prepare)
		opp->prepare(opp,PRECALL);
	/* load/unload */
	if (opp->run && opp->run(opp) == INVALID) {
		syslog(LOG_LEVEL,"fail to execute");
		exit(1);
	}
	closelog();
	/* post-call */
	if (opp->end)
		opp->end(opp,POSTCALL);

	return 0;
}
