/*
 * $XFree86: xc/lib/Xrender/Composite.c,v 1.2 2000/08/28 02:43:13 tsi Exp $
 *
 * Copyright  2000 SuSE, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of SuSE not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  SuSE makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * SuSE DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL SuSE
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Author:  Keith Packard, SuSE, Inc.
 */

/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001,2003 NoMachine, http://www.nomachine.com.           */
/*                                                                        */
/* NXPROXY, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

#include "Xrenderint.h"

#undef NX_DEBUG_RENDER
                                                                                                                                                
#ifdef NX_DEBUG_RENDER
#include <stdio.h>
static int iFlagComposite  = 0;
#endif

void
XRenderComposite (Display   *dpy,
		  int	    op,
		  Picture   src,
		  Picture   mask,
		  Picture   dst,
		  int	    src_x,
		  int	    src_y,
		  int	    mask_x,
		  int	    mask_y,
		  int	    dst_x,
		  int	    dst_y,
		  unsigned int	width,
		  unsigned int	height)
{
    XExtDisplayInfo         *info = XRenderFindDisplay (dpy);
    xRenderCompositeReq	    *req;

#ifdef NX_DEBUG_RENDER
    if (!iFlagComposite)
    {
     fprintf(stderr,"Xrender library uses XRenderComposite cleanup libXrender.so.1.2-1.2.3-1-ROS3 \n");
     iFlagComposite = 1;
    }
#endif

    RenderSimpleCheckExtension (dpy, info);
    LockDisplay(dpy);
    GetReq(RenderComposite, req);
    req->reqType = info->codes->major_opcode;
    req->renderReqType = X_RenderComposite;
    req->op = (CARD8) op;
    req->pad1 = 0;
    req->pad2 = 0;
    req->src = src;
    req->mask = mask;
    req->dst = dst;
    req->xSrc = src_x;
    req->ySrc = src_y;
    req->xMask = mask_x;
    req->yMask = mask_y;
    req->xDst = dst_x;
    req->yDst = dst_y;
    req->width = width;
    req->height = height;
    UnlockDisplay(dpy);
    SyncHandle();
}
