/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001, 2004 NoMachine, http://www.nomachine.com.          */
/*                                                                        */
/* NXAGENT, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

/*

Copyright 1993 by Davor Matic

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation.  Davor Matic makes no representations about
the suitability of this software for any purpose.  It is provided "as
is" without express or implied warranty.

*/

#include "X.h"
#include "Xproto.h"
#include "screenint.h"
#include "input.h"
#include "misc.h"
#include "scrnintstr.h"
#include "windowstr.h"
#include "servermd.h"

#include "Agent.h"
#include "Handlers.h"
#include "Display.h"
#include "Events.h"
#include "Control.h"

/*
 * Set here the required log level.
 */

#define PANIC
#define WARNING
#define TEST
#undef  DEBUG


void nxagentBlockHandler(blockData, pTimeout, pReadMask)
     pointer blockData;
     pointer pTimeout;
     pointer pReadMask;
{
/*
GFPZR: This is to be optimized.
*/
  if (XEventsQueued(nxagentDisplay, QueuedAfterFlush))
  {
    nxagentDispatchEvents();
  }

  if (nxagentCongestion)
  {
    nxagentCongestionHandler();
  }
  else
  {
    nxagentWakeupByDecongestion();
  }
}

void nxagentWakeupHandler(result, pReadMask)
     int result;
     pointer pReadMask;
{
/*
GFPZR: This is to be optimized.
*/
  if (XEventsQueued(nxagentDisplay, QueuedAfterReading))
  {
    nxagentDispatchEvents();
  }

  if (nxagentCongestion)
  {
    nxagentCongestionHandler();
  }
  else
  {
    nxagentWakeupByDecongestion();
  }
}

/*
 * Wait until all events have been processed
 * and the proxy link is out of congestion
 * state.
 */

void nxagentCongestionHandler()
{
  XEvent event;

  do
  {
    /*
     * Read any available event.
     */

    if (XEventsQueued(nxagentDisplay, QueuedAlready))
    {
      nxagentDispatchEvents();
    }

    /*
     * If after having read any pending event
     * we are still in congestion state then
     * block waiting for the decongestion.
     */

    if (nxagentCongestion)
    {
      XPeekEvent(nxagentDisplay, &event);
    }
  }
  while (nxagentCongestion);

  nxagentWakeupByDecongestion();
}
