/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001, 2004 NoMachine, http://www.nomachine.com.          */
/*                                                                        */
/* NXAGENT, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

/*

Copyright 1993 by Davor Matic

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation.  Davor Matic makes no representations about
the suitability of this software for any purpose.  It is provided "as
is" without express or implied warranty.

*/

#include "X.h"
#include "Xproto.h"
#include "miscstruct.h"
#include "pixmapstr.h"
#include "scrnintstr.h"
#include "regionstr.h"
#include "gc.h"
#include "servermd.h"
#include "mi.h"

#include "../../fb/fb.h"

#include "Agent.h"

#include "Display.h"
#include "Screen.h"
#include "Pixmap.h"
#include "Trap.h"

#include "GC.h"
#include "GCOps.h"
#include "Drawable.h"
#include "Visual.h"
#include "Control.h"
#include NXAGENT_NXLIB_INCLUDE
#include NXAGENT_NXPACK_INCLUDE

RESTYPE  RT_NX_PIXMAP;

/*
 * Set here the required log level.
 */

#define PANIC
#define WARNING
#undef  TEST
#undef  DEBUG

/*
 * Force deallocation of the virtual pixmap.
 */

static Bool nxagentDestroyVirtualPixmap(PixmapPtr pPixmap);

/*
 * The following is just used for persistence.
 */

#ifdef NXAGENT_RECONNECT

extern int  nxagentPackMethod;
extern int  nxagentPackQuality;

Bool (*nxagentOldModifyPixmapHeader) (PixmapPtr, int, int, int, int, int, pointer);

#ifdef NXAGENT_STOPBIGREQ
extern Bool nxSleepByBigReq(ClientPtr);
extern Bool nxEndBigReq(ClientPtr);
#endif

/*
 * FIXME: Should be GC. Just want to avoid
 * conflicts with internal definition of GC.
 */

#if 0
static XlibGC nxagentMakeTempGC(PixmapPtr);
static Bool nxagentFreeTempGC(void);
#endif

/*
 * These are temporarily here. Changes must be
 * merged back into the original functions.
 */

static Bool nxagentReConnectPutImage(DrawablePtr, XlibGC, int, int, int, int, int, int, int, char*);
static Bool nxagentReConnectSplitImage(PixmapPtr, XlibGC);

#endif /* NXAGENT_RECONNECT */

int nxagentPixmapPrivateIndex;

#ifdef NXAGENT_MVFB
extern Bool nxagentTrue24;
#endif

PixmapPtr nxagentCreatePixmap(pScreen, width, height, depth)
    ScreenPtr   pScreen;
    int         width;
    int         height;
    int         depth;
{
  nxagentPrivPixmapPtr pPixmapPriv;

  PixmapPtr pPixmap;
  PixmapPtr pVirtual;

  /*
   * Create the pixmap structure but do
   * not allocate memory for the data.
   */

  pPixmap = AllocatePixmap(pScreen, 0);

  if (!pPixmap)
  {
    #ifdef WARNING
    fprintf(stderr, "nxagentCreatePixmap: WARNING! Failed to create pixmap with "
                "width [%d] height [%d] depth [%d].\n", width, height, depth);
    #endif

    return NullPixmap;
  }

  /*
   * Initialize the core members.
   */

  pPixmap -> drawable.type = DRAWABLE_PIXMAP;
  pPixmap -> drawable.class = 0;
  pPixmap -> drawable.pScreen = pScreen;
  pPixmap -> drawable.depth = depth;
  pPixmap -> drawable.bitsPerPixel = BitsPerPixel(depth);
  pPixmap -> drawable.id = 0;
  pPixmap -> drawable.serialNumber = NEXT_SERIAL_NUMBER;
  pPixmap -> drawable.x = 0;
  pPixmap -> drawable.y = 0;
  pPixmap -> drawable.width = width;
  pPixmap -> drawable.height = height;
/*
GFPZR

  pPixmap -> devKind = PixmapBytePad(pPixmap->drawable.width, pPixmap->drawable.depth);
*/
  pPixmap -> devKind = 0;
  pPixmap -> refcnt = 1;
  pPixmap -> devPrivate.ptr = NULL;

/*
GFPZR: Can't really understand what this is used for.
       This seems to be taken from the fb code but
       we dont use the devPrivate.
*/
/*
  {
    int adjust, base;
    base = pScreen->totalPixmapSize;
    adjust = 0;
    if (base & 7)
        adjust = 8 - (base & 7);
    pPixmap->devPrivate.ptr = (pointer) ((char *)pPixmap + base + adjust);
  }
*/

  /*
   * Create the pixmap in the virtual framebuffer.
   */

  pVirtual = fbCreatePixmap(pScreen, width, height, depth);

  /*
   * Initialize the privates of the real picture.
   */

  pPixmapPriv = nxagentPixmapPriv(pPixmap);

  pPixmapPriv -> isVirtual = False;

  if (width && height)
  {
    pPixmapPriv -> id = XCreatePixmap(nxagentDisplay,
                                      nxagentDefaultWindows[pScreen -> myNum],
                                      width, height, depth);
  }
  else
  {
/*
GFPZR: It seems that a pixmap with 0 width and height
       is created at the beginning.
*/
    pPixmapPriv -> id = 0;
  }

  pPixmapPriv -> mid = FakeClientID(0);

  AddResource(pPixmapPriv -> mid, RT_NX_PIXMAP, pPixmap);

  pPixmapPriv -> pRealPixmap = pPixmap;
  pPixmapPriv -> pVirtualPixmap = pVirtual;
  pPixmapPriv -> pPicture = NULL;

  /*
   * Check that the virtual pixmap is created with
   * the appropriate bits-per-plane, otherwise free
   * everything and return.
   */

  if (pVirtual == NULL)
  {
    #ifdef PANIC
    fprintf(stderr, "nxagentCreatePixmap: PANIC! Failed to create virtual pixmap with "
                "width [%d] height [%d] depth [%d].\n", width, height, depth);
    #endif

    nxagentDestroyPixmap(pPixmap);

    return NullPixmap;
  }
  else if (pVirtual -> drawable.bitsPerPixel == 0)
  {
    #ifdef WARNING

    fprintf(stderr, "nxagentCreatePixmap: WARNING! Virtual pixmap at [%p] has invalid "
                "bits per pixel.\n", (void *) pVirtual);

    fprintf(stderr, "nxagentCreatePixmap: WARNING! Real pixmap created with width [%d] "
                "height [%d] depth [%d] bits per pixel [%d].\n", pPixmap -> drawable.width,
                    pPixmap -> drawable.height = height, pPixmap -> drawable.depth,
                        pPixmap -> drawable.bitsPerPixel);

    #endif

    if (!nxagentRenderTrap)
    {
      fprintf(stderr, "Warning: Disabling render extension due to missing pixmap format.\n");

      nxagentRenderTrap = 1;
    }

    nxagentDestroyPixmap(pPixmap);

    return NullPixmap;
  }

  /*
   * Initialize the privates of the virtual picture. We
   * could avoid to use a flag and just check the pointer
   * to the virtual pixmap that, if the pixmap is actually
   * virtual, will be NULL. Unfortunately the flag can be
   * changed in nxagentValidateGC(). That code, probably,
   * can be removed in future.
   */

  nxagentPixmapPriv(pVirtual) -> isVirtual = True;

  /*
   * We might distinguish real and virtual pixmaps by
   * checking the pointers to pVirtualPixmap. We should
   * also remove the copy of id and use the one of the
   * real pixmap.
   */
   
  nxagentPixmapPriv(pVirtual) -> id = pPixmapPriv -> id;
  nxagentPixmapPriv(pVirtual) -> mid = 0;

/*
GFPZR: Setting this to NULL yields the following error,
       so Render.c is the next place to cleanup.

==9923== Invalid read of size 4
==9923==    at 0x80960BB: nxagentCreatePicture (Render.c:205)
==9923==    by 0x8066016: ProcRenderCreatePicture (NXrender.c:674)
==9923==    by 0x8068E07: ProcRenderDispatch (NXrender.c:2015)
==9923==    by 0x805553F: Dispatch (NXdispatch.c:983)
==9923==    by 0x80780AF: main (main.c:435)
==9923==    by 0x4035AA46: __libc_start_main (in /lib/libc-2.3.2.so)
==9923==    by 0x804DB24: ??? (start.S:81)
==9923==    Address 0x24 is not stack'd, malloc'd or free'd
*/
  /*
   * Storing a pointer back to the real pixmap is
   * silly. Unfortunately this is the way it has
   * been originally implemented. See also the
   * comment in destroy of the pixmap.
   */

  nxagentPixmapPriv(pVirtual) -> pRealPixmap = pPixmap;
  nxagentPixmapPriv(pVirtual) -> pVirtualPixmap = NULL;
  nxagentPixmapPriv(pVirtual) -> pPicture = NULL;

  #ifdef TEST
  fprintf(stderr, "nxagentCreatePixmap: Created pixmap at [%p] virtual at [%p] with width [%d] "
              "height [%d] depth [%d].\n", (void *) pPixmap, (void *) pVirtual,
                  width, height, depth);
  #endif

  return pPixmap;
}

Bool nxagentDestroyPixmap(pPixmap)
     PixmapPtr pPixmap;
{
  PixmapPtr pVirtual;

  nxagentPrivPixmapPtr pPixmapPriv;

  if (!pPixmap)
  {
    #ifdef PANIC
    fprintf(stderr, "nxagentDestroyPixmap: PANIC! Invalid attempt to destroy "
                "a null pixmap pointer.\n");
    #endif

    return False;
  }

  pPixmapPriv = nxagentPixmapPriv(pPixmap);

  pVirtual = pPixmapPriv -> pVirtualPixmap;

  #ifdef TEST
  fprintf(stderr, "\nnxagentDestroyPixmap: Destroying pixmap at [%p] with virtual at [%p].\n",
              (void *) pPixmap, (void *) pVirtual);
  #endif

  if (pPixmapPriv -> isVirtual)
  {
    int refcnt;

    /*
     * For some pixmaps we receive the destroy only for the
     * virtual. Infact to draw in the framebuffer we can use
     * the virtual pixmap instead of the pointer to the real
     * one. As the virtual pixmap can collect references, we
     * must transfer those references to the real pixmap so
     * we can continue as the destroy had been requested for
     * it.
     */

    pVirtual = pPixmap;
    pPixmap  = pPixmapPriv -> pRealPixmap;

    pPixmapPriv = nxagentPixmapPriv(pPixmap);

    /*
     * Move the references accumulated by the virtual
     * pixmap into the references of the real one.
     */

    refcnt = pVirtual -> refcnt - 1;

    #ifdef TEST
    fprintf(stderr, "nxagentDestroyPixmap: Adding [%d] references to pixmap at [%p].\n",
                refcnt, (void *) pPixmap);
    #endif

    pPixmap -> refcnt += refcnt;

    pVirtual -> refcnt -= refcnt;
  }

  #ifdef TEST
  fprintf(stderr, "nxagentDestroyPixmap: Pixmap has counter [%d] virtual pixmap [%d].\n",
              pPixmap -> refcnt, pVirtual -> refcnt);
  #endif

  --pPixmap -> refcnt;

  #ifdef TEST

  fprintf(stderr, "nxagentDestroyPixmap: Pixmap has now counter [%d] virtual pixmap has [%d].\n",
              pPixmap -> refcnt, pVirtual -> refcnt);

  if (pVirtual -> refcnt != 1)
  {
    fprintf(stderr, "nxagentDestroyPixmap: PANIC! Virtual pixmap does not have references equal to 1.\n");
  }

  #endif

  if (pPixmap -> refcnt)
  {
    return True;
  }

  #ifdef TEST
  fprintf(stderr, "nxagentDestroyPixmap: Managing to destroy the pixmap at [%p]\n",
              (void *) pPixmap);
  #endif

  nxagentDestroyVirtualPixmap(pPixmap);

  /*
   * It seems that a pixmap with 0 width and height
   * is created at the beginning. The id is not
   * assigned in this case.
   */

  if (pPixmapPriv -> id)
  {
    XFreePixmap(nxagentDisplay, pPixmapPriv -> id);
  }

  if (pPixmapPriv -> mid)
  {
    FreeResource(pPixmapPriv -> mid, RT_NONE);
  }

  xfree(pPixmap);

  return True;
}

Bool nxagentDestroyVirtualPixmap(PixmapPtr pPixmap)
{
  PixmapPtr pVirtual;

  pVirtual = nxagentPixmapPriv(pPixmap) -> pVirtualPixmap;

  /*
   * Force the routine to get rid of the virtual
   * pixmap.
   */

  if (pVirtual)
  {
    pVirtual -> refcnt = 1;

    fbDestroyPixmap(pVirtual);
  }

  return True;
}

RegionPtr nxagentPixmapToRegion(pPixmap)
     PixmapPtr pPixmap;
{
  XImage *ximage;
  register RegionPtr pReg, pTmpReg;
  register int x, y;
  unsigned long previousPixel, currentPixel;
  BoxRec Box;
  Bool overlap;

#ifdef NXAGENT_MVFB_DEBUG
  fprintf(stderr, "PixmapToRegion: Pixmap = [%lx] nxagentVirtualPixmap = [%lx]\n",pPixmap,nxagentVirtualPixmap(pPixmap));
#endif

#ifdef NXAGENT_MVFB

  return fbPixmapToRegion(nxagentVirtualPixmap(pPixmap));

#endif

  ximage = XGetImage(nxagentDisplay, nxagentPixmap(pPixmap), 0, 0,
                     pPixmap->drawable.width, pPixmap->drawable.height,
                     1, XYPixmap);

  pReg = REGION_CREATE(pPixmap->drawable.pScreen, NULL, 1);
  pTmpReg = REGION_CREATE(pPixmap->drawable.pScreen, NULL, 1);
  if (!pReg || !pTmpReg) return NullRegion;

  for (y = 0; y < pPixmap->drawable.height; y++) {
    Box.y1 = y;
    Box.y2 = y + 1;
    previousPixel = 0L;
    for (x = 0; x < pPixmap->drawable.width; x++)
    {
      currentPixel = XGetPixel(ximage, x, y);
      if (previousPixel != currentPixel) {
        if (previousPixel == 0L) {
          /* left edge */
          Box.x1 = x;
        }
        else if (currentPixel == 0L) {
          /* right edge */
          Box.x2 = x;
          REGION_RESET(pPixmap->drawable.pScreen, pTmpReg, &Box);
          REGION_APPEND(pPixmap->drawable.pScreen, pReg, pTmpReg);
        }
        previousPixel = currentPixel;
      }
    }
    if (previousPixel != 0L) {
      /* right edge because of the end of pixmap */
      Box.x2 = pPixmap->drawable.width;
      REGION_RESET(pPixmap->drawable.pScreen, pTmpReg, &Box);
      REGION_APPEND(pPixmap->drawable.pScreen, pReg, pTmpReg);
    }
  }

  REGION_DESTROY(pPixmap->drawable.pScreen, pTmpReg);

  XDestroyImage(ximage);

  REGION_VALIDATE(pPixmap->drawable.pScreen, pReg, &overlap);

  return(pReg);
}

Bool nxagentModifyPixmapHeader(pPixmap, width, height, depth,
                                   bitsPerPixel, devKind, pPixData)
    PixmapPtr pPixmap;
    int       width;
    int       height;
    int       depth;
    int       bitsPerPixel;
    int       devKind;
    pointer   pPixData;
{
  PixmapPtr pVirtualPixmap;

  /*
   * See miModifyPixmapHeader() in miscrinit.c. This
   * function is used to recycle the scratch pixmap
   * for this screen. We let it refer to the virtual
   * pixmap.
   */

  if (!pPixmap)
  {
    return False;
  }

  if (nxagentPixmapIsVirtual(pPixmap))
  {
    #ifdef PANIC
    fprintf(stderr, "nxagentModifyPixmapHeader: PANIC! Pixmap at [%p] is virtual.\n",
                (void *) pPixmap);
    #endif

    FatalError("nxagentModifyPixmapHeader: PANIC! Pixmap is virtual.");
  }

  pVirtualPixmap = nxagentVirtualPixmap(pPixmap);

  #ifdef TEST
  fprintf(stderr, "nxagentModifyPixmapHeader: Pixmap has width [%d] height [%d] depth [%d] "
              "bits-per-pixel [%d] devKind [%d] pPixData [%p].\n", pPixmap->drawable.width,
                  pPixmap->drawable.height, pPixmap->drawable.depth, pPixmap->drawable.bitsPerPixel,
                      pPixmap->devKind, (void *) pPixmap->devPrivate.ptr);

  fprintf(stderr, "nxagentModifyPixmapHeader: New parameters are width [%d] height [%d] depth [%d] "
              "bits-per-pixel [%d] devKind [%d] pPixData [%p].\n", width, height, depth,
                  bitsPerPixel, devKind, (void *) pPixData);
  #endif

  if ((width > 0) && (height > 0) && (depth > 0) &&
          (bitsPerPixel > 0) && (devKind > 0) && pPixData)
  {
    pPixmap->drawable.depth = depth;
    pPixmap->drawable.bitsPerPixel = bitsPerPixel;
    pPixmap->drawable.id = 0;
    pPixmap->drawable.serialNumber = NEXT_SERIAL_NUMBER;
    pPixmap->drawable.x = 0;
    pPixmap->drawable.y = 0;
    pPixmap->drawable.width = width;
    pPixmap->drawable.height = height;
    pPixmap->devKind = devKind;
    pPixmap->refcnt = 1;
    pPixmap->devPrivate.ptr = pPixData;

    pVirtualPixmap->drawable.depth = depth;
    pVirtualPixmap->drawable.bitsPerPixel = bitsPerPixel;
    pVirtualPixmap->drawable.id = 0;
    pVirtualPixmap->drawable.serialNumber = NEXT_SERIAL_NUMBER;
    pVirtualPixmap->drawable.x = 0;
    pVirtualPixmap->drawable.y = 0;
    pVirtualPixmap->drawable.width = width;
    pVirtualPixmap->drawable.height = height;
    pVirtualPixmap->devKind = devKind;
    pVirtualPixmap->refcnt = 1;
    pVirtualPixmap->devPrivate.ptr = pPixData;
  }
  else
  {
    if (width > 0)
        pPixmap->drawable.width = width;

    if (height > 0)
        pPixmap->drawable.height = height;

    if (depth > 0)
        pPixmap->drawable.depth = depth;

    if (bitsPerPixel > 0)
        pPixmap->drawable.bitsPerPixel = bitsPerPixel;
    else if ((bitsPerPixel < 0) && (depth > 0))
        pPixmap->drawable.bitsPerPixel = BitsPerPixel(depth);

    if (devKind > 0)
        pPixmap->devKind = devKind;
    else if ((devKind < 0) && ((width > 0) || (depth > 0)))
        pPixmap->devKind = PixmapBytePad(pPixmap->drawable.width,
            pPixmap->drawable.depth);

    if (pPixData)
        pVirtualPixmap->devPrivate.ptr = pPixData;

    if (width > 0)
        pVirtualPixmap->drawable.width = width;

    if (height > 0)
        pVirtualPixmap->drawable.height = height;

    if (depth > 0)
        pVirtualPixmap->drawable.depth = depth;

    if (bitsPerPixel > 0)
        pVirtualPixmap->drawable.bitsPerPixel = bitsPerPixel;
    else if ((bitsPerPixel < 0) && (depth > 0))
        pVirtualPixmap->drawable.bitsPerPixel = BitsPerPixel(depth);

    if (devKind > 0)
        pVirtualPixmap->devKind = devKind;
    else if ((devKind < 0) && ((width > 0) || (depth > 0)))
        pVirtualPixmap->devKind = PixmapBytePad(pVirtualPixmap->drawable.width,
            pVirtualPixmap->drawable.depth);

    if (pPixData)
        pVirtualPixmap->devPrivate.ptr = pPixData;

    #ifdef PANIC

    if (pPixmap->drawable.x != 0 || pPixmap->drawable.y != 0)
    {
      fprintf(stderr, "nxagentModifyPixmapHeader: PANIC! Pixmap at [%p] has x [%d] and y [%d].\n",
                  (void *) pPixmap, pPixmap->drawable.x, pPixmap->drawable.y);

      FatalError("nxagentModifyPixmapHeader: PANIC! Pixmap has x or y greater than zero.");
    }

    #endif

    /*
     * This is a quick patch intended to solve the problem of the
     * clipped glyphs drawn in the virtual frame buffer. We should
     * better investigate why pixmaps are requested with a size
     * smaller than actually required. Note that the buffer seems
     * to be never accessed beyond its boundary. This means that
     * the memory for the glyph is allocated using the right size.
     */

    pPixmap->drawable.height *= 4;
    pPixmap->drawable.width  *= 4;

    pVirtualPixmap->drawable.height *= 4;
    pVirtualPixmap->drawable.width  *= 4;
  }

  return True;
}

/*
 * Slightly modified image stuff. It takes in
 * account size of images exceeding the 262144
 * limit.
 */

static Bool nxagentReConnectSplitImage(pPixmap, gc)
  PixmapPtr pPixmap;
  XlibGC      gc;
{
  Bool success = True;
  unsigned int         format, width, height, paddedWidth, lenght, x, y, numOfSplit;
  char        *data;
  unsigned long planemask = 0xFFFFFFFF;
  int i;

  if (pPixmap -> drawable.depth == 1)
          format = XYPixmap;
  else
          format = ZPixmap;

  paddedWidth = PixmapBytePad(pPixmap -> drawable.width, pPixmap -> drawable.depth);
  lenght = paddedWidth * pPixmap -> drawable.height;
    
  width = pPixmap -> drawable.width;
  height = MIN(NXAGENT_MAX_REQUEST_EFF_SIZE, lenght) / paddedWidth;
  numOfSplit = pPixmap -> drawable.height / height;
  if (pPixmap -> drawable.height % height)
    numOfSplit++;
  x = 0;
  y = 0;

#ifdef NXAGENT_RECONNECT_PIXMAP_DEBUG
  fprintf(stderr, "nxagentReConnectSplitImage: splitting image of data size %d in %d parts\n", 
                  lenght, numOfSplit);
#endif

  data = xalloc(paddedWidth * height);
  if (!data)
  {
    fprintf(stderr, "nxagentReConnectSplitImage: xalloc failed\n");
    return 0;
  }


  for(i = 0; (i < numOfSplit) && success; i++)
  {
    if (i == numOfSplit - 1)
    {
      height = pPixmap -> drawable.height - y;
    }

    fbGetImage((DrawablePtr)nxagentVirtualPixmap(pPixmap),
                x,
                y,
                width,
                height,
                format,
                planemask,
                data);
 
    success = nxagentReConnectPutImage((DrawablePtr)pPixmap,
                                       gc,
                                       pPixmap -> drawable.depth,
                                       x, y,
                                       width, height,
                                       0,
                                       format,
                                       data);
    y += height;
  }

  xfree(data);

  return success;  
}
 
static Bool nxagentReConnectPutImage(pDrawable, gc, depth, x, y, w, h, leftPad, format, data)
  DrawablePtr pDrawable;
  XlibGC      gc;
  int         depth, x, y, w, h;
  int         leftPad;
  int         format;
  char        *data;
{

  NXPackedImage *packedImage = NULL;
  XImage        *ximage        = NULL;
  unsigned char *md5           = NULL;
  unsigned int  localPackMethod = 0;
  int           geometrySet = 0;

  if (nxImageCacheStat < 0)
  {
    NXCacheInit(100);
  }

  ximage = XCreateImage(nxagentDisplay, nxagentDefaultVisual(pDrawable->pScreen),
                        depth, format, 
                        0 /* leftPad */,
                        (char *) data,
                        w, h, BitmapPad(nxagentDisplay),
                        (format == ZPixmap) ?
                        PixmapBytePad(w, depth) : BitmapBytePad(w+leftPad));

  if (!ximage) 
  {
    return False;
  }

  #ifdef DEBUG
  fprintf(stderr, "nxagentReConnectPutImage: w=%d h=%d depth=%d nxagentPackQuality=%d image count is [%d]\n",
              w, h, depth, nxagentPackQuality, ++image_count);
  #endif

  /*
   * We got image data from the X client with our
   * own endianess while the ximage was initialized
   * with the endianess of the remote display. Fix
   * the ximage structure to carry to appropriate
   * flags.
   */

  nxagentSetImageFormat(ximage);

  /*
   * Always clean the image to ensure that caching
   * algorithms will be able to find imges that are
   * equal but don't clean pixmaps that are used in
   * conjunction with render extension and make use
   * use of the alpha channel.
   */

  if (nxagentDrawablePicture(pDrawable) == NULL)
  {
    NXCleanInPlaceImage(ximage);
  }
  else if ((pDrawable)->type == DRAWABLE_WINDOW)
  {
    NXCleanInPlaceImage(ximage);
  }

  /*
   * Do not apply packing to 1 bpp bitmaps.
   */

  if (depth != 1)
  {
    if (nxImageCacheStat > 0)
    {
      packedImage = NXCacheFindImage(ximage, &localPackMethod, &md5);

      if (packedImage != NULL)
      {
        /*
         * Note that this is likely to use the 'default'
         * unpack geometry as set in Args.c.
         */

        NXPutPackedImage(nxagentDisplay, 0, nxagentDrawable(pDrawable), gc,
                          packedImage, localPackMethod, depth,
                          0, 0, x, y, w, h);

        #ifdef DEBUG
        fprintf(stderr, "nxagentReConnectPutImage: Calling NXPutPackedImage(%s) size is [%d x %d] data size is [%d]\n",
                    (localPackMethod >= PACK_PNG_8_COLORS && localPackMethod <= PACK_PNG_16M_COLORS) ? "PNG" : "JPEG",
                        ximage -> width, ximage -> height, packedImage -> xoffset);
        #endif

        XFree(ximage);

        return True;
      }
    }

    localPackMethod = nxagentPackMethod;

    if (localPackMethod > 0 &&
            (localPackMethod > PACK_TIGHT_16M_COLORS ||
                 localPackMethod < PACK_TIGHT_8_COLORS))
    {
      /*
       * FIXME: for we decide here later probably we will move
       * to another place -> to separate function
       */

      if (localPackMethod >= PACK_JPEG_8_COLORS &&
              localPackMethod <= PACK_JPEG_16M_COLORS)
      {
        #ifdef DEBUG
        fprintf(stderr, "nxagentReConnectPutImage: encodingJpeg forced by command line parameter\n");
        #endif

        localPackMethod = PACK_JPEG_16M_COLORS;

        packedImage = NXEncodeJpeg(ximage, localPackMethod, nxagentPackQuality);
      }
      else if (localPackMethod >= PACK_PNG_8_COLORS &&
                   localPackMethod <= PACK_PNG_16M_COLORS)
      {
        #ifdef DEBUG
        fprintf(stderr, "nxagentReConnectPutImage: encodingPng forced by command line parameter\n");
        #endif

        localPackMethod = PACK_PNG_16M_COLORS;

        /*
         * packedImage = NXDynamicPngPack(ximage,localPackMethod,NULL);
         */

        packedImage = NXEncodePng(ximage, localPackMethod , NULL);
      }
      else if (localPackMethod >= PACK_PNG_JPEG_8_COLORS &&
                   PACK_PNG_JPEG_16M_COLORS)
      {
        #ifdef DEBUG
        fprintf(stderr, "nxagentReConnectPutImage: Not executing deperecated NXDynamicSelectPackMethod().\n");
        #endif

        /*
         * packedImage = NXDynamicSelectPackMethod(ximage, &localPackMethod, nxagentPackQuality);
         */
      }
    }
  }

  if (packedImage != NULL &&
          (localPackMethod < PACK_TIGHT_8_COLORS ||
               localPackMethod > PACK_TIGHT_16M_COLORS))
  {
    if (geometrySet == 0)
    {
      /*
       * Set the 'default' unpack geometry.
       */

      NXSetUnpackGeometry(nxagentDisplay, 0, (Screen *) pDrawable->pScreen,
                              nxagentDefaultVisual(pDrawable->pScreen));
      geometrySet = 1;
    }

    #ifdef DEBUG
    fprintf(stderr, "nxagentReConnectPutImage: Calling NXPutPackedImage(%s) size is [%d x %d] data size is [%d]\n",
                (localPackMethod >= PACK_PNG_8_COLORS && localPackMethod <= PACK_PNG_16M_COLORS) ? "PNG" : "JPEG",
                     ximage->width, ximage->height, packedImage->xoffset);
    #endif

    NXPutPackedImage(nxagentDisplay, 0, nxagentDrawable(pDrawable), gc,
                         packedImage, localPackMethod, depth,
                             0, 0, x, y, w, h);
  }
  else if (localPackMethod >= PACK_TIGHT_8_COLORS &&
               localPackMethod <= PACK_TIGHT_16M_COLORS)
  {
    if (geometrySet == 0)
    {
      /*
       * Set the 'default' unpack geometry.
       */

      NXSetUnpackGeometry(nxagentDisplay, 0, (Screen *) pDrawable->pScreen,
                              nxagentDefaultVisual(pDrawable->pScreen));

      geometrySet = 1;
    }

    NXEncodeTight(nxagentDisplay, nxagentDrawable(pDrawable), nxagentDefaultVisual(pDrawable->pScreen),
                      gc, ximage, localPackMethod, 0, 0, x, y, w, h);

    #ifdef DEBUG
    fprintf(stderr, "nxagentReConnectPutImage: Calling NXPutPackedImage(TIGHT) size is [%d x %d] data size is [%d]\n",
              ximage->width, ximage->height, packedImage->xoffset);
    #endif

    NXPutPackedImage(nxagentDisplay, 0, nxagentDrawable(pDrawable), gc,
                         packedImage, localPackMethod, depth,
                             0, 0, x, y, w, h);
  }
  else if (packedImage == NULL)
  {
    #ifdef DEBUG
    fprintf(stderr, "nxagentReConnectPutImage: Calling XPutImage, size is [%d x %d] data size is [%d]\n",
                ximage->width, ximage->height, ximage->bytes_per_line * ximage->height);
    #endif

    XPutImage(nxagentDisplay, nxagentDrawable(pDrawable), gc,
                  ximage, 0, 0, x, y, w, h);
  }

  if (packedImage)
  {
    if (nxImageCacheStat > 0 && md5 != NULL)
    {
      NXCacheAddImage(packedImage, localPackMethod, md5);
    }

    XFree(packedImage);
  }
  else
  {
    if (md5 != NULL)
    {
      XFree(md5);
    }
  }

  XFree(ximage);

  return True;
}

#ifdef NXAGENT_RECONNECT

/*
 * Reconnection stuff.
 */

int nxagentDestroyNewPixmapResourceType(pointer p, XID id)
{
  /*
   * Address of the destructor is set in Init.c.
   */

  #ifdef TEST
  fprintf(stderr, "nxagentDestroyNewPixmapResourceType: Destroying mirror id [%ld] for pixmap at [%p].\n",
              nxagentPixmapPriv((PixmapPtr) p) -> mid, (void *) p);
  #endif

  nxagentPixmapPriv((PixmapPtr) p) -> mid = None;

  return True;
}

void nxagentDisconnectPixmap(void *p0, XID x1, void* p2)
{
  PixmapPtr pPixmap = (PixmapPtr) p0;

  Bool *pBool;

  pBool = (Bool*) p2;

  #ifdef TEST
  fprintf(stderr, "nxagentDisconnectPixmap: Called with bool [%d] and pixmap at [%p].\n",
              *pBool, (void *) pPixmap);

  fprintf(stderr, "nxagentDisconnectPixmap: Virtual pixmap is [%ld].\n",
              nxagentPixmap(pPixmap));
  #endif

  nxagentPixmap(pPixmap) = None;
}

Bool nxagentDisconnectPixmaps(void)
{
  Bool r;
  int i;

  #ifdef TEST
  fprintf(stderr, "nxagentDisconnectPixmaps: Going to iterate through pixmap resources.\n");
  #endif

  for (i = 0, r = 1; i < MAXCLIENTS; r = 1, i++)
  {
    if (clients[i])
    {
      FindClientResourcesByType(clients[i], RT_NX_PIXMAP,
                                    nxagentDisconnectPixmap, &r);

      #ifdef WARNING

      if (r == False)
      {
        fprintf(stderr, "nxagentDisconnectPixmaps: WARNING! Failed to disconnect "
                    "pixmap for client [%d].\n", i);
      }

      #endif
    }
  }

  return True;
}

void nxagentReConnectPixmap(void *p0, XID x1, void *p2)
{
  PixmapPtr pPixmap = (PixmapPtr) p0;
  Bool *pBool = (Bool*) p2;

  XlibGC gc;

  extern ScreenPtr nxagentDummyScreen;

  nxagentPrivPixmapPtr pPixmapPriv;

  #ifdef TEST
  fprintf(stderr, "nxagentReConnectPixmap: Called with bool [%d] and pixmap at [%p].\n",
              *pBool, (void *) pPixmap);

  fprintf(stderr, "nxagentReConnectPixmap: Virtual pixmap is at [%p] picture is at [%p].\n",
              (void *) nxagentPixmapPriv(pPixmap) -> pVirtualPixmap,
                  (void *) nxagentPixmapPriv(pPixmap) -> pPicture);
  #endif

  if (!*pBool || !pPixmap)
  {
    return;
  }

  pPixmapPriv = nxagentPixmapPriv(pPixmap);

  #ifdef TEST
  fprintf(stderr, "nxagentReConnectPixmap: 1.\n");
  #endif

  if (pPixmap -> drawable.width && pPixmap -> drawable.height)
  {
    #ifdef TEST
    fprintf(stderr, "nxagentReConnectPixmap: 2.\n");
    #endif

    pPixmapPriv -> id = XCreatePixmap(nxagentDisplay,
                                      nxagentDefaultWindows[pPixmap -> drawable.pScreen -> myNum],
                                      pPixmap -> drawable.width,
                                      pPixmap -> drawable.height,
                                      pPixmap -> drawable.depth);

    nxagentPixmap(pPixmapPriv -> pVirtualPixmap) = pPixmapPriv -> id;

    #ifdef TEST
    fprintf(stderr, "nxagentReConnectPixmap: Created virtual pixmap with id [%ld] for pixmap at [%p].\n",
                nxagentPixmap(pPixmap), (void *) pPixmap);
    #endif

    if (pPixmap == (PixmapPtr) nxagentDummyScreen -> devPrivate)
    {
      #ifdef WARNING
      fprintf(stderr, "nxagentReConnectPixmap: WARNING! Pixmap is root screen. Returning.\n");
      #endif

      return;
    }

    #ifdef TEST
    fprintf(stderr, "nxagentReConnectPixmap: 3.\n");
    #endif

    /* 
     * FIXME: This is terribly slow to recreate a GC
     * for every pixmap reconnection but the routine
     * that cache them doesn't seem to work properly.
     *
     * gc = nxagentMakeTempGC(pPixmap);
     */

    gc = XCreateGC(nxagentDisplay, nxagentPixmap(pPixmap), 0, NULL);

    if (gc == NULL)
    {
      #ifdef PANIC
      fprintf(stderr, "nxagentReConnectPixmap: PANIC! Failed to create the temporary GC. Returning.\n");
      #endif

      *pBool = False;

      return;
    }
    
    #ifdef TEST
    fprintf(stderr, "nxagentReConnectPixmap: 4.\n");
    #endif

    *pBool = nxagentReConnectSplitImage(pPixmap, gc);

    XFreeGC(nxagentDisplay, gc);

    if (!*pBool)
    {
      #ifdef PANIC
      fprintf(stderr, "nxagentReConnectPixmap: PANIC! Failed to execute the put image request.\n");
      #endif
    }

    #ifdef TEST
    fprintf(stderr, "nxagentReConnectPixmap: 5.\n");
    #endif
  }

  #ifdef TEST
  XSync(nxagentDisplay, False);
  #endif

  #ifdef TEST
  fprintf(stderr, "nxagentReConnectPixmap: 6.\n");
  #endif
}

Bool nxagentReCreatePixmaps(void *p0)
{
  ScreenPtr pScreen;

  int i;
  Bool r;

  #ifdef TEST
  fprintf(stderr, "nxagentReCreatePixmaps: Going to recreate all pixmaps.\n");
  #endif

  /*
   * Reset the geometry and alpha information
   * used by proxy to unpack the packed images.
   */

  nxagentResetVisualCache();

  nxagentResetAlphaCache();

  for (i = 0, r = 1; i < MAXCLIENTS; r = 1, i++)
  {
    if (clients[i])
    {
      FindClientResourcesByType(clients[i], RT_NX_PIXMAP,
                                    nxagentReConnectPixmap, &r);

      #ifdef WARNING

      if (r == False)
      {
        fprintf(stderr, "nxagentReCreatePixmaps: WARNING! Failed to recreate "
                    "pixmap for client [%d].\n", i);
      }

      #endif
    }
  }

  for (i = 0, r = 1; i < screenInfo.numScreens; r = 1, i++)
  {
    pScreen = screenInfo.screens[i];

    if (pScreen && pScreen -> pScratchPixmap)
    {
      nxagentReConnectPixmap(pScreen -> pScratchPixmap, 0, &r);

      #ifdef WARNING

      if (r == False)
      {
        fprintf(stderr, "nxagentReCreatePixmaps: WARNING! Failed to recreate "
                    "scratch pixmap for screen at [%p].\n", (void *) pScreen);
      }

      #endif
    }
  }

  /* 
   * FIXME: Look at the comment in nxagentReConnectPixmap().
   *
   * if (!nxagentFreeTempGC())
   * {
   *   fprintf(stderr, "nxagentRecreatePixmaps: free of temporary GCs failed\n");
   * }
   */

  return True;
}

#endif /* NXAGENT_RECONNECT */

/*
 * This code is not compiled in.
 */

#if 0

/* 
 * TODO: This 2 function implement a temporany cache
 *       during reconnection time, in order not to 
 *       create a GC for every XCreatePixmap, but they have some problems.
 *       Fix them!.
 */

typedef struct GC_array{
  int depth;
  XlibGC gc;
}GC_array;

GC_array *GC_array_ptr;
int      GC_array_size = 0;

static XlibGC nxagentMakeTempGC(PixmapPtr pPixmap)
{
  int i;

  for(i = 0; i < GC_array_size; i++)
      if (pPixmap->drawable.depth == GC_array_ptr[i].depth)
        return GC_array_ptr[i].gc;

  GC_array_ptr = xrealloc(GC_array_ptr, (GC_array_size + 1) * sizeof(GC_array));

  if (!GC_array_ptr)
  {
    fprintf(stderr, "nxagentMakeGC: couldn't allocate memory to recreate Pixmaps\n");
    return NULL;
  }

  GC_array_size++;
  GC_array_ptr[GC_array_size - 1].depth = pPixmap->drawable.depth;
  GC_array_ptr[GC_array_size - 1].gc = XCreateGC(nxagentDisplay,
                                                 (Drawable) (pPixmapPriv -> id),
                                                 0,
                                                 NULL);

  return GC_array_ptr[GC_array_size - 1].gc;
}

static Bool nxagentFreeTempGC(void)
{
  int i;

  for(i = 0; i < GC_array_size; i++)
  {
    XFreeGC(nxagentDisplay, GC_array_ptr[i].gc);
  }

  xfree(GC_array_ptr);
  GC_array_ptr = NULL;
  GC_array_size = 0;

  return True;
}

#endif

