/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001, 2004 NoMachine, http://www.nomachine.com.          */
/*                                                                        */
/* NXAGENT, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

#include "Xutil.h"
#include "Xatom.h"
#include "Xlib.h"

#include "misc.h"
#include "scrnintstr.h"

#include "NXpack.h"

#include "Atoms.h"
#include "Display.h"
#include "Screen.h"
#include "Options.h"

/*
 * Set here the required log level.
 */

#define PANIC
#define WARNING
#undef  TEST
#undef  DEBUG

/*
 * These values should be moved in
 * the option repository.
 */

extern int nxagentRenderEnable;
extern int nxagentAlphaEnabled;
extern int nxagentPackMethod;

Atom nxagentAtoms[NXAGENT_NUMBER_OF_ATOMS];

char *nxagentAtomNames[NXAGENT_NUMBER_OF_ATOMS + 1] =
{
  "NX_IDENTITY",          /* 0  */
  "WM_PROTOCOLS",         /* 1  */
  "WM_DELETE_WINDOW",     /* 2  */
  "WM_NX_READY",          /* 3  */
  "MCOPGLOBALS",          /* 4  */
  "NX_CUT_BUFFER_SERVER", /* 5  */
  "TARGETS",              /* 6  */
  "TEXT",                 /* 7  */
  "NX_AGENT_SIGNATURE",   /* 8  */
  "NXDARWIN",             /* 9  */
  NULL
};

int nxagentInitAtoms(WindowPtr pWin)
{
  Atom atom;

  /*
   * Value of nxagentAtoms[8] is "NX_AGENT_SIGNATURE".
   *
   * We don't need to save the atom's value. It will
   * be checked by other agents to find if they are
   * run nested.
   */

  atom = MakeAtom(nxagentAtomNames[8], strlen(nxagentAtomNames[8]), 1);

  if (atom == None)
  {
    #ifdef PANIC
    fprintf(stderr, "nxagentInitAtoms: PANIC! Could not create [%s] atom.\n",
                nxagentAtomNames[8]);
    #endif

    return -1;
  }

  return 1;
}

int nxagentQueryAtoms(ScreenPtr pScreen)
{
  Atom identity;
  extern Atom nxagent_WM;


  int type[4] = { 1, 0, 85, 0 };

  #ifdef TEST

  int i;

  #endif

  #ifdef TEST
  fprintf(stderr, "nxagentQueryAtoms: Going to create intern atoms on real display.\n");
  #endif

  /*
   * Flag only-if-exists is false, so we'll always create
   * the atoms. The whole procedure by which atoms are
   * created and managed is clumsy and should be improved
   * in future versions. At the moment, anyway, it serves
   * the purpose of minimizing the number of round trips.
   */

  XInternAtoms(nxagentDisplay, nxagentAtomNames, NXAGENT_NUMBER_OF_ATOMS,
                   False, nxagentAtoms);

  /*
   * This is dirty but works:
   *
   * nxagentAtoms[0] is "NX_IDENTITY"
   * nxagentAtoms[1] is "WM_PROTOCOL"
   *
   * We are supposing that NX_IDENTITY has been created by
   * us, so we test whether WM_PROTOCOL is created right now
   * (and so its number is bigger than that of NX_IDENTITY)
   * or it already existed at the time XInternAtoms() was
   * called. That's a hack to check wether there is Window
   * manager running on the X server without using a further
   * round-trip.
   *
   * We need to know if there is a WM running. If this is
   * the case, we'll later activate the magic pixel so the
   * user will be able to minimize the simulated full-screen
   * window. If there is no WM, we shall avoid to unmap the
   * agent window or user will not be able to bring it back
   * on screen.
   *
   * In future we should move all these checks in another
   * function.
   */

  if (nxagentAtoms[1] > nxagentAtoms[0])
  {
    nxagent_WM = None;
  }
  else
  {
    nxagent_WM = nxagentAtoms[1];
  }

  /*
   * Value of nxagentAtoms[9] is "NXDARWIN".
   *
   * We check if it was created by the NX client.
   */

  if (nxagentAtoms[9] > nxagentAtoms[0])
  {
    nxagentAtoms[9] = None;
  }

  /*
   * Value of nxagentAtoms[8] is "NX_AGENT_SIGNATURE".
   *
   * This atom is created internally by the agent server at
   * startup to let other agents determine if they are run
   * nested. If agent is run nested, in fact, at the time it
   * will create the NX_AGENT_SIGNATURE atom on the real X
   * server it will find the existing atom with a value less
   * than any NX_IDENTITY created but itself.
   */

  if (nxagentAtoms[8] > nxagentAtoms[0])
  {
    nxagentAtoms[8] = None;
  }

  if (nxagentAtoms[8] != None)
  {
    /*
     * We are running nested in another agent server.
     */

    nxagentChangeOption(Nested, 1);

    /*
     * If the current pack method is JPEG, we could
     * disable the encoding to avoid the degradation
     * caused by multiple lossy encoding.
     *
     * fprintf(stderr, "Warning: Disabling use of packed images in nested mode.\n");
     *
     * nxagentPackMethod = NO_PACK;
     */
  }

  /*
   * This property is needed by NXWin. In the
   * previous versions there were 4 defines
   * with the following data:
   *
   * #define NXAGENT_SESSION 1
   * #define NXAGENT_MAJOR_VERSION   0
   * #define NXAGENT_MINOR_VERSION   85
   * #define NXAGENT_RELEASE 0
   */

  #ifdef TEST
  fprintf(stderr, "nxagentQueryAtoms: Going to change NX_IDENTITY property on real display.\n");
  #endif

  identity = nxagentAtoms[0]; /* NX_IDENTITY */

  XChangeProperty(nxagentDisplay,
                  nxagentDefaultWindows[pScreen->myNum],
                  identity,
                  XA_ATOM,
                  sizeof(int) * 8,
                  PropModeReplace,
                  (unsigned char *) &type,
                  4);

  #ifdef TEST

  for (i = 0; i < NXAGENT_NUMBER_OF_ATOMS; i++)
  {
    fprintf(stderr, "nxagentQueryAtoms: Created intern atom [%s] with id [%ld].\n",
                nxagentAtomNames[i], nxagentAtoms[i]);
  }

  #endif

  return 1;
}
