/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001, 2004 NoMachine, http://www.nomachine.com.          */
/*                                                                        */
/* NXAGENT, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

/*

Copyright 1993 by Davor Matic

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation.  Davor Matic makes no representations about
the suitability of this software for any purpose.  It is provided "as
is" without express or implied warranty.

*/

#include "X.h"
#include "Xproto.h"
#include "gcstruct.h"
#include "window.h"
#include "windowstr.h"
#include "pixmapstr.h"
#include "colormapst.h"
#include "scrnintstr.h"
#include "region.h"

#include "mi.h"

#include "Agent.h"

#include "Display.h"
#include "Screen.h"
#include "GC.h"
#include "Drawable.h"
#include "Color.h"
#include "Cursor.h"
#include "Visual.h"
#include "Events.h"
#include "Clipboard.h"
#include "Args.h"

#ifdef NXAGENT_BAKSTR
#include "Init.h"
#endif

#ifdef NXAGENT_VISIBILITY
#include NXAGENT_NXLIB_INCLUDE
#endif

#ifdef NXAGENT_SAFEMODE
extern int nxagentSafeMode;
#endif

int nxagentWindowPrivateIndex;

#ifdef NXAGENT_EXPOSURES
extern Bool nxagentAutoExposures;
#endif

#ifdef NXAGENT_REPARENT
WindowPtr nxagentRootWindow;
#endif

#ifdef NXAGENT_FORCEBACK
#include "Xatom.h"
#include "Window.h"
#endif

/*
 * Used to track nxagent window's visibility.
 */

int nxagentVisibility = VisibilityUnobscured;
unsigned long nxagentVisibilityTimeout = 0;
Bool nxagentVisibilityStop = False;

/*
 * Set here the required log level.
 */

#define PANIC
#define WARNING
#undef  TEST
#undef  DEBUG

/*
 * Used to walk through the window hierarchy
 * to find a window 
*/

typedef struct _WindowMatch
{
  WindowPtr pWin;
  Window    id;

} WindowMatchRec;

#ifdef NXAGENT_FORCEBACK

static char *blacklist[]=
{
    "mozilla",
    "Mozilla",
    NULL
};

extern Bool nxagentForceBackingStore;
extern unsigned long nxagentMaxAreaBackS;
extern unsigned long nxagentMinAreaBackS;
extern unsigned long nxagentMaxAreaBackS;
extern void nxagentSetBackingStore(WindowPtr, int);
extern void delbsQueue(WindowPtr pWin, nxbsQueuePtr pbsQueue);
extern nxbsQueuePtr pbsQueue;

#endif

#ifdef NXAGENT_LOGO

extern char isItTimeToYield;
extern WindowPtr nxagentRootTileWindow;
extern void nomachineLogo(GCPtr pGC, WindowPtr pWin);
extern void nomachineClearLogo(GCPtr pGC, WindowPtr pWin);

/*
 * Also referenced in Events.c.
 */

int nomachineLogoCount = 0;

#endif

#ifdef NXAGENT_FORCEBACK

void nxagentSetBackingStore(WindowPtr pWin, int BackingStore)
{
    XSetWindowAttributes att;
    unsigned long mask = 0;

    att.backing_store = BackingStore;
    if(nxagentWindowPriv(pWin)->is_blacklisted)
    {
        BackingStore = NotUseful;
    }
    mask |= CWBackingStore;
    XChangeWindowAttributes(
                            nxagentDisplay,
                            nxagentWindow(pWin),
                            mask,
                            &att
                           );
    nxagentWindowPriv(pWin)->b_stored = BackingStore;
    nxagentWindowPriv(pWin)->bs_time = BackingStore?GetTimeInMillis()+2000:0;
    /*
    pWin->backingStore = BackingStore;
    pWin->drawable.pScreen->ChangeWindowAttributes(pWin, mask);
    */
#ifdef NXAGENT_FORCEBACK_DEBUG
    fprintf(stderr,
            "nxagentSetBackingStore: %x %i\n",
            nxagentWindow(pWin),
            pWin->backingStore
           );
    /*
    if(pWin->backingStore != NotUseful){
        pWin->borderWidth = 2;
    }
    else
    {
        pWin->borderWidth = 0;
    }
    nxagentConfigureWindow(pWin, CWBorderWidth);
    */
#endif
}


void blacklistChild(WindowPtr pWin)
{
    register WindowPtr pChild, pHead;

    pHead = RealChildHead(pWin);

    for (pChild = pWin->lastChild; pChild != pHead; pChild = pChild->prevSib)
    {
        blacklistChild(pChild);
    }
    nxagentWindowPriv(pWin)->is_blacklisted = True;
}


void nxagentIsBlacklistedforBS(WindowPtr pWin)
{
    if (pWin)
    {
        int           iReturn;
        unsigned long ulReturnItems;
        unsigned long ulReturnBytesLeft;
        Atom          atomReturnType;
        int           iReturnFormat;
        unsigned char *pszReturnData = NULL;
        char          *name;

        if(!(nxagentWindowPriv(pWin)->is_blacklisted))
        {
#ifdef NXAGENT_FORCEBACK_DEBUG
            fprintf(stderr,
                    "nxagentIsBlacklistedforBS: startfrom here for %x\n",
                    nxagentWindow(pWin),
                   );
#endif
            if(!(nxagentWindowPriv(pWin->parent)->is_blacklisted))
            {
                extern int GetWindowProperty(WindowPtr, Atom, long, long, Bool, Atom, Atom*, int*,
                                             unsigned long*, unsigned long*, unsigned char**);

                iReturn = GetWindowProperty(pWin, XA_WM_NAME,0,0, False,
                                            AnyPropertyType, &atomReturnType, &iReturnFormat,
                                            &ulReturnItems, &ulReturnBytesLeft, &pszReturnData);

                if(!iReturn && ulReturnBytesLeft>0)
                {
                    iReturn = GetWindowProperty(pWin, XA_WM_NAME, 0, ulReturnBytesLeft, False,
                                                AnyPropertyType, &atomReturnType, &iReturnFormat,
                                                &ulReturnItems, &ulReturnBytesLeft, &pszReturnData);
                    if(pszReturnData)
                    {
                        name = (char*)xalloc(ulReturnItems+1);
                        if(name)
                        {
                            int i=0;

                            strncpy(name, (char *) pszReturnData, ulReturnItems);
                            name[ulReturnItems] = 0;
                            for(i = 0; blacklist[i]; i++)
                            {
                                if(strstr(name ,blacklist[i]))
                                {
#ifdef NXAGENT_FORCEBACK_DEBUG
                                    fprintf(stderr,
                                            "nxagentIsBlacklistedforBS: disabling for %x coz called mozilla\n",
                                            nxagentWindow(pWin)
                                           );
#endif
                                    blacklistChild(pWin);
                                    nxagentWindowPriv(pWin)->is_blacklisted = True;
                                    break;
                                }
                            }
                            xfree(name);
                        }
                    }
                }
            }
            else
            {
#ifdef NXAGENT_FORCEBACK_DEBUG
                fprintf(stderr, "nxagentIsBlacklistedforBS: disabling for %x coz moz is parent\n",
                        nxagentWindow(pWin)
                       );
#endif
                nxagentWindowPriv(pWin)->is_blacklisted = True;
            }
        }
    }
}
#endif

WindowPtr nxagentGetWindowFromID(Window id)
{
  WindowPtr pWin = WindowTable[0];

  while (pWin && nxagentWindowPriv(pWin))
  {
    if (nxagentWindow(pWin) == id)
    {
      return pWin;
    }

    if (pWin -> nextSib)
    {
      pWin = pWin -> nextSib;
    }
    else
    {
      pWin = pWin -> firstChild;
    }
  }

  return NULL;
}

static int nxagentFindWindowMatch(WindowPtr pWin, pointer ptr)
{
  WindowMatchRec *match = (WindowMatchRec *) ptr;

  if (match -> id == nxagentWindow(pWin))
  {
    match -> pWin = pWin;

    return WT_STOPWALKING;
  }
  else
  {
    return WT_WALKCHILDREN;
  }
}

WindowPtr nxagentWindowPtr(Window window)
{
  int i;

  WindowMatchRec match;

  match.pWin = NullWindow;
  match.id   = window;

  for (i = 0; i < nxagentNumScreens; i++)
  {
    WalkTree(screenInfo.screens[i], nxagentFindWindowMatch, (pointer) &match);

    if (match.pWin) break;
  }

  return match.pWin;
}

Bool nxagentCreateWindow(pWin)
     WindowPtr pWin;
{
  unsigned long mask;
  XSetWindowAttributes attributes;
  Visual *visual;
  ColormapPtr pCmap;

#ifdef NXAGENT_LOGO
  nomachineLogoCount++;

  if (nomachineLogoCount == 2)
  {
      GCPtr pGC = GetScratchGC(nxagentRootTileWindow->drawable.depth,
                                   nxagentRootTileWindow->drawable.pScreen);
      if (pGC)
      {
          nomachineClearLogo(pGC, nxagentRootTileWindow);

          /*XClearWindow(nxagentDisplay, nxagentWindowPriv(nxagentRootTileWindow)->window);
           */

          FreeScratchGC(pGC);
      }
  }
#ifdef NXAGENT_LOGO_DEBUG
  fprintf(stderr, "nomachineLogoCount: %d\n", nomachineLogoCount);
#endif
#endif

  if (pWin->drawable.class == InputOnly) {
    mask = 0L;
    visual = CopyFromParent;
  }
  else {
    mask = CWEventMask | CWBackingStore;
    attributes.event_mask = ExposureMask;

#ifdef NXAGENT_STOPBIGREQ_no
    attributes.event_mask |= VisibilityChangeMask;
#endif

#ifdef NXAGENT_BAKSTR
    mask |= CWBackingPlanes | CWBackingPixel;
    if (nxagentBackingStore != NotUseful)
      {
#ifdef NXAGENT_BAKSTR_DEBUG
        if (pWin->backingStore != NotUseful)
          {
            fprintf(stderr, "nxagentCreateWindow\n");
            fprintf(stderr, "     backingstore on window: xu is: %u\n",
                    nxagentWindow(pWin), pWin->backingStore);
          }
#endif
        attributes.backing_store = pWin->backingStore;
        if (pWin->optional)
          {
            mask |= CWBackingPlanes | CWBackingPixel;
            attributes.backing_planes = pWin->optional->backingBitPlanes;
            attributes.backing_pixel = pWin->optional->backingPixel;
          }
      }
    else
      {
        attributes.backing_store = NotUseful;
      }

    if (nxagentSaveUnder == True)
      {
#ifdef NXAGENT_BAKSTR_DEBUG
        if (pWin->saveUnder == True)
          {
            fprintf(stderr, "nxagentCreateWindow\n");
            fprintf(stderr, "     saveunder on window: %x is: %u\n", nxagentWindow(pWin), pWin->saveUnder);
          }
#endif
        mask |= CWSaveUnder;
        attributes.save_under = pWin->saveUnder;
      }
#else /* NXAGENT_BAKSTR */
    attributes.backing_store = NotUseful;
#endif
#if defined(NXAGENT_FORCEBACK) || defined(NXAGENT_INTERNALBS)
    nxagentWindowPriv(pWin)->visible = 0;
    nxagentWindowPriv(pWin)->b_stored = 0;
    nxagentWindowPriv(pWin)->bs_time = 0;
    nxagentWindowPriv(pWin)->unexposed = 1;
#endif
#ifdef NXAGENT_FORCEBACK
    if(nxagentForceBackingStore)
    {
        if(attributes.backing_store != NotUseful){
            nxagentWindowPriv(pWin)->native_bs = True;
        }
        else{
            nxagentWindowPriv(pWin)->native_bs = False;
        }
        /*XXX*/
        if(!(nxagentWindowPriv(pWin)->native_bs))
        {
            nxagentWindowPriv(pWin)->area = pWin->drawable.width *
                pWin->drawable.height;
            if(nxagentWindowPriv(pWin)->area < nxagentMaxAreaBackS)
            {
                nxagentWindowPriv(pWin)->is_bscandidate = True;
            }
            else
            {
                nxagentWindowPriv(pWin)->is_bscandidate = False;
            }
        }
    }
#endif
    if (pWin->parent) {
      if (pWin->optional && pWin->optional->visual != wVisual(pWin->parent)) {
        visual = nxagentVisualFromID(pWin->drawable.pScreen, wVisual(pWin));
        mask |= CWColormap;
        if (pWin->optional->colormap) {
          pCmap = (ColormapPtr)LookupIDByType(wColormap(pWin), RT_COLORMAP);
          attributes.colormap = nxagentColormap(pCmap);
        }
        else
          attributes.colormap = nxagentDefaultVisualColormap(visual);
      }
      else if (pWin->optional)
       visual = CopyFromParent;
      else {
        visual = nxagentVisualFromID(pWin->drawable.pScreen, wVisual(pWin));
        mask |= CWColormap;
        attributes.colormap = nxagentDefaultVisualColormap(visual);
      }
    }
    else { /* root windows have their own colormaps at creation time */
      visual = nxagentVisualFromID(pWin->drawable.pScreen, wVisual(pWin));
      pCmap = (ColormapPtr)LookupIDByType(wColormap(pWin), RT_COLORMAP);
      mask |= CWColormap;
      attributes.colormap = nxagentColormap(pCmap);
#ifdef NXAGENT_REPARENT
      /* beware of moultiple roots (screens) */
      nxagentRootWindow = pWin;
      nxagentSetInstalledColormapWindows(pWin->drawable.pScreen);
      nxagentWindowPriv(pWin)->window = (int)NULL;
      return;
#endif
    }
  }

#ifdef NXAGENT_REPARENT
  if ((pWin)->parent == nxagentRootWindow)
    {
      /* visual CopyFromParent does not work if parent is root */
      if (visual == CopyFromParent)
        {
          visual = nxagentVisualFromID(pWin->drawable.pScreen, wVisual(pWin));
          pCmap = (ColormapPtr)LookupIDByType(wColormap(pWin), RT_COLORMAP);
          mask |= CWColormap;
          attributes.colormap = nxagentColormap(pCmap);
        }
      mask &= ~CWEventMask;
      mask |= CWColormap;
    }

  if (pWin != nxagentRootWindow)
    {
      mask |= CWEventMask;
      attributes.event_mask |= StructureNotifyMask;
/*       attributes.event_mask |= PointerMotionMask; */
    }
#endif
#ifdef NXAGENT_FORCEBACK
  if(nxagentForceBackingStore){
      nxagentWindowPriv(pWin)->event_mask = attributes.event_mask;
      nxagentWindowPriv(pWin)->is_blacklisted = False;
      nxagentWindowPriv(pWin)->enqueued = 0;
  }
#endif

  /*
   * Select the event mask if window is a top level
   * window. This at least makes the keyboard barely
   * work.
   */

  if (nxagentOption(Rootless) &&
          nxagentWindowTopLevel(pWin))
  {
    #ifdef TEST
    fprintf(stderr, "nxagentRootlessCreateWindow: Setting default event mask to top level window.\n");
    #endif

    mask |= CWEventMask;

    attributes.event_mask = nxagentEventMask;
  }

  #ifdef TEST
  fprintf(stderr, "nxagentCreateWindow: Going to create new window.\n");
  #endif

  nxagentWindowPriv(pWin)->window = XCreateWindow(nxagentDisplay,
                                                  nxagentWindowParent(pWin),
                                                  pWin->origin.x -
                                                  wBorderWidth(pWin),
                                                  pWin->origin.y -
                                                  wBorderWidth(pWin),
                                                  pWin->drawable.width,
                                                  pWin->drawable.height,
                                                  pWin->borderWidth,
                                                  pWin->drawable.depth,
                                                  pWin->drawable.class,
                                                  visual,
                                                  mask, &attributes);

  #ifdef TEST
  fprintf(stderr, "nxagentCreateWindow: Created new window with id [%ld].\n",
              nxagentWindowPriv(pWin)->window);
  #endif

  nxagentWindowPriv(pWin)->parent = nxagentWindowParent(pWin);
  nxagentWindowPriv(pWin)->x = pWin->origin.x - wBorderWidth(pWin);
  nxagentWindowPriv(pWin)->y = pWin->origin.y - wBorderWidth(pWin);
  nxagentWindowPriv(pWin)->width = pWin->drawable.width;
  nxagentWindowPriv(pWin)->height = pWin->drawable.height;
  nxagentWindowPriv(pWin)->border_width = pWin->borderWidth;
  nxagentWindowPriv(pWin)->sibling_above = None;
  nxagentWindowPriv(pWin)->pPicture = NULL;

#ifdef NXAGENT_FORCEBACK

  if (nxagentForceBackingStore)
  {
      if (nxagentRootTileWindow)
      {
          if (pWin)
          {
              nxagentIsBlacklistedforBS(pWin);
              if(nxagentWindowPriv(pWin)->native_bs){
                  if(!(nxagentWindowPriv(pWin)->is_blacklisted &&
                       nxagentWindowPriv(pWin)->area < nxagentMinAreaBackS) &&
                     nxagentWindowPriv(pWin)->area > nxagentMaxAreaBackS)
                  {
                      nxagentWindowPriv(pWin)->is_bscandidate = True;
                  }
                  else
                  {
                      nxagentWindowPriv(pWin)->is_bscandidate = False;
                  }
              }
          }
      }
  }
#endif
#ifdef NXAGENT_LOGO

  if (nxagentRootTileWindow)
  {
      if (nxagentWindowPriv(pWin)->window != nxagentWindowPriv(nxagentRootTileWindow)->window)
      {
          XClearWindow(nxagentDisplay, nxagentWindowPriv(nxagentRootTileWindow)->window);
      }
  }
#endif
  if (pWin->nextSib)
  {
    nxagentWindowPriv(pWin->nextSib)->sibling_above = nxagentWindow(pWin);
  }

#ifdef NXAGENT_SHAPE2
#ifdef SHAPE
  nxagentWindowPriv(pWin)->bounding_shape = NULL;
  nxagentWindowPriv(pWin)->clip_shape = NULL;
#endif /* SHAPE */
#else
#ifdef SHAPE
  nxagentWindowPriv(pWin)->bounding_shape =
    REGION_CREATE(pWin->drawable.pScreen, NULL, 1);
  nxagentWindowPriv(pWin)->clip_shape =
    REGION_CREATE(pWin->drawable.pScreen, NULL, 1);
#endif /* SHAPE */
#endif

  if (!pWin->parent) /* only the root window will have the right colormap */
    nxagentSetInstalledColormapWindows(pWin->drawable.pScreen);

  return True;
}

Bool nxagentDestroyWindow(pWin)
     WindowPtr pWin;
{
  nxagentClearClipboard(NULL, pWin);

#ifdef NXAGENT_FORCEBACK
    if(nxagentForceBackingStore)
    {
        delbsQueue(pWin, pbsQueue);
    }
#endif
#ifdef NXAGENT_REPARENT
  if (nxagentWindowPriv(pWin)->window == NULL)
    return;
#endif
  if (pWin->nextSib)
  {
    nxagentWindowPriv(pWin->nextSib)->sibling_above =
      nxagentWindowPriv(pWin)->sibling_above;
  }
#ifdef NXAGENT_SHAPE2
#ifdef SHAPE
  if (nxagentWindowPriv(pWin)->bounding_shape)
    {
      REGION_DESTROY(pWin->drawable.pScreen,
                     nxagentWindowPriv(pWin)->bounding_shape);
    }

  if (nxagentWindowPriv(pWin)->clip_shape)
    {
      REGION_DESTROY(pWin->drawable.pScreen,
                     nxagentWindowPriv(pWin)->clip_shape);
    }
#endif
#else
  REGION_DESTROY(pWin->drawable.pScreen,
                 nxagentWindowPriv(pWin)->bounding_shape);
  REGION_DESTROY(pWin->drawable.pScreen,
                 nxagentWindowPriv(pWin)->clip_shape);
#endif

  XDestroyWindow(nxagentDisplay, nxagentWindow(pWin));

#ifdef NXAGENT_LOGO
  nomachineLogoCount--;
#ifdef NXAGENT_LOGO_DEBUG
  fprintf(stderr, "nxagentDestroyWindow: nomachineLogoCount: %d\n", nomachineLogoCount);
#endif

  if(nomachineLogoCount == 1 && !isItTimeToYield)
  {
      GCPtr pGC = GetScratchGC(nxagentRootTileWindow->drawable.depth, nxagentRootTileWindow->drawable.pScreen);

      if(pGC)
      {
#ifdef NXAGENT_LOGO_DEBUG
          fprintf(stderr, "nxagentDestroyWindow: create pGC %p\n", pGC);
          fprintf(stderr, "nxagentDestroyWindow: DO LOGO\n");
#endif
          nomachineLogo(pGC, nxagentRootTileWindow);
          FreeScratchGC(pGC);
      }
#ifdef NXAGENT_LOGO_DEBUG
      else {
          fprintf(stderr, "nxagentDestroyWindow: pGC created as null pointer\n"); /*XXX*/
      }
#endif
      XClearWindow(nxagentDisplay, nxagentWindowPriv(nxagentRootTileWindow)->window);
  }

  if (pWin == nxagentRootTileWindow)
  {
      nxagentWindowPriv(nxagentRootTileWindow)->window = None;
      nxagentRootTileWindow = None;
  }
#endif

  nxagentWindowPriv(pWin)->window = None;

  if (pWin->optional && pWin->optional->colormap && pWin->parent)
    nxagentSetInstalledColormapWindows(pWin->drawable.pScreen);

  return True;
}

/*
 * Need this to test the configure-window
 * failure in rootless mode. Remove when
 * done.
 */

#ifdef TEST
#define MAKE_SYNC_CONFIGURE_WINDOW  XSync(nxagentDisplay, False)
#else
#define MAKE_SYNC_CONFIGURE_WINDOW
#endif

Bool nxagentPositionWindow(pWin, x, y)
     WindowPtr pWin;
     int x, y;
{
  /*
   * This is not only very inefficient (why don't we
   * just change the requested attributes?) but it
   * also seems to assume that the x and y coordina-
   * tes have been already written somewhere else. 
   */

  #ifdef TEST
  fprintf(stderr, "nxagentPositionWindow: Changing position of window [%p][%ld].\n",
              (void *) pWin, nxagentWindow(pWin));
  #endif

  nxagentConfigureWindow(pWin,
                         CWParent |
                         CWX | CWY |
                         CWWidth | CWHeight |
                         CWBorderWidth);

  return True;
}

void nxagentRestackWindow(pWin, pOldNextSib)
     WindowPtr pWin;
     WindowPtr pOldNextSib;
{
  if (!pWin -> prevSib)
  {
    #ifdef TEST
    fprintf(stderr, "nxagentRestackWindow: Raising window [%p][%ld].\n",
                (void *) pWin, nxagentWindow(pWin));
    #endif

    XRaiseWindow(nxagentDisplay, nxagentWindow(pWin));
  }
  else if (!pWin -> nextSib)
  {
    #ifdef TEST
    fprintf(stderr, "nxagentRestackWindow: Lowering window [%p][%ld].\n",
                (void *) pWin, nxagentWindow(pWin));
    #endif

    XLowerWindow(nxagentDisplay, nxagentWindow(pWin));
  }
  else
  {
    Window windowList[2];

    #ifdef TEST
    fprintf(stderr, "nxagentRestackWindow: Putting window [%p][%ld] in the middle.\n",
                (void *) pWin, nxagentWindow(pWin));
    #endif

    windowList[0] = nxagentWindow(pWin->prevSib);
    windowList[1] = nxagentWindow(pWin);

    XRestackWindows(nxagentDisplay, windowList, 2);
  }

  return;
}

void nxagentConfigureWindow(pWin, mask)
     WindowPtr pWin;
     unsigned int mask;
{
  unsigned int valuemask;
  XWindowChanges values;

  #ifdef TEST
  fprintf(stderr, "nxagentConfigureWindow: Called with window [%ld] and mask [%x].\n",
              nxagentWindow(pWin), mask);
  #endif

  #ifdef NXAGENT_REPARENT

  if (nxagentWindowPriv(pWin)->window == NULL)
  {
    return;
  }

  #endif

  if (mask & CWParent &&
          nxagentWindowPriv(pWin)->parent !=
              nxagentWindowParent(pWin))
  {
    #ifdef TEST
    fprintf(stderr, "nxagentConfigureWindow: Going to reparent window [%ld].\n",
                nxagentWindow(pWin));
    #endif

    XReparentWindow(nxagentDisplay, nxagentWindow(pWin),
                    nxagentWindowParent(pWin),
                    pWin->origin.x - wBorderWidth(pWin),
                    pWin->origin.y - wBorderWidth(pWin));

    MAKE_SYNC_CONFIGURE_WINDOW;

    nxagentWindowPriv(pWin)->parent = nxagentWindowParent(pWin);
    nxagentWindowPriv(pWin)->x = pWin->origin.x - wBorderWidth(pWin);
    nxagentWindowPriv(pWin)->y = pWin->origin.y - wBorderWidth(pWin);
    nxagentWindowPriv(pWin)->sibling_above = None;

    if (pWin->nextSib)
    {
      nxagentWindowPriv(pWin->nextSib)->sibling_above = nxagentWindow(pWin);
    }
  }

  valuemask = 0;

  if (mask & CWX &&
          nxagentWindowPriv(pWin)->x !=
              pWin->origin.x - wBorderWidth(pWin))
  {
    valuemask |= CWX;

    values.x = nxagentWindowPriv(pWin)->x = pWin->origin.x - wBorderWidth(pWin);
  }

  if (mask & CWY &&
          nxagentWindowPriv(pWin)->y !=
              pWin->origin.y - wBorderWidth(pWin))
  {
    valuemask |= CWY;

    values.y = nxagentWindowPriv(pWin)->y = pWin->origin.y - wBorderWidth(pWin);
  }

  if (mask & CWWidth &&
          nxagentWindowPriv(pWin)->width !=
              pWin->drawable.width)
  {
    valuemask |= CWWidth;

    #ifdef NXAGENT_FORCEBACK

    if (nxagentForceBackingStore)
    {
      nxagentIsBlacklistedforBS(pWin);
      nxagentWindowPriv(pWin)->area = pWin->drawable.width * pWin->drawable.height;

      if (!(nxagentWindowPriv(pWin)->is_blacklisted &&
              nxagentWindowPriv(pWin)->area > nxagentMinAreaBackS ) &&
                  nxagentWindowPriv(pWin)->area < nxagentMaxAreaBackS)
      {
        nxagentWindowPriv(pWin)->is_bscandidate = True;
      }
      else
      {
        nxagentWindowPriv(pWin)->is_bscandidate = False;
        nxagentSetBackingStore(pWin, NotUseful);
      }
    }

    #endif

    values.width = nxagentWindowPriv(pWin)->width = pWin->drawable.width;
  }

  if (mask & CWHeight &&
          nxagentWindowPriv(pWin)->height !=
              pWin->drawable.height)
  {
    valuemask |= CWHeight;

    #ifdef NXAGENT_FORCEBACK

    if (nxagentForceBackingStore)
    {
      nxagentIsBlacklistedforBS(pWin);
      nxagentWindowPriv(pWin)->area = pWin->drawable.width * pWin->drawable.height;

      if (!(nxagentWindowPriv(pWin)->is_blacklisted &&
               nxagentWindowPriv(pWin)->area > nxagentMinAreaBackS ) &&
                   nxagentWindowPriv(pWin)->area < nxagentMaxAreaBackS)
      {
        nxagentWindowPriv(pWin)->is_bscandidate = True;
      }
      else
      {
        nxagentWindowPriv(pWin)->is_bscandidate = False;
        nxagentSetBackingStore(pWin, NotUseful);
      }
    }

    #endif

    values.height = nxagentWindowPriv(pWin)->height = pWin->drawable.height;
  }

  if (mask & CWBorderWidth &&
          nxagentWindowPriv(pWin)->border_width !=
              pWin->borderWidth)
  {
    valuemask |= CWBorderWidth;

    values.border_width = nxagentWindowPriv(pWin)->border_width = pWin->borderWidth;
  }

  if (valuemask)
  {
    #ifdef TEST
    fprintf(stderr, "nxagentConfigureWindow: Going to configure window [%ld] with mask [%x].\n",
                nxagentWindow(pWin), valuemask);
    #endif

    XConfigureWindow(nxagentDisplay, nxagentWindow(pWin), valuemask, &values);

    MAKE_SYNC_CONFIGURE_WINDOW;
  }

  if (mask & CWStackingOrder &&
          nxagentWindowPriv(pWin)->sibling_above !=
              nxagentWindowSiblingAbove(pWin))
  {
    WindowPtr pSib;

    /*
     * Find the top sibling.
     */

    for (pSib = pWin; pSib->prevSib != NullWindow; pSib = pSib->prevSib);

    /*
     * Configure the top sibling.
     */

    valuemask = CWStackMode;

    values.stack_mode = Above;

    #ifdef NXAGENT_SPLASH

    /*
     * Do we really need this?
     */

    {
      extern void setOwnerNX_WM(WindowPtr);
      extern Window nxagentSplashWindow;

      if (nxagentSplashWindow)
      {
        #ifdef TEST
        fprintf(stderr, "nxagentConfigureWindow: Going to set NX_WM to NULL.\n");
        #endif

        /*XConfigureWindow(nxagentDisplay, nxagentSplashWindow, valuemask, &values);*/

        setOwnerNX_WM(NULL);

        MAKE_SYNC_CONFIGURE_WINDOW;
      }
    }

    #endif

    #ifdef TEST
    fprintf(stderr, "nxagentConfigureWindow: Going to configure top sibling [%ld] "
                "with mask [%x] and parent [%ld].\n", nxagentWindow(pSib),
                    valuemask, nxagentWindowParent(pWin));
    #endif

    XConfigureWindow(nxagentDisplay, nxagentWindow(pSib), valuemask, &values);

    MAKE_SYNC_CONFIGURE_WINDOW;

    nxagentWindowPriv(pSib)->sibling_above = None;

    /*
     * Configure the rest of siblings.
     */

    valuemask = CWSibling | CWStackMode;

    values.stack_mode = Below;

    for (pSib = pSib->nextSib; pSib != NullWindow; pSib = pSib->nextSib)
    {
      values.sibling = nxagentWindowSiblingAbove(pSib);

      #ifdef TEST
      fprintf(stderr, "nxagentConfigureWindow: Going to configure other sibling [%ld] "
                  "with mask [%x] and parent [%ld] below [%ld].\n", nxagentWindow(pSib),
                      valuemask, nxagentWindowParent(pWin), nxagentWindowSiblingAbove(pSib));
      #endif

      XConfigureWindow(nxagentDisplay, nxagentWindow(pSib), valuemask, &values);

      MAKE_SYNC_CONFIGURE_WINDOW;

      nxagentWindowPriv(pSib)->sibling_above = nxagentWindowSiblingAbove(pSib);
    }
  }

  #ifdef NXAGENT_SPLASH

  /*
   * This should bring again the splash window
   * on top, so why the else clause? Is this
   * really needed?
   */

  else if (mask & CWStackingOrder)
  {
    extern Window nxagentSplashWindow;

    if (nxagentSplashWindow)
    {
      valuemask = CWStackMode;

      values.stack_mode = Above;

      #ifdef TEST
      fprintf(stderr, "nxagentConfigureWindow: Going to configure splash window [%ld].\n",
                  nxagentSplashWindow);
      #endif

      XConfigureWindow(nxagentDisplay, nxagentSplashWindow, valuemask, &values);

      MAKE_SYNC_CONFIGURE_WINDOW;
    }
  }

  #endif
}

Bool nxagentChangeWindowAttributes(pWin, mask)
     WindowPtr pWin;
     unsigned long mask;
{
  XSetWindowAttributes attributes;

#ifdef NXAGENT_REPARENT
  if (nxagentWindowPriv(pWin)->window == NULL)
    return;
#endif

  if (mask & CWBackPixmap)
    switch (pWin->backgroundState) {
    case None:
        attributes.background_pixmap = None;
        attributes.background_pixel = nxagentWhitePixel;
      break;

    case ParentRelative:
      attributes.background_pixmap = ParentRelative;
      break;

    case BackgroundPixmap:
      attributes.background_pixmap = nxagentPixmap(pWin->background.pixmap);
      break;

    case BackgroundPixel:
      mask &= ~CWBackPixmap;
      break;
    }

  if (mask & CWBackPixel) {
    if (pWin->backgroundState == BackgroundPixel)
      attributes.background_pixel = nxagentPixel(pWin->background.pixel);
    else
      mask &= ~CWBackPixel;
  }

  if (mask & CWBorderPixmap) {
    if (pWin->borderIsPixel)
      mask &= ~CWBorderPixmap;
    else
      attributes.border_pixmap = nxagentPixmap(pWin->border.pixmap);
  }

  if (mask & CWBorderPixel) {
    if (pWin->borderIsPixel)
      attributes.border_pixel = nxagentPixel(pWin->border.pixel);
    else
      mask &= ~CWBorderPixel;
  }

  if (mask & CWBitGravity)
    attributes.bit_gravity = pWin->bitGravity;

  if (mask & CWWinGravity) /* dix does this for us */
    mask &= ~CWWinGravity;

#ifdef NXAGENT_BAKSTR
  if (mask & CWBackingStore)
    {  /*
        if ((nxagentBackingStore == NotUseful))
        mask &= ~CWBackingStore;
      else
        { */
          attributes.backing_store = pWin->backingStore;
          /* this is really useful */
#ifdef NXAGENT_BAKSTR_DEBUG
          fprintf(stderr, "Configuring backingstore for window: %X, value: %d\n",
                  nxagentWindow(pWin), pWin->backingStore);
#endif

       /* }*/
    }
#else
  if (mask & CWBackingStore) /* this is really not useful */
    mask &= ~CWBackingStore;
#endif
#ifdef NXAGENT_BAKSTR
  if (mask & CWBackingPlanes)
    {
      if ((nxagentBackingStore == NotUseful) || (!pWin->optional))
        mask &= ~CWBackingPlanes;
      else
        {
          attributes.backing_planes = pWin->optional->backingBitPlanes;
#ifdef NXAGENT_BAKSTR_DEBUG
          fprintf(stderr, "Configuring backingplanes for window: %X, value: %d\n",
                  nxagentWindow(pWin), pWin->backingStore);
#endif

        }
    }
#else
  if (mask & CWBackingPlanes) /* this is really not useful */
    mask &= ~CWBackingPlanes;
#endif

#ifdef NXAGENT_BAKSTR
  if (mask & CWBackingPixel)
    {
      if ((nxagentBackingStore == NotUseful) || (!pWin->optional))
        mask &= ~CWBackingPixel;
      else
        {
          attributes.backing_pixel = pWin->optional->backingPixel;
#ifdef NXAGENT_BAKSTR_DEBUG
          fprintf(stderr, "Configuring backingpixel for window: %X, value: %d\n",
                  nxagentWindow(pWin), pWin->backingStore);
#endif

        }
    }
#else /* NXAGENT_BAKSTR */
  if (mask & CWBackingPixel) /* this is really not useful */
    mask &= ~CWBackingPixel;
#endif /* NXAGENT_BAKSTR */

  if (mask & CWOverrideRedirect)
    attributes.override_redirect = pWin->overrideRedirect;

#ifdef NXAGENT_BAKSTR
  if (mask & CWSaveUnder)
  { /*
    if(nxagentSaveUnder == False)
      mask &= ~CWSaveUnder;
    else
      {*/
        attributes.save_under = pWin->saveUnder;
#ifdef NXAGENT_BAKSTR_DEBUG
        fprintf(stderr, "Configuring saveunder for window: %X, value: %d\n",
                nxagentWindow(pWin), pWin->saveUnder);
#endif
    /*  }*/
  }
#else
  if (mask & CWSaveUnder) /* this is really not useful */
    mask &= ~CWSaveUnder;
#endif

#ifdef NXAGENT_REPARENT
  if (mask & CWEventMask)
    {
      /* We always need some events */
      attributes.event_mask = (pWin->eventMask | ExposureMask & (StructureNotifyMask |
                                                  KeyPressMask | KeyReleaseMask |
                                                  KeymapStateMask |
                                                  ButtonPressMask | ButtonReleaseMask));
/*       mask &= ~CWEventMask; */
    }
#else
  if (mask & CWEventMask) /* events are handled elsewhere */
    mask &= ~CWEventMask;
#endif

  if (mask & CWDontPropagate) /* events are handled elsewhere */
    mask &= ~CWDontPropagate;

  if (mask & CWColormap) {
    ColormapPtr pCmap;

    pCmap = (ColormapPtr)LookupIDByType(wColormap(pWin), RT_COLORMAP);

    attributes.colormap = nxagentColormap(pCmap);

    nxagentSetInstalledColormapWindows(pWin->drawable.pScreen);
  }

  if (mask & CWCursor) /* this is handled in cursor code */
    mask &= ~CWCursor;

  if (mask)
  {
    XChangeWindowAttributes(nxagentDisplay, nxagentWindow(pWin),
                            mask, &attributes);
 }

  return True;
}

Bool nxagentRealizeWindow(pWin)
     WindowPtr pWin;
{
#ifdef NXAGENT_REPARENT
  if (nxagentWindowPriv(pWin)->window == NULL)
    return;
#endif

  nxagentConfigureWindow(pWin, CWStackingOrder);

#ifdef SHAPE
  nxagentShapeWindow(pWin);
#endif /* SHAPE */

  /*
   * Mapping of the root window is called by
   * InitRootWindow in DIX. Skip the operation
   * if we are in rootless mode.
   */

  if (!nxagentOption(Rootless) ||
          nxagentRootlessWindow != pWin)
  {
    XMapWindow(nxagentDisplay, nxagentWindow(pWin));
  }

  return True;
}

Bool nxagentUnrealizeWindow(pWin)
    WindowPtr pWin;
{

#ifdef NXAGENT_REPARENT
  if (nxagentWindowPriv(pWin)->window == NULL)
    return;
#endif

  XUnmapWindow(nxagentDisplay, nxagentWindow(pWin));

#ifdef NXAGENT_INTERNALBS
  /*nxagentWindowPriv(pWin)->unexposed = 1;*/
#endif

  return True;
}

void nxagentPaintWindowBackground(pWin, pRegion, what)
     WindowPtr pWin;
     RegionPtr pRegion;
     int what;
{
  int i;
  BoxPtr pBox;

#ifdef NXAGENT_CONFWINOPTIMIZE
  if (nxagentSafeMode == True)
  {
    nxagentConfigureWindow(pWin, CWWidth | CWHeight);
  }
#ifdef NXAGENT_CONFWINOPTIMIZE_DEBUG
  else
  {
    fprintf(stderr, "nxagentPaintWindowBackground: Suppressing nxagentConfigureWindow() for window [%ld].\n",
                nxagentWindow(pWin));
  }
#endif
#else
  nxagentConfigureWindow(pWin, CWWidth | CWHeight);
#endif

  pBox = REGION_RECTS(pRegion);
  for (i = 0; i < REGION_NUM_RECTS(pRegion); i++)
  {
    XClearArea(nxagentDisplay, nxagentWindow(pWin),
               pBox[i].x1 - pWin->drawable.x,
               pBox[i].y1 - pWin->drawable.y,
               pBox[i].x2 - pBox[i].x1,
               pBox[i].y2 - pBox[i].y1,
               False);
  }
}

void nxagentPaintWindowBorder(pWin, pRegion, what)
     WindowPtr pWin;
     RegionPtr pRegion;
     int what;
{
#ifdef NXAGENT_CONFWINOPTIMIZE
  if (nxagentSafeMode == True)
  {
    nxagentConfigureWindow(pWin, CWBorderWidth);
  }
#ifdef NXAGENT_CONFWINOPTIMIZE_DEBUG
  else
  {
    fprintf(stderr, "nxagentPaintWindowBorder: Suppressing nxagentConfigureWindow() for window [%ld].\n",
                nxagentWindow(pWin));
  }
#endif
#else
  nxagentConfigureWindow(pWin, CWBorderWidth);
#endif
}

void nxagentCopyWindow(pWin, oldOrigin, oldRegion)
     WindowPtr pWin;
     xPoint oldOrigin;
     RegionPtr oldRegion;
{
    /*miWindowExposures(pWin, oldRegion, NullRegion);*/
}

void nxagentClipNotify(pWin, dx, dy)
     WindowPtr pWin;
     int dx, dy;
{
  nxagentConfigureWindow(pWin, CWStackingOrder);
#if defined(NXAGENT_INTERNALBS) && defined(NXAGENT_FORCEBACK)
  nxagentWindowPriv(pWin)->unexposed = 1;
#endif
#ifdef NXAGENT_SHAPE
  return;
#else

#ifdef SHAPE
  nxagentShapeWindow(pWin);
#endif /* SHAPE */

#endif /* NXAGENT_SHAPE */
}

/*
#ifndef NXAGENT_EXPOSURES
*/
static Bool nxagentWindowExposurePredicate(display, event, ptr)
     Display *display;
     XEvent *event;
     XPointer ptr;
{
  return (event->type == Expose && event->xexpose.window == *(Window *)ptr);
}
/*
#endif
*/

/*
 * The mi layer is telling us that we are exposing the window pWin
 * in the region pRgn.  From a Xserver point of view we can dispatch
 * region to miWindowExposures but we are a client too and must handle
 * events coming from the real server. What we want is to check if
 * there are remote expose events in a region internal to pRgn and
 * eliminate them. Those events which are outside the region are marked
 * as ProcessedExpose (so we don't check them again) and put back in
 * the server's queue so nxagentCollectExposures() can get them.
 *
 * Unfortunately this works well only if we can get all the expose
 * events syncronously. Having to call XSync() for any exposure is a
 * pain, while, removing it, we refresh the agent's window twice. The
 * solution is to save the managed exposed regions in a list and send
 * an asynchronous X_GetInputFocus message to the server. The regions
 * reported by the real X server, then, should be combined with regions
 * already exposed. When the reply from X server arrives, the resulting
 * region should be sent to the client and the list of auto-generated
 * exposed regions freed.
 */

void nxagentWindowExposures(pWin, pRgn, other_exposed)
     WindowPtr pWin;
     RegionPtr pRgn, other_exposed;
{
#ifdef NXAGENT_EXPOSURES

  if (nxagentAutoExposures == True)
  {
    XEvent event;
    Window window;
    BoxRec Box;

    /*
     * This would be required to ensure that all
     * the exposed rectangles are collected.
     *
     * XSync(nxagentDisplay, False);
     */

    window = nxagentWindow(pWin);

#ifdef NXAGENT_EXPOSURES_DEBUG
    fprintf(stderr, "nxagentWindowExposures: Checking local expose events for window [%x].\n",
                window);
#endif

    /*
     * Get all enqueued Expose events from real server.
     * If rectangle coming from real server is in region
     * already identified by mi then discard it, else put
     * back event in queue.
     */

    if(nxagentForceBackingStore)
    {
       if(nxagentWindowPriv(pWin)->b_stored != NotUseful && GetTimeInMillis() > nxagentWindowPriv(pWin)->bs_time && !nxagentWindowPriv(pWin)->unexposed)
       {
          return;
       }
    }

     while (XCheckIfEvent(nxagentDisplay, &event,
                         nxagentWindowExposurePredicate, (char *)&window))
     {
          Box.x1 = pWin->drawable.x + wBorderWidth(pWin) + event.xexpose.x;
          Box.y1 = pWin->drawable.y + wBorderWidth(pWin) + event.xexpose.y;
          Box.x2 = Box.x1 + event.xexpose.width;
          Box.y2 = Box.y1 + event.xexpose.height;

          event.xexpose.type = ProcessedExpose;

          if (RECT_IN_REGION(pWin->drawable.pScreen, pRgn, &Box) != rgnIN)
          {
#ifdef NXAGENT_EXPOSURES_DEBUG
              fprintf(stderr, "nxagentWindowExposures: Put back remote expose event for window [%x].\n",
                      window);
#endif
              XPutBackEvent(nxagentDisplay, &event);
          }
#ifdef NXAGENT_EXPOSURES_DEBUG
          else
          {
              fprintf(stderr, "nxagentWindowExposures: Discarded remote expose event for window [%x].\n",
                      window);
          }
#endif
     }

#ifdef NXAGENT_VISIBILITY

    if (nxagentVisibility == VisibilityUnobscured &&
            nxagentVisibilityTimeout < GetTimeInMillis() &&
                !nxagentVisibilityStop)
    {
      /*
       *  Tell proxy to do not bother with Expose
       *  events until new order
       */

      extern Bool nxagentUseNXTrans;

      if (nxagentUseNXTrans &&
              !nxagentOption(Rootless) &&
                  !nxagentOption(Nested))
      {
        NXSetExposeEvents(nxagentDisplay, False, False, False);

        nxagentVisibilityStop = True;
      }
    }

#endif

#ifdef NXAGENT_INTERNALBS

    /*
     * in case of internal backing store enabled
     * the agent discard complitely internal events
     * for the win with backing store on the real
     * server.
     */
    /*
     if(pWin->backingStore == NotUseful)
     */
    if(nxagentForceBackingStore)
    {
       if(nxagentWindowPriv(pWin)->b_stored == NotUseful || GetTimeInMillis() < nxagentWindowPriv(pWin)->bs_time || nxagentWindowPriv(pWin)->unexposed)
       {
#ifdef NXAGENT_EXPOSURES_DEBUG
            fprintf(stderr, "nxagentWindowExposures: Handling local expose event for window [%x].\n",
                    window);
#endif
            nxagentWindowPriv(pWin)->unexposed = 0;
            miWindowExposures(pWin, pRgn, other_exposed);
            return;
       }
       return;
    }
    else
    {

#ifdef NXAGENT_EXPOSURES_DEBUG
        fprintf(stderr, "nxagentWindowExposures: Handling local expose event for window [%x].\n",
                window);
#endif

        miWindowExposures(pWin, pRgn, other_exposed);
        return;
    }
#endif /* NXAGENT_INTERNALBS */
  }
  else
  {
    /*
     * Ignore expose events generated by our own mi layer
     * and only process those events sent by the remote
     * server in nxagentCollectExposures().
     */

    return;
  }

#else
  XEvent event;
  Window window;
  BoxRec Box;

  /*
   * This would be required to ensure that all
   * the exposed rectangles are collected.
   *
   * XSync(nxagentDisplay, False);
   */

  window = nxagentWindow(pWin);

  while (XCheckIfEvent(nxagentDisplay, &event,
                       nxagentWindowExposurePredicate, (char *)&window)) {

    Box.x1 = pWin->drawable.x + wBorderWidth(pWin) + event.xexpose.x;
    Box.y1 = pWin->drawable.y + wBorderWidth(pWin) + event.xexpose.y;
    Box.x2 = Box.x1 + event.xexpose.width;
    Box.y2 = Box.y1 + event.xexpose.height;

    event.xexpose.type = ProcessedExpose;

    if (RECT_IN_REGION(pWin->drawable.pScreen, pRgn, &Box) != rgnIN)
        XPutBackEvent(nxagentDisplay, &event);
  }

  miWindowExposures(pWin, pRgn, other_exposed);
#endif /* NXAGENT_EXPOSURES */
}

#ifdef SHAPE
static Bool nxagentRegionEqual(pReg1, pReg2)
     RegionPtr pReg1, pReg2;
{
  BoxPtr pBox1, pBox2;
  unsigned int n1, n2;

  if (pReg1 == pReg2) return True;

  if (pReg1 == NullRegion || pReg2 == NullRegion) return False;

  pBox1 = REGION_RECTS(pReg1);
  n1 = REGION_NUM_RECTS(pReg1);

  pBox2 = REGION_RECTS(pReg2);
  n2 = REGION_NUM_RECTS(pReg2);

  if (n1 != n2) return False;

  if (pBox1 == pBox2) return True;

  if (memcmp(pBox1, pBox2, n1 * sizeof(BoxRec))) return False;

  return True;
}

void nxagentShapeWindow(pWin)
     WindowPtr pWin;
{
  Region reg;
  BoxPtr pBox;
  XRectangle rect;
  int i;

#ifdef NXAGENT_SHAPE2_DEBUG
      fprintf(stderr, "nxagentShapeWindow, win: %d\n", nxagentWindow(pWin));
#endif

  if (!nxagentRegionEqual(nxagentWindowPriv(pWin)->bounding_shape,
                        wBoundingShape(pWin)))
    {
#ifdef NXAGENT_SHAPE2_DEBUG
      fprintf(stderr, "Bounding shapes differ\n", nxagentWindow(pWin));
#endif
      if (wBoundingShape(pWin))
        {
#ifdef NXAGENT_SHAPE2_DEBUG
          fprintf(stderr, "wBounding shape exists\n", nxagentWindow(pWin));
#endif

#ifdef NXAGENT_SHAPE2
          if (!nxagentWindowPriv(pWin)->bounding_shape)
            {
              nxagentWindowPriv(pWin)->bounding_shape =
                REGION_CREATE(pWin->drawable.pScreen, NULL, 1);            
            }
#endif
          REGION_COPY(pWin->drawable.pScreen, 
                      nxagentWindowPriv(pWin)->bounding_shape, wBoundingShape(pWin));

          reg = XCreateRegion();
          pBox = REGION_RECTS(nxagentWindowPriv(pWin)->bounding_shape);
          for (i = 0;
               i < REGION_NUM_RECTS(nxagentWindowPriv(pWin)->bounding_shape);
               i++)
            {
              rect.x = pBox[i].x1;
              rect.y = pBox[i].y1;
              rect.width = pBox[i].x2 - pBox[i].x1;
              rect.height = pBox[i].y2 - pBox[i].y1;
              XUnionRectWithRegion(&rect, reg, reg);
            }
#ifdef NXAGENT_SHAPE2_DEBUG
          fprintf(stderr, "nxagentShapeWindow, first loop called: %d times\n", i);
#endif


#ifndef NXAGENT_SHAPE
          XShapeCombineRegion(nxagentDisplay, nxagentWindow(pWin),
                              ShapeBounding, 0, 0, reg, ShapeSet);
#endif
          XDestroyRegion(reg);
        }
      else
        {
          REGION_EMPTY(pWin->drawable.pScreen,
                       nxagentWindowPriv(pWin)->bounding_shape);
#ifndef NXAGENT_SHAPE
          XShapeCombineMask(nxagentDisplay, nxagentWindow(pWin),
                            ShapeBounding, 0, 0, None, ShapeSet);
#endif
        }
    }

  if (!nxagentRegionEqual(nxagentWindowPriv(pWin)->clip_shape,
                        wClipShape(pWin)))
    {

      if (wClipShape(pWin))
        {
#ifdef NXAGENT_SHAPE2
          if (!nxagentWindowPriv(pWin)->clip_shape)
            {
              nxagentWindowPriv(pWin)->clip_shape =
                REGION_CREATE(pWin->drawable.pScreen, NULL, 1);
            }
#endif
          REGION_COPY(pWin->drawable.pScreen,
                      nxagentWindowPriv(pWin)->clip_shape, wClipShape(pWin));

          reg = XCreateRegion();
          pBox = REGION_RECTS(nxagentWindowPriv(pWin)->clip_shape);
          for (i = 0;
               i < REGION_NUM_RECTS(nxagentWindowPriv(pWin)->clip_shape);
               i++) 
            {
              rect.x = pBox[i].x1;
              rect.y = pBox[i].y1;
              rect.width = pBox[i].x2 - pBox[i].x1;
              rect.height = pBox[i].y2 - pBox[i].y1;
              XUnionRectWithRegion(&rect, reg, reg);
            }
#ifdef NXAGENT_SHAPE2_DEBUG
          fprintf(stderr, "nxagentShapeWindow, first loop called: %d times\n", i);
#endif

#ifndef NXAGENT_SHAPE
          XShapeCombineRegion(nxagentDisplay, nxagentWindow(pWin),
                              ShapeClip, 0, 0, reg, ShapeSet);
#endif
          XDestroyRegion(reg);
        }
      else 
        {
          REGION_EMPTY(pWin->drawable.pScreen,
                       nxagentWindowPriv(pWin)->clip_shape);
#ifndef NXAGENT_SHAPE
          XShapeCombineMask(nxagentDisplay, nxagentWindow(pWin),
                            ShapeClip, 0, 0, None, ShapeSet);
#endif
        }
    }
}
#endif /* SHAPE */

static int nxagentForceExposure(pWin, ptr)
WindowPtr pWin;
     pointer ptr;
{
    RegionPtr exposedRgn;
    BoxRec Box;

    if (pWin -> drawable.class != InputOnly)
    {
      Box.x1 = pWin->drawable.x;
      Box.y1 = pWin->drawable.y;
      Box.x2 = pWin->drawable.width;
      Box.y2 = pWin->drawable.height;

      exposedRgn = REGION_CREATE(pWin->drawable.pScreen, &Box, 1);
      miWindowExposures(pWin, exposedRgn, NullRegion);
/*
    miMarkWindow(pWin);
*/  }

    return WT_WALKCHILDREN;
}



void nxagentRefreshWindows(WindowPtr pWin)
{
   int action = 1;
   TraverseTree(pWin, nxagentForceExposure, &action);
/*   miHandleValidateExposures(pWin);*/
}

#ifdef NXAGENT_RECONNECT

Bool nxagentReCreateWindows(void*);
Bool nxagentDisconnectWindows(void);
static void nxagentTraverseWindow(WindowPtr, void(*)(pointer, XID, pointer), pointer);
static void nxagentDisconnectWindow(pointer, XID, pointer);
static Bool nxagentLoopOverWindows(void);
static void nxagentReConnectWindow(pointer, XID, pointer);
static void nxagentReConfigureWindow(pointer, XID, pointer);

Bool nxagentDisconnectWindows(void)
{
  Bool succeded = True;
  int i;
  WindowPtr pWin;

#if defined(NXAGENT_RECONNECT_DEBUG) || defined(NXAGENT_RECONNECT_WINDOW_DEBUG)
  fprintf(stderr, "nxagentDisconnectWindows\n");
#endif

  for( i = 0; i < screenInfo.numScreens; i++)
  {
    pWin = WindowTable[i];
    nxagentTraverseWindow( pWin, nxagentDisconnectWindow, &succeded);
  }

#ifdef NXAGENT_RECONNECT_WINDOW_DEBUG
  fprintf(stderr, "nxagentDisconnectWindows: all windows disconnected\n");
#endif

  return succeded;
}

/* FIXME: We are giving up reconnecting those pointer that are not resource, 
   and we are just disconnecting them.
   perhaps we could do better and reconnect them. */
void nxagentDisconnectWindow(pointer p0, XID x1, pointer p2)
{
  WindowPtr pWin = (WindowPtr)p0;
  Bool*     pBool = (Bool*)p2;
  extern void nxagentDisconnectCursor(pointer, XID, pointer);
  extern ScreenPtr nxagentDummyScreen;

  if ((pWin -> optional) &&
      (pWin -> optional -> cursor) &&
      (nxagentCursor((pWin -> optional -> cursor), nxagentDummyScreen) != None) )
  {
#ifdef NXAGENT_RECONNECT_CURSOR_DEBUG
    char msg[] = "nxagentDisconnectWindow:";

    nxagentPrintCursorInfo(pWin -> optional -> cursor, msg);
#endif
    nxagentDisconnectCursor((pointer)pWin -> optional -> cursor, (XID)0, pBool);
  }
  else
    pWin->cursorIsNone = TRUE;

}

Bool nxagentReCreateWindows(void*p0)
{
  Bool succeded;
  int flexibility;
#ifdef NXAGENT_ONSTART
  extern Window nxagentSplashWindow;
  extern Pixmap nxagentPixmapLogo;
#endif

  flexibility = *(int*)p0;
#if defined(NXAGENT_RECONNECT_DEBUG) || defined(NXAGENT_RECONNECT_WINDOW_DEBUG)
  fprintf(stderr, "nxagentReCreateWindows\n");
#endif

#ifdef NXAGENT_ONSTART
  /* FIXME: Here we are just ignoring Splash and Logo, perhaps they could be recreated. */
  nxagentSplashWindow = None;
  nxagentPixmapLogo = None;
#endif
  /* FIXME: Why is pixel of root window not blackPixel(0).
   * It seem to have a random value. 
   * That is because WindowPtr -> background is a union !!!
   * The next test is there just to check if we have to correct 
   * the pixel value.
   */
  if (WindowTable[0] -> backgroundState == BackgroundPixel)
    WindowTable[0] -> background.pixel = WindowTable[0] -> drawable.pScreen->blackPixel;

  if (WindowTable[0] -> backgroundState == BackgroundPixel &&
      WindowTable[0] -> background.pixel != WindowTable[0] -> drawable.pScreen->blackPixel)
    FatalError("nxagentReCreateWindows: the background pixel "
                     "of the root window has to be set");
  if (WindowTable[0] -> backgroundState == BackgroundPixmap &&
      WindowTable[0] -> background.pixmap == NULL)
    FatalError("nxagentReCreateWindows: correct the FIXME\n");

  succeded = nxagentLoopOverWindows();

  nxagentInitClipboard(WindowTable[0]);

  return succeded;
}

static void nxagentTraverseWindow(
  WindowPtr pWin, 
  void (*pF)(pointer, XID, pointer), 
  pointer p)
{
  pF(pWin, 0, p);  
  
  if( pWin -> nextSib )
    nxagentTraverseWindow(pWin -> nextSib, pF, p);  

  if( pWin -> firstChild )
    nxagentTraverseWindow(pWin -> firstChild, pF, p);
}

static Bool nxagentLoopOverWindows(void)
{
  int i;
  Bool windowSuccess = True;
  WindowPtr pWin;

  for( i = 0; i < screenInfo.numScreens; i++)
  {
    pWin = WindowTable[i];
    nxagentTraverseWindow( pWin, nxagentReConnectWindow, &windowSuccess);
  }
#ifdef NXAGENT_RECONNECT_WINDOW_DEBUG
  fprintf(stderr, "nxagentLoopOverWindows: all windows created\n");
#endif
  for( i = 0; i < screenInfo.numScreens; i++)
  {
    pWin = WindowTable[i];
    nxagentTraverseWindow( pWin, nxagentReConfigureWindow, &windowSuccess);
  }
#ifdef NXAGENT_RECONNECT_WINDOW_DEBUG
  fprintf(stderr, "nxagentLoopOverWindows: all windows attributes set\n");
#endif

  return windowSuccess;
}

static void nxagentReConnectWindow(pointer param0, XID param1, pointer data_buffer)
{
  WindowPtr pWin = (WindowPtr)param0;
  Bool *pBool = (Bool*)data_buffer;
  Visual *visual;
  unsigned long mask;
  XSetWindowAttributes attributes;
  ColormapPtr pCmap;

  if( !pWin || !*pBool )
      return;

#ifdef NXAGENT_RECONNECT_WINDOW_DEBUG
  fprintf(stderr, "nxagentReConnectWindow: %p - ID %lx\n", pWin, nxagentWindow(pWin));
#endif

  if (pWin->drawable.class == InputOnly) {
    mask = 0L;
    visual = CopyFromParent;
  }
  else {
    mask = CWEventMask | CWBackingStore;
    attributes.event_mask = ExposureMask;

#ifdef NXAGENT_STOPBIGREQ_no
    attributes.event_mask |= VisibilityChangeMask;
#endif

#ifdef NXAGENT_BAKSTR
    mask |= CWBackingPlanes | CWBackingPixel;
    if (nxagentBackingStore != NotUseful)
      {
#ifdef NXAGENT_BAKSTR_DEBUG
        if (pWin->backingStore != NotUseful) 
          {
            fprintf(stderr, "nxagentCreateWindow\n");
            fprintf(stderr, "     backingstore on window: xu is: %u\n",
                    nxagentWindow(pWin), pWin->backingStore);
          }
#endif
        attributes.backing_store = pWin->backingStore;
        if (pWin->optional)
          {
            mask |= CWBackingPlanes | CWBackingPixel;
            attributes.backing_planes = pWin->optional->backingBitPlanes;
            attributes.backing_pixel = pWin->optional->backingPixel;
          }
      }
    else
      {
        attributes.backing_store = NotUseful;
      }

    if (nxagentSaveUnder == True)
      {
#ifdef NXAGENT_BAKSTR_DEBUG
        if (pWin->saveUnder == True)
          {
            fprintf(stderr, "nxagentCreateWindow\n");
            fprintf(stderr, "     saveunder on window: %x is: %u\n", nxagentWindow(pWin), pWin->saveUnder);
          }
#endif
        mask |= CWSaveUnder;
        attributes.save_under = pWin->saveUnder;
      }
#else /* NXAGENT_BAKSTR */
    attributes.backing_store = NotUseful;
#endif

#if 0 /* FIXME: Do i have to set these parameters. */
#if defined(NXAGENT_FORCEBACK) || defined(NXAGENT_INTERNALBS)
    nxagentWindowPriv(pWin)->visible = 0;
    nxagentWindowPriv(pWin)->b_stored = 0;
    nxagentWindowPriv(pWin)->bs_time = 0;
    nxagentWindowPriv(pWin)->unexposed = 1;
#endif
#endif

#ifdef NXAGENT_FORCEBACK
    if(nxagentForceBackingStore)
    {

#if 0  /* FIXME: Do i have to set these parameters. */
        if(attributes.backing_store != NotUseful){
            nxagentWindowPriv(pWin)->native_bs = True;
        }
        else{
            nxagentWindowPriv(pWin)->native_bs = False;
        }
        /*XXX*/
        if(!(nxagentWindowPriv(pWin)->native_bs))
        {
            nxagentWindowPriv(pWin)->area = pWin->drawable.width *
                pWin->drawable.height;
            if(nxagentWindowPriv(pWin)->area < nxagentMaxAreaBackS)
            {
                nxagentWindowPriv(pWin)->is_bscandidate = True;
            }
            else
            {
                nxagentWindowPriv(pWin)->is_bscandidate = False;
            }
        }
#endif

    }
#endif
    if (pWin->parent) {
        if (pWin->optional && pWin->optional->visual != wVisual(pWin->parent)) {
        visual = nxagentVisualFromID(pWin->drawable.pScreen, wVisual(pWin));
        mask |= CWColormap;
        if (pWin->optional->colormap) {
          pCmap = (ColormapPtr)LookupIDByType(wColormap(pWin), RT_COLORMAP);
          attributes.colormap = nxagentColormap(pCmap);
        }
        else
          attributes.colormap = nxagentDefaultVisualColormap(visual);
      }
      else
        visual = CopyFromParent;
    }
    else { /* root windows have their own colormaps at creation time */
      visual = nxagentVisualFromID(pWin->drawable.pScreen, wVisual(pWin));
      pCmap = (ColormapPtr)LookupIDByType(wColormap(pWin), RT_COLORMAP);
      mask |= CWColormap;
      attributes.colormap = nxagentColormap(pCmap);
#ifdef NXAGENT_REPARENT
      /* beware of moultiple roots (screens) */
      nxagentRootWindow = pWin;
      nxagentSetInstalledColormapWindows(pWin->drawable.pScreen);
      nxagentWindowPriv(pWin)->window = (int)NULL;
      return;
#endif
    }
  }

#ifdef NXAGENT_REPARENT
  if ((pWin)->parent == nxagentRootWindow)
    {
      /* visual CopyFromParent does not work if parent is root */
      if (visual == CopyFromParent)
        {
          visual = nxagentVisualFromID(pWin->drawable.pScreen, wVisual(pWin));
          pCmap = (ColormapPtr)LookupIDByType(wColormap(pWin), RT_COLORMAP);
          mask |= CWColormap;
          attributes.colormap = nxagentColormap(pCmap);
        }
      mask &= ~CWEventMask;
      mask |= CWColormap;
    }

  if (pWin != nxagentRootWindow)
    {
      mask |= CWEventMask;
      attributes.event_mask |= StructureNotifyMask;
/*       attributes.event_mask |= PointerMotionMask; */
    }
#endif

#if 0 /* FIXME: Do i have to set these parameters. */
#ifdef NXAGENT_FORCEBACK
  if(nxagentForceBackingStore){
      nxagentWindowPriv(pWin)->event_mask = attributes.event_mask;
      nxagentWindowPriv(pWin)->is_blacklisted = False;
      nxagentWindowPriv(pWin)->enqueued = 0;
  }
#endif
#endif

  #ifdef TEST
  fprintf(stderr, "nxagentReConnectWindow: Going to create new window.\n");
  #endif

  nxagentWindow(pWin) = XCreateWindow(nxagentDisplay,
                                      nxagentWindowParent(pWin),
                                      pWin->origin.x -
                                      wBorderWidth(pWin),
                                      pWin->origin.y -
                                      wBorderWidth(pWin),
                                      pWin->drawable.width,
                                      pWin->drawable.height,
                                      pWin->borderWidth,
                                      pWin->drawable.depth,
                                      pWin->drawable.class,
                                      visual,
                                      mask, 
                                      &attributes);

  nxagentWindowPriv(pWin) -> parent = nxagentWindowParent(pWin);

  #ifdef TEST
  fprintf(stderr, "nxagentReConnectWindow: Created new window with id [%ld].\n",
              nxagentWindowPriv(pWin)->window);
  #endif
}

static void nxagentReConfigureWindow(pointer param0, XID param1, pointer data_buffer)
{
  WindowPtr pWin = (WindowPtr)param0;
  unsigned long mask = 0;

#ifdef NXAGENT_RECONNECT_WINDOW_DEBUG
  fprintf(stderr, "nxagentReConfigureWindow: pWin %p - ID %lx\n", pWin, nxagentWindow(pWin));
#endif

  if( pWin -> drawable.class == InputOnly )
    mask = CWWinGravity | CWEventMask | CWDontPropagate | CWOverrideRedirect | CWCursor;
  else
    mask = CWBackPixmap | CWBackPixel | CWBorderPixmap | CWBorderPixel |
         CWBitGravity | CWWinGravity | CWBackingStore | CWBackingPlanes |
         CWBackingPixel | CWOverrideRedirect | CWSaveUnder | CWEventMask |
         CWDontPropagate | CWColormap | CWCursor; 

  nxagentChangeWindowAttributes(pWin, mask);

#ifdef SHAPE
  if (nxagentWindowPriv(pWin) -> bounding_shape)
  {
    REGION_DESTROY(pWin -> drawable.pScreen, 
                   nxagentWindowPriv(pWin) -> bounding_shape);
    nxagentWindowPriv(pWin) -> bounding_shape = NULL;
  }

  if (nxagentWindowPriv(pWin) -> clip_shape)
  {
    REGION_DESTROY(pWin -> drawable.pScreen,
                   nxagentWindowPriv(pWin) -> clip_shape);
    nxagentWindowPriv(pWin) -> clip_shape = NULL;
  }
  nxagentShapeWindow(pWin);
#endif 

  if( pWin->realized )
    nxagentRealizeWindow( pWin );
  else if( pWin->mapped ) 
    XMapWindow(nxagentDisplay, nxagentWindow(pWin));
}

#endif /* NXAGENT_RECONNECT */
