/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001,2003 NoMachine, http://www.nomachine.com.           */
/*                                                                        */
/* NXPROXY, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

#include "IntCache.h"

const unsigned int PARTIAL_INT_MASK[33] =
{
  0x00000000,
  0x00000001,
  0x00000003,
  0x00000007,
  0x0000000f,
  0x0000001f,
  0x0000003f,
  0x0000007f,
  0x000000ff,
  0x000001ff,
  0x000003ff,
  0x000007ff,
  0x00000fff,
  0x00001fff,
  0x00003fff,
  0x00007fff,
  0x0000ffff,
  0x0001ffff,
  0x0003ffff,
  0x0007ffff,
  0x000fffff,
  0x001fffff,
  0x003fffff,
  0x007fffff,
  0x00ffffff,
  0x01ffffff,
  0x03ffffff,
  0x07ffffff,
  0x0fffffff,
  0x1fffffff,
  0x3fffffff,
  0x7fffffff,
  0xffffffff
};

IntCache::IntCache(unsigned int size)

  : size_(size), length_(0), buffer_(new unsigned int[size]),
        lastDiff_(0), lastValueInserted_(0), predictedBlockSize_(0)
{
}

int IntCache::lookup(unsigned int &value, unsigned int &index,
                         unsigned int mask, unsigned int &sameDiff)
{
  for (unsigned int i = 0; i < length_; i++)
  {
    if (value == buffer_[i])
    {
      index = i;
      if (i)
      {
        unsigned int target = (i >> 1);
        do
        {
          buffer_[i] = buffer_[i - 1];
          i--;
        }
        while (i > target);
        buffer_[target] = value;
      }
      return 1;
    }
  }
  unsigned int insertionPoint;
  if (2 >= length_)
    insertionPoint = length_;
  else
    insertionPoint = 2;
  unsigned int start;
  if (length_ >= size_)
    start = size_ - 1;
  else
  {
    start = length_;
    length_++;
  }
  for (unsigned int k = start; k > insertionPoint; k--)
    buffer_[k] = buffer_[k - 1];
  buffer_[insertionPoint] = value;
  unsigned int diff = value - lastValueInserted_;

  lastValueInserted_ = (value & mask);
  value = (diff & mask);
  sameDiff = (value == lastDiff_);
  if (!sameDiff)
  {
    lastDiff_ = value;

    unsigned int lastChangeIndex = 0;
    unsigned int lastBitIsOne = (lastDiff_ & 0x1);
    unsigned int j = 1;
    for (unsigned int nextMask = 0x2; nextMask & mask; nextMask <<= 1)
    {
      unsigned int nextBitIsOne = (lastDiff_ & nextMask);
      if (nextBitIsOne)
      {
        if (!lastBitIsOne)
        {
          lastChangeIndex = j;
          lastBitIsOne = nextBitIsOne;
        }
      }
      else
      {
        if (lastBitIsOne)
        {
          lastChangeIndex = j;
          lastBitIsOne = nextBitIsOne;
        }
      }
      j++;
    }
    predictedBlockSize_ = lastChangeIndex + 1;
    if (predictedBlockSize_ < 2)
      predictedBlockSize_ = 2;
  }
  return 0;
}

unsigned int IntCache::get(unsigned int index)
{
  unsigned int result = buffer_[index];
  if (index != 0)
  {
    unsigned int i = index;
    unsigned int target = (i >> 1);
    do
    {
      buffer_[i] = buffer_[i - 1];
      i--;
    }
    while (i > target);
    buffer_[target] = result;
  }
  return result;
}

void IntCache::insert(unsigned int &value, unsigned int mask)
{
  unsigned int insertionPoint;
  if (2 >= length_)
    insertionPoint = length_;
  else
    insertionPoint = 2;
  unsigned int start;
  if (length_ >= size_)
    start = size_ - 1;
  else
  {
    start = length_;
    length_++;
  }
  for (unsigned int k = start; k > insertionPoint; k--)
    buffer_[k] = buffer_[k - 1];
  if (lastDiff_ != value)
  {
    lastDiff_ = value;
    unsigned int lastChangeIndex = 0;
    unsigned int lastBitIsOne = (lastDiff_ & 0x1);
    unsigned int j = 1;
    for (unsigned int nextMask = 0x2; nextMask & mask; nextMask <<= 1)
    {
      unsigned int nextBitIsOne = (lastDiff_ & nextMask);
      if (nextBitIsOne)
      {
        if (!lastBitIsOne)
        {
          lastChangeIndex = j;
          lastBitIsOne = nextBitIsOne;
        }
      }
      else
      {
        if (lastBitIsOne)
        {
          lastChangeIndex = j;
          lastBitIsOne = nextBitIsOne;
        }
      }
      j++;
    }
    predictedBlockSize_ = lastChangeIndex + 1;
    if (predictedBlockSize_ < 2)
      predictedBlockSize_ = 2;
  }
  lastValueInserted_ += value;
  lastValueInserted_ &= mask;
  buffer_[insertionPoint] = lastValueInserted_;
  value = lastValueInserted_;
}
