/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001,2003 NoMachine, http://www.nomachine.com.           */
/*                                                                        */
/* NXPROXY, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rigths reserved.                                                   */
/*                                                                        */
/**************************************************************************/

#ifndef Png_H
#define Png_H

#ifdef __cplusplus
extern "C" {
#endif

#include "X11/X.h"
#include "X11/Xlib.h"
#include "X11/Xmd.h"

#include <png.h> 

typedef struct
{
  long pixel;
  int found;

} NXColorTable;

extern int PngCompareColorTable(
#if NeedFunctionPrototypes
  NXColorTable *     /* c1 */, 
  NXColorTable *     /* c2 */
#endif
);

extern char* PngCompressData(
#if NeedFunctionPrototypes
    XImage*          /* image */,
    int*             /* compressed_size */,
    NXColorTable*    /* color_table */
#endif
);

int NXCreatePalette16(
#if NeedFunctionPrototypes
    XImage*          /* src_image */,
    NXColorTable*    /* color_table */,
    CARD8*           /* image_index */,
    int              /* nb_max */
#endif
);

int NXCreatePalette32(
#if NeedFunctionPrototypes
    XImage*          /* src_image */,
    NXColorTable*    /* color_table */,
    CARD8*           /* image_index */,
    int              /* nb_max */
#endif
);

#ifdef __cplusplus
}
#endif

#endif /* Png_H */

