/*
 * Copyright (c) 2004 Nokia. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the
 * distribution.
 *
 * Neither the name of Nokia nor the names of its contributors may be
 * used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef rootimpl_h
#define rootimpl_h

#include <glib.h>

#include "osb.h"

class BridgeImpl;
class FrameImpl;
class PreferencesImpl;

class FrameGroup;
class WebCoreSettings;


class RootImpl
{
public:
    RootImpl(OSB::Root*, const gchar* frameName, const gchar* group);
    virtual ~RootImpl();

    void setGroup(const gchar*);
    const gchar* group();
    
    FrameImpl* mainFrame();
    
    /** @return GList of BridgeImpl*
     */
    GList* peers();
    OSB::URLCredentialStorage* credentials();

    OSB::BackForwardList* backForwardList();
    OSB::URLCredentialStorage* credentialStorage();
    
    void goBack();
    bool canGoBack();
    void goForward();
    bool canGoForward();

    /** Sets the device type to be used. */
    void setDeviceType(OSB::DeviceType deviceType);

    /** Gets the device type currently used in rendering. */
    OSB::DeviceType deviceType() const;

    void setTextSizeMultiplier(float multiplier);

    float textSizeMultiplier();
    
    void setFrameLoadDelegate(OSB::FrameLoadDelegate*);
    void setResourceLoadDelegate(OSB::ResourceLoadDelegate*);
    void setUIDelegate(OSB::UIDelegate*);

    OSB::Root* iface() { return _iface; }

    OSB::ProtocolDelegate* protocolDelegateForURL(const gchar* url);
    
    void registerContentRepresentation(OSB::ContentRepresentationFactory* crf, const gchar* mimeType);
    bool searchFor(const gchar *string, bool forward, bool caseSensitive);

    void setPreferences(const OSB::Preferences& prefs);
    OSB::Preferences*  preferences();

    void setFeatures(const OSB::Features& prefs);
    OSB::Features*  features();
    
    WebCoreSettings* sharedSettings();
    WebCoreSettings* sharedSettings() const;
    
private:
    FrameImpl* _mainFrame;

    OSB::FrameLoadDelegate* frame_d; 
    OSB::ResourceLoadDelegate* res_d;
    OSB::UIDelegate* ui_d;
    OSB::Root* _iface;
    float _textSizeMultiplier;

    FrameGroup* _currentGroup;
    OSB::Preferences prefs;
    OSB::Features feats;
    OSB::DeviceType _deviceType;
};

#endif
