#ifdef DESKTOP_VERSION
#include <qprocess.h>
#else
#include <qtopia/qprocess.h>
#endif
#include <qapplication.h>
#include <qfiledialog.h>
#include <qmessagebox.h>
#include <qtextedit.h>
#include <qtabwidget.h>
#include <qlistview.h>
#include <qlistbox.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qpushbutton.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qstring.h>
#include <stdlib.h>
#include <qregexp.h>
#include "qpkg.h"
#ifndef DESKTOP_VERSION
#include <qtopia/config.h>
#endif
#ifdef QWS
#include <qtopia/qcopenvelope_qws.h>
#endif

#include <stdlib.h>
#include <sys/vfs.h>

#include <iostream>
using namespace std;



qpkg::qpkg( QWidget *parent, const char *name )
    : qpkgBase( parent, name ), ipkgRunning(false)
{
    proc = new QProcess( this );
    connect( proc, SIGNAL(readyReadStdout()), this, SLOT(readFromStdout()) );
    connect( proc, SIGNAL(readyReadStderr()), this, SLOT(readFromStderr()) );
    connect( proc, SIGNAL(processExited()), this, SLOT(ipkgFinished()) );

    log_view->setTextFormat(PlainText);

    QFile optionsFile("/etc/ipkg.conf");
    if (optionsFile.open(IO_ReadOnly)) {
      QTextStream options(&optionsFile);
      QString line;
      QRegExp source( "^src\\s+(\\S+)\\s+(\\S+)" );
      QRegExp dest("^dest\\s+(\\S+)\\s+(\\S+)");
      QRegExp httpproxy("^(#\\s)?option\\s+http_proxy\\s+(\\S+)");
      QRegExp ftpproxy("^(#\\s)?option\\s+ftp_proxy\\s+(\\S+)");
      QRegExp proxyusername("^option\\s+proxy_username\\s+(\\S+)");
      QRegExp proxypassword("^option\\s+proxy_password\\s+(\\S+)");

      while ((line=options.readLine())!= NULL) {
	if ((source.search(line)!=-1)  && (dest.numCaptures()==2)){
	      feeds.push_back(source.cap(1) + " " + source.cap(2));
	} else
	  if ((dest.search(line)!=-1) && (dest.numCaptures()==2)) {
		dests.push_back(Dest(dest.cap(1),dest.cap(2)));
        } else 
	  if (httpproxy.search(line)!=-1) {
	     httpProxyLine->setText(httpproxy.cap(2));
	     if (httpproxy.cap(1)=="") {
	       httpProxyEnable->setChecked(true);
            } else {
               httpProxyEnable->setChecked(false);
	    }
	} else 
	  if (ftpproxy.search(line)!=-1) {
	        ftpProxyLine->setText(ftpproxy.cap(2));
		if (ftpproxy.cap(1)=="") {
		  ftpProxyEnable->setChecked(true);
            } else {
		  ftpProxyEnable->setChecked(false);
	    }
	  } else 
	  if (proxyusername.search(line)!=-1) {
	    loginLine->setText(proxyusername.cap(1));
	    
	} else 
	  if (proxypassword.search(line)!=-1) {
	    passwdLine->setText(proxypassword.cap(1));
	} 
      }
    }


    ipkg_listview->clear();
    for (unsigned int i=0;i<dests.size();i++) {
      updateListView(dests[i].path);
    }
    updateNewListView();
    

    FeedListBox->clear();
    for (unsigned int i=0;i<feeds.size();i++){
      FeedListBox->insertItem(feeds[i]);
    }
    FeedListBox->setCurrentItem(feeds.size());

    update_iconf();
    update_storages();
}

qpkg::~qpkg()
{

}

void qpkg::update_storages()
{
    dest_box->clear();
    for (unsigned int i=0;i<dests.size();i++){
      update_storage(dests[i].path);
    }
}

void qpkg::update_storage( QString disk)
{
 
    struct statfs buf;
    QString str = "mount | grep '" + disk + "'";
 
    if ((!statfs(disk, &buf)) && (system(str) == 0)) {
 
	//long free = buf.f_bavail;
	//long bs = buf.f_bsize;
	//fprintf(stderr, "%ld %ld\n", free, bs);
	int s = buf.f_bavail * buf.f_bsize / 1024;
	QString size;
	if (s > 1024*4) {
	    s /= 1024;
	    size.setNum(s);
	    size.append(" MB");
	} else {
	    size.setNum(s);
	    size.append(" KB");
	}
	dest_box->insertItem(disk + " (" + size + ")" );
    }
}

void qpkg::install_ipkg()
{
#ifndef QT_NO_FILEDIALOG
    if (ipkgRunning) return;
    QString fn = QFileDialog::getOpenFileName( QString::null, /*QString::null*/"Packages (*.ipk *.deb)", this );
    if ( !fn.isEmpty() ) {
        //qDebug("package: " + fn);
	proc->clearArguments();
	proc->addArgument( "ipkg-install" );

	QString dest = dest_box->currentText();
	dest.truncate(dest.find(' '));
	proc->addArgument( dest );
	
	proc->addArgument( fn );
	ipkgRunning = true;
	if ( !proc->start() ) {
	    QMessageBox::critical( 0,
		tr("Fatal error"),
		tr("Could not start the ipkg command."),
		tr("Quit") );
	    ipkgRunning = false;
	    return;
	}
	install_button->setEnabled(false);
	go_button->setEnabled(false);
	reload_button->setEnabled(false);
	dest_box->setEnabled(false);
    }
#else
    update_storages();
    return;
#endif
}

void qpkg::netinstall_ipkg()
{
    if (ipkgRunning) return;

    proc->clearArguments();
    proc->addArgument( "ipkg-install" );
    
    QString dest = dest_box->currentText();
    dest.truncate(dest.find(' '));
    proc->addArgument( dest );

    bool argsOk = false;
    QListViewItem *item = new_listview->firstChild();
    while (item) {
	if (((QCheckListItem *)item)->isOn()) { proc->addArgument( item->text(0) ); argsOk = true; }
	item = item->nextSibling();
    }
    if (!argsOk) {
	QMessageBox::information(0, tr("Warning!"), tr("No package(s) selected!"), QMessageBox::Ok);
	return;
    }

    new_listview->clearSelection();

    ipkgRunning = true;
    if ( !proc->start() ) {
	QMessageBox::critical( 0,
	    tr("Fatal error"),
	    tr("Could not start the ipkg command."),
	    tr("Quit") );
	ipkgRunning = false;
	return;
    }
    
    install_button->setEnabled(false);
    go_button->setEnabled(false);
    reload_button->setEnabled(false);
    dest_box->setEnabled(false);
}

void qpkg::go_ipkg()
{
    switch(tab_window->currentPageIndex()) {
	case 0: remove_ipkg(); break;
	case 1: netinstall_ipkg(); break;
	default: break;
    }
}

void qpkg::remove_ipkg()
{
    if (ipkgRunning) return;
    
    proc->clearArguments();
    proc->addArgument( "ipkg-uninstall" );
    
    QString spisok="";
    bool argsOk = false;
    QListViewItem *item = ipkg_listview->firstChild();
    while (item) {
	if (((QCheckListItem *)item)->isOn()) { proc->addArgument( item->text(0) ); argsOk = true; spisok += " " + item->text(0); }
	item = item->nextSibling();
    }
    if (!argsOk) {
	QMessageBox::information(0, tr("Warning!"), tr("No package(s) selected!"), QMessageBox::Ok);
	return;
    }

    QMessageBox mb(tr("Package manager"), tr("Remove packages "+spisok+"?"), 
		    QMessageBox::NoIcon, QMessageBox::Yes, QMessageBox::No | QMessageBox::Default, 0);
    if ( mb.exec() != QMessageBox::Yes ) return;
    
    ipkg_listview->clearSelection();

    ipkgRunning = true;
    if ( !proc->start() ) {
	QMessageBox::critical( 0,
	    tr("Fatal error"),
	    tr("Could not start the ipkg command."),
	    tr("Quit") );
	ipkgRunning = false;
	return;
    }
    install_button->setEnabled(false);
    go_button->setEnabled(false);
    reload_button->setEnabled(false);
    dest_box->setEnabled(false);
}

void qpkg::readFromStdout()
{
   log_view->moveCursor(QTextEdit::MoveEnd,false);
   log_view->insert(proc->readStdout() );
}

void qpkg::readFromStderr()
{
  log_view->moveCursor(QTextEdit::MoveEnd,false);
  log_view->insert( proc->readStderr() );
}

void qpkg::ipkgFinished()
{
#ifdef QWS
    QCopEnvelope e("QPE/System", "linkChanged(QString)");
    QString lf = QString::null;
    e << lf;
#else
/*
 * matchbox hack for update icons on desktop and menu
 */
    system("killall -HUP matchbox-desktop");
    system("killall -HUP mb-applet-menu-launcher");
#endif
    ipkgRunning = false;
    ipkg_listview->clear();
    for (unsigned int i=0;i<dests.size();i++) {
      updateListView(dests[i].path);
    }
    new_listview->clear();
    updateNewListView();
    install_button->setEnabled(true);
    go_button->setEnabled(true);
    reload_button->setEnabled(true);
    dest_box->setEnabled(true);
    update_storages();
}

void qpkg::updateListView(QString path)
{
    QFile f( QString( path + "/usr/lib/ipkg/status").latin1() );
    if (!f.exists()) {
	//qDebug("!status");
	return;
    }
    f.open( IO_ReadOnly );
    QString str="", pkg_str="", ver_str="", dst_str="";
    bool found = false;
    int pos;
    while(!f.atEnd()) {
	f.readLine(str, 80);
	if ((pos = str.find("Package:",0)) >= 0) {
	    if (found) {
		QListViewItem *tmp  = new QCheckListItem(ipkg_listview, /*dst_str + " " + */ pkg_str /* + " " + ver_str */, QCheckListItem::CheckBox);
		tmp->setText(1, ver_str);
		tmp->setText(2, dst_str);
	    }
	    pkg_str = str.right(str.length() - pos - 9);
	    pkg_str.truncate(pkg_str.length() - 1);
	    found = true;
	} else if ((pos = str.find("Version:",0)) >= 0) {
	    ver_str = str.right(str.length() - pos - 9);
	    ver_str.truncate(ver_str.length() - 1);
	} else if ((pos = str.find("Root:",0)) >= 0) {
	    dst_str = str.right(str.length() - pos - 6);
	    dst_str.truncate(dst_str.length() - 1);
	}
    }
    if (found) {
	found = false;
	QListViewItem *tmp  = new QCheckListItem(ipkg_listview, /*dst_str + " " + */ pkg_str /* + " " + ver_str */, QCheckListItem::CheckBox);
	tmp->setText(1, ver_str);
	tmp->setText(2, dst_str);
    }
    f.close();
}

bool qpkg::checkInst(QString &str)
{
    QListViewItem *item = ipkg_listview->firstChild();
    while (item) {
	if (str == item->text(0)) return true;
	item = item->nextSibling();
    }
    return false;
}

void qpkg::updateNewListView()
{
    system("ipkg info>/tmp/qpkg_packages.123");
    QFile f( QString("/tmp/qpkg_packages.123").latin1() );
    if (!f.exists()) {
	//qDebug("!status ap");
	return;
    }
    f.open( IO_ReadOnly );
    QString str="", pkg_str="", ver_str="", desc_str="", deps_str="";
    bool found = false;
    int pos;
    while(!f.atEnd()) {
	f.readLine(str, 80);
	if ((pos = str.find("Package:",0)) >= 0) {
	    if (found) {
		if (!checkInst(pkg_str)) {
		    QListViewItem *tmp  = new QCheckListItem(new_listview, pkg_str /* + " " + ver_str*/, QCheckListItem::CheckBox);
		    tmp->setText(1, ver_str);
		    tmp->setText(2, desc_str);
		    tmp->setText(3, deps_str);
		}
		pkg_str=""; 
		ver_str="";
		desc_str="";
		deps_str="";
	    }
	    pkg_str = str.right(str.length() - pos - 9);
	    pkg_str.truncate(pkg_str.length() - 1);
	    found = true;
	} else if ((pos = str.find("Version:",0)) >= 0) {
	    ver_str = str.right(str.length() - pos - 9);
	    ver_str.truncate(ver_str.length() - 1);
	} else if ((pos = str.find("Description:",0)) >= 0) {
	    desc_str = str.right(str.length() - pos - 13);
	    desc_str.truncate(desc_str.length() - 1);
	} else if ((pos = str.find("Depends:",0)) >= 0) {
	    deps_str = str.right(str.length() - pos - 9);
	    deps_str.truncate(deps_str.length() - 1);
	}
    }
    if (found) {
	found = false;
	if (!checkInst(pkg_str)) {
	    QListViewItem *tmp  = new QCheckListItem(new_listview, pkg_str /* + " " + ver_str*/, QCheckListItem::CheckBox);
	    tmp->setText(1, ver_str);
	    tmp->setText(2, desc_str);
	    tmp->setText(3, deps_str);
	}
    }
    f.close();
    system("rm -f /tmp/qpkg_packages.123");
}

void qpkg::reload_ipkg()
{
//    qDebug("-- "+QString::number(tab_window->currentPageIndex()));
    if (ipkgRunning) return;
    proc->clearArguments();
    proc->addArgument( "ipkg" );
    proc->addArgument( "update" );
    ipkgRunning = true;
    if ( !proc->start() ) {
	QMessageBox::critical( 0,
	    tr("Fatal error"),
	    tr("Could not start the ipkg command."),
	    tr("Quit") );
	ipkgRunning = false;
	return;
    }
    install_button->setEnabled(false);
    go_button->setEnabled(false);
    reload_button->setEnabled(false);
    dest_box->setEnabled(false);
}

void qpkg::add_feed()
{
  FeedListBox->insertItem(NewNameLineEdit->text().stripWhiteSpace() + " " + NewFeedLineEdit->text().stripWhiteSpace());
    NewFeedLineEdit->setText("");
    NewNameLineEdit->setText("");
    FeedListBox->setCurrentItem(FeedListBox->count()-1);
    update_iconf();
}

void qpkg::remove_feed()
{
    FeedListBox->removeItem(FeedListBox->currentItem());
    update_iconf();
}

void qpkg::edit_feed()
{
  NewNameLineEdit->setText(FeedListBox->currentText().section(" ",0,0));  
  NewFeedLineEdit->setText(FeedListBox->currentText().section(" ",1,1));
}

void qpkg::update_iconf()
{
   
    QFile options("/etc/ipkg.conf");
    if ( options.open(IO_WriteOnly) ) {
	QTextStream opt(&options);
	for (unsigned int i=0; i<FeedListBox->count(); i++) {
	    opt << "src " << FeedListBox->text(i) << "\n";
	}
        for (unsigned int i=0; i< dests.size();i++) {
	  opt << "dest"  << " " << dests[i].name << " " << dests[i].path <<endl;
	}

	if (!httpProxyLine->text().isEmpty()) {
	    if (! httpProxyEnable->isChecked()) {
	      opt << "# "; 
	    }
	    opt << "option http_proxy " << httpProxyLine->text() << "\n";
	}
	if (!ftpProxyLine->text().isEmpty()) {
	  if (! ftpProxyEnable->isChecked()) {
            opt << "# ";
	  }
	  opt << "option ftp_proxy " << ftpProxyLine->text() << "\n";
	}
	if (!loginLine->text().isEmpty()) {
	    opt << "option proxy_username " << loginLine->text() << "\n";
	    opt << "option proxy_password " << passwdLine->text() << "\n";
	}	
    }
}

void qpkg::proxy_apply()
{
    update_iconf();
}

