/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the demonstration applications of the Qt Toolkit.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "imagemodel.h"

ImageModel::ImageModel(const QString &fileName, QObject *parent)
    : QAbstractTableModel(parent)
{
    image.load(fileName);
}

ImageModel::~ImageModel()
{

}

int ImageModel::rowCount() const
{
    return image.height();
}

int ImageModel::columnCount() const
{
    return image.width();
}

QVariant ImageModel::data(const QModelIndex &index, int role) const
{
    if (index.isValid() && role == QAbstractItemModel::DisplayRole)
        return image.pixel(index.column(), index.row());
    return QVariant();
}

bool ImageModel::setData(const QModelIndex &index, int role, const QVariant &value)
{
    if (index.isValid() && role == QAbstractItemModel::EditRole) {
        image.setPixel(index.column(), index.row(), value.toInt());
        emit dataChanged(index, index);
        return true;
    }
    return false;
}

QAbstractItemModel::ItemFlags ImageModel::flags(const QModelIndex &index) const
{
    return QAbstractItemModel::flags(index) | ItemIsEditable;
}
