/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the widgets module of the Qt Toolkit.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef QGRIDWIDGET_H
#define QGRIDWIDGET_H

#include "qframe.h"

#ifndef QT_NO_GRIDWIDGET

class QGridLayout;

class Q_GUI_EXPORT QGridWidget : public QFrame
{
    Q_OBJECT

public:
    QGridWidget(int n, QWidget *parent = 0, Qt::WFlags f = 0);
    QGridWidget(int n, Qt::Orientation orientation, QWidget *parent = 0, Qt::WFlags f = 0);

    void setMargin(int margin);
    void setSpacing(int spacing);

#ifdef QT_COMPAT
    QT_COMPAT_CONSTRUCTOR QGridWidget(int n, QWidget* parent, const char* name, Qt::WFlags f);
    QT_COMPAT_CONSTRUCTOR QGridWidget(int n, Qt::Orientation orientation, QWidget* parent, const char* name, Qt::WFlags f);
    typedef Qt::Orientation Direction;
#endif

protected:
    void childEvent(QChildEvent*);

private:
    Q_DISABLE_COPY(QGridWidget)

    QGridLayout *lay;
};

#endif // QT_NO_GRIDWIDGET

#endif // QGRIDWIDGET_H
