/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the designer application of the Qt Toolkit.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "newformdialog.h"

#include <QPushButton>
#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QHeaderView>
#include <QTreeWidget>
#include <QTreeWidgetItem>

NewFormDialog::NewFormDialog(QWidget *parent) : QDialog(parent)
{
    setWindowTitle(tr("Create New Form"));
    QVBoxLayout *mainLayout = new QVBoxLayout(this);

    mWidgetTree = new QTreeWidget(this);
    mWidgetTree->setColumnCount(1);
    mWidgetTree->header()->setResizeMode(QHeaderView::Stretch);
    mWidgetTree->header()->hide();

    QTreeWidgetItem *root = new QTreeWidgetItem(mWidgetTree);
    root->setText(0, tr("Standard Templates"));
    mWidgetTree->openItem(root);
    QTreeWidgetItem *item = new QTreeWidgetItem(root);
    item->setText(0, tr("Dialog"));
    item->setText(1, tr("QDialog"));
    item = new QTreeWidgetItem(root);
    item->setText(0, tr("Widget"));
    item->setText(1, tr("QWidget"));
    mWidgetTree->setSelected(item, true);
    mWidgetTree->setCurrentItem(item);

    QHBoxLayout *buttonLayout = new QHBoxLayout();
    QPushButton *btn = new QPushButton(tr("&Open..."), this);
    connect(btn, SIGNAL(clicked()), this, SIGNAL(needOpen()));
    buttonLayout->addWidget(btn);
    btnCreate = new QPushButton(tr("&Create"), this);
    btnCreate->setEnabled(false);
    connect(btnCreate, SIGNAL(clicked()), this, SLOT(createThisOne()));
    buttonLayout->addSpacing(1);
    buttonLayout->addWidget(btnCreate);
    btn = new QPushButton(tr("Cancel"), this);
    connect(btn, SIGNAL(clicked()), this, SLOT(reject()));
    buttonLayout->addWidget(btn);

    mainLayout->addWidget(mWidgetTree);
    mainLayout->addLayout(buttonLayout);
    connect(mWidgetTree, SIGNAL(clicked(QTreeWidgetItem *, int, Qt::MouseButton, Qt::KeyboardModifiers)),
            this, SLOT(fixButton(QTreeWidgetItem *)));
    connect(mWidgetTree, SIGNAL(doubleClicked(QTreeWidgetItem *, int, Qt::MouseButton, Qt::KeyboardModifiers)),
            this, SLOT(handleDoubleClick(QTreeWidgetItem *)));
    connect(mWidgetTree, SIGNAL(returnPressed(QTreeWidgetItem *, int)),
            this, SLOT(handleDoubleClick(QTreeWidgetItem *)));
    fixButton(item);
}

NewFormDialog::~NewFormDialog()
{
}

void NewFormDialog::handleClass(const QString &str)
{
    emit itemPicked(str);
    accept();
}

void NewFormDialog::handleDoubleClick(QTreeWidgetItem *item)
{
    if (item && item->parent())
        handleClass(item->text(1));

}

void NewFormDialog::createThisOne()
{
    if (QTreeWidgetItem *item = mWidgetTree->currentItem()) {
        if (item->parent())
            handleClass(item->text(1));
    }
}

void NewFormDialog::fixButton(QTreeWidgetItem *item)
{
    bool enable = ((item && item->parent())
                    || (mWidgetTree->currentItem() && mWidgetTree->currentItem()->parent()));
    btnCreate->setDefault(enable);
    btnCreate->setEnabled(enable);
}
