/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the designer application of the Qt Toolkit.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef ABSTRACTWIDGETBOX_H
#define ABSTRACTWIDGETBOX_H

#include <QWidget>

#include "sdk_global.h"

class DomUI;

class QT_SDK_EXPORT AbstractWidgetBox : public QWidget
{
    Q_OBJECT
public:
    AbstractWidgetBox(QWidget *parent = 0, Qt::WFlags flags = 0);
    virtual ~AbstractWidgetBox();

    virtual int categoryCount() const = 0;
    virtual DomUI *category(int cat_idx) const = 0;
    virtual int widgetCount(int cat_idx) const = 0;
    virtual DomUI *widget(int cat_idx, int wgt_idx) const = 0;

    virtual int addCategory(const QString &name, const QString &icon_file, DomUI *ui) = 0;
    virtual void removeCategory(int cat_idx) = 0;
};

#endif // ABSTRACTWIDGETBOX_H
