/**********************************************************************
** Copyright (C) 2000-2002 Trolltech AS.  All rights reserved.
**
** This file is part of the Qtopia Environment.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/
#ifndef GLOBAL_H
#define GLOBAL_H

#include <qtopia/qpeglobal.h>
#include <qtopia/quuid.h>
#include <qstringlist.h>
#include <qguardedptr.h>
#include <qwidget.h>

class QDawg;
class QLabel;
class AppLnk;
class DocLnkSet;
class QFile;

#if defined(__GNUC__) && !defined(NO_DEBUG)
// C99 defines __func__ instead of __FUNCTION__, possibly supported on windows
# include <time.h>
# include <sys/times.h>
# define QTOPIA_PROFILE(s)    qDebug("%fms %s (%s), line: %i file: %s", times(0)*1000.0/CLOCKS_PER_SEC, __FUNCTION__, s, __LINE__, __FILE__ )
#else
# define QTOPIA_PROFILE(s)
#endif

class QTOPIA_EXPORT Global
{
public:
    static QUuid generateUuid(); // libqtopia

    static QString homeDirPath(); // libqtopia
    static bool renameFile( QString from, QString to ); // libqtopia
    static QString tempName(const QString &filename); // libqtopia
    static QString journalFileName(const QString &filename); // libqtopia

    static QString applicationFileName(const QString& appname, const QString& filename);
    static void findDocuments(DocLnkSet* folder, const QString &mimefilter=QString::null);
    static bool isDocumentFileName(const QString& file); // libqtopia
    static bool isAppLnkFileName(const QString& file); // libqtopia

#ifdef QTOPIA_INTERNAL_FILEOPERATIONS
    static bool truncateFile(QFile &f, int size);
    static QString tempDir( );
#endif

#ifdef QTOPIA_INTERNAL_LANGLIST
    static QStringList languageList();
    static QStringList helpPath();
#endif

    static void statusMessage(const QString&);

    static QString shellQuote(const QString& s);
    static QString stringQuote(const QString& s);

    static QByteArray encodeBase64(const QByteArray& origData); // libqtopia
    static QByteArray decodeBase64(const QByteArray& encoded); // libqtopia
    static bool weekStartsOnMonday(); // libqtopia
    static void setWeekStartsMonday(bool ); // libqtopia

#ifdef Q_WS_QWS

    Global();

    // Dictionaries
    static const QDawg& fixedDawg();
    static const QDawg& addedDawg();
    static const QDawg& dawg(const QString& name);

    static void addWords(const QStringList& word);
    static void addWords(const QString& dictname, const QStringList& word);
    // static void removeWords(const QStringList& word); -- if someone wants it

    static void createDocDir();

    static QString version(); // libqtopia
    static QString architecture(); // libqtopia
    static QString deviceId(); // libqtopia
    static QString ownerName(); // libqtopia

    struct Command {
	const char *file;
	QWidget *(*func)( bool );
	bool maximized;
	bool documentary;
    };
    static void setBuiltinCommands( Command* );
    static Command* builtinCommands();
    static QGuardedPtr<QWidget>* builtinRunning();

    static void execute( const QString &exec, const QString &document=QString::null );
    static void setDocument( QWidget* receiver, const QString& document );
    static bool terminateBuiltin( const QString& );
    static void terminate( const AppLnk* );

    static bool isBuiltinCommand( const QString &name );

    // system messaging
    static void applyStyle();
    static QWidget *shutdown( bool = FALSE );
    static QWidget *restart( bool = FALSE );
    static void hideInputMethod();
    static void showInputMethod();

    static void writeHWClock();

#ifdef QTOPIA_INTERNAL_FILEOPERATIONS
    enum Lockflags {LockShare = 1, LockWrite = 2, LockBlock = 4};
    static bool lockFile(QFile &f, int flags = -1);
    static bool unlockFile(QFile &f);
    static bool isFileLocked(QFile &f, int flags = -1);
#endif

private:
    static void invoke( const QString &exec);
    static Command* builtin;
    static QGuardedPtr<QWidget> *running;
    static void removeRunningArray();
#endif
};

#ifdef QTOPIA_INTERNAL_FILEOPERATIONS
QString qtopia_tempName( const QString &fname );
bool qtopia_renameFile( QString from, QString to );
#endif

#endif
