/**********************************************************************
** Copyright (C) 2000 Trolltech AS.  All rights reserved.
**
** This file is part of Qtopia Environment.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#include <qtopia/calc/doubleinstruction.h>
#include <qtopia/qpeapplication.h>
#include "simple.h"


FormSimple::FormSimple(QWidget *parent) :QWidget(parent) {
    QSizePolicy mySizePolicy(QSizePolicy::Preferred,QSizePolicy::Preferred,FALSE);

    bool portrait;
    
    QWidget *d = QPEApplication::desktop();
    QGridLayout * grid;

    Type1DecimalInputWidget *siw = new Type1DecimalInputWidget(this,"SIW");
    siw->setSizePolicy(mySizePolicy);
    
    if ( d->width() < d->height() ) {  //portrait mode
        grid = new QGridLayout(this, 5, 4, 0 , -1, "grid");
        grid->addMultiCellWidget(siw, 1, 4, 0, 3);
        portrait = TRUE;
    } else { //landscape mode
        grid = new QGridLayout(this, 4, 5, 0, -1,  "grid");
        grid->addMultiCellWidget(siw, 0, 3, 0, 3);
        portrait = FALSE;
    }
    
    
    QFont big(font());
    big.setPointSize(big.pointSize()*2);

    QPushButton *PBMPlus = new QPushButton(this,"PBM+");
    PBMPlus->setSizePolicy(mySizePolicy);
    PBMPlus->setText(tr("M+"));
    PBMPlus->setFont(big);

    QPushButton *PBMC = new QPushButton(this,"PBMC");
    PBMC->setSizePolicy(mySizePolicy);
    PBMC->setText(tr("MC"));
    PBMC->setFont(big);

    QPushButton *PBMR = new QPushButton(this,"PBMR");
    PBMR->setSizePolicy(mySizePolicy);
    PBMR->setText(tr("MR"));
    PBMR->setFont(big);

    QPushButton *PBCE = new QPushButton(this,"PBCE");
    PBCE->setSizePolicy(mySizePolicy);
    PBCE->setText(tr("CE/C"));
    PBCE->setFont(big);

    if (portrait) {
        grid->addWidget(PBCE, 0, 3);
        grid->addWidget(PBMC, 0, 1);
        grid->addWidget(PBMR, 0, 2);
        grid->addWidget(PBMPlus, 0, 0);
    } else {
        grid->addWidget(PBCE, 0, 4);
        grid->addWidget(PBMC, 1, 4);
        grid->addWidget(PBMR, 2, 4);
        grid->addWidget(PBMPlus, 3, 4);
    }
        
         

    connect (PBCE, SIGNAL(clicked()), this, SLOT(CEClicked()));
    connect (PBMR, SIGNAL(clicked()), this, SLOT(MRClicked()));
    connect (PBMC, SIGNAL(clicked()), this, SLOT(MCClicked()));
    connect (PBMPlus, SIGNAL(clicked()), this, SLOT(MPlusClicked()));

}

void FormSimple::showEvent ( QShowEvent *e ) {
    systemEngine->setAccType("Double"); // No tr
    QWidget::showEvent(e);
}

void FormSimple::CEClicked() {
    systemEngine->dualReset();
}
void FormSimple::MCClicked() {
    systemEngine->memoryReset();
}
void FormSimple::MRClicked() {
    systemEngine->memoryRecall();
}
void FormSimple::MPlusClicked() {
    systemEngine->memorySave();
}

