/**********************************************************************
** Copyright (C) 2000-2002 Trolltech AS.  All rights reserved.
**
** This file is part of the Qtopia Environment.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/
#ifndef LOADING_WIDGET_H
#define LOADING_WIDGET_H


#include <qprogressbar.h>
#include "launcherview.h"


class LoadingWidget : public LauncherView 
{
    Q_OBJECT
public:
    LoadingWidget( QWidget *parent, const char *name = 0 );
    ~LoadingWidget();

    void setEnabled( bool );
    bool enabled() const { return docLoadingWidgetEnabled; }

    void setProgressStyle();
    void setLoadingWidgetEnabled( bool v );
    void setProgress( int percent );

private:
//    LauncherView *docLoadingWidget;
    QProgressBar *docLoadingWidgetProgress;
    bool docLoadingWidgetEnabled;
};


#endif // LOADING_WIDGET_H

