package javasci ;
/********************************************************************************************************/
/* Allan CORNET */
/* INRIA 2005 */
/********************************************************************************************************/
public class SciReal
{
/********************************************************************************************************/
  private double [] x ;
  private int m, n;
  private String name; 
/********************************************************************************************************/  
  public native void Job(String job);
  public native void Get();
  public native void Send();
/********************************************************************************************************/  
  static 
  {
    System.loadLibrary("javasci");
  }
/********************************************************************************************************/  
  public SciReal(String name,SciReal Obj) 
  {
    this.name = name;
    this.m = Obj.getRow() ;
    this.n = Obj.getCol();
    this.x = new double[m*n];
   
    this.x =Obj.getData() ;
  }
/********************************************************************************************************/  
  public SciReal(String name,int m,int n) 
  {
    this.m = m ;
    this.n = n;
    this.x = new double[m*n];
    this.name = name;
   
    for ( int i = 0 ; i < m*n ; i++)x[i]=0;
  }
 /********************************************************************************************************/  
  public SciReal(String name,int m,int n,double [] x )
  {
    if ( m*n != x.length) 
    {
     throw new BadDataArgumentException("Bad Matrix call, size of third argument is wrong");
    }
    this.m = m ;
    this.n = n;
    this.x = x;
    this.name = name;
  }
/********************************************************************************************************/
  public int getRow() 
  {
   return m;
  }
/********************************************************************************************************/  
  public int getCol() 
  {
   return n;
  }
/********************************************************************************************************/  
  public String getName()
  {
   return name;
  }
/********************************************************************************************************/  
  public double[] getData() 
  {
   Get();
   return x;
  }
/********************************************************************************************************/  
  public void disp() 
  {
	Get();
    System.out.println("Matrix "+ getName() +"=");
    Job( "disp(" + getName() +");");
  }
}
/********************************************************************************************************/