#ifndef _LAN_H_
#define _LAN_H_

#include "lanbase.h"
#include "config.h"

class Lan: public LanBase
{
    Q_OBJECT
public:
    Lan(QWidget *parent = 0, const char *name = 0);
    ~Lan();

private:
    Config *config;
    QButtonGroup *ipGroup;
    bool writePcmciaNetworkOpts( Config *config, QString scheme );
    bool writeNetworkOpts( Config *config, QString scheme );
    void readConfig(Config *config);
    bool writeConfig(Config *config);
    void removeConfig(QString n);
    void addConfig(QString n);

private slots:
    void ipSelect( int id );
    void Apply();
    void cable_selected();
    void wifi_selected();
    void bt_selected();
    void remove_account();
    void new_account(const QString &str);
    void new_wifi_mode(int i);
};

#endif
