// generated by Fast Light User Interface Designer (fluid) version 1.0105

#include "giacintl.h"
#include "xcas.h"
#include <stdio.h>
#include <locale.h>
#include <signal.h>
#include <unistd.h>
#include <sys/types.h>
#include <time.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <sys/wait.h>
#include <cmath>
#include "gen.h"
#include "identificateur.h"
#include "tex.h"
#include "sym2poly.h"
#include "usual.h"
#include "plot.h"
#include "prog.h"
#include "ifactor.h"
#include "derive.h"
#include "intg.h"
#include "lin.h"
#include "tex.h"
#include "gauss.h"
#include "solve.h"
#include "subst.h"
#include "isom.h"
#include "permu.h"
#include "misc.h"
#include "input_lexer.h"
#include "help.h"
#include "rpn.h"
#include "mathml.h"
/* */ using namespace giac;
/* */ using namespace std;
static int helpitems,xcas_argc;
static char ** xcas_argv;
static Fl_Input ** Help_Chooser_Input_Array;
static int png_count=0,HTMLindex=0;
static int mouse_x_save=0;
static int mouse_y_save=0;
static vector<aide> aide_v;
static aide cur_aide;
static int run_plot_setup=0,run_cas_setup=0,run_general_setup=0;
static int matrix_symmetry=0;
static int scroll_value_save=0;
static int prg_input_position=0,prg_input_mark=0,help_hint=5;
static int session_counter=0,program_counter=0,sheet_counter=0,eqw_counter=0;
static char progfilename[1024]="session.cxx",matrixfilename[1024]="session.tab",eqwfilename[1024]="session.eqw";
static bool maj=false,help_chooser=false,full_helptext=false,history_saved=true;
static char filename[1024]="session.ar",bandeau_label[1024]="";
static char petit_buffer[2];
static std::string doc_prefix="doc/fr/",current_help_string;
static gen eqw_clipboard;
static int the_pipe[2];
static vecteur rpn_menu;
static vecteur rpn_description;
static int rpn_menu_page;
#define BUTTON_PER_PAGE 6;
#define BUFFER_SIZE 100000
static bool fl_handle_lock=false;
Fl_Widget * help_save_focus,*eval_last_focus;
static vecteur mem_menu,debug_menu,boolean_menu,control_menu,tools_menu,alg_menu,geo_menu,maths_menu,phys_menu,prg_menu,cas_menu,home_menu,lycee_menu;
static std::map<std::string,giac::editor_string> Xcas_program_map;
#ifdef HAVE_LIBFLVW //
static std::map<std::string,giac::xcas_matrix> Xcas_matrix_map;
#endif //
static string rpn_menu_string[6]; string debug_prog_name; bool rpn_menu_is_directory[6];
static bool is_answer=false;
giac::Flv_Table_Gen *spread_ptr;
static Flve_Input * spread_editor;
static Fl_Hold_Browser * help_related,*help_examples;
void manage_upper_window(int i,bool force);
static void cb_Xcas_program_list_new(Fl_Menu_*, void*);
static void cb_Xcas_matrix_list_new(Fl_Menu_*, void*);
static void cb_Xcas_tortue_bonjour(Fl_Menu_*, void*);

void a_propos() {
  string s("xcas "); s+=VERSION; s+=" (c) 2004, Bernard Parisse, Rene De Graeve\n";
  s += "http://www-fourier.ujf-grenoble.fr/~parisse/giac.html\nftp://ftp-fourier.ujf-grenoble.fr/xcas\n";
  s += "If you like xcas, please link your webpage to the above link\n";
  s += "to help other find xcas using e.g. google\n";
  s += "Math ML support, xcas online: Jean-Pierre Branchard\n";
  s += "Spanish localization, J. Manrique Lopez\n";
  s += "Debian package: Carlos Enrique Carleos Artime\n";
  s += "Mac OS X port thanks to Jean-Yves Avenard and IREM Grenoble\n";
  s += "Xcas testers: Christiane Serret et ses lves du lyce de Crest,\nMichle Gandit et ses lves du lyce international de Grenoble,\nJuan Antonio Martinez Rojas, Nicolas Rosillo (Spain)\nSbastien Celles, Grard Vinel, Robert Rolland, Robert Stif\n";
  s += "Francois Maltey (Mupacs)\nFrederic Faure, Emilien Kia, Andreas Thillosen (giac)\n";
  s += "Uses GMP, (c) T. Granlund & al.\n";
#ifdef HAVE_LIBMPFR
  s += "Longfloat support by MPFR, G. Hanrot, P. Zimmermann, V. Lefevre & al. \n";
#endif //
  s += "Interface using FLTK (c) Bill Spitzak et al\n";
#ifdef HAVE_LIBFLVW
  s += "FLVW (c)Larry Charlton and others\n";
#endif
#ifdef HAVE_LIBPARI
  s += "Contains PARI code (c) Henri Cohen & al.\n";
#endif //
#ifdef HAVE_LIBGSL
  s += "Contains GSL code (c) Mark Galassi, James Theiler & al\n";
#endif //
#ifdef HAVE_LIBNTL
  s += "Contains NTL code (c) Victor Shoup\n";
#endif //
  s += "Postscript output of geometry inspired by eukleides (c) Christian Obrecht\n";
  s += "Licensed under the GPL, General Public License 2.0 or later\nSee the file COPYING in this package for more details\nOr browse http://www.gnu.org\n";
  s += "Except for the French documentation (c) Renee de Graeve\n";
  s += "This documentation is freely redistribuable for non commercial purpose";
  Help_text_value(s.c_str());
}

void unlink_tmp_files() {
  string tmp="xcas_"+print_INT_(getpid());
 unlink((tmp+".ar").c_str());
 for (int i=0;i<=3;i++){
   string suffixe("cas");
   if (i==1)
     suffixe="map";
   if (i==2)
     suffixe="mup";
   if (i==3)
     suffixe="tix";
   if (!access((tmp+"."+suffixe).c_str(),R_OK)){
     unlink((tmp+"."+suffixe).c_str());
     unlink((tmp+".tex").c_str());
   }
 }
}

int clear_history() {
  int i=fl_ask(gettext("Really clear?"));
 if (i==1){
  history_in.clear();
  history_out.clear();
  history_begin_level=0;
  history_endlines.clear();
  history_positions.clear();
  Picture->clear();
  Picture->redraw();
  PICTautoname="A";
  xcas_output->value("");
  scroll_value_save=0;
  Xcas_Output_scroll->value(0,1,0,1);
  Eqw_history->data=Eqw_nullstring(Eqw_history->attr);
  save_eqw_data=Eqw_history->data;
  Eqw_history->redraw();
  strcpy(filename,"session.ar");
  Xcas->label("xcas: session.ar");
  bandeau_fill_label_redraw();
  Xcas->redraw();
 }
 return i;
}

void rm_variables() {
  PICTautoname="A"; input_value("rm_all_vars()"); input_eval(false);
}

bool shifton() {
  bool shift= (Fl::event_state()== FL_SHIFT );
    if (shift_on)
      return !shift;
    else
      return shift;
}

bool Program_editor_changed() {
  return editor_changed;
}

void Xcas_editor_filename_value(const char * ch) {
  if (ch!=progfilename)
    strcpy(progfilename,ch);
  Xcas_editor_filename->value(ch); 
  int pos=strlen(ch); 
  Xcas_editor_filename->position(pos,pos);
  // recompute Xcas_program_list_menu from Xcas_program_map
  int n=Xcas_program_list_menu->size();
  for (int i=n-2;i>1;--i)
   Xcas_program_list_menu->remove(i);
  map<string,editor_string>::const_iterator it=Xcas_program_map.begin(),itend=Xcas_program_map.end();
  for (;it!=itend;++it){
    if (it->first!="session.cxx")
      Xcas_program_list_menu->add(it->first.c_str(),0,(Fl_Callback*)cb_Xcas_program_list_new);
  }
}

void Xcas_matrix_filename_value(const char * ch) {
  #ifdef HAVE_LIBFLVW
if (ch!=matrixfilename)
    strcpy(matrixfilename,ch);
  update_sheet_label();
  // recompute Xcas_matrix_list_menu from Xcas_matrix_map
  int n=Xcas_matrix_list_menu->size();
  for (int i=n-2;i>1;--i)
   Xcas_matrix_list_menu->remove(i);
  map<string,xcas_matrix>::const_iterator it=Xcas_matrix_map.begin(),itend=Xcas_matrix_map.end();
  for (;it!=itend;++it){
    if (it->first!="session.tab")
      Xcas_matrix_list_menu->add(it->first.c_str(),0,(Fl_Callback*)cb_Xcas_matrix_list_new);
  }
  Xcas_matrix_list_menu->redraw();
#endif
}

std::string Program_editor_value() {
  char * ch=Program_editor->buffer()->text(); 
  string res(ch); free(ch);
  return res;
}

void Program_editor_position(int & i,int & j) {
  if (Program_editor->buffer()->selected())
    Program_editor->buffer()->selection_position(&i,&j); 
  else {
    i=Program_editor->insert_position();
    j=i; 
  }
}

void set_language(int i) {
  language=i;
  switch (language){
    case 1:
      doc_prefix="doc/fr/";
      break;
    case 2:
      doc_prefix="doc/en/";
      break;
    case 3:
      doc_prefix="doc/es/";
      break;
    default:
      doc_prefix="doc/en/";
  }
}

void Eqw_eqw_escape(giac::Eqw * eqwptr) {
  eqwptr->parse_desactivate();
eqw_ok(true);
}

void Eqw_eqw_enter(giac::Eqw * eqwptr) {
  eqwptr->parse_desactivate();
eqwptr->select();
eqwptr->fl_select();
}

int Eqw_history_update(giac::Eqw * eqwptr) {
  eqwptr->parse_desactivate();
   // recompute history_in from eqwptr, and find 1st modified level
   gen g=eqwptr->get_data();
   if (g.type!=_VECT || g.subtype!=_HIST__VECT)
     return -1;
   vecteur tmp=*g._VECTptr;
   const_iterateur it=tmp.begin(),itend=tmp.end();
   if (rpn_mode){
     int n=history_out.size(),j=0;
     for (;j<n && it!=itend;++j,++it)
       history_out[j]=(*it)[1];
     for (;it!=itend;++it){
       gen tmp=(*it)[1];
       if (tmp.type!=_STRNG || !tmp._STRNGptr->empty() ){
         history_in.push_back(tmp);
         history_out.push_back(tmp);
       }
     }
     return -1;
   }
   int n=history_in.size(),j=0;
   for (;j<n && it!=itend;++j,++it){
     if ((*it)[0]!=history_in[j])
       break;
   }
   if (j==n && it==itend)
     return -1;
   else {
     int j0=j;
     for (;j<n && it!=itend;++j,++it){
       history_in[j]=(*it)[0];
     }
     for (;it!=itend;++it){
       gen tmp=(*it)[0];
       if (tmp.type!=_STRNG || !tmp._STRNGptr->empty() ){
         if (!is_semi_expr(tmp)){
           history_in.push_back(tmp);
           history_out.push_back(tmp);
         }
       }
     }
     return j0;
  }
}

void win32_recalc_history() {
  int s=history_in.size();
    block_signal=true;
    for (int i=run_modif_pos;i<s;++i){
      try {
        history_out[i]=eval(history_in[i]);
      }
      catch (std::runtime_error & e){
        history_out[i]=string2gen(e.what(),false);
      }
    }
    block_signal=false;
    Picture->clear();
    int i=erase_pos();
    updatePICT(vecteur(history_out.begin()+i,history_out.end()));
    Picture->redraw();
    // red_draw=false;
  redraw_finish("");
  return;
}

void Eqw_history_enter(giac::Eqw * eqwptr) {
  eval_last_focus=eqwptr;
int n=history_in.size();
   bool active=eqwptr->parse_desactivate();
   int h=history_pos();
   int j=Eqw_history_update(eqwptr);
   if (!Recompute_history->value()){
     if (j>h && history_in.size()>j)
       h=j;
     else
       j=h;
   }
   if (active && (j==-1 || h<j) && h<n && history_in[h].is_symb_of_sommet(at_read))
     j=h;
   if (active && j!=-1 && j<=h ){
     // get current history level
     gen f;
     if (h<history_in.size())
       f=history_in[h];
     if (f.is_symb_of_sommet(at_sto))
       f=f._SYMBptr->feuille._VECTptr->front();
     // check if it is an expr
     if (h<n && f.is_symb_of_sommet(at_expr)){
       // yes, then we parse this level and check syntax errors
       f=f._SYMBptr->feuille;
       if (f.type==_STRNG && *f._STRNGptr!=";"){
         f=gen(*f._STRNGptr);
         if (giac::first_error_line){
            Eqw_select(eqwptr->data,false);
            Help_text_value((gettext("Parse error line ")+print_INT_(giac::first_error_line)+ gettext(" at ") +giac::error_token_name).c_str());
            // put the cursor at the right place
            if (eqwptr->data.type==_VECT && 2*h<eqwptr->data._VECTptr->size()){
              gen ff = (*eqwptr->data._VECTptr)[2*h];
              if (ff.type==_VECT){
                vecteur ffv=*ff._VECTptr;
                if (!ffv.empty() && ffv.back().type==_EQW && ffv.back()._EQWptr->g==at_sto){
               ff=ffv.front();
               if (ff.type==_VECT)
                 ffv=*ff._VECTptr;
            }
                if (!ffv.empty() && ffv.back().type==_EQW && ffv.back()._EQWptr->g==at_expr){
                  gen & fff = ffv.front();
                  if (fff.type==_VECT){
                   vecteur & fffv = *fff._VECTptr;
                   if (!fffv.empty() && fffv.back().type==_EQW && fffv.back()._EQWptr->g==at_multistring && giac::first_error_line<fffv.size()){
                     Eqw_select(fffv[giac::first_error_line-1],true);
                     eqwptr->adjust_xy_sel();
                     }
                  }
                }
              }
            }
            return;
         }
       }
     }
   }
   if (j==-1)
     history_redraw(n);
   else {
    if (Recompute_history->value()){
     run_modif_pos=j;
#ifdef WIN32 //
  win32_recalc_history();
#else //
     run_modif=true;
     if (child_reeval(run_modif_pos)){
       run_modif=false;
     }
#endif //
    }       
    else {
      history_out[j]=protecteval(history_in[j],100,0);
      is_answer=false;
      if (j<n){
        xcas_history_select(j);
        bool save_rpn_mode=rpn_mode;
        rpn_mode=true; // this is for replace_selection
        // redraw history level j
        Eqw_history->replace_selection(history_in[j],false);
        Eqw_history->select_right(0);
        Eqw_history->replace_selection(history_out[j],false);
        rpn_mode=save_rpn_mode;
      }
      else
        history_redraw(n);
      xcas_history_select(j+1);
      Eqw_history->select_down(0);
      Eqw_history->select_down(0);
    }
  }
}

void Eqw_history_escape(giac::Eqw * eqwptr) {
  history_redraw(history_in.size());
}

void Eqw_history_backspace(giac::Eqw * eqwptr) {
  eval_last_focus=eqwptr; erase_history_levels();
}

void Eqw_eqw_select(const char * ch) {
  input_value(ch);
}

void Eqw_IDS(giac::Eqw * eqwptr,const giac::gen & newg) {
  eqwptr->parse_desactivate();
               gen g(eqwptr->get_selection());
               newg._SYMBptr->feuille._VECTptr->front()=g;
               eqwptr->replace_selection(newg);
               Fl::focus(eqwptr);
               eqwptr->select_down(0);
               eqwptr->select_right(0);
}

void xcas_windows(int n) {
  int oldn=int(Split_windows->value());
Picture->window_xmax=Picture->window_xmin+oldn*(Picture->window_xmax-Picture->window_xmin)/n;
Picture2global_window();
Split_windows->value(n);
int s=current_upper_window.size();
if (n==s) return;
if (n<s){
  for (int j=s;j>n;--j)
    current_upper_window.pop_back();
}
else {
  for (int i=s;i<n;++i)
    current_upper_window.push_back(0);
}
}

int file_not_available(const char * newfile) {
  if (!newfile)
    return true;
  if (access(newfile,R_OK)){
    cerr << "The file " << newfile << " does not exist!" << endl;
    Help_text_value(("The file "+string(newfile)+" does not exist!").c_str());
    return true;
  }
  return false;
}

void fl_handle() {
  if (fl_handle_lock)
    return;
  fl_handle_lock=true;
  Fl::handle(FL_KEYBOARD,Xcas);
  fl_handle_lock=false;
}

void focus_output() {
  if (Eqw_history->visible() && !rpn_mode){
    Fl::focus(eval_last_focus);
    input_position(0,string(input->value()).size());
  }
  else
    Fl::focus(xcas_output);
}

void focus_history() {
  if (Picture->run_plot_view)
  Fl::focus(input);
else {
  if (Eqw_history->visible())
    Fl::focus(Eqw_history);
  else
    Fl::focus(xcas_output);
}
}

const char * input_value() {
  return input->value();
}

int find_sort_row(int c2,bool isrow) {
  int c;
  if (maple_mode)
    c=c2+1;
  else
    c=c2;
  string question=gettext("Sort with respect to ");
  if (isrow)
    question += gettext("row");
  else
    question += gettext("column");
  const char * chptr=fl_input(question.c_str(),print_INT_(c).c_str());
  if (!chptr)
    return -1;
  string colonne(chptr);
  gen g(colonne);
  if (maple_mode)
    g = g + minus_one;
  if (g.type!=_INT_ )
    return -1;
  return g.val;
}

void sheetsort(bool row_sort,bool increasing) {
  #ifdef HAVE_LIBFLVW
   if (spread_ptr->is_spreadsheet){
       int i=fl_ask(gettext("Sorting is not compatible with some cell references. Sort anyway"),gettext("Yes"),gettext("No"));
       if (i!=1) return ;
    }
    int r1,r2,c1,c2;
    matrice m;
    if (row_sort){ // Transpose if sort w.r. to current row
      m=mtran(spread_ptr->m);
      r1=spread_ptr->col();
      r2=spread_ptr->push_col;
      c1=spread_ptr->row();
      c2=spread_ptr->push_row;
      int r=find_sort_row(c2,true);
      if (r<0 || r>=spread_ptr->rows())
       return;
      spread_ptr->sort_col=r;
    }
    else {
      m=spread_ptr->m;
      r1=spread_ptr->row();
      r2=spread_ptr->push_row;
      c1=spread_ptr->col();
      c2=spread_ptr->push_col;
      if (spread_ptr->is_spreadsheet){
        int i=c2,r,c;
        string tmp;
        for(int j=0;;++j){
          tmp=char('A'+i%26-(j!=0))+tmp;
          i=i/26;
          if (!i)
	    break;
        }
       string question=gettext("Sort with respect to ");
       if (row_sort)
         question += gettext("row");
       else
         question += gettext("column");
        const char * chptr=fl_input(question.c_str(),tmp.c_str());
	if (!chptr){
           return;
        }
        string therow=chptr;
        therow +='1';
        if (!iscell(therow,r,c))
          return;
        spread_ptr->sort_col=r;
      }
      else {
        int c=find_sort_row(c2,false);
        if (c<0 || c>= spread_ptr->cols() )
          return;
        spread_ptr->sort_col=c;
      }
    }
    if (r1==r2)
      return;
    if (r1>r2)
      std::swap<int>(r1,r2);
    if (c1>c2)
      std::swap<int>(c1,c2);
    // keep only rows r1->r2 and cols c1->c2
    m=mtran(matrice(m.begin()+r1,m.begin()+r2+1));
    m=mtran(matrice(m.begin()+c1,m.begin()+c2+1));
    // sort
    spread_ptr->sort_col -= c1;
    sort(m.begin(),m.end(),thesheetsort);
    if (!increasing)
      reverse(m.begin(),m.end());
    // put in the matrix
    if (row_sort){ // Back transpose
      m=mtran(m);
      spread_ptr->row(c1);
      spread_ptr->col(r1);
    }
    else {
      spread_ptr->row(r1);
      spread_ptr->col(c1);
    }
    spread_ptr->paste(m);
#endif // HAVE_LIBFLVW
}

void eqw_ok(bool cancelled) {
  bool was_mtrw=(old_upper_window_state==upper_window_mtrw);
if (was_mtrw)
  manage_upper_window(upper_window_mtrw,false);
else
  manage_upper_window(upper_window_hist,false);
if (cancelled)
  return;
string ins;
// if (shifton())
  ins=Eqw_eqw->get_selection().print();
// else
//  ins=Eqw_eqw->get_data().print();
if (rpn_mode)
  ins="'"+ins+"'";
//if (was_mtrw)
// input_value(ins.c_str());
//else
 input_insert(ins.c_str(),true);
Fl::focus(input);
}

void cmdline2eqw() {
  if (current_upper_window[0]==upper_window_eqw)
    return;
  gen g(input->value());
  Eqw_eqw->ytop=Eqw_eqw->h()/2;
  Eqw_eqw->data=Eqw_compute_size(g,Eqw_eqw->attr,Eqw_eqw->w());
  Eqw_eqw->select();
  Eqw_eqw->fl_select();
  Eqw_eqw->setscroll();
  manage_upper_window(upper_window_eqw,false);
}

giac::gen history_get() {
  if (Eqw_History_group->visible())
      return Eqw_history->get_selection();
    if (history_out.empty())
      return zero;
    else {
      if (is_answer)
        return history_out[history_pos()];
      else
        return history_in[history_pos()];
    }
}

void hist2eqw() {
  if (current_upper_window[0]==upper_window_eqw)
    return;
  gen g;
# ifdef HAVE_LIBFLVW
  if (current_upper_window[0]==upper_window_mtrw)
    g=spread_ptr->m[spread_ptr->row()][spread_ptr->col()][1];
  else
# endif 
  g=history_get();
  Eqw_eqw->ytop=Eqw_eqw->h()/2;
  Eqw_eqw->data=Eqw_compute_size(g,Eqw_eqw->attr,Eqw_eqw->w());
  Eqw_eqw->select();
  Eqw_eqw->fl_select();
  Eqw_eqw->setscroll();
  manage_upper_window(upper_window_eqw,false);
  Fl::focus(Eqw_eqw);
}

void gnuplot_setview() {
  #ifdef WITH_GNUPLOT
  bool clrplot=false;
  int out_handle;
  FILE * gnuplot_out_readstream,* stream = open_gnuplot(clrplot,gnuplot_out_readstream,out_handle);
  fprintf(stream,"%s %f,%f,%f,%f\n%s\n","set view ",Rot_x->value(),Rot_z->value(),X_scale->value(),Z_scale->value(),"replot");
  fflush(stream);
  gnuplot_wait(out_handle,gnuplot_out_readstream,2);  
#endif //
}

void Eqw_history_select(int h) {
  Eqw_history->deselect();
   if (Eqw_history->data.type!=_VECT)
     return;
   vecteur & eqv = *Eqw_history->data._VECTptr;
   if (eqv.size()<=h*2+is_answer)
     return;
   Eqw_select(eqv[h*2+is_answer],true);
   Eqw_history->adjust_xy_sel();
   Eqw_history->setscroll();
}

void input_value(const char *s) {
  input->value(s);
}

int input_position() {
  return input->position();
}

int input_mark() {
  return input->mark();
}

void input_position(int i,int j) {
  input->position(i,j);
}

void input_redraw() {
  input->redraw();
}

void hist_view(int mode) {
  if (history_out.size()){
  gen g=history_get();
  vecteur v1(lop(g,at_expr));
  vecteur v2(*protecteval(v1,DEFAULT_EVAL_LEVEL,0)._VECTptr);
  g=quotesubst(g,v1,v2);
  int save_mode=maple_mode;
  maple_mode=mode;
  Help_text->value(g.print().c_str());
  Help_text_select();
  maple_mode=save_mode;
 }
}

void recompute_window_xyminmax(double h) {
  if (Orthonormal->value()){ // ratio (ymax-ymin)/(xmax-xmin) should be h/w
      // factor 1.15 seems to work for resolution 1024x768 on my screen
      h=h*1.15;
      double w=Picture->w();
      double window_w=Picture->window_xmax-Picture->window_xmin,window_h=Picture->window_ymax-Picture->window_ymin;
      double window_hsize=h/w*window_w;
      if (window_h > window_hsize*1.01){ // enlarge horizontally
        double window_xcenter=(Picture->window_xmin+Picture->window_xmax)/2;
        double window_wsize=w/h*window_h;
        Picture->window_xmin=window_xcenter-window_wsize/2;
        Picture->window_xmax=window_xcenter+window_wsize/2;
      }
      if (window_h < window_hsize*0.99) { // enlarge vertically
        double window_ycenter=(Picture->window_ymin+Picture->window_ymax)/2;
        Picture->window_ymin=window_ycenter-window_hsize/2;
        Picture->window_ymax=window_ycenter+window_hsize/2;
      }
      Picture2global_window();
    }
}

void Left_Xcas_resize() {
  int h=Xcas->h()-xcas->h(),upper_h,middle_h,low_h;
int w=Xcas->w();
if (Picture->fullscreen){
      upper_h=(17*h)/24;
      middle_h=(7*h)/24;
    low_h=0;
} 
else { 
      upper_h=(10*h)/24;
      middle_h=(7*h)/24;
      low_h=(7*h)/24;
}
int upper_x=xcas->x(),upper_y=xcas->y()+xcas->h(),upper_w=Xcas->w();
int middle_w=(3*upper_w)/4;
int nwin=current_upper_window.size();
int upper_w_,upper_x_,upper_h_,upper_y_;
if (horizontal_split){
 upper_w_=upper_w;
 upper_x_=0;
 upper_y_=upper_h/nwin;
 upper_h_=upper_h/nwin;
}
else {
 upper_w_=upper_w/nwin;
 upper_x_=upper_w/nwin;
 upper_y_=0;
 upper_h_=upper_h;
}
Cas_setup_w->hide();
General_setup_w->hide();
Plot_setup_w->hide();
int pos=current_upper_window[0];
if (pos!=upper_window_cas_setup && pos!=upper_window_geo_setup && pos!=upper_window_gen_setup){
 if (pos==upper_window_debug){
  Debug_group->resize(upper_x,upper_y,upper_w_,upper_h_);
  Debug_group->show();
 }
 else
  Debug_group->hide();
 pos=equalposcomp(current_upper_window,upper_window_hist);
 int nchilds=Eqw_History_group->children();
 if (pos){
  Historique->resize(upper_x+upper_x_*(pos-1),upper_y+upper_y_*(pos-1),upper_w_,upper_h_);
  Historique->show();
  if (Eqw_History_group->visible())
      Eqw_history->show();
 }
 else {
  Historique->hide(); // hide all childrens of Eqw_History_group
   Eqw_history->hide();
 }
 pos=equalposcomp(current_upper_window,upper_window_full_message);
 if (pos){
  Bighelp->resize(upper_x+upper_x_*(pos-1),upper_y+upper_y_*(pos-1),upper_w_,upper_h_);
  Bighelp->show();
 }
 else {
   Bighelp->hide();
 }
 pos=equalposcomp(current_upper_window,upper_window_prog);
 if (pos){
  Programme->resize(upper_x+upper_x_*(pos-1),upper_y+upper_y_*(pos-1),upper_w_,upper_h_);
  Programme->show();
  // Program_editor->show();
 }
 else {
  Programme->hide();
  // Program_editor->hide();
 }
 pos=equalposcomp(current_upper_window,upper_window_eqw);
 if (pos){
  Eqw_group->show();
  Eqw_eqw->show();
  Eqw_group->resize(upper_x+upper_x_*(pos-1),upper_y+upper_y_*(pos-1),upper_w_,upper_h_);
 }
 else {
  Eqw_group->hide();
  Eqw_eqw->hide();
 }
 pos=equalposcomp(current_upper_window,upper_window_geo);
 if (pos){
  PICTshow();
  int taille=Geo_save->labelsize();
  Geo_group->resize(upper_x+upper_x_*(pos-1),upper_y+upper_y_*(pos-1),upper_w_,upper_h_);
  // Geo_group->resize(upper_x+upper_w_*(pos-1),upper_y,upper_w_,upper_h);
  // Picture->resize(upper_x+upper_x_*(pos-1),upper_y+upper_y_*(pos-1),upper_w_,upper_h_-taille);
  // Geo_buttons->resize(upper_x+upper_x_*(pos-1),upper_y+upper_y_*(pos-1)+upper_h_-taille,upper_w_,taille);
 }
 else {
  // Picture->resize(upper_x,upper_y,upper_w_,upper_h_);
  Geo_group->resize(upper_x,upper_y,upper_w_,upper_h_);
   PICThide();
 }
 pos=equalposcomp(current_upper_window,upper_window_mtrw);
 if (pos){
  Spread_group->resize(upper_x+upper_x_*(pos-1),upper_y+upper_y_*(pos-1),upper_w_,upper_h_);
  Spread_group->show();
#ifdef HAVE_LIBFLVW
  spread_ptr->show();
#endif
 }
 else {
  Spread_group->hide();
#ifdef HAVE_LIBFLVW
  spread_ptr->hide();
#endif
 }
 pos=equalposcomp(current_upper_window,upper_window_help);
 if (pos){
  Help_Chooser->resize(upper_x+upper_x_*(pos-1),upper_y+upper_y_*(pos-1),upper_w_,upper_h_);
  Help_Chooser->show();
 }
 else
   Help_Chooser->hide();
 Input_group->show();
}
else {
  Historique->hide();
  Eqw_history->hide();  
  Bighelp->hide();
  Programme->hide();
  Eqw_group->hide();
  Eqw_eqw->hide();
  PICThide();
  Spread_group->hide();
  Help_Chooser->hide();
  Debug_group->hide();
 if (pos==upper_window_cas_setup){
   Cas_setup_w->show();
   Cas_setup_w->resize(upper_x,upper_y,middle_w,upper_h+middle_h);
 }
 if (pos==upper_window_gen_setup){
   General_setup_w->show();
   General_setup_w->resize(upper_x,upper_y,middle_w,upper_h+middle_h);
 }
 if (pos==upper_window_geo_setup){
   Plot_setup_w->resize(upper_x,upper_y,middle_w,upper_h+middle_h);
   Plot_setup_w->show();
 }
 Input_group->hide();
}
Input_group->resize(upper_x,upper_y+upper_h,upper_w,middle_h);
Input_group->redraw();
Keyboard_group->resize(upper_x,upper_y+upper_h+middle_h,upper_w,low_h);
if (Picture->fullscreen){
   Direction_group->hide();
   Direction_group2->show();
   Keyboard_group->hide();
}
else {
   Direction_group->show();
   Direction_group2->hide();
   Keyboard_group->show();
}
Xcas->redraw();
}

void shift_off() {
  shift_on=false;
  Scientific_keyboard->show();
  Alpha_keyboard->hide();
}

void manage_numeric_keys() {
  if (Picture->fullscreen){
    Direction_group2->show();
    Direction_group->hide();
  }
  else {
    Direction_group2->hide();
    Direction_group->show();
  }
}

int PICT_resize_halfscreen() {
  Xcas->redraw();
  Picture->fullscreen=false;
  Keyboard_group->show();
  manage_numeric_keys();
  int y=En_haut->y()-Cst_i->y()+(3*En_haut->h())/5;
  Left_Xcas_resize();
  return y;
}

int PICT_resize_fullscreen() {
  int y=Xcas->h()-xcas->h();
  Picture->fullscreen=true;
  Keyboard_group->hide();
  manage_numeric_keys();
  Left_Xcas_resize();
  input_redraw();
  return y;
}

void PICTshow() {
  Geo_group->show();
    Picture->show();
    Picture->run_plot_view=true;
    Geo_buttons->show();
    rpn_menu=geo_menu;
    show_rpn_menu(0);
}

void PICThide() {
  Geo_group->hide();
    Geo_buttons->hide();
    Picture->hide();
    Picture->run_plot_view=false;
}

void update_sheet_label() {
  #ifdef HAVE_LIBFLVW
static char spreadlegend[512];
  string tmp;
  if (spread_ptr->is_spreadsheet)
     tmp=gettext("Spreadsheet ")+string(matrixfilename);
  else
     tmp=gettext("Matrix ")+string(matrixfilename);
  strcpy(spreadlegend,tmp.c_str());
  spread_ptr->label(spreadlegend);
  spread_ptr->redraw();
  bandeau_fill_label_redraw();
#endif //
}

void save_current_xcas_matrix(const char * newfile) {
  #ifdef HAVE_LIBFLVW 
// cerr << newfile << spread_ptr->m << endl;
Xcas_matrix_map[newfile]=xcas_matrix(spread_ptr->m,spread_ptr->changed,spread_ptr->is_spreadsheet,spread_ptr->rows(),spread_ptr->cols(),spread_ptr->row(),spread_ptr->select_start_row(),spread_ptr->col(),spread_ptr->select_start_col());
spread_ptr->m=makefreematrice(spread_ptr->m);
#endif //
}

void save_current_sheet(const char * newfile) {
  #ifdef HAVE_LIBFLVW 
string tmp(add_extension(newfile,"tab","spreadsheet"));
ofstream of(tmp.c_str());
if (spread_ptr->is_spreadsheet)
  of << gen(spread_ptr->m,_SPREAD__VECT) << endl;
else
  of << gen(extractmatricefromsheet(spread_ptr->m)) << endl;
spread_ptr->changed=false;
save_current_xcas_matrix(newfile);
#endif //
}

void save_current_program(const char * newfile) {
  Program_editor->buffer()->savefile(newfile);
  editor_changed=false;
  int i,j;
  Program_editor_position(i,j);
  Xcas_program_map[newfile]=editor_string(Program_editor_value(),false,i,j);
Help_text_value((string(progfilename)+" saved").c_str());
}

void load_current_program(const char * ch) {
  if (!progfilename[0])
  strcpy(progfilename,"session.cxx");
 if (Program_editor_changed()){
  int i=fl_ask(gettext("Save current program?")),j;
   if (i==1)
     save_current_program(progfilename);
   else {
     Program_editor_position(i,j);   
     Xcas_program_map[Xcas_editor_filename->value()]=editor_string(Program_editor_value(),editor_changed,i,j);
   }
 }
 char * newfile;
 if (ch && ch[0])
   strcpy(newfile,ch);
 else {
#ifdef IPAQ
   strcpy(progfilename,("prog"+print_INT_(program_counter)+".cxx").c_str()); 
#endif //
 newfile = fl_file_chooser("Load program", "*.cxx", "*.cxx");
 }
 if ( file_not_available(newfile))
  return;
 strcpy(progfilename,newfile);
 Program_editor->buffer()->loadfile(progfilename);
 Program_editor->buffer()->call_modify_callbacks();
 Xcas_program_map[progfilename]=editor_string(Program_editor_value(),false,0,0);
 Xcas_editor_filename_value(progfilename);
 editor_changed=false;
}

void manage_upper_window(int i,bool force) {
  static int save_hist_position=0,save_hist_selection=0,save_mtrw_hist_position=0,save_mtrw_hist_selection=0;
  int oldi=current_upper_window[0];
  if (i==oldi){
     Left_Xcas_resize();
     return;
  }
  if ( !force &&  ( (current_upper_window[0]==upper_window_debug)) )
    return;
  if (oldi==upper_window_hist){
    save_input_value=input->value();
    save_hist_position=input->position();
    save_hist_selection=input->mark();
  }
  if (oldi==upper_window_mtrw){
    save_matrix_input_value=input->value();
    save_mtrw_hist_position=input->position();
    save_mtrw_hist_selection=input->mark();
  }
  if (i==upper_window_hist){
    input->value(save_input_value.c_str());
    input->position(save_hist_position,save_hist_selection);
  }
  if (oldi==upper_window_prog)
    save_current_program(progfilename);
  if (i==upper_window_full_message)
    Bighelp->buffer()->text(Help_text->value());
  if (i==upper_window_prog){ // prog
    Fl::focus(Program_editor);
  }
#ifdef HAVE_LIBFLVW
  if (spread_ptr) spread_ptr->editing=false;
  if (i==upper_window_mtrw){ // mtrw
      update_sheet_label();
      input->value(save_matrix_input_value.c_str());
      input->position(save_mtrw_hist_position,save_mtrw_hist_selection);
      Fl::focus(spread_ptr);
      if (spread_ptr->is_spreadsheet&& Spreadsheet_recompute->value()){
         spread_eval_interrupt(spread_ptr->m,0);
     }
  }
#endif //
  old_upper_window_state=current_upper_window[0];
  manage_numeric_keys();
  if (i!=upper_window_cas_setup && i!=upper_window_gen_setup && i!=upper_window_geo_setup && oldi!=upper_window_cas_setup && oldi!=upper_window_gen_setup && oldi!=upper_window_geo_setup){ // shift state
    int nwin=current_upper_window.size();
    for (int j=nwin-1;j>=1;--j)
      current_upper_window[j]=current_upper_window[j-1];
  }
  current_upper_window[0]=i;
  Left_Xcas_resize();
}

void Help_text_value(const char * chaine) {
  if (!Help_text)
  return;
string s(chaine);
s=cut_help(s,Help_text->textsize(),Bighelp->w());
Help_text->value(s.c_str());
Bighelp->buffer()->text(Help_text->value());
Help_text->redraw();
Bighelp->redraw();
}

void Help_text_select() {
  Fl::focus(Help_text);
int s=string(Help_text->value()).size();
Help_text->position(0,s);
Fl::selection(*Help_text,Help_text->value(),s);
}

int history_pos() {
  if (Eqw_History_group->visible() && !user_screen){
  gen g=Eqw_history->data;
  if (g.type==_VECT) {
    int i,nrows,res;
    if (!Eqw_find_vector_pos(g._VECTptr->begin(),g._VECTptr->end()-1,i,nrows)){
      is_answer=true;
      if (rpn_mode)
        res=nrows-1;
      else
        res=nrows/2-1;
    }
    else {
      if (rpn_mode){
        is_answer=true;
        res=i;
      }
      else {
        is_answer=i%2;
        res=i/2;
      }
    }
    if (!history_in.empty())
      res=min(res,history_in.size()-1);
    return res;
  }
}
int s=history_positions.size();
if (!s)
  return 0;
if (Picture->run_plot_view){
  if (Picture->selected.empty())
    return 0;
  else
    return Picture->history_position;
}
int pos1=xcas_output->position();
int pos2=xcas_output->mark();
pos1=min(pos1,pos2);
vector<int>::const_iterator it=history_positions.begin(),itend=history_positions.end();
for (;it!=itend;++it){
  if (*it>=pos1)
    return (it-history_positions.begin());
}
return s;
}

void rpn_button(int i) {
  int si=rpn_menu_page*6+i;
  gen e;
  if (rpn_menu.size()>si){
    e=rpn_menu[si];
    if ( (e.type==_VECT) && (e._VECTptr->size()==2))
      e= e._VECTptr->back();
  }
  else {
    return;
  }
  if (e.type==_VECT){
    vecteur tmp(1,string2gen('"'+string("BACK")+'"'));
    if ((rpn_menu.back().type==_VECT) && (rpn_menu.back()._VECTptr->front().type==_STRNG) && (*rpn_menu.back()._VECTptr->front()._STRNGptr==string("BACK")) )
      rpn_menu.pop_back();
    tmp.push_back(rpn_menu);
    rpn_menu=*e._VECTptr;
    rpn_menu.push_back(tmp);
    show_rpn_menu(0);
  }
  else {
    if (!rpn_mode){
      Eqw * eqwptr=dynamic_cast<Eqw *> (Fl::focus());
      if (eqwptr){
        eqwptr->parse_desactivate();
        if (eqwptr->allow_immediate_eval){
           eqwptr->eval_function(e);
           return;
        }
      }
      if (e.type==_FUNC){
       if (e.subtype){
#ifndef IPAQ
        input_1arg(e._FUNCptr->ptr->s.c_str(),false,true);
#else
        input_1arg(e._FUNCptr->ptr->s.c_str(),false,false);
#endif //
       }
       else
        input_0arg((e._FUNCptr->ptr->s+" ").c_str());
      }
      else
        input_0arg(e.print().c_str());
    }
    else 
      input_0arg(e.print().c_str());
    if (direct_entry())
      input_eval(false);
  }
}

void show_rpn_menu(int i) {
  rpn_menu_page=i;
  int j=i*BUTTON_PER_PAGE;
  fl_font(F1->labelfont(),F1->labelsize());
  for (int k=0;k<6;k++){
    string s;
    rpn_menu_is_directory[k]=false;
    if (rpn_menu.size()>j+k){
      gen e=rpn_menu[j+k];
      if ( (e.type==_VECT) && (e._VECTptr->size()==2)){
        e=e._VECTptr->front();
        rpn_menu_is_directory[k]=true;
        s=e.print();
        if (s[0]=='"')
          s=s.substr(1,s.size()-2);
      }
      else {
        if (e.type==_FUNC)
          s=e._FUNCptr->ptr->s;
        else
          s=e.print();
        if (e.type==_VECT)
          rpn_menu_is_directory[k]=true;
      }
    }
    else
      s="";
    while(fl_width(s.c_str())>F1->w())
      s=s.substr(0,s.size()-1);
    rpn_menu_string[k]=s;
  }
  F1->label(rpn_menu_string[0].c_str());
  F1->labelcolor(7-rpn_menu_is_directory[0]);    
  F2->label(rpn_menu_string[1].c_str());
  F2->labelcolor(7-rpn_menu_is_directory[1]);    
  F3->label(rpn_menu_string[2].c_str());
  F3->labelcolor(7-rpn_menu_is_directory[2]);    
  F4->label(rpn_menu_string[3].c_str());
  F4->labelcolor(7-rpn_menu_is_directory[3]);    
  F5->label(rpn_menu_string[4].c_str());
  F5->labelcolor(7-rpn_menu_is_directory[4]);    
  F6->label(rpn_menu_string[5].c_str());
  F6->labelcolor(7-rpn_menu_is_directory[5]);    
  bandeau->redraw();
}

void update_Xcas_mode() {
  string mode_s;
  if (angle_radian(0))
    mode_s+="RAD ";
  else
    mode_s+="DEG ";
  mode_s += print_INT_(decimal_digits);
  mode_s += ' ';
  if (complex_mode(0)) // GIAC_CONTEXT
    mode_s += "complex ";
  else
    mode_s += "real ";
  if (approx_mode(0))
    mode_s += "approx";
  else
    mode_s += "exact ";
  if (rpn_mode)
    mode_s += "RPN ";
  else
    mode_s += "ALG ";
  switch (maple_mode){
    case 0: mode_s+="xcas "; break;
    case 1: mode_s+="maple "; break;
    case 2: mode_s+="mupad "; break;
    case 3: mode_s+="ti89 "; break;
  }
  mode_s += getcwd(0,0);
  Xcas_mode->value(mode_s.c_str());
}

void update_io() {
  if (user_screen){
    Show_io->label("io"); 
    Show_io->color(FL_GREEN);
    Geo_show_io->label("io"); 
    Geo_show_io->color(FL_GREEN);
  }
  else  {
    Show_io->label("ia");
    Show_io->color(FL_CYAN);
    Geo_show_io->label("ia");
    Geo_show_io->color(FL_CYAN);
  }
  Show_io->redraw();
  Geo_show_io->redraw();
}

void redraw_finish(const char * sortie) {
  undo_history_out=history_out;
  undo_history_in=history_in;
  history_begin_level=history_in.size();
  // rusage child_usage;
  // wait4(child_id,0,WNOHANG,&child_usage);
  // string child_usage_s("Done (User: ");
  // child_usage_s += print_INT_(child_usage.ru_utime.tv_sec) + "s" + print_INT_(child_usage.ru_utime.tv_usec/10000) + "cs ,\n System: ";
  // child_usage_s += print_INT_(child_usage.ru_stime.tv_sec) + "s" + print_INT_(child_usage.ru_stime.tv_usec/10000)+"cs)";
  // Help_text->value((child_usage_s+messages_to_print).c_str());    
  Help_text_value(messages_to_print.c_str());    
  int nlignes=history_out.size();
  history_redraw(nlignes);
  string b,s,t;
  input_before_selected_after(b,s,t);
  int pos1=b.size();
  if (rpn_mode){
    input->value("");
    if (Picture->run_plot_view)
      Fl::focus(input);
    else
      focus_output();
  }
  else {
    if (pos1 || t.size() ){
      s=sortie;
      int pos2=pos1+s.size();
      input->value((b+s+t).c_str());
      input->position(pos1,pos2);
      // Fl::focus(input);
    }
    else {
       if (current_upper_window[0]==upper_window_prog)
        Fl::focus(Program_editor);
      else {
      if (Picture->run_plot_view)
        Fl::focus(input);
      else
        focus_output();
      }
    }
  }
  nlignes=history_endlines.size();
  int xcas_output_lignes=xcas_output->h()/(xcas_output_fontsize+2);
  if (nlignes>xcas_output_lignes ){
     xcas_output->position(history_endlines.back()-2,history_endlines.back()-1);
     Xcas_Output_scroll->value(nlignes-1,xcas_output_lignes,0,nlignes+xcas_output_lignes-1);
    }
  if (!history_out.empty()){
    gen & gb=history_in.back();
    gen & gob =history_out.back();
    // FIXME If a plot3d is followed by any interactive instruction
    if (!running_file && (gb.type==_SYMB) && equalposcomp(implicittex_plot_sommets,gb._SYMBptr->sommet) && gob.is_symb_of_sommet(at_pnt) && gob.subtype>=0 ) {
        gnuplot_fileno=history_out.back().subtype;
      gnuplot_fltk();
      usleep(500000);
      if (Eqw_history->visible()){
        // recompute plot pointer
        gen & g=Eqw_history->data;
        if (g.type==_VECT && g.subtype==_HIST__VECT){
          vecteur & v=*g._VECTptr;
          int s=v.size();
          if (s>4){
            gen & gg=v[s-4];
            if (gg.type==_EQW){
              gen & ggg = gg._EQWptr->g;
              if (ggg.type==_POINTER_ && gg.subtype==_FL_IMAGE_POINTER){
                ggg=gnuplot_fileno;
                Eqw_history->set_data(Eqw_history->get_data());
              }
            }
          }
        }
      }
    }
  }
  update_Xcas_mode();
  Fl::redraw(); // if (!block_signal) Fl::check();
}

void manage_upper_window_geo() {
  if (!equalposcomp(current_upper_window,upper_window_geo))
   manage_upper_window(upper_window_geo,false);
}

bool intermediate_update() {
  gen entree,sortie;
  if (!read_data(entree,sortie,messages_to_print,0)){
    return false;
  }
  /* if ( ((sortie.type==_SYMB) && equalposcomp(plot_sommets,sortie._SYMBptr->sommet)) ||
         ((sortie.type==_VECT) && 
	  (sortie._VECTptr->size() ) && 
	  (sortie._VECTptr->back().type==_SYMB) && 
	  (equalposcomp(plot_sommets,sortie._VECTptr->back()._SYMBptr->sommet)))
       )
       manage_upper_window_geo();
    */
    Picture->redraw();
    redraw_finish(sortie.print().c_str());
    return true;
}

bool chk_data_ready() {
  #ifndef WIN32
  for (int i=0;i<30;++i){
    if (child_busy){ 
      if (i==29)
        busy_error();
      // cerr << "Sleep " << i << endl;
#ifdef __APPLE__
      usleep(1000);
#else
      timespec t,tr;
      t.tv_sec=0;
      t.tv_nsec=10000000;
      nanosleep(&t,&tr);
#endif
      if (data_ready){
        intermediate_update();
      }
    }
  }
#endif //
  return intermediate_update();
}

void redraw_callback(void *) {
  static int initialized=-1;
   ++initialized;
   if (initialized % 3){
     usleep(10000);
     return;
   }
   bandeau_fill_label_redraw();
   static int upper_window_before_debug=0;
    if ((Picture->fullscreen && Input_group->y()+Input_group->h()+20<Xcas->h()) 
      || (!horizontal_split &&Geo_group->w()*current_upper_window.size() > Xcas->w() + 20)
      || (horizontal_split && Geo_group->h()*current_upper_window.size() > Xcas->h() - Input_group->h() )
       ){
      // cerr << "Resizing bandeau"<<endl;
      Left_Xcas_resize();
      // bandeau->resize(bandeau->x(),bandeau->y(),(3*bandeau->w())/4,bandeau->h());
      // bandeau->redraw();
   }
   if (!horizontal_split)
      recompute_window_xyminmax(Picture->h());
    if ( !initialized ){
      initialized=true;
      Eqw_history->show();
  if (xcas_user_level==8){
    cb_Xcas_tortue_bonjour(0,0);
  }
#ifdef WIN32
    string configname=xcasroot+xcasrc;
#else
    string configname=giac::home_directory()+xcasrc;
#endif //
   if (access(configname.c_str(),R_OK)){
    Xcas->hide();
    int n,m=fl_choice(gettext("Choose initial level"),"Tortue","Universite","Lycee"),mm;
    if (m==1)
      n=fl_choice(gettext("Choose initial configuration"),"TI89","Xcas","Maple");
    else {
      if (m==2){
        mm=fl_choice(gettext("Choose sublevel"),"Terminale","Premiere","Seconde");
        n=0;
      }
      else
        n=1;
    }
#ifdef IPAQ // default with bandeau
    string configs="widget_size(20,267,56,735,557,1,1,1,";
#else // ifndef IPAQ, default without bandeau and full screen
    string configs="widget_size(20,267,56,735,557,0,1,0,";
#endif // IPAQ
    if (n==2){
      configs += "3";
      Eqw_history->set_data(Eqw_nullhistlevel());
      Fl::focus(Eqw_history);
      Eqw_history->select();
      Eqw_history->select_down(0);
      Eqw_history->select_down(0);
      Eqw_history->select_down(0);
    }
    else 
      configs += '8';
    configs += ','; configs += '"'; configs += '"' ; configs += ','; // BROWSER
    if (m==0){
      configs+="8";
      set_xcas_user_level(8);
    }
    if (m==2){
      configs+=print_INT_(mm+1);
      set_xcas_user_level(mm+1);
    }
    if (m==1)
      configs+="0";
    configs +=");maple_mode(";
    if (n==0)
      configs+='3';
    if (n==2)
      configs+='1';
    if (n==1)
      configs+='0';
    configs += ");xyztrange(-10.0,10.0,-10.0,10.0,-10.0,10.0,-10.0,10.0,-10.0,10.0,-1.4,1.1,1,0.0,1.0);";
    ofstream configfile(configname.c_str());
    configfile << configs << endl;
    configfile.close();
    n=fl_ask(gettext("Launch tutorial?"));
    if (n==1)
      system(browser_command("doc/fr/tutoriel/index.html").c_str());
    string s(xcas_argv[0]);
    for (int i=1;i<xcas_argc;++i){
      s+=" ";
      s+=xcas_argv[i];
    }
    s += " &";
    system(s.c_str());
    unlink_tmp_files();
    kill_gnuplot(); 
    if (child_id>0)
      kill(child_id,SIGKILL);
    exit(0);
  }
    }
    if (debug_mode){
    if (!Debug_group->visible()){
      upper_window_before_debug=current_upper_window[0];
      manage_upper_window(upper_window_debug,false);
    }
    if (debug_refresh && (debug_info.type==_VECT) && (debug_info._VECTptr->size()==7)){ 
       debug_refresh=false;
       // read data in debug_info
       // FIXME: change in prog.cc function debug_loop and gen debug_info
       // and here w[3] to undef if the function did not change
       vecteur w=*debug_info._VECTptr;
       string msg;
       msg += "Eval "+w[1].print() + " = " + w[2].print() + '\n';
       msg += "Stopped in ";
       if ( w[0].type==_VECT && !w[0]._VECTptr->empty() && w[0]._VECTptr->front().type==_VECT && !w[0]._VECTptr->front()._VECTptr->empty() ){
         debug_prog_name=w[0]._VECTptr->front()._VECTptr->front().print();
         msg += debug_prog_name + "(" + gen(vecteur(w[0]._VECTptr->front()._VECTptr->begin()+1,w[0]._VECTptr->front()._VECTptr->end()),_SEQ__VECT).print()+")";
         msg += ",\nbreakpoint "+w[0]._VECTptr->back().print();
       }
       else
         msg += w[0].print();
       msg += ",\nline " + w[4].print()+ ",\n";
       Debug_messages->value(msg.c_str());
       gen w_in(w[5]),w_out(w[6]);
       if ( (w_in.type==_VECT) && (w_out.type==_VECT) ){
         int pos=max(Variable_browser->value(),1);
         Variable_browser->clear();
         const_iterateur it=w_in._VECTptr->begin(),itend=w_in._VECTptr->end();
         const_iterateur jt=w_out._VECTptr->begin(),jtend=w_out._VECTptr->end();
         for (;(it!=itend)&&(jt!=jtend);++it,++jt)
           Variable_browser->add( (it->print() + " := " + jt->print()).c_str() );
         Variable_browser->value(min(pos,w_in._VECTptr->size()));
       }
       if (!is_undef(w[3])){
         Source_browser->clear();
         vector<string> vs;
         if (w[3].type==_VECT)
           debug_print(*w[3]._VECTptr,vs);
         else
           debug_print(w[3],vs);
         vector<string>::iterator it=vs.begin(),itend=vs.end();
         for (;it!=itend;++it){
           Source_browser->add(it->c_str());
         }
       }
       current_instruction=w[4].val;
       Source_browser->value(current_instruction);
    }
  }
  else {
    if (Debug_group->visible())
      manage_upper_window(upper_window_before_debug,true);
  }
#ifndef WIN32
  if (!child_id)
    child_id=make_child();
  int status;
  pid_t res= waitpid (child_id, &status, WNOHANG);
  if (res==child_id){ // the child process died
    int tmp=child_id;
    child_id=0;
    string report("Evaluation process "+print_INT_(tmp)+ " died!");
    if (WIFSIGNALED(status))
         report+="\nSignal not handeld:"+print_INT_(WTERMSIG(status));
    if (WIFSTOPPED(status))
         report+="\nStopped by signal"+print_INT_(WSTOPSIG(status));
    report +="\nRestoring history";
    kill(tmp,SIGKILL);
    cerr << report << endl;
    Help_text_value(report.c_str());
    // restore previous history
    history_in=undo_history_in;
    history_out=undo_history_out;
    history_begin_level=0;
    return;
  }
#endif // WIN32
  if (chk_data_ready()){
    // synchronize_history=true;
    return;
  }
  // always true for WIN32
  int new_x,new_y;
  Fl::get_mouse(new_x,new_y);
  if ( (!Picture->red_draw) && (new_x>Picture->dx) && ((new_x-Picture->dx)<Picture->w()) && 
       (new_y>Picture->dy) && ((new_y-Picture->dy)<Picture->h()) && 
#ifdef WIN32
       ( (giac::absint(new_x-mouse_x_save)>=5) || 
         (giac::absint(new_y-mouse_y_save)>=5) )
#else // WIN32
       ( (giac::absint(new_x-mouse_x_save)>=1) || 
         (giac::absint(new_y-mouse_y_save)>=1) )
#endif // WIN32
     ){
     mouse_x_save=new_x;
     mouse_y_save=new_y;
     if (!Picture->damage())
       redraw_mouse_position_only=true;
     Picture->redraw();
   }
}

void busy_error() {
  Help_text_value("CAS is busy! Press interrupt button or wait");
}

bool direct_entry() {
  if (!rpn_mode)
    return false;
  if (!*input->value())
    return true;
  if ( (*input->value()!=39) && (*input->value()!='<') )
    return true;
  return false;
}

std::string remove_path(char * s) {
  int i=strlen(s);
  for (;i>0;--i){
    if (*(s+i)=='/'){
      ++i;
      break;
    }
  }
  return s+i;
}

void bandeau_fill_label_redraw() {
  string tmps="hist ";
   if (history_saved)
     tmps += gettext("not changed");
   else
     tmps += gettext("changed");
   tmps += " ("+remove_path(filename)+ "),";
#ifdef HAVE_LIBFLVW
   tmps += " mtrw ";
   if (spread_ptr->changed)
     tmps += gettext("changed");
   else
     tmps += gettext("not changed");
   tmps += " ("+remove_path(matrixfilename)+")";
#endif
   if (strcmp(bandeau_label,tmps.c_str())){
     strcpy(bandeau_label,tmps.c_str());
     bandeau_fill->label(bandeau_label);
     bandeau_fill->redraw();
   }
}

void history_redraw(int i) {
  save_file(("xcas_"+print_INT_(getpid())).c_str(),0,false);
   history_saved=false;
   bandeau_fill_label_redraw();
   bool save_mode=user_screen;
   if (user_screen) {
     user_screen=false; update_io();
     swap_io_hist();
     Picture->plot_instructions_ptr=&plot_instructions;
   }    
   if (Eqw_History_group->visible() ){
    if (history_out.size()!=history_in.size())
      history_out=history_in;
    gen hh=Eqw_nullhistlevel();
    if (!history_in.empty())
      hh=gen(mergevecteur(mtran(makevecteur(history_in,history_out)),*hh._VECTptr),_HIST__VECT);
    Eqw_history->set_data(hh);
    if (Eqw_history->data.type==_VECT && (2*i+1)<Eqw_history->data._VECTptr->size()){
       Eqw_select((*Eqw_history->data._VECTptr)[2*i+rpn_mode],true);
    }
    // cerr << Eqw_history->data << endl;
    Eqw_history->save_data();
    Eqw_history->redraw();
    if (save_mode)
      ckuser_screen();
    return;
  }
  string os(calc_endlines_positions(history_in,history_out,(2*xcas_output->w())/(xcas_output_fontsize+2)-4,history_endlines,history_positions));
  int nlignes=history_endlines.size();
  // should add end of lines if nlignes is small to adjust to bottom
  xcas_output->value(os.c_str());
  int currentligne=0;
  if (!history_positions.empty()){
    i=min(i,history_positions.size()-1);
    if (i){
      xcas_output->position(history_positions[i-1]+1,history_positions[i]);
      for (;currentligne<nlignes;++currentligne){
        if (history_endlines[currentligne]>=history_positions[i-1])
           break;
      }
    }
    else
      xcas_output->position(0,history_positions.front());
  }
  int xcas_output_lignes=xcas_output->h()/(xcas_output_fontsize+2);
  // cout << xcas_output_lignes << endl;
  if (nlignes>xcas_output_lignes){
    // scroll(p,w,t,l)
    //	p = position, first line displayed
    //	w = window, number of lines displayed
    //	t = top, number of first line
    //	l = length, total number of lines
    Xcas_Output_scroll->value(currentligne,xcas_output_lignes,0,nlignes+xcas_output_lignes-1);
  }
  else
    Xcas_Output_scroll->value(0,1,0,1);
  Xcas_Output_scroll->linesize(1);
  if (!Picture->run_plot_view)
    focus_output();
  else
    Fl::focus(input);
  if (save_mode)
    ckuser_screen();
}

void input_eval(bool numeric) {
  if (waiting_click){
    waiting_click_value=gen(input->value());
    waiting_click=false;
    return;
  }
  if (current_upper_window[0]==upper_window_eqw){
    gen g(input->value());
    Eqw_eqw->insure_something_selected();
    Eqw_eqw->replace_selection(g);
    Fl::focus(Eqw_eqw);
    return;
  }
  input_eval2(numeric);
}

void input_eval2(bool numeric) {
  #ifdef HAVE_LIBFLVW
  if (current_upper_window[0]==upper_window_mtrw){
    if (spread_ptr && spread_ptr->editing){
      spread_ptr->editing=false;
      // cerr << "Mtrw edit end" << endl;
      spread_ptr->row(spread_ptr->edit_row);
      spread_ptr->col(spread_ptr->edit_col);
    }
    spread_ptr->changed=true;
    int R=spread_ptr->row(),C=spread_ptr->col();
    int dofill=0;
    if ( (R>=0) && (C>=0) ){
      vecteur & v=*spread_ptr->m[R]._VECTptr;
      gen g(string( input->value() ));
      if (g.type==_SYMB){ 
         if ( (g._SYMBptr->sommet==at_tablefunc ) || (g._SYMBptr->sommet==at_tableseq) ) {
           if (g._SYMBptr->sommet==at_tablefunc)
             dofill=2;
           else
             dofill=1;
           spread_ptr->is_spreadsheet=true;
           update_sheet_label();
           spread_ptr->row(0);
           R=-1;
           g=protecteval(g,DEFAULT_EVAL_LEVEL,0);
         }
         else {
           if (!spread_ptr->is_spreadsheet || Matrix_fill_cells->value())
             g=protecteval(g,DEFAULT_EVAL_LEVEL,0);
         }
      }
      if ( Matrix_fill_cells->value() && g.type==_VECT){
        matrice & m=*g._VECTptr;
        if (!ckmatrix(m)){
          m=vecteur(1,m);
        }
        spread_ptr->paste(m);
        spread_ptr->redraw();
        Fl::focus(spread_ptr);
        spread_ptr->row(min(R+m.size(),spread_ptr->rows()));
        if (dofill){
          spread_ptr->copy_down();
          if (dofill==2){
            spread_ptr->col(spread_ptr->col()+1);
            spread_ptr->copy_down();
          }
        }
        spread_ptr->select_start_row(spread_ptr->row());
        spread_ptr->select_start_col(spread_ptr->col());
        return;
      }
      if ( (v[C].type==_VECT) && (v[C]._VECTptr->size()==3)){
	v[C]._VECTptr->front()=spread_convert(g,R,C);
	if (spread_ptr->is_spreadsheet && Spreadsheet_recompute->value())
          spread_eval_interrupt(spread_ptr->m,spread_ptr->lc,0);
	else 
	  (*v[C]._VECTptr)[1]=g;
      }
      else
	v[C]=g;
      if (matrix_symmetry && matrix_symmetry %2)
        g=-g;
      if (matrix_symmetry && matrix_symmetry/2)
        g=conj(g,0);
      if (matrix_symmetry && !spread_ptr->is_spreadsheet && (spread_ptr->rows()==spread_ptr->cols()) ){
        vecteur & v=*spread_ptr->m[C]._VECTptr;
        if ( (v[R].type==_VECT) && (v[R]._VECTptr->size()==3)){
	  v[R]._VECTptr->front()=spread_convert(g,C,R);
	  (*v[R]._VECTptr)[1]=g;
        }
        else
	  v[R]=g;
      }
      spread_ptr->enter_move();
    }
    printcell_current_row=spread_ptr->row();
    printcell_current_col=spread_ptr->col();
    string s_s=printcell(makevecteur(makevecteur(0),makevecteur(0)));
    Spread_goto->value(s_s.c_str());
    spread_ptr->redraw();
    Fl::focus(spread_ptr);
    return;
  }
#endif //
#ifndef WIN32
  chk_data_ready();
#endif //
 // cerr << "Sleep " << child_busy << " " << data_ready << endl;
 if (child_busy || data_ready){
   // synchronize_history=true;
   run_modif=false;
   UNDO->label("modif");
   UNDO->redraw();
   input->textcolor(FL_BLACK);
   /*
   try {
    bool save_interrupt_button=interrupt_button;
    interrupt_button=true;
    string s(input_value());
    gen g(s);
    g=eval(g);
    interrupt_button=save_interrupt_button;
    fl_alert(("CAS is busy "+s+" : " +g.print()).c_str());
   }
   catch (std::runtime_error & e){
   }
   */
   busy_error();
   return;
 }
 string t(input->value());
 int j=-1;
 if (Pretty_print->value())
   j=Eqw_history_update(Eqw_history);
 if (run_modif){
  run_modif=false;
  UNDO->label("modif");
  UNDO->redraw();
  input->textcolor(FL_BLACK);
  if (!t.size())
    return;
  gen e;
  try {
   e=gen(t,list_one_letter__IDNT);
  }
  catch (std::runtime_error & error){
      Help_text_value(error.what());
      return;
  }
  // save from pos to size 
  undo_history_out=history_out;
  undo_history_in=history_in;
  if (run_modif>=history_in.size() || history_in.size()!=history_out.size()){
    cerr << "Error" << endl;
    return;
  }
  history_in[run_modif_pos]=e;
  /* The following does not work if curves are inside history
  if ( (e.type==_SYMB) && (e._SYMBptr->sommet==at_assume) && (e._SYMBptr->feuille.type==_SYMB) && (e._SYMBptr->feuille._SYMBptr->sommet==at_equal) ){
    history_out[run_modif_pos]=protecteval(e,DEFAULT_EVAL_LEVEL,0);
    Picture->clear();
    int i=erase_pos();
    updatePICT(vecteur(history_out.begin()+i,history_out.end()));
    Picture->redraw();
    Picture->red_draw=false;
    return;
  }
  */ 
  if (j>=0)
    run_modif_pos=min(j,run_modif_pos);
#ifdef WIN32
  win32_recalc_history();
  return ;
#endif //
  child_reeval(run_modif_pos);
  return;
 } // end run_modif case
 if (t.empty()){
  if (!history_out.empty()){
    history_out.push_back(history_out.back());
    history_in.push_back(history_out.back());
    history_redraw(history_pos());
  }
  return;
 }
 size_t sel1=input->position(),sel2=input->mark();
 if (sel1>sel2)
  std::swap<size_t>(sel1,sel2);
 string t_before=t.substr(0,sel1);
 string t_selected=t.substr(sel1,sel2-sel1);
 string t_after=t.substr(sel2,t.size()-sel2);
 // workaround in RPN mode: embedd in a program 
 if ( rpn_mode){
  int ts=t.size(),j,je;
  for (j=0;j<ts;++j){
    if (t[j]>' ')
      break;
  }
  for (je=ts-1;je>j;--je){
    if (t[je]>' ')
      break;
  }
  if (j<ts){
    if ( (t[j]!=39) || (t[je]!=39) ){
      t="<< "+t+" >>";
    }
  }
 }
 if ( (sel1==sel2) || rpn_mode ){
      t_before=string("");
      t_selected=t;
      t_after=string("");
 }
 string s(t_selected);
#ifdef WIN32
 undo_history_out=history_out;
 gen entr(s,list_one_letter__IDNT),sortie;
 clock_t debut,fin;
 try {
   debut=clock();
   if (numeric || approx_mode(0))
     sortie=entr.evalf();
   else 
      sortie=entr.eval(100);
    fin=clock();
 } 
 catch (std::runtime_error & error ){
   sortie= '"'+string(error.what())+'"'  ;
 }
 update_data(entr,sortie,0);
    /* if ( ((sortie.type==_SYMB) && equalposcomp(plot_sommets,sortie._SYMBptr->sommet)) ||
         ((sortie.type==_VECT) && 
	  (sortie._VECTptr->size() ) && 
	  (sortie._VECTptr->back().type==_SYMB) && 
	  (equalposcomp(plot_sommets,sortie._VECTptr->back()._SYMBptr->sommet)))
       ){
      Picture->run_plot_view=true;
        manage_upper_window_geo();
    }
    */
 Picture->redraw();
 redraw_finish(sortie.print().c_str());
 Help_text_value(("Time: "+gen(double(fin-debut)/(CLOCKS_PER_SEC)).print()).c_str());
#else // WIN32
 if (!child_eval(s,numeric,false)){
  busy_error();
 }
 else 
  Help_text_value("Starting evalution...");
# endif // WIN32
}

void input_0arg(const char * chaine) {
  if ( ( Fl::focus()!=input ) && (current_upper_window[0]==upper_window_eqw) ){
  Eqw_eqw->parse_desactivate();
  Eqw_eqw->replace_selection(gen(chaine));
  return;
}
if (current_upper_window[0]!=upper_window_help || Fl::focus()==Help_input )
  make_new_help(chaine);
string s=chaine;
int l=s.size();
if (l>1000)
  l=1000;
for (int i=0;i<l;++i){
  petit_buffer[0]=s[i];
  petit_buffer[1]=0;
  Fl::e_text= petit_buffer;
  Fl::e_length=1;
  Fl::e_keysym=s[i];
  fl_handle();
}
/* string t(input->value());
  size_t sel1=input->position(),sel2=input->mark();
  if (sel1>sel2)
    std::swap<size_t>(sel1,sel2);
  string t_before=t.substr(0,sel1);
  string t_selected=t.substr(sel1,sel2-sel1);
  string t_after=t.substr(sel2,t.size()-sel2);
  s = t_before+s;
  s += t_after;
  input->value( s.c_str());
  size_t pos1=t_before.size();
  size_t pos2=s.size()-t_after.size();
  if (sel1==sel2)
    input->position(pos2,pos2);
  else
    input->position(pos1,pos2); */
}

void input_char(char ch) {
  if ( Fl::focus()==xcas_output )
  Fl::focus(input);
if (maj && isalpha(ch))
  ch=toupper(ch);
petit_buffer[0]=ch;
petit_buffer[1]=0;
Fl::e_text= petit_buffer;
Fl::e_length=1;
Fl::e_keysym=ch;
fl_handle();
/*
string s;
s+=ch;
string t(input->value());
size_t sel1=input->position(),sel2=input->mark();
if (sel1>sel2)
  std::swap<size_t>(sel1,sel2);
string t_before=t.substr(0,sel1);
string t_selected=t.substr(sel1,sel2-sel1);
string t_after=t.substr(sel2,t.size()-sel2);
if (is_operator_char(ch)){
 s = t_before+t_selected+s+t_after;
 input->value( s.c_str());
 input->position(sel2+1,sel2+1);
}
else {
 s = t_before+s+t_after;
 input->value( s.c_str());
 input->position(sel1+1,sel1+1);
}
*/
}

void input_enter() {
  if ( Fl::focus()==xcas_output )
  Fl::focus(input);
petit_buffer[0]=FL_Enter;
petit_buffer[1]=0;
Fl::e_text= petit_buffer;
Fl::e_length=1;
Fl::e_keysym=FL_Enter;
fl_handle();
}

void binary_op(char c) {
  if ( dynamic_cast<Eqw *> (Fl::focus()) )
  input_char(c);
else {
 if (direct_entry()){
  input_char(' ');
  input_char(c);
  input_eval(false);
 }
 else
  input_char(c);
 }
}

void input_1arg(const char * chaine,bool immediate_eval,bool nochooser) {
  Eqw * eqwptr=dynamic_cast<Eqw *> (Fl::focus());
if (eqwptr==Eqw_history && eqwptr->is_selected(true,true)){
  eqwptr->handle_text(string(chaine)+'(');
  make_new_help(chaine);
  return;
}
if ( eqwptr ){
  eqwptr->parse_desactivate();
  gen f("'"+string(chaine)+"'");
  if ( (immediate_eval && eqwptr->allow_immediate_eval) || (f.type!=_FUNC))
    eqwptr->eval_function(f);
  else {
    make_new_help(chaine);
    eqwptr->replace_selection(symbolic(*f._FUNCptr,eqwptr->get_selection()));
  }
  return;
}
Fl_Input * the_input=input;
#ifdef HAVE_LIBFLVW
if (Fl::focus()==spread_editor && !direct_entry())
  the_input=spread_editor;
#endif //
if (current_upper_window[0]==upper_window_help || current_upper_window[0]==upper_window_prog){
  input_0arg(chaine);
  return;
}
else
  make_new_help(chaine);
string s=chaine;
string t(the_input->value());
if ( direct_entry() ){
  the_input->value((t+" "+s).c_str());
  input_eval(false);
  return;
}
size_t sel1=the_input->position(),sel2=the_input->mark();
if (sel1>sel2)
  std::swap<size_t>(sel1,sel2);
string t_before=t.substr(0,sel1);
string t_selected=t.substr(sel1,sel2-sel1);
string t_after=t.substr(sel2,t.size()-sel2);
if (!debug_mode && help_chooser && !nochooser){
  Help_Chooser_Array_fill(t_selected.c_str());
  manage_upper_window(upper_window_help,false);
}
else {
  bool par= s.empty() || s[0]!='_';
  if (par)
    s += '(';
  s = t_before+s;
  s += t_selected;
  if (par)
    s += ')';
  s += t_after;
  the_input->value( s.c_str());
  size_t pos1=t_before.size();
  size_t pos2=s.size()-t_after.size();
  if (sel1==sel2)
    the_input->position(pos2-1,pos2-1);
  else
    the_input->position(pos1,pos2);
  }
}

void input_2arg(const char * chaine,const char * argument) {
  if (current_upper_window[0]!=upper_window_help)
  make_new_help(chaine);
  Eqw * eqwptr= dynamic_cast<Eqw*>(Fl::focus());
  if (eqwptr) {
               gen g(eqwptr->get_selection());
               gen newg(string(chaine)+"("+g.print()+","+string(argument)+")");
               eqwptr->replace_selection(newg);
               eqwptr->select_down(0);
               eqwptr->select_right(0);
 }
 else {
string b,s,a;
if ( direct_entry() ){
  s =input->value();
  s += " ";
  s +=chaine ;
  input->value(s.c_str());
  input_eval(false);
  return;
}
input_before_selected_after(b,s,a);
if (!b.empty())
  b=b+" ";
s=b+chaine+"("+s+","+argument+")"+a;
int pos=b.size()+string(chaine).size()+1;
input->value(s.c_str());
input->position(pos,pos);
}
}

void fltk_cas_setup() {
  if (!run_cas_setup){
  Picture->run_plot_view=false;
  manage_upper_window(upper_window_cas_setup,false);
 switch (scientific_format(0)){
  case 0:
    Float_style_output->value("Standard");
    break;
  case 1:
    Float_style_output->value("Scientific");
    break;
  case 2:
    Float_style_output->value("Engineer");
    break;
  case 3:
    Float_style_output->value("Hexa");
    break;
 }
if (maple_mode==0)
  Style->value("xcas");
if (maple_mode==1)
  Style->value("maple");
if (maple_mode==2)
  Style->value("mupad");
if (maple_mode==3)
  Style->value("ti89");
  Digits->value(decimal_digits);
  Angle_radian->value(angle_radian(0));
  Epsilon->value(epsilon(0));
  Complex_variables->value(complex_variables(0)); // GIAC_CONTEXT
  Save_var->value(variables_are_files(0)); // GIAC_CONTEXT
  Approx_mode->value(approx_mode(0));
  Complex_mode->value(complex_mode(0));
  Xcas_sqrt->value(withsqrt(0));
  Xcas_all_trig_sol->value(all_trig_sol(0));
  run_cas_setup=old_upper_window_state;
}
}

void general_setup() {
  Pretty_print->value(Eqw_History_group->visible());
  Pretty_input->value(pretty_input);
  if (getenv("BROWSER"))
    Help_font_browser->value(getenv("BROWSER"));
  else
    Help_font_browser->value("mozilla");
  if (getenv("GIAC_PREVIEW"))
    Xcas_ps_preview->value(getenv("GIAC_PREVIEW"));
  if (!run_cas_setup){
  Picture->run_plot_view=false;
  manage_upper_window(upper_window_gen_setup,false);
  run_general_setup=old_upper_window_state;
  RPN->value(rpn_mode);
  hide_help->value(Picture->fullscreen);
  Printer_landscape->value(printer_landscape);
#ifdef HAVE_LIBFLVW
  Spread_rows->value(print_INT_(spread_ptr->rows()).c_str());
  Spread_cols->value(print_INT_(spread_ptr->cols()).c_str());
  Spreadsheet_editor->value(spread_ptr->is_spreadsheet);
#endif //
}
}

void plot_setup() {
  if (!run_plot_setup){
  Window_xmin->value(Picture->window_xmin);
  Window_xmax->value(Picture->window_xmax);
  if (Picture->fullscreen)
    Window_ymin->value(Picture->window_ymin);
  else
    Window_ymin->value(Picture->window_ymax+(Picture->window_ymin-Picture->window_ymax)*1.78);
  Window_ymax->value(Picture->window_ymax);
  Xcas_hidden_3d->value(gnuplot_hidden3d);
  Xcas_pm3d->value(gnuplot_pm3d);
  Xmin->value(gnuplot_xmin);
  Xmax->value(gnuplot_xmax);
  Ymin->value(gnuplot_ymin);
  Ymax->value(gnuplot_ymax);
  Zmin->value(gnuplot_zmin);
  Zmax->value(gnuplot_zmax);
  Tmin->value(gnuplot_tmin);
  Tmax->value(gnuplot_tmax);
  Picture->run_plot_view=false;
  Class_min->value(class_minimum);
  Class_size->value(class_size);
  Axes->value(show_axes); 
  manage_upper_window(upper_window_geo_setup,false);
  run_plot_setup=1;
}
}

void increase_selection() {
  int pos1=input->position();
  int pos2=input->mark();
  if (pos1>pos2)
    std::swap<int>(pos1,pos2);
  string s(input->value());
  increase_selection(s,pos1,pos2);
  input->position(pos1,pos2);
}

void decrease_selection() {
  int pos1=input->position();
  int pos2=input->mark();
  if (pos1>pos2)
    std::swap<int>(pos1,pos2);
  string s(input->value());
  decrease_selection(s,pos1,pos2);
  input->position(pos1,pos2);
}

void move_selection_right() {
  int pos1=input->position();
  int pos2=input->mark();
  if (pos1>pos2)
    std::swap<int>(pos1,pos2);
  if (pos2==pos1){
    input->position(pos1+1,pos1+1);
    return;
  }
  string s(input->value());
  move_selection_right(s,pos1,pos2);
  input->position(pos1,pos2);
}

void move_selection_left() {
  int pos1=input->position();
  int pos2=input->mark();
  if (pos1>pos2)
    std::swap<int>(pos1,pos2);
  if (pos2==pos1){
    if (pos1)
      input->position(pos1-1,pos1-1);
    return;
  }
  string s(input->value());
  move_selection_left(s,pos1,pos2);
  input->position(pos1,pos2);
}

void help_chooser_ok(bool add_help_function) {
  string ins;
    if (add_help_function) ins=cur_aide.cmd_name+"(";
    for (Fl_Input ** ptr=Help_Chooser_Input_Array;*ptr;){
         if ((*ptr)->value())
           ins += (*ptr)->value();
         ++ptr;
         if (!*ptr)
           break;
         if ((*ptr)->visible() && (*ptr)->value() && *((*ptr)->value()) )
            ins += ",";
         else
           break;
    }
    if (add_help_function) ins += ")";
    if ( (old_upper_window_state==upper_window_mtrw) || (old_upper_window_state==upper_window_geo) || (old_upper_window_state==upper_window_eqw) || (old_upper_window_state==upper_window_prog) )
        manage_upper_window(old_upper_window_state,true);
    else 
        manage_upper_window(upper_window_hist,true);
    vecteur position;
    if (help_save_focus==Eqw_history){
     gen * act=Eqw_selected(Eqw_history->data,Eqw_history->attr,Eqw_history->w(),position,1);
     if (act)
       Eqw_history->handle_text(ins,act);
     else
       Eqw_history->replace_selection(gen(ins));
    }
    input_insert(ins.c_str(),true);
    if (help_save_focus->visible())
      Fl::focus(help_save_focus);
}

void Help_Chooser_Array_fill(const char * ch) {
  gen g;
  if (ch && *ch)
    g=gen(ch);
  vecteur tmpv;
  if ( (g.type==_VECT) && (g.subtype==_SEQ__VECT) )
    tmpv=*g._VECTptr;
  else
    tmpv=vecteur(1,g);
  int i=0;
  int s=tmpv.size();
  Fl_Input ** ptr=Help_Chooser_Input_Array;
  for (;*ptr && (i<s);++ptr,++i){
    if ((*ptr)->visible())
      (*ptr)->value(tmpv[i].print().c_str());
  }
  for (;*ptr;++ptr){
    if ((*ptr)->visible())
      (*ptr)->value("");
 }
}

std::string findtooltip(const giac::gen & g) {
  string s,s1,s2;
  static char * tooltip_tab[]={"Integer","Expression","Variable","Matrix","Function","String","Polynom","Vector","Point","List","List of point","List of reals","Sequence of variables","Command"};
  static char * tooltip_name[]={"Intg","Expr","Var","Mtrx","Fnc","Str","Poly","Vect","Pnt","Lst","LstPnt","LstReal","SeqVar","Cmd",0};
  if (g.is_symb_of_sommet(at_ou)){
    gen & f = g._SYMBptr->feuille;
    if (f.type==_VECT){
      const_iterateur it=f._VECTptr->begin(),itend=f._VECTptr->end();
      if (it!=itend){
        for (s=findtooltip(*it),++it;it!=itend;++it)
          s = s + gettext(" or ") + findtooltip(*it);
      }
    }
    return s;
  }
  if (g.type==_VECT && g._VECTptr->size()==1)
    return findtooltip(g._VECTptr->front())+"(optional)";
  s = g.print();
  int l=s.size();
  int p=s.find('(');
  if (p>0 && p<l){
    s1 = s.substr(0,p); s2=s.substr(p,l);
  }
  else s1=s;
  char ** tooltip_ptr=tooltip_name;
  for (;*tooltip_ptr;++tooltip_ptr){
    if (*tooltip_ptr==s1){
      return tooltip_tab[tooltip_ptr-tooltip_name]+s2;
    }
  }
  return s;
}

void make_help() {
  static Fl_Input * tmpinput[] ={ Help_Chooser_Input_Array0,Help_Chooser_Input_Array1,Help_Chooser_Input_Array2,Help_Chooser_Input_Array3,Help_Chooser_Input_Array4,Help_Chooser_Input_Array5,0};
  int wsize=Help_Chooser->w();
  HTMLindex=0;
  Help_Chooser_Input_Array=tmpinput;
  static string * help_ptr[]={0,0,0,0,0,0,0}, * tooltip_ptr_tab[]={0,0,0,0,0,0,0};
  for (Fl_Input ** ptr=Help_Chooser_Input_Array;*ptr;++ptr){
    (*ptr)->hide();
  }
  Help_Chooser_OK_with_function->label(cur_aide.cmd_name.c_str());
  gen helpg;
  vecteur helpv;
  if (!cur_aide.syntax.empty()){
    helpg=cur_aide.syntax;
    if (helpg.type==_VECT)
      helpv=*helpg._VECTptr;
    else
      helpv=vecteur(1,helpg);
  }
  const_iterateur jt=helpv.begin(),jtend=helpv.end();
  int vpos=0;
  Fl_Input ** ptr=Help_Chooser_Input_Array;
  for (string ** charptr=help_ptr,**tooltipptr=tooltip_ptr_tab;*ptr && jt!=jtend;++jt,vpos += 20,++ptr,++charptr,++tooltipptr){
    gen tmp=*jt;
    if (tmp.type==_VECT)
      (*ptr)->labelcolor(FL_BLUE);
    else 
      (*ptr)->labelcolor(FL_BLACK);
    if (*charptr)
      delete *charptr;
    *charptr=new string(tmp.print());
    if (*tooltipptr)
      delete *tooltipptr;
    *tooltipptr = new string(gettext("Expecting ")+findtooltip(tmp));
    (*ptr)->tooltip((*tooltipptr)->c_str());
    (*ptr)->label((*charptr)->c_str());
    (*ptr)->show();
    (*ptr)->value("");
  }
  if (helpv.begin()!=jtend)
    --ptr;
  int y=(*ptr)->y()+(*ptr)->h()+2,wh=Help_Chooser->h()-y-Help_Chooser_OK->h(),wx=Help_Chooser->x(),ww=Help_Chooser->w();
  //Help_Chooser_Index->resize(wx,y,ww/3,wh);
  //help_examples->resize(wx+ww/3,y,ww/3,wh);
  //help_related->resize(wx+(2*ww)/3,y,ww/3,wh);
  Help_Chooser->redraw();
  Help_input->value(cur_aide.cmd_name.c_str());
  string result=cur_aide.cmd_name;
  if (!cur_aide.syntax.empty())
    result=result+"("+cur_aide.syntax+")\n";
  vector<localized_string>::const_iterator it=cur_aide.blabla.begin(),itend=cur_aide.blabla.end();
  for (;it!=itend;++it){
    if (it->language==language){
      result = it->chaine +'\n'+result ;
      break;
    }
  }
  // Help_Chooser_Help->value(cut_help(result,Help_Chooser_Help->textsize()+2,Help_Chooser_Help->w()).c_str());
  Help_text_value(result.c_str());
  // Help_text_select();
  help_examples->clear();
  help_related->clear();
  vector<indexed_string>::const_iterator iti=cur_aide.related.begin(),itiend=cur_aide.related.end();
  for (;iti!=itiend;++iti)
    help_related->add(iti->chaine.c_str());
  if (cur_aide.syntax.empty())
    help_examples->add(cur_aide.cmd_name.c_str());
  else {
   vector<string>::const_iterator its=cur_aide.examples.begin(),itsend=cur_aide.examples.end();
   for (;its!=itsend;++its)
     help_examples->add(its->c_str());
  }
}

void make_new_help(const char * chaine) {
  current_help_string=chaine;
int ll=current_help_string.size();
if (ll && current_help_string[ll-1]==' ')
  current_help_string=current_help_string.substr(0,ll-1);
int k=0;
for (;k<aide_v.size();++k){
  if (aide_v[k].cmd_name>=current_help_string)
    break;
}
k = min(k,Help_Chooser_Index->size()-1);
 Help_Chooser_Index->value(k+1);
 bool trouve=current_help_string==aide_v[k].cmd_name;
 cur_aide=helpon(current_help_string.c_str(),aide_v,language,helpitems,!trouve);
 make_help();
 if (!trouve){
    Help_text_value((current_help_string+gettext(" not found. Check best matches above\nOr try Help->Find word in HTML help")).c_str());
 }
 html_vtt=html_help(html_mtt,aide_v[k].cmd_name);
}

void input_insert(const char * chaine,bool selected) {
  size_t pos1=input->position();
size_t pos2=input->mark();
if (pos1>pos2){
  size_t tmp=pos1;
  pos1=pos2;
  pos2=tmp;
}
string input_s(input->value());
size_t l=input_s.size();
input_s=input_s.substr(0,pos1)+chaine+input_s.substr(pos2,l-pos2);
input->value(input_s.c_str());
pos2=pos1+string(chaine).size();
if (selected)
  input->position(pos1,pos2);
else
  input->position(pos2,pos2);
}
static void cb_Save_as(Fl_Menu_ *, void *);
static void cb_Program_store(Fl_Menu_ *, void *);
static void cb_Program_store_as(Fl_Menu_ *, void *);
static void cb_Spread_store_as(Fl_Menu_ *, void *);
static void cb_Save_session(Fl_Menu_ *, void *);
static void cb_Eqw_store(Fl_Menu_ *, void *);
static void cb_Eqw_store_as(Fl_Menu_ *, void *);
static void cb_Save_2dplot_tex(Fl_Menu_ *, void *);
static void cb_Echappement(Fl_Button*, void*);
static void cb_ENTER(Fl_Button*, void*);
static void cb_Show_kbd(Fl_Button*, void*);
static void cb_Tabulation(Fl_Button*, void*);
static void cb_Ans_In(Fl_Button*, void*);
static void cb_Show_io(Fl_Button*, void*);
static void cb_Ans_Down(Fl_Button*, void*);
static void cb_Sto(Fl_Button*, void*);
static void cb_Prg_paste(Fl_Button*, void*);
static void cb_Move_selection_left(Fl_Button*, void*);
static void cb_Move_selection_right(Fl_Button*, void*);
static void cb_En_haut(Fl_Button*, void*);
static void cb_En_bas(Fl_Button*, void*);
static void cb_Crochets(Fl_Button*, void*);
static void cb_Select_eval(Fl_Button*, void*);
static void cb_Double_quote(Fl_Button*, void*);
static void cb_Plot_setup_OK(Fl_Return_Button*, void*);
static void cb_Cas_setup_OK(Fl_Return_Button*, void*);
static void cb_General_setup_OK(Fl_Return_Button*, void*);
static void cb_Majuscule_key(Fl_Button*, void*);
static void cb_Editor_search(Fl_Input*, void*);
static void cb_Spread_stats(Fl_Menu_ *, void *);
static void cb_Spread_classes(Fl_Menu_ *, void *);
static void cb_Spread_new_table(Fl_Menu_ *, void *);

void select_run_file(char * thename) {
  #ifndef WIN32
  chk_data_ready();
  // synchronize_history=true;
#endif //
if (child_busy || data_ready){
  busy_error();
  return;
 }
 undo_history_in=history_in;
 undo_history_out=history_out;
 char runfilename[1024]="session.ar"; 
 if (thename)
   strcpy(runfilename,thename);
 char * newfile;
 fl_font(FL_HELVETICA,10);
 fl_message_font(FL_HELVETICA,10);
  char suffixe[]="*.cas";
  if (maple_mode==1)
    strcpy(suffixe,"*.m*");
  if (maple_mode==2)
    strcpy(suffixe,"*.mu");
  if (maple_mode==3)
    strcpy(suffixe,"*.ti");
 newfile = fl_file_chooser("Run File", suffixe, runfilename);
 if ( (!newfile) || (!*newfile))
  return;
 run_file(newfile);
}

void run_file(const char * newfile) {
  vecteur args,l;
  if (file_not_available(newfile))
    return;
  ifstream inf(newfile);
  char thebuf[BUFFER_SIZE];
  inf.getline(thebuf,BUFFER_SIZE,'\n');
  string lu(thebuf),thet;
  if (lu=="giac archive"){
    fl_message((string(newfile)+gettext(" looks like a session archive. Try File->Run xcas session instead")).c_str());
    return;
  }
  if (lu.size()>9 && lu.substr(0,9)=="{VERSION "){ // Maple Worksheet
    ofstream of("__.map");
    of << "maple_mode(1);" << endl; // insure maple mode
    mws_translate(inf,of);
    of.close();
    maple_mode=1;
    fl_message(gettext("Running maple text translation __.map"));
    run_file("__.map");
    return;
  }
  if (lu.size()>6 && lu.substr(0,6)=="**TI92"){ // TI
     inf.close();
     input_value(("maple_mode(3),read(\""+string(newfile)+"\")").c_str());
     input_eval(false);
     return;
  }
  if (lu=="\\START92\\\r"){
    ofstream of("__.ti");
    ti_translate(inf,of);
    of.close();
    maple_mode=3;
    run_file("__.ti");
    return;
  } // end file of type TI
#ifdef WIN32
ifstream infile(newfile);
readargs_from_stream(infile,args,l);
iterateur it=args.begin(),itend=args.end();
for (int count=0;it!=itend;++it,++count){
  if (it->is_symb_of_sommet(at_debug))
    *it=it->_SYMBptr->feuille;
  history_in.push_back(*it);
  gen res;
  try {
     if (approx_mode(0))
       res=it->evalf();
     else
       res=it->eval();
  } 
  catch (std::runtime_error & error ){
    res = '"'+ string(error.what()) + '"' ;
  }
  history_out.push_back(res);
  if (!(count %5)){
    gen hh(mtran(makevecteur(history_in,history_out)),_HIST__VECT);
    Eqw_history->set_data(hh);
    if (!block_signal) Fl::check();
  }
}
history_redraw(history_out.size());
// clear PICT and recompute from history
Picture->clear();
int i=erase_pos();
updatePICT(vecteur(history_out.begin()+i,history_out.end()));
Fl::focus(input);
//red_draw=true;
Picture->redraw();
#else // WIN32
  chk_data_ready();
  // synchronize_history=true;
 if (child_busy || data_ready){
  busy_error();
  return;
 }
 child_eval(newfile,true,true);
#endif //WIN32
}

void save_file(const char * chaine,int begin_pos,bool withtex) {
  string chaines(chaine);
string archive_name(remove_extension(chaines)+string(".ar"));
archive_session(archive_name,0);
ofstream archive_namef(archive_name.c_str(),ios::app);
archive(archive_namef,turtlevect2vecteur(turtle_stack));
archive(archive_namef,graph_instructions);
#ifdef HAVE_LIBFLVW
archive(archive_namef,gen(spread_ptr->m,_SPREAD__VECT));
#endif
archive_namef.close();
if (maple_mode==0)
  chaines=add_extension(chaine,"cas","");
if (maple_mode==1)
  chaines=add_extension(chaine,"map","");
if (maple_mode==2)
  chaines=add_extension(chaine,"mu","");
if (maple_mode==3)
  chaines=add_extension(chaine,"ti","");
ofstream of(chaines.c_str());
string texchaine;
texchaine=remove_extension(chaines.c_str());
texchaine += ".tex";
ofstream texof(texchaine.c_str());
if (!of || !texof)
  return;
if (withtex){
  texof << "% Generated by xcas" << endl;
  texof << giac::tex_preamble ;
}
int l=min(history_in.size(),history_out.size());
int gnuplot_count=0;
for (int i=begin_pos;i<l;++i){
  if (!of || !texof)
    return;
  if ( (history_in[i].type==_SYMB) && (history_in[i]._SYMBptr->sommet==at_signal) )
     continue;
  of << history_in[i];
  if (i!=l-1) {
    if (maple_mode==3)
      of << "" << endl;
    else
      of << ";" << endl;
  }
  else
    of << endl;
  if (!withtex)
    continue;
  if (history_in[i].type==_STRNG){
    string s=*history_in[i]._STRNGptr;
    int l=s.size(),debut,fin;
    if (l && (s[0]=='"'))
      debut=1;
    else
      debut=0;
    if (l && (s[l-1]='"'))
      fin = l-1;
    else
      fin =l;
    texof << s.substr(debut,fin-debut);
    if (s[debut]!='\\')
      texof << "\\\\" << endl;
    else
      texof << endl; 
  }
  else {
    if ( (history_out[i].type==_SYMB) && (history_out[i]._SYMBptr->sommet==at_program))
      texof << "\\begin{verbatim}\n"+history_out[i].print()+"\n\\end{verbatim}";
    else {
     if ( (history_out[i].type==_VECT) && (history_out[i].subtype==_SPREAD__VECT) )
       texof << spread2tex(*history_out[i]._VECTptr,0) << " = " << gen2tex(history_out[i]) << endl;
     else {
      texof << "\\begin{equation} \\label{eq:" << i << "}\n" <<gen2tex(history_in[i]);
      if ( (history_in[i].type==_SYMB) && ( equalposcomp(notexprint_plot_sommets,history_in[i]._SYMBptr->sommet) || equalposcomp(implicittex_plot_sommets,history_in[i]._SYMBptr->sommet) || history_in[i]._SYMBptr->sommet==at_graph2tex || history_in[i]._SYMBptr->sommet==at_graph3d2tex))
        texof << "\n\\end{equation}" << endl;
      else
        texof << " = " << gen2tex(history_out[i]) << "\n\\end{equation}" << endl;
      }
    }
  }	
  if ( (history_in[i].type==_SYMB) && ( (history_in[i]._SYMBptr->sommet==at_graph2tex) || (history_in[i]._SYMBptr->sommet==at_graph3d2tex) || (equalposcomp(implicittex_plot_sommets,history_in[i]._SYMBptr->sommet) ) ) ){
    string name;
    bool do_input=false;
    if (!equalposcomp(implicittex_plot_sommets,history_in[i]._SYMBptr->sommet) &&history_in[i]._SYMBptr->sommet!=at_graph3d2tex ){
      gen & g=history_in[i]._SYMBptr->feuille;
      if (g.type==_STRNG)
        name=*g._STRNGptr;
      else {
        if ( (g.type==_VECT) && (!g._VECTptr->empty()) && (g._VECTptr->front().type==_STRNG) )
          name=*g._VECTptr->front()._STRNGptr;
      }
    }
    else {
      if (history_out[i].type==_POINTER_){
        texof << gen2tex(history_out[i]) << endl;
        continue;
      }
      if (history_out[i].type==_INT_){
        name=gnuplot_filename+print_INT_(history_out[i].val)+".tex";
        do_input=true;
      }
    }
    // create tex file if name is empty, then copy from name
    if (!name.size()){
       name="#graph2tex#";
       double horiz_unit=horiz_latex/(gnuplot_xmax-gnuplot_xmin);
       double vert_unit=vert_latex/(gnuplot_ymax-gnuplot_ymin);
       double unit=horiz_unit;
       if (horiz_unit>vert_unit)
	 unit=vert_unit;
       graph2tex(name,vecteur(history_out.begin()+erase_pos(i),history_out.begin()+i+1),gnuplot_xmin,gnuplot_xmax,gnuplot_ymin,gnuplot_ymax,unit);
    }
    if (name.size()){
      if (do_input)
        texof << "\\input "+name+"\n";
      else {
       char c;
       ifstream copyif(name.c_str());
       int skip_lines=-4;
       string a_ecrire;
       while (copyif.get(c)){
         a_ecrire += c;
         if (c=='\n'){
           ++skip_lines;
           // cerr << skip_lines << a_ecrire ;
           if ( (skip_lines>=0) && (a_ecrire!="\\end{document}\n") )
             texof << a_ecrire;
           a_ecrire="";
         }
       }
      }
    }
  }
}
of.close();
if (withtex)
  texof << giac::tex_end << endl;
texof.close();
}

void run_archive(const char * newfile) {
  bool ok=false;vecteur extra;
 try {
  gen tmp=unarchive_session(newfile,-1,0,0);
  ok=(tmp.type==_VECT);
  if (ok)
    extra=*tmp._VECTptr;
  if (!history_in.empty() && !history_out.empty()){
    // remove fake zeros
    history_in.pop_back();
    history_out.pop_back();
  }
 } catch(std::runtime_error & e){
   ok=false;
   Help_text_value(e.what());
 }
 if (!ok){
   history_in=undo_history_in;
   history_out=undo_history_out;
 }
 else {
   if (extra.size()>=3 && extra[0].type==_VECT && extra[1].type==_VECT){
     turtle_stack=vecteur2turtlevect(*extra[0]._VECTptr); // plot_instructions=*extra[0]._VECTptr;
     if (!turtle_stack.empty())
       turtle=turtle_stack.back();
     graph_instructions=*extra[1]._VECTptr;
#ifdef HAVE_LIBFLVW
     if (extra[2].type==_VECT && extra[2].subtype==_SPREAD__VECT){
       spread_ptr->set_matrix(extra[2]);
       spread_ptr->changed=false;
     }
#endif //
   }
   plot_instructions.clear();
   int i=erase_pos();
   updatePICT(vecteur(history_out.begin()+i,history_out.end()));
 }
 if (child_id){
   kill(child_id,SIGKILL);
    wait4(child_id,0,0,0);
    child_id=0;
    child_id=make_child();
 }
 history_redraw(history_in.size());
}

Fl_Double_Window *Xcas=(Fl_Double_Window *)0;

Fl_Menu_Bar *xcas=(Fl_Menu_Bar *)0;

static void cb_xcas(Fl_Menu_Bar*, void*) {
  redraw_mouse_position_only=false;
}

static void cb_Fichier(Fl_Menu_*, void*) {
  redraw_mouse_position_only=false;
}

static void cb_Run_session(Fl_Menu_*, void*) {
  int i=0;
if (!history_saved)
  i=fl_ask(gettext("This will replace the current session. Save it before?"));
if (i==1)
  save_file(filename,0,true);
#ifdef HAVE_LIBFLVW
if (spread_ptr->changed)
  i=fl_ask(gettext("This will replace the current matrix. Save it before?"));
if (i==1)
  save_current_sheet(matrixfilename);  
#endif
char suffixe[]="*.ar";
#ifndef WIN32
  chk_data_ready();
  // synchronize_history=true;
#endif //
if (child_busy || data_ready){
  busy_error();
  return;
 }
 undo_history_in=history_in;
 undo_history_out=history_out;
 char runfilename[1024]="session.ar"; 
 char * newfile = fl_file_chooser("Run File", suffixe, runfilename);
 if ( (!newfile) || (!*newfile))
  return;
 run_archive(newfile);
}

static void cb_Run_file(Fl_Menu_*, void*) {
  char suffixe[]="*.cas";
  if (maple_mode==1)
    strcpy(suffixe,"*.m*");
  if (maple_mode==2)
    strcpy(suffixe,"*.mu");
  if (maple_mode==3)
    strcpy(suffixe,"*.ti");
  select_run_file(suffixe);
}

static void cb_Run_script(Fl_Menu_*, void*) {
  load_current_program(0);
  xcas_windows(2);
  // Picture->run_plot_view=false;
  manage_upper_window(upper_window_prog,false);
  Fl::focus(Program_editor);
}

static void cb_Read_program(Fl_Menu_*, void*) {
  char suffixe[]="*.*";
   char * newfile = fl_file_chooser("Read File?", suffixe, progfilename);
   if (!newfile || !newfile[0])
     return;
   input_value(("read(\""+string(newfile)+"\")").c_str());
   input_eval(false);
}

static void cb_Save_session(Fl_Menu_*, void*) {
  if (filename[0] == '\0' || !strcmp(filename,"session.ar")) {
    // No filename - get one!
    cb_Save_as(0,0);
  }
  else save_file(filename,0,true);
  Help_text_value((filename+string(gettext(" saved"))).c_str());
  history_saved=true;
}

static void cb_Save_as(Fl_Menu_*, void*) {
  string tmp;
  for (;;){
   char *newfile;
   fl_font(FL_HELVETICA,10);
   char suffixe[]="*.ar";
   if (!strcmp(filename,"session.ar")){
     strcpy(filename,("session"+print_INT_(session_counter)+".ar").c_str());
     ++session_counter;
   }
   newfile = fl_file_chooser("Save File As?", suffixe, filename);
   if (!newfile || !newfile[0])
     return;
   tmp=remove_extension(newfile).substr(0,1000);
   if (!strcmp(progfilename,"session.cxx")){
     strcpy(progfilename,(tmp+".cxx").c_str());
     if (!access(progfilename,R_OK))
       strcpy(progfilename,"session.cxx");
     Xcas_editor_filename_value(progfilename);
   }
   if (!strcmp(matrixfilename,"session.tab")){
     strcpy(matrixfilename,(tmp+".tab").c_str());
     if (!access(matrixfilename,R_OK))
       strcpy(matrixfilename,"session.tab");
   }
   if (!strcmp(eqwfilename,"session.eqw")){
     strcpy(eqwfilename,(tmp+".eqw").c_str());
     if (!access(eqwfilename,R_OK))
       strcpy(eqwfilename,"session.eqw");
   }
   update_sheet_label();
   if (maple_mode==0)
      tmp += ".cas";
   if (maple_mode==1)
      tmp += ".map";
   if (maple_mode==2)
      tmp += ".mu";
   if (maple_mode==3)
      tmp += ".ti";
   int i=1;
   if (!access(tmp.c_str(),R_OK)){
     i=fl_ask((tmp+gettext(": file exists. Overwrite?")).c_str());
     string tmpar=remove_extension(tmp)+".ar";
     if (i==1 && !access(tmpar.c_str(),R_OK))
       i=fl_ask((tmpar+gettext(": file exists. Overwrite?")).c_str());
   }
   if (i==1)
    break;
  }
  string old_gnuplot_filename=gnuplot_filename;
  gnuplot_filename=remove_extension(tmp);
  strcpy(filename,tmp.c_str());
  Xcas->label((string("xcas:")+tmp).c_str());
  Xcas->redraw();
  // copy previous graphs
  for (int i=0;i<=gnuplot_fileno;++i)
      rename((old_gnuplot_filename+print_INT_(i)+".tex").c_str(),(gnuplot_filename+print_INT_(i)+".tex").c_str());
  save_file(filename,0,true);
  Help_text_value((filename+(string("/.ar")+gettext(" saved"))).c_str());
  history_saved=true;
  bandeau_fill_label_redraw();
}

static void cb_Print_native(Fl_Menu_*, void*) {
  #ifdef HAVE_LIBFLVW
widget_print(Eqw_history);
#endif
}

static void cb_Print_PS(Fl_Menu_*, void*) {
  #ifdef HAVE_LIBFLVW
widget_ps_print(Eqw_history);
#endif
}

static void cb_Preview(Fl_Menu_*, void*) {
  if (filename[0] == '\0') {
    // No filename - get one!
    cb_Save_as(0,0);
  }
  else save_file(filename,0,true);
  if (filename[0] == '\0') return;
#ifdef WIN32
  system((xcasroot+"latex.bat "+remove_extension(filename)).c_str());
  cerr << xcasroot+"latex.bat "+remove_extension(filename) << endl;
  system((xcasroot+"xdvi.bat "+remove_extension(filename)).c_str());
  cerr << xcasroot+"xdvi.bat "+remove_extension(filename) << endl;
#else
  system(("latex "+remove_extension(filename)).c_str());
  system(("xdvi "+remove_extension(filename)+" &").c_str());
#endif //
}

static void cb_Print_to_printer(Fl_Menu_*, void*) {
  if (filename[0] == '\0') {
    // No filename - get one!
    cb_Save_as(0,0);
  }
  else save_file(filename,0,true);
  if (filename[0] == '\0') return;
#ifdef WIN32
  system((xcasroot+"latex.bat "+remove_extension(filename)).c_str());
  system((xcasroot+"dvips.bat "+remove_extension(filename)).c_str());
#else
  system(("latex "+remove_extension(filename)).c_str());
  system(("dvips "+remove_extension(filename)).c_str());
#endif //
}

static void cb_Import_xcas(Fl_Menu_*, void*) {
  int save_maple_mode=maple_mode;
maple_mode=0;
select_run_file("*.cxx");
maple_mode=save_maple_mode;
}

static void cb_Import_maple(Fl_Menu_*, void*) {
  int save_maple_mode=maple_mode;
maple_mode=1;
select_run_file("*.map");
maple_mode=save_maple_mode;
}

static void cb_Import_mws(Fl_Menu_*, void*) {
  int save_maple_mode=maple_mode;
maple_mode=1;
select_run_file("*.mws");
maple_mode=save_maple_mode;
}

static void cb_Import_mupad(Fl_Menu_*, void*) {
  int save_maple_mode=maple_mode;
maple_mode=2;
select_run_file("*.mu");
maple_mode=save_maple_mode;
}

static void cb_Import_ti89(Fl_Menu_*, void*) {
  int save_maple_mode=maple_mode;
maple_mode=3;
select_run_file("*.89*");
maple_mode=save_maple_mode;
}

static void cb_Import_ti92(Fl_Menu_*, void*) {
  int save_maple_mode=maple_mode;
maple_mode=3;
select_run_file("*.92*");
maple_mode=save_maple_mode;
}

static void cb_Import_ti_text(Fl_Menu_*, void*) {
  int save_maple_mode=maple_mode;
maple_mode=3;
select_run_file("*.txt");
maple_mode=save_maple_mode;
}

static void cb_Export_xcas(Fl_Menu_*, void*) {
  int save_maple_mode=maple_mode;
maple_mode=0;
char * newfile;
fl_font(FL_HELVETICA,10);
  newfile = fl_file_chooser("Save File As?", "*.cas", filename);
  if (newfile != NULL) 
    save_file(newfile,0,true);
maple_mode=save_maple_mode;
}

static void cb_Export_maple(Fl_Menu_*, void*) {
  int save_maple_mode=maple_mode;
maple_mode=1+_DECALAGE;
char * newfile;
fl_font(FL_HELVETICA,10);
  newfile = fl_file_chooser("Save File As?", "*.map", "*.map");
  if (newfile != NULL) 
    save_file(newfile,0,true);
maple_mode=save_maple_mode;
}

static void cb_Export_mupad(Fl_Menu_*, void*) {
  int save_maple_mode=maple_mode;
maple_mode=2;
char * newfile;
fl_font(FL_HELVETICA,10);
  newfile = fl_file_chooser("Save File As?", "*.mu", "*.mu");
  if (newfile != NULL) 
    save_file(newfile,0,true);
maple_mode=save_maple_mode;
}

static void cb_Export_ti89(Fl_Menu_*, void*) {
  int save_maple_mode=maple_mode;
maple_mode=3;
char * newfile;
fl_font(FL_HELVETICA,10);
  newfile = fl_file_chooser("Save File As?", "*.ti", filename);
  if (newfile != NULL) 
    save_file(newfile,0,true);
maple_mode=save_maple_mode;
}

static void cb_Francais(Fl_Menu_*, void*) {
  set_language(1);
}

static void cb_English(Fl_Menu_*, void*) {
  set_language(2);
}

static void cb_Espanol(Fl_Menu_*, void*) {
  set_language(3);
}

static void cb_Save_config(Fl_Menu_*, void*) {
  #ifdef WIN32 
// Save config in home_dir or if not available in $XCAS_ROOT or current dir
string s((giac::home_directory()));
if (s.size()<2 && getenv("XCAS_ROOT"))
  s=getenv("XCAS_ROOT")+string("/");
if (s.size()<2)
  s="";
cerr << "Saving preferences in file " << s+xcasrc << endl;
ofstream of((s+xcasrc).c_str());
#else
ofstream of((giac::home_directory()+xcasrc).c_str());
#endif //
   of << "widget_size(" << print_INT_(Eqw_eqw->attr.fontsize) << "," << Xcas->x() << "," << Xcas->y() << "," << Xcas->w() << "," << Xcas->h() << "," ;
   if (Picture->fullscreen) 
     of << "0," ; 
   else 
     of << "1," ;
   if (horizontal_split)
     of << "-";
   of << current_upper_window.size();
   if (Bandeau->value()) 
     of << ",1," ; 
   else 
     of << ",0," ;
   int pretty;
   if (pretty_input)
     pretty=0;
   else
     pretty=2;
   if (!Recompute_history->value())
     pretty += 1;
   if (Pretty_print->value())
     pretty += 4;
   if (Eqw_history_freezed->value())
     pretty += 8;
   of << pretty ;
   if (getenv("BROWSER"))
     of << "," << '"' << getenv("BROWSER") << '"' ;
   else
     of << "," << '"' << '"' ;
   if (Xcas_turtle->value()) xcas_user_level=8;
   else { if (xcas_user_level==8) xcas_user_level=0; }
   string xcas_level(Xcas_level_output->value());
   of << "," << xcas_user_level ;
   if (getenv("GIAC_PREVIEW"))
     of << "," << '"' << getenv("GIAC_PREVIEW") << '"' ;
   of << ");" << endl;
   // of << "maple_mode(" << maple_mode << ");" << endl;
   of << cas_setup_string(0) << ";" << endl;
   of << geo_setup_string() << ";" << endl;
   vecteur vv(*_lsmod(zero)._VECTptr);
   const_iterateur it=vv.begin(),itend=vv.end();
   for (;it!=itend;++it)
     of << "insmod(" << it->print() << ");" << endl;
}

static void cb_Eqw_open(Fl_Menu_*, void*) {
  char sheetfilename[1024];
 strcpy(sheetfilename,("eqw"+print_INT_(eqw_counter)+".eqw").c_str()); 
 char * newfile = fl_file_chooser("Load equation", "*.eqw", sheetfilename);
 if ( file_not_available(newfile))
  return;
 ifstream inf(newfile);
 string tmp="";
 char c;
 for (;;){
   inf.get(c);
   if (inf.eof())
     break;
   tmp += c;
 }
 Eqw_eqw->data=Eqw_compute_size(tmp,Eqw_eqw->attr,Eqw_eqw->w());
 Eqw_eqw->setscroll();
}

static void cb_Eqw_store(Fl_Menu_*, void*) {
  if (!eqwfilename || eqwfilename[0]=='\0' || !strcmp(eqwfilename,"session.eqw"))
   cb_Eqw_store_as(0,0);
 ofstream of(eqwfilename);
 of << Eqw_eqw->get_data() ;
 Help_text_value((eqwfilename+string(" saved")).c_str());
}

static void cb_Eqw_store_as(Fl_Menu_*, void*) {
  strcpy(eqwfilename,("session"+print_INT_(eqw_counter)+".eqw").c_str()); 
 char * newfile = fl_file_chooser("Store equation", "*.eqw", eqwfilename);
 if ( (!newfile) || (!*newfile))
  return;
 ++eqw_counter;
 string tmp=remove_extension(newfile).substr(0,1000)+".eqw";
 strcpy(eqwfilename,tmp.c_str());
 ofstream of(eqwfilename);
 of << Eqw_eqw->get_data() ;
 Help_text_value((eqwfilename+string(" saved")).c_str());
}

static void cb_Eqw_insert(Fl_Menu_*, void*) {
  if (current_upper_window[0]!=upper_window_eqw)
    return;
 char sheetfilename[1024];
 strcpy(sheetfilename,("session"+print_INT_(eqw_counter)+".eqw").c_str()); 
 char * newfile = fl_file_chooser("Insert equation", "*.eqw", sheetfilename);
 if ( file_not_available(newfile) )
  return;
 ifstream inf(newfile);
 string tmp="";
 char c;
 for (;;){
   inf.get(c);
   if (inf.eof())
     break;
   tmp += c;
 }
 Eqw_eqw->parse_desactivate();
 Eqw_eqw->replace_selection(tmp);
}

static void cb_Eqw_substore(Fl_Menu_*, void*) {
  if (current_upper_window[0]!=upper_window_eqw)
    return;
char sheetfilename[1024];
 strcpy(sheetfilename,("session"+print_INT_(eqw_counter)+".eqw").c_str()); 
 char * newfile = fl_file_chooser("Store selection", "*.eqw", eqwfilename);
 if ( (!newfile) || (!*newfile))
  return;
++eqw_counter;
 string tmp=add_extension(newfile,"eqw","");
 ofstream of(tmp.c_str());
 of << Eqw_eqw->get_selection();
 Help_text_value((tmp+string(" saved")).c_str());
}

static void cb_Print_eqw(Fl_Menu_*, void*) {
  widget_print(Eqw_eqw);
}

static void cb_Save_eqw_ps(Fl_Menu_*, void*) {
  widget_ps_print(Eqw_eqw);
}

static void cb_Save_2dplot_ps(Fl_Menu_*, void*) {
  widget_ps_print(Picture);
}

static void cb_Print_2dplot(Fl_Menu_*, void*) {
  widget_print(Picture);
}

static void cb_Save_2dplot_svg(Fl_Menu_*, void*) {
  char svgfilename[1024];
 strcpy(svgfilename,("session"+print_INT_(png_count)+".svg").c_str()); 
 char * newfile = fl_file_chooser("Store 2-d graph", "*.svg", svgfilename);
 if ( (!newfile) || (!*newfile))
  return;
 ++png_count;
 string tmp=add_extension(newfile,"svg","");
 ofstream of(tmp.c_str());
 of <<svg_preamble(10,10);
 of <<gen2svg(*Picture->plot_instructions_ptr)<<endl;
 of <<svg_grid()<<"</svg>"<<endl;
 Help_text_value((tmp+string(" saved")).c_str());
}

static void cb_Save_2dplot_tex(Fl_Menu_* o, void*) {
  string name_=remove_extension(filename)+print_INT_(png_count);
   string name(name_+".tex");
   vecteur vg;
   if (Picture->turtleptr && Xcas_turtle->value()){
     double horiz_unit=horiz_latex/Picture->w();
     double vert_unit=vert_latex/Picture->h();
     double unit=horiz_unit;
     if (horiz_unit>vert_unit)
	unit=vert_unit;
     vg=turtlevect2vecteur(*Picture->turtleptr);
     graph2tex(name,vg,0,Picture->w(),0,Picture->h(),unit,true);
   }
   else {
     double horiz_unit=horiz_latex/(gnuplot_xmax-gnuplot_xmin);
     double vert_unit=vert_latex/(gnuplot_ymax-gnuplot_ymin);
     double unit=horiz_unit;
     if (horiz_unit>vert_unit)
	unit=vert_unit;
     if (user_screen)
       vg=graph_instructions;
     else {
       int i=history_out.size();
       vg=vecteur(history_out.begin()+erase_pos(i),history_out.begin()+i);
     }
     graph2tex(name,vg,gnuplot_xmin,gnuplot_xmax,gnuplot_ymin,gnuplot_ymax,unit);
  }
  png_count++;
#ifdef WIN32
  system((xcasroot+"latex.bat "+name_).c_str());
  system((xcasroot+"dvips.bat "+name_+" -o "+name_+".ps").c_str());
#else
  system(("latex "+name_).c_str());
  system(("dvips "+name_+" -o "+name_+".ps").c_str());
#endif //
  Help_text_value(("Saved to "+name+" and " + name_+".ps").c_str());
}

static void cb_Save_3dplot_tex(Fl_Menu_*, void*) {
  string name=remove_extension(filename)+print_INT_(png_count)+"_3d.tex";
  _graph3d2tex(string2gen(name,false));
  Help_text_value(("Saved to "+name).c_str());
}

static void cb_Save_3dplot_png(Fl_Menu_*, void*) {
  char * newfile;
newfile = fl_file_chooser("Save 3-d plot png","*.png","image3d.png");
if (newfile && newfile[0]){
  if (!access(newfile,R_OK)){
    int i=fl_ask(gettext("File exists. Overwrite?"));
    if (i!=1)
      return;
  }
  png_replot(absolute_path(newfile).c_str()); 
  Help_text_value(("Saved to "+string(newfile)+".png").c_str());
  };
}

static void cb_Save_3dplot_svg(Fl_Menu_*, void*) {
  char * newfile;
newfile = fl_file_chooser("Save 3-d plot svg","*.svg","image3d.svg");
if (newfile && newfile[0]){
  if (!access(newfile,R_OK)){
    int i=fl_ask(gettext("File exists. Overwrite?"));
    if (i!=1)
      return;
  }
  terminal_replot("svg",absolute_path(newfile).c_str()); 
  Help_text_value(("Saved to "+string(newfile)+".svg").c_str());
  };
}

static void cb_Save_3dplot_emf(Fl_Menu_*, void*) {
  char * newfile;
newfile = fl_file_chooser("Save 3-d plot emf","*.emf","image3d.emf");
if (newfile && newfile[0]){
  if (!access(newfile,R_OK)){
    int i=fl_ask(gettext("File exists. Overwrite?"));
    if (i!=1)
      return;
  }
  terminal_replot("emf",absolute_path(newfile)); 
  Help_text_value(("Saved to "+string(newfile)).c_str());
  };
}

static void cb_Spread_open(Fl_Menu_*, void*) {
  #ifdef HAVE_LIBFLVW 
if (spread_ptr->changed){
  int i=fl_ask(gettext("Save changes"));
  if (i==1)
    save_current_sheet(matrixfilename);
  else
    save_current_xcas_matrix(matrixfilename);
}
#ifndef IPAQ
if (!matrixfilename[0])
#endif //
 strcpy(matrixfilename,("session"+print_INT_(sheet_counter)+".tab").c_str()); 
 char * newfile = fl_file_chooser("Load sheet", "*.tab", "*.tab");
 if (!newfile || file_not_available(newfile))
   return;
 strcpy(matrixfilename,newfile);
 update_sheet_label();
 ifstream inf(newfile);
 gen value(read1arg_from_stream(inf,list_one_letter__IDNT)); 
 try {
   spread_ptr->set_matrix(value);
   spread_ptr->changed=false;
   save_current_xcas_matrix(matrixfilename);
 }
 catch(std::runtime_error & e){
   cerr << e.what() << endl;
 }
#endif //
}

static void cb_Spread_store(Fl_Menu_*, void*) {
  #ifdef HAVE_LIBFLVW 
if (!strcmp(matrixfilename,"session.tab"))
  cb_Spread_store_as(0,0);
else
  save_current_sheet(matrixfilename);
#endif //
}

static void cb_Spread_store_as(Fl_Menu_*, void*) {
  #ifdef HAVE_LIBFLVW 
 string tmp;
 for (;;){
  char * newfile = fl_file_chooser("Store sheet", "*.tab", ("session"+print_INT_(sheet_counter)+".tab").c_str());
  if ( (!newfile) || (!*newfile))
   return;
  tmp=newfile;
  tmp=remove_extension(tmp.substr(0,1000).c_str())+".tab";
  if (access(tmp.c_str(),R_OK))
    break;
  int i=fl_ask((tmp+gettext(": file exists. Overwrite?")).c_str());
  if (i==1)
    break;
 }
 strcpy(matrixfilename,tmp.c_str()); 
 ++sheet_counter;
 strcpy(matrixfilename,tmp.c_str());
 update_sheet_label();
save_current_sheet(matrixfilename);
 Xcas_matrix_filename_value(matrixfilename);
#endif //
}

static void cb_Spread_insert(Fl_Menu_*, void*) {
  #ifdef HAVE_LIBFLVW 
 char sheetfilename[1024];
 strcpy(sheetfilename,("session"+print_INT_(sheet_counter)+".tab").c_str()); 
 char * newfile = fl_file_chooser("Insert sheet", "*.tab", sheetfilename);
 if ( file_not_available(newfile))
  return;
 ifstream inf(newfile);
 gen value(read1arg_from_stream(inf,list_one_letter__IDNT));
 if (!ckmatrix(value))
   return;
 spread_ptr->paste(*value._VECTptr);
#endif //
}

static void cb_Spread_substore(Fl_Menu_*, void*) {
  #ifdef HAVE_LIBFLVW
 if (spread_ptr->selected.empty() )
   return;
 char sheetfilename[1024];
 strcpy(sheetfilename,("session"+print_INT_(sheet_counter)+".tab").c_str()); 
 char * newfile = fl_file_chooser("Save selection", "*.tab", sheetfilename);
 if ( (!newfile) || (!*newfile))
  return;
 ++sheet_counter;
 string tmp(add_extension(newfile,"tab","sheet"));
 ofstream of(tmp.c_str());
if (spread_ptr->is_spreadsheet)
  of << gen(spread_ptr->selected,_SPREAD__VECT) << endl;
else
  of << gen(extractmatricefromsheet(spread_ptr->selected)) << endl;
#endif //
}

static void cb_Print_spread(Fl_Menu_*, void*) {
  #ifdef HAVE_LIBFLVW
widget_print(spread_ptr);
#endif //
}

static void cb_Save_sheet_ps(Fl_Menu_*, void*) {
  #ifdef HAVE_LIBFLVW
widget_ps_print(spread_ptr);
#endif
}

static void cb_Program_open(Fl_Menu_*, void*) {
  load_current_program(0);
}

static void cb_Program_store(Fl_Menu_*, void*) {
  if (!progfilename || progfilename[0]==0 || !strcmp(progfilename,"session.cxx"))
  cb_Program_store_as(0,0);
else
  save_current_program(progfilename);
}

static void cb_Program_store_as(Fl_Menu_*, void*) {
  string tmp;
 for (;;){
  char * newfile = fl_file_chooser("Store program", "*.cxx", ("session"+print_INT_(program_counter)+".cxx").c_str());
  if ( (!newfile) || (!*newfile))
   return;
  tmp=newfile;
  tmp=remove_extension(tmp.substr(0,1000).c_str())+".cxx";
  if (access(tmp.c_str(),R_OK))
    break;
  int i=fl_ask((tmp+gettext(": file exists. Overwrite?")).c_str());
  if (i==1)
    break;
 }
 strcpy(progfilename,tmp.c_str());
 ++program_counter;
 save_current_program(tmp.c_str());
 Xcas_editor_filename_value(progfilename);
 Programme->redraw();
}

static void cb_Program_insert(Fl_Menu_*, void*) {
  if (current_upper_window[0]!=upper_window_prog)
    return;
  char sheetfilename[1024];
   strcpy(sheetfilename,("prog"+print_INT_(program_counter)+".cxx").c_str()); 
 char * newfile = fl_file_chooser("Insert program", "*.cxx", sheetfilename);
 if ( file_not_available(newfile) )
  return;
Program_editor->buffer()->insertfile(newfile,Program_editor->insert_position());
}

static void cb_Print_prg(Fl_Menu_*, void*) {
  widget_print(Program_editor);
}

static void cb_Save_prg_ps(Fl_Menu_*, void*) {
  widget_ps_print(Program_editor);
}

static void cb_Update_xcas(Fl_Menu_*, void*) {
  #ifdef WIN32 // new code added since update can not update while xcas runs
fl_message(gettext("To update, quit xcas first, then run update in Start->Programs->Xcas or update.bat in the xcas directory"));
return;
#endif
int i=fl_ask(gettext("Check Internet connexion. Ready to update xcas?"));
if (i!=1)
  return;
#ifdef WIN32 //
system(("cd "+xcasroot+" && ./update.bat &").c_str());
#else //
system(("cd "+xcasroot+" && ./updatecas &").c_str());
#endif //
Xcas->hide();
}

static void cb_A_propos(Fl_Menu_*, void*) {
  a_propos();
string s="(c) 2004, B. Parisse, R. De Graeve\nwww-fourier.ujf-grenoble.fr/~parisse/giac.html\nIf you like xcas,\nplease put the link above on your web page!";
fl_message(s.c_str());
manage_upper_window(upper_window_full_message,false);
}

static void cb_Quit(Fl_Menu_*, void*) {
  Xcas->hide();
}

static void cb_Edit_edit(Fl_Menu_*, void*) {
  redraw_mouse_position_only=false;
}

static void cb_Cmdline_to_eqw(Fl_Menu_*, void*) {
  cmdline2eqw();
}

static void cb_Cmdline_to_mtrw(Fl_Menu_*, void*) {
  if (current_upper_window[0]!=upper_window_mtrw)
  save_matrix_input_value=input->value();
}

static void cb_History_to_eqw(Fl_Menu_*, void*) {
  hist2eqw();
}

static void cb_History_to_prog(Fl_Menu_*, void*) {
  const char * ch=Program_editor->buffer()->text();
  string s(ch); free((void *)ch);
  const_iterateur it=history_in.begin(),itend=history_in.end();
  for (;it!=itend;++it){
    if (it->is_symb_of_sommet(at_expr)){
      gen tmp=it->_SYMBptr->feuille;
      if (tmp.type==_VECT && tmp.subtype==_SEQ__VECT && tmp._VECTptr->size()==2)
        tmp = tmp._VECTptr->front();
      if (tmp.type==_STRNG) s += *tmp._STRNGptr; else s += tmp.print();
    }
    else
      s += it->print();
    s += ";\n";
  }
  Program_editor->buffer()->text(s.c_str());
}

static void cb_Eqw_to_history(Fl_Menu_*, void*) {
  if (current_upper_window[0]==upper_window_eqw){
              input_insert(Eqw_eqw->get_selection().print().c_str(),true);
              manage_upper_window(upper_window_hist,false);
              };
}

static void cb_Cell_to_history(Fl_Menu_*, void*) {
  if (current_upper_window[0]==upper_window_mtrw)
  save_input_value=input->value();
}

static void cb_Matrix_to_history(Fl_Menu_*, void*) {
  manage_upper_window(upper_window_hist,false);
Fl::focus(input);
#ifdef HAVE_LIBFLVW
  // copy current sheet in input as a matrix
   if (spread_ptr->is_spreadsheet)
    input_insert(gen(spread_ptr->m,_SPREAD__VECT).print().c_str(),true);
   else
    input_insert(gen(extractmatricefromsheet(spread_ptr->m),_MATRIX__VECT).print().c_str(),true);
#endif //
}

static void cb_Matrixsel_to_cmdline(Fl_Menu_*, void*) {
  manage_upper_window(upper_window_hist,false);
Fl::focus(input);
#ifdef HAVE_LIBFLVW
  // copy current sheet in input as a matrix
   if (spread_ptr->is_spreadsheet)
    input_insert(gen(spread_ptr->selected,_SPREAD__VECT).print().c_str(),true);
   else
    input_insert(gen(extractmatricefromsheet(spread_ptr->selected),_MATRIX__VECT).print().c_str(),true);
#endif //
}

static void cb_Prg_to_cmdline(Fl_Menu_*, void*) {
  const char * ch=Program_editor->buffer()->text();
  string s(ch); free((void *)ch);
  input_value(s.c_str());
}

static void cb_Edit_clear(Fl_Menu_*, void*) {
  if (run_modif && !input->value()[0]) modify_history(); else input->value("");
}

static void cb_Clear_history(Fl_Menu_*, void*) {
  clear_history();
}

static void cb_Newprob(Fl_Menu_*, void*) {
  int i=clear_history(); if (i==1) rm_variables();
}

static void cb_Remove_a_z(Fl_Menu_*, void*) {
  input_value("_rm_a_z(zero,0)");
}

static void cb_Remove_vars(Fl_Menu_*, void*) {
  rm_variables();
}

static void cb_Clear_Eqw(Fl_Menu_*, void*) {
  Eqw_eqw->data=Eqw_nullstring(Eqw_eqw->attr);
  Eqw_eqw->setscroll();
}

static void cb_Spread_new_table(Fl_Menu_*, void*) {
  #ifdef HAVE_LIBFLVW
int confirm=fl_ask(gettext("Clear sheet?")); 
  if (confirm){
    spread_ptr->set_matrix(vecteur(50,vecteur(10,zero)));
    spread_ptr->is_spreadsheet=true;
    strcpy(matrixfilename,"session.tab");
    update_sheet_label();
  }
#endif //
}

static void cb_Clear_Program(Fl_Menu_*, void*) {
  int i=fl_ask(gettext("Really clear?"));
if (i==1){
  Program_editor->buffer()->text("");
  strcpy(progfilename,"session.cxx");
  Xcas_editor_filename_value(progfilename);
};
}

static void cb_Edit_ClrIO(Fl_Menu_*, void*) {
  input_value("ClrIO");
input_eval(false);
}

static void cb_Edit_paste(Fl_Menu_*, void*) {
  #ifdef HAVE_LIBFLVW
if (current_upper_window[0]==upper_window_mtrw){
  spread_ptr->paste(spread_ptr->selected);
  return;
}
#endif //
Fl::paste(*Fl::focus());
}

static void cb_Cancel_modif(Fl_Menu_*, void*) {
  history_redraw(history_in.size());
}

static void cb_Xcas_1_Window(Fl_Menu_*, void*) {
  xcas_windows(1); Left_Xcas_resize(); history_redraw(history_in.size());
}

static void cb_Xcas_2_Windows(Fl_Menu_*, void*) {
  xcas_windows(2); Left_Xcas_resize(); history_redraw(history_in.size());
}

static void cb_Xcas_3_Windows(Fl_Menu_*, void*) {
  xcas_windows(3); Left_Xcas_resize(); history_redraw(history_in.size());
}

static void cb_Edit_eqw(Fl_Menu_*, void*) {
  Picture->run_plot_view=false;
manage_upper_window(upper_window_eqw,false);
}

static void cb_Edit_geo(Fl_Menu_*, void*) {
  manage_upper_window(upper_window_geo,false);
}

static void cb_Edit_help1(Fl_Menu_*, void*) {
  help_save_focus=Fl::focus();
manage_upper_window(upper_window_help,false);
string t(input->value()),s;
size_t sel1=input->position(),sel2=input->mark();
if (sel1==sel2)
  s=t;
if (sel1>sel2){
  std::swap<size_t>(sel1,sel2);
s=t.substr(sel1,sel2-sel1);
}
size_t pos=s.find_first_of('(');
if (pos)
  s=s.substr(0,pos);
make_new_help(s.c_str());
}

static void cb_Edit_history(Fl_Menu_*, void*) {
  Fl::focus(input);
manage_upper_window(upper_window_hist,false);
}

static void cb_Edit_matrix(Fl_Menu_*, void*) {
  Picture->run_plot_view=false;
manage_upper_window(upper_window_mtrw,false);
}

static void cb_Edit_msg(Fl_Menu_*, void*) {
  manage_upper_window(upper_window_full_message,false);
}

static void cb_Edit_prg(Fl_Menu_*, void*) {
  Picture->run_plot_view=false;
  manage_upper_window(upper_window_prog,false);
}

static void cb_Horizontal_split_menu(Fl_Menu_*, void*) {
  horizontal_split=true;
Horizontal_split->value(true);
Left_Xcas_resize();
}

static void cb_Vertical_split_menu(Fl_Menu_*, void*) {
  horizontal_split=false;
Horizontal_split->value(false);
Left_Xcas_resize();
}

static void cb_On_bandeau(Fl_Menu_*, void*) {
  Bandeau->value(1);
bandeau->show();
bandeau2->hide();
}

static void cb_Off_bandeau(Fl_Menu_*, void*) {
  Bandeau->value(0);
bandeau->hide();
bandeau2->show();
}

static void cb_Edit_undo(Fl_Menu_*, void*) {
  Eqw * eqwptr = dynamic_cast<Eqw *>(Fl::focus());
if (eqwptr){
  eqwptr->rcl_data();
};
}

static void cb_Geo_zoom_in(Fl_Menu_*, void*) {
  Picture->geo_zoom(0.707);
}

static void cb_Geo_zoom_out(Fl_Menu_*, void*) {
  Picture->geo_zoom(1.414);
}

static void cb_Xcas_Recompute_history(Fl_Menu_*, void*) {
  if (!history_in.empty()){
  run_modif=true;run_modif_pos=0; 
  input_value(history_in.front().print().c_str()); 
  input_eval(false);
 };
}

static void cb_History_insert_level(Fl_Menu_*, void*) {
  int pos=history_pos(); 
  if (pos<history_in.size() && pos < history_out.size()){
    history_in.insert(history_in.begin()+pos,0); 
    history_out.insert(history_out.begin()+pos,0); 
    history_redraw(pos+1);
  };
}

static void cb_CPP_View(Fl_Menu_*, void*) {
  hist_view(0);
}

static void cb_Maple_View(Fl_Menu_*, void*) {
  hist_view(1+_DECALAGE);
}

static void cb_Mupad_View(Fl_Menu_*, void*) {
  hist_view(2);
}

static void cb_TI89_View(Fl_Menu_*, void*) {
  hist_view(3);
}

static void cb_Spread_inc_col_sort(Fl_Menu_*, void*) {
  #ifdef HAVE_LIBFLVW //
sheetsort(false,true);
spread_eval_interrupt(spread_ptr->m,0);
spread_ptr->redraw();
#endif //
}

static void cb_Spread_dec_col_sort(Fl_Menu_*, void*) {
  #ifdef HAVE_LIBFLVW //
sheetsort(false,false);
spread_eval_interrupt(spread_ptr->m,0);
spread_ptr->redraw();
#endif //
}

static void cb_Spread_inc_row_sort(Fl_Menu_*, void*) {
  #ifdef HAVE_LIBFLVW //
sheetsort(true,true);
spread_eval_interrupt(spread_ptr->m,0);
spread_ptr->redraw();
#endif //
}

static void cb_Spread_dec_row_sort(Fl_Menu_*, void*) {
  #ifdef HAVE_LIBFLVW //
sheetsort(true,false);
spread_eval_interrupt(spread_ptr->m,0);
spread_ptr->redraw();
#endif //
}

static void cb_Edit_copy_menu(Fl_Menu_*, void*) {
  #ifdef HAVE_LIBFLVW
spread_ptr->copy();
#endif //
}

static void cb_Spread_insert_col_end(Fl_Menu_*, void*) {
  #ifdef HAVE_LIBFLVW 
spread_ptr->addcolatend();
#endif //
}

static void cb_Spread_insert_row_end(Fl_Menu_*, void*) {
  #ifdef HAVE_LIBFLVW 
spread_ptr->addrowatend();
#endif //
}

static void cb_Spread_delete_col(Fl_Menu_*, void*) {
  #ifdef HAVE_LIBFLVW 
spread_ptr->spread_erase(0,1); 
#endif //
}

static void cb_Spread_delete_row(Fl_Menu_*, void*) {
  #ifdef HAVE_LIBFLVW 
spread_ptr->spread_erase(1,0); 
#endif //
}

static void cb_Spread_delete_cols(Fl_Menu_*, void*) {
  #ifdef HAVE_LIBFLVW 
spread_ptr->erase_row_col(1); 
#endif //
}

static void cb_Spread_delete_rows(Fl_Menu_*, void*) {
  #ifdef HAVE_LIBFLVW 
spread_ptr->erase_row_col(0); 
#endif //
}

static void cb_Spread_new_table2(Fl_Menu_*, void*) {
  cb_Spread_new_table(0,0);
}

static void cb_Spread_col_larger(Fl_Menu_*, void*) {
  #ifdef HAVE_LIBFLVW 
spread_ptr->col_width(spread_ptr->col_width(spread_ptr->col())+5,spread_ptr->col());
#endif //
}

static void cb_Spread_col_smaller(Fl_Menu_*, void*) {
  #ifdef HAVE_LIBFLVW 
spread_ptr->col_width(spread_ptr->col_width(spread_ptr->col())-5,spread_ptr->col());
#endif //
}

static void cb_Spread_move_right(Fl_Menu_*, void*) {
  #ifdef HAVE_LIBFLVW 
spread_ptr->move_on_enter(FLV_MOVE_ON_ENTER_COL_ROW); 
spread_ptr->move_right=true;
#endif //
}

static void cb_Spread_move_down(Fl_Menu_*, void*) {
  #ifdef HAVE_LIBFLVW 
spread_ptr->move_on_enter(FLV_MOVE_ON_ENTER_ROW_COL); 
spread_ptr->move_right=false;
#endif //
}

static void cb_Spread_table(Fl_Menu_*, void*) {
  input_1arg("tablefunc",false,false);
}

static void cb_Spread_tableseq(Fl_Menu_*, void*) {
  input_1arg("tableseq",false,false);
}

static void cb_Spread_copy_down(Fl_Menu_*, void*) {
  #ifdef HAVE_LIBFLVW
spread_ptr->copy_down();
#endif //
}

static void cb_Spread_copy_right(Fl_Menu_*, void*) {
  #ifdef HAVE_LIBFLVW
spread_ptr->copy_right();
#endif //
}

static void cb_Spread_fill_selection(Fl_Menu_*, void*) {
  #ifdef HAVE_LIBFLVW
spread_ptr->copy_first_in_selection();
#endif //
}

static void cb_Spread_fill_0(Fl_Menu_*, void*) {
  #ifdef HAVE_LIBFLVW
bool tmp=spread_ptr->is_spreadsheet;
spread_ptr->is_spreadsheet=false;
spread_ptr->blank();
spread_ptr->is_spreadsheet=tmp;
#endif //
}

static void cb_Spread_classes(Fl_Menu_*, void*) {
  #ifdef HAVE_LIBFLVW
if (current_upper_window[0]==upper_window_mtrw){
  matrice g;
  try {
    g=effectifs(extractmatricefromsheet(spread_ptr->selected),class_minimum,class_size);
  } catch (std::runtime_error & e){
    return;
  }
  spread_ptr->paste(g);
  return;
}
#endif //
}

static void cb_Spread_recompute(Fl_Menu_*, void*) {
  #ifdef HAVE_LIBFLVW
spread_eval_interrupt(spread_ptr->m,spread_ptr->lc,0);
spread_ptr->redraw();
#endif //
}

static void cb_Program_find(Fl_Menu_*, void*) {
  manage_upper_window(upper_window_prog,false); Fl::focus(Editor_search);
}

static void cb_Program_findnext(Fl_Menu_*, void*) {
  manage_upper_window(upper_window_prog,false); cb_Editor_search(0,0);
}

static void cb_Program_replace(Fl_Menu_*, void*) {
  manage_upper_window(upper_window_prog,false); Fl::focus(Editor_replace);
}

static void cb_Cas_setup(Fl_Menu_*, void*) {
  fltk_cas_setup();
}

static void cb_General_setup(Fl_Menu_*, void*) {
  general_setup();
}

static void cb_Plot_setup(Fl_Menu_*, void*) {
  plot_setup();
}

static void cb_Xcas_tortue_zoomin(Fl_Menu_*, void*) {
  Picture->turtlezoom *= 1.414;
Picture->redraw();
}

static void cb_Xcas_tortue_zoomout(Fl_Menu_*, void*) {
  Picture->turtlezoom *= .707;
Picture->redraw();
}

static void cb_Xcas_tortue_gauche(Fl_Menu_*, void*) {
  Picture->turtlex -= int(Picture->w()/(5*Picture->turtlezoom));
Picture->redraw();
}

static void cb_Xcas_tortue_droite(Fl_Menu_*, void*) {
  Picture->turtlex += int(Picture->w()/(5*Picture->turtlezoom));
Picture->redraw();
}

static void cb_Xcas_tortue_haut(Fl_Menu_*, void*) {
  Picture->turtley += int(Picture->h()/(5*Picture->turtlezoom));
Picture->redraw();
}

static void cb_Xcas_tortue_bas(Fl_Menu_*, void*) {
  Picture->turtley -= int(Picture->h()/(5*Picture->turtlezoom));
Picture->redraw();
}

static void cb_Xcas_tortue_avance(Fl_Menu_*, void*) {
  input_0arg("avance ");
}

static void cb_Xcas_tortue_recule(Fl_Menu_*, void*) {
  input_0arg("recule ");
}

static void cb_Xcas_tortue_saute(Fl_Menu_*, void*) {
  input_0arg("saute ");
}

static void cb_Xcas_tortue_pas_de_cote(Fl_Menu_*, void*) {
  input_0arg("pas_de_cote ");
}

static void cb_Xcas_tortue_tourne_droite(Fl_Menu_*, void*) {
  input_0arg("tourne_droite ");
}

static void cb_Xcas_tortue_tourne_gauche(Fl_Menu_*, void*) {
  input_0arg("tourne_gauche ");
}

static void cb_Xcas_tortue_efface0(Fl_Menu_*, void*) {
  Picture->turtlezoom=1;Picture->turtlex=0;Picture->turtley=0;input_value("efface ;");
}

static void cb_Xcas_tortue_cap(Fl_Menu_*, void*) {
  input_0arg("cap ");
}

static void cb_Xcas_tortue_position(Fl_Menu_*, void*) {
  input_0arg("position ");
}

static void cb_Xcas_tortue_vers(Fl_Menu_*, void*) {
  input_1arg("vers",false,false);
}

static void cb_Xcas_tortue_rond(Fl_Menu_*, void*) {
  input_0arg("rond ");
}

static void cb_Xcas_tortue_disque(Fl_Menu_*, void*) {
  input_0arg("disque ");
}

static void cb_Xcas_tortue_rectangle_plein(Fl_Menu_*, void*) {
  input_0arg("rectangle_plein ");
}

static void cb_Xcas_tortue_triangle_plein(Fl_Menu_*, void*) {
  input_0arg("triangle_plein ");
}

static void cb_Xcas_tortue_polygone_rempli(Fl_Menu_*, void*) {
  input_0arg("polygone_rempli ");
}

static void cb_Xcas_tortue_dessine_tortue(Fl_Menu_*, void*) {
  input_0arg("dessine_tortue");
}

static void cb_Xcas_tortue_leve_crayon(Fl_Menu_*, void*) {
  input_0arg("leve_crayon ");
}

static void cb_Xcas_tortue_baisse_crayon(Fl_Menu_*, void*) {
  input_0arg("baisse_crayon ");
}

static void cb_Xcas_tortue_rouge(Fl_Menu_*, void*) {
  input_0arg("crayon rouge");
}

static void cb_Xcas_tortue_vert(Fl_Menu_*, void*) {
  input_0arg("crayon vert");
}

static void cb_Xcas_tortue_bleu(Fl_Menu_*, void*) {
  input_0arg("crayon bleu");
}

static void cb_Xcas_tortue_jaune(Fl_Menu_*, void*) {
  input_0arg("crayon jaune");
}

static void cb_Xcas_tortue_magenta(Fl_Menu_*, void*) {
  input_0arg("crayon magenta");
}

static void cb_Xcas_tortue_cyan(Fl_Menu_*, void*) {
  input_0arg("crayon cyan");
}

static void cb_Xcas_tortue_noir(Fl_Menu_*, void*) {
  input_0arg("crayon noir");
}

static void cb_Xcas_tortue_blanc(Fl_Menu_*, void*) {
  input_0arg("crayon blanc");
}

static void cb_Xcas_tortue_gomme(Fl_Menu_*, void*) {
  input_0arg("crayon gomme");
}

static void cb_Xcas_tortue_crayon(Fl_Menu_*, void*) {
  input_0arg("crayon ");
}

static void cb_Xcas_tortue_cache_tortue(Fl_Menu_*, void*) {
  input_0arg("cache_tortue");
}

static void cb_Xcas_tortue_montre_tortue(Fl_Menu_*, void*) {
  input_0arg("montre_tortue");
}

static void cb_Xcas_tortue_efface(Fl_Menu_*, void*) {
  Picture->turtlezoom=1;Picture->turtlex=0;Picture->turtley=0;input_value("efface ;");
}

static void cb_Xcas_tortue_repete(Fl_Menu_*, void*) {
  input_0arg("repete ");
}

static void cb_Xcas_tortue_si(Fl_Menu_*, void*) {
  input_0arg("si alors sinon fsi;");
}

static void cb_Xcas_tortue_pour(Fl_Menu_*, void*) {
  input_0arg("pour de jusque faire fpour");
}

static void cb_Xcas_tortue_tantque(Fl_Menu_*, void*) {
  input_0arg("tantque faire ftantque");
}

static void cb_Xcas_tortue_lis(Fl_Menu_*, void*) {
  input_0arg("lis ");
}

static void cb_Xcas_tortue_lis_phrase(Fl_Menu_*, void*) {
  input_0arg("lis_phrase ");
}

static void cb_Xcas_tortue_debut_enregistrement(Fl_Menu_*, void*) {
  input_value("debut_enregistrement ;");
}

static void cb_Xcas_tortue_fin_enregistrement(Fl_Menu_*, void*) {
  input_value("fin_enregistrement \"\";");
}

static void cb_Xcas_tortue_sauve(Fl_Menu_*, void*) {
  input_value("sauve \"\";");
}

static void cb_Xcas_tortue_ramene(Fl_Menu_*, void*) {
  input_value("ramene \"\";");
}

static void cb_Xcas_tortue_print(Fl_Menu_*, void*) {
  widget_print(Picture);
}

static void cb_Xcas_tortue_print_ps(Fl_Menu_*, void*) {
  widget_ps_print(Picture);
}

static void cb_Xcas_tortue_bonjour(Fl_Menu_*, void*) {
  manage_upper_window(upper_window_geo,false); Geo_buttons->hide(); Geo_buttons_tortue->show(); Xcas_turtle->value(1);  
Picture->turtlezoom=1;Picture->turtlex=0;Picture->turtley=0;
// input_value("angle_radian:=0;efface();"); input_eval(false);
}

static void cb_Xcas_tortue_aurevoir(Fl_Menu_*, void*) {
  Xcas_turtle->value(0); 
// input_value("angle_radian:=1;"); input_eval(false);
Geo_buttons->show(); Geo_buttons_tortue->hide();
}

static void cb_Xcas_Lycee_Seconde_Expand(Fl_Menu_*, void*) {
  input_1arg("expand",true,false);
}

static void cb_Xcas_Lycee_Seconde_Factor(Fl_Menu_*, void*) {
  input_1arg("factor",true,false);
}

static void cb_Xcas_Lycee_Seconde_Left(Fl_Menu_*, void*) {
  input_1arg("left",true,false);
}

static void cb_Xcas_Lycee_Seconde_Right(Fl_Menu_*, void*) {
  input_1arg("right",true,false);
}

static void cb_Xcas_Lycee_Seconde_Solve(Fl_Menu_*, void*) {
  input_1arg("solve",true,false);
}

static void cb_Xcas_Lycee_Seconde_Simplify(Fl_Menu_*, void*) {
  input_1arg("simplify",true,false);
}

static void cb_Xcas_Lycee_Seconde_Subst(Fl_Menu_*, void*) {
  input_1arg("subst",true,false);
}

static void cb_Xcas_Lycee_Seconde_Tablefunc(Fl_Menu_*, void*) {
  input_1arg("tablefunc",false,false);
}

static void cb_Xcas_Lycee_Seconde_Plotfunc(Fl_Menu_*, void*) {
  input_1arg("plotfunc",false,false);
}

static void cb_Xcas_Lycee_Premiere_Diff(Fl_Menu_*, void*) {
  input_1arg("diff",true,false);
}

static void cb_Xcas_Lycee_Seconde_Mult_conjugate(Fl_Menu_*, void*) {
  input_1arg("mult_conjugate",true,false);
}

static void cb_Xcas_Lycee_Premiere_Limit(Fl_Menu_*, void*) {
  input_1arg("limit",true,false);
}

static void cb_Xcas_Lycee_Premiere_Tangent(Fl_Menu_*, void*) {
  input_1arg("tangent",true,false);
}

static void cb_Xcas_Lycee_Premiere_Linetan(Fl_Menu_*, void*) {
  input_1arg("LineTan",true,false);
}

static void cb_Xcas_Lycee_Seconde_Tableseq(Fl_Menu_*, void*) {
  input_1arg("tableseq",false,false);
}

static void cb_Xcas_Lycee_Seconde_Plotseq(Fl_Menu_*, void*) {
  input_1arg("plotseq",false,false);
}

static void cb_Xcas_Lycee_Terminale_cFactor(Fl_Menu_*, void*) {
  input_1arg("cFactor",true,false);
}

static void cb_Xcas_Lycee_Terminale_Integrate(Fl_Menu_*, void*) {
  input_1arg("integrate",true,false);
}

static void cb_Xcas_Lycee_Terminale_Mult_c_conjugate(Fl_Menu_*, void*) {
  input_1arg("mult_c_conjugate",true,false);
}

static void cb_Xcas_Lycee_Terminale_cSolve(Fl_Menu_*, void*) {
  input_1arg("cSolve",true,false);
}

static void cb_Xcas_Lycee_Terminale_Plotparam(Fl_Menu_*, void*) {
  input_1arg("plotparam",false,false);
}

static void cb_Xcas_Lycee_Terminale_Plotpolar(Fl_Menu_*, void*) {
  input_1arg("plotpolar",false,false);
}

static void cb_Maths(Fl_Menu_*, void*) {
  redraw_mouse_position_only=false;
}

static void cb_Pi(Fl_Menu_*, void*) {
  input_0arg("pi");
}

static void cb_Constante_i(Fl_Menu_*, void*) {
  input_0arg(printi().c_str());
}

static void cb_Constante_e(Fl_Menu_*, void*) {
  input_0arg("exp(1)");
}

static void cb_Plus_infinity(Fl_Menu_*, void*) {
  input_0arg("+infinity");
}

static void cb_Minus_infinity(Fl_Menu_*, void*) {
  input_0arg("-infinity");
}

static void cb_Infinity(Fl_Menu_*, void*) {
  input_0arg("infinity");
}

static void cb_Euler(Fl_Menu_*, void*) {
  input_1arg("euler",false,false);
}

static void cb_Fracmod(Fl_Menu_*, void*) {
  input_1arg("fracmod",false,false);
}

static void cb_Gcd(Fl_Menu_*, void*) {
  input_1arg("gcd",false,false);
}

static void cb_Iabcuv(Fl_Menu_*, void*) {
  input_1arg("iabcuv",false,false);
}

static void cb_Ichinrem(Fl_Menu_*, void*) {
  input_1arg("ichinrem",false,false);
}

static void cb_Idivis(Fl_Menu_*, void*) {
  input_1arg("idivis",false,false);
}

static void cb_Iegcd(Fl_Menu_*, void*) {
  input_1arg("iegcd",false,false);
}

static void cb_Ifactor(Fl_Menu_*, void*) {
  input_1arg("ifactor",false,false);
}

static void cb_Ifactors(Fl_Menu_*, void*) {
  input_1arg("ifactors",false,false);
}

static void cb_Iquo(Fl_Menu_*, void*) {
  input_1arg("iquo",false,false);
}

static void cb_Iquorem(Fl_Menu_*, void*) {
  input_1arg("iquorem",false,false);
}

static void cb_Irem(Fl_Menu_*, void*) {
  input_1arg("irem",false,false);
}

static void cb_Is_prime(Fl_Menu_*, void*) {
  input_1arg("is_prime",false,false);
}

static void cb_Is_pseudoprime(Fl_Menu_*, void*) {
  input_1arg("is_pseudoprime",false,false);
}

static void cb_Lcm(Fl_Menu_*, void*) {
  input_1arg("lcm",false,false);
}

static void cb_Modulo(Fl_Menu_*, void*) {
  binary_op('%');
}

static void cb_Nextprime(Fl_Menu_*, void*) {
  input_1arg("nextprime",false,false);
}

static void cb_Pa2b2(Fl_Menu_*, void*) {
  input_1arg("pa2b2",false,false);
}

static void cb_Powmod(Fl_Menu_*, void*) {
  input_1arg("powmod",false,false);
}

static void cb_Prevprime(Fl_Menu_*, void*) {
  input_1arg("prevprime",false,false);
}

static void cb_Smod(Fl_Menu_*, void*) {
  input_1arg("smod",false,false);
}

static void cb_Abs(Fl_Menu_*, void*) {
  input_1arg("abs",false,false);
}

static void cb_Ceil(Fl_Menu_*, void*) {
  input_1arg("ceil",false,false);
}

static void cb_Factorial(Fl_Menu_*, void*) {
  input_1arg("factorial",false,false);
}

static void cb_Floor(Fl_Menu_*, void*) {
  input_1arg("floor",false,false);
}

static void cb_Frac(Fl_Menu_*, void*) {
  input_1arg("frac",false,false);
}

static void cb_Max(Fl_Menu_*, void*) {
  input_1arg("max",false,false);
}

static void cb_Min(Fl_Menu_*, void*) {
  input_1arg("min",false,false);
}

static void cb_Xcas_Round(Fl_Menu_*, void*) {
  input_1arg("round",false,false);
}

static void cb_Sign(Fl_Menu_*, void*) {
  input_1arg("sign",false,false);
}

static void cb_Real_part(Fl_Menu_*, void*) {
  input_1arg("re",false,false);
}

static void cb_Imaginary_part(Fl_Menu_*, void*) {
  input_1arg("im",false,false);
}

static void cb_Evalc_item(Fl_Menu_*, void*) {
  input_1arg("evalc",false,false);
}

static void cb_Conjugate(Fl_Menu_*, void*) {
  input_1arg("conj",false,false);
}

static void cb_Mult_c_conjugate(Fl_Menu_*, void*) {
  input_1arg("mult_c_conjugate",true,false);
}

static void cb_Complex_modulus(Fl_Menu_*, void*) {
  input_1arg("abs",false,false);
}

static void cb_Argument(Fl_Menu_*, void*) {
  input_1arg("arg",false,false);
}

static void cb_Alogarithm10(Fl_Menu_*, void*) {
  input_1arg("10^",false,false);
}

static void cb_Exponential(Fl_Menu_*, void*) {
  input_1arg("exp",false,false);
}

static void cb_Logarithm(Fl_Menu_*, void*) {
  input_1arg("log",false,false);
}

static void cb_Logarithm10(Fl_Menu_*, void*) {
  input_1arg("log10",false,false);
}

static void cb_Tanh(Fl_Menu_*, void*) {
  input_1arg("tanh",false,false);
}

static void cb_Sinh(Fl_Menu_*, void*) {
  input_1arg("sinh",false,false);
}

static void cb_Cosh(Fl_Menu_*, void*) {
  input_1arg("cosh",false,false);
}

static void cb_Argtanh(Fl_Menu_*, void*) {
  input_1arg("atanh",false,false);
}

static void cb_Argsinh(Fl_Menu_*, void*) {
  input_1arg("asinh",false,false);
}

static void cb_Argcosh(Fl_Menu_*, void*) {
  input_1arg("acosh",false,false);
}

static void cb_Arccos(Fl_Menu_*, void*) {
  input_1arg("acos",false,false);
}

static void cb_Arcsin(Fl_Menu_*, void*) {
  input_1arg("asin",false,false);
}

static void cb_Arctangent(Fl_Menu_*, void*) {
  input_1arg("atan",false,false);
}

static void cb_Cos(Fl_Menu_*, void*) {
  input_1arg("cos",false,false);
}

static void cb_Sin(Fl_Menu_*, void*) {
  input_1arg("sin",false,false);
}

static void cb_Tangent(Fl_Menu_*, void*) {
  input_1arg("tan",false,false);
}

static void cb_Arccot(Fl_Menu_*, void*) {
  input_1arg("acot",false,false);
}

static void cb_Arccsc(Fl_Menu_*, void*) {
  input_1arg("acsc",false,false);
}

static void cb_Arcsec(Fl_Menu_*, void*) {
  input_1arg("asec",false,false);
}

static void cb_Csc(Fl_Menu_*, void*) {
  input_1arg("csc",false,false);
}

static void cb_Sec(Fl_Menu_*, void*) {
  input_1arg("sec",false,false);
}

static void cb_Cotangent(Fl_Menu_*, void*) {
  input_1arg("cot",false,false);
}

static void cb_Collect(Fl_Menu_*, void*) {
  input_1arg("collect",true,false);
}

static void cb_Eval_item(Fl_Menu_*, void*) {
  input_1arg("eval",false,false);
}

static void cb_Equal2diff(Fl_Menu_*, void*) {
  input_1arg("equal2diff",true,false);
}

static void cb_F2nd(Fl_Menu_*, void*) {
  input_1arg("f2nd",true,false);
}

static void cb_Factor(Fl_Menu_*, void*) {
  input_1arg("factor",true,false);
}

static void cb_Mult_conjugate(Fl_Menu_*, void*) {
  input_1arg("mult_conjugate",true,false);
}

static void cb_Normal(Fl_Menu_*, void*) {
  input_1arg("normal",true,false);
}

static void cb_Ratnormal(Fl_Menu_*, void*) {
  input_1arg("ratnormal",true,false);
}

static void cb_Reorder(Fl_Menu_*, void*) {
  input_1arg("reorder",false,false);
}

static void cb_Partfrac(Fl_Menu_*, void*) {
  input_1arg("partfrac",true,false);
}

static void cb_simp2(Fl_Menu_*, void*) {
  input_1arg("simp2",false,false);
}

static void cb_Simplifier(Fl_Menu_*, void*) {
  input_1arg("simplifier",true,false);
}

static void cb_Simplify(Fl_Menu_*, void*) {
  input_1arg("simplify",true,false);
}

static void cb_Subst(Fl_Menu_*, void*) {
  input_1arg("subst",true,false);
}

static void cb_Exp2pow(Fl_Menu_*, void*) {
  input_1arg("exp2pow",true,false);
}

static void cb_Exp2trig(Fl_Menu_*, void*) {
  input_1arg("exp2trig",true,false);
}

static void cb_Hyp2exp(Fl_Menu_*, void*) {
  input_1arg("hyp2exp",true,false);
}

static void cb_Lin(Fl_Menu_*, void*) {
  input_1arg("lin",true,false);
}

static void cb_Lncollect(Fl_Menu_*, void*) {
  input_1arg("lncollect",true,false);
}

static void cb_Powexpand(Fl_Menu_*, void*) {
  input_1arg("powexpand",true,false);
}

static void cb_Trig2exp(Fl_Menu_*, void*) {
  input_1arg("trig2exp",true,false);
}

static void cb_Tsimplify(Fl_Menu_*, void*) {
  input_1arg("tsimplify",true,false);
}

static void cb_Acos2asin(Fl_Menu_*, void*) {
  input_1arg("acos2asin",true,false);
}

static void cb_Acos2atan(Fl_Menu_*, void*) {
  input_1arg("acos2atan",true,false);
}

static void cb_Asin2acos(Fl_Menu_*, void*) {
  input_1arg("asin2acos",true,false);
}

static void cb_Asin2atan(Fl_Menu_*, void*) {
  input_1arg("asin2atan",true,false);
}

static void cb_Atan2acos(Fl_Menu_*, void*) {
  input_1arg("atan2acos",true,false);
}

static void cb_Atan2asin(Fl_Menu_*, void*) {
  input_1arg("atan2asin",true,false);
}

static void cb_Halftan(Fl_Menu_*, void*) {
  input_1arg("halftan",true,false);
}

static void cb_Tan2sincos(Fl_Menu_*, void*) {
  input_1arg("tan2sincos",true,false);
}

static void cb_Tan2cossin2(Fl_Menu_*, void*) {
  input_1arg("tan2cossin2",true,false);
}

static void cb_Tan2sincos2(Fl_Menu_*, void*) {
  input_1arg("tan2sincos2",true,false);
}

static void cb_Tcollect(Fl_Menu_*, void*) {
  input_1arg("tcollect",true,false);
}

static void cb_Texpand2(Fl_Menu_*, void*) {
  input_1arg("texpand",true,false);
}

static void cb_Tlin2(Fl_Menu_*, void*) {
  input_1arg("tlin",true,false);
}

static void cb_Trigcos(Fl_Menu_*, void*) {
  input_1arg("trigcos",true,false);
}

static void cb_Trigsin(Fl_Menu_*, void*) {
  input_1arg("trigsin",true,false);
}

static void cb_Trigtan(Fl_Menu_*, void*) {
  input_1arg("trigtan",true,false);
}

static void cb_Binomial(Fl_Menu_*, void*) {
  input_1arg("binomial",false,false);
}

static void cb_Perm(Fl_Menu_*, void*) {
  input_1arg("perm",false,false);
}

static void cb_Rand(Fl_Menu_*, void*) {
  input_1arg("rand",false,false);
}

static void cb_Randnorm(Fl_Menu_*, void*) {
  input_1arg("randnorm",false,false);
}

static void cb_Center2interval(Fl_Menu_*, void*) {
  input_1arg("center2interval",false,false);
}

static void cb_Cumulated_frequencies(Fl_Menu_*, void*) {
  input_1arg("cumulated_frequencies",false,false);
}

static void cb_Histogram(Fl_Menu_*, void*) {
  input_1arg("histogram",false,false);
}

static void cb_Interval2center(Fl_Menu_*, void*) {
  input_1arg("interval2center",false,false);
}

static void cb_Mean(Fl_Menu_*, void*) {
  input_1arg("mean",false,false);
}

static void cb_Median(Fl_Menu_*, void*) {
  input_1arg("median",false,false);
}

static void cb_Moustache(Fl_Menu_*, void*) {
  input_1arg("moustache",false,false);
}

static void cb_Quartiles(Fl_Menu_*, void*) {
  input_1arg("quartiles",false,false);
}

static void cb_Quartile1(Fl_Menu_*, void*) {
  input_1arg("quartile1",false,false);
}

static void cb_Quartile3(Fl_Menu_*, void*) {
  input_1arg("quartile3",false,false);
}

static void cb_StatsSum(Fl_Menu_*, void*) {
  input_1arg("sum",false,false);
}

static void cb_Stddev(Fl_Menu_*, void*) {
  input_1arg("stddev",false,false);
}

static void cb_Variance(Fl_Menu_*, void*) {
  input_1arg("variance",false,false);
}

static void cb_Covariance(Fl_Menu_*, void*) {
  input_1arg("covariance",false,false);
}

static void cb_Correlation(Fl_Menu_*, void*) {
  input_1arg("correlation",false,false);
}

static void cb_Exponential_regression(Fl_Menu_*, void*) {
  input_1arg("exponential_regression",false,false);
}

static void cb_Linear_regression(Fl_Menu_*, void*) {
  input_1arg("linear_regression",false,false);
}

static void cb_Logarithmic_regression(Fl_Menu_*, void*) {
  input_1arg("logarithmic_regression",false,false);
}

static void cb_Polygonplot(Fl_Menu_*, void*) {
  input_1arg("polygonplot",false,false);
}

static void cb_Polynomial_regression(Fl_Menu_*, void*) {
  input_1arg("polynomial_regression",false,false);
}

static void cb_Power_regression(Fl_Menu_*, void*) {
  input_1arg("power_regression",false,false);
}

static void cb_Scatterplot(Fl_Menu_*, void*) {
  input_1arg("scatterplot",false,false);
}

static void cb_Binomial_distribution(Fl_Menu_*, void*) {
  input_1arg("binomial",false,false);
}

static void cb_Binomial_cdf_distribution(Fl_Menu_*, void*) {
  input_1arg("binomial_cdf",false,false);
}

static void cb_Binomial_icdf_distribution(Fl_Menu_*, void*) {
  input_1arg("binomial_icdf",false,false);
}

static void cb_Chisquare_distribution(Fl_Menu_*, void*) {
  input_1arg("chisquare",false,false);
}

static void cb_Chisquare_cdf_distribution(Fl_Menu_*, void*) {
  input_1arg("chisquare_cdf",false,false);
}

static void cb_Chisquare_icdf_distribution(Fl_Menu_*, void*) {
  input_1arg("chisquare_icdf",false,false);
}

static void cb_Fisher_distribution(Fl_Menu_*, void*) {
  input_1arg("fisher",false,false);
}

static void cb_Fisher_cdf_distribution(Fl_Menu_*, void*) {
  input_1arg("fisher_cdf",false,false);
}

static void cb_Fisher_icdf_distribution(Fl_Menu_*, void*) {
  input_1arg("fisher_icdf",false,false);
}

static void cb_Normald_distribution(Fl_Menu_*, void*) {
  input_1arg("normald",false,false);
}

static void cb_Normald_cdf_distribution(Fl_Menu_*, void*) {
  input_1arg("normald_cdf",false,false);
}

static void cb_Normald_icdf_distribution(Fl_Menu_*, void*) {
  input_1arg("normald_icdf",false,false);
}

static void cb_Poisson_distribution(Fl_Menu_*, void*) {
  input_1arg("poisson",false,false);
}

static void cb_Poisson_cdf_distribution(Fl_Menu_*, void*) {
  input_1arg("poisson_cdf",false,false);
}

static void cb_Poisson_icdf_distribution(Fl_Menu_*, void*) {
  input_1arg("poisson_icdf",false,false);
}

static void cb_Student_distribution(Fl_Menu_*, void*) {
  input_1arg("student",false,false);
}

static void cb_Student_cdf_distribution(Fl_Menu_*, void*) {
  input_1arg("student_cdf",false,false);
}

static void cb_Student_icdf_distribution(Fl_Menu_*, void*) {
  input_1arg("student_icdf",false,false);
}

static void cb_UTPC_distribution(Fl_Menu_*, void*) {
  input_1arg("UTPC",false,false);
}

static void cb_UTPF_distribution(Fl_Menu_*, void*) {
  input_1arg("UTPF",false,false);
}

static void cb_UTPN_distribution(Fl_Menu_*, void*) {
  input_1arg("UTPN",false,false);
}

static void cb_UTPT_distribution(Fl_Menu_*, void*) {
  input_1arg("UTPT",false,false);
}

static void cb_Plot_erase(Fl_Menu_*, void*) {
  input_0arg("erase"); PICTautoname="A";
}

static void cb_Plot_menub(Fl_Menu_*, void*) {
  input_1arg("plot",false,false);
}

static void cb_Plotcontour_menub(Fl_Menu_*, void*) {
  input_1arg("plotcontour",false,false);
}

static void cb_Plotfield_menub(Fl_Menu_*, void*) {
  input_1arg("plotfield",false,false);
}

static void cb_Plotfunc_menub(Fl_Menu_*, void*) {
  input_1arg("plotfunc",false,false);
}

static void cb_Plotimplicit_menub(Fl_Menu_*, void*) {
  input_1arg("plotimplicit",false,false);
}

static void cb_Interactive_Plotode_menub(Fl_Menu_*, void*) {
  input_1arg("interactive_odeplot",false,false);
}

static void cb_Plotode_menub(Fl_Menu_*, void*) {
  input_1arg("plotode",false,false);
}

static void cb_Plotparam_menub(Fl_Menu_*, void*) {
  input_1arg("plotparam",false,false);
}

static void cb_Plotpolar_menub(Fl_Menu_*, void*) {
  input_1arg("plotpolar",false,false);
}

static void cb_Plotseq_menub(Fl_Menu_*, void*) {
  input_1arg("plotseq",false,false);
}

static void cb_Plot_setup_menub(Fl_Menu_*, void*) {
  plot_setup();
}

static void cb_Plot_selection(Fl_Menu_*, void*) {
  string t(input->value());
    size_t sel1=input->position(),sel2=input->mark();
    if (sel1>sel2)
      std::swap<size_t>(sel1,sel2);
    string t_selected=t.substr(sel1,sel2-sel1);
    if (sel1==sel2)
      t_selected=t;
    gen e;
    try {
      e=gen(t_selected);
    }
    catch(std::runtime_error & err){
      Help_text->value(err.what());
      return;
    }
    manage_upper_window(upper_window_hist,false);
    input_value(gen(symbolic(at_plot,makevecteur(e,vx_var))).print().c_str());
    input_eval(false);
    input_value(t.c_str());
    // input_position(sel1,sel2);
}

static void cb_Graph2tex2(Fl_Menu_*, void*) {
  input_1arg("graph2tex",false,false);
}

static void cb_Graph3d2tex2(Fl_Menu_*, void*) {
  input_1arg("graph3d2tex",false,false);
}

static void cb_Plot_switch_axes(Fl_Menu_*, void*) {
  input_0arg("switch_axes");
}

static void cb_Vector_abs(Fl_Menu_*, void*) {
  input_1arg("abs",false,false);
}

static void cb_Cross(Fl_Menu_*, void*) {
  input_1arg("cross",false,false);
}

static void cb_Dot(Fl_Menu_*, void*) {
  input_1arg("dot",false,false);
}

static void cb_Vector_l2norm(Fl_Menu_*, void*) {
  input_1arg("l2norm",false,false);
}

static void cb_Vector_maxnorm(Fl_Menu_*, void*) {
  input_1arg("maxnorm",false,false);
}

static void cb_Geometrie(Fl_Menu_*, void*) {
  redraw_mouse_position_only=false;
}

static void cb_Xcas_Graph2tex(Fl_Menu_*, void*) {
  input_value("graph2tex()"); input_eval(false);
}

static void cb_Xcas_Graph3d2tex(Fl_Menu_*, void*) {
  input_value("graph3d2tex()");input_eval(false);
}

static void cb_Geo_ClrGraph(Fl_Menu_*, void*) {
  input_1arg("ClrGraph",false,false);
}

static void cb_Geo_erase(Fl_Menu_*, void*) {
  input_0arg("erase"); PICTautoname="A";
}

static void cb_Geo_erase3d(Fl_Menu_*, void*) {
  input_1arg("erase3d",false,false);
}

static void cb_Geo_couleur(Fl_Menu_*, void*) {
  input_1arg("couleur",false,false);
}

static void cb_Geo_legende(Fl_Menu_*, void*) {
  input_1arg("legende",false,false);
}

static void cb_Geo_switch_axes(Fl_Menu_*, void*) {
  input_1arg("switch_axes",false,false);
}

static void cb_Geo_barycentre(Fl_Menu_*, void*) {
  input_1arg("barycentre",false,false);
}

static void cb_Geo_centre(Fl_Menu_*, void*) {
  input_1arg("centre",false,false);
}

static void cb_Geo_element(Fl_Menu_*, void*) {
  input_1arg("element",false,false);
}

static void cb_Geo_inter(Fl_Menu_*, void*) {
  input_1arg("inter",false,false);
}

static void cb_Geo_isobarycentre(Fl_Menu_*, void*) {
  input_1arg("isobarycentre",false,false);
}

static void cb_Geo_milieu(Fl_Menu_*, void*) {
  input_1arg("milieu",false,false);
}

static void cb_Geo_point(Fl_Menu_*, void*) {
  input_1arg("point",false,false);
}

static void cb_Geo_point2d(Fl_Menu_*, void*) {
  input_1arg("point2d",false,false);
}

static void cb_Geo_point3d(Fl_Menu_*, void*) {
  input_1arg("point3d",false,false);
}

static void cb_Geo_sommets(Fl_Menu_*, void*) {
  input_1arg("sommets",false,false);
}

static void cb_Geo_aretes(Fl_Menu_*, void*) {
  input_1arg("aretes",false,false);
}

static void cb_Geo_bissectrice(Fl_Menu_*, void*) {
  input_1arg("bissectrice",false,false);
}

static void cb_Geo_demi_droite(Fl_Menu_*, void*) {
  input_1arg("demi_droite",false,false);
}

static void cb_Geo_droite(Fl_Menu_*, void*) {
  input_1arg("droite",false,false);
}

static void cb_Geo_enveloppe(Fl_Menu_*, void*) {
  input_1arg("enveloppe",false,false);
}

static void cb_Geo_exbissectrice(Fl_Menu_*, void*) {
  input_1arg("exbissectrice",false,false);
}

static void cb_Geo_hauteur(Fl_Menu_*, void*) {
  input_1arg("hauteur",false,false);
}

static void cb_Geo_lieu(Fl_Menu_*, void*) {
  input_1arg("lieu",false,false);
}

static void cb_Geo_LineTan(Fl_Menu_*, void*) {
  input_1arg("LineTan",false,false);
}

static void cb_Geo_mediane(Fl_Menu_*, void*) {
  input_1arg("mediane",false,false);
}

static void cb_Geo_mediatrice(Fl_Menu_*, void*) {
  input_1arg("mediatrice",false,false);
}

static void cb_Geo_parallele(Fl_Menu_*, void*) {
  input_1arg("parallele",false,false);
}

static void cb_Geo_perpendiculaire(Fl_Menu_*, void*) {
  input_1arg("perpendiculaire",false,false);
}

static void cb_Geo_perpendiculaire_commune(Fl_Menu_*, void*) {
  input_1arg("perpendiculaire_commune",false,false);
}

static void cb_Geo_segment(Fl_Menu_*, void*) {
  input_1arg("segment",false,false);
}

static void cb_Geo_tangent(Fl_Menu_*, void*) {
  input_1arg("tangent",false,false);
}

static void cb_Geo_funcplot(Fl_Menu_*, void*) {
  input_1arg("funcplot",false,false);
}

static void cb_Geo_paramplot(Fl_Menu_*, void*) {
  input_1arg("paramplot",false,false);
}

static void cb_Geo_triangle(Fl_Menu_*, void*) {
  input_1arg("triangle",false,false);
}

static void cb_Geo_triangle_equilateral(Fl_Menu_*, void*) {
  input_1arg("triangle_equilateral",false,false);
}

static void cb_Geo_triangle_isocele(Fl_Menu_*, void*) {
  input_1arg("triangle_isocele",false,false);
}

static void cb_Geo_triangle_rectangle(Fl_Menu_*, void*) {
  input_1arg("triangle_rectangle",false,false);
}

static void cb_Geo_carre(Fl_Menu_*, void*) {
  input_1arg("carre",false,false);
}

static void cb_Geo_losange(Fl_Menu_*, void*) {
  input_1arg("losange",false,false);
}

static void cb_Geo_parallelogramme(Fl_Menu_*, void*) {
  input_1arg("parallelogramme",false,false);
}

static void cb_Geo_quadrilatere(Fl_Menu_*, void*) {
  input_1arg("quadrilatere",false,false);
}

static void cb_Geo_rectangle(Fl_Menu_*, void*) {
  input_1arg("rectangle",false,false);
}

static void cb_Geo_isopolygone(Fl_Menu_*, void*) {
  input_1arg("isopolygone",false,false);
}

static void cb_Geo_polygone(Fl_Menu_*, void*) {
  input_1arg("polygone",false,false);
}

static void cb_Geo_arc(Fl_Menu_*, void*) {
  input_1arg("arc",false,false);
}

static void cb_Geo_cercle(Fl_Menu_*, void*) {
  input_1arg("cercle",false,false);
}

static void cb_Geo_circonscrit(Fl_Menu_*, void*) {
  input_1arg("circonscrit",false,false);
}

static void cb_Geo_exinscrit(Fl_Menu_*, void*) {
  input_1arg("exinscrit",false,false);
}

static void cb_Geo_inscrit(Fl_Menu_*, void*) {
  input_1arg("inscrit",false,false);
}

static void cb_Geo_cercle2(Fl_Menu_*, void*) {
  input_1arg("cercle",false,false);
}

static void cb_Geo_ellipse(Fl_Menu_*, void*) {
  input_1arg("ellipse",false,false);
}

static void cb_Geo_hyperbole(Fl_Menu_*, void*) {
  input_1arg("hyperbole",false,false);
}

static void cb_Geo_parabole(Fl_Menu_*, void*) {
  input_1arg("parabole",false,false);
}

static void cb_Xcas_geo_cone(Fl_Menu_*, void*) {
  input_1arg("cone",false,false);
}

static void cb_Xcas_geo_cylindre(Fl_Menu_*, void*) {
  input_1arg("cylindre",false,false);
}

static void cb_Xcas_geo_demi_cone(Fl_Menu_*, void*) {
  input_1arg("demi_cone",false,false);
}

static void cb_Xcas_geo_plan(Fl_Menu_*, void*) {
  input_1arg("plan",false,false);
}

static void cb_Xcas_geo_sphere(Fl_Menu_*, void*) {
  input_1arg("sphere",false,false);
}

static void cb_Xcas_geo_funcplot(Fl_Menu_*, void*) {
  input_1arg("funcplot",false,false);
}

static void cb_Xcas_geo_paramplot(Fl_Menu_*, void*) {
  input_1arg("paramplot",false,false);
}

static void cb_Xcas_geo_mediatrice(Fl_Menu_*, void*) {
  input_1arg("mediatrice",false,false);
}

static void cb_Xcas_geo_tangent(Fl_Menu_*, void*) {
  input_1arg("tangent",false,false);
}

static void cb_Xcas_geo_cube2(Fl_Menu_*, void*) {
  input_1arg("cube",false,false);
}

static void cb_Xcas_geo_pyramide(Fl_Menu_*, void*) {
  input_1arg("pyramide",false,false);
}

static void cb_Xcas_geo_parallelepipede(Fl_Menu_*, void*) {
  input_1arg("parallelepipede",false,false);
}

static void cb_Xcas_geo_polyedre(Fl_Menu_*, void*) {
  input_1arg("polyedre",false,false);
}

static void cb_Xcas_geo_tetraedre_centre(Fl_Menu_*, void*) {
  input_1arg("tetraedre_centre",false,false);
}

static void cb_Xcas_geo_cube_centre(Fl_Menu_*, void*) {
  input_1arg("cube_centre",false,false);
}

static void cb_Xcas_geo_octaedre(Fl_Menu_*, void*) {
  input_1arg("octaedre",false,false);
}

static void cb_Xcas_geo_dodecaedre(Fl_Menu_*, void*) {
  input_1arg("dodecaedre",false,false);
}

static void cb_Xcas_geo_icosaedre(Fl_Menu_*, void*) {
  input_1arg("icosaedre",false,false);
}

static void cb_Geo_abs(Fl_Menu_*, void*) {
  input_1arg("abs",false,false);
}

static void cb_Geo_abscisse(Fl_Menu_*, void*) {
  input_1arg("abscisse",false,false);
}

static void cb_Geo_affixe(Fl_Menu_*, void*) {
  input_1arg("affixe",false,false);
}

static void cb_Geo_aire(Fl_Menu_*, void*) {
  input_1arg("aire",false,false);
}

static void cb_Geo_angle(Fl_Menu_*, void*) {
  input_1arg("angle",false,false);
}

static void cb_Geo_arg(Fl_Menu_*, void*) {
  input_1arg("arg",false,false);
}

static void cb_Geo_cote(Fl_Menu_*, void*) {
  input_1arg("cote",false,false);
}

static void cb_Geo_coordonnees(Fl_Menu_*, void*) {
  input_1arg("coordonnees",false,false);
}

static void cb_Geo_equation(Fl_Menu_*, void*) {
  input_1arg("equation",false,false);
}

static void cb_Geo_longueur(Fl_Menu_*, void*) {
  input_1arg("longueur",false,false);
}

static void cb_Geo_longueur2(Fl_Menu_*, void*) {
  input_1arg("longueur2",false,false);
}

static void cb_Geo_ordonnee(Fl_Menu_*, void*) {
  input_1arg("ordonnee",false,false);
}

static void cb_Geo_parameq(Fl_Menu_*, void*) {
  input_1arg("parameq",false,false);
}

static void cb_Geo_rayon(Fl_Menu_*, void*) {
  input_1arg("rayon",false,false);
}

static void cb_Geo_scalar_product(Fl_Menu_*, void*) {
  input_1arg("scalar_product",false,false);
}

static void cb_Geo_homothetie(Fl_Menu_*, void*) {
  input_1arg("homothetie",false,false);
}

static void cb_Geo_inversion(Fl_Menu_*, void*) {
  input_1arg("inversion",false,false);
}

static void cb_Geo_projection(Fl_Menu_*, void*) {
  input_1arg("projection",false,false);
}

static void cb_Geo_rotation(Fl_Menu_*, void*) {
  input_1arg("rotation",false,false);
}

static void cb_Geo_similitude(Fl_Menu_*, void*) {
  input_1arg("similitude",false,false);
}

static void cb_Geo_symetrie(Fl_Menu_*, void*) {
  input_1arg("symetrie",false,false);
}

static void cb_Geo_translation(Fl_Menu_*, void*) {
  input_1arg("translation",false,false);
}

static void cb_Geo_est_aligne(Fl_Menu_*, void*) {
  input_1arg("est_aligne",false,false);
}

static void cb_Geo_est_cocyclique(Fl_Menu_*, void*) {
  input_1arg("est_cocyclique",false,false);
}

static void cb_Geo_est_coplanaire(Fl_Menu_*, void*) {
  input_1arg("est_coplanaire",false,false);
}

static void cb_Geo_est_element(Fl_Menu_*, void*) {
  input_1arg("est_element",false,false);
}

static void cb_Geo_est_parallele(Fl_Menu_*, void*) {
  input_1arg("est_parallele",false,false);
}

static void cb_Geo_est_perpendiculaire(Fl_Menu_*, void*) {
  input_1arg("est_perpendiculaire",false,false);
}

static void cb_Geo_est_equilateral(Fl_Menu_*, void*) {
  input_1arg("est_equilateral",false,false);
}

static void cb_Geo_est_isocele(Fl_Menu_*, void*) {
  input_1arg("est_isocele",false,false);
}

static void cb_Geo_est_rectangle(Fl_Menu_*, void*) {
  input_1arg("est_rectangle",false,false);
}

static void cb_Geo_est_carre(Fl_Menu_*, void*) {
  input_1arg("est_carre",false,false);
}

static void cb_Geo_est_losange(Fl_Menu_*, void*) {
  input_1arg("est_losange",false,false);
}

static void cb_Geo_est_parallelogramme(Fl_Menu_*, void*) {
  input_1arg("est_parallelogramme",false,false);
}

static void cb_Geo_est_conjugue(Fl_Menu_*, void*) {
  input_1arg("est_conjugue",false,false);
}

static void cb_Geo_est_faisceau_cercle(Fl_Menu_*, void*) {
  input_1arg("est_faisceau_cercle",false,false);
}

static void cb_Geo_est_faisceau_droite(Fl_Menu_*, void*) {
  input_1arg("est_faisceau_droite",false,false);
}

static void cb_Geo_axe_radical(Fl_Menu_*, void*) {
  input_1arg("axe_radical",false,false);
}

static void cb_Geo_birapport(Fl_Menu_*, void*) {
  input_1arg("birapport",false,false);
}

static void cb_Geo_pole(Fl_Menu_*, void*) {
  input_1arg("pole",false,false);
}

static void cb_Geo_polaire(Fl_Menu_*, void*) {
  input_1arg("polaire",false,false);
}

static void cb_Geo_polaire_reciproque(Fl_Menu_*, void*) {
  input_1arg("polaire_reciproque",false,false);
}

static void cb_Geo_conj_harmonique(Fl_Menu_*, void*) {
  input_1arg("conj_harmonique",false,false);
}

static void cb_Geo_div_harmonique(Fl_Menu_*, void*) {
  input_1arg("div_harmonique",false,false);
}

static void cb_Geo_point_div(Fl_Menu_*, void*) {
  input_1arg("point_div",false,false);
}

static void cb_Geo_puissance(Fl_Menu_*, void*) {
  input_1arg("puissance",false,false);
}

static void cb_Constant_G(Fl_Menu_*, void*) {
  input_0arg("_G_");
}

static void cb_Constant_NA(Fl_Menu_*, void*) {
  input_0arg("_NA_");
}

static void cb_Constant_Rydberg(Fl_Menu_*, void*) {
  input_0arg("_R_");
}

static void cb_Constant_Vm(Fl_Menu_*, void*) {
  input_0arg("_Vm_");
}

static void cb_Constant_StdP(Fl_Menu_*, void*) {
  input_0arg("_StdP_");
}

static void cb_Constant_StdT(Fl_Menu_*, void*) {
  input_0arg("_StdT_");
}

static void cb_Constant_alpha(Fl_Menu_*, void*) {
  input_0arg("_alpha_");
}

static void cb_Constant_c(Fl_Menu_*, void*) {
  input_0arg("_c_");
}

static void cb_Constant_epsilon0(Fl_Menu_*, void*) {
  input_0arg("_epsilon0_");
}

static void cb_Constant_F(Fl_Menu_*, void*) {
  input_0arg("_F_");
}

static void cb_Constant_g(Fl_Menu_*, void*) {
  input_0arg("_g_");
}

static void cb_Constant_h(Fl_Menu_*, void*) {
  input_0arg("_h_");
}

static void cb_Constant_hbar(Fl_Menu_*, void*) {
  input_0arg("_hbar_");
}

static void cb_Constant_kB(Fl_Menu_*, void*) {
  input_0arg("_k_");
}

static void cb_Constant_me(Fl_Menu_*, void*) {
  input_0arg("_me_");
}

static void cb_Constant_mp(Fl_Menu_*, void*) {
  input_0arg("_mp_");
}

static void cb_Constant_mpme(Fl_Menu_*, void*) {
  input_0arg("_mpme_");
}

static void cb_Constant_phi(Fl_Menu_*, void*) {
  input_0arg("_phi_");
}

static void cb_Constant_q(Fl_Menu_*, void*) {
  input_0arg("_q_");
}

static void cb_Constant_qme(Fl_Menu_*, void*) {
  input_0arg("_qme_");
}

static void cb_Constant_sigma(Fl_Menu_*, void*) {
  input_0arg("_sigma_");
}

static void cb_Unit_mksa(Fl_Menu_*, void*) {
  input_1arg("mksa",false,false);
}

static void cb_Unit_convert(Fl_Menu_*, void*) {
  input_1arg("convert",false,false);
}

static void cb_Unit_ufactor(Fl_Menu_*, void*) {
  input_1arg("ufactor",false,false);
}

static void cb_Unit_usimplify(Fl_Menu_*, void*) {
  input_1arg("usimplify",false,false);
}

static void cb_Unit_Y(Fl_Menu_*, void*) {
  input_char('Y');
}

static void cb_Unit_Z(Fl_Menu_*, void*) {
  input_char('Z');
}

static void cb_Unit_E(Fl_Menu_*, void*) {
  input_char('E');
}

static void cb_Unit_Peta(Fl_Menu_*, void*) {
  input_char('P');
}

static void cb_Unit_Tera(Fl_Menu_*, void*) {
  input_char('T');
}

static void cb_Unit_Giga(Fl_Menu_*, void*) {
  input_char('G');
}

static void cb_Unit_Mega(Fl_Menu_*, void*) {
  input_char('M');
}

static void cb_Unit_Kilo(Fl_Menu_*, void*) {
  input_char('k');
}

static void cb_Unit_Hecto(Fl_Menu_*, void*) {
  input_char('h');
}

static void cb_Unit_Deca(Fl_Menu_*, void*) {
  input_char('D');
}

static void cb_Unit_Deci(Fl_Menu_*, void*) {
  input_char('d');
}

static void cb_Unit_Centi(Fl_Menu_*, void*) {
  input_char('c');
}

static void cb_Unit_Milli(Fl_Menu_*, void*) {
  input_char('m');
}

static void cb_Unit_Micro(Fl_Menu_*, void*) {
  input_char('');
}

static void cb_Unit_Nano(Fl_Menu_*, void*) {
  input_char('n');
}

static void cb_Unit_Pico(Fl_Menu_*, void*) {
  input_char('p');
}

static void cb_Unit_Femto(Fl_Menu_*, void*) {
  input_char('f');
}

static void cb_Unit_ato(Fl_Menu_*, void*) {
  input_char('a');
}

static void cb_Unit_z(Fl_Menu_*, void*) {
  input_char('z');
}

static void cb_Unit_y(Fl_Menu_*, void*) {
  input_char('y');
}

static void cb_Unit_m(Fl_Menu_*, void*) {
  input_0arg("_m");
}

static void cb_Unit_cm(Fl_Menu_*, void*) {
  input_0arg("_cm");
}

static void cb_Unit_mm(Fl_Menu_*, void*) {
  input_0arg("_mm");
}

static void cb_Unit_km(Fl_Menu_*, void*) {
  input_0arg("_km");
}

static void cb_Unit_au(Fl_Menu_*, void*) {
  input_0arg("_au");
}

static void cb_Unit_lyr(Fl_Menu_*, void*) {
  input_0arg("_lyr");
}

static void cb_Unit_pc(Fl_Menu_*, void*) {
  input_0arg("_pc");
}

static void cb_Unit_Angstrom(Fl_Menu_*, void*) {
  input_0arg("_Angstrom");
}

static void cb_Unit_chain(Fl_Menu_*, void*) {
  input_0arg("_chain");
}

static void cb_Unit_fath(Fl_Menu_*, void*) {
  input_0arg("_fath");
}

static void cb_Unit_fm(Fl_Menu_*, void*) {
  input_0arg("_fm");
}

static void cb_Unit_fermi(Fl_Menu_*, void*) {
  input_0arg("_fermi");
}

static void cb_Unit_yd(Fl_Menu_*, void*) {
  input_0arg("_yd");
}

static void cb_Unit_ft(Fl_Menu_*, void*) {
  input_0arg("_ft");
}

static void cb_Unit_ftUS(Fl_Menu_*, void*) {
  input_0arg("_ftUS");
}

static void cb_Unit_in(Fl_Menu_*, void*) {
  input_0arg("_in");
}

static void cb_Unit_mi(Fl_Menu_*, void*) {
  input_0arg("_mi");
}

static void cb_Unit_mile(Fl_Menu_*, void*) {
  input_0arg("_mile");
}

static void cb_Unit_mille(Fl_Menu_*, void*) {
  input_0arg("_mille");
}

static void cb_Unit_miUS(Fl_Menu_*, void*) {
  input_0arg("_miUS");
}

static void cb_Unit_mil(Fl_Menu_*, void*) {
  input_0arg("_mil");
}

static void cb_Unit_nmi(Fl_Menu_*, void*) {
  input_0arg("_nmi");
}

static void cb_Unit_rod(Fl_Menu_*, void*) {
  input_0arg("_rod");
}

static void cb_Unit_m2(Fl_Menu_*, void*) {
  input_0arg("_m^2");
}

static void cb_Unit_km2(Fl_Menu_*, void*) {
  input_0arg("_km^2");
}

static void cb_Unit_cm2(Fl_Menu_*, void*) {
  input_0arg("_cm^2");
}

static void cb_Unit_ha(Fl_Menu_*, void*) {
  input_0arg("_ha");
}

static void cb_Unit_a(Fl_Menu_*, void*) {
  input_0arg("_a");
}

static void cb_Unit_acre(Fl_Menu_*, void*) {
  input_0arg("_acre");
}

static void cb_Unit_b(Fl_Menu_*, void*) {
  input_0arg("_b");
}

static void cb_Unit_yd2(Fl_Menu_*, void*) {
  input_0arg("_yd^2");
}

static void cb_Unit_ft2(Fl_Menu_*, void*) {
  input_0arg("_ft^2");
}

static void cb_Unit_in2(Fl_Menu_*, void*) {
  input_0arg("_in^2");
}

static void cb_Unit_mi2(Fl_Menu_*, void*) {
  input_0arg("_mi^2");
}

static void cb_Unit_miUS2(Fl_Menu_*, void*) {
  input_0arg("_miUS^2");
}

static void cb_Unit_m3(Fl_Menu_*, void*) {
  input_0arg("_m^3");
}

static void cb_Unit_cm3(Fl_Menu_*, void*) {
  input_0arg("_cm^3");
}

static void cb_Unit_l(Fl_Menu_*, void*) {
  input_0arg("_l");
}

static void cb_Unit_ml(Fl_Menu_*, void*) {
  input_0arg("_ml");
}

static void cb_Unit_st(Fl_Menu_*, void*) {
  input_0arg("_st");
}

static void cb_Unit_yd3(Fl_Menu_*, void*) {
  input_0arg("_yd^3");
}

static void cb_Unit_ft3(Fl_Menu_*, void*) {
  input_0arg("_ft^3");
}

static void cb_Unit_in3(Fl_Menu_*, void*) {
  input_0arg("_in^3");
}

static void cb_Unit_bbl(Fl_Menu_*, void*) {
  input_0arg("_bbl");
}

static void cb_Unit_bu(Fl_Menu_*, void*) {
  input_0arg("_bu");
}

static void cb_Unit_buUS(Fl_Menu_*, void*) {
  input_0arg("_buUS");
}

static void cb_Unit_cu(Fl_Menu_*, void*) {
  input_0arg("_cu");
}

static void cb_Unit_fbm(Fl_Menu_*, void*) {
  input_0arg("_fbm");
}

static void cb_Unit_ozfl(Fl_Menu_*, void*) {
  input_0arg("_ozfl");
}

static void cb_Unit_ozUK(Fl_Menu_*, void*) {
  input_0arg("_ozUK");
}

static void cb_Unit_tbsp(Fl_Menu_*, void*) {
  input_0arg("_tbsp");
}

static void cb_Unit_tsp(Fl_Menu_*, void*) {
  input_0arg("_tsp");
}

static void cb_Unit_qt(Fl_Menu_*, void*) {
  input_0arg("_qt");
}

static void cb_Unit_liqpt(Fl_Menu_*, void*) {
  input_0arg("_liqpt");
}

static void cb_Unit_ptUK(Fl_Menu_*, void*) {
  input_0arg("_ptUK");
}

static void cb_Unit_pk(Fl_Menu_*, void*) {
  input_0arg("_pk");
}

static void cb_Unit_galUS(Fl_Menu_*, void*) {
  input_0arg("_galUS");
}

static void cb_Unit_galC(Fl_Menu_*, void*) {
  input_0arg("_galC");
}

static void cb_Unit_galUK(Fl_Menu_*, void*) {
  input_0arg("_galUK");
}

static void cb_Unit_s(Fl_Menu_*, void*) {
  input_0arg("_s");
}

static void cb_Unit_min(Fl_Menu_*, void*) {
  input_0arg("_min");
}

static void cb_Unit_h(Fl_Menu_*, void*) {
  input_0arg("_h");
}

static void cb_Unit_d(Fl_Menu_*, void*) {
  input_0arg("_d");
}

static void cb_Unit_yr(Fl_Menu_*, void*) {
  input_0arg("_yr");
}

static void cb_Unit_Hz(Fl_Menu_*, void*) {
  input_0arg("_Hz");
}

static void cb_Unit_MHz(Fl_Menu_*, void*) {
  input_0arg("_MHz");
}

static void cb_Unit_m_s(Fl_Menu_*, void*) {
  input_0arg("_(m/s)");
}

static void cb_Unit_cm_s(Fl_Menu_*, void*) {
  input_0arg("_(cm/s)");
}

static void cb_Unit_ft_s(Fl_Menu_*, void*) {
  input_0arg("_(ft/s)");
}

static void cb_Unit_kph(Fl_Menu_*, void*) {
  input_0arg("_kph");
}

static void cb_Unit_kmh(Fl_Menu_*, void*) {
  input_0arg("_(km/h)");
}

static void cb_Unit_mph(Fl_Menu_*, void*) {
  input_0arg("_mph");
}

static void cb_Unit_knot(Fl_Menu_*, void*) {
  input_0arg("_knot");
}

static void cb_Unit_rs(Fl_Menu_*, void*) {
  input_0arg("_(rad/s)");
}

static void cb_Unit_trmin(Fl_Menu_*, void*) {
  input_0arg("_(tr/min)");
}

static void cb_Unit_trs(Fl_Menu_*, void*) {
  input_0arg("_(tr/s)");
}

static void cb_Unit_kg(Fl_Menu_*, void*) {
  input_0arg("_kg");
}

static void cb_Unit_g(Fl_Menu_*, void*) {
  input_0arg("_g");
}

static void cb_Unit_grain(Fl_Menu_*, void*) {
  input_0arg("_grain");
}

static void cb_Unit_lb(Fl_Menu_*, void*) {
  input_0arg("_lb");
}

static void cb_Unit_lbt(Fl_Menu_*, void*) {
  input_0arg("_lbt");
}

static void cb_Unit_oz(Fl_Menu_*, void*) {
  input_0arg("_oz");
}

static void cb_Unit_ozt(Fl_Menu_*, void*) {
  input_0arg("_ozt");
}

static void cb_Unit_slug(Fl_Menu_*, void*) {
  input_0arg("_slug");
}

static void cb_Unit_ton(Fl_Menu_*, void*) {
  input_0arg("_ton");
}

static void cb_Unit_tonUK(Fl_Menu_*, void*) {
  input_0arg("_tonUK");
}

static void cb_Unit_u(Fl_Menu_*, void*) {
  input_0arg("_u");
}

static void cb_Unit_t(Fl_Menu_*, void*) {
  input_0arg("_t");
}

static void cb_Unit_ct(Fl_Menu_*, void*) {
  input_0arg("_ct");
}

static void cb_Unit_mol(Fl_Menu_*, void*) {
  input_0arg("_mol");
}

static void cb_Unit_m_s2(Fl_Menu_*, void*) {
  input_0arg("_(m/s^2)");
}

static void cb_Unit_Gal(Fl_Menu_*, void*) {
  input_0arg("_Gal");
}

static void cb_Unit_r_s2(Fl_Menu_*, void*) {
  input_0arg("_(rad/s^2)");
}

static void cb_Unit_kg_m_s2(Fl_Menu_*, void*) {
  input_0arg("_(kg*m/s^2)");
}

static void cb_Unit_N(Fl_Menu_*, void*) {
  input_0arg("_N");
}

static void cb_Unit_dyn(Fl_Menu_*, void*) {
  input_0arg("_dyn");
}

static void cb_Unit_kip(Fl_Menu_*, void*) {
  input_0arg("_kip");
}

static void cb_Unit_gf(Fl_Menu_*, void*) {
  input_0arg("_gf");
}

static void cb_Unit_lbf(Fl_Menu_*, void*) {
  input_0arg("_lbf");
}

static void cb_Unit_pdl(Fl_Menu_*, void*) {
  input_0arg("_pdl");
}

static void cb_Unit_kg_m2_s2(Fl_Menu_*, void*) {
  input_0arg("_(kg*m^2/s^2)");
}

static void cb_Unit_J(Fl_Menu_*, void*) {
  input_0arg("_J");
}

static void cb_Unit_Wh(Fl_Menu_*, void*) {
  input_0arg("_Wh");
}

static void cb_Unit_kWh(Fl_Menu_*, void*) {
  input_0arg("_kWh");
}

static void cb_Unit_Kcal(Fl_Menu_*, void*) {
  input_0arg("_Kcal");
}

static void cb_Unit_cal(Fl_Menu_*, void*) {
  input_0arg("_cal");
}

static void cb_Unit_eV(Fl_Menu_*, void*) {
  input_0arg("_eV");
}

static void cb_Unit_MeV(Fl_Menu_*, void*) {
  input_0arg("_MeV");
}

static void cb_Unit_Btu(Fl_Menu_*, void*) {
  input_0arg("_Btu");
}

static void cb_Unit_erg(Fl_Menu_*, void*) {
  input_0arg("_erg");
}

static void cb_Unit_ftxlb(Fl_Menu_*, void*) {
  input_0arg("_(ft*lb)");
}

static void cb_Unit_therm(Fl_Menu_*, void*) {
  input_0arg("_therm");
}

static void cb_Unit_tep(Fl_Menu_*, void*) {
  input_0arg("_tep");
}

static void cb_Unit_toe(Fl_Menu_*, void*) {
  input_0arg("_toe");
}

static void cb_Unit_tec(Fl_Menu_*, void*) {
  input_0arg("_tec");
}

static void cb_Unit_lep(Fl_Menu_*, void*) {
  input_0arg("_lep");
}

static void cb_Unit_bblep(Fl_Menu_*, void*) {
  input_0arg("_bblep");
}

static void cb_Unit_boe(Fl_Menu_*, void*) {
  input_0arg("_boe");
}

static void cb_Unit_cf(Fl_Menu_*, void*) {
  input_0arg("_cf");
}

static void cb_Unit_kg_m_s3(Fl_Menu_*, void*) {
  input_0arg("_(kg*m/s^3)");
}

static void cb_Unit_W(Fl_Menu_*, void*) {
  input_0arg("_W");
}

static void cb_Unit_MW(Fl_Menu_*, void*) {
  input_0arg("_MW");
}

static void cb_Unit_hp(Fl_Menu_*, void*) {
  input_0arg("_hp");
}

static void cb_Unit_kg_m1_s2(Fl_Menu_*, void*) {
  input_0arg("_(kg/m/s^2)");
}

static void cb_Unit_Pa(Fl_Menu_*, void*) {
  input_0arg("_Pa");
}

static void cb_Unit_bar(Fl_Menu_*, void*) {
  input_0arg("_bar");
}

static void cb_Unit_atm(Fl_Menu_*, void*) {
  input_0arg("_atm");
}

static void cb_Unit_psi(Fl_Menu_*, void*) {
  input_0arg("_psi");
}

static void cb_Unit_torr(Fl_Menu_*, void*) {
  input_0arg("_torr");
}

static void cb_Unit_mmHg(Fl_Menu_*, void*) {
  input_0arg("_mmHg");
}

static void cb_Unit_inHg(Fl_Menu_*, void*) {
  input_0arg("_ inHg");
}

static void cb_Unit_inH2O(Fl_Menu_*, void*) {
  input_0arg("_ inH2O");
}

static void cb_Unit_K(Fl_Menu_*, void*) {
  input_0arg("_K");
}

static void cb_Unit_Rankine(Fl_Menu_*, void*) {
  input_0arg("_Rankine");
}

static void cb_Unit_A(Fl_Menu_*, void*) {
  input_0arg("_A");
}

static void cb_Unit_V(Fl_Menu_*, void*) {
  input_0arg("_V");
}

static void cb_Unit_C(Fl_Menu_*, void*) {
  input_0arg("_C");
}

static void cb_Unit_Ohm(Fl_Menu_*, void*) {
  input_0arg("_Ohm");
}

static void cb_Unit_F(Fl_Menu_*, void*) {
  input_0arg("_F");
}

static void cb_Unit_Fdy(Fl_Menu_*, void*) {
  input_0arg("_Fdy");
}

static void cb_Unit_Wb(Fl_Menu_*, void*) {
  input_0arg("_Wb");
}

static void cb_Unit_H(Fl_Menu_*, void*) {
  input_0arg("_H");
}

static void cb_Unit_mho(Fl_Menu_*, void*) {
  input_0arg("_mho");
}

static void cb_Unit_S(Fl_Menu_*, void*) {
  input_0arg("_S");
}

static void cb_Unit_T(Fl_Menu_*, void*) {
  input_0arg("_T");
}

static void cb_Unit_Ah(Fl_Menu_*, void*) {
  input_0arg("_(A*h)");
}

static void cb_Unit_cd(Fl_Menu_*, void*) {
  input_0arg("_cd");
}

static void cb_Unit_flam(Fl_Menu_*, void*) {
  input_0arg("_flam");
}

static void cb_Unit_rad(Fl_Menu_*, void*) {
  input_0arg("_rad");
}

static void cb_Unit_deg(Fl_Menu_*, void*) {
  input_0arg("_deg");
}

static void cb_Unit_grad(Fl_Menu_*, void*) {
  input_0arg("_grad");
}

static void cb_Unit_gon(Fl_Menu_*, void*) {
  input_0arg("_gon");
}

static void cb_Unit_arcmin(Fl_Menu_*, void*) {
  input_0arg("_arcmin");
}

static void cb_Unit_arcs(Fl_Menu_*, void*) {
  input_0arg("_arcs");
}

static void cb_Unit_tr(Fl_Menu_*, void*) {
  input_0arg("_tr");
}

static void cb_Unit_m2_s(Fl_Menu_*, void*) {
  input_0arg("_(m^2/s)");
}

static void cb_Unit_P(Fl_Menu_*, void*) {
  input_0arg("_P");
}

static void cb_Unit_St(Fl_Menu_*, void*) {
  input_0arg("_St");
}

static void cb_Unit_Bq(Fl_Menu_*, void*) {
  input_0arg("_Bq");
}

static void cb_Unit_Ci(Fl_Menu_*, void*) {
  input_0arg("_Ci");
}

static void cb_Unit_Gy(Fl_Menu_*, void*) {
  input_0arg("_Gy");
}

static void cb_Unit_rd(Fl_Menu_*, void*) {
  input_0arg("_rd");
}

static void cb_Unit_rem(Fl_Menu_*, void*) {
  input_0arg("_rem");
}

static void cb_Unit_Sv(Fl_Menu_*, void*) {
  input_0arg("_Sv");
}

static void cb_Unit_R(Fl_Menu_*, void*) {
  input_0arg("_R");
}

static void cb_Unit_FF(Fl_Menu_*, void*) {
  input_0arg("_FF");
}

static void cb_Unit_Euro(Fl_Menu_*, void*) {
  input_0arg("_E");
}

static void cb_Algebra(Fl_Menu_*, void*) {
  redraw_mouse_position_only=false;
}

static void cb_Canonical_Form(Fl_Menu_*, void*) {
  input_1arg("canonical_form",false,false);
}

static void cb_Coeff(Fl_Menu_*, void*) {
  input_1arg("coeff",false,false);
}

static void cb_Degree(Fl_Menu_*, void*) {
  input_1arg("degree",false,false);
}

static void cb_Factor_Xn(Fl_Menu_*, void*) {
  input_1arg("factor_xn",false,false);
}

static void cb_Factors(Fl_Menu_*, void*) {
  input_1arg("factors",false,false);
}

static void cb_Fcoeff(Fl_Menu_*, void*) {
  input_1arg("fcoeff",false,false);
}

static void cb_Froot(Fl_Menu_*, void*) {
  input_1arg("froot",false,false);
}

static void cb_Genpoly(Fl_Menu_*, void*) {
  input_1arg("genpoly",false,false);
}

static void cb_Horner(Fl_Menu_*, void*) {
  input_1arg("horner",false,false);
}

static void cb_Lagrange(Fl_Menu_*, void*) {
  input_1arg("lagrange",false,false);
}

static void cb_Lcoeff(Fl_Menu_*, void*) {
  input_1arg("lcoeff",false,false);
}

static void cb_Pcoeff(Fl_Menu_*, void*) {
  input_1arg("pcoeff",false,false);
}

static void cb_Peval(Fl_Menu_*, void*) {
  input_1arg("peval",false,false);
}

static void cb_Proot2(Fl_Menu_*, void*) {
  input_1arg("proot",false,false);
}

static void cb_Ptayl(Fl_Menu_*, void*) {
  input_1arg("ptayl",false,false);
}

static void cb_Poly2symb(Fl_Menu_*, void*) {
  input_1arg("poly2symb",false,false);
}

static void cb_Ranm(Fl_Menu_*, void*) {
  input_1arg("ranm",false,false);
}

static void cb_Symb2poly(Fl_Menu_*, void*) {
  input_1arg("symb2poly",false,false);
}

static void cb_Tcoeff(Fl_Menu_*, void*) {
  input_1arg("tcoeff",false,false);
}

static void cb_Valuation(Fl_Menu_*, void*) {
  input_1arg("valuation",false,false);
}

static void cb_Abcuv(Fl_Menu_*, void*) {
  input_1arg("abcuv",false,false);
}

static void cb_Chinrem(Fl_Menu_*, void*) {
  input_1arg("chinrem",false,false);
}

static void cb_Cyclotomic(Fl_Menu_*, void*) {
  input_1arg("cyclotomic",false,false);
}

static void cb_Divis(Fl_Menu_*, void*) {
  input_1arg("divis",false,false);
}

static void cb_Egcd(Fl_Menu_*, void*) {
  input_1arg("egcd",false,false);
}

static void cb_Factor2(Fl_Menu_*, void*) {
  input_1arg("factor",true,false);
}

static void cb_Gcd_poly(Fl_Menu_*, void*) {
  input_1arg("gcd",false,false);
}

static void cb_Lcm_poly(Fl_Menu_*, void*) {
  input_1arg("lcm",false,false);
}

static void cb_Quotient(Fl_Menu_*, void*) {
  input_1arg("quo",false,false);
}

static void cb_Quorem(Fl_Menu_*, void*) {
  input_1arg("quorem",false,false);
}

static void cb_Rem(Fl_Menu_*, void*) {
  input_1arg("rem",false,false);
}

static void cb_Resultant(Fl_Menu_*, void*) {
  input_1arg("resultant",false,false);
}

static void cb_Sturm(Fl_Menu_*, void*) {
  input_1arg("sturm",false,false);
}

static void cb_Sturmab(Fl_Menu_*, void*) {
  input_1arg("sturmab",false,false);
}

static void cb_Hermite(Fl_Menu_*, void*) {
  input_1arg("hermite",false,false);
}

static void cb_Laguerre(Fl_Menu_*, void*) {
  input_1arg("laguerre",false,false);
}

static void cb_Legendre(Fl_Menu_*, void*) {
  input_1arg("legendre",false,false);
}

static void cb_Tchebyshev1(Fl_Menu_*, void*) {
  input_1arg("tchebyshev1",false,false);
}

static void cb_Tchebyshev2(Fl_Menu_*, void*) {
  input_1arg("tchebyshev2",false,false);
}

static void cb_Gbasis(Fl_Menu_*, void*) {
  input_1arg("gbasis",false,false);
}

static void cb_Greduce(Fl_Menu_*, void*) {
  input_1arg("greduce",false,false);
}

static void cb_Current_Sheet(Fl_Menu_*, void*) {
  input_1arg("current_sheet",false,false);
}

static void cb_Hadamard(Fl_Menu_*, void*) {
  input_1arg("hadamard",false,false);
}

static void cb_Hilbert(Fl_Menu_*, void*) {
  input_1arg("hilbert",false,false);
}

static void cb_Idendity(Fl_Menu_*, void*) {
  input_1arg("idn",false,false);
}

static void cb_Matrix_makemat(Fl_Menu_*, void*) {
  input_1arg("makemat",false,false);
}

static void cb_Matrix_ncols(Fl_Menu_*, void*) {
  input_1arg("ncols",false,false);
}

static void cb_Matrix_nrows(Fl_Menu_*, void*) {
  input_1arg("nrows",false,false);
}

static void cb_Rand_mat(Fl_Menu_*, void*) {
  input_1arg("ranm",false,false);
}

static void cb_Syst2mat(Fl_Menu_*, void*) {
  input_1arg("syst2mat",false,false);
}

static void cb_Vandermonde(Fl_Menu_*, void*) {
  input_1arg("vandermonde",false,false);
}

static void cb_Basis(Fl_Menu_*, void*) {
  input_1arg("basis",false,false);
}

static void cb_Reduction_changebase(Fl_Menu_*, void*) {
  input_1arg("changebase",false,false);
}

static void cb_Det(Fl_Menu_*, void*) {
  input_1arg("det",false,false);
}

static void cb_Matrix_det_minor(Fl_Menu_*, void*) {
  input_1arg("det_minor",false,false);
}

static void cb_Inverse_matrix(Fl_Menu_*, void*) {
  input_1arg("inv",false,false);
}

static void cb_Ibasis(Fl_Menu_*, void*) {
  input_1arg("ibasis",false,false);
}

static void cb_Idn(Fl_Menu_*, void*) {
  input_1arg("idn",false,false);
}

static void cb_Ker(Fl_Menu_*, void*) {
  input_1arg("ker",false,false);
}

static void cb_Lin_Image(Fl_Menu_*, void*) {
  input_1arg("image",false,false);
}

static void cb_Linsolve(Fl_Menu_*, void*) {
  input_1arg("linsolve",false,false);
}

static void cb_Rank_mat(Fl_Menu_*, void*) {
  input_1arg("rank",false,false);
}

static void cb_Rref_mat(Fl_Menu_*, void*) {
  input_1arg("rref",false,false);
}

static void cb_Trace(Fl_Menu_*, void*) {
  input_1arg("trace",false,false);
}

static void cb_Transconjugate(Fl_Menu_*, void*) {
  input_1arg("trn",false,false);
}

static void cb_Transpose(Fl_Menu_*, void*) {
  input_1arg("tran",false,false);
}

static void cb_Egv_adjoint_matrix(Fl_Menu_*, void*) {
  input_1arg("adjoint_matrix",false,false);
}

static void cb_Companion(Fl_Menu_*, void*) {
  input_1arg("companion",false,false);
}

static void cb_Egv(Fl_Menu_*, void*) {
  input_1arg("egv",false,false);
}

static void cb_Egvl(Fl_Menu_*, void*) {
  input_1arg("egvl",false,false);
}

static void cb_Egv_hessenberg(Fl_Menu_*, void*) {
  input_1arg("hessenberg",false,false);
}

static void cb_Jordan(Fl_Menu_*, void*) {
  input_1arg("jordan",false,false);
}

static void cb_Egv_pcar(Fl_Menu_*, void*) {
  input_1arg("pcar",false,false);
}

static void cb_Egv_pcar_hessenberg(Fl_Menu_*, void*) {
  input_1arg("pcar_hessenberg",false,false);
}

static void cb_Egv_pmin(Fl_Menu_*, void*) {
  input_1arg("pmin",false,false);
}

static void cb_Cholesky(Fl_Menu_*, void*) {
  input_1arg("cholesky",false,false);
}

static void cb_Lll(Fl_Menu_*, void*) {
  input_1arg("lll",false,false);
}

static void cb_Lu(Fl_Menu_*, void*) {
  input_1arg("lu",false,false);
}

static void cb_Qr(Fl_Menu_*, void*) {
  input_1arg("qr",false,false);
}

static void cb_Svd(Fl_Menu_*, void*) {
  input_1arg("svd",false,false);
}

static void cb_A2q(Fl_Menu_*, void*) {
  input_1arg("a2q",false,false);
}

static void cb_Gauss(Fl_Menu_*, void*) {
  input_1arg("gauss",false,false);
}

static void cb_Gramschmidt(Fl_Menu_*, void*) {
  input_1arg("gramschmidt",false,false);
}

static void cb_Q2a(Fl_Menu_*, void*) {
  input_1arg("q2a",false,false);
}

static void cb_Isom(Fl_Menu_*, void*) {
  input_1arg("isom",false,false);
}

static void cb_Mkisom(Fl_Menu_*, void*) {
  input_1arg("mkisom",false,false);
}

static void cb_C1oc2(Fl_Menu_*, void*) {
  input_1arg("c1oc2",false,false);
}

static void cb_C1op2(Fl_Menu_*, void*) {
  input_1arg("c1op2",false,false);
}

static void cb_Cycle2perm(Fl_Menu_*, void*) {
  input_1arg("cycle2perm",false,false);
}

static void cb_Cycleinv(Fl_Menu_*, void*) {
  input_1arg("cycleinv",false,false);
}

static void cb_Cycles2permu(Fl_Menu_*, void*) {
  input_1arg("cycles2permu",false,false);
}

static void cb_Est_Cycle(Fl_Menu_*, void*) {
  input_1arg("est_cycle",false,false);
}

static void cb_Est_Permu(Fl_Menu_*, void*) {
  input_1arg("est_permu",false,false);
}

static void cb_Groupepermu(Fl_Menu_*, void*) {
  input_1arg("groupepermu",false,false);
}

static void cb_P1oc2(Fl_Menu_*, void*) {
  input_1arg("p1oc2",false,false);
}

static void cb_P1op2(Fl_Menu_*, void*) {
  input_1arg("p1op2",false,false);
}

static void cb_Perminv(Fl_Menu_*, void*) {
  input_1arg("perminv",false,false);
}

static void cb_Permu2cycles(Fl_Menu_*, void*) {
  input_1arg("permu2cycles",false,false);
}

static void cb_Permu2mat(Fl_Menu_*, void*) {
  input_1arg("permu2mat",false,false);
}

static void cb_Permuorder(Fl_Menu_*, void*) {
  input_1arg("permuorder",false,false);
}

static void cb_Randperm(Fl_Menu_*, void*) {
  input_1arg("randperm",false,false);
}

static void cb_Perm_Signature(Fl_Menu_*, void*) {
  input_1arg("signature",false,false);
}

static void cb_Cas_menu(Fl_Menu_*, void*) {
  redraw_mouse_position_only=false;
}

static void cb_Derive(Fl_Menu_*, void*) {
  input_1arg("diff",false,false);
}

static void cb_Ibpdv(Fl_Menu_*, void*) {
  input_1arg("ibpdv",true,false);
}

static void cb_Ibpu(Fl_Menu_*, void*) {
  input_1arg("ibpu",true,false);
}

static void cb_Integrate(Fl_Menu_*, void*) {
  input_1arg("integrate",false,false);
}

static void cb_Preval(Fl_Menu_*, void*) {
  input_1arg("preval",false,false);
}

static void cb_Sum(Fl_Menu_*, void*) {
  input_1arg("sum",false,false);
}

static void cb_Curl(Fl_Menu_*, void*) {
  input_1arg("curl",false,false);
}

static void cb_Derive2(Fl_Menu_*, void*) {
  input_1arg("derive",false,false);
}

static void cb_Divergence(Fl_Menu_*, void*) {
  input_1arg("divergence",false,false);
}

static void cb_Hessian(Fl_Menu_*, void*) {
  input_1arg("hessian",false,false);
}

static void cb_Laplacian(Fl_Menu_*, void*) {
  input_1arg("laplacian",false,false);
}

static void cb_Potential(Fl_Menu_*, void*) {
  input_1arg("potential",false,false);
}

static void cb_Vpotential(Fl_Menu_*, void*) {
  input_1arg("vpotential",false,false);
}

static void cb_Limit(Fl_Menu_*, void*) {
  Eqw * eqwptr= dynamic_cast<Eqw*>(Fl::focus());
  if (eqwptr) 
    Eqw_IDS(eqwptr,symbolic(at_limit,makevecteur(zero,vx_var,zero)));
  else
    input_1arg("limit",false,false);
}

static void cb_Series(Fl_Menu_*, void*) {
  string s=(string("series(")+input->value()+",x=,5)");
input->value(s.c_str());
input->position(s.size()-3,s.size()-3);
make_new_help("series");
}

static void cb_Linsolve2(Fl_Menu_*, void*) {
  input_1arg("linsolve",false,false);
}

static void cb_Solve(Fl_Menu_*, void*) {
  input_1arg("solve",false,false);
}

static void cb_Desolve(Fl_Menu_*, void*) {
  input_1arg("desolve",false,false);
}

static void cb_Reverse_Rsolve(Fl_Menu_*, void*) {
  input_1arg("reverse_rsolve",false,false);
}

static void cb_Epsilon2zero(Fl_Menu_*, void*) {
  input_1arg("epsilon2zero",false,false);
}

static void cb_Evalf_item(Fl_Menu_*, void*) {
  input_1arg("evalf",false,false);
}

static void cb_Float2rational(Fl_Menu_*, void*) {
  input_1arg("float2rational",true,false);
}

static void cb_Newton(Fl_Menu_*, void*) {
  input_1arg("newton",false,false);
}

static void cb_Romberg(Fl_Menu_*, void*) {
  input_1arg("romberg",false,false);
}

static void cb_Odesolve(Fl_Menu_*, void*) {
  input_1arg("odesolve",false,false);
}

static void cb_Fsolve11(Fl_Menu_*, void*) {
  input_1arg("fsolve",false,false);
}

static void cb_Bisection(Fl_Menu_*, void*) {
  input_2arg("fsolve","bisection_solver");
}

static void cb_Brent(Fl_Menu_*, void*) {
  input_2arg("fsolve","brent_solver");
}

static void cb_Falsepos(Fl_Menu_*, void*) {
  input_2arg("fsolve","falsepos_solver");
}

static void cb_Newtonf(Fl_Menu_*, void*) {
  input_2arg("fsolve","newton_solver");
}

static void cb_Secant(Fl_Menu_*, void*) {
  input_2arg("fsolve","secant_solver");
}

static void cb_Steffenson(Fl_Menu_*, void*) {
  input_2arg("fsolve","steffenson_solver");
}

static void cb_Fsolve21(Fl_Menu_*, void*) {
  input_1arg("fsolve",false,false);
}

static void cb_Newtond(Fl_Menu_*, void*) {
  input_2arg("fsolve","dnewton_solver");
}

static void cb_Hybrid(Fl_Menu_*, void*) {
  input_2arg("fsolve","hybrid_solver");
}

static void cb_Hybrids(Fl_Menu_*, void*) {
  input_2arg("fsolve","hybrids_solver");
}

static void cb_Newtonj(Fl_Menu_*, void*) {
  input_2arg("fsolve","newtonj_solver");
}

static void cb_Hybridj(Fl_Menu_*, void*) {
  input_2arg("fsolve","hybridj_solver");
}

static void cb_Hybridsj(Fl_Menu_*, void*) {
  input_2arg("fsolve","hybridsj_solver");
}

static void cb_Gamma(Fl_Menu_*, void*) {
  input_1arg("gamma",false,false);
}

static void cb_Psi(Fl_Menu_*, void*) {
  input_1arg("psi",false,false);
}

static void cb_Zeta(Fl_Menu_*, void*) {
  input_1arg("zeta",false,false);
}

static void cb_Airy_Ai(Fl_Menu_*, void*) {
  input_1arg("Airy_Ai",false,false);
}

static void cb_Airy_Bi(Fl_Menu_*, void*) {
  input_1arg("Airy_Bi",false,false);
}

static void cb_Fft(Fl_Menu_*, void*) {
  input_1arg("fft",false,false);
}

static void cb_Fourier_An(Fl_Menu_*, void*) {
  input_1arg("fourier_an",false,false);
}

static void cb_Fourier_Bn(Fl_Menu_*, void*) {
  input_1arg("fourier_bn",false,false);
}

static void cb_Fourier_Cn(Fl_Menu_*, void*) {
  input_1arg("fourier_cn",false,false);
}

static void cb_Ifft(Fl_Menu_*, void*) {
  input_1arg("ifft",false,false);
}

static void cb_Ilaplace(Fl_Menu_*, void*) {
  input_1arg("ilaplace",false,false);
}

static void cb_Laplace(Fl_Menu_*, void*) {
  input_1arg("laplace",false,false);
}

static void cb_Prg_local(Fl_Menu_*, void*) {
  make_new_help("local");
  string s(input->value());
  int p=input->position();
  s=s.substr(0,p)+"{\n  local ,; \n  \n}"+s.substr(p,s.size()-p);
  input->value(s.c_str());
  input->position(p+10,p+10);
}

static void cb_Prg_bloc(Fl_Menu_*, void*) {
  input_0arg("{ \n}");
}

static void cb_Prg_return(Fl_Menu_*, void*) {
  input_1arg("return",false,false);
}

static void cb_Prg_ifte(Fl_Menu_*, void*) {
  make_new_help("if");
  string s(input->value());
  int p=input->position();
  s=s.substr(0,p)+"if (){\n \n} else {\n \n}\n"+s.substr(p,s.size()-p);
  input->value(s.c_str());
  input->position(p+4,p+4);
}

static void cb_Prg_if(Fl_Menu_*, void*) {
  input_0arg("if ");
}

static void cb_Prg_then(Fl_Menu_*, void*) {
  input_0arg("then ");
}

static void cb_Prg_else(Fl_Menu_*, void*) {
  input_0arg("else ");
}

static void cb_Prg_endif(Fl_Menu_*, void*) {
  input_0arg("end_if;");
}

static void cb_Prg_switch(Fl_Menu_*, void*) {
  input_1arg("switch",false,false);
}

static void cb_Prg_case(Fl_Menu_*, void*) {
  input_0arg("case:");
}

static void cb_Prg_break2(Fl_Menu_*, void*) {
  input_1arg("break;",false,false);
}

static void cb_Prg_try(Fl_Menu_*, void*) {
  make_new_help("try");
  string s(input->value());
  int p=input->position();
  s=s.substr(0,p)+"try{\n }\ncatch(){\n }\n"+s.substr(p,s.size()-p);
  input->value(s.c_str());
  input->position(p+5,p+5);
}

static void cb_Prg_for(Fl_Menu_*, void*) {
  make_new_help("for");
  string s(input->value());
  int p=input->position();
  s=s.substr(0,p)+"for(;;){\n \n}\n"+s.substr(p,s.size()-p);
  input->value(s.c_str());
  input->position(p+4,p+4);
}

static void cb_Prg_while(Fl_Menu_*, void*) {
  input_1arg("while",false,false);
}

static void cb_Prg_do(Fl_Menu_*, void*) {
  input_0arg("do ");
}

static void cb_Prg_end_while(Fl_Menu_*, void*) {
  input_0arg("end_while;");
}

static void cb_Prg_break(Fl_Menu_*, void*) {
  input_0arg("break;");
}

static void cb_Prg_continue(Fl_Menu_*, void*) {
  input_0arg("continue;");
}

static void cb_Prg_append(Fl_Menu_*, void*) {
  input_1arg("append",false,false);
}

static void cb_Prg_accumulate_head_tail(Fl_Menu_*, void*) {
  input_1arg("accumulate_head_tail",false,false);
}

static void cb_Prg_concat(Fl_Menu_*, void*) {
  input_1arg("concat",false,false);
}

static void cb_Prg_head(Fl_Menu_*, void*) {
  input_1arg("head",false,false);
}

static void cb_Prg_makelist(Fl_Menu_*, void*) {
  input_1arg("makelist",false,false);
}

static void cb_Prg_member(Fl_Menu_*, void*) {
  input_1arg("member",false,false);
}

static void cb_Prg_mid(Fl_Menu_*, void*) {
  input_1arg("mid",false,false);
}

static void cb_Prg_revlist(Fl_Menu_*, void*) {
  input_1arg("revlist",false,false);
}

static void cb_Prg_rotate(Fl_Menu_*, void*) {
  input_1arg("rotate",false,false);
}

static void cb_Prg_shift(Fl_Menu_*, void*) {
  input_1arg("shift",false,false);
}

static void cb_Prg_size(Fl_Menu_*, void*) {
  input_1arg("size",false,false);
}

static void cb_Prg_sizes(Fl_Menu_*, void*) {
  input_1arg("sizes",false,false);
}

static void cb_Prg_sort(Fl_Menu_*, void*) {
  input_1arg("sort",false,false);
}

static void cb_Prg_suppress(Fl_Menu_*, void*) {
  input_1arg("suppress",false,false);
}

static void cb_Prg_tail(Fl_Menu_*, void*) {
  input_1arg("tail",false,false);
}

static void cb_Prg_about(Fl_Menu_*, void*) {
  input_1arg("about",false,false);
}

static void cb_Prg_affect(Fl_Menu_*, void*) {
  input_0arg(":=");
}

static void cb_Prg_ans(Fl_Menu_*, void*) {
  input_1arg("ans",false,false);
}

static void cb_Prg_assume(Fl_Menu_*, void*) {
  input_1arg("assume",false,false);
}

static void cb_Prg_entry(Fl_Menu_*, void*) {
  input_1arg("entry",false,false);
}

static void cb_Prg_purge(Fl_Menu_*, void*) {
  input_1arg("purge",false,false);
}

static void cb_Prg_intersect(Fl_Menu_*, void*) {
  input_0arg("intersect");
}

static void cb_Prg_minus(Fl_Menu_*, void*) {
  input_0arg("minus");
}

static void cb_Prg_union(Fl_Menu_*, void*) {
  input_0arg("union");
}

static void cb_Prg_asc(Fl_Menu_*, void*) {
  input_1arg("asc",false,false);
}

static void cb_Prg_char(Fl_Menu_*, void*) {
  input_1arg("char",false,false);
}

static void cb_Prg_inString(Fl_Menu_*, void*) {
  input_1arg("inString",false,false);
}

static void cb_Prg_left(Fl_Menu_*, void*) {
  input_1arg("left",false,false);
}

static void cb_Prg_ord(Fl_Menu_*, void*) {
  input_1arg("ord",false,false);
}

static void cb_Prg_right(Fl_Menu_*, void*) {
  input_1arg("right",false,false);
}

static void cb_Prg_string(Fl_Menu_*, void*) {
  input_1arg("string",false,false);
}

static void cb_Prg_ClrIO(Fl_Menu_*, void*) {
  input_1arg("ClrIO",false,false);
}

static void cb_Prg_input(Fl_Menu_*, void*) {
  input_1arg("input",false,false);
}

static void cb_Prg_print(Fl_Menu_*, void*) {
  input_1arg("print",false,false);
}

static void cb_Prg_and(Fl_Menu_*, void*) {
  input_0arg("and");
}

static void cb_Prg_or(Fl_Menu_*, void*) {
  input_0arg("or");
}

static void cb_Prg_not(Fl_Menu_*, void*) {
  input_1arg("not",false,false);
}

static void cb_Prg_xor(Fl_Menu_*, void*) {
  input_0arg("xor");
}

static void cb_Prg_eqeq(Fl_Menu_*, void*) {
  input_0arg("==");
}

static void cb_Prg_neq(Fl_Menu_*, void*) {
  input_0arg("!=");
}

static void cb_Prg_infstrict(Fl_Menu_*, void*) {
  input_0arg("<");
}

static void cb_Prg_infegal(Fl_Menu_*, void*) {
  input_0arg("<=");
}

static void cb_Prg_supstrict(Fl_Menu_*, void*) {
  input_0arg(">");
}

static void cb_Prg_supegal(Fl_Menu_*, void*) {
  input_0arg(">=");
}

static void cb_Prg_breakpoint(Fl_Menu_*, void*) {
  input_1arg("breakpoint",false,false);
}

static void cb_Prg_debug(Fl_Menu_*, void*) {
  input_1arg("debug",false,false);
}

static void cb_Prg_kill(Fl_Menu_*, void*) {
  input_1arg("kill",false,false);
}

static void cb_Prg_rmbreakpoint(Fl_Menu_*, void*) {
  input_1arg("rmbreakpoint",false,false);
}

static void cb_Prg_rmwatch(Fl_Menu_*, void*) {
  input_1arg("rmwatch",false,false);
}

static void cb_Prg_watch(Fl_Menu_*, void*) {
  input_1arg("watch",false,false);
}

static void cb_Search_help(Fl_Menu_*, void*) {
  const char * ch=fl_input(gettext("Enter word to search"),current_help_string.c_str());
if (ch){
  string s=ch;
  help_fltk(s.c_str());
};
}

static void cb_Edit_help(Fl_Menu_*, void*) {
  manage_upper_window(upper_window_help,false);
string t(input->value()),s;
size_t sel1=input->position(),sel2=input->mark();
if (sel1==sel2)
  s=t;
if (sel1>sel2){
  std::swap<size_t>(sel1,sel2);
s=t.substr(sel1,sel2-sel1);
}
size_t pos=s.find_first_of('(');
if (pos)
  s=s.substr(0,pos);
make_new_help(s.c_str());
}

static void cb_Tutorial_help(Fl_Menu_*, void*) {
  if (language==2)
  system(browser_command(doc_prefix+"tutoriel_en/index.html").c_str());
else
  system(browser_command(doc_prefix+"tutoriel/index.html").c_str());
}

static void cb_Cas_help(Fl_Menu_*, void*) {
  system(browser_command("doc/fr/casflan/index.html").c_str());
}

static void cb_Geo_help(Fl_Menu_*, void*) {
  system(browser_command("doc/fr/casgeo/index.html").c_str());
}

static void cb_Mtrw_help(Fl_Menu_*, void*) {
  system(browser_command("doc/fr/cassim/index.html").c_str());
}

static void cb_Prog_help(Fl_Menu_*, void*) {
  system(browser_command("doc/fr/casrouge/index.html").c_str());
}

static void cb_Tortue_help(Fl_Menu_*, void*) {
  system(browser_command("doc/fr/castor/index.html").c_str());
}

static void cb_Us_help(Fl_Menu_*, void*) {
  system(browser_command("doc/en/giac_us.html").c_str());
}

static void cb_Spanish_help(Fl_Menu_*, void*) {
  system(browser_command("doc/es/giac_es.html").c_str());
}

static void cb_Forum_help(Fl_Menu_*, void*) {
  system(browser_command("http:pcm1.e.ujf-grenoble.fr:8080/Logiciels/Forum-Xcas/").c_str());
}

Fl_Menu_Item menu_xcas[] = {
 {gettext("File"), 0,  (Fl_Callback*)cb_Fichier, 0, 64, 0, 0, 10, 56},
 {gettext("Run xcas session"), 0x40072,  (Fl_Callback*)cb_Run_session, 0, 0, 0, 0, 10, 56},
 {gettext("Run file (read)"), 0,  (Fl_Callback*)cb_Run_file, 0, 0, 0, 0, 10, 56},
 {gettext("Run file line by line"), 0x40065,  (Fl_Callback*)cb_Run_script, 0, 0, 0, 0, 10, 56},
 {gettext("Read file (1 history level)"), 0,  (Fl_Callback*)cb_Read_program, 0, 0, 0, 0, 10, 56},
 {gettext("Save history"), 0x40073,  (Fl_Callback*)cb_Save_session, 0, 0, 0, 0, 10, 56},
 {gettext("Save history as"), 0,  (Fl_Callback*)cb_Save_as, 0, 0, 0, 0, 10, 56},
 {gettext("Print history"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("Printer"), 0,  (Fl_Callback*)cb_Print_native, 0, 0, 0, 0, 10, 56},
 {gettext("Preview hist to Postscript file"), 0,  (Fl_Callback*)cb_Print_PS, 0, 0, 0, 0, 10, 56},
 {gettext("Preview (using LaTeX)"), 0,  (Fl_Callback*)cb_Preview, 0, 0, 0, 0, 10, 56},
 {gettext("Print (using LaTeX)"), 0,  (Fl_Callback*)cb_Print_to_printer, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Import history from"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("xcas text"), 0,  (Fl_Callback*)cb_Import_xcas, 0, 0, 0, 0, 10, 56},
 {gettext("maple text"), 0,  (Fl_Callback*)cb_Import_maple, 0, 0, 0, 0, 10, 56},
 {gettext("maple worksheet"), 0,  (Fl_Callback*)cb_Import_mws, 0, 0, 0, 0, 10, 56},
 {gettext("mupad text"), 0,  (Fl_Callback*)cb_Import_mupad, 0, 0, 0, 0, 10, 56},
 {gettext("ti89 (prog, func, group)"), 0,  (Fl_Callback*)cb_Import_ti89, 0, 0, 0, 0, 10, 56},
 {gettext("ti92 (prog, func, group)"), 0,  (Fl_Callback*)cb_Import_ti92, 0, 0, 0, 0, 10, 56},
 {gettext("ti text"), 0,  (Fl_Callback*)cb_Import_ti_text, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Export history as"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("xcas text"), 0,  (Fl_Callback*)cb_Export_xcas, 0, 0, 0, 0, 10, 56},
 {gettext("maple text"), 0,  (Fl_Callback*)cb_Export_maple, 0, 0, 0, 0, 10, 56},
 {gettext("mupad text"), 0,  (Fl_Callback*)cb_Export_mupad, 0, 0, 0, 0, 10, 56},
 {gettext("TI89 text"), 0,  (Fl_Callback*)cb_Export_ti89, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Help language"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("Francais"), 0x50066,  (Fl_Callback*)cb_Francais, 0, 0, 0, 0, 10, 56},
 {gettext("English"), 0x50065,  (Fl_Callback*)cb_English, 0, 0, 0, 0, 10, 56},
 {gettext("Espanol"), 0x50073,  (Fl_Callback*)cb_Espanol, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Save configuration"), 0,  (Fl_Callback*)cb_Save_config, 0, 0, 0, 0, 10, 56},
 {gettext("eqw (Equationwriter) i/o"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("Load equation"), 0,  (Fl_Callback*)cb_Eqw_open, 0, 0, 0, 0, 10, 56},
 {gettext("Store equation"), 0,  (Fl_Callback*)cb_Eqw_store, 0, 0, 0, 0, 10, 56},
 {gettext("Store equation as"), 0,  (Fl_Callback*)cb_Eqw_store_as, 0, 0, 0, 0, 10, 56},
 {gettext("Insert equation"), 0,  (Fl_Callback*)cb_Eqw_insert, 0, 0, 0, 0, 10, 56},
 {gettext("Save selection as"), 0,  (Fl_Callback*)cb_Eqw_substore, 0, 0, 0, 0, 10, 56},
 {gettext("Print eqw"), 0,  (Fl_Callback*)cb_Print_eqw, 0, 0, 0, 0, 10, 56},
 {gettext("Preview eqw to Postscript file"), 0,  (Fl_Callback*)cb_Save_eqw_ps, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("geo (Geometry) i/o"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("Preview 2d plot to Postscript file"), 0,  (Fl_Callback*)cb_Save_2dplot_ps, 0, 0, 0, 0, 10, 56},
 {gettext("Print 2d plot"), 0,  (Fl_Callback*)cb_Print_2dplot, 0, 0, 0, 0, 10, 56},
 {gettext("Save 2d plot to SVG file"), 0,  (Fl_Callback*)cb_Save_2dplot_svg, 0, 0, 0, 0, 10, 56},
 {gettext("Save 2d plot as LaTex and PS"), 0,  (Fl_Callback*)cb_Save_2dplot_tex, 0, 0, 0, 0, 10, 56},
 {gettext("Save 3d plot as LaTex"), 0,  (Fl_Callback*)cb_Save_3dplot_tex, 0, 0, 0, 0, 10, 56},
 {gettext("Save 3-d plot as png"), 0,  (Fl_Callback*)cb_Save_3dplot_png, 0, 0, 0, 0, 10, 56},
 {gettext("Save 3-d plot as svg"), 0,  (Fl_Callback*)cb_Save_3dplot_svg, 0, 0, 0, 0, 10, 56},
 {gettext("Save 3-d plot as emf"), 0,  (Fl_Callback*)cb_Save_3dplot_emf, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("mtrw (Matrixwriter) i/o"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("Load sheet"), 0,  (Fl_Callback*)cb_Spread_open, 0, 0, 0, 0, 10, 56},
 {gettext("Store sheet"), 0,  (Fl_Callback*)cb_Spread_store, 0, 0, 0, 0, 10, 56},
 {gettext("Store sheet as"), 0,  (Fl_Callback*)cb_Spread_store_as, 0, 0, 0, 0, 10, 56},
 {gettext("Insert sheet from file"), 0,  (Fl_Callback*)cb_Spread_insert, 0, 0, 0, 0, 10, 56},
 {gettext("Save selection"), 0,  (Fl_Callback*)cb_Spread_substore, 0, 0, 0, 0, 10, 56},
 {gettext("Print sheet"), 0,  (Fl_Callback*)cb_Print_spread, 0, 0, 0, 0, 10, 56},
 {gettext("Preview sheet to Postscript file"), 0,  (Fl_Callback*)cb_Save_sheet_ps, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("prg (Program) i/o"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("Load program"), 0,  (Fl_Callback*)cb_Program_open, 0, 0, 0, 0, 10, 56},
 {gettext("Store program"), 0,  (Fl_Callback*)cb_Program_store, 0, 0, 0, 0, 10, 56},
 {gettext("Store program as"), 0,  (Fl_Callback*)cb_Program_store_as, 0, 0, 0, 0, 10, 56},
 {gettext("Insert program"), 0,  (Fl_Callback*)cb_Program_insert, 0, 0, 0, 0, 10, 56},
 {gettext("Print prg"), 0,  (Fl_Callback*)cb_Print_prg, 0, 0, 0, 0, 10, 56},
 {gettext("Preview prog to Postscript file"), 0,  (Fl_Callback*)cb_Save_prg_ps, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Update xcas"), 0,  (Fl_Callback*)cb_Update_xcas, 0, 0, 0, 0, 10, 56},
 {gettext("About"), 0,  (Fl_Callback*)cb_A_propos, 0, 0, 0, 0, 10, 56},
 {gettext("Quit"), 0x40071,  (Fl_Callback*)cb_Quit, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Edit"), 0,  (Fl_Callback*)cb_Edit_edit, 0, 64, 0, 0, 10, 56},
 {gettext("Copy to"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("histcmd2eqw"), 0,  (Fl_Callback*)cb_Cmdline_to_eqw, 0, 0, 0, 0, 10, 56},
 {gettext("histcmd2mtrw"), 0,  (Fl_Callback*)cb_Cmdline_to_mtrw, 0, 0, 0, 0, 10, 56},
 {gettext("histsel2eqw"), 0,  (Fl_Callback*)cb_History_to_eqw, 0, 0, 0, 0, 10, 56},
 {gettext("hist2prg"), 0,  (Fl_Callback*)cb_History_to_prog, 0, 0, 0, 0, 10, 56},
 {gettext("eqw2histcmd"), 0,  (Fl_Callback*)cb_Eqw_to_history, 0, 0, 0, 0, 10, 56},
 {gettext("mtrwcell2histcmd"), 0,  (Fl_Callback*)cb_Cell_to_history, 0, 0, 0, 0, 10, 56},
 {gettext("mtrw2histcmd"), 0,  (Fl_Callback*)cb_Matrix_to_history, 0, 0, 0, 0, 10, 56},
 {gettext("mtrwsel2histcmd"), 0,  (Fl_Callback*)cb_Matrixsel_to_cmdline, 0, 0, 0, 0, 10, 56},
 {gettext("prg2histcmd"), 0,  (Fl_Callback*)cb_Prg_to_cmdline, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Clear"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("Clear commandline"), 0xff1b,  (Fl_Callback*)cb_Edit_clear, 0, 0, 0, 0, 10, 56},
 {gettext("Clear history"), 0,  (Fl_Callback*)cb_Clear_history, 0, 0, 0, 0, 10, 56},
 {gettext("Clear all"), 0,  (Fl_Callback*)cb_Newprob, 0, 0, 0, 0, 10, 56},
 {gettext("Clear a..z variables"), 0,  (Fl_Callback*)cb_Remove_a_z, 0, 0, 0, 0, 10, 56},
 {gettext("Clear all variables"), 0,  (Fl_Callback*)cb_Remove_vars, 0, 0, 0, 0, 10, 56},
 {gettext("Clear eqw"), 0,  (Fl_Callback*)cb_Clear_Eqw, 0, 0, 0, 0, 10, 56},
 {gettext("Clear mtrw"), 0,  (Fl_Callback*)cb_Spread_new_table, 0, 0, 0, 0, 10, 56},
 {gettext("Clear program"), 0,  (Fl_Callback*)cb_Clear_Program, 0, 0, 0, 0, 10, 56},
 {gettext("ClrIO"), 0,  (Fl_Callback*)cb_Edit_ClrIO, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Paste"), 0x40076,  (Fl_Callback*)cb_Edit_paste, 0, 0, 0, 0, 10, 56},
 {gettext("Cancel hist modifs"), 0x4007a,  (Fl_Callback*)cb_Cancel_modif, 0, 0, 0, 0, 10, 56},
 {gettext("Windows"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("1 Window"), 0x4ffbe,  (Fl_Callback*)cb_Xcas_1_Window, 0, 0, 0, 0, 10, 56},
 {gettext("2 Windows"), 0x4ffbf,  (Fl_Callback*)cb_Xcas_2_Windows, 0, 0, 0, 0, 10, 56},
 {gettext("3 Windows"), 0x4ffc0,  (Fl_Callback*)cb_Xcas_3_Windows, 0, 0, 0, 0, 10, 56},
 {gettext("Equation"), 0x4ffc1,  (Fl_Callback*)cb_Edit_eqw, 0, 0, 0, 0, 10, 56},
 {gettext("Geometry"), 0x4ffc2,  (Fl_Callback*)cb_Edit_geo, 0, 0, 0, 0, 10, 56},
 {gettext("Help"), 0x4ffc3,  (Fl_Callback*)cb_Edit_help1, 0, 0, 0, 0, 10, 56},
 {gettext("History"), 0x4ffc4,  (Fl_Callback*)cb_Edit_history, 0, 0, 0, 0, 10, 56},
 {gettext("Matrix"), 0x4ffc5,  (Fl_Callback*)cb_Edit_matrix, 0, 0, 0, 0, 10, 56},
 {gettext("Messages"), 0x4ffc6,  (Fl_Callback*)cb_Edit_msg, 0, 0, 0, 0, 10, 56},
 {gettext("Edit program"), 0x4ffc7,  (Fl_Callback*)cb_Edit_prg, 0, 0, 0, 0, 10, 56},
 {gettext("Horizontal split"), 0x4ffc8,  (Fl_Callback*)cb_Horizontal_split_menu, 0, 0, 0, 0, 10, 56},
 {gettext("Vertical split"), 0x4ffc9,  (Fl_Callback*)cb_Vertical_split_menu, 0, 0, 0, 0, 10, 56},
 {gettext("Show bandeau"), 0,  (Fl_Callback*)cb_On_bandeau, 0, 0, 0, 0, 10, 56},
 {gettext("Hide bandeau"), 0,  (Fl_Callback*)cb_Off_bandeau, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("eqw"), 0,  0, 0, 80, 0, 0, 10, 56},
 {gettext("Undo"), 0,  (Fl_Callback*)cb_Edit_undo, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("geo (Geometry)"), 0,  0, 0, 80, 0, 0, 10, 56},
 {gettext("Zoom in"), 0,  (Fl_Callback*)cb_Geo_zoom_in, 0, 0, 0, 0, 10, 56},
 {gettext("Zoom out"), 0,  (Fl_Callback*)cb_Geo_zoom_out, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("hist (History)"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("Recompute history"), 0x40066,  (Fl_Callback*)cb_Xcas_Recompute_history, 0, 0, 0, 0, 10, 56},
 {gettext("Insert history level"), 0x4006e,  (Fl_Callback*)cb_History_insert_level, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("View hist in msg as"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("xcas"), 0,  (Fl_Callback*)cb_CPP_View, 0, 0, 0, 0, 10, 56},
 {gettext("maple"), 0,  (Fl_Callback*)cb_Maple_View, 0, 0, 0, 0, 10, 56},
 {gettext("mupad"), 0,  (Fl_Callback*)cb_Mupad_View, 0, 0, 0, 0, 10, 56},
 {gettext("ti89"), 0,  (Fl_Callback*)cb_TI89_View, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("mtrw (Matrixwriter)"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("Sort"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("Inc/col"), 0,  (Fl_Callback*)cb_Spread_inc_col_sort, 0, 0, 0, 0, 10, 56},
 {gettext("Dec/col"), 0,  (Fl_Callback*)cb_Spread_dec_col_sort, 0, 0, 0, 0, 10, 56},
 {gettext("Inc/row"), 0,  (Fl_Callback*)cb_Spread_inc_row_sort, 0, 0, 0, 0, 10, 56},
 {gettext("Dec/row"), 0,  (Fl_Callback*)cb_Spread_dec_row_sort, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Cell copy"), 0,  (Fl_Callback*)cb_Edit_copy_menu, 0, 0, 0, 0, 10, 56},
 {gettext("Col+ at end"), 0,  (Fl_Callback*)cb_Spread_insert_col_end, 0, 0, 0, 0, 10, 56},
 {gettext("Row+ at end"), 0,  (Fl_Callback*)cb_Spread_insert_row_end, 0, 0, 0, 0, 10, 56},
 {gettext("Erase current col"), 0,  (Fl_Callback*)cb_Spread_delete_col, 0, 0, 0, 0, 10, 56},
 {gettext("Erase current row"), 0,  (Fl_Callback*)cb_Spread_delete_row, 0, 0, 0, 0, 10, 56},
 {gettext("Erase selection cols"), 0,  (Fl_Callback*)cb_Spread_delete_cols, 0, 0, 0, 0, 10, 56},
 {gettext("Erase selection rows"), 0,  (Fl_Callback*)cb_Spread_delete_rows, 0, 0, 0, 0, 10, 56},
 {gettext("Clear mtrw"), 0xffc9,  (Fl_Callback*)cb_Spread_new_table2, 0, 0, 0, 0, 10, 56},
 {gettext("Col larger"), 0,  (Fl_Callback*)cb_Spread_col_larger, 0, 0, 0, 0, 10, 56},
 {gettext("Col smaller"), 0,  (Fl_Callback*)cb_Spread_col_smaller, 0, 0, 0, 0, 10, 56},
 {gettext("Move ->"), 0,  (Fl_Callback*)cb_Spread_move_right, 0, 0, 0, 0, 10, 56},
 {gettext("Move down"), 0,  (Fl_Callback*)cb_Spread_move_down, 0, 0, 0, 0, 10, 56},
 {gettext("tablefunc"), 0,  (Fl_Callback*)cb_Spread_table, 0, 0, 0, 0, 10, 56},
 {gettext("tableseq"), 0,  (Fl_Callback*)cb_Spread_tableseq, 0, 0, 0, 0, 10, 56},
 {gettext("Fill down"), 0,  (Fl_Callback*)cb_Spread_copy_down, 0, 0, 0, 0, 10, 56},
 {gettext("Fill to right"), 0,  (Fl_Callback*)cb_Spread_copy_right, 0, 0, 0, 0, 10, 56},
 {gettext("to selection"), 0,  (Fl_Callback*)cb_Spread_fill_selection, 0, 0, 0, 0, 12, 56},
 {gettext("fill selection with 0"), 0,  (Fl_Callback*)cb_Spread_fill_0, 0, 0, 0, 0, 12, 56},
 {gettext("Classes"), 0,  (Fl_Callback*)cb_Spread_classes, 0, 0, 0, 0, 10, 56},
 {gettext("Recompute"), 0,  (Fl_Callback*)cb_Spread_recompute, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("prg (Program)"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("Find"), 0x40066,  (Fl_Callback*)cb_Program_find, 0, 0, 0, 0, 10, 56},
 {gettext("Find next"), 0x4006e,  (Fl_Callback*)cb_Program_findnext, 0, 0, 0, 0, 10, 56},
 {gettext("Replace"), 0,  (Fl_Callback*)cb_Program_replace, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Setup"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("Cas setup"), 0,  (Fl_Callback*)cb_Cas_setup, 0, 0, 0, 0, 10, 56},
 {gettext("General setup"), 0,  (Fl_Callback*)cb_General_setup, 0, 0, 0, 0, 10, 56},
 {gettext("Plot setup"), 0,  (Fl_Callback*)cb_Plot_setup, 0, 0, 0, 0, 10, 56},
 {0},
 {0},
 {gettext("Scolaire"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("Tortue"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("Reglages"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("Zoom in"), 0,  (Fl_Callback*)cb_Xcas_tortue_zoomin, 0, 0, 0, 0, 10, 56},
 {gettext("Zoom out"), 0,  (Fl_Callback*)cb_Xcas_tortue_zoomout, 0, 0, 0, 0, 10, 56},
 {gettext("Voir vers la gauche"), 0,  (Fl_Callback*)cb_Xcas_tortue_gauche, 0, 0, 0, 0, 10, 56},
 {gettext("Voir vers la droite"), 0,  (Fl_Callback*)cb_Xcas_tortue_droite, 0, 0, 0, 0, 10, 56},
 {gettext("Voir vers le haut"), 0,  (Fl_Callback*)cb_Xcas_tortue_haut, 0, 0, 0, 0, 10, 56},
 {gettext("Voir vers le bas"), 0,  (Fl_Callback*)cb_Xcas_tortue_bas, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Deplacements"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("avance"), 0,  (Fl_Callback*)cb_Xcas_tortue_avance, 0, 0, 0, 0, 10, 56},
 {gettext("recule"), 0,  (Fl_Callback*)cb_Xcas_tortue_recule, 0, 0, 0, 0, 10, 56},
 {gettext("saute"), 0,  (Fl_Callback*)cb_Xcas_tortue_saute, 0, 0, 0, 0, 10, 56},
 {gettext("pas_de_cote"), 0,  (Fl_Callback*)cb_Xcas_tortue_pas_de_cote, 0, 0, 0, 0, 10, 56},
 {gettext("tourne_droite"), 0,  (Fl_Callback*)cb_Xcas_tortue_tourne_droite, 0, 0, 0, 0, 10, 56},
 {gettext("tourne_gauche"), 0,  (Fl_Callback*)cb_Xcas_tortue_tourne_gauche, 0, 0, 0, 0, 10, 56},
 {gettext("efface"), 0,  (Fl_Callback*)cb_Xcas_tortue_efface0, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Positionner"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("cap"), 0,  (Fl_Callback*)cb_Xcas_tortue_cap, 0, 0, 0, 0, 10, 56},
 {gettext("position"), 0,  (Fl_Callback*)cb_Xcas_tortue_position, 0, 0, 0, 0, 10, 56},
 {gettext("vers"), 0,  (Fl_Callback*)cb_Xcas_tortue_vers, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Formes"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("rond"), 0,  (Fl_Callback*)cb_Xcas_tortue_rond, 0, 0, 0, 0, 10, 56},
 {gettext("disque"), 0,  (Fl_Callback*)cb_Xcas_tortue_disque, 0, 0, 0, 0, 10, 56},
 {gettext("rectangle_plein"), 0,  (Fl_Callback*)cb_Xcas_tortue_rectangle_plein, 0, 0, 0, 0, 10, 56},
 {gettext("triangle_plein"), 0,  (Fl_Callback*)cb_Xcas_tortue_triangle_plein, 0, 0, 0, 0, 10, 56},
 {gettext("polygone_rempli"), 0,  (Fl_Callback*)cb_Xcas_tortue_polygone_rempli, 0, 0, 0, 0, 10, 56},
 {gettext("dessine_tortue"), 0,  (Fl_Callback*)cb_Xcas_tortue_dessine_tortue, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Crayon"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("leve_crayon"), 0,  (Fl_Callback*)cb_Xcas_tortue_leve_crayon, 0, 0, 0, 0, 10, 56},
 {gettext("baisse_crayon"), 0,  (Fl_Callback*)cb_Xcas_tortue_baisse_crayon, 0, 0, 0, 0, 10, 56},
 {gettext("rouge"), 0,  (Fl_Callback*)cb_Xcas_tortue_rouge, 0, 0, 0, 0, 10, 56},
 {gettext("vert"), 0,  (Fl_Callback*)cb_Xcas_tortue_vert, 0, 0, 0, 0, 10, 56},
 {gettext("bleu"), 0,  (Fl_Callback*)cb_Xcas_tortue_bleu, 0, 0, 0, 0, 10, 56},
 {gettext("jaune"), 0,  (Fl_Callback*)cb_Xcas_tortue_jaune, 0, 0, 0, 0, 10, 56},
 {gettext("magenta"), 0,  (Fl_Callback*)cb_Xcas_tortue_magenta, 0, 0, 0, 0, 10, 56},
 {gettext("cyan"), 0,  (Fl_Callback*)cb_Xcas_tortue_cyan, 0, 0, 0, 0, 10, 56},
 {gettext("noir"), 0,  (Fl_Callback*)cb_Xcas_tortue_noir, 0, 0, 0, 0, 10, 56},
 {gettext("blanc"), 0,  (Fl_Callback*)cb_Xcas_tortue_blanc, 0, 0, 0, 0, 10, 56},
 {gettext("gomme"), 0,  (Fl_Callback*)cb_Xcas_tortue_gomme, 0, 0, 0, 0, 10, 56},
 {gettext("crayon"), 0,  (Fl_Callback*)cb_Xcas_tortue_crayon, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Tortue"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("cache_tortue"), 0,  (Fl_Callback*)cb_Xcas_tortue_cache_tortue, 0, 0, 0, 0, 10, 56},
 {gettext("montre_tortue"), 0,  (Fl_Callback*)cb_Xcas_tortue_montre_tortue, 0, 0, 0, 0, 10, 56},
 {gettext("efface"), 0,  (Fl_Callback*)cb_Xcas_tortue_efface, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Programmes"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("repete"), 0,  (Fl_Callback*)cb_Xcas_tortue_repete, 0, 0, 0, 0, 10, 56},
 {gettext("si"), 0,  (Fl_Callback*)cb_Xcas_tortue_si, 0, 0, 0, 0, 10, 56},
 {gettext("pour"), 0,  (Fl_Callback*)cb_Xcas_tortue_pour, 0, 0, 0, 0, 10, 56},
 {gettext("tantque"), 0,  (Fl_Callback*)cb_Xcas_tortue_tantque, 0, 0, 0, 0, 10, 56},
 {gettext("lis"), 0,  (Fl_Callback*)cb_Xcas_tortue_lis, 0, 0, 0, 0, 10, 56},
 {gettext("lis_phrase"), 0,  (Fl_Callback*)cb_Xcas_tortue_lis_phrase, 0, 0, 0, 0, 10, 56},
 {gettext("debut_enregistrement"), 0,  (Fl_Callback*)cb_Xcas_tortue_debut_enregistrement, 0, 0, 0, 0, 10, 56},
 {gettext("fin_enregistrement"), 0,  (Fl_Callback*)cb_Xcas_tortue_fin_enregistrement, 0, 0, 0, 0, 10, 56},
 {gettext("sauve"), 0,  (Fl_Callback*)cb_Xcas_tortue_sauve, 0, 0, 0, 0, 10, 56},
 {gettext("ramene"), 0,  (Fl_Callback*)cb_Xcas_tortue_ramene, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Imprimer"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("vers imprimante"), 0,  (Fl_Callback*)cb_Xcas_tortue_print, 0, 0, 0, 0, 10, 56},
 {gettext("vers fichier postscript"), 0,  (Fl_Callback*)cb_Xcas_tortue_print_ps, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Bonjour et Aurevoir"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("Bonjour"), 0,  (Fl_Callback*)cb_Xcas_tortue_bonjour, 0, 0, 0, 0, 10, 56},
 {gettext("Aurevoir"), 0,  (Fl_Callback*)cb_Xcas_tortue_aurevoir, 0, 0, 0, 0, 10, 56},
 {0},
 {0},
 {gettext("Seconde"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("expand"), 0,  (Fl_Callback*)cb_Xcas_Lycee_Seconde_Expand, 0, 0, 0, 0, 10, 56},
 {gettext("factor"), 0x80066,  (Fl_Callback*)cb_Xcas_Lycee_Seconde_Factor, 0, 0, 0, 0, 10, 56},
 {gettext("left"), 0,  (Fl_Callback*)cb_Xcas_Lycee_Seconde_Left, 0, 0, 0, 0, 10, 56},
 {gettext("right"), 0,  (Fl_Callback*)cb_Xcas_Lycee_Seconde_Right, 0, 0, 0, 0, 10, 56},
 {gettext("solve"), 0,  (Fl_Callback*)cb_Xcas_Lycee_Seconde_Solve, 0, 0, 0, 0, 10, 56},
 {gettext("simplify"), 0x80073,  (Fl_Callback*)cb_Xcas_Lycee_Seconde_Simplify, 0, 0, 0, 0, 10, 56},
 {gettext("subst"), 0,  (Fl_Callback*)cb_Xcas_Lycee_Seconde_Subst, 0, 0, 0, 0, 10, 56},
 {gettext("tablefunc"), 0,  (Fl_Callback*)cb_Xcas_Lycee_Seconde_Tablefunc, 0, 0, 0, 0, 10, 56},
 {gettext("plotfunc"), 0,  (Fl_Callback*)cb_Xcas_Lycee_Seconde_Plotfunc, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Premiere"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("diff"), 0,  (Fl_Callback*)cb_Xcas_Lycee_Premiere_Diff, 0, 0, 0, 0, 10, 56},
 {gettext("mult_conjugate"), 0,  (Fl_Callback*)cb_Xcas_Lycee_Seconde_Mult_conjugate, 0, 0, 0, 0, 10, 56},
 {gettext("limit"), 0,  (Fl_Callback*)cb_Xcas_Lycee_Premiere_Limit, 0, 0, 0, 0, 10, 56},
 {gettext("tangent"), 0,  (Fl_Callback*)cb_Xcas_Lycee_Premiere_Tangent, 0, 0, 0, 0, 10, 56},
 {gettext("LineTan"), 0,  (Fl_Callback*)cb_Xcas_Lycee_Premiere_Linetan, 0, 0, 0, 0, 10, 56},
 {gettext("tableseq"), 0,  (Fl_Callback*)cb_Xcas_Lycee_Seconde_Tableseq, 0, 0, 0, 0, 10, 56},
 {gettext("plotseq"), 0,  (Fl_Callback*)cb_Xcas_Lycee_Seconde_Plotseq, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Terminale"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("cFactor"), 0,  (Fl_Callback*)cb_Xcas_Lycee_Terminale_cFactor, 0, 0, 0, 0, 10, 56},
 {gettext("integrate"), 0,  (Fl_Callback*)cb_Xcas_Lycee_Terminale_Integrate, 0, 0, 0, 0, 10, 56},
 {gettext("mult_c_conjugate"), 0,  (Fl_Callback*)cb_Xcas_Lycee_Terminale_Mult_c_conjugate, 0, 0, 0, 0, 10, 56},
 {gettext("cSolve"), 0,  (Fl_Callback*)cb_Xcas_Lycee_Terminale_cSolve, 0, 0, 0, 0, 10, 56},
 {gettext("plotparam"), 0,  (Fl_Callback*)cb_Xcas_Lycee_Terminale_Plotparam, 0, 0, 0, 0, 10, 56},
 {gettext("plotpolar"), 0,  (Fl_Callback*)cb_Xcas_Lycee_Terminale_Plotpolar, 0, 0, 0, 0, 10, 56},
 {0},
 {0},
 {gettext("Math"), 0,  (Fl_Callback*)cb_Maths, 0, 64, 0, 0, 10, 56},
 {gettext("Constants"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("pi"), 0,  (Fl_Callback*)cb_Pi, 0, 0, 0, 0, 10, 56},
 {gettext("i"), 0,  (Fl_Callback*)cb_Constante_i, 0, 0, 0, 0, 10, 56},
 {gettext("e"), 0,  (Fl_Callback*)cb_Constante_e, 0, 0, 0, 0, 10, 56},
 {gettext("+infinity"), 0,  (Fl_Callback*)cb_Plus_infinity, 0, 0, 0, 0, 10, 56},
 {gettext("-infinity"), 0,  (Fl_Callback*)cb_Minus_infinity, 0, 0, 0, 0, 10, 56},
 {gettext("infinity"), 0,  (Fl_Callback*)cb_Infinity, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Integer"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("euler"), 0,  (Fl_Callback*)cb_Euler, 0, 0, 0, 0, 10, 56},
 {gettext("fracmod"), 0,  (Fl_Callback*)cb_Fracmod, 0, 0, 0, 0, 10, 56},
 {gettext("gcd"), 0,  (Fl_Callback*)cb_Gcd, 0, 0, 0, 0, 10, 56},
 {gettext("iabcuv"), 0,  (Fl_Callback*)cb_Iabcuv, 0, 0, 0, 0, 10, 56},
 {gettext("ichinrem"), 0,  (Fl_Callback*)cb_Ichinrem, 0, 0, 0, 0, 10, 56},
 {gettext("idivis"), 0,  (Fl_Callback*)cb_Idivis, 0, 0, 0, 0, 10, 56},
 {gettext("iegcd"), 0,  (Fl_Callback*)cb_Iegcd, 0, 0, 0, 0, 10, 56},
 {gettext("ifactor"), 0,  (Fl_Callback*)cb_Ifactor, 0, 0, 0, 0, 10, 56},
 {gettext("ifactors"), 0,  (Fl_Callback*)cb_Ifactors, 0, 0, 0, 0, 10, 56},
 {gettext("iquo"), 0,  (Fl_Callback*)cb_Iquo, 0, 0, 0, 0, 10, 56},
 {gettext("iquorem"), 0,  (Fl_Callback*)cb_Iquorem, 0, 0, 0, 0, 10, 56},
 {gettext("irem"), 0,  (Fl_Callback*)cb_Irem, 0, 0, 0, 0, 10, 56},
 {gettext("is_prime"), 0,  (Fl_Callback*)cb_Is_prime, 0, 0, 0, 0, 10, 56},
 {gettext("is_pseudoprime"), 0,  (Fl_Callback*)cb_Is_pseudoprime, 0, 0, 0, 0, 10, 56},
 {gettext("lcm"), 0,  (Fl_Callback*)cb_Lcm, 0, 0, 0, 0, 10, 56},
 {gettext("mod"), 0,  (Fl_Callback*)cb_Modulo, 0, 0, 0, 0, 10, 56},
 {gettext("nextprime"), 0,  (Fl_Callback*)cb_Nextprime, 0, 0, 0, 0, 10, 56},
 {gettext("pa2b2"), 0,  (Fl_Callback*)cb_Pa2b2, 0, 0, 0, 0, 10, 56},
 {gettext("powmod"), 0,  (Fl_Callback*)cb_Powmod, 0, 0, 0, 0, 10, 56},
 {gettext("prevprime"), 0,  (Fl_Callback*)cb_Prevprime, 0, 0, 0, 0, 10, 56},
 {gettext("smod"), 0,  (Fl_Callback*)cb_Smod, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Real"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("abs"), 0,  (Fl_Callback*)cb_Abs, 0, 0, 0, 0, 10, 56},
 {gettext("ceil"), 0,  (Fl_Callback*)cb_Ceil, 0, 0, 0, 0, 10, 56},
 {gettext("factorial"), 0,  (Fl_Callback*)cb_Factorial, 0, 0, 0, 0, 10, 56},
 {gettext("floor"), 0,  (Fl_Callback*)cb_Floor, 0, 0, 0, 0, 10, 56},
 {gettext("frac"), 0,  (Fl_Callback*)cb_Frac, 0, 0, 0, 0, 10, 56},
 {gettext("max"), 0,  (Fl_Callback*)cb_Max, 0, 0, 0, 0, 10, 56},
 {gettext("min"), 0,  (Fl_Callback*)cb_Min, 0, 0, 0, 0, 10, 56},
 {gettext("round"), 0,  (Fl_Callback*)cb_Xcas_Round, 0, 0, 0, 0, 10, 56},
 {gettext("sign"), 0,  (Fl_Callback*)cb_Sign, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Complex"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("re"), 0,  (Fl_Callback*)cb_Real_part, 0, 0, 0, 0, 10, 56},
 {gettext("im"), 0,  (Fl_Callback*)cb_Imaginary_part, 0, 0, 0, 0, 10, 56},
 {gettext("evalc"), 0,  (Fl_Callback*)cb_Evalc_item, 0, 0, 0, 0, 10, 56},
 {gettext("conj"), 0,  (Fl_Callback*)cb_Conjugate, 0, 0, 0, 0, 10, 56},
 {gettext("mult_c_conjugate"), 0,  (Fl_Callback*)cb_Mult_c_conjugate, 0, 0, 0, 0, 10, 56},
 {gettext("abs"), 0,  (Fl_Callback*)cb_Complex_modulus, 0, 0, 0, 0, 10, 56},
 {gettext("arg"), 0,  (Fl_Callback*)cb_Argument, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Transcendental"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("Expln"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("10^"), 0,  (Fl_Callback*)cb_Alogarithm10, 0, 0, 0, 0, 10, 56},
 {gettext("exp"), 0,  (Fl_Callback*)cb_Exponential, 0, 0, 0, 0, 10, 56},
 {gettext("log"), 0,  (Fl_Callback*)cb_Logarithm, 0, 0, 0, 0, 10, 56},
 {gettext("log10"), 0,  (Fl_Callback*)cb_Logarithm10, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Hyp"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("tanh"), 0,  (Fl_Callback*)cb_Tanh, 0, 0, 0, 0, 10, 56},
 {gettext("sinh"), 0,  (Fl_Callback*)cb_Sinh, 0, 0, 0, 0, 10, 56},
 {gettext("cosh"), 0,  (Fl_Callback*)cb_Cosh, 0, 0, 0, 0, 10, 56},
 {gettext("atanh"), 0,  (Fl_Callback*)cb_Argtanh, 0, 0, 0, 0, 10, 56},
 {gettext("asinh"), 0,  (Fl_Callback*)cb_Argsinh, 0, 0, 0, 0, 10, 56},
 {gettext("acosh"), 0,  (Fl_Callback*)cb_Argcosh, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Trig"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("acos"), 0,  (Fl_Callback*)cb_Arccos, 0, 0, 0, 0, 10, 56},
 {gettext("asin"), 0,  (Fl_Callback*)cb_Arcsin, 0, 0, 0, 0, 10, 56},
 {gettext("atan"), 0,  (Fl_Callback*)cb_Arctangent, 0, 0, 0, 0, 10, 56},
 {gettext("cos"), 0,  (Fl_Callback*)cb_Cos, 0, 0, 0, 0, 10, 56},
 {gettext("sin"), 0,  (Fl_Callback*)cb_Sin, 0, 0, 0, 0, 10, 56},
 {gettext("tan"), 0,  (Fl_Callback*)cb_Tangent, 0, 0, 0, 0, 10, 56},
 {gettext("acot"), 0,  (Fl_Callback*)cb_Arccot, 0, 0, 0, 0, 10, 56},
 {gettext("acsc"), 0,  (Fl_Callback*)cb_Arccsc, 0, 0, 0, 0, 10, 56},
 {gettext("asec"), 0,  (Fl_Callback*)cb_Arcsec, 0, 0, 0, 0, 10, 56},
 {gettext("csc"), 0,  (Fl_Callback*)cb_Csc, 0, 0, 0, 0, 10, 56},
 {gettext("sec"), 0,  (Fl_Callback*)cb_Sec, 0, 0, 0, 0, 10, 56},
 {gettext("cot"), 0,  (Fl_Callback*)cb_Cotangent, 0, 0, 0, 0, 10, 56},
 {0},
 {0},
 {gettext("Rewrite"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("collect"), 0,  (Fl_Callback*)cb_Collect, 0, 0, 0, 0, 10, 56},
 {gettext("eval"), 0,  (Fl_Callback*)cb_Eval_item, 0, 0, 0, 0, 10, 56},
 {gettext("equal2diff"), 0,  (Fl_Callback*)cb_Equal2diff, 0, 0, 0, 0, 10, 56},
 {gettext("f2nd"), 0,  (Fl_Callback*)cb_F2nd, 0, 0, 0, 0, 10, 56},
 {gettext("factor"), 0x80066,  (Fl_Callback*)cb_Factor, 0, 0, 0, 0, 10, 56},
 {gettext("mult_conjugate"), 0,  (Fl_Callback*)cb_Mult_conjugate, 0, 0, 0, 0, 10, 56},
 {gettext("normal"), 0x8006e,  (Fl_Callback*)cb_Normal, 0, 0, 0, 0, 10, 56},
 {gettext("ratnormal"), 0x80073,  (Fl_Callback*)cb_Ratnormal, 0, 0, 0, 0, 10, 56},
 {gettext("reorder"), 0,  (Fl_Callback*)cb_Reorder, 0, 0, 0, 0, 10, 56},
 {gettext("partfrac"), 0,  (Fl_Callback*)cb_Partfrac, 0, 0, 0, 0, 10, 56},
 {gettext("simp2"), 0,  (Fl_Callback*)cb_simp2, 0, 0, 0, 0, 10, 56},
 {gettext("simplifier"), 0,  (Fl_Callback*)cb_Simplifier, 0, 0, 0, 0, 10, 56},
 {gettext("simplify"), 0x80073,  (Fl_Callback*)cb_Simplify, 0, 0, 0, 0, 10, 56},
 {gettext("subst"), 0,  (Fl_Callback*)cb_Subst, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Rew_trig_exp"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("exp2pow"), 0,  (Fl_Callback*)cb_Exp2pow, 0, 0, 0, 0, 10, 56},
 {gettext("exp2trig"), 0,  (Fl_Callback*)cb_Exp2trig, 0, 0, 0, 0, 10, 56},
 {gettext("hyp2exp"), 0,  (Fl_Callback*)cb_Hyp2exp, 0, 0, 0, 0, 10, 56},
 {gettext("lin"), 0,  (Fl_Callback*)cb_Lin, 0, 0, 0, 0, 10, 56},
 {gettext("lncollect"), 0,  (Fl_Callback*)cb_Lncollect, 0, 0, 0, 0, 10, 56},
 {gettext("powexpand"), 0,  (Fl_Callback*)cb_Powexpand, 0, 0, 0, 0, 10, 56},
 {gettext("trig2exp"), 0,  (Fl_Callback*)cb_Trig2exp, 0, 0, 0, 0, 10, 56},
 {gettext("tsimplify"), 0,  (Fl_Callback*)cb_Tsimplify, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Rew_inv_trig"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("acos2asin"), 0,  (Fl_Callback*)cb_Acos2asin, 0, 0, 0, 0, 10, 56},
 {gettext("acos2atan"), 0,  (Fl_Callback*)cb_Acos2atan, 0, 0, 0, 0, 10, 56},
 {gettext("asin2acos"), 0,  (Fl_Callback*)cb_Asin2acos, 0, 0, 0, 0, 10, 56},
 {gettext("asin2atan"), 0,  (Fl_Callback*)cb_Asin2atan, 0, 0, 0, 0, 10, 56},
 {gettext("atan2acos"), 0,  (Fl_Callback*)cb_Atan2acos, 0, 0, 0, 0, 10, 56},
 {gettext("atan2asin"), 0,  (Fl_Callback*)cb_Atan2asin, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Rew_trig"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("halftan"), 0,  (Fl_Callback*)cb_Halftan, 0, 0, 0, 0, 10, 56},
 {gettext("tan2sincos"), 0,  (Fl_Callback*)cb_Tan2sincos, 0, 0, 0, 0, 10, 56},
 {gettext("tan2cossin2"), 0,  (Fl_Callback*)cb_Tan2cossin2, 0, 0, 0, 0, 10, 56},
 {gettext("tan2sincos2"), 0,  (Fl_Callback*)cb_Tan2sincos2, 0, 0, 0, 0, 10, 56},
 {gettext("tcollect"), 0,  (Fl_Callback*)cb_Tcollect, 0, 0, 0, 0, 10, 56},
 {gettext("texpand"), 0,  (Fl_Callback*)cb_Texpand2, 0, 0, 0, 0, 10, 56},
 {gettext("tlin"), 0,  (Fl_Callback*)cb_Tlin2, 0, 0, 0, 0, 10, 56},
 {gettext("trigcos"), 0,  (Fl_Callback*)cb_Trigcos, 0, 0, 0, 0, 10, 56},
 {gettext("trigsin"), 0,  (Fl_Callback*)cb_Trigsin, 0, 0, 0, 0, 10, 56},
 {gettext("trigtan"), 0,  (Fl_Callback*)cb_Trigtan, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Proba"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("binomial"), 0,  (Fl_Callback*)cb_Binomial, 0, 0, 0, 0, 10, 56},
 {gettext("perm"), 0,  (Fl_Callback*)cb_Perm, 0, 0, 0, 0, 10, 56},
 {gettext("rand"), 0,  (Fl_Callback*)cb_Rand, 0, 0, 0, 0, 10, 56},
 {gettext("randnorm"), 0,  (Fl_Callback*)cb_Randnorm, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Stats"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("1-d"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("center2interval"), 0,  (Fl_Callback*)cb_Center2interval, 0, 0, 0, 0, 10, 56},
 {gettext("cumulated_frequencies"), 0,  (Fl_Callback*)cb_Cumulated_frequencies, 0, 0, 0, 0, 10, 56},
 {gettext("histogram"), 0,  (Fl_Callback*)cb_Histogram, 0, 0, 0, 0, 10, 56},
 {gettext("interval2center"), 0,  (Fl_Callback*)cb_Interval2center, 0, 0, 0, 0, 10, 56},
 {gettext("mean"), 0,  (Fl_Callback*)cb_Mean, 0, 0, 0, 0, 10, 56},
 {gettext("median"), 0,  (Fl_Callback*)cb_Median, 0, 0, 0, 0, 10, 56},
 {gettext("moustache"), 0,  (Fl_Callback*)cb_Moustache, 0, 0, 0, 0, 10, 56},
 {gettext("quartiles"), 0,  (Fl_Callback*)cb_Quartiles, 0, 0, 0, 0, 10, 56},
 {gettext("quartile1"), 0,  (Fl_Callback*)cb_Quartile1, 0, 0, 0, 0, 10, 56},
 {gettext("quartile3"), 0,  (Fl_Callback*)cb_Quartile3, 0, 0, 0, 0, 10, 56},
 {gettext("sum"), 0,  (Fl_Callback*)cb_StatsSum, 0, 0, 0, 0, 10, 56},
 {gettext("stddev"), 0,  (Fl_Callback*)cb_Stddev, 0, 0, 0, 0, 10, 56},
 {gettext("variance"), 0,  (Fl_Callback*)cb_Variance, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("2-d"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("covariance"), 0,  (Fl_Callback*)cb_Covariance, 0, 0, 0, 0, 10, 56},
 {gettext("correlation"), 0,  (Fl_Callback*)cb_Correlation, 0, 0, 0, 0, 10, 56},
 {gettext("exponential_regression"), 0,  (Fl_Callback*)cb_Exponential_regression, 0, 0, 0, 0, 10, 56},
 {gettext("linear_regression"), 0,  (Fl_Callback*)cb_Linear_regression, 0, 0, 0, 0, 10, 56},
 {gettext("logarithmic_regression"), 0,  (Fl_Callback*)cb_Logarithmic_regression, 0, 0, 0, 0, 10, 56},
 {gettext("polygonplot"), 0,  (Fl_Callback*)cb_Polygonplot, 0, 0, 0, 0, 10, 56},
 {gettext("polynomial_regression"), 0,  (Fl_Callback*)cb_Polynomial_regression, 0, 0, 0, 0, 10, 56},
 {gettext("power_regression"), 0,  (Fl_Callback*)cb_Power_regression, 0, 0, 0, 0, 10, 56},
 {gettext("scatterplot"), 0,  (Fl_Callback*)cb_Scatterplot, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Distributions"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("binomial"), 0,  (Fl_Callback*)cb_Binomial_distribution, 0, 0, 0, 0, 10, 56},
 {gettext("binomial_cdf"), 0,  (Fl_Callback*)cb_Binomial_cdf_distribution, 0, 0, 0, 0, 10, 56},
 {gettext("binomial_icdf"), 0,  (Fl_Callback*)cb_Binomial_icdf_distribution, 0, 0, 0, 0, 10, 56},
 {gettext("chisquare"), 0,  (Fl_Callback*)cb_Chisquare_distribution, 0, 0, 0, 0, 10, 56},
 {gettext("chisquare_cdf"), 0,  (Fl_Callback*)cb_Chisquare_cdf_distribution, 0, 0, 0, 0, 10, 56},
 {gettext("chisquare_icdf"), 0,  (Fl_Callback*)cb_Chisquare_icdf_distribution, 0, 0, 0, 0, 10, 56},
 {gettext("fisher"), 0,  (Fl_Callback*)cb_Fisher_distribution, 0, 0, 0, 0, 10, 56},
 {gettext("fisher_cdf"), 0,  (Fl_Callback*)cb_Fisher_cdf_distribution, 0, 0, 0, 0, 10, 56},
 {gettext("fisher_icdf"), 0,  (Fl_Callback*)cb_Fisher_icdf_distribution, 0, 0, 0, 0, 10, 56},
 {gettext("normald"), 0,  (Fl_Callback*)cb_Normald_distribution, 0, 0, 0, 0, 10, 56},
 {gettext("normald_cdf"), 0,  (Fl_Callback*)cb_Normald_cdf_distribution, 0, 0, 0, 0, 10, 56},
 {gettext("normald_icdf"), 0,  (Fl_Callback*)cb_Normald_icdf_distribution, 0, 0, 0, 0, 10, 56},
 {gettext("poisson"), 0,  (Fl_Callback*)cb_Poisson_distribution, 0, 0, 0, 0, 10, 56},
 {gettext("poisson_cdf"), 0,  (Fl_Callback*)cb_Poisson_cdf_distribution, 0, 0, 0, 0, 10, 56},
 {gettext("poisson_icdf"), 0,  (Fl_Callback*)cb_Poisson_icdf_distribution, 0, 0, 0, 0, 10, 56},
 {gettext("student"), 0,  (Fl_Callback*)cb_Student_distribution, 0, 0, 0, 0, 10, 56},
 {gettext("student_cdf"), 0,  (Fl_Callback*)cb_Student_cdf_distribution, 0, 0, 0, 0, 10, 56},
 {gettext("student_icdf"), 0,  (Fl_Callback*)cb_Student_icdf_distribution, 0, 0, 0, 0, 10, 56},
 {gettext("UTPC"), 0,  (Fl_Callback*)cb_UTPC_distribution, 0, 0, 0, 0, 10, 56},
 {gettext("UTPF"), 0,  (Fl_Callback*)cb_UTPF_distribution, 0, 0, 0, 0, 10, 56},
 {gettext("UTPN"), 0,  (Fl_Callback*)cb_UTPN_distribution, 0, 0, 0, 0, 10, 56},
 {gettext("UTPT"), 0,  (Fl_Callback*)cb_UTPT_distribution, 0, 0, 0, 0, 10, 56},
 {0},
 {0},
 {gettext("Plot"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("erase"), 0,  (Fl_Callback*)cb_Plot_erase, 0, 0, 0, 0, 10, 56},
 {gettext("plot"), 0x80070,  (Fl_Callback*)cb_Plot_menub, 0, 0, 0, 0, 10, 56},
 {gettext("plotcontour"), 0,  (Fl_Callback*)cb_Plotcontour_menub, 0, 0, 0, 0, 10, 56},
 {gettext("plotfield"), 0,  (Fl_Callback*)cb_Plotfield_menub, 0, 0, 0, 0, 10, 56},
 {gettext("plotfunc"), 0,  (Fl_Callback*)cb_Plotfunc_menub, 0, 0, 0, 0, 10, 56},
 {gettext("plotimplicit"), 0,  (Fl_Callback*)cb_Plotimplicit_menub, 0, 0, 0, 0, 10, 56},
 {gettext("interactive_odeplot"), 0,  (Fl_Callback*)cb_Interactive_Plotode_menub, 0, 0, 0, 0, 10, 56},
 {gettext("plotode"), 0,  (Fl_Callback*)cb_Plotode_menub, 0, 0, 0, 0, 10, 56},
 {gettext("plotparam"), 0,  (Fl_Callback*)cb_Plotparam_menub, 0, 0, 0, 0, 10, 56},
 {gettext("plotpolar"), 0,  (Fl_Callback*)cb_Plotpolar_menub, 0, 0, 0, 0, 10, 56},
 {gettext("plotseq"), 0,  (Fl_Callback*)cb_Plotseq_menub, 0, 0, 0, 0, 10, 56},
 {gettext("Plot_setup"), 0,  (Fl_Callback*)cb_Plot_setup_menub, 0, 0, 0, 0, 10, 56},
 {gettext("Plot selection"), 0,  (Fl_Callback*)cb_Plot_selection, 0, 0, 0, 0, 10, 56},
 {gettext("graph2tex"), 0,  (Fl_Callback*)cb_Graph2tex2, 0, 0, 0, 0, 10, 56},
 {gettext("graph3d2tex"), 0,  (Fl_Callback*)cb_Graph3d2tex2, 0, 0, 0, 0, 10, 56},
 {gettext("switch_axes"), 0,  (Fl_Callback*)cb_Plot_switch_axes, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Vect"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("abs"), 0,  (Fl_Callback*)cb_Vector_abs, 0, 0, 0, 0, 10, 56},
 {gettext("cross"), 0,  (Fl_Callback*)cb_Cross, 0, 0, 0, 0, 10, 56},
 {gettext("dot"), 0,  (Fl_Callback*)cb_Dot, 0, 0, 0, 0, 10, 56},
 {gettext("l2norm"), 0,  (Fl_Callback*)cb_Vector_l2norm, 0, 0, 0, 0, 10, 56},
 {gettext("maxnorm"), 0,  (Fl_Callback*)cb_Vector_maxnorm, 0, 0, 0, 0, 10, 56},
 {0},
 {0},
 {gettext("Geo"), 0,  (Fl_Callback*)cb_Geometrie, 0, 64, 0, 0, 10, 56},
 {gettext("Gestion"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("display 2d to hist"), 0,  (Fl_Callback*)cb_Xcas_Graph2tex, 0, 0, 0, 0, 10, 56},
 {gettext("display 3d to hist"), 0,  (Fl_Callback*)cb_Xcas_Graph3d2tex, 0, 0, 0, 0, 10, 56},
 {gettext("ClrGraph"), 0,  (Fl_Callback*)cb_Geo_ClrGraph, 0, 0, 0, 0, 10, 56},
 {gettext("erase"), 0,  (Fl_Callback*)cb_Geo_erase, 0, 0, 0, 0, 10, 56},
 {gettext("erase3d"), 0,  (Fl_Callback*)cb_Geo_erase3d, 0, 0, 0, 0, 10, 56},
 {gettext("couleur"), 0,  (Fl_Callback*)cb_Geo_couleur, 0, 0, 0, 0, 10, 56},
 {gettext("legende"), 0,  (Fl_Callback*)cb_Geo_legende, 0, 0, 0, 0, 10, 56},
 {gettext("switch_axes"), 0,  (Fl_Callback*)cb_Geo_switch_axes, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Points"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("barycentre"), 0,  (Fl_Callback*)cb_Geo_barycentre, 0, 0, 0, 0, 10, 56},
 {gettext("centre"), 0,  (Fl_Callback*)cb_Geo_centre, 0, 0, 0, 0, 10, 56},
 {gettext("element"), 0,  (Fl_Callback*)cb_Geo_element, 0, 0, 0, 0, 10, 56},
 {gettext("inter"), 0,  (Fl_Callback*)cb_Geo_inter, 0, 0, 0, 0, 10, 56},
 {gettext("isobarycentre"), 0,  (Fl_Callback*)cb_Geo_isobarycentre, 0, 0, 0, 0, 10, 56},
 {gettext("milieu"), 0,  (Fl_Callback*)cb_Geo_milieu, 0, 0, 0, 0, 10, 56},
 {gettext("point"), 0,  (Fl_Callback*)cb_Geo_point, 0, 0, 0, 0, 10, 56},
 {gettext("point2d"), 0,  (Fl_Callback*)cb_Geo_point2d, 0, 0, 0, 0, 10, 56},
 {gettext("point3d"), 0,  (Fl_Callback*)cb_Geo_point3d, 0, 0, 0, 0, 10, 56},
 {gettext("sommets"), 0,  (Fl_Callback*)cb_Geo_sommets, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Lines"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("aretes"), 0,  (Fl_Callback*)cb_Geo_aretes, 0, 0, 0, 0, 10, 56},
 {gettext("bissectrice"), 0,  (Fl_Callback*)cb_Geo_bissectrice, 0, 0, 0, 0, 10, 56},
 {gettext("demi_droite"), 0,  (Fl_Callback*)cb_Geo_demi_droite, 0, 0, 0, 0, 10, 56},
 {gettext("droite"), 0,  (Fl_Callback*)cb_Geo_droite, 0, 0, 0, 0, 10, 56},
 {gettext("enveloppe"), 0,  (Fl_Callback*)cb_Geo_enveloppe, 0, 0, 0, 0, 10, 56},
 {gettext("exbissectrice"), 0,  (Fl_Callback*)cb_Geo_exbissectrice, 0, 0, 0, 0, 10, 56},
 {gettext("hauteur"), 0,  (Fl_Callback*)cb_Geo_hauteur, 0, 0, 0, 0, 10, 56},
 {gettext("lieu"), 0,  (Fl_Callback*)cb_Geo_lieu, 0, 0, 0, 0, 10, 56},
 {gettext("LineTan"), 0,  (Fl_Callback*)cb_Geo_LineTan, 0, 0, 0, 0, 10, 56},
 {gettext("mediane"), 0,  (Fl_Callback*)cb_Geo_mediane, 0, 0, 0, 0, 10, 56},
 {gettext("mediatrice"), 0,  (Fl_Callback*)cb_Geo_mediatrice, 0, 0, 0, 0, 10, 56},
 {gettext("parallele"), 0,  (Fl_Callback*)cb_Geo_parallele, 0, 0, 0, 0, 10, 56},
 {gettext("perpendiculaire"), 0,  (Fl_Callback*)cb_Geo_perpendiculaire, 0, 0, 0, 0, 10, 56},
 {gettext("perpendiculaire_commune"), 0,  (Fl_Callback*)cb_Geo_perpendiculaire_commune, 0, 0, 0, 0, 10, 56},
 {gettext("segment"), 0,  (Fl_Callback*)cb_Geo_segment, 0, 0, 0, 0, 10, 56},
 {gettext("tangent"), 0,  (Fl_Callback*)cb_Geo_tangent, 0, 0, 0, 0, 10, 56},
 {gettext("funcplot"), 0,  (Fl_Callback*)cb_Geo_funcplot, 0, 0, 0, 0, 10, 56},
 {gettext("paramplot"), 0,  (Fl_Callback*)cb_Geo_paramplot, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Triangles"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("triangle"), 0,  (Fl_Callback*)cb_Geo_triangle, 0, 0, 0, 0, 10, 56},
 {gettext("triangle_equilateral"), 0,  (Fl_Callback*)cb_Geo_triangle_equilateral, 0, 0, 0, 0, 10, 56},
 {gettext("triangle_isocele"), 0,  (Fl_Callback*)cb_Geo_triangle_isocele, 0, 0, 0, 0, 10, 56},
 {gettext("triangle_rectangle"), 0,  (Fl_Callback*)cb_Geo_triangle_rectangle, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Quadrilaterals"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("carre"), 0,  (Fl_Callback*)cb_Geo_carre, 0, 0, 0, 0, 10, 56},
 {gettext("losange"), 0,  (Fl_Callback*)cb_Geo_losange, 0, 0, 0, 0, 10, 56},
 {gettext("parallelogramme"), 0,  (Fl_Callback*)cb_Geo_parallelogramme, 0, 0, 0, 0, 10, 56},
 {gettext("quadrilatere"), 0,  (Fl_Callback*)cb_Geo_quadrilatere, 0, 0, 0, 0, 10, 56},
 {gettext("rectangle"), 0,  (Fl_Callback*)cb_Geo_rectangle, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Polygones"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("isopolygone"), 0,  (Fl_Callback*)cb_Geo_isopolygone, 0, 0, 0, 0, 10, 56},
 {gettext("polygone"), 0,  (Fl_Callback*)cb_Geo_polygone, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Circles"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("arc"), 0,  (Fl_Callback*)cb_Geo_arc, 0, 0, 0, 0, 10, 56},
 {gettext("cercle"), 0,  (Fl_Callback*)cb_Geo_cercle, 0, 0, 0, 0, 10, 56},
 {gettext("circonscrit"), 0,  (Fl_Callback*)cb_Geo_circonscrit, 0, 0, 0, 0, 10, 56},
 {gettext("exinscrit"), 0,  (Fl_Callback*)cb_Geo_exinscrit, 0, 0, 0, 0, 10, 56},
 {gettext("inscrit"), 0,  (Fl_Callback*)cb_Geo_inscrit, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Conic sections"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("cercle"), 0,  (Fl_Callback*)cb_Geo_cercle2, 0, 0, 0, 0, 10, 56},
 {gettext("ellipse"), 0,  (Fl_Callback*)cb_Geo_ellipse, 0, 0, 0, 0, 10, 56},
 {gettext("hyperbole"), 0,  (Fl_Callback*)cb_Geo_hyperbole, 0, 0, 0, 0, 10, 56},
 {gettext("parabole"), 0,  (Fl_Callback*)cb_Geo_parabole, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Surfaces"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("cone"), 0,  (Fl_Callback*)cb_Xcas_geo_cone, 0, 0, 0, 0, 10, 56},
 {gettext("cylindre"), 0,  (Fl_Callback*)cb_Xcas_geo_cylindre, 0, 0, 0, 0, 10, 56},
 {gettext("demi_cone"), 0,  (Fl_Callback*)cb_Xcas_geo_demi_cone, 0, 0, 0, 0, 10, 56},
 {gettext("plan"), 0,  (Fl_Callback*)cb_Xcas_geo_plan, 0, 0, 0, 0, 10, 56},
 {gettext("sphere"), 0,  (Fl_Callback*)cb_Xcas_geo_sphere, 0, 0, 0, 0, 10, 56},
 {gettext("funcplot"), 0,  (Fl_Callback*)cb_Xcas_geo_funcplot, 0, 0, 0, 0, 10, 56},
 {gettext("paramplot"), 0,  (Fl_Callback*)cb_Xcas_geo_paramplot, 0, 0, 0, 0, 10, 56},
 {gettext("mediatrice"), 0,  (Fl_Callback*)cb_Xcas_geo_mediatrice, 0, 0, 0, 0, 10, 56},
 {gettext("tangent"), 0,  (Fl_Callback*)cb_Xcas_geo_tangent, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Solides"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("cube"), 0,  (Fl_Callback*)cb_Xcas_geo_cube2, 0, 0, 0, 0, 10, 56},
 {gettext("pyramide"), 0,  (Fl_Callback*)cb_Xcas_geo_pyramide, 0, 0, 0, 0, 10, 56},
 {gettext("parallelepipede"), 0,  (Fl_Callback*)cb_Xcas_geo_parallelepipede, 0, 0, 0, 0, 10, 56},
 {gettext("polyedre"), 0,  (Fl_Callback*)cb_Xcas_geo_polyedre, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Solides_Platon"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("tetraedre_centre"), 0,  (Fl_Callback*)cb_Xcas_geo_tetraedre_centre, 0, 0, 0, 0, 10, 56},
 {gettext("cube_centre"), 0,  (Fl_Callback*)cb_Xcas_geo_cube_centre, 0, 0, 0, 0, 10, 56},
 {gettext("octaedre"), 0,  (Fl_Callback*)cb_Xcas_geo_octaedre, 0, 0, 0, 0, 10, 56},
 {gettext("dodecaedre"), 0,  (Fl_Callback*)cb_Xcas_geo_dodecaedre, 0, 0, 0, 0, 10, 56},
 {gettext("icosaedre"), 0,  (Fl_Callback*)cb_Xcas_geo_icosaedre, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Mesures"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("abs"), 0,  (Fl_Callback*)cb_Geo_abs, 0, 0, 0, 0, 10, 56},
 {gettext("abscisse"), 0,  (Fl_Callback*)cb_Geo_abscisse, 0, 0, 0, 0, 10, 56},
 {gettext("affixe"), 0,  (Fl_Callback*)cb_Geo_affixe, 0, 0, 0, 0, 10, 56},
 {gettext("aire"), 0,  (Fl_Callback*)cb_Geo_aire, 0, 0, 0, 0, 10, 56},
 {gettext("angle"), 0,  (Fl_Callback*)cb_Geo_angle, 0, 0, 0, 0, 10, 56},
 {gettext("arg"), 0,  (Fl_Callback*)cb_Geo_arg, 0, 0, 0, 0, 10, 56},
 {gettext("cote"), 0,  (Fl_Callback*)cb_Geo_cote, 0, 0, 0, 0, 10, 56},
 {gettext("coordonnees"), 0,  (Fl_Callback*)cb_Geo_coordonnees, 0, 0, 0, 0, 10, 56},
 {gettext("equation"), 0,  (Fl_Callback*)cb_Geo_equation, 0, 0, 0, 0, 10, 56},
 {gettext("longueur"), 0,  (Fl_Callback*)cb_Geo_longueur, 0, 0, 0, 0, 10, 56},
 {gettext("longueur2"), 0,  (Fl_Callback*)cb_Geo_longueur2, 0, 0, 0, 0, 10, 56},
 {gettext("ordonnee"), 0,  (Fl_Callback*)cb_Geo_ordonnee, 0, 0, 0, 0, 10, 56},
 {gettext("parameq"), 0,  (Fl_Callback*)cb_Geo_parameq, 0, 0, 0, 0, 10, 56},
 {gettext("rayon"), 0,  (Fl_Callback*)cb_Geo_rayon, 0, 0, 0, 0, 10, 56},
 {gettext("scalar_product"), 0,  (Fl_Callback*)cb_Geo_scalar_product, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Transformations"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("homothetie"), 0,  (Fl_Callback*)cb_Geo_homothetie, 0, 0, 0, 0, 10, 56},
 {gettext("inversion"), 0,  (Fl_Callback*)cb_Geo_inversion, 0, 0, 0, 0, 10, 56},
 {gettext("projection"), 0,  (Fl_Callback*)cb_Geo_projection, 0, 0, 0, 0, 10, 56},
 {gettext("rotation"), 0,  (Fl_Callback*)cb_Geo_rotation, 0, 0, 0, 0, 10, 56},
 {gettext("similitude"), 0,  (Fl_Callback*)cb_Geo_similitude, 0, 0, 0, 0, 10, 56},
 {gettext("symetrie"), 0,  (Fl_Callback*)cb_Geo_symetrie, 0, 0, 0, 0, 10, 56},
 {gettext("translation"), 0,  (Fl_Callback*)cb_Geo_translation, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Properties"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("est_aligne"), 0,  (Fl_Callback*)cb_Geo_est_aligne, 0, 0, 0, 0, 10, 56},
 {gettext("est_cocyclique"), 0,  (Fl_Callback*)cb_Geo_est_cocyclique, 0, 0, 0, 0, 10, 56},
 {gettext("est_coplanaire"), 0,  (Fl_Callback*)cb_Geo_est_coplanaire, 0, 0, 0, 0, 10, 56},
 {gettext("est_element"), 0,  (Fl_Callback*)cb_Geo_est_element, 0, 0, 0, 0, 10, 56},
 {gettext("est_parallele"), 0,  (Fl_Callback*)cb_Geo_est_parallele, 0, 0, 0, 0, 10, 56},
 {gettext("est_perpendiculaire"), 0,  (Fl_Callback*)cb_Geo_est_perpendiculaire, 0, 0, 0, 0, 10, 56},
 {gettext("est_equilateral"), 0,  (Fl_Callback*)cb_Geo_est_equilateral, 0, 0, 0, 0, 10, 56},
 {gettext("est_isocele"), 0,  (Fl_Callback*)cb_Geo_est_isocele, 0, 0, 0, 0, 10, 56},
 {gettext("est_rectangle"), 0,  (Fl_Callback*)cb_Geo_est_rectangle, 0, 0, 0, 0, 10, 56},
 {gettext("est_carre"), 0,  (Fl_Callback*)cb_Geo_est_carre, 0, 0, 0, 0, 10, 56},
 {gettext("est_losange"), 0,  (Fl_Callback*)cb_Geo_est_losange, 0, 0, 0, 0, 10, 56},
 {gettext("est_parallelogramme"), 0,  (Fl_Callback*)cb_Geo_est_parallelogramme, 0, 0, 0, 0, 10, 56},
 {gettext("est_conjugue"), 0,  (Fl_Callback*)cb_Geo_est_conjugue, 0, 0, 0, 0, 10, 56},
 {gettext("est_faisceau_cercle"), 0,  (Fl_Callback*)cb_Geo_est_faisceau_cercle, 0, 0, 0, 0, 10, 56},
 {gettext("est_faisceau_droite"), 0,  (Fl_Callback*)cb_Geo_est_faisceau_droite, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Advanced"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("axe_radical"), 0,  (Fl_Callback*)cb_Geo_axe_radical, 0, 0, 0, 0, 10, 56},
 {gettext("birapport"), 0,  (Fl_Callback*)cb_Geo_birapport, 0, 0, 0, 0, 10, 56},
 {gettext("pole"), 0,  (Fl_Callback*)cb_Geo_pole, 0, 0, 0, 0, 10, 56},
 {gettext("polaire"), 0,  (Fl_Callback*)cb_Geo_polaire, 0, 0, 0, 0, 10, 56},
 {gettext("polaire_reciproque"), 0,  (Fl_Callback*)cb_Geo_polaire_reciproque, 0, 0, 0, 0, 10, 56},
 {gettext("conj_harmonique"), 0,  (Fl_Callback*)cb_Geo_conj_harmonique, 0, 0, 0, 0, 10, 56},
 {gettext("div_harmonique"), 0,  (Fl_Callback*)cb_Geo_div_harmonique, 0, 0, 0, 0, 10, 56},
 {gettext("point_div"), 0,  (Fl_Callback*)cb_Geo_point_div, 0, 0, 0, 0, 10, 56},
 {gettext("puissance"), 0,  (Fl_Callback*)cb_Geo_puissance, 0, 0, 0, 0, 10, 56},
 {0},
 {0},
 {gettext("Phys"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("Const"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("_G_"), 0,  (Fl_Callback*)cb_Constant_G, 0, 0, 0, 0, 10, 56},
 {gettext("_NA_"), 0,  (Fl_Callback*)cb_Constant_NA, 0, 0, 0, 0, 10, 56},
 {gettext("_R_"), 0,  (Fl_Callback*)cb_Constant_Rydberg, 0, 0, 0, 0, 10, 56},
 {gettext("_Vm_"), 0,  (Fl_Callback*)cb_Constant_Vm, 0, 0, 0, 0, 10, 56},
 {gettext("_StdP_"), 0,  (Fl_Callback*)cb_Constant_StdP, 0, 0, 0, 0, 10, 56},
 {gettext("_StdT_"), 0,  (Fl_Callback*)cb_Constant_StdT, 0, 0, 0, 0, 10, 56},
 {gettext("_alpha_"), 0,  (Fl_Callback*)cb_Constant_alpha, 0, 0, 0, 0, 10, 56},
 {gettext("_c_"), 0,  (Fl_Callback*)cb_Constant_c, 0, 0, 0, 0, 10, 56},
 {gettext("_epsilon0_"), 0,  (Fl_Callback*)cb_Constant_epsilon0, 0, 0, 0, 0, 10, 56},
 {gettext("_F_"), 0,  (Fl_Callback*)cb_Constant_F, 0, 0, 0, 0, 10, 56},
 {gettext("_g_"), 0,  (Fl_Callback*)cb_Constant_g, 0, 0, 0, 0, 10, 56},
 {gettext("_h_"), 0,  (Fl_Callback*)cb_Constant_h, 0, 0, 0, 0, 10, 56},
 {gettext("_hbar_"), 0,  (Fl_Callback*)cb_Constant_hbar, 0, 0, 0, 0, 10, 56},
 {gettext("_k_"), 0,  (Fl_Callback*)cb_Constant_kB, 0, 0, 0, 0, 10, 56},
 {gettext("_me_"), 0,  (Fl_Callback*)cb_Constant_me, 0, 0, 0, 0, 10, 56},
 {gettext("_mp_"), 0,  (Fl_Callback*)cb_Constant_mp, 0, 0, 0, 0, 10, 56},
 {gettext("_mpme_"), 0,  (Fl_Callback*)cb_Constant_mpme, 0, 0, 0, 0, 10, 56},
 {gettext("_phi_"), 0,  (Fl_Callback*)cb_Constant_phi, 0, 0, 0, 0, 10, 56},
 {gettext("_q_"), 0,  (Fl_Callback*)cb_Constant_q, 0, 0, 0, 0, 10, 56},
 {gettext("_qme_"), 0,  (Fl_Callback*)cb_Constant_qme, 0, 0, 0, 0, 10, 56},
 {gettext("_sigma_"), 0,  (Fl_Callback*)cb_Constant_sigma, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Unit_convert"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("mksa"), 0,  (Fl_Callback*)cb_Unit_mksa, 0, 0, 0, 0, 10, 56},
 {gettext("convert"), 0,  (Fl_Callback*)cb_Unit_convert, 0, 0, 0, 0, 10, 56},
 {gettext("ufactor"), 0,  (Fl_Callback*)cb_Unit_ufactor, 0, 0, 0, 0, 10, 56},
 {gettext("usimplify"), 0,  (Fl_Callback*)cb_Unit_usimplify, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Unit_prefix"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("Y"), 0,  (Fl_Callback*)cb_Unit_Y, 0, 0, 0, 0, 10, 56},
 {gettext("Z"), 0,  (Fl_Callback*)cb_Unit_Z, 0, 0, 0, 0, 10, 56},
 {gettext("E"), 0,  (Fl_Callback*)cb_Unit_E, 0, 0, 0, 0, 10, 56},
 {gettext("P"), 0,  (Fl_Callback*)cb_Unit_Peta, 0, 0, 0, 0, 10, 56},
 {gettext("T"), 0,  (Fl_Callback*)cb_Unit_Tera, 0, 0, 0, 0, 10, 56},
 {gettext("G"), 0,  (Fl_Callback*)cb_Unit_Giga, 0, 0, 0, 0, 10, 56},
 {gettext("M"), 0,  (Fl_Callback*)cb_Unit_Mega, 0, 0, 0, 0, 10, 56},
 {gettext("K"), 0,  (Fl_Callback*)cb_Unit_Kilo, 0, 0, 0, 0, 10, 56},
 {gettext("H"), 0,  (Fl_Callback*)cb_Unit_Hecto, 0, 0, 0, 0, 10, 56},
 {gettext("D"), 0,  (Fl_Callback*)cb_Unit_Deca, 0, 0, 0, 0, 10, 56},
 {gettext("d"), 0,  (Fl_Callback*)cb_Unit_Deci, 0, 0, 0, 0, 10, 56},
 {gettext("c"), 0,  (Fl_Callback*)cb_Unit_Centi, 0, 0, 0, 0, 10, 56},
 {gettext("m"), 0,  (Fl_Callback*)cb_Unit_Milli, 0, 0, 0, 0, 10, 56},
 {gettext("micro"), 0,  (Fl_Callback*)cb_Unit_Micro, 0, 0, 0, 0, 10, 56},
 {gettext("n"), 0,  (Fl_Callback*)cb_Unit_Nano, 0, 0, 0, 0, 10, 56},
 {gettext("p"), 0,  (Fl_Callback*)cb_Unit_Pico, 0, 0, 0, 0, 10, 56},
 {gettext("f"), 0,  (Fl_Callback*)cb_Unit_Femto, 0, 0, 0, 0, 10, 56},
 {gettext("a"), 0,  (Fl_Callback*)cb_Unit_ato, 0, 0, 0, 0, 10, 56},
 {gettext("z"), 0,  (Fl_Callback*)cb_Unit_z, 0, 0, 0, 0, 10, 56},
 {gettext("y"), 0,  (Fl_Callback*)cb_Unit_y, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Length"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("_m"), 0,  (Fl_Callback*)cb_Unit_m, 0, 0, 0, 0, 10, 56},
 {gettext("_cm"), 0,  (Fl_Callback*)cb_Unit_cm, 0, 0, 0, 0, 10, 56},
 {gettext("_mm"), 0,  (Fl_Callback*)cb_Unit_mm, 0, 0, 0, 0, 10, 56},
 {gettext("_km"), 0,  (Fl_Callback*)cb_Unit_km, 0, 0, 0, 0, 10, 56},
 {gettext("_au"), 0,  (Fl_Callback*)cb_Unit_au, 0, 0, 0, 0, 10, 56},
 {gettext("_lyr"), 0,  (Fl_Callback*)cb_Unit_lyr, 0, 0, 0, 0, 10, 56},
 {gettext("_pc"), 0,  (Fl_Callback*)cb_Unit_pc, 0, 0, 0, 0, 10, 56},
 {gettext("_Angstrom"), 0,  (Fl_Callback*)cb_Unit_Angstrom, 0, 0, 0, 0, 10, 56},
 {gettext("_chain"), 0,  (Fl_Callback*)cb_Unit_chain, 0, 0, 0, 0, 10, 56},
 {gettext("_fath"), 0,  (Fl_Callback*)cb_Unit_fath, 0, 0, 0, 0, 10, 56},
 {gettext("_fm"), 0,  (Fl_Callback*)cb_Unit_fm, 0, 0, 0, 0, 10, 56},
 {gettext("_fermi"), 0,  (Fl_Callback*)cb_Unit_fermi, 0, 0, 0, 0, 10, 56},
 {gettext("_yd"), 0,  (Fl_Callback*)cb_Unit_yd, 0, 0, 0, 0, 10, 56},
 {gettext("_ft"), 0,  (Fl_Callback*)cb_Unit_ft, 0, 0, 0, 0, 10, 56},
 {gettext("_ftUS"), 0,  (Fl_Callback*)cb_Unit_ftUS, 0, 0, 0, 0, 10, 56},
 {gettext("_in"), 0,  (Fl_Callback*)cb_Unit_in, 0, 0, 0, 0, 10, 56},
 {gettext("_mi"), 0,  (Fl_Callback*)cb_Unit_mi, 0, 0, 0, 0, 10, 56},
 {gettext("_mile"), 0,  (Fl_Callback*)cb_Unit_mile, 0, 0, 0, 0, 10, 56},
 {gettext("_mille"), 0,  (Fl_Callback*)cb_Unit_mille, 0, 0, 0, 0, 10, 56},
 {gettext("_miUS"), 0,  (Fl_Callback*)cb_Unit_miUS, 0, 0, 0, 0, 10, 56},
 {gettext("_mil"), 0,  (Fl_Callback*)cb_Unit_mil, 0, 0, 0, 0, 10, 56},
 {gettext("_nmi"), 0,  (Fl_Callback*)cb_Unit_nmi, 0, 0, 0, 0, 10, 56},
 {gettext("_rod"), 0,  (Fl_Callback*)cb_Unit_rod, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Area"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("_m^2"), 0,  (Fl_Callback*)cb_Unit_m2, 0, 0, 0, 0, 10, 56},
 {gettext("_km^2"), 0,  (Fl_Callback*)cb_Unit_km2, 0, 0, 0, 0, 10, 56},
 {gettext("_cm^2"), 0,  (Fl_Callback*)cb_Unit_cm2, 0, 0, 0, 0, 10, 56},
 {gettext("_ha"), 0,  (Fl_Callback*)cb_Unit_ha, 0, 0, 0, 0, 10, 56},
 {gettext("_a"), 0,  (Fl_Callback*)cb_Unit_a, 0, 0, 0, 0, 10, 56},
 {gettext("_acre"), 0,  (Fl_Callback*)cb_Unit_acre, 0, 0, 0, 0, 10, 56},
 {gettext("_b"), 0,  (Fl_Callback*)cb_Unit_b, 0, 0, 0, 0, 10, 56},
 {gettext("_yd^2"), 0,  (Fl_Callback*)cb_Unit_yd2, 0, 0, 0, 0, 10, 56},
 {gettext("_ft^2"), 0,  (Fl_Callback*)cb_Unit_ft2, 0, 0, 0, 0, 10, 56},
 {gettext("_in^2"), 0,  (Fl_Callback*)cb_Unit_in2, 0, 0, 0, 0, 10, 56},
 {gettext("_mi^2"), 0,  (Fl_Callback*)cb_Unit_mi2, 0, 0, 0, 0, 10, 56},
 {gettext("_miUS^2"), 0,  (Fl_Callback*)cb_Unit_miUS2, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Volume"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("_m^3"), 0,  (Fl_Callback*)cb_Unit_m3, 0, 0, 0, 0, 10, 56},
 {gettext("_cm^3"), 0,  (Fl_Callback*)cb_Unit_cm3, 0, 0, 0, 0, 10, 56},
 {gettext("_l"), 0,  (Fl_Callback*)cb_Unit_l, 0, 0, 0, 0, 10, 56},
 {gettext("_ml"), 0,  (Fl_Callback*)cb_Unit_ml, 0, 0, 0, 0, 10, 56},
 {gettext("_st"), 0,  (Fl_Callback*)cb_Unit_st, 0, 0, 0, 0, 10, 56},
 {gettext("_yd^3"), 0,  (Fl_Callback*)cb_Unit_yd3, 0, 0, 0, 0, 10, 56},
 {gettext("_ft^3"), 0,  (Fl_Callback*)cb_Unit_ft3, 0, 0, 0, 0, 10, 56},
 {gettext("_in^3"), 0,  (Fl_Callback*)cb_Unit_in3, 0, 0, 0, 0, 10, 56},
 {gettext("_bbl"), 0,  (Fl_Callback*)cb_Unit_bbl, 0, 0, 0, 0, 10, 56},
 {gettext("_bu"), 0,  (Fl_Callback*)cb_Unit_bu, 0, 0, 0, 0, 10, 56},
 {gettext("_buUS"), 0,  (Fl_Callback*)cb_Unit_buUS, 0, 0, 0, 0, 10, 56},
 {gettext("_cu"), 0,  (Fl_Callback*)cb_Unit_cu, 0, 0, 0, 0, 10, 56},
 {gettext("_fbm"), 0,  (Fl_Callback*)cb_Unit_fbm, 0, 0, 0, 0, 10, 56},
 {gettext("_ozfl"), 0,  (Fl_Callback*)cb_Unit_ozfl, 0, 0, 0, 0, 10, 56},
 {gettext("_ozUK"), 0,  (Fl_Callback*)cb_Unit_ozUK, 0, 0, 0, 0, 10, 56},
 {gettext("_tbsp"), 0,  (Fl_Callback*)cb_Unit_tbsp, 0, 0, 0, 0, 10, 56},
 {gettext("_tsp"), 0,  (Fl_Callback*)cb_Unit_tsp, 0, 0, 0, 0, 10, 56},
 {gettext("_qt"), 0,  (Fl_Callback*)cb_Unit_qt, 0, 0, 0, 0, 10, 56},
 {gettext("_liqpt"), 0,  (Fl_Callback*)cb_Unit_liqpt, 0, 0, 0, 0, 10, 56},
 {gettext("_ptUK"), 0,  (Fl_Callback*)cb_Unit_ptUK, 0, 0, 0, 0, 10, 56},
 {gettext("_pk"), 0,  (Fl_Callback*)cb_Unit_pk, 0, 0, 0, 0, 10, 56},
 {gettext("_galUS"), 0,  (Fl_Callback*)cb_Unit_galUS, 0, 0, 0, 0, 10, 56},
 {gettext("_galC"), 0,  (Fl_Callback*)cb_Unit_galC, 0, 0, 0, 0, 10, 56},
 {gettext("_galUK"), 0,  (Fl_Callback*)cb_Unit_galUK, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Time"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("_s"), 0,  (Fl_Callback*)cb_Unit_s, 0, 0, 0, 0, 10, 56},
 {gettext("_min"), 0,  (Fl_Callback*)cb_Unit_min, 0, 0, 0, 0, 10, 56},
 {gettext("_h"), 0,  (Fl_Callback*)cb_Unit_h, 0, 0, 0, 0, 10, 56},
 {gettext("_d"), 0,  (Fl_Callback*)cb_Unit_d, 0, 0, 0, 0, 10, 56},
 {gettext("_yr"), 0,  (Fl_Callback*)cb_Unit_yr, 0, 0, 0, 0, 10, 56},
 {gettext("_Hz"), 0,  (Fl_Callback*)cb_Unit_Hz, 0, 0, 0, 0, 10, 56},
 {gettext("_Hz"), 0,  (Fl_Callback*)cb_Unit_MHz, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Speed"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("_(m/s)"), 0,  (Fl_Callback*)cb_Unit_m_s, 0, 0, 0, 0, 10, 56},
 {gettext("_(cm/s)"), 0,  (Fl_Callback*)cb_Unit_cm_s, 0, 0, 0, 0, 10, 56},
 {gettext("_(ft/s)"), 0,  (Fl_Callback*)cb_Unit_ft_s, 0, 0, 0, 0, 10, 56},
 {gettext("_kph"), 0,  (Fl_Callback*)cb_Unit_kph, 0, 0, 0, 0, 10, 56},
 {gettext("_(km/h)"), 0,  (Fl_Callback*)cb_Unit_kmh, 0, 0, 0, 0, 10, 56},
 {gettext("_mph"), 0,  (Fl_Callback*)cb_Unit_mph, 0, 0, 0, 0, 10, 56},
 {gettext("_knot"), 0,  (Fl_Callback*)cb_Unit_knot, 0, 0, 0, 0, 10, 56},
 {gettext("_(rad/s)"), 0,  (Fl_Callback*)cb_Unit_rs, 0, 0, 0, 0, 10, 56},
 {gettext("_(tr/min)"), 0,  (Fl_Callback*)cb_Unit_trmin, 0, 0, 0, 0, 10, 56},
 {gettext("_(tr/s)"), 0,  (Fl_Callback*)cb_Unit_trs, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Mass"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("_kg"), 0,  (Fl_Callback*)cb_Unit_kg, 0, 0, 0, 0, 10, 56},
 {gettext("_g"), 0,  (Fl_Callback*)cb_Unit_g, 0, 0, 0, 0, 10, 56},
 {gettext("_grain"), 0,  (Fl_Callback*)cb_Unit_grain, 0, 0, 0, 0, 10, 56},
 {gettext("_lb"), 0,  (Fl_Callback*)cb_Unit_lb, 0, 0, 0, 0, 10, 56},
 {gettext("_lbt"), 0,  (Fl_Callback*)cb_Unit_lbt, 0, 0, 0, 0, 10, 56},
 {gettext("_oz"), 0,  (Fl_Callback*)cb_Unit_oz, 0, 0, 0, 0, 10, 56},
 {gettext("_ozt"), 0,  (Fl_Callback*)cb_Unit_ozt, 0, 0, 0, 0, 10, 56},
 {gettext("_slug"), 0,  (Fl_Callback*)cb_Unit_slug, 0, 0, 0, 0, 10, 56},
 {gettext("_ton"), 0,  (Fl_Callback*)cb_Unit_ton, 0, 0, 0, 0, 10, 56},
 {gettext("_tonUK"), 0,  (Fl_Callback*)cb_Unit_tonUK, 0, 0, 0, 0, 10, 56},
 {gettext("_u"), 0,  (Fl_Callback*)cb_Unit_u, 0, 0, 0, 0, 10, 56},
 {gettext("_t"), 0,  (Fl_Callback*)cb_Unit_t, 0, 0, 0, 0, 10, 56},
 {gettext("_ct"), 0,  (Fl_Callback*)cb_Unit_ct, 0, 0, 0, 0, 10, 56},
 {gettext("_mol"), 0,  (Fl_Callback*)cb_Unit_mol, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Acceleration"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("_(m/s^2)"), 0,  (Fl_Callback*)cb_Unit_m_s2, 0, 0, 0, 0, 10, 56},
 {gettext("_Gal"), 0,  (Fl_Callback*)cb_Unit_Gal, 0, 0, 0, 0, 10, 56},
 {gettext("_(rad/s^2)"), 0,  (Fl_Callback*)cb_Unit_r_s2, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Force"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("_(kg*m/s^2)"), 0,  (Fl_Callback*)cb_Unit_kg_m_s2, 0, 0, 0, 0, 10, 56},
 {gettext("_N"), 0,  (Fl_Callback*)cb_Unit_N, 0, 0, 0, 0, 10, 56},
 {gettext("_dyn"), 0,  (Fl_Callback*)cb_Unit_dyn, 0, 0, 0, 0, 10, 56},
 {gettext("_kip"), 0,  (Fl_Callback*)cb_Unit_kip, 0, 0, 0, 0, 10, 56},
 {gettext("_gf"), 0,  (Fl_Callback*)cb_Unit_gf, 0, 0, 0, 0, 10, 56},
 {gettext("_lbf"), 0,  (Fl_Callback*)cb_Unit_lbf, 0, 0, 0, 0, 10, 56},
 {gettext("_pdl"), 0,  (Fl_Callback*)cb_Unit_pdl, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Energy"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("_(kg*m^2/s^2)"), 0,  (Fl_Callback*)cb_Unit_kg_m2_s2, 0, 0, 0, 0, 10, 56},
 {gettext("_J"), 0,  (Fl_Callback*)cb_Unit_J, 0, 0, 0, 0, 10, 56},
 {gettext("_Wh"), 0,  (Fl_Callback*)cb_Unit_Wh, 0, 0, 0, 0, 10, 56},
 {gettext("_kWh"), 0,  (Fl_Callback*)cb_Unit_kWh, 0, 0, 0, 0, 10, 56},
 {gettext("_Kcal"), 0,  (Fl_Callback*)cb_Unit_Kcal, 0, 0, 0, 0, 10, 56},
 {gettext("_cal"), 0,  (Fl_Callback*)cb_Unit_cal, 0, 0, 0, 0, 10, 56},
 {gettext("_eV"), 0,  (Fl_Callback*)cb_Unit_eV, 0, 0, 0, 0, 10, 56},
 {gettext("_MeV"), 0,  (Fl_Callback*)cb_Unit_MeV, 0, 0, 0, 0, 10, 56},
 {gettext("_Btu"), 0,  (Fl_Callback*)cb_Unit_Btu, 0, 0, 0, 0, 10, 56},
 {gettext("_erg"), 0,  (Fl_Callback*)cb_Unit_erg, 0, 0, 0, 0, 10, 56},
 {gettext("_(ft*lb)"), 0,  (Fl_Callback*)cb_Unit_ftxlb, 0, 0, 0, 0, 10, 56},
 {gettext("_therm"), 0,  (Fl_Callback*)cb_Unit_therm, 0, 0, 0, 0, 10, 56},
 {gettext("_tep"), 0,  (Fl_Callback*)cb_Unit_tep, 0, 0, 0, 0, 10, 56},
 {gettext("_toe"), 0,  (Fl_Callback*)cb_Unit_toe, 0, 0, 0, 0, 10, 56},
 {gettext("_tec"), 0,  (Fl_Callback*)cb_Unit_tec, 0, 0, 0, 0, 10, 56},
 {gettext("_lep"), 0,  (Fl_Callback*)cb_Unit_lep, 0, 0, 0, 0, 10, 56},
 {gettext("_bblep"), 0,  (Fl_Callback*)cb_Unit_bblep, 0, 0, 0, 0, 10, 56},
 {gettext("_boe"), 0,  (Fl_Callback*)cb_Unit_boe, 0, 0, 0, 0, 10, 56},
 {gettext("_cf"), 0,  (Fl_Callback*)cb_Unit_cf, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Power"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("_(kg*m/s^3)"), 0,  (Fl_Callback*)cb_Unit_kg_m_s3, 0, 0, 0, 0, 10, 56},
 {gettext("_W"), 0,  (Fl_Callback*)cb_Unit_W, 0, 0, 0, 0, 10, 56},
 {gettext("_MW"), 0,  (Fl_Callback*)cb_Unit_MW, 0, 0, 0, 0, 10, 56},
 {gettext("_hp"), 0,  (Fl_Callback*)cb_Unit_hp, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Pressure"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("_(kg/m/s^2)"), 0,  (Fl_Callback*)cb_Unit_kg_m1_s2, 0, 0, 0, 0, 10, 56},
 {gettext("_Pa"), 0,  (Fl_Callback*)cb_Unit_Pa, 0, 0, 0, 0, 10, 56},
 {gettext("_bar"), 0,  (Fl_Callback*)cb_Unit_bar, 0, 0, 0, 0, 10, 56},
 {gettext("_atm"), 0,  (Fl_Callback*)cb_Unit_atm, 0, 0, 0, 0, 10, 56},
 {gettext("_psi"), 0,  (Fl_Callback*)cb_Unit_psi, 0, 0, 0, 0, 10, 56},
 {gettext("_torr"), 0,  (Fl_Callback*)cb_Unit_torr, 0, 0, 0, 0, 10, 56},
 {gettext("_mmHg"), 0,  (Fl_Callback*)cb_Unit_mmHg, 0, 0, 0, 0, 10, 56},
 {gettext("_inHg"), 0,  (Fl_Callback*)cb_Unit_inHg, 0, 0, 0, 0, 10, 56},
 {gettext("_inH2O"), 0,  (Fl_Callback*)cb_Unit_inH2O, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Temperature"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("_K"), 0,  (Fl_Callback*)cb_Unit_K, 0, 0, 0, 0, 10, 56},
 {gettext("_Rankine"), 0,  (Fl_Callback*)cb_Unit_Rankine, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Electricity"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("_A"), 0,  (Fl_Callback*)cb_Unit_A, 0, 0, 0, 0, 10, 56},
 {gettext("_V"), 0,  (Fl_Callback*)cb_Unit_V, 0, 0, 0, 0, 10, 56},
 {gettext("_C"), 0,  (Fl_Callback*)cb_Unit_C, 0, 0, 0, 0, 10, 56},
 {gettext("_Ohm"), 0,  (Fl_Callback*)cb_Unit_Ohm, 0, 0, 0, 0, 10, 56},
 {gettext("_F"), 0,  (Fl_Callback*)cb_Unit_F, 0, 0, 0, 0, 10, 56},
 {gettext("_Fdy"), 0,  (Fl_Callback*)cb_Unit_Fdy, 0, 0, 0, 0, 10, 56},
 {gettext("_Wb"), 0,  (Fl_Callback*)cb_Unit_Wb, 0, 0, 0, 0, 10, 56},
 {gettext("_H"), 0,  (Fl_Callback*)cb_Unit_H, 0, 0, 0, 0, 10, 56},
 {gettext("_mho"), 0,  (Fl_Callback*)cb_Unit_mho, 0, 0, 0, 0, 10, 56},
 {gettext("_S"), 0,  (Fl_Callback*)cb_Unit_S, 0, 0, 0, 0, 10, 56},
 {gettext("_T"), 0,  (Fl_Callback*)cb_Unit_T, 0, 0, 0, 0, 10, 56},
 {gettext("_(A*h)"), 0,  (Fl_Callback*)cb_Unit_Ah, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Light"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("_cd"), 0,  (Fl_Callback*)cb_Unit_cd, 0, 0, 0, 0, 10, 56},
 {gettext("_flam"), 0,  (Fl_Callback*)cb_Unit_flam, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Angle"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("_rad"), 0,  (Fl_Callback*)cb_Unit_rad, 0, 0, 0, 0, 10, 56},
 {gettext("_deg"), 0,  (Fl_Callback*)cb_Unit_deg, 0, 0, 0, 0, 10, 56},
 {gettext("_grad"), 0,  (Fl_Callback*)cb_Unit_grad, 0, 0, 0, 0, 10, 56},
 {gettext("_gon"), 0,  (Fl_Callback*)cb_Unit_gon, 0, 0, 0, 0, 10, 56},
 {gettext("_arcmin"), 0,  (Fl_Callback*)cb_Unit_arcmin, 0, 0, 0, 0, 10, 56},
 {gettext("_arcs"), 0,  (Fl_Callback*)cb_Unit_arcs, 0, 0, 0, 0, 10, 56},
 {gettext("_tr"), 0,  (Fl_Callback*)cb_Unit_tr, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Viscosity"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("_(m^2/s)"), 0,  (Fl_Callback*)cb_Unit_m2_s, 0, 0, 0, 0, 10, 56},
 {gettext("_P"), 0,  (Fl_Callback*)cb_Unit_P, 0, 0, 0, 0, 10, 56},
 {gettext("_St"), 0,  (Fl_Callback*)cb_Unit_St, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Radiation"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("_Bq"), 0,  (Fl_Callback*)cb_Unit_Bq, 0, 0, 0, 0, 10, 56},
 {gettext("_Ci"), 0,  (Fl_Callback*)cb_Unit_Ci, 0, 0, 0, 0, 10, 56},
 {gettext("_Gy"), 0,  (Fl_Callback*)cb_Unit_Gy, 0, 0, 0, 0, 10, 56},
 {gettext("_rd"), 0,  (Fl_Callback*)cb_Unit_rd, 0, 0, 0, 0, 10, 56},
 {gettext("_rem"), 0,  (Fl_Callback*)cb_Unit_rem, 0, 0, 0, 0, 10, 56},
 {gettext("_Sv"), 0,  (Fl_Callback*)cb_Unit_Sv, 0, 0, 0, 0, 10, 56},
 {gettext("_R"), 0,  (Fl_Callback*)cb_Unit_R, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Monetary"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("_FF"), 0,  (Fl_Callback*)cb_Unit_FF, 0, 0, 0, 0, 10, 56},
 {gettext("_E"), 0,  (Fl_Callback*)cb_Unit_Euro, 0, 0, 0, 0, 10, 56},
 {0},
 {0},
 {gettext("Alg"), 0,  (Fl_Callback*)cb_Algebra, 0, 64, 0, 0, 10, 56},
 {gettext("Polynomials"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("canonical_form"), 0,  (Fl_Callback*)cb_Canonical_Form, 0, 0, 0, 0, 10, 56},
 {gettext("coeff"), 0,  (Fl_Callback*)cb_Coeff, 0, 0, 0, 0, 10, 56},
 {gettext("degree"), 0,  (Fl_Callback*)cb_Degree, 0, 0, 0, 0, 10, 56},
 {gettext("factor_xn"), 0,  (Fl_Callback*)cb_Factor_Xn, 0, 0, 0, 0, 10, 56},
 {gettext("factors"), 0,  (Fl_Callback*)cb_Factors, 0, 0, 0, 0, 10, 56},
 {gettext("fcoeff"), 0,  (Fl_Callback*)cb_Fcoeff, 0, 0, 0, 0, 10, 56},
 {gettext("froot"), 0,  (Fl_Callback*)cb_Froot, 0, 0, 0, 0, 10, 56},
 {gettext("genpoly"), 0,  (Fl_Callback*)cb_Genpoly, 0, 0, 0, 0, 10, 56},
 {gettext("horner"), 0,  (Fl_Callback*)cb_Horner, 0, 0, 0, 0, 10, 56},
 {gettext("lagrange"), 0,  (Fl_Callback*)cb_Lagrange, 0, 0, 0, 0, 10, 56},
 {gettext("lcoeff"), 0,  (Fl_Callback*)cb_Lcoeff, 0, 0, 0, 0, 10, 56},
 {gettext("pcoeff"), 0,  (Fl_Callback*)cb_Pcoeff, 0, 0, 0, 0, 10, 56},
 {gettext("peval"), 0,  (Fl_Callback*)cb_Peval, 0, 0, 0, 0, 10, 56},
 {gettext("proot"), 0,  (Fl_Callback*)cb_Proot2, 0, 0, 0, 0, 10, 56},
 {gettext("ptayl"), 0,  (Fl_Callback*)cb_Ptayl, 0, 0, 0, 0, 10, 56},
 {gettext("poly2symb"), 0,  (Fl_Callback*)cb_Poly2symb, 0, 0, 0, 0, 10, 56},
 {gettext("ranm"), 0,  (Fl_Callback*)cb_Ranm, 0, 0, 0, 0, 10, 56},
 {gettext("symb2poly"), 0,  (Fl_Callback*)cb_Symb2poly, 0, 0, 0, 0, 10, 56},
 {gettext("tcoeff"), 0,  (Fl_Callback*)cb_Tcoeff, 0, 0, 0, 0, 10, 56},
 {gettext("valuation"), 0,  (Fl_Callback*)cb_Valuation, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Poly. arit."), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("abcuv"), 0,  (Fl_Callback*)cb_Abcuv, 0, 0, 0, 0, 10, 56},
 {gettext("chinrem"), 0,  (Fl_Callback*)cb_Chinrem, 0, 0, 0, 0, 10, 56},
 {gettext("cyclotomic"), 0,  (Fl_Callback*)cb_Cyclotomic, 0, 0, 0, 0, 10, 56},
 {gettext("divis"), 0,  (Fl_Callback*)cb_Divis, 0, 0, 0, 0, 10, 56},
 {gettext("egcd"), 0,  (Fl_Callback*)cb_Egcd, 0, 0, 0, 0, 10, 56},
 {gettext("factor"), 0,  (Fl_Callback*)cb_Factor2, 0, 0, 0, 0, 10, 56},
 {gettext("gcd"), 0,  (Fl_Callback*)cb_Gcd_poly, 0, 0, 0, 0, 10, 56},
 {gettext("lcm"), 0,  (Fl_Callback*)cb_Lcm_poly, 0, 0, 0, 0, 10, 56},
 {gettext("quo"), 0,  (Fl_Callback*)cb_Quotient, 0, 0, 0, 0, 10, 56},
 {gettext("quorem"), 0,  (Fl_Callback*)cb_Quorem, 0, 0, 0, 0, 10, 56},
 {gettext("rem"), 0,  (Fl_Callback*)cb_Rem, 0, 0, 0, 0, 10, 56},
 {gettext("resultant"), 0,  (Fl_Callback*)cb_Resultant, 0, 0, 0, 0, 10, 56},
 {gettext("sturm"), 0,  (Fl_Callback*)cb_Sturm, 0, 0, 0, 0, 10, 56},
 {gettext("sturmab"), 0,  (Fl_Callback*)cb_Sturmab, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Ortho. poly"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("hermite"), 0,  (Fl_Callback*)cb_Hermite, 0, 0, 0, 0, 10, 56},
 {gettext("laguerre"), 0,  (Fl_Callback*)cb_Laguerre, 0, 0, 0, 0, 10, 56},
 {gettext("legendre"), 0,  (Fl_Callback*)cb_Legendre, 0, 0, 0, 0, 10, 56},
 {gettext("tchebyshev1"), 0,  (Fl_Callback*)cb_Tchebyshev1, 0, 0, 0, 0, 10, 56},
 {gettext("tchebyshev2"), 0,  (Fl_Callback*)cb_Tchebyshev2, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Groebner"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("gbasis"), 0,  (Fl_Callback*)cb_Gbasis, 0, 0, 0, 0, 10, 56},
 {gettext("greduce"), 0,  (Fl_Callback*)cb_Greduce, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Matrix"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("current_sheet"), 0,  (Fl_Callback*)cb_Current_Sheet, 0, 0, 0, 0, 10, 56},
 {gettext("hadamard"), 0,  (Fl_Callback*)cb_Hadamard, 0, 0, 0, 0, 10, 56},
 {gettext("hilbert"), 0,  (Fl_Callback*)cb_Hilbert, 0, 0, 0, 0, 10, 56},
 {gettext("identity"), 0,  (Fl_Callback*)cb_Idendity, 0, 0, 0, 0, 10, 56},
 {gettext("makemat"), 0,  (Fl_Callback*)cb_Matrix_makemat, 0, 0, 0, 0, 10, 56},
 {gettext("ncols"), 0,  (Fl_Callback*)cb_Matrix_ncols, 0, 0, 0, 0, 10, 56},
 {gettext("nrows"), 0,  (Fl_Callback*)cb_Matrix_nrows, 0, 0, 0, 0, 10, 56},
 {gettext("ranm"), 0,  (Fl_Callback*)cb_Rand_mat, 0, 0, 0, 0, 10, 56},
 {gettext("syst2mat"), 0,  (Fl_Callback*)cb_Syst2mat, 0, 0, 0, 0, 10, 56},
 {gettext("vandermonde"), 0,  (Fl_Callback*)cb_Vandermonde, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Linalg"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("basis"), 0,  (Fl_Callback*)cb_Basis, 0, 0, 0, 0, 10, 56},
 {gettext("changebase"), 0,  (Fl_Callback*)cb_Reduction_changebase, 0, 0, 0, 0, 10, 56},
 {gettext("det"), 0,  (Fl_Callback*)cb_Det, 0, 0, 0, 0, 10, 56},
 {gettext("det_minor"), 0,  (Fl_Callback*)cb_Matrix_det_minor, 0, 0, 0, 0, 10, 56},
 {gettext("inv"), 0,  (Fl_Callback*)cb_Inverse_matrix, 0, 0, 0, 0, 10, 56},
 {gettext("ibasis"), 0,  (Fl_Callback*)cb_Ibasis, 0, 0, 0, 0, 10, 56},
 {gettext("idn"), 0,  (Fl_Callback*)cb_Idn, 0, 0, 0, 0, 10, 56},
 {gettext("ker"), 0,  (Fl_Callback*)cb_Ker, 0, 0, 0, 0, 10, 56},
 {gettext("image"), 0,  (Fl_Callback*)cb_Lin_Image, 0, 0, 0, 0, 10, 56},
 {gettext("linsolve"), 0,  (Fl_Callback*)cb_Linsolve, 0, 0, 0, 0, 10, 56},
 {gettext("rank"), 0,  (Fl_Callback*)cb_Rank_mat, 0, 0, 0, 0, 10, 56},
 {gettext("rref"), 0,  (Fl_Callback*)cb_Rref_mat, 0, 0, 0, 0, 10, 56},
 {gettext("trace"), 0,  (Fl_Callback*)cb_Trace, 0, 0, 0, 0, 10, 56},
 {gettext("trn"), 0,  (Fl_Callback*)cb_Transconjugate, 0, 0, 0, 0, 10, 56},
 {gettext("tran"), 0,  (Fl_Callback*)cb_Transpose, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Eigenvect"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("adjoint_matrix"), 0,  (Fl_Callback*)cb_Egv_adjoint_matrix, 0, 0, 0, 0, 10, 56},
 {gettext("companion"), 0,  (Fl_Callback*)cb_Companion, 0, 0, 0, 0, 10, 56},
 {gettext("egv"), 0,  (Fl_Callback*)cb_Egv, 0, 0, 0, 0, 10, 56},
 {gettext("egvl"), 0,  (Fl_Callback*)cb_Egvl, 0, 0, 0, 0, 10, 56},
 {gettext("hessenberg"), 0,  (Fl_Callback*)cb_Egv_hessenberg, 0, 0, 0, 0, 10, 56},
 {gettext("jordan"), 0,  (Fl_Callback*)cb_Jordan, 0, 0, 0, 0, 10, 56},
 {gettext("pcar"), 0,  (Fl_Callback*)cb_Egv_pcar, 0, 0, 0, 0, 10, 56},
 {gettext("pcar_hessenberg"), 0,  (Fl_Callback*)cb_Egv_pcar_hessenberg, 0, 0, 0, 0, 10, 56},
 {gettext("pmin"), 0,  (Fl_Callback*)cb_Egv_pmin, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Matrix_factor"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("cholesky"), 0,  (Fl_Callback*)cb_Cholesky, 0, 0, 0, 0, 10, 56},
 {gettext("lll"), 0,  (Fl_Callback*)cb_Lll, 0, 0, 0, 0, 10, 56},
 {gettext("lu"), 0,  (Fl_Callback*)cb_Lu, 0, 0, 0, 0, 10, 56},
 {gettext("qr"), 0,  (Fl_Callback*)cb_Qr, 0, 0, 0, 0, 10, 56},
 {gettext("svd"), 0,  (Fl_Callback*)cb_Svd, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Quadratic"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("a2q"), 0,  (Fl_Callback*)cb_A2q, 0, 0, 0, 0, 10, 56},
 {gettext("gauss"), 0,  (Fl_Callback*)cb_Gauss, 0, 0, 0, 0, 10, 56},
 {gettext("gramschmidt"), 0,  (Fl_Callback*)cb_Gramschmidt, 0, 0, 0, 0, 10, 56},
 {gettext("q2a"), 0,  (Fl_Callback*)cb_Q2a, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Isometries"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("isom"), 0,  (Fl_Callback*)cb_Isom, 0, 0, 0, 0, 10, 56},
 {gettext("mkisom"), 0,  (Fl_Callback*)cb_Mkisom, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Permutations"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("c1oc2"), 0,  (Fl_Callback*)cb_C1oc2, 0, 0, 0, 0, 10, 56},
 {gettext("c1op2"), 0,  (Fl_Callback*)cb_C1op2, 0, 0, 0, 0, 10, 56},
 {gettext("cycle2perm"), 0,  (Fl_Callback*)cb_Cycle2perm, 0, 0, 0, 0, 10, 56},
 {gettext("cycleinv"), 0,  (Fl_Callback*)cb_Cycleinv, 0, 0, 0, 0, 10, 56},
 {gettext("cycles2permu"), 0,  (Fl_Callback*)cb_Cycles2permu, 0, 0, 0, 0, 10, 56},
 {gettext("est_cycle"), 0,  (Fl_Callback*)cb_Est_Cycle, 0, 0, 0, 0, 10, 56},
 {gettext("est_permu"), 0,  (Fl_Callback*)cb_Est_Permu, 0, 0, 0, 0, 10, 56},
 {gettext("groupepermu"), 0,  (Fl_Callback*)cb_Groupepermu, 0, 0, 0, 0, 10, 56},
 {gettext("p1oc2"), 0,  (Fl_Callback*)cb_P1oc2, 0, 0, 0, 0, 10, 56},
 {gettext("p1op2"), 0,  (Fl_Callback*)cb_P1op2, 0, 0, 0, 0, 10, 56},
 {gettext("perminv"), 0,  (Fl_Callback*)cb_Perminv, 0, 0, 0, 0, 10, 56},
 {gettext("permu2cycles"), 0,  (Fl_Callback*)cb_Permu2cycles, 0, 0, 0, 0, 10, 56},
 {gettext("permu2mat"), 0,  (Fl_Callback*)cb_Permu2mat, 0, 0, 0, 0, 10, 56},
 {gettext("permuorder"), 0,  (Fl_Callback*)cb_Permuorder, 0, 0, 0, 0, 10, 56},
 {gettext("randperm"), 0,  (Fl_Callback*)cb_Randperm, 0, 0, 0, 0, 10, 56},
 {gettext("signature"), 0,  (Fl_Callback*)cb_Perm_Signature, 0, 0, 0, 0, 10, 56},
 {0},
 {0},
 {gettext("Calc"), 0,  (Fl_Callback*)cb_Cas_menu, 0, 64, 0, 0, 10, 56},
 {gettext("Diff int 1-d"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("diff"), 0x80064,  (Fl_Callback*)cb_Derive, 0, 0, 0, 0, 10, 56},
 {gettext("ibpdv"), 0,  (Fl_Callback*)cb_Ibpdv, 0, 0, 0, 0, 10, 56},
 {gettext("ibpu"), 0,  (Fl_Callback*)cb_Ibpu, 0, 0, 0, 0, 10, 56},
 {gettext("integrate"), 0x80069,  (Fl_Callback*)cb_Integrate, 0, 0, 0, 0, 10, 56},
 {gettext("preval"), 0,  (Fl_Callback*)cb_Preval, 0, 0, 0, 0, 10, 56},
 {gettext("sum"), 0x80053,  (Fl_Callback*)cb_Sum, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Diff int n-d"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("curl"), 0,  (Fl_Callback*)cb_Curl, 0, 0, 0, 0, 10, 56},
 {gettext("diff"), 0,  (Fl_Callback*)cb_Derive2, 0, 0, 0, 0, 10, 56},
 {gettext("divergence"), 0,  (Fl_Callback*)cb_Divergence, 0, 0, 0, 0, 10, 56},
 {gettext("hessian"), 0,  (Fl_Callback*)cb_Hessian, 0, 0, 0, 0, 10, 56},
 {gettext("laplacian"), 0,  (Fl_Callback*)cb_Laplacian, 0, 0, 0, 0, 10, 56},
 {gettext("potential"), 0,  (Fl_Callback*)cb_Potential, 0, 0, 0, 0, 10, 56},
 {gettext("vpotential"), 0,  (Fl_Callback*)cb_Vpotential, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Limit series"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("limit"), 0x8006c,  (Fl_Callback*)cb_Limit, 0, 0, 0, 0, 10, 56},
 {gettext("series"), 0,  (Fl_Callback*)cb_Series, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Exact_solve"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("linsolve"), 0,  (Fl_Callback*)cb_Linsolve2, 0, 0, 0, 0, 10, 56},
 {gettext("solve"), 0,  (Fl_Callback*)cb_Solve, 0, 0, 0, 0, 10, 56},
 {gettext("desolve"), 0,  (Fl_Callback*)cb_Desolve, 0, 0, 0, 0, 10, 56},
 {gettext("reverse_rsolve"), 0,  (Fl_Callback*)cb_Reverse_Rsolve, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Numeric"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("epsilon2zero"), 0,  (Fl_Callback*)cb_Epsilon2zero, 0, 0, 0, 0, 10, 56},
 {gettext("evalf"), 0,  (Fl_Callback*)cb_Evalf_item, 0, 0, 0, 0, 10, 56},
 {gettext("float2rational"), 0,  (Fl_Callback*)cb_Float2rational, 0, 0, 0, 0, 10, 56},
 {gettext("newton"), 0,  (Fl_Callback*)cb_Newton, 0, 0, 0, 0, 10, 56},
 {gettext("romberg"), 0,  (Fl_Callback*)cb_Romberg, 0, 0, 0, 0, 10, 56},
 {gettext("odesolve"), 0,  (Fl_Callback*)cb_Odesolve, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Num_solve_eq"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("fsolve"), 0,  (Fl_Callback*)cb_Fsolve11, 0, 0, 0, 0, 10, 56},
 {gettext("bisection_solver"), 0,  (Fl_Callback*)cb_Bisection, 0, 0, 0, 0, 10, 56},
 {gettext("brent_solver"), 0,  (Fl_Callback*)cb_Brent, 0, 0, 0, 0, 10, 56},
 {gettext("falsepos_solver"), 0,  (Fl_Callback*)cb_Falsepos, 0, 0, 0, 0, 10, 56},
 {gettext("newton_solver"), 0,  (Fl_Callback*)cb_Newtonf, 0, 0, 0, 0, 10, 56},
 {gettext("secant_solver"), 0,  (Fl_Callback*)cb_Secant, 0, 0, 0, 0, 10, 56},
 {gettext("steffenson_solver"), 0,  (Fl_Callback*)cb_Steffenson, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Num_solve_syst"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("fsolve"), 0,  (Fl_Callback*)cb_Fsolve21, 0, 0, 0, 0, 10, 56},
 {gettext("dnewton_solver"), 0,  (Fl_Callback*)cb_Newtond, 0, 0, 0, 0, 10, 56},
 {gettext("hybrid_solver"), 0,  (Fl_Callback*)cb_Hybrid, 0, 0, 0, 0, 10, 56},
 {gettext("hybrids_solver"), 0,  (Fl_Callback*)cb_Hybrids, 0, 0, 0, 0, 10, 56},
 {gettext("newtonj_solver"), 0,  (Fl_Callback*)cb_Newtonj, 0, 0, 0, 0, 10, 56},
 {gettext("hybridj_solver"), 0,  (Fl_Callback*)cb_Hybridj, 0, 0, 0, 0, 10, 56},
 {gettext("hybridsj_solver"), 0,  (Fl_Callback*)cb_Hybridsj, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Spec"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("gamma"), 0,  (Fl_Callback*)cb_Gamma, 0, 0, 0, 0, 10, 56},
 {gettext("psi"), 0,  (Fl_Callback*)cb_Psi, 0, 0, 0, 0, 10, 56},
 {gettext("zeta"), 0,  (Fl_Callback*)cb_Zeta, 0, 0, 0, 0, 10, 56},
 {gettext("Airy_Ai"), 0,  (Fl_Callback*)cb_Airy_Ai, 0, 0, 0, 0, 10, 56},
 {gettext("Airy_Bi"), 0,  (Fl_Callback*)cb_Airy_Bi, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Transform"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("fft"), 0,  (Fl_Callback*)cb_Fft, 0, 0, 0, 0, 10, 56},
 {gettext("fourier_an"), 0,  (Fl_Callback*)cb_Fourier_An, 0, 0, 0, 0, 10, 56},
 {gettext("fourier_bn"), 0,  (Fl_Callback*)cb_Fourier_Bn, 0, 0, 0, 0, 10, 56},
 {gettext("fourier_cn"), 0,  (Fl_Callback*)cb_Fourier_Cn, 0, 0, 0, 0, 10, 56},
 {gettext("ifft"), 0,  (Fl_Callback*)cb_Ifft, 0, 0, 0, 0, 10, 56},
 {gettext("ilaplace"), 0,  (Fl_Callback*)cb_Ilaplace, 0, 0, 0, 0, 10, 56},
 {gettext("laplace"), 0,  (Fl_Callback*)cb_Laplace, 0, 0, 0, 0, 10, 56},
 {0},
 {0},
 {gettext("Prg"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("Func"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("local"), 0,  (Fl_Callback*)cb_Prg_local, 0, 0, 0, 0, 10, 56},
 {gettext("{ }"), 0,  (Fl_Callback*)cb_Prg_bloc, 0, 0, 0, 0, 10, 56},
 {gettext("return"), 0,  (Fl_Callback*)cb_Prg_return, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Test"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("ifte"), 0,  (Fl_Callback*)cb_Prg_ifte, 0, 0, 0, 0, 10, 56},
 {gettext("if"), 0,  (Fl_Callback*)cb_Prg_if, 0, 0, 0, 0, 10, 56},
 {gettext("then"), 0,  (Fl_Callback*)cb_Prg_then, 0, 0, 0, 0, 10, 56},
 {gettext("else"), 0,  (Fl_Callback*)cb_Prg_else, 0, 0, 0, 0, 10, 56},
 {gettext("endif"), 0,  (Fl_Callback*)cb_Prg_endif, 0, 0, 0, 0, 10, 56},
 {gettext("switch"), 0,  (Fl_Callback*)cb_Prg_switch, 0, 0, 0, 0, 10, 56},
 {gettext("case"), 0,  (Fl_Callback*)cb_Prg_case, 0, 0, 0, 0, 10, 56},
 {gettext("break"), 0,  (Fl_Callback*)cb_Prg_break2, 0, 0, 0, 0, 10, 56},
 {gettext("try_catch"), 0,  (Fl_Callback*)cb_Prg_try, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Loop"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("for"), 0,  (Fl_Callback*)cb_Prg_for, 0, 0, 0, 0, 10, 56},
 {gettext("while"), 0,  (Fl_Callback*)cb_Prg_while, 0, 0, 0, 0, 10, 56},
 {gettext("do"), 0,  (Fl_Callback*)cb_Prg_do, 0, 0, 0, 0, 10, 56},
 {gettext("end_while"), 0,  (Fl_Callback*)cb_Prg_end_while, 0, 0, 0, 0, 10, 56},
 {gettext("break"), 0,  (Fl_Callback*)cb_Prg_break, 0, 0, 0, 0, 10, 56},
 {gettext("continue"), 0,  (Fl_Callback*)cb_Prg_continue, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("List"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("append"), 0,  (Fl_Callback*)cb_Prg_append, 0, 0, 0, 0, 10, 56},
 {gettext("accumulate_head_tail"), 0,  (Fl_Callback*)cb_Prg_accumulate_head_tail, 0, 0, 0, 0, 10, 56},
 {gettext("concat"), 0,  (Fl_Callback*)cb_Prg_concat, 0, 0, 0, 0, 10, 56},
 {gettext("head"), 0,  (Fl_Callback*)cb_Prg_head, 0, 0, 0, 0, 10, 56},
 {gettext("makelist"), 0,  (Fl_Callback*)cb_Prg_makelist, 0, 0, 0, 0, 10, 56},
 {gettext("member"), 0,  (Fl_Callback*)cb_Prg_member, 0, 0, 0, 0, 10, 56},
 {gettext("mid"), 0,  (Fl_Callback*)cb_Prg_mid, 0, 0, 0, 0, 10, 56},
 {gettext("revlist"), 0,  (Fl_Callback*)cb_Prg_revlist, 0, 0, 0, 0, 10, 56},
 {gettext("rotate"), 0,  (Fl_Callback*)cb_Prg_rotate, 0, 0, 0, 0, 10, 56},
 {gettext("shift"), 0,  (Fl_Callback*)cb_Prg_shift, 0, 0, 0, 0, 10, 56},
 {gettext("size"), 0,  (Fl_Callback*)cb_Prg_size, 0, 0, 0, 0, 10, 56},
 {gettext("sizes"), 0,  (Fl_Callback*)cb_Prg_sizes, 0, 0, 0, 0, 10, 56},
 {gettext("sort"), 0,  (Fl_Callback*)cb_Prg_sort, 0, 0, 0, 0, 10, 56},
 {gettext("suppress"), 0,  (Fl_Callback*)cb_Prg_suppress, 0, 0, 0, 0, 10, 56},
 {gettext("tail"), 0,  (Fl_Callback*)cb_Prg_tail, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Memory"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("about"), 0,  (Fl_Callback*)cb_Prg_about, 0, 0, 0, 0, 10, 56},
 {gettext(":="), 0,  (Fl_Callback*)cb_Prg_affect, 0, 0, 0, 0, 10, 56},
 {gettext("ans"), 0,  (Fl_Callback*)cb_Prg_ans, 0, 0, 0, 0, 10, 56},
 {gettext("assume"), 0,  (Fl_Callback*)cb_Prg_assume, 0, 0, 0, 0, 10, 56},
 {gettext("entry"), 0,  (Fl_Callback*)cb_Prg_entry, 0, 0, 0, 0, 10, 56},
 {gettext("purge"), 0,  (Fl_Callback*)cb_Prg_purge, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Set"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("intersect"), 0,  (Fl_Callback*)cb_Prg_intersect, 0, 0, 0, 0, 10, 56},
 {gettext("minus"), 0,  (Fl_Callback*)cb_Prg_minus, 0, 0, 0, 0, 10, 56},
 {gettext("union"), 0,  (Fl_Callback*)cb_Prg_union, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Strings"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("asc"), 0,  (Fl_Callback*)cb_Prg_asc, 0, 0, 0, 0, 10, 56},
 {gettext("char"), 0,  (Fl_Callback*)cb_Prg_char, 0, 0, 0, 0, 10, 56},
 {gettext("inString"), 0,  (Fl_Callback*)cb_Prg_inString, 0, 0, 0, 0, 10, 56},
 {gettext("left"), 0,  (Fl_Callback*)cb_Prg_left, 0, 0, 0, 0, 10, 56},
 {gettext("ord"), 0,  (Fl_Callback*)cb_Prg_ord, 0, 0, 0, 0, 10, 56},
 {gettext("right"), 0,  (Fl_Callback*)cb_Prg_right, 0, 0, 0, 0, 10, 56},
 {gettext("string"), 0,  (Fl_Callback*)cb_Prg_string, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("History"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("ClrIO"), 0,  (Fl_Callback*)cb_Prg_ClrIO, 0, 0, 0, 0, 10, 56},
 {gettext("input"), 0,  (Fl_Callback*)cb_Prg_input, 0, 0, 0, 0, 10, 56},
 {gettext("print"), 0,  (Fl_Callback*)cb_Prg_print, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Boolean"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("and"), 0,  (Fl_Callback*)cb_Prg_and, 0, 0, 0, 0, 10, 56},
 {gettext("or"), 0,  (Fl_Callback*)cb_Prg_or, 0, 0, 0, 0, 10, 56},
 {gettext("not"), 0,  (Fl_Callback*)cb_Prg_not, 0, 0, 0, 0, 10, 56},
 {gettext("xor"), 0,  (Fl_Callback*)cb_Prg_xor, 0, 0, 0, 0, 10, 56},
 {gettext("=="), 0,  (Fl_Callback*)cb_Prg_eqeq, 0, 0, 0, 0, 10, 56},
 {gettext("!="), 0,  (Fl_Callback*)cb_Prg_neq, 0, 0, 0, 0, 10, 56},
 {gettext("<"), 0,  (Fl_Callback*)cb_Prg_infstrict, 0, 0, 0, 0, 10, 56},
 {gettext("<="), 0,  (Fl_Callback*)cb_Prg_infegal, 0, 0, 0, 0, 10, 56},
 {gettext(">"), 0,  (Fl_Callback*)cb_Prg_supstrict, 0, 0, 0, 0, 10, 56},
 {gettext(">="), 0,  (Fl_Callback*)cb_Prg_supegal, 0, 0, 0, 0, 10, 56},
 {0},
 {gettext("Debug"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("breakpoint"), 0,  (Fl_Callback*)cb_Prg_breakpoint, 0, 0, 0, 0, 10, 56},
 {gettext("debug"), 0,  (Fl_Callback*)cb_Prg_debug, 0, 0, 0, 0, 10, 56},
 {gettext("kill"), 0,  (Fl_Callback*)cb_Prg_kill, 0, 0, 0, 0, 10, 56},
 {gettext("rmbreakpoint"), 0,  (Fl_Callback*)cb_Prg_rmbreakpoint, 0, 0, 0, 0, 10, 56},
 {gettext("rmwatch"), 0,  (Fl_Callback*)cb_Prg_rmwatch, 0, 0, 0, 0, 10, 56},
 {gettext("watch"), 0,  (Fl_Callback*)cb_Prg_watch, 0, 0, 0, 0, 10, 56},
 {0},
 {0},
 {gettext("Help"), 0,  0, 0, 64, 0, 0, 10, 56},
 {gettext("Search word in HTML help"), 0xffc7,  (Fl_Callback*)cb_Search_help, 0, 0, 0, 0, 10, 56},
 {gettext("Help screen"), 0xffc8,  (Fl_Callback*)cb_Edit_help, 0, 0, 0, 0, 10, 56},
 {gettext("Tutorial"), 0,  (Fl_Callback*)cb_Tutorial_help, 0, 0, 0, 0, 10, 56},
 {gettext("Computer Alg. Sys."), 0,  (Fl_Callback*)cb_Cas_help, 0, 0, 0, 0, 10, 56},
 {gettext("Geometry"), 0,  (Fl_Callback*)cb_Geo_help, 0, 0, 0, 0, 10, 56},
 {gettext("Tableur"), 0,  (Fl_Callback*)cb_Mtrw_help, 0, 0, 0, 0, 10, 56},
 {gettext("Programming"), 0,  (Fl_Callback*)cb_Prog_help, 0, 0, 0, 0, 10, 56},
 {gettext("Tortue logo"), 0,  (Fl_Callback*)cb_Tortue_help, 0, 0, 0, 0, 10, 56},
 {gettext("English"), 0,  (Fl_Callback*)cb_Us_help, 0, 0, 0, 0, 10, 56},
 {gettext("Espanol"), 0,  (Fl_Callback*)cb_Spanish_help, 0, 0, 0, 0, 10, 56},
 {gettext("Forum"), 0xffc8,  (Fl_Callback*)cb_Forum_help, 0, 0, 0, 0, 10, 56},
 {0},
 {0}
};

Fl_Group *Eqw_group=(Fl_Group *)0;

Fl_Group *Eqw_eqw_group=(Fl_Group *)0;

giac::Eqw *Eqw_eqw=(giac::Eqw *)0;

Fl_Group *Eqw_buttons=(Fl_Group *)0;

Fl_Button *Eqw_save=(Fl_Button *)0;

static void cb_Eqw_save(Fl_Button*, void*) {
  cb_Eqw_store(0,0);
}

Fl_Button *Eqw_ok=(Fl_Button *)0;

static void cb_Eqw_ok(Fl_Button*, void*) {
  eqw_ok(false);
}

Fl_Button *Eqw_left=(Fl_Button *)0;

static void cb_Eqw_left(Fl_Button*, void*) {
  Eqw_eqw->select_left(2);
}

Fl_Button *Eqw_right=(Fl_Button *)0;

static void cb_Eqw_right(Fl_Button*, void*) {
  Eqw_eqw->select_right(2);
}

Fl_Button *Eqw_copy=(Fl_Button *)0;

static void cb_Eqw_copy(Fl_Button*, void*) {
  Eqw_eqw->parse_desactivate(); eqw_clipboard=Eqw_eqw->get_selection();
}

Fl_Button *Eqw_undo=(Fl_Button *)0;

static void cb_Eqw_undo(Fl_Button*, void*) {
  Eqw_eqw->rcl_data();
}

Fl_Button *Eqw_exec=(Fl_Button *)0;

static void cb_Eqw_exec(Fl_Button*, void*) {
  string s;
gen g=Eqw_eqw->get_selection();
if (g.type==_STRNG)
  s=*g._STRNGptr;
else
  s=g.print();
input_value(s.c_str());
Eqw_eqw->select_down(1);
input_eval2(false);
}

Fl_Button *Eqw_down=(Fl_Button *)0;

static void cb_Eqw_down(Fl_Button*, void*) {
  Eqw_eqw->ytop -= Eqw_eqw->h()/4;
Eqw_eqw->setscroll();
}

Fl_Group *Help_Chooser=(Fl_Group *)0;

Fl_Group *Help_Chooser_Input_Arrays=(Fl_Group *)0;

Fl_Input *Help_Chooser_Input_Array0=(Fl_Input *)0;

static void cb_Help_Chooser_Input_Array0(Fl_Input*, void*) {
  Fl::focus(Help_Chooser_Input_Array1);
}

Fl_Input *Help_Chooser_Input_Array1=(Fl_Input *)0;

static void cb_Help_Chooser_Input_Array1(Fl_Input*, void*) {
  Fl::focus(Help_Chooser_Input_Array2);
}

Fl_Input *Help_Chooser_Input_Array2=(Fl_Input *)0;

static void cb_Help_Chooser_Input_Array2(Fl_Input*, void*) {
  Fl::focus(Help_Chooser_Input_Array3);
}

Fl_Input *Help_Chooser_Input_Array3=(Fl_Input *)0;

static void cb_Help_Chooser_Input_Array3(Fl_Input*, void*) {
  Fl::focus(Help_Chooser_Input_Array4);
}

Fl_Input *Help_Chooser_Input_Array4=(Fl_Input *)0;

static void cb_Help_Chooser_Input_Array4(Fl_Input*, void*) {
  Fl::focus(Help_Chooser_Input_Array5);
}

Fl_Input *Help_Chooser_Input_Array5=(Fl_Input *)0;

static void cb_Help_Chooser_Input_Array5(Fl_Input*, void*) {
  Fl::focus(Help_Chooser_Input_Array0);
}

Fl_Button *Help_Chooser_OK_with_function=(Fl_Button *)0;

static void cb_Help_Chooser_OK_with_function(Fl_Button*, void*) {
  help_chooser_ok(true);
}

Fl_Return_Button *Help_Chooser_OK=(Fl_Return_Button *)0;

static void cb_Help_Chooser_OK(Fl_Return_Button*, void*) {
  help_chooser_ok(false);
}

Fl_Input *Help_input=(Fl_Input *)0;

static void cb_Help_input(Fl_Input*, void*) {
  make_new_help(Help_input->value());
}

Fl_Button *HTML_Help=(Fl_Button *)0;

static void cb_HTML_Help(Fl_Button*, void*) {
  if (!html_vtt.empty()){
  HTMLindex=min(HTMLindex,html_vtt.size()-1);
  system(browser_command(html_vtt[HTMLindex]).c_str());
  ++HTMLindex;
 };
}

Fl_Button *Help_Chooser_Cancel=(Fl_Button *)0;

static void cb_Help_Chooser_Cancel(Fl_Button*, void*) {
  if ( (old_upper_window_state==upper_window_mtrw) || (old_upper_window_state==upper_window_geo) || (old_upper_window_state==upper_window_eqw) || (old_upper_window_state==upper_window_prog) )
        manage_upper_window(old_upper_window_state,true);
    else 
        manage_upper_window(upper_window_hist,true);
}

Fl_Group *Help_index_group=(Fl_Group *)0;

Fl_Browser *Help_Chooser_Index=(Fl_Browser *)0;

static void cb_Help_Chooser_Index(Fl_Browser*, void*) {
  if (Help_Chooser_Index->value())
  make_new_help(aide_v[Help_Chooser_Index->value()-1].cmd_name.c_str());
}

Fl_Group *Geo_group=(Fl_Group *)0;

Fl_Group *Geo_picture=(Fl_Group *)0;

giac::Image *Picture=(giac::Image *)0;

Fl_Group *Geo_buttons=(Fl_Group *)0;

Fl_Button *Geo_save=(Fl_Button *)0;

static void cb_Geo_save(Fl_Button*, void*) {
  input_value("graph2tex()");
// cb_Save_2dplot_tex(0,0);
input_eval(false);
}

Fl_Button *Geo_zoomin=(Fl_Button *)0;

static void cb_Geo_zoomin(Fl_Button*, void*) {
  Picture->geo_zoom(0.707);
Picture->redraw();
}

Fl_Button *Geo_zoomout=(Fl_Button *)0;

static void cb_Geo_zoomout(Fl_Button*, void*) {
  Picture->geo_zoom(1.414);
Picture->redraw();
}

Fl_Button *Geo_go_left=(Fl_Button *)0;

static void cb_Geo_go_left(Fl_Button*, void*) {
  double d=(Picture->window_xmax-Picture->window_xmin)/10;
Picture->window_xmax+=d;
Picture->window_xmin+=d;
Picture->redraw();
Picture2global_window();
}

Fl_Button *Geo_go_right=(Fl_Button *)0;

static void cb_Geo_go_right(Fl_Button*, void*) {
  double d=(Picture->window_xmax-Picture->window_xmin)/10;
Picture->window_xmax-=d;
Picture->window_xmin-=d;
Picture2global_window();
Picture->redraw();
}

Fl_Button *Geo_go_up=(Fl_Button *)0;

static void cb_Geo_go_up(Fl_Button*, void*) {
  double d=(Picture->window_ymax-Picture->window_ymin)/10;
Picture->window_ymax-=d;
Picture->window_ymin-=d;
Picture2global_window();
Picture->redraw();
}

Fl_Button *Geo_go_down=(Fl_Button *)0;

static void cb_Geo_go_down(Fl_Button*, void*) {
  double d=(Picture->window_ymax-Picture->window_ymin)/10;
Picture->window_ymax+=d;
Picture->window_ymin+=d;
Picture2global_window();
Picture->redraw();
}

Fl_Button *Geo_erase_button=(Fl_Button *)0;

static void cb_Geo_erase_button(Fl_Button*, void*) {
  input->value("erase");
Fl::focus(input);
}

Fl_Button *Geo_axes=(Fl_Button *)0;

static void cb_Geo_axes(Fl_Button*, void*) {
  if (show_axes) show_axes=false; else show_axes=true;
  Picture->redraw();
}

Fl_Button *Geo_show_io=(Fl_Button *)0;

static void cb_Geo_show_io(Fl_Button*, void*) {
  if (!user_screen) 
   user_screen=true; 
 else 
   user_screen=false;
 update_io();
 // change eqw data and PICT data
 swap_io_hist();
 if (user_screen) 
   Picture->plot_instructions_ptr=&graph_instructions; 
 else 
   Picture->plot_instructions_ptr=&plot_instructions;
 Eqw_history->redraw();
 Picture->redraw();
 redraw_mouse_position_only=false;
}

Fl_Group *Geo_buttons_tortue=(Fl_Group *)0;

Fl_Button *Xcas_tortue_button_av=(Fl_Button *)0;

static void cb_Xcas_tortue_button_av(Fl_Button*, void*) {
  input_0arg("avance ");
}

Fl_Button *Xcas_tortue_button_re=(Fl_Button *)0;

static void cb_Xcas_tortue_button_re(Fl_Button*, void*) {
  input_0arg("recule ");
}

Fl_Button *Xcas_tortue_button_td=(Fl_Button *)0;

static void cb_Xcas_tortue_button_td(Fl_Button*, void*) {
  input_0arg("tourne_droite ");
}

Fl_Button *Xcas_tortue_button_tg=(Fl_Button *)0;

static void cb_Xcas_tortue_button_tg(Fl_Button*, void*) {
  input_0arg("tourne_gauche ");
}

Fl_Button *Xcas_tortue_button_pc=(Fl_Button *)0;

static void cb_Xcas_tortue_button_pc(Fl_Button*, void*) {
  input_0arg("pas_de_cote ");
}

Fl_Button *Xcas_tortue_button_sa=(Fl_Button *)0;

static void cb_Xcas_tortue_button_sa(Fl_Button*, void*) {
  input_0arg("saute ");
}

Fl_Button *Xcas_tortue_button_cr=(Fl_Button *)0;

static void cb_Xcas_tortue_button_cr(Fl_Button*, void*) {
  input_0arg("crayon ");
}

Fl_Button *Xcas_tortue_button_ro=(Fl_Button *)0;

static void cb_Xcas_tortue_button_ro(Fl_Button*, void*) {
  input_0arg("rond ");
}

Fl_Button *Xcas_tortue_button_di=(Fl_Button *)0;

static void cb_Xcas_tortue_button_di(Fl_Button*, void*) {
  input_0arg("disque ");
}

Fl_Button *Xcas_tortue_button_rp=(Fl_Button *)0;

static void cb_Xcas_tortue_button_rp(Fl_Button*, void*) {
  input_0arg("rectangle_plein ");
}

Fl_Button *Xcas_tortue_button_tp=(Fl_Button *)0;

static void cb_Xcas_tortue_button_tp(Fl_Button*, void*) {
  input_0arg("triangle_plein ");
}

Fl_Button *Xcas_tortue_button_ef=(Fl_Button *)0;

static void cb_Xcas_tortue_button_ef(Fl_Button*, void*) {
  Picture->turtlezoom=1;Picture->turtlex=0;Picture->turtley=0;input_0arg("efface");
}

Fl_Text_Display *Bighelp=(Fl_Text_Display *)0;

Fl_Group *Debug_group=(Fl_Group *)0;

Fl_Browser *Source_browser=(Fl_Browser *)0;

static void cb_Source_browser(Fl_Browser*, void*) {
  string s("breakpoint(");
s += debug_prog_name;
s += ',';
s += print_INT_(Source_browser->value());
s += ')';
input->value(s.c_str());
Source_browser->value(current_instruction);
}

Fl_Output *Debug_messages=(Fl_Output *)0;

Fl_Browser *Variable_browser=(Fl_Browser *)0;

static void cb_Variable_browser(Fl_Browser*, void*) {
  input_value(Variable_browser->text(Variable_browser->value()));
}

Fl_Group *Debug_buttons=(Fl_Group *)0;

Fl_Button *watch_button=(Fl_Button *)0;

static void cb_watch_button(Fl_Button*, void*) {
  input->value("");input_1arg("watch",false,true);
}

Fl_Button *sst_button=(Fl_Button *)0;

static void cb_sst_button(Fl_Button*, void*) {
  input->value("sst(0)");
input_eval(false);
}

Fl_Button *sst_in_button=(Fl_Button *)0;

static void cb_sst_in_button(Fl_Button*, void*) {
  input->value("sst_in(0)");
input_eval(false);
}

Fl_Button *cont_button=(Fl_Button *)0;

static void cb_cont_button(Fl_Button*, void*) {
  input->value("cont(0)");
input_eval(false);
}

Fl_Button *break_button=(Fl_Button *)0;

static void cb_break_button(Fl_Button*, void*) {
  string s("breakpoint(");
s += debug_prog_name;
s += ',';
s += print_INT_(Source_browser->value());
s += ')';
input->value(s.c_str());
input_eval(false);
}

Fl_Button *kill_button=(Fl_Button *)0;

static void cb_kill_button(Fl_Button*, void*) {
  input->value("kill(0)");
input_eval(false);
}

Fl_Group *Historique=(Fl_Group *)0;

Fl_Group *History_button=(Fl_Group *)0;

Fl_Button *Hist_save_button=(Fl_Button *)0;

static void cb_Hist_save_button(Fl_Button*, void*) {
  cb_Save_session(0,0);
}

Fl_Button *Hist2eqw_button=(Fl_Button *)0;

static void cb_Hist2eqw_button(Fl_Button*, void*) {
  hist2eqw();
}

Fl_Button *Ans_In=(Fl_Button *)0;

static void cb_Ans_In(Fl_Button*, void*) {
  vecteur vv;
int h=history_pos();
if (is_answer)
  vv=history_out;
else
  vv=history_in;
size_t n=vv.size();
if (h){
  h--;
  if (Picture->history_position)
    --Picture->history_position;
  Picture->selected=vector<int>(1,h-erase_pos());
  redraw_mouse_position_only=false;
  Picture->redraw();
  xcas_history_select(h);
if (n>h){
  if (Picture->run_plot_view)
    input_value("");
  input_insert(vv[h].print().c_str(),true);
}  
}
  focus_history();
}

Fl_Button *Ans_Down=(Fl_Button *)0;

static void cb_Ans_Down(Fl_Button*, void*) {
  vecteur vv;
int h=history_pos();
if (is_answer)
  vv=history_out;
else
  vv=history_in;
size_t n=vv.size();
if (h<n-1){
  h++;
  ++Picture->history_position;
  Picture->selected=vector<int>(1,h-erase_pos());
  Picture->redraw();
  redraw_mouse_position_only=false;
  xcas_history_select(h);
}
if (n>h){
  if (Picture->run_plot_view)
    input_value("");
  input_insert(vv[h].print().c_str(),true);
}
  focus_history();
}

Fl_Button *Quest_In=(Fl_Button *)0;

static void cb_Quest_In(Fl_Button*, void*) {
  size_t n=history_in.size();
 int h=history_pos();
 if (n && h>=n)
   h=n-1;
 is_answer=false;
 xcas_history_select(h);
 if (n>h)
  input_insert(history_in[h].print().c_str(),true);
 focus_history();
}

Fl_Button *Answer=(Fl_Button *)0;

static void cb_Answer(Fl_Button*, void*) {
  size_t n=history_out.size();
 int h=history_pos();
 if (n && h>=n)
   h=n-1;
 is_answer=true;
 xcas_history_select(h);
 if (n>h)
  input_insert(history_out[h].print().c_str(),true);
 focus_history();
}

Fl_Button *Roll=(Fl_Button *)0;

static void cb_Roll(Fl_Button*, void*) {
  int i=history_pos();
int s=history_out.size();
if (s-i<2)
  return;
ROLL(s-i);
history_begin_level=0;
history_redraw(i);
i=erase_pos();
Picture->clear();
vecteur args(history_out.begin()+i,history_out.end());
updatePICT(args);
  focus_history();
}

Fl_Button *Rolld=(Fl_Button *)0;

static void cb_Rolld(Fl_Button*, void*) {
  int i=history_pos();
int s=history_out.size();
if (s-i<2)
  return;
ROLLD(s-i);
history_begin_level=0;
history_redraw(i);
i=erase_pos();
Picture->clear();
vecteur args(history_out.begin()+i,history_out.end());
updatePICT(args);
  focus_history();
}

Fl_Button *UNDO=(Fl_Button *)0;

static void cb_UNDO(Fl_Button*, void*) {
  modify_history();
}

Fl_Button *TeX=(Fl_Button *)0;

static void cb_TeX(Fl_Button*, void*) {
  string s;
Eqw * ptr=dynamic_cast<Eqw *> (Fl::focus());
if (ptr){
  try {
    s=gen2tex(ptr->get_selection());
  } catch (std::runtime_error & e){
    s = e.what()+ptr->get_selection().print();
  }
}
else {
  size_t i=min(history_in.size(),history_out.size());
  if (!i) return;
  i=min(i,history_pos());
  s = gen2tex(history_in[i])+"\n=\n"+gen2tex(history_out[i])+'\n';
}
Help_text->value(s.c_str());
Help_text_select();
}

Fl_Button *Show_io=(Fl_Button *)0;

static void cb_Show_io(Fl_Button*, void*) {
  if (!user_screen) 
   user_screen=true; 
 else 
   user_screen=false;
 update_io();
 // change eqw data and PICT data
 swap_io_hist();
 if (user_screen) 
   Picture->plot_instructions_ptr=&graph_instructions; 
 else 
   Picture->plot_instructions_ptr=&plot_instructions;
 Eqw_history->redraw();
 Picture->redraw();
 redraw_mouse_position_only=false;
}

Fl_Group *Historique_output=(Fl_Group *)0;

Fl_Group *Eqw_History_group=(Fl_Group *)0;

giac::Eqw *Eqw_history=(giac::Eqw *)0;

Fl_Group *Text_History_group=(Fl_Group *)0;

Fl_Output *xcas_output=(Fl_Output *)0;

Fl_Scrollbar *Xcas_Output_scroll=(Fl_Scrollbar *)0;

static void cb_Xcas_Output_scroll(Fl_Scrollbar*, void*) {
  ;
int pos;
int val=Xcas_Output_scroll->value();
if (val<history_endlines.size())
  pos=history_endlines[val]-1 ;
else
  pos=0;
// cerr << val << " " << history_endlines.size() << " " <<pos << " " <<string(xcas_output->value()).size() << endl;
xcas_output->position(pos,pos+1);
}

Fl_Group *Spread_group=(Fl_Group *)0;

Fl_Group *Spread_buttons=(Fl_Group *)0;

Fl_Button *Spread_button_save=(Fl_Button *)0;

static void cb_Spread_button_save(Fl_Button*, void*) {
  #ifdef HAVE_LIBFLVW
if (!strcmp(matrixfilename,"session.tab"))
  cb_Spread_store_as(0,0);
else
  save_current_sheet(matrixfilename);
#endif //
}

Fl_Button *Spread_copy_cell=(Fl_Button *)0;

static void cb_Spread_copy_cell(Fl_Button*, void*) {
  #ifdef HAVE_LIBFLVW
spread_ptr->copy();
#endif //
}

Fl_Button *Spread_recompute_button=(Fl_Button *)0;

static void cb_Spread_recompute_button(Fl_Button*, void*) {
  #ifdef HAVE_LIBFLVW
spread_eval_interrupt(spread_ptr->m,spread_ptr->lc,0);
spread_ptr->redraw();
if (Recompute_history->value()){
  run_modif_pos=0; // FIXME find first current_sheet occurance
#ifdef WIN32
  win32_recalc_history();
#else
  run_modif=true;
  child_reeval(run_modif_pos);
  run_modif=false;
#endif
}
#endif //
}

Fl_Button *Spread_insert_row=(Fl_Button *)0;

static void cb_Spread_insert_row(Fl_Button*, void*) {
  #ifdef HAVE_LIBFLVW
spread_ptr->spread_insert(1,0); 
#endif //
}

Fl_Button *Spread_insert_column=(Fl_Button *)0;

static void cb_Spread_insert_column(Fl_Button*, void*) {
  #ifdef HAVE_LIBFLVW  
spread_ptr->spread_insert(0,1); 
#endif //
}

Fl_Input *Spread_goto=(Fl_Input *)0;

static void cb_Spread_goto(Fl_Input*, void*) {
  #ifdef HAVE_LIBFLVW
gen g;
string s;
const char * ch =Spread_goto->value();
int l=strlen(ch);
for (int i=0;i<l;++i,++ch){
  if (*ch==':')
    s += "..";
  else
    s+=*ch;
}
try {
  g=gen(s);
}
catch (std::runtime_error & e){
  Help_text_value(e.what());
  return;
}
int r,c;
if (iscell(g,c,r) ){
  if (r>=spread_ptr->rows()||c>=spread_ptr->cols())
    spread_ptr->resizesheet(max(r+1,spread_ptr->rows()),max(c+1,spread_ptr->cols()));
  // cerr << g << " " << r << " " << c << endl;
  spread_ptr->row(r);
  spread_ptr->col(c);
  spread_ptr->select_start_row(r);
  spread_ptr->select_start_col(c);
  printcell_current_row=r;
  printcell_current_col=c;
  //spread_ptr->redraw();
  if (current_upper_window[0]==upper_window_mtrw){
   string s(spread_ptr->m[r][c][0].print());
          input_value(s.c_str());
	  input_position(s.size(),0);
  }
  return;
}
matrice m;
if (iscell_range(g,spread_ptr->m,spread_ptr->selected,spread_ptr) ){
    g=extractmatricefromsheet(spread_ptr->selected);
    string s(g.print());
    Fl::selection(*spread_ptr,s.c_str(),s.size());
    Help_text_value(s.c_str());
}
#endif //
}

Fl_Menu_Bar *Spread_statistics_menu=(Fl_Menu_Bar *)0;

static void cb_Spread_fill_down(Fl_Menu_*, void*) {
  #ifdef HAVE_LIBFLVW
spread_ptr->copy_down();
#endif //
}

static void cb_Spread_fill_right(Fl_Menu_*, void*) {
  #ifdef HAVE_LIBFLVW
spread_ptr->copy_right();
#endif //
}

static void cb_Spread_fill_selection2(Fl_Menu_*, void*) {
  #ifdef HAVE_LIBFLVW
spread_ptr->copy_first_in_selection();
#endif //
}

static void cb_Spread_classes2(Fl_Menu_*, void*) {
  cb_Spread_classes(0,0);
}

static void cb_Spread_frequencies(Fl_Menu_*, void*) {
  #ifdef HAVE_LIBFLVW
manage_upper_window(upper_window_hist,true);
input_value(("cumulated_frequencies("+current_sheet_string()+")").c_str());
input_eval(false);
#endif //
}

static void cb_Spread_histogram(Fl_Menu_*, void*) {
  #ifdef HAVE_LIBFLVW
manage_upper_window(upper_window_hist,true);
input_value(("histogram("+current_sheet_string()+")").c_str());
input_eval(false);
#endif //
}

static void cb_Spread_stats(Fl_Menu_*, void*) {
  #ifdef HAVE_LIBFLVW
  if (spread_ptr->selected.empty()){
    Help_text->value("Select something first with copy");
    return;
  }
  matrice m=ascsort(spread_ptr->selected,true);
  vecteur moyenne=mean(m,false);
  vecteur ecart=stddev(m,false);
  string res;
  int save_decimal_digits=decimal_digits;
  decimal_digits=4;
  res  =    "mean    :"+gen(moyenne).print();
  res += "\nstddev  :"+gen(ecart).print();
  m=mtran(m);
  int lg=m.size()-1;
  res += "\nmin      :"+m[0].print();
  res += "\ndecile1  :"+m[lg/10].print();
  res += "\nquartile1:"+m[lg/4].print();
  res += "\nmedian   :"+m[lg/2].print();
  res += "\nquartile3:"+m[(3*lg)/4].print();
  res += "\ndecile9  :"+m[(9*lg)/10].print();
  res += "\nmax      :"+m[lg-1].print();
  decimal_digits=save_decimal_digits;
  Help_text->value(res.c_str());
  if (current_upper_window.size()<2)
    xcas_windows(2);
  manage_upper_window(upper_window_full_message,false);
#endif //
}

static void cb_Spread_boxwhistler(Fl_Menu_*, void*) {
  #ifdef HAVE_LIBFLVW
manage_upper_window(upper_window_hist,true);
input_value(("moustache("+current_sheet_string()+")").c_str());
input_eval(false);
#endif //
}

static void cb_Spread_scatterplot(Fl_Menu_*, void*) {
  #ifdef HAVE_LIBFLVW
manage_upper_window(upper_window_hist,true);
input_value(("scatterplot("+current_sheet_string()+")").c_str());
input_eval(false);
#endif //
}

static void cb_Spread_polygonplot(Fl_Menu_*, void*) {
  #ifdef HAVE_LIBFLVW
manage_upper_window(upper_window_hist,true);
input_value(("polygonplot("+current_sheet_string()+")").c_str());
input_eval(false);
#endif //
}

static void cb_Spread_not_implemented(Fl_Menu_*, void*) {
  #ifdef HAVE_LIBFLVW
#endif //
}

Fl_Menu_Item menu_Spread_statistics_menu[] = {
 {gettext("fill"), 0,  0, 0, 64, 0, 0, 12, 56},
 {gettext("down"), 0,  (Fl_Callback*)cb_Spread_fill_down, 0, 0, 0, 0, 12, 56},
 {gettext("to the right"), 0,  (Fl_Callback*)cb_Spread_fill_right, 0, 0, 0, 0, 12, 56},
 {gettext("to selection"), 0,  (Fl_Callback*)cb_Spread_fill_selection2, 0, 0, 0, 0, 12, 56},
 {0},
 {gettext("1d"), 0,  0, 0, 64, 0, 0, 12, 56},
 {gettext("Classes"), 0,  (Fl_Callback*)cb_Spread_classes2, 0, 0, 0, 0, 10, 56},
 {gettext("Cumulated frequencies"), 0,  (Fl_Callback*)cb_Spread_frequencies, 0, 0, 0, 0, 12, 56},
 {gettext("Histogram"), 0,  (Fl_Callback*)cb_Spread_histogram, 0, 0, 0, 0, 12, 56},
 {gettext("Statistics_values"), 0,  (Fl_Callback*)cb_Spread_stats, 0, 0, 0, 0, 12, 56},
 {gettext("Boxwhistler"), 0,  (Fl_Callback*)cb_Spread_boxwhistler, 0, 0, 0, 0, 12, 56},
 {0},
 {gettext("2d"), 0,  0, 0, 64, 0, 0, 12, 56},
 {gettext("Scatterplot"), 0,  (Fl_Callback*)cb_Spread_scatterplot, 0, 0, 0, 0, 12, 56},
 {gettext("Polygonplot"), 0,  (Fl_Callback*)cb_Spread_polygonplot, 0, 0, 0, 0, 12, 56},
 {0},
 {gettext("inf"), 0,  0, 0, 64, 0, 0, 12, 56},
 {gettext("To be implemented"), 0,  (Fl_Callback*)cb_Spread_not_implemented, 0, 0, 0, 0, 12, 56},
 {0},
 {0}
};

Fl_Menu_Button *Xcas_matrix_list_menu=(Fl_Menu_Button *)0;

static void cb_Xcas_matrix_list_new(Fl_Menu_* o, void*) {
  #ifdef HAVE_LIBFLVW
  if (!strcmp(o->text(),matrixfilename))
     return;
  save_current_xcas_matrix(matrixfilename);
  xcas_matrix & e=Xcas_matrix_map[o->text()];
  spread_ptr->m=makefreematrice(e.m);
  spread_ptr->rows(e.rows);
  spread_ptr->row(e.row);
  spread_ptr->cols(e.cols);
  spread_ptr->select_start_row(e.row_end);
  spread_ptr->col(e.col);
  spread_ptr->select_start_col(e.col_end);
  spread_ptr->is_spreadsheet=e.is_spreadsheet;
  spread_ptr->redraw();
  Xcas_matrix_filename_value(o->text());
  spread_ptr->changed=e.changed;
#endif //
}

Fl_Menu_Item menu_Xcas_matrix_list_menu[] = {
 {gettext("session.tab"), 0,  (Fl_Callback*)cb_Xcas_matrix_list_new, 0, 0, 0, 0, 14, 56},
 {0}
};

Fl_Group *Programme=(Fl_Group *)0;

Fl_Group *Programme_boutons=(Fl_Group *)0;

Fl_Button *Button_program_save=(Fl_Button *)0;

static void cb_Button_program_save(Fl_Button*, void*) {
  cb_Program_store(0,0);
}

Fl_Menu_Button *Xcas_program_list_menu=(Fl_Menu_Button *)0;

static void cb_Xcas_program_list_new(Fl_Menu_* o, void*) {
  int i,j;
    Program_editor_position(i,j);
    Xcas_program_map[progfilename]=editor_string(Program_editor_value(),editor_changed,i,j);
  editor_string & e=Xcas_program_map[o->text()];
  Program_editor->buffer()->text(e.s.c_str());
  if (e.pos1==e.pos2)
    Program_editor->insert_position(e.pos1);
  else
    Program_editor->buffer()->select(e.pos1,e.pos2);
  Program_editor->buffer()->call_modify_callbacks();
  Xcas_editor_filename_value(o->text());
  editor_changed=e.changed;
}

Fl_Menu_Item menu_Xcas_program_list_menu[] = {
 {gettext("session.cxx"), 0,  (Fl_Callback*)cb_Xcas_program_list_new, 0, 0, 0, 0, 14, 56},
 {0}
};

Fl_Button *Button_program_load=(Fl_Button *)0;

static void cb_Button_program_load(Fl_Button*, void*) {
  load_current_program(0);
}

Fl_Button *Prg_fini=(Fl_Button *)0;

static void cb_Prg_fini(Fl_Button*, void*) {
  cb_Program_store(0,0);
  manage_upper_window(upper_window_hist,false);
  string s="read(\""+string(Xcas_editor_filename->value())+"\")";
  input->value(s.c_str());
  // if current_program is in history modify instead of add
  if (!rpn_mode && !run_modif){ 
    int pos;
    try {
      gen g(s);
      const_iterateur it=history_in.begin(),itend=history_in.end();
      --it;
      --itend;
      for (;it!=itend;--itend){
        gen tmp=*itend; // cerr << tmp << endl;
        if (tmp==g){
            run_modif=true;
            run_modif_pos=itend-it-1;
            input_eval(false);
            return;
        }
      }
      input_eval(false);
    }
    catch(std::runtime_error & e){
      run_modif=false;
    }
  }
  else
    input_eval(false); 
  // end if ...;
}

Fl_Button *Button_program_save_and_compile=(Fl_Button *)0;

static void cb_Button_program_save_and_compile(Fl_Button*, void*) {
  gen g;
try {
  g=gen(Program_editor_value());
}
catch (std::runtime_error & e){
  cerr << e.what() << endl;
}
if (giac::first_error_line){
  int pos1=Program_editor->buffer()->skip_lines(0,giac::first_error_line-1);
  int pos2=Program_editor->buffer()->skip_lines(pos1,1);
  Program_editor->buffer()->select(pos1,pos2);
  Program_editor->show_insert_position();
  Programme->redraw();
  Help_text_value((gettext("Parse error line ")+print_INT_(giac::first_error_line)+ gettext(" at ") +giac::error_token_name).c_str());
}
else
 Help_text_value((string("Success, ")+progfilename+string(" saved\n")+check_local_assign(g)).c_str());
}

Fl_Button *Button_program_exec_line=(Fl_Button *)0;

static void cb_Button_program_exec_line(Fl_Button*, void*) {
  if (current_upper_window.size()<2){
  xcas_windows(2);
  manage_upper_window(upper_window_hist,false);
  manage_upper_window(upper_window_prog,false);
}
int r= Program_editor->insert_position();
char * ch=Program_editor->buffer()->line_text(r);
string s=ch;
free(ch);
gen g;
try {
  g=gen(s);
}
catch (std::runtime_error & e){
  cerr << e.what() << endl;
}
 int next=Program_editor->buffer()->line_end(r)+1;
 int nextend=Program_editor->buffer()->line_end(next);
 Program_editor->insert_position(next);
 Program_editor->show_insert_position();
 Program_editor->buffer()->select(next,nextend);
 Programme->redraw();
 input_value(s.c_str());
if (giac::first_error_line){
  Help_text_value((gettext("Parse error at ") +giac::error_token_name).c_str());
}
 else {
 input_eval(false);
};
}

Fl_Button *Button_func=(Fl_Button *)0;

static void cb_Button_func(Fl_Button*, void*) {
  int pos1=Program_editor->insert_position();
if (maple_mode==3){
  Program_editor->buffer()->insert(pos1,":f(x,y)\n:Func\n:Local z\n:\n:EndFunc\n");
  return;
}
if (maple_mode==2){
  Program_editor->buffer()->insert(pos1,"f:=proc(x,y)->\nlocal z;\nbegin\n\nend_proc;\n");
  return;
}
if (maple_mode==1){
  Program_editor->buffer()->insert(pos1,"f:=proc(x,y)->\nlocal z;\n\nend;\n");
  return;
}
if (maple_mode==0){
  Program_editor->buffer()->insert(pos1,"f(x,y):={\nlocal z;\n\n}\n");
  return;
};
}

Fl_Button *Prg_semi=(Fl_Button *)0;

static void cb_Prg_semi(Fl_Button*, void*) {
  if (maple_mode==3) input_char(':'); else input_char(';');
}

Fl_Return_Button *Button_Insert_Return=(Fl_Return_Button *)0;

static void cb_Button_Insert_Return(Fl_Return_Button*, void*) {
  input_enter(); if (maple_mode==3) input_char(':');
}

Fl_Button *Button_ifte=(Fl_Button *)0;

static void cb_Button_ifte(Fl_Button*, void*) {
  make_new_help("if");
  Program_editor->buffer()->insert(Program_editor->insert_position(),symb_ifte(symbolic(at_inferieur_strict,makevecteur(vx_var,0)),1,0).print().c_str());
}

Fl_Button *Button_for=(Fl_Button *)0;

static void cb_Button_for(Fl_Button*, void*) {
  make_new_help("for");
  Program_editor->buffer()->insert(Program_editor->insert_position(),symb_for(symbolic(at_sto,makevecteur(1,vx_var)),symbolic(at_inferieur_strict,makevecteur(vx_var,9)),symbolic(at_sto,makevecteur(vx_var+1,vx_var)),symb_bloc(0)).print().c_str());
}

Fl_Button *Button_return=(Fl_Button *)0;

static void cb_Button_return(Fl_Button*, void*) {
  string s=gen(symbolic(at_return,vx_var)).print();
if (maple_mode!=3)
  s += ";\n";
else
  s += "\n:";
Program_editor->buffer()->insert(Program_editor->insert_position(),s.c_str());
}

Fl_Text_Editor *Program_editor=(Fl_Text_Editor *)0;

Fl_Input *Editor_search=(Fl_Input *)0;

static void cb_Editor_search(Fl_Input*, void*) {
  string s(Editor_search->value());
  if (s.empty())
    return;
  int pos = Program_editor->insert_position();
  int found = Program_editor->buffer()->search_forward(pos, s.c_str(), &pos);
  if (found) {
    // Found a match; select and update the position...
    Program_editor->buffer()->select(pos, pos+s.size());
    Program_editor->insert_position(pos+s.size());
    Program_editor->show_insert_position();
    Program_editor->redraw();
    Fl::focus(Program_editor);
  }
  else fl_alert("No occurrences of '%s' found!", s.c_str());
}

Fl_Button *Editor_next=(Fl_Button *)0;

static void cb_Editor_next(Fl_Button*, void*) {
  cb_Editor_search(0,0);
}

Fl_Input *Editor_replace=(Fl_Input *)0;

static void cb_Editor_replace(Fl_Input* o, void*) {
  const char *find = Editor_search->value();
  const char *replace = Editor_replace->value();
  if (find[0] == 0)
    return;
  int pos = Program_editor->insert_position(),n=0;
  while (Program_editor->buffer()->search_forward(pos, find, &pos)) {
    Program_editor->buffer()->select(pos, pos+strlen(find));
    Program_editor->redraw();
    if (n!=2){
      Fl::focus(Program_editor);
      Fl::redraw(); // Fl::check();
      usleep(500000);
      Fl_Window * w = new Fl_Window(108,30);
      w->hotspot(Editor_next);
      Fl_Button * button0 = new Fl_Button(2,2,30,16);
      button0->shortcut("^[");
      button0->label(gettext("Yes"));
      Fl_Button * button1 = new Fl_Button(34,2,30,16);
      button1->label(gettext("No"));
      Fl_Button * button2 = new Fl_Button(66,2,40,16);
      button2->label(gettext("All"));
      w->end();
      w->resizable(w);
      w->set_modal();
      w->show();
      for (;;){
        Fl_Widget *o = Fl::readqueue();
        if (o){
	  if (o==button0) { n=0; break;}
	  if (o==button1){ n=1; break; }
          if (o==button2) { n=2; break; }
          if (o==w) { n=3; break; }
        }
	else Fl::wait();
      }
      w->hide();
      delete button2;
      delete button1;
      delete button0;
      delete w;
    }
    if (n==3)
      break;
    if (n==1){
      pos += strlen(find);
      Program_editor->insert_position(pos);
    }
    else {
      Program_editor->buffer()->remove_selection();
      Program_editor->buffer()->insert(pos, replace);
      pos += strlen(replace);
      Program_editor->insert_position(pos);
    }
  };
}

Fl_Output *Xcas_editor_filename=(Fl_Output *)0;

Fl_Group *Input_group=(Fl_Group *)0;

Fl_Group *bandeau=(Fl_Group *)0;

Fl_Button *PREV=(Fl_Button *)0;

static void cb_PREV(Fl_Button*, void*) {
  if (rpn_menu_page )
  --rpn_menu_page;
else
  rpn_menu_page=rpn_menu.size()/6;
show_rpn_menu(rpn_menu_page);
}

Fl_Button *F1=(Fl_Button *)0;

static void cb_F1(Fl_Button*, void*) {
  rpn_button(0);
}

Fl_Button *F2=(Fl_Button *)0;

static void cb_F2(Fl_Button*, void*) {
  rpn_button(1);
}

Fl_Button *F3=(Fl_Button *)0;

static void cb_F3(Fl_Button*, void*) {
  rpn_button(2);
}

Fl_Button *F4=(Fl_Button *)0;

static void cb_F4(Fl_Button*, void*) {
  rpn_button(3);
}

Fl_Button *F5=(Fl_Button *)0;

static void cb_F5(Fl_Button*, void*) {
  rpn_button(4);
}

Fl_Button *F6=(Fl_Button *)0;

static void cb_F6(Fl_Button*, void*) {
  rpn_button(5);
}

Fl_Button *NXT=(Fl_Button *)0;

static void cb_NXT(Fl_Button*, void*) {
  if ( ((rpn_menu_page+1)*6) < rpn_menu.size() )
   ++rpn_menu_page;
else
   rpn_menu_page=0;
show_rpn_menu(rpn_menu_page);
}

Fl_Button *CST=(Fl_Button *)0;

static void cb_CST(Fl_Button*, void*) {
  gen e=protecteval(CST__IDNT_e,2,0);
  if (e.type==_VECT){
    rpn_menu=*e._VECTptr;
    show_rpn_menu(0);
  };
}

Fl_Button *VAR=(Fl_Button *)0;

static void cb_VAR(Fl_Button*, void*) {
  // if (variables_are_files){
    gen e=_VARS(1,0);
    rpn_menu=*e._VECTptr;
    show_rpn_menu(0);
  //}
  //else {
  //  input_value("VARS");
  //  input_eval(false);
  //};
}

Fl_Button *Home_button=(Fl_Button *)0;

static void cb_Home_button(Fl_Button*, void*) {
  rpn_menu=home_menu;
show_rpn_menu(0);
}

Fl_Button *Eqw_button=(Fl_Button *)0;

static void cb_Eqw_button(Fl_Button*, void*) {
  manage_upper_window(upper_window_eqw,false); Fl::focus(Eqw_eqw);
}

Fl_Button *Plot_view=(Fl_Button *)0;

static void cb_Plot_view(Fl_Button*, void*) {
  int tmp = Fl::event_x_root();
          tmp -= Fl::event_x();
          // tmp -= Plot_view->x();
          tmp += Picture->x();
          Picture->dx=tmp;
          tmp = Fl::event_y_root();
          tmp -= Fl::event_y();
          // tmp -= Plot_view->y();
          tmp += Picture->y();
          Picture->dy=tmp;
          Picture->run_plot_view=true;
          manage_upper_window(upper_window_geo,false); 
          redraw_mouse_position_only=false;
          Picture->redraw();
}

Fl_Button *Help_online=(Fl_Button *)0;

static void cb_Help_online(Fl_Button*, void*) {
  help_save_focus=Fl::focus();
Fl::focus(Help_input);
manage_upper_window(upper_window_help,false);
    if (!help_chooser && !(help_hint %10) ){
      fl_message(gettext("Hint: you can use the gen configuration button to get help automatically"));
    }
    ++help_hint;
}

Fl_Button *Show_history=(Fl_Button *)0;

static void cb_Show_history(Fl_Button*, void*) {
  Fl::focus(eval_last_focus);
manage_upper_window(upper_window_hist,false);
}

Fl_Button *Full_message=(Fl_Button *)0;

static void cb_Full_message(Fl_Button*, void*) {
  manage_upper_window(upper_window_full_message,false);
}

Fl_Button *MTRW=(Fl_Button *)0;

static void cb_MTRW(Fl_Button*, void*) {
  #ifdef HAVE_LIBFLVW
if (current_upper_window[0]==upper_window_mtrw){
  spread_ptr->is_spreadsheet=!spread_ptr->is_spreadsheet;
  if (spread_ptr->is_spreadsheet)
    spread_eval_interrupt(spread_ptr->m,0);
  update_sheet_label();
  spread_ptr->redraw();
  return;
}
#endif //
Picture->run_plot_view=false;
manage_upper_window(upper_window_mtrw,false);
}

Fl_Button *Prog_button=(Fl_Button *)0;

static void cb_Prog_button(Fl_Button*, void*) {
  manage_upper_window(upper_window_prog,false);
}

Fl_Group *bandeau2=(Fl_Group *)0;

Fl_Button *bandeau_fill=(Fl_Button *)0;

static void cb_bandeau_fill(Fl_Button*, void*) {
  a_propos(); Fl::focus(eval_last_focus);
manage_upper_window(upper_window_hist,false); 
if (!history_saved)
  cb_Save_session(0,0);
save_current_sheet(matrixfilename);
bandeau_fill_label_redraw();
}

Fl_Button *bandeau_fill2=(Fl_Button *)0;

static void cb_bandeau_fill2(Fl_Button*, void*) {
  a_propos(); Fl::focus(eval_last_focus);
manage_upper_window(upper_window_hist,false);
xcas_windows(1); Left_Xcas_resize(); history_redraw(history_in.size());
if (user_screen)
  cb_Show_io(0,0);
current_folder_name=zero;
}

Fl_Button *Eqw_button2=(Fl_Button *)0;

static void cb_Eqw_button2(Fl_Button*, void*) {
  manage_upper_window(upper_window_eqw,false); Fl::focus(Eqw_eqw);
}

Fl_Button *Plot_view2=(Fl_Button *)0;

static void cb_Plot_view2(Fl_Button*, void*) {
  int tmp = Fl::event_x_root();
          tmp -= Fl::event_x();
          // tmp -= Plot_view->x();
          tmp += Picture->x();
          Picture->dx=tmp;
          tmp = Fl::event_y_root();
          tmp -= Fl::event_y();
          // tmp -= Plot_view->y();
          tmp += Picture->y();
          Picture->dy=tmp;
          Picture->run_plot_view=true;
          manage_upper_window(upper_window_geo,false); 
          redraw_mouse_position_only=false;
          Picture->redraw();
}

Fl_Button *Help_online2=(Fl_Button *)0;

static void cb_Help_online2(Fl_Button*, void*) {
  help_save_focus=Fl::focus();
Fl::focus(Help_input);
manage_upper_window(upper_window_help,false);
    if (!help_chooser && !(help_hint %10) ){
      fl_message(gettext("Hint: you can use the gen configuration button to get help automatically"));
    }
    ++help_hint;
}

Fl_Button *Show_history2=(Fl_Button *)0;

static void cb_Show_history2(Fl_Button*, void*) {
  Fl::focus(eval_last_focus);
manage_upper_window(upper_window_hist,false);
}

Fl_Button *Full_message2=(Fl_Button *)0;

static void cb_Full_message2(Fl_Button*, void*) {
  manage_upper_window(upper_window_full_message,false);
}

Fl_Button *MTRW2=(Fl_Button *)0;

static void cb_MTRW2(Fl_Button*, void*) {
  #ifdef HAVE_LIBFLVW
if (current_upper_window[0]==upper_window_mtrw){
  spread_ptr->is_spreadsheet=!spread_ptr->is_spreadsheet;
  if (spread_ptr->is_spreadsheet && Spreadsheet_recompute->value())
    spread_eval_interrupt(spread_ptr->m,0);
  update_sheet_label();
  spread_ptr->redraw();
  return;
}
#endif //
Picture->run_plot_view=false;
manage_upper_window(upper_window_mtrw,false);
}

Fl_Button *Prog_button2=(Fl_Button *)0;

static void cb_Prog_button2(Fl_Button*, void*) {
  manage_upper_window(upper_window_prog,false);
}

Fl_Button *Xcas_var=(Fl_Button *)0;

static void cb_Xcas_var(Fl_Button*, void*) {
  gen e;
    if (!select_user_var(100,200,e,0))
      return;
    input->insert(e.print().c_str());
}

Fl_Input *input_old=(Fl_Input *)0;

static void cb_input_old(Fl_Input*, void*) {
  eval_last_focus=input;
input_eval(false);
}

giac::Input_tab *input=(giac::Input_tab *)0;

static void cb_input(giac::Input_tab*, void*) {
  eval_last_focus=input;
input_eval(false);
}

Fl_Group *Status_group=(Fl_Group *)0;

Fl_Output *Xcas_mode=(Fl_Output *)0;

static void cb_Xcas_mode(Fl_Output*, void*) {
  cerr << "Click" << endl;
}

Fl_Button *Geo_setup_button=(Fl_Button *)0;

static void cb_Geo_setup_button(Fl_Button*, void*) {
  plot_setup();
}

Fl_Button *Cas_setup_button=(Fl_Button *)0;

static void cb_Cas_setup_button(Fl_Button*, void*) {
  fltk_cas_setup();
}

Fl_Button *Gen_setup=(Fl_Button *)0;

static void cb_Gen_setup(Fl_Button*, void*) {
  general_setup();
}

Fl_Button *Xcas_Computation_progress=(Fl_Button *)0;

Fl_Group *Message_group=(Fl_Group *)0;

Fl_Output *Help_text=(Fl_Output *)0;

Fl_Button *Send_kill_to_child=(Fl_Button *)0;

static void cb_Send_kill_to_child(Fl_Button*, void*) {
  if (interrupt_button){
//   kill(getpid(),SIGINT);
   ctrl_c=true;
   return;
 }
 if (child_id){
  kill(child_id,SIGKILL);
    history_in=undo_history_in;
    history_out=undo_history_out;
  history_begin_level=0;
  // Send_kill_to_child->labelcolor(FL_WHITE);
  child_id=0;
  Help_text_value("Interrupted");
};
}

Fl_Group *Direction_group2=(Fl_Group *)0;

Fl_Button *Geo_left=(Fl_Button *)0;

static void cb_Geo_left(Fl_Button*, void*) {
  cb_Move_selection_left(0,0);
}

Fl_Button *Geo_right=(Fl_Button *)0;

static void cb_Geo_right(Fl_Button*, void*) {
  cb_Move_selection_right(0,0);
}

Fl_Button *Geo_haut=(Fl_Button *)0;

static void cb_Geo_haut(Fl_Button*, void*) {
  cb_En_haut(0,0);
}

Fl_Button *Geo_bas=(Fl_Button *)0;

static void cb_Geo_bas(Fl_Button*, void*) {
  cb_En_bas(0,0);
}

Fl_Button *Geo_backspace=(Fl_Button *)0;

static void cb_Geo_backspace(Fl_Button*, void*) {
  handle_backspace();
}

Fl_Button *Geo_eval=(Fl_Button *)0;

static void cb_Geo_eval(Fl_Button*, void*) {
  cb_Select_eval(0,0);
}

Fl_Button *Geo_paste=(Fl_Button *)0;

static void cb_Geo_paste(Fl_Button*, void*) {
  cb_Prg_paste(0,0);
}

Fl_Button *Geo_tab=(Fl_Button *)0;

static void cb_Geo_tab(Fl_Button*, void*) {
  cb_Tabulation(0,0);
}

Fl_Button *Geo_kbd=(Fl_Button *)0;

static void cb_Geo_kbd(Fl_Button*, void*) {
  cb_Show_kbd(0,0);
}

Fl_Button *Geo_esc=(Fl_Button *)0;

static void cb_Geo_esc(Fl_Button*, void*) {
  cb_Echappement(0,0);
}

Fl_Button *Geo_enter=(Fl_Button *)0;

static void cb_Geo_enter(Fl_Button*, void*) {
  cb_ENTER(0,0);
}

Fl_Group *Direction_group=(Fl_Group *)0;

Fl_Button *En_haut=(Fl_Button *)0;

static void cb_En_haut(Fl_Button*, void*) {
  Eqw * eqwptr = dynamic_cast<Eqw *>(Fl::focus());
  if (eqwptr){
    eqwptr->select_up(!shifton());
    return;
  }
  if (Fl::focus()==xcas_output){
    cb_Ans_In(0,0);
  }
  else {
  if (Fl::focus()==En_haut)
    Fl::focus(input);
  petit_buffer[0]=0;
  Fl::e_length=0;
  Fl::e_text=petit_buffer;
  Fl::e_keysym=FL_Up;
  fl_handle();
  };
}

Fl_Button *En_bas=(Fl_Button *)0;

static void cb_En_bas(Fl_Button*, void*) {
  Eqw * eqwptr = dynamic_cast<Eqw *>(Fl::focus());
  if (eqwptr){
    eqwptr->select_down(!shifton());
    return;
  }
  if (Fl::focus()==xcas_output){
    cb_Ans_Down(0,0);
  } else {
  if (Fl::focus()==input) 
    decrease_selection();
  else {
    petit_buffer[0]=0;
    Fl::e_length=0;
    Fl::e_text=petit_buffer;
    Fl::e_keysym=FL_Down;
    fl_handle();
  }
  };
}

Fl_Button *Move_selection_right=(Fl_Button *)0;

static void cb_Move_selection_right(Fl_Button*, void*) {
  Eqw * eqwptr = dynamic_cast<Eqw *>(Fl::focus());
  if (eqwptr){
    eqwptr->select_right(!shifton());
    return;
  }
  if (Fl::focus()==input) 
    move_selection_right();
  else {
   if (Fl::focus()==xcas_output)
     Fl::focus(input);
    petit_buffer[0]=0;
    Fl::e_length=0;
    Fl::e_text=petit_buffer;
    Fl::e_keysym=FL_Right;
    fl_handle();
  };
}

Fl_Button *Move_selection_left=(Fl_Button *)0;

static void cb_Move_selection_left(Fl_Button*, void*) {
  Eqw * eqwptr = dynamic_cast<Eqw *>(Fl::focus());
  if (eqwptr){
    eqwptr->select_left(!shifton());
    return;
  }
  if (Fl::focus()==input) 
    move_selection_left();
  else {
    if (Fl::focus()==xcas_output)
      Fl::focus(input);
    petit_buffer[0]=0;
    Fl::e_length=0;
    Fl::e_text=petit_buffer;
    Fl::e_keysym=FL_Left;
    fl_handle();
  };
}

Fl_Button *Backspace=(Fl_Button *)0;

static void cb_Backspace(Fl_Button*, void*) {
  handle_backspace();
}

Fl_Button *Prg_paste=(Fl_Button *)0;

static void cb_Prg_paste(Fl_Button*, void*) {
  if (current_upper_window[0]==upper_window_eqw && Fl::focus()==Eqw_eqw){
  Eqw_eqw->parse_desactivate();
  Eqw_eqw->replace_selection(eqw_clipboard);
  return; 
}
#ifdef HAVE_LIBFLVW
if (Fl::focus()==spread_ptr)
  spread_ptr->paste(spread_ptr->selected);
else
#endif //
  Fl::paste(*Fl::focus());
}

Fl_Button *Shift_Key=(Fl_Button *)0;

static void cb_Shift_Key(Fl_Button*, void*) {
  if (shift_on)
    shift_off();
  else {
    shift_on=true;
    if (!Picture->fullscreen){
      Alpha_keyboard->show();
      Scientific_keyboard->hide();
    }
  };
}

Fl_Button *Tabulation=(Fl_Button *)0;

static void cb_Tabulation(Fl_Button*, void*) {
  input_char(char(9));
}

Fl_Group *Keyboard_group=(Fl_Group *)0;

Fl_Group *Alpha_keyboard=(Fl_Group *)0;

Fl_Button *a_key=(Fl_Button *)0;

static void cb_a_key(Fl_Button*, void*) {
  input_char('a');
}

Fl_Button *b_key=(Fl_Button *)0;

static void cb_b_key(Fl_Button*, void*) {
  input_char('b');
}

Fl_Button *c_key=(Fl_Button *)0;

static void cb_c_key(Fl_Button*, void*) {
  input_char('c');
}

Fl_Button *d_key=(Fl_Button *)0;

static void cb_d_key(Fl_Button*, void*) {
  input_char('d');
}

Fl_Button *e_key=(Fl_Button *)0;

static void cb_e_key(Fl_Button*, void*) {
  input_char('e');
}

Fl_Button *f_key=(Fl_Button *)0;

static void cb_f_key(Fl_Button*, void*) {
  input_char('f');
}

Fl_Button *g_key=(Fl_Button *)0;

static void cb_g_key(Fl_Button*, void*) {
  input_char('g');
}

Fl_Button *h_key=(Fl_Button *)0;

static void cb_h_key(Fl_Button*, void*) {
  input_char('h');
}

Fl_Button *i_key=(Fl_Button *)0;

static void cb_i_key(Fl_Button*, void*) {
  input_char('i');
}

Fl_Button *j_key=(Fl_Button *)0;

static void cb_j_key(Fl_Button*, void*) {
  input_char('j');
}

Fl_Button *k_key=(Fl_Button *)0;

static void cb_k_key(Fl_Button*, void*) {
  input_char('k');
}

Fl_Button *l_key=(Fl_Button *)0;

static void cb_l_key(Fl_Button*, void*) {
  input_char('l');
}

Fl_Button *m_key=(Fl_Button *)0;

static void cb_m_key(Fl_Button*, void*) {
  input_char('m');
}

Fl_Button *n_key=(Fl_Button *)0;

static void cb_n_key(Fl_Button*, void*) {
  input_char('n');
}

Fl_Button *o_key=(Fl_Button *)0;

static void cb_o_key(Fl_Button* o, void*) {
  input_char('o');
}

Fl_Button *p_key=(Fl_Button *)0;

static void cb_p_key(Fl_Button*, void*) {
  input_char('p');
}

Fl_Button *q_key=(Fl_Button *)0;

static void cb_q_key(Fl_Button*, void*) {
  input_char('q');
}

Fl_Button *r_key=(Fl_Button *)0;

static void cb_r_key(Fl_Button*, void*) {
  input_char('r');
}

Fl_Button *s_key=(Fl_Button *)0;

static void cb_s_key(Fl_Button*, void*) {
  input_char('s');
}

Fl_Button *t_key=(Fl_Button *)0;

static void cb_t_key(Fl_Button*, void*) {
  input_char('t');
}

Fl_Button *u_key=(Fl_Button *)0;

static void cb_u_key(Fl_Button*, void*) {
  input_char('u');
}

Fl_Button *v_key=(Fl_Button *)0;

static void cb_v_key(Fl_Button*, void* v) {
  input_char('v');
}

Fl_Button *w_key=(Fl_Button *)0;

static void cb_w_key(Fl_Button*, void*) {
  input_char('w');
}

Fl_Button *x_key=(Fl_Button *)0;

static void cb_x_key(Fl_Button*, void*) {
  input_char('x');
}

Fl_Button *y_key=(Fl_Button *)0;

static void cb_y_key(Fl_Button*, void*) {
  input_char('y');
}

Fl_Button *z_key=(Fl_Button *)0;

static void cb_z_key(Fl_Button*, void*) {
  input_char('z');
}

Fl_Button *Inferieur_key=(Fl_Button *)0;

static void cb_Inferieur_key(Fl_Button*, void*) {
  input_char('<');
}

Fl_Button *Superieur_key=(Fl_Button *)0;

static void cb_Superieur_key(Fl_Button*, void*) {
  input_char('>');
}

Fl_Button *Backslash_key=(Fl_Button *)0;

static void cb_Backslash_key(Fl_Button*, void*) {
  input_char('\\');
}

Fl_Button *Parenthese_ouvrante_key=(Fl_Button *)0;

static void cb_Parenthese_ouvrante_key(Fl_Button*, void*) {
  input_char('(');
}

Fl_Button *Parenthese_fermante_key=(Fl_Button *)0;

static void cb_Parenthese_fermante_key(Fl_Button*, void*) {
  input_char(')');
}

Fl_Button *Espace_key=(Fl_Button *)0;

static void cb_Espace_key(Fl_Button*, void*) {
  input_char(' ');
}

Fl_Button *Point_exclamation_key=(Fl_Button *)0;

static void cb_Point_exclamation_key(Fl_Button*, void*) {
  input_char('!');
}

Fl_Button *Crochet_fermant_key=(Fl_Button *)0;

static void cb_Crochet_fermant_key(Fl_Button*, void*) {
  input_char(']');
}

Fl_Button *Crochet_ouvrant_key=(Fl_Button *)0;

static void cb_Crochet_ouvrant_key(Fl_Button*, void*) {
  input_char('[');
}

Fl_Button *Accolade_ouvrant_key=(Fl_Button *)0;

static void cb_Accolade_ouvrant_key(Fl_Button*, void*) {
  input_char('{');
}

Fl_Button *Accolade_fermant_key=(Fl_Button *)0;

static void cb_Accolade_fermant_key(Fl_Button*, void*) {
  input_char('}');
}

Fl_Button *Deux_points_key=(Fl_Button *)0;

static void cb_Deux_points_key(Fl_Button*, void*) {
  input_char(':');
}

Fl_Button *Equal_key=(Fl_Button *)0;

static void cb_Equal_key(Fl_Button*, void*) {
  input_char('=');
}

Fl_Button *Guillemet_key=(Fl_Button *)0;

static void cb_Guillemet_key(Fl_Button*, void*) {
  input_char('"');
}

Fl_Button *Souligne_key=(Fl_Button *)0;

static void cb_Souligne_key(Fl_Button*, void*) {
  input_char('_');
}

Fl_Button *Majuscule_key=(Fl_Button *)0;

static void cb_Majuscule_key(Fl_Button* o, void* v) {
  if (maj){
  maj=false;
  Majuscule_key->label("Maj");
  a_key->label("a");
  b_key->label("b");
  c_key->label("c");
  d_key->label("d");
  e_key->label("e");
  f_key->label("f");
  g_key->label("g");
  h_key->label("h");
  i_key->label("i");
  j_key->label("j");
  k_key->label("k");
  l_key->label("l");
  m_key->label("m");
  n_key->label("n");
  o_key->label("o");
  p_key->label("p");
  q_key->label("q");
  r_key->label("r");
  s_key->label("s");
  t_key->label("t");
  u_key->label("u");
  v_key->label("v");
  w_key->label("w");
  x_key->label("x");
  y_key->label("y");
  z_key->label("z");
}
else {
  maj=true;
  Majuscule_key->label("Min");
  a_key->label("A");
  b_key->label("B");
  c_key->label("C");
  d_key->label("D");
  e_key->label("E");
  f_key->label("F");
  g_key->label("G");
  h_key->label("H");
  i_key->label("I");
  j_key->label("J");
  k_key->label("K");
  l_key->label("L");
  m_key->label("M");
  n_key->label("N");
  o_key->label("O");
  p_key->label("P");
  q_key->label("Q");
  r_key->label("R");
  s_key->label("S");
  t_key->label("T");
  u_key->label("U");
  v_key->label("V");
  w_key->label("W");
  x_key->label("X");
  y_key->label("Y");
  z_key->label("Z");
	}
Alpha_keyboard->redraw();
}

Fl_Button *Diese_key=(Fl_Button *)0;

static void cb_Diese_key(Fl_Button*, void*) {
  input_char('#');
}

Fl_Button *Pi_key=(Fl_Button *)0;

static void cb_Pi_key(Fl_Button*, void*) {
  input_0arg("pi");
}

Fl_Return_Button *A_la_ligne=(Fl_Return_Button *)0;

static void cb_A_la_ligne(Fl_Return_Button*, void*) {
  Eqw * eqwptr=dynamic_cast<Eqw *> (Fl::focus());
if ( eqwptr ) handle_newline(eqwptr); else input_enter();
}

Fl_Button *Alpha_virgule_key=(Fl_Button *)0;

static void cb_Alpha_virgule_key(Fl_Button*, void*) {
  input_char(',');
}

Fl_Button *Alpha_point_virgule_key=(Fl_Button *)0;

static void cb_Alpha_point_virgule_key(Fl_Button*, void*) {
  input_char(';');
}

Fl_Button *Alpha_quote_key=(Fl_Button *)0;

static void cb_Alpha_quote_key(Fl_Button*, void*) {
  input_char('\'');
}

Fl_Group *Scientific_keyboard=(Fl_Group *)0;

Fl_Menu_Button *Keyboard_intsumdiff=(Fl_Menu_Button *)0;

static void cb_Keyboard_diff(Fl_Menu_*, void*) {
  Eqw * eqwptr= dynamic_cast<Eqw*>(Fl::focus());
  if (eqwptr) 
    Eqw_IDS(eqwptr,symbolic(at_derive,makevecteur(zero,vx_var)));
  else
    input_1arg("diff",false,false);
}

static void cb_Keyboard_integrate(Fl_Menu_*, void*) {
  Eqw * eqwptr= dynamic_cast<Eqw*>(Fl::focus());
  if (eqwptr) 
    Eqw_IDS(eqwptr,symbolic(at_integrate,makevecteur(zero,vx_var,zero,plus_one)));
  else
     input_1arg("integrate",false,false);
}

static void cb_Keyboard_sigma(Fl_Menu_*, void*) {
  Eqw * eqwptr= dynamic_cast<Eqw*>(Fl::focus());
  if (eqwptr) 
    Eqw_IDS(eqwptr,symbolic(at_sum,makevecteur(zero,n__IDNT_e,zero,plus_one)));
  else
    input_1arg("sum",false,false);
}

Fl_Menu_Item menu_Keyboard_intsumdiff[] = {
 {gettext("diff"), 0,  (Fl_Callback*)cb_Keyboard_diff, 0, 0, 0, 0, 12, 56},
 {gettext("integrate"), 0,  (Fl_Callback*)cb_Keyboard_integrate, 0, 0, 0, 0, 12, 56},
 {gettext("sum"), 0,  (Fl_Callback*)cb_Keyboard_sigma, 0, 0, 0, 0, 12, 56},
 {0}
};

Fl_Menu_Button *Keyboard_limseries=(Fl_Menu_Button *)0;

static void cb_Keyboard_limit(Fl_Menu_*, void*) {
  Eqw * eqwptr= dynamic_cast<Eqw*>(Fl::focus());
  if (eqwptr) 
    Eqw_IDS(eqwptr,symbolic(at_limit,makevecteur(zero,vx_var,zero)));
  else
    input_1arg("limit",false,false);
}

static void cb_Keyboard_series(Fl_Menu_*, void*) {
  Eqw * eqwptr= dynamic_cast<Eqw*>(Fl::focus());
  if (eqwptr) 
    Eqw_IDS(eqwptr,symbolic(at_series,makevecteur(zero,vx_var,zero)));
  else
     input_1arg("series",false,false);
}

Fl_Menu_Item menu_Keyboard_limseries[] = {
 {gettext("limit"), 0,  (Fl_Callback*)cb_Keyboard_limit, 0, 0, 0, 0, 12, 56},
 {gettext("series"), 0,  (Fl_Callback*)cb_Keyboard_series, 0, 0, 0, 0, 12, 56},
 {0}
};

Fl_Group *Delim_keyboard=(Fl_Group *)0;

Fl_Button *Double_quote=(Fl_Button *)0;

static void cb_Double_quote(Fl_Button*, void*) {
  input_char('"');
input_char('"');
input->position(input->position()-1,input->position()-1);
}

Fl_Button *RPN_programme=(Fl_Button *)0;

static void cb_RPN_programme(Fl_Button*, void*) {
  if (rpn_mode){
input_char('<');
input_char('<');
input_char(' ');
input_char(' ');
input_char('>');
input_char('>');
input->position(input->position()-3,input->position()-3);
}
else {
input_char('(');
input_char(')');
input->position(input->position()-1,input->position()-1);
};
}

Fl_Button *Brackets=(Fl_Button *)0;

static void cb_Brackets(Fl_Button*, void*) {
  input_char('{');
input_char('}');
input->position(input->position()-1,input->position()-1);
}

Fl_Button *Crochets=(Fl_Button *)0;

static void cb_Crochets(Fl_Button*, void*) {
  input_char('[');
input_char(']');
size_t pos=input->position();
input->position(pos-1,pos-1);
}

Fl_Button *Quote=(Fl_Button *)0;

static void cb_Quote(Fl_Button*, void*) {
  input_char(39);
input_char(39);
input->position(input->position()-1,input->position()-1);
}

Fl_Button *Virgule=(Fl_Button *)0;

static void cb_Virgule(Fl_Button*, void*) {
  input_char(',');
}

Fl_Button *Semi_button=(Fl_Button *)0;

static void cb_Semi_button(Fl_Button*, void*) {
  if (rpn_mode){
   input_char(' ');
   input_char('R');
   input_char('C');
   input_char('L');
   input_char(' ');
   if (direct_entry())   
     input_eval(false);
 }
 else
   input_char(';');
}

Fl_Button *Sto=(Fl_Button *)0;

static void cb_Sto(Fl_Button*, void*) {
  Eqw * eqwptr=dynamic_cast<Eqw *>(Fl::focus());
 if (eqwptr){
      eqwptr->insure_something_selected();
      gen g=eqwptr->get_selection();
      gen tmp=gen(makevecteur(0,g),_SEQ__VECT);
      eqwptr->replace_selection(symbolic(at_sto,tmp));
	return ;
 }
 if (current_upper_window[0]==upper_window_mtrw){
   input_char('=');
   if (!maj)
     cb_Majuscule_key((Fl_Button*)0,(void*)0);
   return;
 }
 if (current_upper_window[0]==upper_window_help || current_upper_window[0]==upper_window_prog){
  if (maple_mode==3)
   input_0arg(" => ");
  else
   input_0arg(" := ");
  }
 if (rpn_mode){
   input_char(' ');
   input_char('S');
   input_char('T');
   input_char('O');
   input_char(' ');
   if (direct_entry())
     input_eval(false);
 }
 else {
  string s(input->value()),t;
  int p;
  if (s.size()==input->mark()-input->position()){
    if (Picture->run_plot_view){
      s=PICTautoname + " := ";
      p=s.size()-4;
    }
    else {
      s=" := ";
      p=0;
    }
  }
  else {
    if (Picture->run_plot_view && s.empty())
      t=PICTautoname;
    p=input->position();
    s=t+s.substr(0,p)+" := "+s.substr(p,s.size()-p);
  }
  input->value(s.c_str());
  input->position(p+4,p+4);
 };
}

Fl_Button *Keyboard_suchthat=(Fl_Button *)0;

static void cb_Keyboard_suchthat(Fl_Button*, void*) {
  binary_op('|');
}

Fl_Button *RPN_space=(Fl_Button *)0;

static void cb_RPN_space(Fl_Button*, void*) {
  input_char(' ');
}

Fl_Group *Transcendental=(Fl_Group *)0;

Fl_Group *Trig_keyboard=(Fl_Group *)0;

Fl_Button *Sinus_button=(Fl_Button *)0;

static void cb_Sinus_button(Fl_Button*, void*) {
  input_1arg("sin",false,true);
}

Fl_Button *Cosinus_button=(Fl_Button *)0;

static void cb_Cosinus_button(Fl_Button*, void*) {
  input_1arg("cos",false,true);
}

Fl_Button *Tangeant_button=(Fl_Button *)0;

static void cb_Tangeant_button(Fl_Button*, void*) {
  input_1arg("tan",false,true);
}

Fl_Button *Asinus_button=(Fl_Button *)0;

static void cb_Asinus_button(Fl_Button*, void*) {
  input_1arg("asin",false,true);
}

Fl_Button *Acosinus_button=(Fl_Button *)0;

static void cb_Acosinus_button(Fl_Button*, void*) {
  input_1arg("acos",false,true);
}

Fl_Button *Atangeant_button=(Fl_Button *)0;

static void cb_Atangeant_button(Fl_Button*, void*) {
  input_1arg("atan",false,true);
}

Fl_Group *Exp_keyboard=(Fl_Group *)0;

Fl_Button *Exp_button=(Fl_Button *)0;

static void cb_Exp_button(Fl_Button*, void*) {
  input_1arg("exp",false,true);
}

Fl_Button *Dix_puissance=(Fl_Button *)0;

static void cb_Dix_puissance(Fl_Button*, void*) {
  input_1arg("10^",false,true);
}

Fl_Button *Ln10_button=(Fl_Button *)0;

static void cb_Ln10_button(Fl_Button*, void*) {
  input_1arg("log10",false,true);
}

Fl_Button *Ln_button=(Fl_Button *)0;

static void cb_Ln_button(Fl_Button*, void*) {
  input_1arg("log",false,true);
}

Fl_Group *Cst_keyboard=(Fl_Group *)0;

Fl_Button *Cst_i=(Fl_Button *)0;

static void cb_Cst_i(Fl_Button*, void*) {
  input_0arg(printi().c_str());
}

Fl_Button *Cst_pi=(Fl_Button *)0;

static void cb_Cst_pi(Fl_Button*, void*) {
  input_char('p');
input_char('i');
}

Fl_Button *Keyboard_infinity=(Fl_Button *)0;

static void cb_Keyboard_infinity(Fl_Button*, void*) {
  input_0arg("infinity");
}

Fl_Button *Keyboard_e=(Fl_Button *)0;

static void cb_Keyboard_e(Fl_Button*, void*) {
  input_0arg("e");
}

Fl_Group *Unary_keyboard=(Fl_Group *)0;

Fl_Button *Racine_carree=(Fl_Button *)0;

static void cb_Racine_carree(Fl_Button*, void*) {
  input_1arg("sqrt",false,true);
}

Fl_Button *Inverse_button=(Fl_Button *)0;

static void cb_Inverse_button(Fl_Button*, void*) {
  input_1arg("inv",false,true);
}

Fl_Button *Plus_moins=(Fl_Button *)0;

static void cb_Plus_moins(Fl_Button*, void*) {
  if (rpn_mode &&!history_out.empty()){
  history_out.back()=-history_out.back();
  history_redraw(history_pos());
}
else
 input_1arg("neg",false,true);
}

Fl_Button *Carre=(Fl_Button *)0;

static void cb_Carre(Fl_Button*, void*) {
  if (Fl::focus()==input && input->position()==input->mark()){
 input_char('^'); input_char('2');
}
else
 input_1arg("sq",false,true);
}

Fl_Group *Binary_keyboard=(Fl_Group *)0;

Fl_Button *Plus=(Fl_Button *)0;

static void cb_Plus(Fl_Button*, void*) {
  binary_op('+');
}

Fl_Button *Moins=(Fl_Button *)0;

static void cb_Moins(Fl_Button*, void*) {
  binary_op('-');
}

Fl_Button *Fois=(Fl_Button *)0;

static void cb_Fois(Fl_Button*, void*) {
  binary_op('*');
}

Fl_Button *Divise=(Fl_Button *)0;

static void cb_Divise(Fl_Button*, void*) {
  binary_op('/');
}

Fl_Button *Puissance=(Fl_Button *)0;

static void cb_Puissance(Fl_Button*, void*) {
  binary_op('^');
}

Fl_Button *C_mod=(Fl_Button *)0;

static void cb_C_mod(Fl_Button*, void*) {
  input_char('%');
}

Fl_Group *Lettre_keyboard=(Fl_Group *)0;

Fl_Button *Variable_x=(Fl_Button *)0;

static void cb_Variable_x(Fl_Button*, void*) {
  input_char('x');
}

Fl_Button *Variable_y=(Fl_Button *)0;

static void cb_Variable_y(Fl_Button*, void*) {
  input_char('y');
}

Fl_Button *Variable_z=(Fl_Button *)0;

static void cb_Variable_z(Fl_Button*, void*) {
  input_char('z');
}

Fl_Button *Key_t=(Fl_Button *)0;

static void cb_Key_t(Fl_Button*, void*) {
  input_char('t');
}

Fl_Button *Evalf=(Fl_Button *)0;

static void cb_Evalf(Fl_Button*, void*) {
  if (current_upper_window[0]==upper_window_mtrw){
#ifdef HAVE_LIBFLVW
       gen g=spread_ptr->m[spread_ptr->row()][spread_ptr->col()][1];
       Help_text_value(evalf(g).print().c_str());
       return;
#endif
     }
     if (current_upper_window[0]==upper_window_eqw){
        Eqw_eqw->eval_function(at_evalf);
        return;
      }
      string s(input->value());
      if (s.empty() && !history_out.empty() ){
        if ( rpn_mode){
          input->value("evalf");
          input_eval(false);
        }
        else
          input->value(history_out.back().print().c_str());
      }
      input->position(0,input->size());
      input_eval(true);
}

Fl_Button *Select_eval=(Fl_Button *)0;

static void cb_Select_eval(Fl_Button*, void*) {
  if (current_upper_window[0]==upper_window_mtrw){
#ifdef HAVE_LIBFLVW
         int R=spread_ptr->row(),C=spread_ptr->col();
         matrice & m=spread_ptr->m;
         if ( (m[R][C].type==_VECT) && (m[R][C]._VECTptr->size()==3) ){
	   input_value(m[R][C][1].print().c_str());
           return;
         }
#endif //
      }
      if (current_upper_window[0]==upper_window_eqw){
        Eqw_eqw->eval_function(at_eval);
        return;
      }
      string s(input->value());
      if (s.empty() && !history_out.empty() ){
        if (rpn_mode)
          input->value("eval");
        else
          input->value(history_out.back().print().c_str());
      }
      input_eval(false);
}

Fl_Group *Numeric_numbers=(Fl_Group *)0;

Fl_Button *Un=(Fl_Button *)0;

static void cb_Un(Fl_Button*, void*) {
  input_char('1');
}

Fl_Button *Deux=(Fl_Button *)0;

static void cb_Deux(Fl_Button*, void*) {
  input_char('2');
}

Fl_Button *Trois=(Fl_Button *)0;

static void cb_Trois(Fl_Button*, void*) {
  input_char('3');
}

Fl_Button *Quatre=(Fl_Button *)0;

static void cb_Quatre(Fl_Button*, void*) {
  input_char('4');
}

Fl_Button *Cinq=(Fl_Button *)0;

static void cb_Cinq(Fl_Button*, void*) {
  input_char('5');
}

Fl_Button *Six=(Fl_Button *)0;

static void cb_Six(Fl_Button*, void*) {
  input_char('6');
}

Fl_Button *Sept=(Fl_Button *)0;

static void cb_Sept(Fl_Button*, void*) {
  input_char('7');
}

Fl_Button *Huit=(Fl_Button *)0;

static void cb_Huit(Fl_Button*, void*) {
  input_char('8');
}

Fl_Button *Neuf=(Fl_Button *)0;

static void cb_Neuf(Fl_Button*, void*) {
  input_char('9');
}

Fl_Button *Zero=(Fl_Button *)0;

static void cb_Zero(Fl_Button*, void*) {
  input_char('0');
}

Fl_Button *Point=(Fl_Button *)0;

static void cb_Point(Fl_Button*, void*) {
  input_char('.');
}

Fl_Button *EEX=(Fl_Button *)0;

static void cb_EEX(Fl_Button*, void*) {
  input_char('E');
}

Fl_Group *Kbd_control=(Fl_Group *)0;

Fl_Button *Echappement=(Fl_Button *)0;

static void cb_Echappement(Fl_Button*, void*) {
  redraw_mouse_position_only=false;
#ifdef HAVE_LIBFLVW
  if (spread_ptr && spread_ptr->editing){
    spread_ptr->editing=false;
    // cerr << "Mtrw edit end" << endl;
    Fl::focus(spread_ptr);
    return;
  }
#endif
if (run_modif){ modify_history(); return; }
if (!Debug_group->visible() && (signal_plot_parent || waiting_click)){
        input->value("escape");
        input_eval(false);
        return;
      }
      if (Fl::focus()==Picture)
        Fl::focus(input);
      if (Fl::focus()==input){
        input->value(string("").c_str());
      }
      else {
        petit_buffer[0]=0;
        Fl::e_length=0;
        Fl::e_text=petit_buffer;
        Fl::e_keysym=FL_Escape;
        if (dynamic_cast<Eqw *>(Fl::focus()))
          fl_handle();
        };
}

Fl_Button *Show_kbd=(Fl_Button *)0;

static void cb_Show_kbd(Fl_Button*, void*) {
  if (Picture->fullscreen)
    Picture->resize_halfscreen();
  else
    Picture->resize_fullscreen();
}

Fl_Button *ENTER=(Fl_Button *)0;

static void cb_ENTER(Fl_Button*, void*) {
  if (run_plot_setup){
     cb_Plot_setup_OK(0,0);
     return;
    }
    if (run_cas_setup){
     cb_Cas_setup_OK(0,0);
     return;
    }
    if (run_general_setup){
     cb_General_setup_OK(0,0);
     return;
    }
    char vide=0;
    if (!Picture->fullscreen)
      vide=input->value()[0];
    if (rpn_mode && !vide && history_out.size()){
      history_out.push_back(history_out.back());
      history_in.push_back(history_out.back());
      history_redraw(history_pos());
    }
    else {
      if (Fl::focus()==xcas_output)
        Fl::focus(input);
      petit_buffer[0]=0;
      Fl::e_length=0;
      Fl::e_text=petit_buffer;
      Fl::e_keysym=FL_Enter;
      fl_handle();
      };
}

Fl_Group *Plot_setup_w=(Fl_Group *)0;

Fl_Value_Input *Xmin=(Fl_Value_Input *)0;

Fl_Value_Input *Xmax=(Fl_Value_Input *)0;

Fl_Value_Input *Ymin=(Fl_Value_Input *)0;

Fl_Value_Input *Ymax=(Fl_Value_Input *)0;

Fl_Value_Input *Zmin=(Fl_Value_Input *)0;

Fl_Value_Input *Zmax=(Fl_Value_Input *)0;

Fl_Value_Input *Tmin=(Fl_Value_Input *)0;

Fl_Value_Input *Tmax=(Fl_Value_Input *)0;

Fl_Value_Input *Window_xmin=(Fl_Value_Input *)0;

Fl_Value_Input *Window_xmax=(Fl_Value_Input *)0;

Fl_Value_Input *Window_ymin=(Fl_Value_Input *)0;

Fl_Value_Input *Window_ymax=(Fl_Value_Input *)0;

Fl_Value_Input *Rot_x=(Fl_Value_Input *)0;

Fl_Value_Input *Rot_z=(Fl_Value_Input *)0;

Fl_Button *Rot_x_plus=(Fl_Button *)0;

static void cb_Rot_x_plus(Fl_Button*, void*) {
  if (has_gnuplot){
Rot_x->value(Rot_x->value()+5);gnuplot_setview();
};
}

Fl_Button *Rot_x_minus=(Fl_Button *)0;

static void cb_Rot_x_minus(Fl_Button*, void*) {
  if (has_gnuplot){
Rot_x->value(Rot_x->value()-5);
gnuplot_setview();
};
}

Fl_Button *Rot_z_plus=(Fl_Button *)0;

static void cb_Rot_z_plus(Fl_Button*, void*) {
  if (has_gnuplot){
Rot_z->value(Rot_z->value()+5);
gnuplot_setview();
};
}

Fl_Button *Rot_z_minus=(Fl_Button *)0;

static void cb_Rot_z_minus(Fl_Button*, void*) {
  if (has_gnuplot){
Rot_z->value(Rot_z->value()-5);
gnuplot_setview();
};
}

Fl_Value_Input *X_scale=(Fl_Value_Input *)0;

Fl_Value_Input *Z_scale=(Fl_Value_Input *)0;

Fl_Value_Input *Class_min=(Fl_Value_Input *)0;

Fl_Value_Input *Class_size=(Fl_Value_Input *)0;

Fl_Button *Adjust_window=(Fl_Button *)0;

static void cb_Adjust_window(Fl_Button*, void*) {
  Window_xmin->value(Xmin->value());
          Window_xmax->value(Xmax->value());
          Window_ymin->value(Ymin->value());
          Window_ymax->value(Ymax->value());
}

Fl_Check_Button *Axes=(Fl_Check_Button *)0;

static void cb_Axes(Fl_Check_Button*, void*) {
  show_axes=Axes->value();
}

Fl_Check_Button *Autoscale=(Fl_Check_Button *)0;

Fl_Check_Button *Orthonormal=(Fl_Check_Button *)0;

static void cb_Orthonormal(Fl_Check_Button*, void*) {
  win9x=Win9x->value();
}

Fl_Button *Adjust_gnuplot=(Fl_Button *)0;

static void cb_Adjust_gnuplot(Fl_Button*, void*) {
  Xmin->value(Window_xmin->value());
          Xmax->value(Window_xmax->value());
          Ymin->value(Window_ymin->value());
          Ymax->value(Window_ymax->value());
}

Fl_Value_Input *X_tick=(Fl_Value_Input *)0;

static void cb_X_tick(Fl_Value_Input*, void*) {
  if (X_tick->value()>=0)
  x_tick=X_tick->value();
else
  x_tick=1.0;
}

Fl_Value_Input *Y_tick=(Fl_Value_Input *)0;

static void cb_Y_tick(Fl_Value_Input*, void*) {
  if (Y_tick->value()>=0)
  y_tick=Y_tick->value();
else
  y_tick=1.0;
}

Fl_Check_Button *Xcas_turtle=(Fl_Check_Button *)0;

static void cb_Xcas_turtle(Fl_Check_Button*, void*) {
  if (Xcas_turtle->value()) {Geo_buttons->hide(); Geo_buttons_tortue->show(); } else {Geo_buttons->show(); Geo_buttons_tortue->hide(); };
}

Fl_Check_Button *Xcas_hidden_3d=(Fl_Check_Button *)0;

static void cb_Xcas_hidden_3d(Fl_Check_Button*, void*) {
  gnuplot_set_hidden3d(Xcas_hidden_3d->value());
}

Fl_Check_Button *Xcas_pm3d=(Fl_Check_Button *)0;

static void cb_Xcas_pm3d(Fl_Check_Button*, void*) {
  gnuplot_set_pm3d(Xcas_pm3d->value());
}

Fl_Check_Button *Win9x=(Fl_Check_Button *)0;

static void cb_Win9x(Fl_Check_Button*, void*) {
  win9x=!Win9x->value();
}

Fl_Return_Button *Plot_setup_OK=(Fl_Return_Button *)0;

static void cb_Plot_setup_OK(Fl_Return_Button*, void*) {
  // manage_upper_window(upper_window_geo,true);
    manage_upper_window(old_upper_window_state,true);
    run_plot_setup=0;
    Picture->run_plot_view=true;
    redraw_mouse_position_only=false;
    gnuplot_xmin=Xmin->value();
    gnuplot_xmax=Xmax->value();
    gnuplot_ymin=Ymin->value();
    gnuplot_ymax=Ymax->value();
    gnuplot_zmin=Zmin->value();
    gnuplot_zmax=Zmax->value();
    gnuplot_tmin=Tmin->value();
    gnuplot_tmax=Tmax->value();
    Picture->window_xmin=Window_xmin->value();
    Picture->window_xmax=Window_xmax->value();
    Picture->window_ymin=Window_ymin->value();
    Picture->window_ymax=Window_ymax->value();
    double h=Picture->h();
    if (!Picture->fullscreen)
      h=h*1.78;
    recompute_window_xyminmax(h);
    if (!Picture->fullscreen)
      Picture->window_ymin=Picture->window_ymax+(Picture->window_ymin-Picture->window_ymax)/1.78;
    Picture2global_window();
    class_minimum=Class_min->value();
    class_size=Class_size->value();
    string s(input->value());
    input->value(geo_setup_string().c_str());
    input_eval(false);
    input->value(s.c_str());
}

Fl_Button *Plot_setup_cancel=(Fl_Button *)0;

static void cb_Plot_setup_cancel(Fl_Button*, void*) {
  // manage_upper_window(upper_window_geo,true);
    manage_upper_window(old_upper_window_state,true);
    run_plot_setup=0;
    Picture->run_plot_view=true;
    redraw_mouse_position_only=false;
}

Fl_Group *Cas_setup_w=(Fl_Group *)0;

Fl_Menu_Button *Float_style=(Fl_Menu_Button *)0;

static void cb_Float_style_standard(Fl_Menu_*, void*) {
  scientific_format(0,0); Float_style_output->value("standard");
}

static void cb_Float_style_scientific(Fl_Menu_*, void*) {
  scientific_format(1,0); Float_style_output->value("scientific");
}

static void cb_Float_style_engineer(Fl_Menu_*, void*) {
  scientific_format(2,0); Float_style_output->value("engineer");
}

static void cb_Float_style_hexa(Fl_Menu_*, void*) {
  scientific_format(3,0); Float_style_output->value("hexa");
}

Fl_Menu_Item menu_Float_style[] = {
 {gettext("Standard"), 0,  (Fl_Callback*)cb_Float_style_standard, 0, 0, 0, 0, 10, 56},
 {gettext("Scientific"), 0,  (Fl_Callback*)cb_Float_style_scientific, 0, 0, 0, 0, 10, 56},
 {gettext("Engineer"), 0,  (Fl_Callback*)cb_Float_style_engineer, 0, 0, 0, 0, 10, 56},
 {gettext("Engineer"), 0,  (Fl_Callback*)cb_Float_style_hexa, 0, 16, 0, 0, 10, 56},
 {0}
};

Fl_Output *Float_style_output=(Fl_Output *)0;

Fl_Counter *Digits=(Fl_Counter *)0;

static void cb_Digits(Fl_Counter*, void*) {
  decimal_digits=int(Digits->value());
}

Fl_Value_Input *Epsilon=(Fl_Value_Input *)0;

Fl_Check_Button *Approx_mode=(Fl_Check_Button *)0;

static void cb_Approx_mode(Fl_Check_Button*, void*) {
  approx_mode(Approx_mode->value(),0);
}

Fl_Check_Button *Angle_radian=(Fl_Check_Button *)0;

static void cb_Angle_radian(Fl_Check_Button*, void*) {
  angle_radian(Angle_radian->value(),0);
}

Fl_Check_Button *Increasing_power=(Fl_Check_Button *)0;

static void cb_Increasing_power(Fl_Check_Button*, void*) {
  increasing_power(Increasing_power->value(),0);
}

Fl_Menu_Button *Prg_style=(Fl_Menu_Button *)0;

static void cb_CPP(Fl_Menu_*, void*) {
  maple_mode=0; Style->value("Xcas");
}

static void cb_Maple(Fl_Menu_*, void*) {
  maple_mode=1; Style->value("Maple");
}

static void cb_Mupad(Fl_Menu_*, void*) {
  maple_mode=2; Style->value("Mupad");
}

static void cb_TI(Fl_Menu_*, void*) {
  maple_mode=3; Style->value("TI89/92");
}

Fl_Menu_Item menu_Prg_style[] = {
 {gettext("Xcas"), 0,  (Fl_Callback*)cb_CPP, 0, 0, 0, 0, 10, 56},
 {gettext("Maple"), 0,  (Fl_Callback*)cb_Maple, 0, 0, 0, 0, 10, 56},
 {gettext("Mupad"), 0,  (Fl_Callback*)cb_Mupad, 0, 0, 0, 0, 10, 56},
 {gettext("TI89/92"), 0,  (Fl_Callback*)cb_TI, 0, 0, 0, 0, 10, 56},
 {0}
};

Fl_Output *Style=(Fl_Output *)0;

Fl_Check_Button *Complex_mode=(Fl_Check_Button *)0;

static void cb_Complex_mode(Fl_Check_Button*, void*) {
  complex_mode(Complex_mode->value(),0);
}

Fl_Check_Button *Complex_variables=(Fl_Check_Button *)0;

static void cb_Complex_variables(Fl_Check_Button*, void*) {
  complex_variables(Complex_variables->value(),0);
}

Fl_Check_Button *Save_var=(Fl_Check_Button *)0;

static void cb_Save_var(Fl_Check_Button*, void*) {
  variables_are_files(Save_var->value(),0);
}

Fl_Return_Button *Cas_setup_OK=(Fl_Return_Button *)0;

static void cb_Cas_setup_OK(Fl_Return_Button*, void*) {
  if (run_cas_setup==upper_window_hist || run_cas_setup==upper_window_geo)
      manage_upper_window(run_cas_setup,false);
    else
      manage_upper_window(upper_window_hist,false);
    run_cas_setup=0;
    epsilon(fabs(Epsilon->value()),0);
    threads=max(absint(int(Threads->value())),1);
    input->value(cas_setup_string(0).c_str());
    input_eval(false);
}

Fl_Button *Cancel_cas_setup=(Fl_Button *)0;

static void cb_Cancel_cas_setup(Fl_Button*, void*) {
  manage_upper_window(run_cas_setup,false);
  run_cas_setup=0;
}

Fl_Value_Input *Threads=(Fl_Value_Input *)0;

Fl_Check_Button *Xcas_sqrt=(Fl_Check_Button *)0;

static void cb_Xcas_sqrt(Fl_Check_Button*, void*) {
  withsqrt(Xcas_sqrt->value(),0);
}

Fl_Check_Button *Xcas_all_trig_sol=(Fl_Check_Button *)0;

static void cb_Xcas_all_trig_sol(Fl_Check_Button*, void*) {
  all_trig_sol(Xcas_all_trig_sol->value(),0);
}

Fl_Group *General_setup_w=(Fl_Group *)0;

Fl_Group *History_config=(Fl_Group *)0;

Fl_Output *History_font_output=(Fl_Output *)0;

Fl_Menu_Button *History_font=(Fl_Menu_Button *)0;

static void cb_History_20(Fl_Menu_*, void*) {
  xcas_output_fontsize=20;
History_font_output->value("20");
}

static void cb_History_14(Fl_Menu_*, void*) {
  xcas_output_fontsize=14;
History_font_output->value("14");
}

static void cb_History_12(Fl_Menu_*, void*) {
  xcas_output_fontsize=12;
History_font_output->value("12");
}

static void cb_History_10(Fl_Menu_*, void*) {
  xcas_output_fontsize=10;
History_font_output->value("10");
}

static void cb_History_8(Fl_Menu_*, void*) {
  xcas_output_fontsize=8;
History_font_output->value("8");
}

Fl_Menu_Item menu_History_font[] = {
 {gettext("20"), 0,  (Fl_Callback*)cb_History_20, 0, 0, 0, 0, 10, 56},
 {gettext("14"), 0,  (Fl_Callback*)cb_History_14, 0, 0, 0, 0, 10, 56},
 {gettext("12"), 0,  (Fl_Callback*)cb_History_12, 0, 0, 0, 0, 10, 56},
 {gettext("10"), 0,  (Fl_Callback*)cb_History_10, 0, 0, 0, 0, 10, 56},
 {gettext("8"), 0,  (Fl_Callback*)cb_History_8, 0, 0, 0, 0, 10, 56},
 {0}
};

Fl_Check_Button *Center_history=(Fl_Check_Button *)0;

static void cb_Center_history(Fl_Check_Button*, void*) {
  center_history=Center_history->value();
}

Fl_Check_Button *Pretty_input=(Fl_Check_Button *)0;

static void cb_Pretty_input(Fl_Check_Button*, void*) {
  pretty_input=Pretty_input->value();
}

Fl_Check_Button *Pretty_print=(Fl_Check_Button *)0;

Fl_Check_Button *Recompute_history=(Fl_Check_Button *)0;

static void cb_Recompute_history(Fl_Check_Button*, void*) {
  Recompute_history->value();
}

Fl_Check_Button *RPN=(Fl_Check_Button *)0;

Fl_Check_Button *Eqw_history_freezed=(Fl_Check_Button *)0;

static void cb_Eqw_history_freezed(Fl_Check_Button*, void*) {
  Eqw_history->modifiable = !Eqw_history_freezed->value();
}

Fl_Menu_Button *Widget_font=(Fl_Menu_Button *)0;

static void cb_Widget_20(Fl_Menu_*, void*) {
  Help_text_fontsize=14;
change_button_fontsize(20);
Widget_font_output->value("20");
}

static void cb_Widget_14(Fl_Menu_*, void*) {
  Help_text_fontsize=10;
change_button_fontsize(14);
Widget_font_output->value("14");
}

static void cb_Widget_12(Fl_Menu_*, void*) {
  Help_text_fontsize=10;
change_button_fontsize(12);
Widget_font_output->value("12");
}

static void cb_Widget_10(Fl_Menu_*, void*) {
  Help_text_fontsize=8;
change_button_fontsize(10);
Widget_font_output->value("10");
}

static void cb_Widget_8(Fl_Menu_*, void*) {
  Help_text_fontsize=8;
Help_font_output->value("8");
change_button_fontsize(8);
Widget_font_output->value("8");
}

Fl_Menu_Item menu_Widget_font[] = {
 {gettext("20"), 0,  (Fl_Callback*)cb_Widget_20, 0, 0, 0, 0, 10, 56},
 {gettext("14"), 0,  (Fl_Callback*)cb_Widget_14, 0, 0, 0, 0, 10, 56},
 {gettext("12"), 0,  (Fl_Callback*)cb_Widget_12, 0, 0, 0, 0, 10, 56},
 {gettext("10"), 0,  (Fl_Callback*)cb_Widget_10, 0, 0, 0, 0, 10, 56},
 {gettext("8"), 0,  (Fl_Callback*)cb_Widget_8, 0, 0, 0, 0, 10, 56},
 {0}
};

Fl_Output *Widget_font_output=(Fl_Output *)0;

Fl_Group *Matrix_config=(Fl_Group *)0;

Fl_Menu_Button *Select_matrix_type=(Fl_Menu_Button *)0;

static void cb_Normal_matrix(Fl_Menu_*, void*) {
  matrix_symmetry=0;
Select_matrix_type_output->value("Normal");
}

static void cb_Symmetric_matrix(Fl_Menu_*, void*) {
  matrix_symmetry=2;
Select_matrix_type_output->value("Symmetric");
}

static void cb_Antisymmetric_matrix(Fl_Menu_*, void*) {
  matrix_symmetry=1;
Select_matrix_type_output->value("Antisymmetric");
}

static void cb_Hermitian_matrix(Fl_Menu_*, void*) {
  matrix_symmetry=4;
Select_matrix_type_output->value("Hermitian");
}

static void cb_Antihermitian_matrix(Fl_Menu_*, void*) {
  matrix_symmetry=3;
Select_matrix_type_output->value("Antihermitian");
}

Fl_Menu_Item menu_Select_matrix_type[] = {
 {gettext("Normal"), 0,  (Fl_Callback*)cb_Normal_matrix, 0, 0, 0, 0, 10, 56},
 {gettext("Symmetric"), 0,  (Fl_Callback*)cb_Symmetric_matrix, 0, 0, 0, 0, 10, 56},
 {gettext("Antisymmetric"), 0,  (Fl_Callback*)cb_Antisymmetric_matrix, 0, 0, 0, 0, 10, 56},
 {gettext("Hermitian"), 0,  (Fl_Callback*)cb_Hermitian_matrix, 0, 0, 0, 0, 10, 56},
 {gettext("Antihermitian"), 0,  (Fl_Callback*)cb_Antihermitian_matrix, 0, 0, 0, 0, 10, 56},
 {0}
};

Fl_Output *Select_matrix_type_output=(Fl_Output *)0;

Fl_Input *Spread_rows=(Fl_Input *)0;

Fl_Input *Spread_cols=(Fl_Input *)0;

Fl_Check_Button *Spreadsheet_editor=(Fl_Check_Button *)0;

Fl_Check_Button *Matrix_fill_cells=(Fl_Check_Button *)0;

Fl_Check_Button *Spreadsheet_recompute=(Fl_Check_Button *)0;

Fl_Group *Help_config=(Fl_Group *)0;

Fl_Menu_Button *Help_font=(Fl_Menu_Button *)0;

static void cb_Help_20(Fl_Menu_*, void*) {
  Help_text_fontsize=20;
Help_font_output->value("20");
}

static void cb_Help_14(Fl_Menu_*, void*) {
  Help_text_fontsize=14;
Help_font_output->value("14");
}

static void cb_Help_12(Fl_Menu_*, void*) {
  Help_text_fontsize=12;
Help_font_output->value("12");
}

static void cb_Help_10(Fl_Menu_*, void*) {
  Help_text_fontsize=10;
Help_font_output->value("10");
}

static void cb_Help_8(Fl_Menu_*, void*) {
  Help_text_fontsize=8;
Help_font_output->value("8");
}

Fl_Menu_Item menu_Help_font[] = {
 {gettext("20"), 0,  (Fl_Callback*)cb_Help_20, 0, 0, 0, 0, 10, 56},
 {gettext("14"), 0,  (Fl_Callback*)cb_Help_14, 0, 0, 0, 0, 10, 56},
 {gettext("12"), 0,  (Fl_Callback*)cb_Help_12, 0, 0, 0, 0, 10, 56},
 {gettext("10"), 0,  (Fl_Callback*)cb_Help_10, 0, 0, 0, 0, 10, 56},
 {gettext("8"), 0,  (Fl_Callback*)cb_Help_8, 0, 0, 0, 0, 10, 56},
 {0}
};

Fl_Output *Help_font_output=(Fl_Output *)0;

Fl_Check_Button *Chooser_Check_Button=(Fl_Check_Button *)0;

Fl_Input *Help_font_browser=(Fl_Input *)0;

static void cb_Help_font_browser(Fl_Input*, void*) {
  setenv("BROWSER",Help_font_browser->value(),1);
}

Fl_Group *Print_config=(Fl_Group *)0;

Fl_Menu_Button *Page_format=(Fl_Menu_Button *)0;

static void cb_Page_A4(Fl_Menu_*, void*) {
  #ifdef FL_DEVICE
printer_format=Fl_Printer::A4;
#endif
Page_format_output->value("A4");
}

static void cb_Page_A5(Fl_Menu_*, void*) {
  #ifdef FL_DEVICE
printer_format=Fl_Printer::A5;
#endif
Page_format_output->value("A5");
}

static void cb_Page_A3(Fl_Menu_*, void*) {
  #ifdef FL_DEVICE
printer_format=Fl_Printer::A5;
#endif
Page_format_output->value("A3");
}

static void cb_Page_LETTER(Fl_Menu_*, void*) {
  #ifdef FL_DEVICE
printer_format=Fl_Printer::LETTER;
#endif
Page_format_output->value("LETTER");
}

static void cb_Page_ENVELOPE(Fl_Menu_*, void*) {
  #ifdef FL_DEVICE
printer_format=Fl_Printer::ENVELOPE;
#endif
Page_format_output->value("8");
}

Fl_Menu_Item menu_Page_format[] = {
 {gettext("A4"), 0,  (Fl_Callback*)cb_Page_A4, 0, 0, 0, 0, 10, 56},
 {gettext("A5"), 0,  (Fl_Callback*)cb_Page_A5, 0, 0, 0, 0, 10, 56},
 {gettext("A3"), 0,  (Fl_Callback*)cb_Page_A3, 0, 0, 0, 0, 10, 56},
 {gettext("LETTER"), 0,  (Fl_Callback*)cb_Page_LETTER, 0, 0, 0, 0, 10, 56},
 {gettext("ENVELOPE"), 0,  (Fl_Callback*)cb_Page_ENVELOPE, 0, 0, 0, 0, 10, 56},
 {0}
};

Fl_Output *Page_format_output=(Fl_Output *)0;

Fl_Check_Button *Printer_landscape=(Fl_Check_Button *)0;

static void cb_Printer_landscape(Fl_Check_Button*, void*) {
  printer_landscape=Printer_landscape->value();
}

Fl_Input *Xcas_ps_preview=(Fl_Input *)0;

static void cb_Xcas_ps_preview(Fl_Input*, void*) {
  setenv("GIAC_PREVIEW",Xcas_ps_preview->value(),1);
}

Fl_Check_Button *Bandeau=(Fl_Check_Button *)0;

static void cb_Bandeau(Fl_Check_Button*, void*) {
  if (Bandeau->value()){
  bandeau->show();
  bandeau2->hide();
}
else {
  bandeau->hide();
  bandeau2->show();
};
}

Fl_Check_Button *hide_help=(Fl_Check_Button *)0;

Fl_Counter *Split_windows=(Fl_Counter *)0;

Fl_Check_Button *Horizontal_split=(Fl_Check_Button *)0;

static void cb_Horizontal_split(Fl_Check_Button*, void*) {
  horizontal_split=Horizontal_split->value();
}

Fl_Return_Button *General_setup_OK=(Fl_Return_Button *)0;

static void cb_General_setup_OK(Fl_Return_Button*, void*) {
  int n=int(Split_windows->value());
  xcas_windows(n);
  help_chooser=Chooser_Check_Button->value();
  if (Pretty_print->value()){
    Eqw_History_group->show();
    Text_History_group->hide();
    history_redraw(history_out.size());
  }
  else {
    Eqw_History_group->hide();
    Text_History_group->show();
    history_redraw(history_out.size());
  }
  if (hide_help->value())
    Picture->resize_fullscreen();
  else
    Picture->resize_halfscreen();
  manage_upper_window(run_general_setup,false);
  run_general_setup=0;
  rpn_mode=RPN->value();
  if (rpn_mode){
   if (input->mark()-input->position()==string(input->value()).size())
      input->value("");
   show_rpn_menu(0);
   Sto->label("STO");
   Sto->redraw();
   RPN_programme->label("");
   RPN_programme->redraw();
   Semi_button->label("RCL");
   Semi_button->redraw();
   UNDO->label("Undo");
   UNDO->redraw();
  }
  else {
   rpn_mode=false;
   Sto->label(":=");
   Sto->redraw();
   RPN_programme->label("()");
   RPN_programme->redraw();
   Semi_button->label(";");
   Semi_button->redraw();
   UNDO->label("modif");
   UNDO->redraw();
  }
  xcas_output->textsize(xcas_output_fontsize);
  Eqw_history->attr.fontsize=xcas_output_fontsize;
  Eqw_history->set_data(Eqw_history->get_data());
  Eqw_history->redraw();
  Help_text->textsize(Help_text_fontsize);
  help_examples->textsize(Help_text_fontsize);
  help_related->textsize(Help_text_fontsize);
  //Help_Chooser_Index->textsize(Help_text_fontsize);
  history_redraw(history_out.size());
  if (current_upper_window[0]==upper_window_hist)
    focus_output();
#ifdef HAVE_LIBFLVW
    gen g;
    try { g=gen(string(Spread_rows->value()));
    // cerr << g << endl;
    if ( g.type==_INT_ && (g.val>0) ){
      if (g.val!=spread_ptr->rows() )
        spread_ptr->resizesheet(g.val,spread_ptr->cols());
    }
    else
      cerr << g << " invalid length" << endl;
    }
    catch (std::runtime_error & e){
      cerr << e.what() << endl;
    }
    try { g=gen(string(Spread_cols->value()));
    // cerr << g << endl;
    if ( g.type==_INT_ && (g.val>0) ){
      if (g.val!=spread_ptr->cols() )
        spread_ptr->resizesheet(spread_ptr->rows(),g.val);
    }
    else
      cerr << g << " invalid length" << endl;
    }
    catch (std::runtime_error & e){
      cerr << e.what() << endl;
    }
  spread_ptr->is_spreadsheet=Spreadsheet_editor->value();
#endif //
}

Fl_Button *Cancel_general_setup=(Fl_Button *)0;

static void cb_Cancel_general_setup(Fl_Button*, void*) {
  Split_windows->value(current_upper_window.size());
  manage_upper_window(run_general_setup,false);
  run_general_setup=0;
}

Fl_Menu_Button *Xcas_user_level_choice=(Fl_Menu_Button *)0;

static void cb_Xcas_level_universite(Fl_Menu_*, void*) {
  set_xcas_user_level(0);
Xcas_level_output->value("Universite");
}

static void cb_Xcas_level_terminale(Fl_Menu_*, void*) {
  set_xcas_user_level(1);
Xcas_level_output->value("Terminale");
}

static void cb_Xcas_level_premiere(Fl_Menu_*, void*) {
  set_xcas_user_level(2);
Xcas_level_output->value("Premiere");
}

static void cb_Xcas_level_seconde(Fl_Menu_*, void*) {
  set_xcas_user_level(3);
Xcas_level_output->value("Seconde");
}

static void cb_Xcas_level_tortue(Fl_Menu_*, void*) {
  set_xcas_user_level(8);
Xcas_level_output->value("Tortue");
}

Fl_Menu_Item menu_Xcas_user_level_choice[] = {
 {gettext("Universite"), 0,  (Fl_Callback*)cb_Xcas_level_universite, 0, 0, 0, 0, 10, 56},
 {gettext("Terminale"), 0,  (Fl_Callback*)cb_Xcas_level_terminale, 0, 0, 0, 0, 10, 56},
 {gettext("Premiere"), 0,  (Fl_Callback*)cb_Xcas_level_premiere, 0, 0, 0, 0, 10, 56},
 {gettext("Seconde"), 0,  (Fl_Callback*)cb_Xcas_level_seconde, 0, 0, 0, 0, 10, 56},
 {gettext("Tortue"), 0,  (Fl_Callback*)cb_Xcas_level_tortue, 0, 0, 0, 0, 10, 56},
 {0}
};

Fl_Output *Xcas_level_output=(Fl_Output *)0;

int xcas_exec(int argc,char ** argv) {
  Fl_Double_Window* w;
  Xcas_program_map["session.cxx"]=editor_string();
  xcasroot=xcasroot_dir(argv[0]);
  cerr << "// Found xcas directory " << xcasroot << endl;
  // fl calls
  Fl::set_fonts(0);
  Fl::add_idle(redraw_callback,0);
  int r;
  run_gnuplot(r);
  // on-line help
string helper("aide_cas");
aide_v=readhelp(helper.c_str(),helpitems,false);
if (!helpitems){
  if (getenv("XCAS_HELP"))
    helper=getenv("XCAS_HELP");
  else
    helper=giac_aide_dir()+"aide_cas";
  aide_v=readhelp(helper.c_str(),helpitems);
}
if (!helpitems)
  cerr << "// Unable to open help file aide_cas" << endl;
else
  cerr << "// Using help file " << helper << endl;
  { Fl_Double_Window* o = Xcas = new Fl_Double_Window(425, 390, gettext("xcas"));
    w = o;
    { Fl_Menu_Bar* o = xcas = new Fl_Menu_Bar(0, 0, 490, 20, gettext("xcas"));
      o->labelsize(10);
      o->textsize(10);
      o->callback((Fl_Callback*)cb_xcas);
      o->menu(menu_xcas);
    }
    { Fl_Group* o = Eqw_group = new Fl_Group(0, 20, 425, 160);
      o->hide();
      { Fl_Group* o = Eqw_eqw_group = new Fl_Group(0, 20, 425, 140);
        { giac::Eqw* o = Eqw_eqw = new giac::Eqw(0, 20, 405, 125);
          o->box(FL_FLAT_BOX);
          o->color(FL_BACKGROUND_COLOR);
          o->selection_color(FL_BACKGROUND_COLOR);
          o->labeltype(FL_NORMAL_LABEL);
          o->labelfont(0);
          o->labelsize(14);
          o->labelcolor(FL_BLACK);
          o->align(FL_ALIGN_CENTER);
          o->when(FL_WHEN_RELEASE);
          Fl_Group::current()->resizable(o);
        }
        o->end();
        Fl_Group::current()->resizable(o);
      }
      { Fl_Group* o = Eqw_buttons = new Fl_Group(0, 160, 425, 20);
        { Fl_Button* o = Eqw_save = new Fl_Button(0, 160, 40, 20, gettext("save"));
          o->labelsize(12);
          o->callback((Fl_Callback*)cb_Eqw_save);
        }
        { Fl_Button* o = Eqw_ok = new Fl_Button(40, 160, 40, 20, gettext("->cmd"));
          o->tooltip(gettext("Copy to commandline"));
          o->labelsize(12);
          o->callback((Fl_Callback*)cb_Eqw_ok);
        }
        { Fl_Button* o = Eqw_left = new Fl_Button(80, 160, 35, 20, gettext("@-1<-"));
          o->tooltip(gettext("Exchange selection to the left"));
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Eqw_left);
        }
        { Fl_Button* o = Eqw_right = new Fl_Button(115, 160, 35, 20, gettext("@-1->"));
          o->tooltip(gettext("Exchange selection to the right"));
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Eqw_right);
        }
        { Fl_Button* o = Eqw_copy = new Fl_Button(180, 160, 55, 20, gettext("copy"));
          o->tooltip(gettext("Copy selection to clipboard"));
          o->labelsize(12);
          o->callback((Fl_Callback*)cb_Eqw_copy);
        }
        { Fl_Button* o = Eqw_undo = new Fl_Button(255, 160, 55, 20, gettext("undo"));
          o->tooltip(gettext("Undo one operation"));
          o->labelsize(12);
          o->callback((Fl_Callback*)cb_Eqw_undo);
        }
        { Fl_Button* o = Eqw_exec = new Fl_Button(340, 160, 85, 20, gettext("exec"));
          o->tooltip(gettext("Copy selection to commandline and execute"));
          o->labelsize(12);
          o->callback((Fl_Callback*)cb_Eqw_exec);
        }
        { Fl_Button* o = Eqw_down = new Fl_Button(185, 170, 35, 10, gettext("@-12"));
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Eqw_down);
          o->hide();
        }
        o->end();
      }
      o->end();
    }
    { Fl_Group* o = Help_Chooser = new Fl_Group(0, 20, 425, 160);
      o->hide();
      { Fl_Group* o = Help_Chooser_Input_Arrays = new Fl_Group(0, 20, 425, 85);
        { Fl_Input* o = Help_Chooser_Input_Array0 = new Fl_Input(105, 20, 225, 20);
          o->labelsize(10);
          o->textsize(10);
          o->callback((Fl_Callback*)cb_Help_Chooser_Input_Array0);
          o->hide();
        }
        { Fl_Input* o = Help_Chooser_Input_Array1 = new Fl_Input(105, 40, 225, 20);
          o->labelsize(10);
          o->textsize(10);
          o->callback((Fl_Callback*)cb_Help_Chooser_Input_Array1);
          o->hide();
        }
        { Fl_Input* o = Help_Chooser_Input_Array2 = new Fl_Input(50, 60, 115, 20);
          o->labelsize(10);
          o->textsize(10);
          o->callback((Fl_Callback*)cb_Help_Chooser_Input_Array2);
          o->hide();
        }
        { Fl_Input* o = Help_Chooser_Input_Array3 = new Fl_Input(215, 60, 115, 20);
          o->labelsize(10);
          o->textsize(10);
          o->callback((Fl_Callback*)cb_Help_Chooser_Input_Array3);
          o->hide();
        }
        { Fl_Input* o = Help_Chooser_Input_Array4 = new Fl_Input(50, 80, 115, 25);
          o->labelsize(10);
          o->textsize(10);
          o->callback((Fl_Callback*)cb_Help_Chooser_Input_Array4);
          o->hide();
        }
        { Fl_Input* o = Help_Chooser_Input_Array5 = new Fl_Input(215, 80, 115, 25);
          o->labelsize(10);
          o->textsize(10);
          o->callback((Fl_Callback*)cb_Help_Chooser_Input_Array5);
          o->hide();
        }
        { Fl_Button* o = Help_Chooser_OK_with_function = new Fl_Button(340, 20, 85, 20);
          o->tooltip(gettext("Copy function and arguments to commandline"));
          o->labelsize(12);
          o->callback((Fl_Callback*)cb_Help_Chooser_OK_with_function);
        }
        { Fl_Return_Button* o = Help_Chooser_OK = new Fl_Return_Button(340, 40, 40, 20, gettext("OK"));
          o->tooltip(gettext("Copy arguments to commandline"));
          o->labelsize(12);
          o->callback((Fl_Callback*)cb_Help_Chooser_OK);
        }
        { Fl_Input* o = Help_input = new Fl_Input(340, 80, 85, 25, gettext("?"));
          o->tooltip(gettext("Search a keyword in help"));
          o->labelsize(10);
          o->labelcolor(FL_DARK_RED);
          o->textsize(10);
          o->textcolor(72);
          o->callback((Fl_Callback*)cb_Help_input);
          o->when(FL_WHEN_ENTER_KEY_ALWAYS);
        }
        { Fl_Button* o = HTML_Help = new Fl_Button(340, 60, 85, 20, gettext("HTML"));
          o->tooltip(gettext("Show current help in your HTML browser"));
          o->color((Fl_Color)3);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_HTML_Help);
        }
        { Fl_Button* o = Help_Chooser_Cancel = new Fl_Button(380, 40, 45, 20, gettext("Cancel"));
          o->labelsize(12);
          o->callback((Fl_Callback*)cb_Help_Chooser_Cancel);
        }
        o->end();
      }
      { Fl_Group* o = Help_index_group = new Fl_Group(0, 105, 425, 75);
        { Fl_Browser* o = Help_Chooser_Index = new Fl_Browser(0, 105, 140, 75);
          o->type(2);
          o->labeltype(FL_NO_LABEL);
          o->labelsize(10);
          o->textsize(10);
          o->textcolor(72);
          o->callback((Fl_Callback*)cb_Help_Chooser_Index);
        }
        o->end();
        Fl_Group::current()->resizable(o);
      }
      o->end();
    }
    { Fl_Group* o = Geo_group = new Fl_Group(0, 20, 425, 160);
      o->hide();
      { Fl_Group* o = Geo_picture = new Fl_Group(0, 20, 420, 140);
        { giac::Image* o = Picture = new giac::Image(0, 20, 420, 140, gettext("\"PICT\""));
          o->box(FL_FLAT_BOX);
          o->color(FL_BACKGROUND_COLOR);
          o->selection_color(FL_BACKGROUND_COLOR);
          o->labeltype(FL_NORMAL_LABEL);
          o->labelfont(0);
          o->labelsize(14);
          o->labelcolor(FL_BLACK);
          o->align(FL_ALIGN_CENTER);
          o->when(FL_WHEN_RELEASE);
          Fl_Group::current()->resizable(o);
        }
        o->end();
        Fl_Group::current()->resizable(o);
      }
      { Fl_Group* o = Geo_buttons = new Fl_Group(0, 160, 425, 20);
        { Fl_Button* o = Geo_save = new Fl_Button(0, 160, 50, 20, gettext("->hist"));
          o->tooltip(gettext("Include geometry screen in history for printing"));
          o->color((Fl_Color)29);
          o->selection_color((Fl_Color)20);
          o->labelsize(12);
          o->labelcolor(FL_FOREGROUND_COLOR);
          o->callback((Fl_Callback*)cb_Geo_save);
        }
        { Fl_Button* o = Geo_zoomin = new Fl_Button(50, 160, 40, 20, gettext("+zoom"));
          o->tooltip(gettext("Zoom in"));
          o->color((Fl_Color)29);
          o->selection_color((Fl_Color)20);
          o->labelsize(12);
          o->labelcolor(FL_FOREGROUND_COLOR);
          o->callback((Fl_Callback*)cb_Geo_zoomin);
        }
        { Fl_Button* o = Geo_zoomout = new Fl_Button(90, 160, 40, 20, gettext("-zoom"));
          o->tooltip(gettext("Zoom out"));
          o->color((Fl_Color)29);
          o->selection_color((Fl_Color)20);
          o->labelsize(12);
          o->labelcolor(FL_FOREGROUND_COLOR);
          o->callback((Fl_Callback*)cb_Geo_zoomout);
        }
        { Fl_Button* o = Geo_go_left = new Fl_Button(160, 160, 30, 20, gettext("@-1->"));
          o->shortcut(0x4ff51);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Geo_go_left);
        }
        { Fl_Button* o = Geo_go_right = new Fl_Button(130, 160, 30, 20, gettext("@-1<-"));
          o->shortcut(0x4ff53);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Geo_go_right);
        }
        { Fl_Button* o = Geo_go_up = new Fl_Button(190, 160, 30, 20, gettext("@-12"));
          o->shortcut(0x4ff52);
          o->labelsize(10);
          o->labelcolor(FL_INACTIVE_COLOR);
          o->callback((Fl_Callback*)cb_Geo_go_up);
        }
        { Fl_Button* o = Geo_go_down = new Fl_Button(220, 160, 30, 20, gettext("@-18"));
          o->shortcut(0x4ff54);
          o->labelcolor(FL_INACTIVE_COLOR);
          o->callback((Fl_Callback*)cb_Geo_go_down);
        }
        { Fl_Button* o = Geo_erase_button = new Fl_Button(250, 160, 60, 20, gettext("erase"));
          o->tooltip(gettext("Erase geometry screen (confirm with enter)"));
          o->shortcut(0xffc2);
          o->color((Fl_Color)29);
          o->selection_color((Fl_Color)20);
          o->labelsize(12);
          o->labelcolor(FL_FOREGROUND_COLOR);
          o->callback((Fl_Callback*)cb_Geo_erase_button);
        }
        { Fl_Button* o = Geo_axes = new Fl_Button(310, 160, 55, 20, gettext("axes"));
          o->tooltip(gettext("Switch axes on or off"));
          o->shortcut(0xffc2);
          o->color((Fl_Color)29);
          o->selection_color((Fl_Color)20);
          o->labelsize(12);
          o->labelcolor(FL_FOREGROUND_COLOR);
          o->callback((Fl_Callback*)cb_Geo_axes);
        }
        { Fl_Button* o = Geo_show_io = new Fl_Button(365, 160, 60, 20, gettext("ia"));
          o->tooltip(gettext("Switch from interactive screen to io screen"));
          o->shortcut(0xffc2);
          o->color((Fl_Color)6);
          o->selection_color((Fl_Color)20);
          o->labelsize(12);
          o->labelcolor((Fl_Color)4);
          o->callback((Fl_Callback*)cb_Geo_show_io);
        }
        o->end();
      }
      { Fl_Group* o = Geo_buttons_tortue = new Fl_Group(0, 160, 425, 20);
        o->hide();
        { Fl_Button* o = Xcas_tortue_button_av = new Fl_Button(0, 160, 35, 20, gettext("av"));
          o->tooltip(gettext("La tortue avance de n pas"));
          o->color((Fl_Color)29);
          o->selection_color((Fl_Color)20);
          o->labelsize(12);
          o->labelcolor(FL_FOREGROUND_COLOR);
          o->callback((Fl_Callback*)cb_Xcas_tortue_button_av);
        }
        { Fl_Button* o = Xcas_tortue_button_re = new Fl_Button(35, 160, 35, 20, gettext("re"));
          o->tooltip(gettext("La tortue recule de n pas"));
          o->color((Fl_Color)29);
          o->selection_color((Fl_Color)20);
          o->labelsize(12);
          o->labelcolor(FL_FOREGROUND_COLOR);
          o->callback((Fl_Callback*)cb_Xcas_tortue_button_re);
        }
        { Fl_Button* o = Xcas_tortue_button_td = new Fl_Button(70, 160, 35, 20, gettext("td"));
          o->tooltip(gettext("La tortue tourne a droite de n degres"));
          o->color((Fl_Color)29);
          o->selection_color((Fl_Color)20);
          o->labelsize(12);
          o->labelcolor(FL_FOREGROUND_COLOR);
          o->callback((Fl_Callback*)cb_Xcas_tortue_button_td);
        }
        { Fl_Button* o = Xcas_tortue_button_tg = new Fl_Button(105, 160, 35, 20, gettext("tg"));
          o->tooltip(gettext("La tortue tourne a gauche de n degres"));
          o->color((Fl_Color)29);
          o->selection_color((Fl_Color)20);
          o->labelsize(12);
          o->labelcolor(FL_FOREGROUND_COLOR);
          o->callback((Fl_Callback*)cb_Xcas_tortue_button_tg);
        }
        { Fl_Button* o = Xcas_tortue_button_pc = new Fl_Button(140, 160, 35, 20, gettext("pc"));
          o->tooltip(gettext("Pas de cote a droite de n pas"));
          o->color((Fl_Color)29);
          o->selection_color((Fl_Color)20);
          o->labelsize(12);
          o->labelcolor(FL_FOREGROUND_COLOR);
          o->callback((Fl_Callback*)cb_Xcas_tortue_button_pc);
        }
        { Fl_Button* o = Xcas_tortue_button_sa = new Fl_Button(175, 160, 35, 20, gettext("sa"));
          o->tooltip(gettext("Saute de n pas"));
          o->color((Fl_Color)29);
          o->selection_color((Fl_Color)20);
          o->labelsize(12);
          o->labelcolor(FL_FOREGROUND_COLOR);
          o->callback((Fl_Callback*)cb_Xcas_tortue_button_sa);
        }
        { Fl_Button* o = Xcas_tortue_button_cr = new Fl_Button(210, 160, 35, 20, gettext("cr"));
          o->tooltip(gettext("Change la couleur du crayon"));
          o->color((Fl_Color)29);
          o->selection_color((Fl_Color)20);
          o->labelsize(12);
          o->labelcolor(FL_FOREGROUND_COLOR);
          o->callback((Fl_Callback*)cb_Xcas_tortue_button_cr);
        }
        { Fl_Button* o = Xcas_tortue_button_ro = new Fl_Button(245, 160, 35, 20, gettext("ro"));
          o->tooltip(gettext("Arc de cercle"));
          o->color((Fl_Color)29);
          o->selection_color((Fl_Color)20);
          o->labelsize(12);
          o->labelcolor(FL_FOREGROUND_COLOR);
          o->callback((Fl_Callback*)cb_Xcas_tortue_button_ro);
        }
        { Fl_Button* o = Xcas_tortue_button_di = new Fl_Button(280, 160, 35, 20, gettext("di"));
          o->tooltip(gettext("Arc de cercle rempli"));
          o->color((Fl_Color)29);
          o->selection_color((Fl_Color)20);
          o->labelsize(12);
          o->labelcolor(FL_FOREGROUND_COLOR);
          o->callback((Fl_Callback*)cb_Xcas_tortue_button_di);
        }
        { Fl_Button* o = Xcas_tortue_button_rp = new Fl_Button(315, 160, 35, 20, gettext("rp"));
          o->tooltip(gettext("Rectangle plein"));
          o->color((Fl_Color)29);
          o->selection_color((Fl_Color)20);
          o->labelsize(12);
          o->labelcolor(FL_FOREGROUND_COLOR);
          o->callback((Fl_Callback*)cb_Xcas_tortue_button_rp);
        }
        { Fl_Button* o = Xcas_tortue_button_tp = new Fl_Button(350, 160, 35, 20, gettext("tp"));
          o->tooltip(gettext("Triangle plein"));
          o->color((Fl_Color)29);
          o->selection_color((Fl_Color)20);
          o->labelsize(12);
          o->labelcolor(FL_FOREGROUND_COLOR);
          o->callback((Fl_Callback*)cb_Xcas_tortue_button_tp);
        }
        { Fl_Button* o = Xcas_tortue_button_ef = new Fl_Button(385, 160, 40, 20, gettext("ef"));
          o->tooltip(gettext("Efface tout"));
          o->color((Fl_Color)29);
          o->selection_color((Fl_Color)20);
          o->labelsize(12);
          o->labelcolor(FL_FOREGROUND_COLOR);
          o->callback((Fl_Callback*)cb_Xcas_tortue_button_ef);
        }
        o->end();
      }
      o->end();
    }
    { Fl_Text_Display* o = Bighelp = new Fl_Text_Display(0, 20, 425, 160);
      o->textcolor(73);
      o->hide();
      Fl_Text_Buffer * b=new Fl_Text_Buffer;
      Bighelp->buffer(b);
    }
    { Fl_Group* o = Debug_group = new Fl_Group(0, 20, 430, 160);
      o->hide();
      { Fl_Browser* o = Source_browser = new Fl_Browser(0, 20, 425, 75);
        o->tooltip(gettext("Show the source of the program"));
        o->type(2);
        o->labelsize(12);
        o->textsize(12);
        o->callback((Fl_Callback*)cb_Source_browser);
      }
      { Fl_Output* o = Debug_messages = new Fl_Output(0, 95, 195, 65);
        o->tooltip(gettext("Show last line execution status"));
        o->type(12);
        o->labeltype(FL_NO_LABEL);
        o->labelsize(12);
        o->textsize(12);
      }
      { Fl_Browser* o = Variable_browser = new Fl_Browser(195, 95, 230, 65);
        o->tooltip(gettext("Show watch variables"));
        o->type(2);
        o->labelsize(12);
        o->textsize(12);
        o->callback((Fl_Callback*)cb_Variable_browser);
      }
      { Fl_Group* o = Debug_buttons = new Fl_Group(0, 160, 425, 20);
        { Fl_Button* o = watch_button = new Fl_Button(0, 160, 40, 20, gettext("watch"));
          o->tooltip(gettext("Add a variable name to the watch"));
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_watch_button);
        }
        { Fl_Button* o = sst_button = new Fl_Button(55, 160, 40, 20, gettext("sst"));
          o->tooltip(gettext("Execute current line, skip function"));
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_sst_button);
        }
        { Fl_Button* o = sst_in_button = new Fl_Button(95, 160, 40, 20, gettext("in"));
          o->tooltip(gettext("Execute current line, step in function"));
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_sst_in_button);
        }
        { Fl_Button* o = cont_button = new Fl_Button(220, 160, 45, 20, gettext("cont"));
          o->tooltip(gettext("Continue execution until next breakpoint"));
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_cont_button);
        }
        { Fl_Button* o = break_button = new Fl_Button(170, 160, 40, 20, gettext("break"));
          o->tooltip(gettext("Add a breakpoint"));
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_break_button);
        }
        { Fl_Button* o = kill_button = new Fl_Button(275, 160, 50, 20, gettext("kill"));
          o->tooltip(gettext("Kill current program"));
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_kill_button);
        }
        o->end();
      }
      o->end();
    }
    { Fl_Group* o = Historique = new Fl_Group(0, 20, 425, 160);
      { Fl_Group* o = History_button = new Fl_Group(0, 160, 425, 20);
        { Fl_Button* o = Hist_save_button = new Fl_Button(0, 160, 40, 20, gettext("save"));
          o->labelsize(12);
          o->labelcolor(FL_FOREGROUND_COLOR);
          o->callback((Fl_Callback*)cb_Hist_save_button);
        }
        { Fl_Button* o = Hist2eqw_button = new Fl_Button(40, 160, 50, 20, gettext("->eqw"));
          o->tooltip(gettext("Copy selection to equationwriter"));
          o->labelsize(12);
          o->labelcolor(FL_FOREGROUND_COLOR);
          o->callback((Fl_Callback*)cb_Hist2eqw_button);
        }
        { Fl_Button* o = Ans_In = new Fl_Button(90, 160, 30, 20, gettext("@-18"));
          o->tooltip(gettext("Select one level up in history"));
          o->shortcut(0x4ff52);
          o->labelsize(12);
          o->labelcolor(FL_FOREGROUND_COLOR);
          o->callback((Fl_Callback*)cb_Ans_In);
        }
        { Fl_Button* o = Ans_Down = new Fl_Button(120, 160, 30, 20, gettext("@-12"));
          o->tooltip(gettext("Select one level down in history"));
          o->shortcut(0x4ff54);
          o->labelsize(12);
          o->labelcolor(FL_FOREGROUND_COLOR);
          o->callback((Fl_Callback*)cb_Ans_Down);
        }
        { Fl_Button* o = Quest_In = new Fl_Button(150, 160, 30, 20, gettext("@-1<-"));
          o->tooltip(gettext("Select question"));
          o->shortcut(0x4ff51);
          o->labelsize(12);
          o->labelcolor(FL_FOREGROUND_COLOR);
          o->callback((Fl_Callback*)cb_Quest_In);
        }
        { Fl_Button* o = Answer = new Fl_Button(180, 160, 30, 20, gettext("@-1->"));
          o->tooltip(gettext("Select answer"));
          o->shortcut(0x4ff53);
          o->labelsize(12);
          o->labelcolor(FL_FOREGROUND_COLOR);
          o->callback((Fl_Callback*)cb_Answer);
        }
        { Fl_Button* o = Roll = new Fl_Button(210, 160, 30, 20, gettext("@-18"));
          o->tooltip(gettext("Roll levels in history"));
          o->labelsize(12);
          o->labelcolor((Fl_Color)1);
          o->callback((Fl_Callback*)cb_Roll);
        }
        { Fl_Button* o = Rolld = new Fl_Button(240, 160, 30, 20, gettext("@-12"));
          o->tooltip(gettext("Roll levels down in history"));
          o->labelsize(12);
          o->labelcolor((Fl_Color)1);
          o->callback((Fl_Callback*)cb_Rolld);
        }
        { Fl_Button* o = UNDO = new Fl_Button(270, 160, 55, 20, gettext("modif"));
          o->tooltip(gettext("Modify current history level"));
          o->color((Fl_Color)29);
          o->labelsize(12);
          o->labelcolor((Fl_Color)1);
          o->callback((Fl_Callback*)cb_UNDO);
        }
        { Fl_Button* o = TeX = new Fl_Button(325, 160, 50, 20, gettext("->tex"));
          o->tooltip(gettext("Translate selection in TeX to message line"));
          o->shortcut(0x80074);
          o->color((Fl_Color)29);
          o->labelsize(12);
          o->labelcolor(FL_FOREGROUND_COLOR);
          o->callback((Fl_Callback*)cb_TeX);
        }
        { Fl_Button* o = Show_io = new Fl_Button(375, 160, 50, 20, gettext("ia"));
          o->tooltip(gettext("Switch interactive history/io screen"));
          o->shortcut(0xffc2);
          o->color((Fl_Color)6);
          o->selection_color((Fl_Color)20);
          o->labelsize(12);
          o->labelcolor((Fl_Color)4);
          o->callback((Fl_Callback*)cb_Show_io);
        }
        o->end();
      }
      { Fl_Group* o = Historique_output = new Fl_Group(0, 20, 420, 140);
        { Fl_Group* o = Eqw_History_group = new Fl_Group(0, 20, 420, 140);
          { giac::Eqw* o = Eqw_history = new giac::Eqw(0, 20, 420, 140);
            o->box(FL_FLAT_BOX);
            o->color(FL_BACKGROUND_COLOR);
            o->selection_color(FL_BACKGROUND_COLOR);
            o->labeltype(FL_NORMAL_LABEL);
            o->labelfont(0);
            o->labelsize(14);
            o->labelcolor(FL_BLACK);
            o->align(FL_ALIGN_CENTER);
            o->when(FL_WHEN_RELEASE);
          }
          o->end();
        }
        { Fl_Group* o = Text_History_group = new Fl_Group(0, 20, 420, 140);
          o->hide();
          { Fl_Output* o = xcas_output = new Fl_Output(0, 20, 405, 140, gettext("output:"));
            o->type(12);
            o->labeltype(FL_NO_LABEL);
            o->labelsize(10);
            o->textcolor(4);
            Fl_Group::current()->resizable(o);
          }
          { Fl_Scrollbar* o = Xcas_Output_scroll = new Fl_Scrollbar(405, 20, 15, 140);
            o->slider_size(1);
            o->callback((Fl_Callback*)cb_Xcas_Output_scroll);
          }
          o->end();
        }
        o->end();
        Fl_Group::current()->resizable(o);
      }
      o->end();
    }
    { Fl_Group* o = Spread_group = new Fl_Group(0, 20, 425, 160);
      o->hide();
      { Fl_Group* o = Spread_buttons = new Fl_Group(0, 160, 425, 20);
        { Fl_Button* o = Spread_button_save = new Fl_Button(0, 160, 40, 20, gettext("save"));
          o->labelsize(12);
          o->callback((Fl_Callback*)cb_Spread_button_save);
        }
        { Fl_Button* o = Spread_copy_cell = new Fl_Button(60, 160, 45, 20, gettext("copy"));
          o->tooltip(gettext("Copy current cell to clipboard"));
          o->labelsize(12);
          o->callback((Fl_Callback*)cb_Spread_copy_cell);
        }
        { Fl_Button* o = Spread_recompute_button = new Fl_Button(105, 160, 45, 20, gettext("recalc"));
          o->tooltip(gettext("Recompute the spreadsheet"));
          o->labelsize(12);
          o->callback((Fl_Callback*)cb_Spread_recompute_button);
        }
        { Fl_Button* o = Spread_insert_row = new Fl_Button(150, 160, 35, 20, gettext("r+"));
          o->tooltip(gettext("Insert row"));
          o->labelsize(12);
          o->callback((Fl_Callback*)cb_Spread_insert_row);
        }
        { Fl_Button* o = Spread_insert_column = new Fl_Button(185, 160, 35, 20, gettext("c+"));
          o->tooltip(gettext("Insert column"));
          o->labelsize(12);
          o->callback((Fl_Callback*)cb_Spread_insert_column);
        }
        { Fl_Input* o = Spread_goto = new Fl_Input(220, 160, 45, 20);
          o->tooltip(gettext("Selection area"));
          o->labelsize(12);
          o->textsize(12);
          o->callback((Fl_Callback*)cb_Spread_goto);
        }
        { Fl_Menu_Bar* o = Spread_statistics_menu = new Fl_Menu_Bar(265, 160, 160, 20);
          o->menu(menu_Spread_statistics_menu);
        }
        { Fl_Menu_Button* o = Xcas_matrix_list_menu = new Fl_Menu_Button(40, 160, 20, 20);
          o->menu(menu_Xcas_matrix_list_menu);
        }
        o->end();
      }
      o->end();
    }
    { Fl_Group* o = Programme = new Fl_Group(0, 20, 425, 160);
      o->hide();
      { Fl_Group* o = Programme_boutons = new Fl_Group(0, 160, 425, 20);
        { Fl_Button* o = Button_program_save = new Fl_Button(0, 160, 45, 20, gettext("save"));
          o->tooltip(gettext("Save current program"));
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Button_program_save);
        }
        { Fl_Menu_Button* o = Xcas_program_list_menu = new Fl_Menu_Button(45, 160, 25, 20);
          o->menu(menu_Xcas_program_list_menu);
        }
        { Fl_Button* o = Button_program_load = new Fl_Button(70, 160, 35, 20, gettext("load"));
          o->tooltip(gettext("Load a new program"));
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Button_program_load);
        }
        { Fl_Button* o = Prg_fini = new Fl_Button(105, 160, 40, 20, gettext("->hist"));
          o->tooltip(gettext("Read program in history"));
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Prg_fini);
        }
        { Fl_Button* o = Button_program_save_and_compile = new Fl_Button(145, 160, 45, 20, gettext("parse"));
          o->tooltip(gettext("Test the program syntax"));
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Button_program_save_and_compile);
        }
        { Fl_Button* o = Button_program_exec_line = new Fl_Button(190, 160, 40, 20, gettext("exec"));
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Button_program_exec_line);
        }
        { Fl_Button* o = Button_func = new Fl_Button(230, 160, 35, 20, gettext("func"));
          o->shortcut(0xff1b);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Button_func);
        }
        { Fl_Button* o = Prg_semi = new Fl_Button(265, 160, 25, 20, gettext(";"));
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Prg_semi);
        }
        { Fl_Return_Button* o = Button_Insert_Return = new Fl_Return_Button(290, 160, 25, 20);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Button_Insert_Return);
        }
        { Fl_Button* o = Button_ifte = new Fl_Button(315, 160, 25, 20, gettext("if"));
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Button_ifte);
        }
        { Fl_Button* o = Button_for = new Fl_Button(340, 160, 35, 20, gettext("for"));
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Button_for);
        }
        { Fl_Button* o = Button_return = new Fl_Button(375, 160, 50, 20, gettext("return"));
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Button_return);
        }
        o->end();
      }
      { Fl_Text_Editor* o = Program_editor = new Fl_Text_Editor(0, 40, 425, 120);
        o->labeltype(FL_NO_LABEL);
        Fl_Group::current()->resizable(o);
        Fl_Text_Buffer * b = new Fl_Text_Buffer;
        Program_editor->buffer(b); style_init(b); b->add_modify_callback(style_update, Program_editor); b->add_modify_callback(Editor_changed_cb, Program_editor); Program_editor->highlight_data(stylebuf, styletable,sizeof(styletable) / sizeof(styletable[0]),'A', style_unfinished_cb, 0);
      }
      { Fl_Group* o = new Fl_Group(0, 20, 425, 20);
        { Fl_Input* o = Editor_search = new Fl_Input(40, 20, 60, 20, gettext("Find"));
          o->tooltip(gettext("Enter a word to find"));
          o->callback((Fl_Callback*)cb_Editor_search);
          o->when(FL_WHEN_ENTER_KEY);
        }
        { Fl_Button* o = Editor_next = new Fl_Button(220, 20, 45, 20, gettext("next"));
          o->tooltip(gettext("Find next occurence"));
          o->callback((Fl_Callback*)cb_Editor_next);
        }
        { Fl_Input* o = Editor_replace = new Fl_Input(160, 20, 60, 20, gettext("Replace"));
          o->tooltip(gettext("Enter replacement for the word to find"));
          o->callback((Fl_Callback*)cb_Editor_replace);
          o->when(FL_WHEN_ENTER_KEY);
        }
        { Fl_Output* o = Xcas_editor_filename = new Fl_Output(290, 20, 135, 20);
          o->tooltip(gettext("Program filename"));
        }
        o->end();
      }
      o->end();
    }
    { Fl_Group* o = Input_group = new Fl_Group(0, 180, 425, 110);
      { Fl_Group* o = bandeau = new Fl_Group(0, 180, 425, 40);
        o->color((Fl_Color)16);
        o->selection_color(FL_FOREGROUND_COLOR);
        o->hide();
        { Fl_Button* o = PREV = new Fl_Button(0, 180, 45, 20, gettext("<<"));
          o->tooltip(gettext("Previous menu page"));
          o->shortcut(0xffc7);
          o->color(FL_INACTIVE_COLOR);
          o->labelsize(12);
          o->labelcolor((Fl_Color)2);
          o->callback((Fl_Callback*)cb_PREV);
        }
        { Fl_Button* o = F1 = new Fl_Button(45, 180, 50, 20);
          o->shortcut(0xffbe);
          o->color(FL_INACTIVE_COLOR);
          o->labelsize(12);
          o->labelcolor(FL_BACKGROUND2_COLOR);
          o->callback((Fl_Callback*)cb_F1);
        }
        { Fl_Button* o = F2 = new Fl_Button(95, 180, 50, 20);
          o->shortcut(0xffbf);
          o->color(FL_INACTIVE_COLOR);
          o->labelsize(12);
          o->labelcolor(FL_BACKGROUND2_COLOR);
          o->callback((Fl_Callback*)cb_F2);
        }
        { Fl_Button* o = F3 = new Fl_Button(145, 180, 50, 20);
          o->shortcut(0xffc0);
          o->color(FL_INACTIVE_COLOR);
          o->labelsize(12);
          o->labelcolor(FL_BACKGROUND2_COLOR);
          o->callback((Fl_Callback*)cb_F3);
        }
        { Fl_Button* o = F4 = new Fl_Button(195, 180, 50, 20);
          o->shortcut(0xffc1);
          o->color(FL_INACTIVE_COLOR);
          o->labelsize(12);
          o->labelcolor(FL_BACKGROUND2_COLOR);
          o->callback((Fl_Callback*)cb_F4);
        }
        { Fl_Button* o = F5 = new Fl_Button(245, 180, 50, 20);
          o->shortcut(0xffc2);
          o->color(FL_INACTIVE_COLOR);
          o->labelsize(12);
          o->labelcolor(FL_BACKGROUND2_COLOR);
          o->callback((Fl_Callback*)cb_F5);
        }
        { Fl_Button* o = F6 = new Fl_Button(295, 180, 50, 20);
          o->shortcut(0xffc3);
          o->color(FL_INACTIVE_COLOR);
          o->labelsize(12);
          o->labelcolor(FL_BACKGROUND2_COLOR);
          o->callback((Fl_Callback*)cb_F6);
        }
        { Fl_Button* o = NXT = new Fl_Button(345, 180, 45, 20, gettext(">>"));
          o->tooltip(gettext("Next menu page"));
          o->shortcut(0xffc4);
          o->color(FL_INACTIVE_COLOR);
          o->labelsize(12);
          o->labelcolor((Fl_Color)2);
          o->callback((Fl_Callback*)cb_NXT);
        }
        { Fl_Button* o = CST = new Fl_Button(390, 180, 35, 20, gettext("cust"));
          o->tooltip(gettext("Custom menu"));
          o->shortcut(0xffc8);
          o->color(FL_INACTIVE_COLOR);
          o->labelsize(12);
          o->labelcolor(FL_BACKGROUND2_COLOR);
          o->callback((Fl_Callback*)cb_CST);
        }
        { Fl_Button* o = VAR = new Fl_Button(390, 200, 35, 20, gettext("var"));
          o->tooltip(gettext("Show list of variables"));
          o->shortcut(0xffc5);
          o->color(FL_INACTIVE_COLOR);
          o->labelsize(12);
          o->labelcolor(FL_BACKGROUND2_COLOR);
          o->callback((Fl_Callback*)cb_VAR);
        }
        { Fl_Button* o = Home_button = new Fl_Button(0, 200, 45, 20, gettext("home"));
          o->tooltip(gettext("Home menu"));
          o->shortcut(0xffc6);
          o->color(FL_INACTIVE_COLOR);
          o->labelsize(12);
          o->labelcolor(FL_BACKGROUND2_COLOR);
          o->callback((Fl_Callback*)cb_Home_button);
        }
        { Fl_Button* o = Eqw_button = new Fl_Button(45, 200, 50, 20, gettext("eqw"));
          o->tooltip(gettext("Equationwriter window"));
          o->shortcut(0x4ffc1);
          o->color((Fl_Color)3);
          o->labelsize(12);
          o->callback((Fl_Callback*)cb_Eqw_button);
        }
        { Fl_Button* o = Plot_view = new Fl_Button(95, 200, 50, 20, gettext("geo"));
          o->tooltip(gettext("Geometry and graphic windows"));
          o->shortcut(0x4ffc4);
          o->color((Fl_Color)3);
          o->labelsize(12);
          o->callback((Fl_Callback*)cb_Plot_view);
        }
        { Fl_Button* o = Help_online = new Fl_Button(145, 200, 50, 20, gettext("help"));
          o->tooltip(gettext("Help windows"));
          o->shortcut(0x4ffc2);
          o->color((Fl_Color)3);
          o->labelsize(12);
          o->callback((Fl_Callback*)cb_Help_online);
        }
        { Fl_Button* o = Show_history = new Fl_Button(195, 200, 50, 20, gettext("hist"));
          o->tooltip(gettext("History windows"));
          o->shortcut(0x4ffc3);
          o->color((Fl_Color)3);
          o->labelsize(12);
          o->callback((Fl_Callback*)cb_Show_history);
        }
        { Fl_Button* o = Full_message = new Fl_Button(245, 200, 50, 20, gettext("msg"));
          o->tooltip(gettext("Message windows"));
          o->shortcut(0x4ffc5);
          o->color((Fl_Color)3);
          o->labelsize(12);
          o->callback((Fl_Callback*)cb_Full_message);
        }
        { Fl_Button* o = MTRW = new Fl_Button(295, 200, 50, 20, gettext("mtrw"));
          o->tooltip(gettext("Matrixwriter/Spreadsheet windows"));
          o->shortcut(0x4ffc6);
          o->color((Fl_Color)3);
          o->labelsize(12);
          o->callback((Fl_Callback*)cb_MTRW);
        }
        { Fl_Button* o = Prog_button = new Fl_Button(345, 200, 45, 20, gettext("prg"));
          o->tooltip(gettext("Program editor windows"));
          o->shortcut(0x4ffc7);
          o->color((Fl_Color)3);
          o->labelsize(12);
          o->callback((Fl_Callback*)cb_Prog_button);
        }
        o->end();
      }
      { Fl_Group* o = bandeau2 = new Fl_Group(0, 180, 425, 40);
        o->color((Fl_Color)16);
        o->selection_color(FL_FOREGROUND_COLOR);
        { Fl_Button* o = bandeau_fill = new Fl_Button(0, 180, 425, 20, gettext("www-fourier.ujf-grenoble.fr/~parisse/giac.html"));
          o->callback((Fl_Callback*)cb_bandeau_fill);
        }
        { Fl_Button* o = bandeau_fill2 = new Fl_Button(0, 200, 45, 20, gettext("home"));
          o->tooltip(gettext("Back to initial window"));
          o->color((Fl_Color)3);
          o->labelsize(12);
          o->callback((Fl_Callback*)cb_bandeau_fill2);
        }
        { Fl_Button* o = Eqw_button2 = new Fl_Button(45, 200, 50, 20, gettext("eqw"));
          o->tooltip(gettext("Equationwriter window"));
          o->shortcut(0x4ffc1);
          o->color((Fl_Color)3);
          o->labelsize(12);
          o->callback((Fl_Callback*)cb_Eqw_button2);
        }
        { Fl_Button* o = Plot_view2 = new Fl_Button(95, 200, 50, 20, gettext("geo"));
          o->tooltip(gettext("Geometry and graphic windows"));
          o->shortcut(0x4ffc4);
          o->color((Fl_Color)3);
          o->labelsize(12);
          o->callback((Fl_Callback*)cb_Plot_view2);
        }
        { Fl_Button* o = Help_online2 = new Fl_Button(145, 200, 50, 20, gettext("help"));
          o->tooltip(gettext("Help windows"));
          o->shortcut(0x4ffc2);
          o->color((Fl_Color)3);
          o->labelsize(12);
          o->callback((Fl_Callback*)cb_Help_online2);
        }
        { Fl_Button* o = Show_history2 = new Fl_Button(195, 200, 50, 20, gettext("hist"));
          o->tooltip(gettext("History windows"));
          o->shortcut(0x4ffc3);
          o->color((Fl_Color)3);
          o->labelsize(12);
          o->callback((Fl_Callback*)cb_Show_history2);
        }
        { Fl_Button* o = Full_message2 = new Fl_Button(245, 200, 50, 20, gettext("msg"));
          o->tooltip(gettext("Message windows"));
          o->shortcut(0x4ffc5);
          o->color((Fl_Color)3);
          o->labelsize(12);
          o->callback((Fl_Callback*)cb_Full_message2);
        }
        { Fl_Button* o = MTRW2 = new Fl_Button(295, 200, 50, 20, gettext("mtrw"));
          o->tooltip(gettext("Matrixwriter/Spreadsheet windows"));
          o->shortcut(0x4ffc6);
          o->color((Fl_Color)3);
          o->labelsize(12);
          o->callback((Fl_Callback*)cb_MTRW2);
        }
        { Fl_Button* o = Prog_button2 = new Fl_Button(345, 200, 45, 20, gettext("prg"));
          o->tooltip(gettext("Program editor windows"));
          o->shortcut(0x4ffc7);
          o->color((Fl_Color)3);
          o->labelsize(12);
          o->callback((Fl_Callback*)cb_Prog_button2);
        }
        { Fl_Button* o = Xcas_var = new Fl_Button(390, 200, 35, 20, gettext("var"));
          o->tooltip(gettext("Show list of variables"));
          o->shortcut(0xffc5);
          o->color(FL_INACTIVE_COLOR);
          o->labelsize(12);
          o->labelcolor(FL_BACKGROUND2_COLOR);
          o->callback((Fl_Callback*)cb_Xcas_var);
        }
        o->end();
      }
      { Fl_Input* o = input_old = new Fl_Input(0, 220, 320, 25, gettext("In:"));
        o->type(4);
        o->labeltype(FL_NO_LABEL);
        o->labelsize(10);
        o->callback((Fl_Callback*)cb_input_old);
        o->align(132);
        o->when(FL_WHEN_ENTER_KEY_ALWAYS);
        o->hide();
      }
      { giac::Input_tab* o = input = new giac::Input_tab(0, 220, 320, 25, gettext("label"));
        o->tooltip(gettext("Commandline"));
        o->box(FL_DOWN_BOX);
        o->color(FL_BACKGROUND2_COLOR);
        o->selection_color((Fl_Color)4);
        o->labeltype(FL_NO_LABEL);
        o->labelfont(0);
        o->labelsize(14);
        o->labelcolor(FL_BLACK);
        o->callback((Fl_Callback*)cb_input);
        o->align(FL_ALIGN_CENTER);
        o->when(FL_WHEN_ENTER_KEY);
      }
      { Fl_Group* o = Status_group = new Fl_Group(0, 245, 315, 20);
        { Fl_Output* o = Xcas_mode = new Fl_Output(0, 245, 220, 20, gettext("mode"));
          o->tooltip(gettext("Status line"));
          o->color((Fl_Color)19);
          o->labeltype(FL_NO_LABEL);
          o->labelsize(10);
          o->textsize(12);
          o->textcolor(1);
          o->callback((Fl_Callback*)cb_Xcas_mode);
        }
        { Fl_Button* o = Geo_setup_button = new Fl_Button(220, 245, 30, 20, gettext("geo"));
          o->tooltip(gettext("Change geometric window settings"));
          o->color((Fl_Color)19);
          o->labelsize(12);
          o->labelcolor((Fl_Color)1);
          o->callback((Fl_Callback*)cb_Geo_setup_button);
        }
        { Fl_Button* o = Cas_setup_button = new Fl_Button(250, 245, 30, 20, gettext("cas"));
          o->tooltip(gettext("Change cas settings"));
          o->color((Fl_Color)19);
          o->labelsize(12);
          o->labelcolor((Fl_Color)1);
          o->callback((Fl_Callback*)cb_Cas_setup_button);
        }
        { Fl_Button* o = Gen_setup = new Fl_Button(280, 245, 35, 20, gettext("gen"));
          o->tooltip(gettext("Change xcas general settings"));
          o->color((Fl_Color)19);
          o->labelsize(12);
          o->labelcolor((Fl_Color)1);
          o->callback((Fl_Callback*)cb_Gen_setup);
        }
        { Fl_Button* o = Xcas_Computation_progress = new Fl_Button(0, 245, 315, 20, gettext("Computing spreadsheet. Press stop to interrupt"));
          o->hide();
        }
        o->end();
      }
      { Fl_Group* o = Message_group = new Fl_Group(0, 265, 315, 25);
        { Fl_Output* o = Help_text = new Fl_Output(0, 265, 275, 25);
          o->tooltip(gettext("Message line"));
          o->type(12);
          o->labeltype(FL_NO_LABEL);
          o->textsize(10);
          o->textcolor(72);
          o->align(132);
        }
        { Fl_Button* o = Send_kill_to_child = new Fl_Button(275, 265, 40, 25, gettext("stop"));
          o->tooltip(gettext("Interrupt computation"));
          o->box(FL_OVAL_BOX);
          o->shortcut(0x40063);
          o->color((Fl_Color)1);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Send_kill_to_child);
        }
        o->end();
      }
      { Fl_Group* o = Direction_group2 = new Fl_Group(320, 220, 105, 70);
        o->hide();
        { Fl_Button* o = Geo_left = new Fl_Button(320, 220, 25, 20, gettext("@-1<-"));
          o->shortcut(0x4ff51);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Geo_left);
        }
        { Fl_Button* o = Geo_right = new Fl_Button(345, 220, 25, 20, gettext("@-1->"));
          o->shortcut(0x4ff53);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Geo_right);
        }
        { Fl_Button* o = Geo_haut = new Fl_Button(370, 220, 25, 20, gettext("@-18"));
          o->shortcut(0xff52);
          o->labelsize(10);
          o->labelcolor(FL_INACTIVE_COLOR);
          o->callback((Fl_Callback*)cb_Geo_haut);
        }
        { Fl_Button* o = Geo_bas = new Fl_Button(395, 220, 25, 20, gettext("@-12"));
          o->shortcut(0x4ff54);
          o->labelcolor(FL_INACTIVE_COLOR);
          o->callback((Fl_Callback*)cb_Geo_bas);
        }
        { Fl_Button* o = Geo_backspace = new Fl_Button(320, 240, 25, 25, gettext("<-"));
          o->shortcut(0xff08);
          o->callback((Fl_Callback*)cb_Geo_backspace);
        }
        { Fl_Button* o = Geo_eval = new Fl_Button(345, 240, 25, 25, gettext("eval"));
          o->shortcut(0x80065);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Geo_eval);
        }
        { Fl_Button* o = Geo_paste = new Fl_Button(370, 240, 30, 25, gettext("paste"));
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Geo_paste);
        }
        { Fl_Button* o = Geo_tab = new Fl_Button(400, 240, 20, 25, gettext("->"));
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Geo_tab);
        }
        { Fl_Button* o = Geo_kbd = new Fl_Button(320, 265, 25, 25, gettext("kbd"));
          o->tooltip(gettext("Switch keyboard on or off"));
          o->color((Fl_Color)2);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Geo_kbd);
        }
        { Fl_Button* o = Geo_esc = new Fl_Button(345, 265, 25, 25, gettext("esc"));
          o->shortcut(0xff1b);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Geo_esc);
        }
        { Fl_Button* o = Geo_enter = new Fl_Button(370, 265, 50, 25, gettext("enter"));
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Geo_enter);
        }
        o->end();
      }
      { Fl_Group* o = Direction_group = new Fl_Group(320, 220, 105, 70);
        { Fl_Button* o = En_haut = new Fl_Button(365, 225, 20, 20, gettext("@-18"));
          o->shortcut(0x4ff52);
          o->labelsize(10);
          o->labelcolor(FL_INACTIVE_COLOR);
          o->callback((Fl_Callback*)cb_En_haut);
        }
        { Fl_Button* o = En_bas = new Fl_Button(365, 265, 20, 20, gettext("@-12"));
          o->shortcut(0x4ff54);
          o->labelcolor(FL_INACTIVE_COLOR);
          o->callback((Fl_Callback*)cb_En_bas);
        }
        { Fl_Button* o = Move_selection_right = new Fl_Button(385, 245, 25, 20, gettext("@-1->"));
          o->shortcut(0x4ff53);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Move_selection_right);
        }
        { Fl_Button* o = Move_selection_left = new Fl_Button(340, 245, 25, 20, gettext("@-1<-"));
          o->shortcut(0x4ff51);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Move_selection_left);
        }
        { Fl_Button* o = Backspace = new Fl_Button(390, 265, 30, 20, gettext("<-"));
          o->tooltip(gettext("Erase one character to the left"));
          o->shortcut(0xff08);
          o->callback((Fl_Callback*)cb_Backspace);
        }
        { Fl_Button* o = Prg_paste = new Fl_Button(325, 225, 35, 20, gettext("paste"));
          o->tooltip(gettext("Paste clipboard content"));
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Prg_paste);
        }
        { Fl_Button* o = Shift_Key = new Fl_Button(325, 265, 35, 20, gettext("abc"));
          o->tooltip(gettext("Alphabetic keyboard switch (abc or shift key)"));
          o->color((Fl_Color)10);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Shift_Key);
        }
        { Fl_Button* o = Tabulation = new Fl_Button(390, 225, 30, 20, gettext("->"));
          o->tooltip(gettext("Completion key"));
          o->shortcut(0xff09);
          o->callback((Fl_Callback*)cb_Tabulation);
        }
        o->end();
      }
      o->end();
    }
    { Fl_Group* o = Keyboard_group = new Fl_Group(0, 290, 420, 100);
      { Fl_Group* o = Alpha_keyboard = new Fl_Group(0, 290, 305, 100);
        o->hide();
        { Fl_Button* o = a_key = new Fl_Button(0, 290, 30, 25, gettext("a"));
          o->color((Fl_Color)10);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_a_key);
        }
        { Fl_Button* o = b_key = new Fl_Button(30, 290, 25, 25, gettext("b"));
          o->color((Fl_Color)10);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_b_key);
        }
        { Fl_Button* o = c_key = new Fl_Button(55, 290, 25, 25, gettext("c"));
          o->color((Fl_Color)10);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_c_key);
        }
        { Fl_Button* o = d_key = new Fl_Button(80, 290, 25, 25, gettext("d"));
          o->color((Fl_Color)10);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_d_key);
        }
        { Fl_Button* o = e_key = new Fl_Button(105, 290, 25, 25, gettext("e"));
          o->color((Fl_Color)10);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_e_key);
        }
        { Fl_Button* o = f_key = new Fl_Button(130, 290, 25, 25, gettext("f"));
          o->color((Fl_Color)10);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_f_key);
        }
        { Fl_Button* o = g_key = new Fl_Button(155, 290, 25, 25, gettext("g"));
          o->color((Fl_Color)10);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_g_key);
        }
        { Fl_Button* o = h_key = new Fl_Button(180, 290, 25, 25, gettext("h"));
          o->color((Fl_Color)10);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_h_key);
        }
        { Fl_Button* o = i_key = new Fl_Button(205, 290, 25, 25, gettext("i"));
          o->color((Fl_Color)10);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_i_key);
        }
        { Fl_Button* o = j_key = new Fl_Button(230, 290, 25, 25, gettext("j"));
          o->color((Fl_Color)10);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_j_key);
        }
        { Fl_Button* o = k_key = new Fl_Button(255, 290, 25, 25, gettext("k"));
          o->color((Fl_Color)10);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_k_key);
        }
        { Fl_Button* o = l_key = new Fl_Button(280, 290, 25, 25, gettext("l"));
          o->color((Fl_Color)10);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_l_key);
        }
        { Fl_Button* o = m_key = new Fl_Button(0, 315, 30, 25, gettext("m"));
          o->color((Fl_Color)10);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_m_key);
        }
        { Fl_Button* o = n_key = new Fl_Button(30, 315, 25, 25, gettext("n"));
          o->color((Fl_Color)10);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_n_key);
        }
        { Fl_Button* o = o_key = new Fl_Button(55, 315, 25, 25, gettext("o"));
          o->color((Fl_Color)10);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_o_key);
        }
        { Fl_Button* o = p_key = new Fl_Button(80, 315, 25, 25, gettext("p"));
          o->color((Fl_Color)10);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_p_key);
        }
        { Fl_Button* o = q_key = new Fl_Button(105, 315, 25, 25, gettext("q"));
          o->color((Fl_Color)10);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_q_key);
        }
        { Fl_Button* o = r_key = new Fl_Button(130, 315, 25, 25, gettext("r"));
          o->color((Fl_Color)10);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_r_key);
        }
        { Fl_Button* o = s_key = new Fl_Button(155, 315, 25, 25, gettext("s"));
          o->color((Fl_Color)10);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_s_key);
        }
        { Fl_Button* o = t_key = new Fl_Button(180, 315, 25, 25, gettext("t"));
          o->color((Fl_Color)10);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_t_key);
        }
        { Fl_Button* o = u_key = new Fl_Button(205, 315, 25, 25, gettext("u"));
          o->color((Fl_Color)10);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_u_key);
        }
        { Fl_Button* o = v_key = new Fl_Button(230, 315, 25, 25, gettext("v"));
          o->color((Fl_Color)10);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_v_key);
        }
        { Fl_Button* o = w_key = new Fl_Button(255, 315, 25, 25, gettext("w"));
          o->color((Fl_Color)10);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_w_key);
        }
        { Fl_Button* o = x_key = new Fl_Button(280, 315, 25, 25, gettext("x"));
          o->color((Fl_Color)10);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_x_key);
        }
        { Fl_Button* o = y_key = new Fl_Button(0, 340, 30, 25, gettext("y"));
          o->color((Fl_Color)10);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_y_key);
        }
        { Fl_Button* o = z_key = new Fl_Button(30, 340, 25, 25, gettext("z"));
          o->color((Fl_Color)10);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_z_key);
        }
        { Fl_Button* o = Inferieur_key = new Fl_Button(55, 340, 25, 25, gettext("<"));
          o->color((Fl_Color)10);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Inferieur_key);
        }
        { Fl_Button* o = Superieur_key = new Fl_Button(80, 340, 25, 25, gettext(">"));
          o->color((Fl_Color)10);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Superieur_key);
        }
        { Fl_Button* o = Backslash_key = new Fl_Button(30, 365, 25, 25, gettext("\\"));
          o->color((Fl_Color)10);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Backslash_key);
        }
        { Fl_Button* o = Parenthese_ouvrante_key = new Fl_Button(105, 340, 25, 25, gettext("("));
          o->color((Fl_Color)10);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Parenthese_ouvrante_key);
        }
        { Fl_Button* o = Parenthese_fermante_key = new Fl_Button(130, 340, 25, 25, gettext(")"));
          o->color((Fl_Color)10);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Parenthese_fermante_key);
        }
        { Fl_Button* o = Espace_key = new Fl_Button(255, 365, 25, 25);
          o->color((Fl_Color)10);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Espace_key);
        }
        { Fl_Button* o = Point_exclamation_key = new Fl_Button(180, 365, 25, 25, gettext("!"));
          o->color((Fl_Color)10);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Point_exclamation_key);
        }
        { Fl_Button* o = Crochet_fermant_key = new Fl_Button(180, 340, 25, 25, gettext("]"));
          o->color((Fl_Color)10);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Crochet_fermant_key);
        }
        { Fl_Button* o = Crochet_ouvrant_key = new Fl_Button(155, 340, 25, 25, gettext("["));
          o->color((Fl_Color)10);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Crochet_ouvrant_key);
        }
        { Fl_Button* o = Accolade_ouvrant_key = new Fl_Button(205, 340, 25, 25, gettext("{"));
          o->color((Fl_Color)10);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Accolade_ouvrant_key);
        }
        { Fl_Button* o = Accolade_fermant_key = new Fl_Button(230, 340, 25, 25, gettext("}"));
          o->color((Fl_Color)10);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Accolade_fermant_key);
        }
        { Fl_Button* o = Deux_points_key = new Fl_Button(130, 365, 25, 25, gettext(":"));
          o->color((Fl_Color)10);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Deux_points_key);
        }
        { Fl_Button* o = Equal_key = new Fl_Button(155, 365, 25, 25, gettext("="));
          o->color((Fl_Color)10);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Equal_key);
        }
        { Fl_Button* o = Guillemet_key = new Fl_Button(280, 340, 25, 25, gettext("\""));
          o->color((Fl_Color)10);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Guillemet_key);
        }
        { Fl_Button* o = Souligne_key = new Fl_Button(55, 365, 25, 25, gettext("_"));
          o->color((Fl_Color)10);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Souligne_key);
        }
        { Fl_Button* o = Majuscule_key = new Fl_Button(0, 365, 30, 25, gettext("Maj"));
          o->color((Fl_Color)1);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Majuscule_key);
        }
        { Fl_Button* o = Diese_key = new Fl_Button(205, 365, 25, 25, gettext("#"));
          o->color((Fl_Color)10);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Diese_key);
        }
        { Fl_Button* o = Pi_key = new Fl_Button(230, 365, 25, 25, gettext("p"));
          o->color((Fl_Color)10);
          o->labelfont(12);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Pi_key);
        }
        { Fl_Return_Button* o = A_la_ligne = new Fl_Return_Button(280, 365, 25, 25);
          o->color((Fl_Color)10);
          o->selection_color(FL_FOREGROUND_COLOR);
          o->callback((Fl_Callback*)cb_A_la_ligne);
        }
        { Fl_Button* o = Alpha_virgule_key = new Fl_Button(80, 365, 25, 25, gettext(","));
          o->color((Fl_Color)10);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Alpha_virgule_key);
        }
        { Fl_Button* o = Alpha_point_virgule_key = new Fl_Button(105, 365, 25, 25, gettext(";"));
          o->color((Fl_Color)10);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Alpha_point_virgule_key);
        }
        { Fl_Button* o = Alpha_quote_key = new Fl_Button(255, 340, 25, 25, gettext("\'"));
          o->color((Fl_Color)10);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Alpha_quote_key);
        }
        o->end();
      }
      { Fl_Group* o = Scientific_keyboard = new Fl_Group(0, 290, 310, 100);
        { Fl_Menu_Button* o = Keyboard_intsumdiff = new Fl_Menu_Button(0, 290, 40, 25, gettext("d,I,S"));
          o->labelfont(12);
          o->labelsize(12);
          o->textsize(12);
          o->menu(menu_Keyboard_intsumdiff);
        }
        { Fl_Menu_Button* o = Keyboard_limseries = new Fl_Menu_Button(0, 315, 40, 25, gettext("lim"));
          o->labelsize(12);
          o->textsize(12);
          o->menu(menu_Keyboard_limseries);
        }
        { Fl_Group* o = Delim_keyboard = new Fl_Group(40, 290, 140, 50);
          { Fl_Button* o = Double_quote = new Fl_Button(60, 290, 30, 25, gettext("\""));
            o->labelsize(10);
            o->callback((Fl_Callback*)cb_Double_quote);
          }
          { Fl_Button* o = RPN_programme = new Fl_Button(90, 290, 30, 25, gettext("()"));
            o->labelsize(10);
            o->callback((Fl_Callback*)cb_RPN_programme);
          }
          { Fl_Button* o = Brackets = new Fl_Button(150, 290, 30, 25, gettext("{}"));
            o->labelsize(10);
            o->callback((Fl_Callback*)cb_Brackets);
          }
          { Fl_Button* o = Crochets = new Fl_Button(120, 290, 30, 25, gettext("[ ]"));
            o->labelsize(10);
            o->callback((Fl_Callback*)cb_Crochets);
          }
          { Fl_Button* o = Quote = new Fl_Button(40, 290, 20, 25, gettext("\'"));
            o->labelsize(10);
            o->callback((Fl_Callback*)cb_Quote);
          }
          { Fl_Button* o = Virgule = new Fl_Button(90, 315, 30, 25, gettext(","));
            o->callback((Fl_Callback*)cb_Virgule);
          }
          { Fl_Button* o = Semi_button = new Fl_Button(120, 315, 30, 25, gettext(";"));
            o->labelsize(10);
            o->callback((Fl_Callback*)cb_Semi_button);
          }
          { Fl_Button* o = Sto = new Fl_Button(60, 315, 30, 25, gettext(":="));
            o->labelsize(10);
            o->callback((Fl_Callback*)cb_Sto);
          }
          { Fl_Button* o = Keyboard_suchthat = new Fl_Button(40, 315, 20, 25, gettext("|"));
            o->callback((Fl_Callback*)cb_Keyboard_suchthat);
          }
          { Fl_Button* o = RPN_space = new Fl_Button(150, 315, 30, 25);
            o->labelsize(10);
            o->callback((Fl_Callback*)cb_RPN_space);
          }
          o->end();
        }
        { Fl_Group* o = Transcendental = new Fl_Group(0, 340, 120, 50);
          { Fl_Group* o = Trig_keyboard = new Fl_Group(0, 340, 120, 25);
            { Fl_Button* o = Sinus_button = new Fl_Button(10, 340, 30, 25, gettext("sin"));
              o->labelsize(10);
              o->callback((Fl_Callback*)cb_Sinus_button);
            }
            { Fl_Button* o = Cosinus_button = new Fl_Button(50, 340, 30, 25, gettext("cos"));
              o->labelsize(10);
              o->callback((Fl_Callback*)cb_Cosinus_button);
            }
            { Fl_Button* o = Tangeant_button = new Fl_Button(90, 340, 30, 25, gettext("tan"));
              o->labelsize(10);
              o->callback((Fl_Callback*)cb_Tangeant_button);
            }
            { Fl_Button* o = Asinus_button = new Fl_Button(0, 340, 10, 25, gettext("a"));
              o->color((Fl_Color)29);
              o->labelsize(10);
              o->labelcolor((Fl_Color)4);
              o->callback((Fl_Callback*)cb_Asinus_button);
            }
            { Fl_Button* o = Acosinus_button = new Fl_Button(40, 340, 10, 25, gettext("a"));
              o->color((Fl_Color)29);
              o->labelsize(10);
              o->labelcolor((Fl_Color)4);
              o->callback((Fl_Callback*)cb_Acosinus_button);
            }
            { Fl_Button* o = Atangeant_button = new Fl_Button(80, 340, 10, 25, gettext("a"));
              o->color((Fl_Color)29);
              o->labelsize(10);
              o->labelcolor((Fl_Color)4);
              o->callback((Fl_Callback*)cb_Atangeant_button);
            }
            o->end();
          }
          { Fl_Group* o = Exp_keyboard = new Fl_Group(0, 365, 120, 25);
            { Fl_Button* o = Exp_button = new Fl_Button(0, 365, 30, 25, gettext("e^"));
              o->labelsize(10);
              o->callback((Fl_Callback*)cb_Exp_button);
            }
            { Fl_Button* o = Dix_puissance = new Fl_Button(60, 365, 30, 25, gettext("10^"));
              o->labelsize(10);
              o->callback((Fl_Callback*)cb_Dix_puissance);
            }
            { Fl_Button* o = Ln10_button = new Fl_Button(90, 365, 30, 25, gettext("log10"));
              o->labelsize(10);
              o->callback((Fl_Callback*)cb_Ln10_button);
            }
            { Fl_Button* o = Ln_button = new Fl_Button(30, 365, 30, 25, gettext("ln"));
              o->labelsize(10);
              o->callback((Fl_Callback*)cb_Ln_button);
            }
            o->end();
          }
          o->end();
        }
        { Fl_Group* o = Cst_keyboard = new Fl_Group(120, 340, 60, 50);
          { Fl_Button* o = Cst_i = new Fl_Button(120, 340, 30, 25, gettext("i"));
            o->shortcut(0x69);
            o->labelsize(10);
            o->callback((Fl_Callback*)cb_Cst_i);
          }
          { Fl_Button* o = Cst_pi = new Fl_Button(150, 340, 30, 25, gettext("p"));
            o->labelfont(12);
            o->labelsize(10);
            o->callback((Fl_Callback*)cb_Cst_pi);
          }
          { Fl_Button* o = Keyboard_infinity = new Fl_Button(120, 365, 30, 25, gettext("oo"));
            o->labelsize(10);
            o->callback((Fl_Callback*)cb_Keyboard_infinity);
          }
          { Fl_Button* o = Keyboard_e = new Fl_Button(150, 365, 30, 25, gettext("e"));
            o->labelsize(10);
            o->callback((Fl_Callback*)cb_Keyboard_e);
          }
          o->end();
        }
        { Fl_Group* o = Unary_keyboard = new Fl_Group(220, 290, 60, 50);
          { Fl_Button* o = Racine_carree = new Fl_Button(220, 315, 30, 25, gettext("sqrt"));
            o->labelsize(10);
            o->callback((Fl_Callback*)cb_Racine_carree);
          }
          { Fl_Button* o = Inverse_button = new Fl_Button(250, 290, 30, 25, gettext("1/x"));
            o->labelsize(10);
            o->callback((Fl_Callback*)cb_Inverse_button);
          }
          { Fl_Button* o = Plus_moins = new Fl_Button(250, 315, 30, 25, gettext("+-"));
            o->labelsize(10);
            o->callback((Fl_Callback*)cb_Plus_moins);
          }
          { Fl_Button* o = Carre = new Fl_Button(220, 290, 30, 25, gettext("x^2"));
            o->labelsize(10);
            o->callback((Fl_Callback*)cb_Carre);
          }
          o->end();
        }
        { Fl_Group* o = Binary_keyboard = new Fl_Group(250, 290, 60, 100);
          { Fl_Button* o = Plus = new Fl_Button(280, 290, 30, 25, gettext("+"));
            o->shortcut(0x2b);
            o->callback((Fl_Callback*)cb_Plus);
          }
          { Fl_Button* o = Moins = new Fl_Button(280, 315, 30, 25, gettext("-"));
            o->shortcut(0x2d);
            o->callback((Fl_Callback*)cb_Moins);
          }
          { Fl_Button* o = Fois = new Fl_Button(280, 340, 30, 25, gettext("*"));
            o->shortcut(0x2a);
            o->callback((Fl_Callback*)cb_Fois);
          }
          { Fl_Button* o = Divise = new Fl_Button(280, 365, 30, 25, gettext("/"));
            o->shortcut(0x2f);
            o->callback((Fl_Callback*)cb_Divise);
          }
          { Fl_Button* o = Puissance = new Fl_Button(250, 340, 30, 25, gettext("^"));
            o->shortcut(0x5e);
            o->labelsize(10);
            o->callback((Fl_Callback*)cb_Puissance);
          }
          { Fl_Button* o = C_mod = new Fl_Button(250, 365, 30, 25, gettext("%"));
            o->labelsize(10);
            o->callback((Fl_Callback*)cb_C_mod);
          }
          o->end();
        }
        { Fl_Group* o = Lettre_keyboard = new Fl_Group(190, 340, 60, 50);
          { Fl_Button* o = Variable_x = new Fl_Button(190, 340, 30, 25, gettext("x"));
            o->shortcut(0x78);
            o->labelsize(10);
            o->callback((Fl_Callback*)cb_Variable_x);
          }
          { Fl_Button* o = Variable_y = new Fl_Button(220, 340, 30, 25, gettext("y"));
            o->shortcut(0x79);
            o->labelsize(10);
            o->callback((Fl_Callback*)cb_Variable_y);
          }
          { Fl_Button* o = Variable_z = new Fl_Button(190, 365, 30, 25, gettext("z"));
            o->shortcut(0x7a);
            o->labelsize(10);
            o->callback((Fl_Callback*)cb_Variable_z);
          }
          { Fl_Button* o = Key_t = new Fl_Button(220, 365, 30, 25, gettext("t"));
            o->labelsize(10);
            o->callback((Fl_Callback*)cb_Key_t);
          }
          o->end();
        }
        { Fl_Button* o = Evalf = new Fl_Button(190, 290, 30, 25, gettext("num"));
          o->shortcut(0x80068);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Evalf);
        }
        { Fl_Button* o = Select_eval = new Fl_Button(190, 315, 30, 25, gettext("eval"));
          o->shortcut(0x80065);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Select_eval);
        }
        o->end();
      }
      { Fl_Group* o = Numeric_numbers = new Fl_Group(320, 290, 100, 75);
        { Fl_Button* o = Un = new Fl_Button(345, 340, 25, 25, gettext("1"));
          o->shortcut(0x31);
          o->callback((Fl_Callback*)cb_Un);
        }
        { Fl_Button* o = Deux = new Fl_Button(370, 340, 25, 25, gettext("2"));
          o->shortcut(0x32);
          o->callback((Fl_Callback*)cb_Deux);
        }
        { Fl_Button* o = Trois = new Fl_Button(395, 340, 25, 25, gettext("3"));
          o->shortcut(0x33);
          o->callback((Fl_Callback*)cb_Trois);
        }
        { Fl_Button* o = Quatre = new Fl_Button(345, 315, 25, 25, gettext("4"));
          o->shortcut(0x34);
          o->callback((Fl_Callback*)cb_Quatre);
        }
        { Fl_Button* o = Cinq = new Fl_Button(370, 315, 25, 25, gettext("5"));
          o->shortcut(0x35);
          o->callback((Fl_Callback*)cb_Cinq);
        }
        { Fl_Button* o = Six = new Fl_Button(395, 315, 25, 25, gettext("6"));
          o->shortcut(0x36);
          o->callback((Fl_Callback*)cb_Six);
        }
        { Fl_Button* o = Sept = new Fl_Button(345, 290, 25, 25, gettext("7"));
          o->shortcut(0x37);
          o->callback((Fl_Callback*)cb_Sept);
        }
        { Fl_Button* o = Huit = new Fl_Button(370, 290, 25, 25, gettext("8"));
          o->shortcut(0x38);
          o->callback((Fl_Callback*)cb_Huit);
        }
        { Fl_Button* o = Neuf = new Fl_Button(395, 290, 25, 25, gettext("9"));
          o->shortcut(0x39);
          o->callback((Fl_Callback*)cb_Neuf);
        }
        { Fl_Button* o = Zero = new Fl_Button(320, 340, 25, 25, gettext("0"));
          o->shortcut(0x30);
          o->callback((Fl_Callback*)cb_Zero);
        }
        { Fl_Button* o = Point = new Fl_Button(320, 315, 25, 25, gettext("."));
          o->callback((Fl_Callback*)cb_Point);
        }
        { Fl_Button* o = EEX = new Fl_Button(320, 290, 25, 25, gettext("ee"));
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_EEX);
        }
        o->end();
      }
      { Fl_Group* o = Kbd_control = new Fl_Group(320, 365, 100, 25);
        { Fl_Button* o = Echappement = new Fl_Button(345, 365, 25, 25, gettext("esc"));
          o->tooltip(gettext("Cancel (erase cmdline, stop interactive_plotode)"));
          o->shortcut(0xff1b);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Echappement);
        }
        { Fl_Button* o = Show_kbd = new Fl_Button(320, 365, 25, 25, gettext("kbd"));
          o->tooltip(gettext("Switch keyboard on or off"));
          o->color((Fl_Color)10);
          o->selection_color((Fl_Color)29);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Show_kbd);
        }
        { Fl_Button* o = ENTER = new Fl_Button(370, 365, 50, 25, gettext("enter"));
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_ENTER);
        }
        o->end();
      }
      o->end();
    }
    { Fl_Group* o = Plot_setup_w = new Fl_Group(0, 20, 320, 270, gettext("Plot setup"));
      o->box(FL_SHADOW_BOX);
      o->color(FL_BACKGROUND2_COLOR);
      o->labeltype(FL_NO_LABEL);
      o->labelsize(10);
      o->hide();
      { Fl_Value_Input* o = Xmin = new Fl_Value_Input(50, 28, 45, 22, gettext("X-"));
        o->tooltip(gettext("Xmin for computation"));
        o->labelsize(10);
        o->minimum(-1e+99);
        o->maximum(1e+99);
        o->value(-6.5);
        o->textsize(10);
      }
      { Fl_Value_Input* o = Xmax = new Fl_Value_Input(150, 28, 45, 22, gettext("X+"));
        o->tooltip(gettext("Xmax for computation"));
        o->labelsize(10);
        o->minimum(-1e+99);
        o->maximum(1e+99);
        o->value(6.5);
        o->textsize(10);
      }
      { Fl_Value_Input* o = Ymin = new Fl_Value_Input(50, 55, 45, 20, gettext("Y-"));
        o->tooltip(gettext("Ymin for computation"));
        o->labelsize(10);
        o->minimum(-1e+99);
        o->maximum(1e+99);
        o->value(-3.1);
        o->textsize(10);
      }
      { Fl_Value_Input* o = Ymax = new Fl_Value_Input(150, 55, 45, 20, gettext("Y+"));
        o->tooltip(gettext("Ymax for computation"));
        o->labelsize(10);
        o->minimum(-1e+99);
        o->maximum(1e+99);
        o->value(3.1);
        o->textsize(10);
      }
      { Fl_Value_Input* o = Zmin = new Fl_Value_Input(50, 80, 45, 20, gettext("Z-"));
        o->tooltip(gettext("Zmin (3-d)"));
        o->labelsize(10);
        o->minimum(-1e+99);
        o->maximum(1e+99);
        o->value(-10);
        o->textsize(10);
      }
      { Fl_Value_Input* o = Zmax = new Fl_Value_Input(150, 80, 45, 20, gettext("Z+"));
        o->tooltip(gettext("Z-max (3-d)"));
        o->labelsize(10);
        o->minimum(-1e+99);
        o->maximum(1e+99);
        o->value(10);
        o->textsize(10);
      }
      { Fl_Value_Input* o = Tmin = new Fl_Value_Input(50, 105, 45, 20, gettext("t-"));
        o->tooltip(gettext("T-min (parametric computation)"));
        o->labelsize(10);
        o->minimum(-1e+99);
        o->maximum(1e+99);
        o->value(-10);
        o->textsize(10);
      }
      { Fl_Value_Input* o = Tmax = new Fl_Value_Input(150, 105, 45, 20, gettext("t+"));
        o->tooltip(gettext("T-max (parametric computation)"));
        o->labelsize(10);
        o->minimum(-1e+99);
        o->maximum(1e+99);
        o->value(-10);
        o->textsize(10);
      }
      { Fl_Value_Input* o = Window_xmin = new Fl_Value_Input(50, 130, 45, 20, gettext("WX-"));
        o->tooltip(gettext("X-min for visualization"));
        o->labelsize(10);
        o->minimum(-1e+99);
        o->maximum(1e+99);
        o->value(-6.5);
        o->textsize(10);
      }
      { Fl_Value_Input* o = Window_xmax = new Fl_Value_Input(150, 130, 45, 20, gettext("WX+"));
        o->tooltip(gettext("X-max for visualization"));
        o->labelsize(10);
        o->minimum(-1e+99);
        o->maximum(1e+99);
        o->value(6.5);
        o->textsize(10);
      }
      { Fl_Value_Input* o = Window_ymin = new Fl_Value_Input(50, 155, 45, 20, gettext("WY-"));
        o->tooltip(gettext("Y-min for visualization (in fullscreen mode)"));
        o->labelsize(10);
        o->minimum(-1e+99);
        o->maximum(1e+99);
        o->value(-3.1);
        o->textsize(10);
      }
      { Fl_Value_Input* o = Window_ymax = new Fl_Value_Input(150, 155, 45, 20, gettext("WY+"));
        o->tooltip(gettext("Y-max for visualization"));
        o->labelsize(10);
        o->minimum(-1e+99);
        o->maximum(1e+99);
        o->value(3.1);
        o->textsize(10);
      }
      { Fl_Value_Input* o = Rot_x = new Fl_Value_Input(50, 180, 45, 20, gettext("x_rot"));
        o->tooltip(gettext("(3-d) Change x rotation angle"));
        o->labelsize(10);
        o->maximum(180);
        o->value(60);
        o->textsize(10);
        o->when(FL_WHEN_ENTER_KEY);
      }
      { Fl_Value_Input* o = Rot_z = new Fl_Value_Input(50, 205, 45, 20, gettext("z_rot"));
        o->tooltip(gettext("(3-d) Change z-rotation angle"));
        o->labelsize(10);
        o->maximum(360);
        o->value(30);
        o->textsize(10);
        o->when(FL_WHEN_ENTER_KEY);
      }
      { Fl_Button* o = Rot_x_plus = new Fl_Button(165, 180, 25, 20, gettext("+"));
        o->tooltip(gettext("Increase x rotation angle"));
        o->labelsize(10);
        o->callback((Fl_Callback*)cb_Rot_x_plus);
      }
      { Fl_Button* o = Rot_x_minus = new Fl_Button(125, 180, 25, 20, gettext("-"));
        o->tooltip(gettext("(3-d) Decrease x rotation angle"));
        o->labelsize(10);
        o->callback((Fl_Callback*)cb_Rot_x_minus);
      }
      { Fl_Button* o = Rot_z_plus = new Fl_Button(165, 205, 25, 20, gettext("+"));
        o->tooltip(gettext("(3-d) Increase z rotation angle"));
        o->labelsize(10);
        o->callback((Fl_Callback*)cb_Rot_z_plus);
      }
      { Fl_Button* o = Rot_z_minus = new Fl_Button(125, 205, 25, 20, gettext("-"));
        o->tooltip(gettext("(3-d) Decrease z rotation angle"));
        o->labelsize(10);
        o->callback((Fl_Callback*)cb_Rot_z_minus);
      }
      { Fl_Value_Input* o = X_scale = new Fl_Value_Input(50, 230, 45, 20, gettext("x_scale"));
        o->labelsize(10);
        o->minimum(1e-99);
        o->maximum(1e+99);
        o->value(1);
        o->textsize(10);
        o->when(FL_WHEN_ENTER_KEY);
      }
      { Fl_Value_Input* o = Z_scale = new Fl_Value_Input(50, 255, 45, 20, gettext("z_scale"));
        o->labelsize(10);
        o->minimum(1e-99);
        o->maximum(1e+99);
        o->value(1);
        o->textsize(10);
        o->when(FL_WHEN_ENTER_KEY);
      }
      { Fl_Value_Input* o = Class_min = new Fl_Value_Input(145, 230, 45, 20, gettext("class_min"));
        o->tooltip(gettext("Minimum for classes (for e.g. histogram...)"));
        o->labelsize(10);
        o->minimum(1e-99);
        o->maximum(1e+99);
        o->value(1);
        o->textsize(10);
      }
      { Fl_Value_Input* o = Class_size = new Fl_Value_Input(145, 255, 45, 20, gettext("class_size"));
        o->tooltip(gettext("Size of a class (e.g. for histogram...)"));
        o->labelsize(10);
        o->minimum(1e-99);
        o->maximum(1e+99);
        o->value(1);
        o->textsize(10);
      }
      { Fl_Button* o = Adjust_window = new Fl_Button(205, 30, 40, 45, gettext("->W"));
        o->tooltip(gettext("Copy computation parameters to visualization"));
        o->labelsize(10);
        o->callback((Fl_Callback*)cb_Adjust_window);
      }
      { Fl_Check_Button* o = Axes = new Fl_Check_Button(255, 130, 55, 20, gettext("axes"));
        o->tooltip(gettext("Display axes"));
        o->down_box(FL_DIAMOND_DOWN_BOX);
        o->value(1);
        o->selection_color((Fl_Color)2);
        o->labelsize(10);
        o->callback((Fl_Callback*)cb_Axes);
      }
      { Fl_Check_Button* o = Autoscale = new Fl_Check_Button(210, 80, 100, 20, gettext("autoscale 3-d"));
        o->tooltip(gettext("(3-d) autoscale"));
        o->down_box(FL_DIAMOND_DOWN_BOX);
        o->value(1);
        o->selection_color((Fl_Color)2);
        o->labelsize(10);
      }
      { Fl_Check_Button* o = Orthonormal = new Fl_Check_Button(255, 155, 55, 20, gettext("orthon."));
        o->tooltip(gettext("Adjust geo window orthonormally"));
        o->down_box(FL_DIAMOND_DOWN_BOX);
        o->value(1);
        o->selection_color((Fl_Color)2);
        o->labelsize(10);
        o->callback((Fl_Callback*)cb_Orthonormal);
      }
      { Fl_Button* o = Adjust_gnuplot = new Fl_Button(205, 130, 40, 45, gettext("->XY"));
        o->tooltip(gettext("Copy visualization parameters to computation"));
        o->labelsize(10);
        o->callback((Fl_Callback*)cb_Adjust_gnuplot);
      }
      { Fl_Value_Input* o = X_tick = new Fl_Value_Input(275, 30, 35, 20, gettext("TX"));
        o->tooltip(gettext("Tick range on X axis"));
        o->labelsize(10);
        o->maximum(1e+99);
        o->value(1);
        o->textsize(10);
        o->callback((Fl_Callback*)cb_X_tick);
      }
      { Fl_Value_Input* o = Y_tick = new Fl_Value_Input(275, 55, 35, 20, gettext("TY"));
        o->tooltip(gettext("Tick range on Y axis"));
        o->labelsize(10);
        o->maximum(1e+99);
        o->value(1);
        o->textsize(10);
        o->callback((Fl_Callback*)cb_Y_tick);
      }
      { Fl_Check_Button* o = Xcas_turtle = new Fl_Check_Button(210, 105, 100, 20, gettext("Tortue"));
        o->tooltip(gettext("Show or hide the turtle"));
        o->down_box(FL_DIAMOND_DOWN_BOX);
        o->selection_color((Fl_Color)2);
        o->labelsize(10);
        o->callback((Fl_Callback*)cb_Xcas_turtle);
      }
      { Fl_Check_Button* o = Xcas_hidden_3d = new Fl_Check_Button(205, 180, 105, 20, gettext("hidden3d"));
        o->tooltip(gettext("Transparent or opaque 3-d surfaces"));
        o->down_box(FL_DIAMOND_DOWN_BOX);
        o->selection_color((Fl_Color)2);
        o->labelsize(10);
        o->callback((Fl_Callback*)cb_Xcas_hidden_3d);
      }
      { Fl_Check_Button* o = Xcas_pm3d = new Fl_Check_Button(205, 205, 110, 20, gettext("pm3d"));
        o->tooltip(gettext("Colored 3-d surfaces"));
        o->down_box(FL_DIAMOND_DOWN_BOX);
        o->selection_color((Fl_Color)2);
        o->labelsize(10);
        o->callback((Fl_Callback*)cb_Xcas_pm3d);
      }
      { Fl_Check_Button* o = Win9x = new Fl_Check_Button(285, 205, 30, 20, gettext("3d pipes"));
        o->tooltip(gettext("Talk with gnuplot with pipes (windows NT and XP)"));
        o->down_box(FL_DIAMOND_DOWN_BOX);
        o->selection_color((Fl_Color)2);
        o->labelsize(10);
        o->callback((Fl_Callback*)cb_Win9x);
        o->hide();
      }
      { Fl_Return_Button* o = Plot_setup_OK = new Fl_Return_Button(215, 225, 90, 25, gettext("OK"));
        o->labelsize(10);
        o->callback((Fl_Callback*)cb_Plot_setup_OK);
      }
      { Fl_Button* o = Plot_setup_cancel = new Fl_Button(215, 255, 90, 25, gettext("Cancel"));
        o->labelsize(10);
        o->callback((Fl_Callback*)cb_Plot_setup_cancel);
      }
      o->end();
    }
    { Fl_Group* o = Cas_setup_w = new Fl_Group(0, 20, 320, 270);
      o->box(FL_UP_BOX);
      o->color(FL_BACKGROUND2_COLOR);
      o->selection_color(FL_BACKGROUND2_COLOR);
      o->hide();
      { Fl_Menu_Button* o = Float_style = new Fl_Menu_Button(15, 30, 85, 25, gettext("Float format"));
        o->labelsize(10);
        o->textsize(10);
        o->menu(menu_Float_style);
      }
      { Fl_Output* o = Float_style_output = new Fl_Output(15, 55, 85, 25);
        o->tooltip(gettext("Current float printing format"));
        o->labeltype(FL_NO_LABEL);
        o->textsize(10);
      }
      { Fl_Counter* o = Digits = new Fl_Counter(15, 90, 80, 25, gettext("Digits"));
        o->tooltip(gettext("Number of digits"));
        o->labelsize(10);
        o->minimum(0);
        o->maximum(1000);
        o->step(1);
        o->value(6);
        o->textsize(10);
        o->callback((Fl_Callback*)cb_Digits);
      }
      { Fl_Value_Input* o = Epsilon = new Fl_Value_Input(50, 145, 50, 25, gettext("epsilon"));
        o->tooltip(gettext("Number with absolute value less than epsilon can be coerced to 0"));
        o->labelsize(10);
        o->minimum(1e-12);
        o->maximum(0.01);
        o->value(1e-10);
        o->textsize(10);
      }
      { Fl_Check_Button* o = Approx_mode = new Fl_Check_Button(15, 175, 85, 25, gettext("approx"));
        o->tooltip(gettext("Approx or exact mode"));
        o->down_box(FL_DIAMOND_DOWN_BOX);
        o->selection_color((Fl_Color)1);
        o->labelsize(10);
        o->callback((Fl_Callback*)cb_Approx_mode);
      }
      { Fl_Check_Button* o = Angle_radian = new Fl_Check_Button(15, 205, 90, 25, gettext("radian"));
        o->tooltip(gettext("Radian or degree angle mode"));
        o->down_box(FL_DIAMOND_DOWN_BOX);
        o->selection_color((Fl_Color)1);
        o->labelsize(10);
        o->callback((Fl_Callback*)cb_Angle_radian);
      }
      { Fl_Check_Button* o = Increasing_power = new Fl_Check_Button(15, 235, 90, 25, gettext("increasing power"));
        o->tooltip(gettext("Show polynomials in increasin or decreasing order"));
        o->down_box(FL_DIAMOND_DOWN_BOX);
        o->selection_color((Fl_Color)1);
        o->labelsize(10);
        o->callback((Fl_Callback*)cb_Increasing_power);
      }
      { Fl_Menu_Button* o = Prg_style = new Fl_Menu_Button(120, 30, 85, 25, gettext("Prog style"));
        o->labelsize(10);
        o->textsize(10);
        o->menu(menu_Prg_style);
      }
      { Fl_Output* o = Style = new Fl_Output(120, 55, 85, 25);
        o->tooltip(gettext("Current programmation syntax style"));
        o->labeltype(FL_NO_LABEL);
        o->textsize(10);
      }
      { Fl_Check_Button* o = Complex_mode = new Fl_Check_Button(115, 175, 85, 25, gettext("Complex"));
        o->tooltip(gettext("Complex mode (e.g. for factorization)"));
        o->down_box(FL_DIAMOND_DOWN_BOX);
        o->selection_color((Fl_Color)1);
        o->labelsize(10);
        o->callback((Fl_Callback*)cb_Complex_mode);
      }
      { Fl_Check_Button* o = Complex_variables = new Fl_Check_Button(115, 205, 85, 25, gettext("Cmplx_var"));
        o->tooltip(gettext("Variables are complex or real"));
        o->down_box(FL_DIAMOND_DOWN_BOX);
        o->selection_color((Fl_Color)1);
        o->labelsize(10);
        o->callback((Fl_Callback*)cb_Complex_variables);
      }
      { Fl_Check_Button* o = Save_var = new Fl_Check_Button(115, 235, 85, 25, gettext("Save_var"));
        o->tooltip(gettext("Save variables to files or not"));
        o->down_box(FL_DIAMOND_DOWN_BOX);
        o->selection_color(FL_FOREGROUND_COLOR);
        o->labelsize(10);
        o->callback((Fl_Callback*)cb_Save_var);
      }
      { Fl_Return_Button* o = Cas_setup_OK = new Fl_Return_Button(225, 200, 80, 25, gettext("OK"));
        o->labelsize(10);
        o->callback((Fl_Callback*)cb_Cas_setup_OK);
      }
      { Fl_Button* o = Cancel_cas_setup = new Fl_Button(225, 235, 80, 25, gettext("Cancel"));
        o->shortcut(0xff1b);
        o->labelsize(10);
        o->callback((Fl_Callback*)cb_Cancel_cas_setup);
      }
      { Fl_Value_Input* o = Threads = new Fl_Value_Input(255, 90, 50, 25, gettext("threads"));
        o->tooltip(gettext("Maximal number of threads in parallel"));
        o->labelsize(10);
        o->maximum(10);
        o->step(1);
        o->value(1);
        o->textsize(10);
        o->deactivate();
      }
      { Fl_Check_Button* o = Xcas_sqrt = new Fl_Check_Button(115, 145, 85, 25, gettext("Sqrt"));
        o->tooltip(gettext("Factor 2nd order poly using sqrt"));
        o->down_box(FL_DIAMOND_DOWN_BOX);
        o->selection_color((Fl_Color)1);
        o->labelsize(10);
        o->callback((Fl_Callback*)cb_Xcas_sqrt);
      }
      { Fl_Check_Button* o = Xcas_all_trig_sol = new Fl_Check_Button(115, 120, 85, 25, gettext("All_trig_sol"));
        o->tooltip(gettext("Solver: principal solution vs all solutions"));
        o->down_box(FL_DIAMOND_DOWN_BOX);
        o->selection_color((Fl_Color)1);
        o->labelsize(10);
        o->callback((Fl_Callback*)cb_Xcas_all_trig_sol);
      }
      o->end();
    }
    { Fl_Group* o = General_setup_w = new Fl_Group(0, 20, 320, 270);
      o->box(FL_UP_BOX);
      o->color(FL_BACKGROUND2_COLOR);
      o->selection_color(FL_BACKGROUND2_COLOR);
      o->hide();
      { Fl_Group* o = History_config = new Fl_Group(10, 25, 95, 165);
        { Fl_Output* o = History_font_output = new Fl_Output(10, 45, 95, 25, gettext("Size"));
          o->labeltype(FL_NO_LABEL);
          o->labelsize(10);
          o->textsize(10);
        }
        { Fl_Menu_Button* o = History_font = new Fl_Menu_Button(10, 25, 95, 20, gettext("History font"));
          o->tooltip(gettext("Font size for history"));
          o->labelsize(10);
          o->textsize(10);
          o->when(3);
          o->menu(menu_History_font);
        }
        { Fl_Check_Button* o = Center_history = new Fl_Check_Button(10, 70, 95, 20, gettext("Center"));
          o->tooltip(gettext("History answer are centered or right justified"));
          o->down_box(FL_DIAMOND_DOWN_BOX);
          o->color((Fl_Color)51);
          o->selection_color((Fl_Color)1);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Center_history);
        }
        { Fl_Check_Button* o = Pretty_input = new Fl_Check_Button(10, 90, 95, 20, gettext("Pretty in"));
          o->tooltip(gettext("Pretty print or text in history questions"));
          o->down_box(FL_DIAMOND_DOWN_BOX);
          o->value(1);
          o->color((Fl_Color)51);
          o->selection_color((Fl_Color)1);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Pretty_input);
        }
        { Fl_Check_Button* o = Pretty_print = new Fl_Check_Button(10, 110, 95, 20, gettext("Pretty out"));
          o->tooltip(gettext("Pretty print or text output in history"));
          o->down_box(FL_DIAMOND_DOWN_BOX);
          o->value(1);
          o->color((Fl_Color)51);
          o->selection_color((Fl_Color)1);
          o->labelsize(10);
        }
        { Fl_Check_Button* o = Recompute_history = new Fl_Check_Button(10, 130, 95, 20, gettext("Recompute hist"));
          o->tooltip(gettext("Hitting enter in history recomputes all from current level"));
          o->down_box(FL_DIAMOND_DOWN_BOX);
          o->value(1);
          o->color((Fl_Color)51);
          o->selection_color((Fl_Color)1);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Recompute_history);
        }
        { Fl_Check_Button* o = RPN = new Fl_Check_Button(10, 170, 95, 20, gettext("RPN mode"));
          o->tooltip(gettext("RPN or algebraic mode"));
          o->down_box(FL_DIAMOND_DOWN_BOX);
          o->color(FL_LIGHT2);
          o->labelsize(10);
        }
        { Fl_Check_Button* o = Eqw_history_freezed = new Fl_Check_Button(10, 150, 95, 20, gettext("History freezed"));
          o->tooltip(gettext("Allow edit directly in history"));
          o->down_box(FL_DIAMOND_DOWN_BOX);
          o->color((Fl_Color)51);
          o->selection_color((Fl_Color)1);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Eqw_history_freezed);
        }
        o->end();
      }
      { Fl_Menu_Button* o = Widget_font = new Fl_Menu_Button(10, 190, 90, 20, gettext("Widget font"));
        o->tooltip(gettext("Font size for all widgets"));
        o->labelsize(10);
        o->textsize(10);
        o->when(3);
        o->menu(menu_Widget_font);
      }
      { Fl_Output* o = Widget_font_output = new Fl_Output(10, 210, 90, 25, gettext("Size"));
        o->labeltype(FL_NO_LABEL);
        o->labelsize(10);
        o->textsize(10);
      }
      { Fl_Group* o = Matrix_config = new Fl_Group(115, 25, 95, 160);
        { Fl_Menu_Button* o = Select_matrix_type = new Fl_Menu_Button(115, 25, 95, 20, gettext("Matrix type"));
          o->labelsize(10);
          o->textsize(10);
          o->when(3);
          o->menu(menu_Select_matrix_type);
        }
        { Fl_Output* o = Select_matrix_type_output = new Fl_Output(115, 45, 95, 25, gettext("Size"));
          o->labeltype(FL_NO_LABEL);
          o->labelsize(10);
          o->textsize(10);
        }
        { Fl_Input* o = Spread_rows = new Fl_Input(145, 75, 65, 25, gettext("Rows"));
          o->tooltip(gettext("Number of rows in the spreadsheet"));
          o->labelsize(10);
          o->textsize(10);
        }
        { Fl_Input* o = Spread_cols = new Fl_Input(145, 100, 65, 25, gettext("Cols"));
          o->tooltip(gettext("Number of columns in the spreadsheet"));
          o->labelsize(10);
          o->textsize(10);
        }
        { Fl_Check_Button* o = Spreadsheet_editor = new Fl_Check_Button(115, 125, 95, 20, gettext("Spread."));
          o->tooltip(gettext("Spreadsheet or matrix mode in mtrw"));
          o->down_box(FL_DIAMOND_DOWN_BOX);
          o->color((Fl_Color)51);
          o->selection_color((Fl_Color)1);
          o->labelsize(10);
        }
        { Fl_Check_Button* o = Matrix_fill_cells = new Fl_Check_Button(115, 145, 95, 20, gettext("Matrix fill cells"));
          o->tooltip(gettext("Matrix entered in commandline will fill many cells or only 1 cell in mtrw"));
          o->down_box(FL_DIAMOND_DOWN_BOX);
          o->value(1);
          o->color(FL_FOREGROUND_COLOR);
          o->selection_color((Fl_Color)1);
          o->labelsize(10);
        }
        { Fl_Check_Button* o = Spreadsheet_recompute = new Fl_Check_Button(115, 165, 95, 20, gettext("Recompute"));
          o->tooltip(gettext("Automatically recompute the spreadsheet or not"));
          o->down_box(FL_DIAMOND_DOWN_BOX);
          o->value(1);
          o->color((Fl_Color)51);
          o->selection_color((Fl_Color)1);
          o->labelsize(10);
        }
        o->end();
      }
      { Fl_Group* o = Help_config = new Fl_Group(115, 190, 90, 95);
        { Fl_Menu_Button* o = Help_font = new Fl_Menu_Button(115, 190, 90, 20, gettext("Help font"));
          o->tooltip(gettext("Font size for help"));
          o->labelsize(10);
          o->textsize(10);
          o->when(3);
          o->menu(menu_Help_font);
        }
        { Fl_Output* o = Help_font_output = new Fl_Output(115, 210, 90, 25, gettext("Size"));
          o->labeltype(FL_NO_LABEL);
          o->labelsize(10);
          o->textsize(10);
        }
        { Fl_Check_Button* o = Chooser_Check_Button = new Fl_Check_Button(115, 240, 90, 20, gettext("Auto help"));
          o->tooltip(gettext("Automatically display help"));
          o->down_box(FL_DIAMOND_DOWN_BOX);
          o->color((Fl_Color)51);
          o->selection_color((Fl_Color)1);
          o->labelsize(10);
        }
        { Fl_Input* o = Help_font_browser = new Fl_Input(115, 260, 90, 25, gettext("Browser"));
          o->labelsize(10);
          o->textsize(10);
          o->callback((Fl_Callback*)cb_Help_font_browser);
        }
        o->end();
      }
      { Fl_Group* o = Print_config = new Fl_Group(220, 25, 95, 95);
        { Fl_Menu_Button* o = Page_format = new Fl_Menu_Button(220, 25, 95, 20, gettext("Print format"));
          o->tooltip(gettext("Printer page format"));
          o->labelsize(10);
          o->textsize(10);
          o->when(3);
          o->menu(menu_Page_format);
        }
        { Fl_Output* o = Page_format_output = new Fl_Output(220, 45, 95, 25, gettext("Format"));
          o->labeltype(FL_NO_LABEL);
          o->labelsize(10);
          o->textsize(10);
        }
        { Fl_Check_Button* o = Printer_landscape = new Fl_Check_Button(220, 70, 90, 20, gettext("Landscape"));
          o->tooltip(gettext("Landscape or Portrait"));
          o->down_box(FL_DIAMOND_DOWN_BOX);
          o->color((Fl_Color)51);
          o->selection_color((Fl_Color)1);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Printer_landscape);
        }
        { Fl_Input* o = Xcas_ps_preview = new Fl_Input(245, 95, 65, 25, gettext("Prev"));
          o->tooltip(gettext("Postscript previewer program (put no for no preview)"));
          o->labelsize(10);
          o->textsize(10);
          o->callback((Fl_Callback*)cb_Xcas_ps_preview);
        }
        o->end();
      }
      { Fl_Check_Button* o = Bandeau = new Fl_Check_Button(225, 115, 85, 20, gettext("Bandeau"));
        o->tooltip(gettext("Show a calculator-like button bar"));
        o->down_box(FL_DIAMOND_DOWN_BOX);
        o->color((Fl_Color)51);
        o->selection_color((Fl_Color)1);
        o->labelsize(10);
        o->callback((Fl_Callback*)cb_Bandeau);
      }
      { Fl_Check_Button* o = hide_help = new Fl_Check_Button(225, 135, 85, 20, gettext("Hide keys"));
        o->tooltip(gettext("Fullscreen mode or not (hide keyboard)"));
        o->down_box(FL_DIAMOND_DOWN_BOX);
        o->color((Fl_Color)51);
        o->selection_color((Fl_Color)1);
        o->labelsize(10);
      }
      { Fl_Counter* o = Split_windows = new Fl_Counter(225, 160, 80, 25, gettext("Windows"));
        o->tooltip(gettext("Number of windows displayed"));
        o->labelsize(10);
        o->minimum(1);
        o->maximum(3);
        o->step(1);
        o->value(1);
        o->textsize(10);
      }
      { Fl_Check_Button* o = Horizontal_split = new Fl_Check_Button(225, 195, 80, 25, gettext("Horizontal"));
        o->tooltip(gettext("How to split the screen if more than 1 window displayed"));
        o->down_box(FL_DIAMOND_DOWN_BOX);
        o->color((Fl_Color)51);
        o->selection_color((Fl_Color)1);
        o->labelsize(10);
        o->callback((Fl_Callback*)cb_Horizontal_split);
      }
      { Fl_Return_Button* o = General_setup_OK = new Fl_Return_Button(225, 230, 80, 25, gettext("OK"));
        o->labelsize(10);
        o->callback((Fl_Callback*)cb_General_setup_OK);
      }
      { Fl_Button* o = Cancel_general_setup = new Fl_Button(225, 260, 80, 25, gettext("Cancel"));
        o->shortcut(0xff1b);
        o->labelsize(10);
        o->callback((Fl_Callback*)cb_Cancel_general_setup);
      }
      { Fl_Menu_Button* o = Xcas_user_level_choice = new Fl_Menu_Button(10, 240, 60, 20, gettext("Level"));
        o->tooltip(gettext("Font size for all widgets"));
        o->labelsize(10);
        o->textsize(10);
        o->when(3);
        o->menu(menu_Xcas_user_level_choice);
      }
      { Fl_Output* o = Xcas_level_output = new Fl_Output(10, 260, 60, 25);
        o->labeltype(FL_NO_LABEL);
        o->labelsize(10);
        o->textsize(10);
      }
      o->end();
    }
    o->end();
    o->resizable(o);
  }
  child_id=make_child();
#ifdef WIN32
// Send_kill_to_child->hide();
Help_font_browser->hide();
// Win9x->show();
Rot_x->hide();
Rot_x_plus->hide();
Rot_x_minus->hide();
Rot_z->hide();
Rot_z_plus->hide();
Rot_z_minus->hide();
FILE * stream = fopen("gnuplot.txt","w");
fputc(' ',stream);
fflush(stream);
fclose(stream);
Rot_x_plus->hide();
Rot_z_plus->hide();
Rot_x_minus->hide();
Rot_z_minus->hide();
#endif //
#ifdef IPAQ
horizontal_split=true;
xcas_output_fontsize=10;
Help_text_fontsize=10;
// input->resize(input->x(),input->y(),input->w(),input->h()+6);
History_button->resize(History_button->x(),History_button->y()+3,History_button->w(),History_button->h()-1);
// bandeau->resize(bandeau->x(),bandeau->y()+6,bandeau->w(),bandeau->h()-6);
input->textsize(12);
//Help_Chooser_Help->textsize(10);
Source_browser->textsize(10);
Debug_messages->textsize(10);
bandeau_fill->labelsize(10);
F1->labelsize(8);
F2->labelsize(8);
F3->labelsize(8);
F4->labelsize(8);
F5->labelsize(8);
F6->labelsize(8);
PREV->labelsize(10);
Help_online->labelsize(10);
Show_kbd->labelsize(10);
Show_io->labelsize(10);
NXT->labelsize(10);
VAR->labelsize(8);
CST->labelsize(8);
Home_button->labelsize(8);
Full_message->labelsize(10);
Show_history->labelsize(10);
Plot_view->labelsize(10);
Geo_save->labelsize(8);
Geo_zoomin->labelsize(8);
Geo_zoomout->labelsize(8);
Geo_go_left->labelsize(8);
Geo_go_right->labelsize(8);
Geo_go_up->labelsize(8);
Geo_go_down->labelsize(8);
Geo_axes->labelsize(8);
Geo_show_io->labelsize(8);
Geo_erase_button->labelsize(8);
Prog_button->labelsize(10);
Eqw_button->labelsize(10);
Eqw_save->labelsize(8);
Eqw_exec->labelsize(8);
Eqw_ok->labelsize(8);
Eqw_undo->labelsize(8);
Eqw_copy->labelsize(8);
MTRW->labelsize(10);
Spread_button_save->labelsize(8);
Spread_copy_cell->labelsize(8);
Spread_recompute_button->labelsize(8);
Spread_insert_row->labelsize(8);
Spread_insert_column->labelsize(8);
Prg_paste->labelsize(8);
Editor_search->labelsize(10);
Editor_next->labelsize(10);
Editor_replace->labelsize(10);
Xcas_editor_filename->textsize(10);
change_menu_fontsize(Spread_stats_1d,3,10);
//Spread_copy_down_button->labelsize(8);
Spread_stats->labelsize(8);
Spread_insert_column->labelsize(10);
Spread_insert_row->labelsize(10);
Hist2eqw_button->labelsize(8);
TeX->labelsize(8);
UNDO->labelsize(8);
Show_io->labelsize(8);
Help_Chooser_Input_Array0->labelsize(10);
Help_Chooser_Input_Array1->labelsize(10);
Help_Chooser_Input_Array2->labelsize(10);
Help_Chooser_Input_Array3->labelsize(10);
Help_Chooser_Input_Array4->labelsize(10);
Help_Chooser_Input_Array5->labelsize(10);
Geo_setup_button->labelsize(10);
Cas_setup_button->labelsize(10);
Gen_setup->labelsize(10);
Xcas_mode->textsize(10);
Asinus_button->labelsize(8);
Acosinus_button->labelsize(8);
Atangeant_button->labelsize(8);
Ln10_button->labelsize(8);
Dix_puissance->labelsize(8);
Racine_carree->label("sqrt");
Racine_carree->labelsize(8);
Racine_carree->labelfont(FL_HELVETICA);
#else
xcas_output_fontsize=14;
Help_text_fontsize=12;
#endif //
xcas_output->textsize(xcas_output_fontsize);
Help_text->textsize(Help_text_fontsize);
Help_Chooser_Index->textsize(Help_text_fontsize);
#ifdef HAVE_LIBFLVW // insert spreadsheet
  spread_ptr = new Flv_Table_Gen( xcas_output->x(),xcas_output->y(),Spread_group->w(),xcas_output->h(), vecteur(50,vecteur(10,zero)),"Spreadsheet");
  spread_ptr->is_spreadsheet=true;
  spread_editor = new Flve_Input( 0, 0, 0,0);
  // spread_ptr->edit_when(FLV_EDIT_AUTOMATIC);
  // spread_ptr->global_style.editor(spread_editor);
  // spread_editor->textsize(12);
  spread_ptr->select_locked(false);
#ifdef IPAQ
  spread_ptr->global_style.font_size(10);
#else //
  spread_ptr->global_style.font_size(14);
#endif //
  spread_ptr->global_style.x_margin(5);
  spread_ptr->global_style.locked(false);

#ifdef IPAQ
  spread_ptr->col_width(20,-1);
#else // IPAQ
  spread_ptr->col_width(40,-1);
#endif // IPAQ

  spread_ptr->feature(FLVF_HEADERS|FLVF_DIVIDERS|FLVF_MULTI_SELECT);
  
  spread_ptr->global_style.resizable(true);
#ifdef IPAQ
  spread_ptr->global_style.width(40);
  spread_ptr->global_style.height(14);
#else // IPAQ
  spread_ptr->global_style.width(60);
  spread_ptr->global_style.height(14);
#endif // IPAQ
  spread_ptr->row_style[-1].align(FL_ALIGN_CLIP);
  
  spread_ptr->col_style[-1].align(FL_ALIGN_CLIP);
  save_current_xcas_matrix(matrixfilename);
  Spread_group->add(spread_ptr);
  // Spread_group->add(spread_editor);
  Spread_group->resizable(spread_ptr);
  //spread_ptr->changed=true;
#endif // FLVW
// X-windows
//Picture->resize(Geo_group->x(),Geo_group->y(),Geo_group->w(),Geo_group->h()-Geo_show_io->h());
// Geo_group->add(Picture); // add PICT to the Xcas window
// Xcas->add(Picture);
// Geo_group->resizable(Picture);
//Geo_group->resize(Eqw_History_group->x(),Eqw_History_group->y(),Eqw_History_group->w(),Eqw_History_group->h());
#ifdef IPAQ
 Program_editor->textsize(10);
 Bandeau->value(1);
#endif //
Programme->resizable(Program_editor);
Eqw_eqw->data=Eqw_nullstring(Eqw_eqw->attr);
// Set here callbacks
Eqw_eqw->cb_escape=Eqw_eqw_escape;
Eqw_eqw->cb_enter=Eqw_eqw_enter;
Eqw_eqw->cb_select=Eqw_eqw_select; 
int ex=Eqw_History_group->x(),ey=Eqw_History_group->y(),edx=Eqw_History_group->w(),edy=Eqw_History_group->h();
Eqw_eqw->resize(ex,ey,edx-12,edy-12);
Eqw_eqw->vscroll->resize(ex+edx-11,ey,11,edy-12);
Eqw_eqw->hscroll->resize(ex,ey+edy-11,edx-12,11);
// change hist color in next line and in Eqw_history_set_color
Eqw_history->attr.text_color=FL_BLACK; 
Eqw_history->resize(ex,ey,edx-12,edy-12);
Eqw_history->vscroll->resize(ex+edx-11,ey,11,edy-12);
Eqw_history->hscroll->resize(ex,ey+edy-11,edx-12,11);
Eqw_history->set_data(Eqw_nullhistlevel());
Eqw_history->cb_escape=Eqw_history_escape; // FIXME
Eqw_history->cb_enter=Eqw_history_enter; // FIXME
Eqw_history->cb_backspace=Eqw_history_backspace; // FIXME
Eqw_history->allow_immediate_eval=false;
Eqw_History_group->add(Eqw_history);
Eqw_History_group->resizable(Eqw_history);
input->type(4);
#ifdef __APPLE__
input->color(FL_WHITE);
#endif
_erase(0);
// user_screen=false;
// std::swap(eqw_history.data,save_eqw_data);
// Picture->plot_instructions_ptr=&plot_instructions;
// on-line Help load the help index and create the see also/example lists
for (int k=0;k<aide_v.size();++k){
   // cout << k << " " << aide_v[k].cmd_name.c_str() << endl;
   Help_Chooser_Index->add(aide_v[k].cmd_name.c_str());
   completion_tab.push_back(aide_v[k].cmd_name);
}
  int ww=Help_Chooser->w(),wi=Help_Chooser_Index->w(),wh=Help_Chooser_Index->h();
  help_examples=new Fl_Hold_Browser(wi,Help_Chooser_Index->y(),(ww-wi)/2,wh,0);
  help_examples->labelsize(10);
  help_examples->textcolor(72);
  help_examples->textsize(Help_text_fontsize);
  help_examples->callback((Fl_Callback*)cb_help_examples);
  Help_index_group->add(help_examples);
  help_related=new Fl_Hold_Browser((ww+wi)/2,Help_Chooser_Index->y(),(ww-wi)/2,wh,0);
  help_related->labelsize(10);
  help_related->textsize(Help_text_fontsize);
  help_related->textcolor(72);
  help_related->callback((Fl_Callback*)cb_help_related);
  Help_index_group->add(help_related);
  // MEM MENU
  gen mem_menu_tab[]={at_sto,at_RCL,at_purge,zero};
  mem_menu=tab2vecteur(mem_menu_tab);
  vecteur mem_menu_name(makevecteur(string2gen("mem",false),mem_menu));
  // DEBUG MENU
  gen debug_menu_tab[]={at_debug,at_sst,at_sst_in,at_cont,at_kill,at_breakpoint,at_rmbreakpoint,at_watch,at_rmwatch,zero};
  debug_menu=tab2vecteur(debug_menu_tab);
  vecteur debug_menu_name(makevecteur(string2gen("debug",false),debug_menu));
  // BOOLEAN MENU
  gen boolean_menu_tab[]={at_and,at_ou,at_not,at_inferieur_strict,at_inferieur_egal,at_superieur_strict,at_superieur_egal,at_same,zero};
  boolean_menu=tab2vecteur(boolean_menu_tab);
  vecteur boolean_menu_name(makevecteur(string2gen("boolean",false),boolean_menu));
  // CONTROL MENU
  gen control_menu_tab[]={at_ifte,at_case,at_for,at_return,at_local,zero};
  control_menu=tab2vecteur(control_menu_tab);
  vecteur control_menu_name(makevecteur(string2gen("control",false),control_menu));
  // TOOLS MENU
  gen tools_menu_tab[]={mem_menu_name,debug_menu_name,boolean_menu_name,control_menu_name,zero};
  tools_menu=tab2vecteur(tools_menu_tab);
  gen tools_menu_name=makevecteur(string2gen("Tools",false),tools_menu);
  Fl_Menu_Item * menu_xcas_tmp=(Fl_Menu_Item *) menu_xcas;
  nextfl_menu(menu_xcas_tmp);
  nextfl_menu(menu_xcas_tmp);

  lycee_menu=fl_menu2rpn_menu(menu_xcas_tmp);
  gen lycee_menu_name=makevecteur(string2gen("Lycee",false),lycee_menu);
  ++menu_xcas_tmp;

  maths_menu=fl_menu2rpn_menu(menu_xcas_tmp);
  gen maths_menu_name=makevecteur(string2gen("Maths",false),maths_menu);
  ++menu_xcas_tmp;

  geo_menu=fl_menu2rpn_menu(menu_xcas_tmp);
  gen geo_menu_name=makevecteur(string2gen("Geo",false),geo_menu);
  ++menu_xcas_tmp;

  phys_menu=fl_menu2rpn_menu(menu_xcas_tmp);
  gen phys_menu_name=makevecteur(string2gen("Phys",false),phys_menu);
  ++menu_xcas_tmp;

  alg_menu=fl_menu2rpn_menu(menu_xcas_tmp);
  gen alg_menu_name=makevecteur(string2gen("Alg",false),alg_menu);
  ++menu_xcas_tmp;

  cas_menu=fl_menu2rpn_menu(menu_xcas_tmp);
  gen cas_menu_name=makevecteur(string2gen("Calc",false),cas_menu);
  ++menu_xcas_tmp;

  prg_menu=fl_menu2rpn_menu(menu_xcas_tmp);
  gen prg_menu_name=makevecteur(string2gen("Prg",false),prg_menu);
  ++menu_xcas_tmp;
  // MTH MENU
  gen home_menu_tab[]={lycee_menu_name,maths_menu_name,geo_menu_name,phys_menu_name,alg_menu_name,cas_menu_name,prg_menu_name,tools_menu_name,zero};
  home_menu=tab2vecteur(home_menu_tab);
  rpn_menu=home_menu;
  show_rpn_menu(0);
  // parse argument
  int nargs=0;
  Fl::args(argc,argv,nargs);
  Xcas->show(argc,argv);
  Left_Xcas_resize();
  Eqw_eqw->data=Eqw_compute_size(zero,Eqw_eqw->attr,Eqw_eqw->w());
  Eqw_eqw->select();
  Eqw_eqw->setscroll();
  Eqw_history->set_data(Eqw_nullhistlevel());
  Eqw_history->setscroll();
  if (in_texmacs){
    cout << GIAC_DATA_BEGIN << "channel:prompt" << GIAC_DATA_END;
    cout << "quest(0)";
    cout << GIAC_DATA_END;
    fflush (stdout);
  }
  Xcas_editor_filename_value(progfilename);
#ifdef HAVE_LIBFLTK
// add here redefinition of interactive functions
__click.op=&fltk_input;
__input.op=&fltk_inputform;
__inputform.op=&fltk_inputform;
__interactive.op=&fltk_interactive;
__widget_size.op=&fltk_widget_size;
__keyboard.op=&fltk_keyboard;
__current_sheet.op=&fltk_current_sheet;
__Row.op=&fltk_Row;
__Col.op=&fltk_Col;
__xyztrange.op=&fltk_xyztrange;
fl_widget_delete_function=&fltk_fl_widget_delete_function;
fl_widget_archive_function=&fltk_fl_widget_archive_function;
fl_widget_unarchive_function=&fltk_fl_widget_unarchive_function;
fl_widget_texprint_function=&fltk_fl_widget_texprint_function;
fl_widget_updatepict_function=&fltk_fl_widget_updatepict_function;
giac::readqueue=&giac::plotfltk_readqueue;
#endif //
Xcas->label("xcas: session.ar");
read_env();
protected_read_config();
Select_matrix_type_output->value("Normal");
set_language(language);
html_help_init(argv[0]);
kill(child_id,SIGKILL); 
wait4(child_id,0,0,0);
  child_id=0;
  child_id=make_child();
  make_new_help("maple_mode");
  Eqw_history->set_data(Eqw_nullhistlevel());
  Eqw_eqw->set_data(0);
  Eqw_eqw->select();
  Eqw_eqw->redraw();
  a_propos();
  if (argc==2 && (string(argv[1])=="-v" || string(argv[1])=="--version" ) ){
    cout << VERSION << endl;
    return 0;
  }
  std::string autorecover_filename;
  if (has_autorecover_data("./",autorecover_filename)){
    fl_message("Executing and removing auto-recovery file, ignoring other arguments");
    run_archive(autorecover_filename.c_str());
    unlink(autorecover_filename.c_str());
  }
  else {
    if (nargs<argc){
      if (string(argv[nargs])=="--texmacs"){
        in_texmacs=true;
        ++nargs;
      }
      if (nargs<argc){
        cerr << "Executing file " << argv[nargs] << endl;
        run_file(argv[nargs]);
      }
    }
  }
  input->value("");
  Picture->turtleptr=&turtle_stack;
  update_Xcas_mode();
  if (pretty_input)
    eval_last_focus=input;
  else
    eval_last_focus=Eqw_history;
  if (Bandeau->value()){
    bandeau->show(); bandeau2->hide();
  }
  if (Eqw_history->visible()){
    history_redraw(0);
    history_saved=true;
    Fl::focus(eval_last_focus);
  }
  else
    Fl::focus(input);
  if (!pretty_input){
    Eqw_history->select();
    Eqw_history->select_down(0);
    Eqw_history->select_down(0);
    Eqw_history->select_down(0);
  }
  Eqw_history->redraw();
  fastcurveprint=true;
// #ifdef __APPLE__
  Fl::visible_focus(0);
// #endif
  return Fl::run();
}

void cb_help_examples(Fl_Browser * b, void * v) {
  int i=b->value();
  if (i && i<=cur_aide.examples.size()){
    if (Help_Chooser->visible() && cur_aide.examples[i-1][0]!=' ' ){
      gen g(cur_aide.examples[i-1]);
      if (g.type==_SYMB)
        g=g._SYMBptr->feuille;
      Help_Chooser_Array_fill(g.print().c_str());
    }
    else {
      input->value(cur_aide.examples[i-1].c_str());
      input->position(0,cur_aide.examples[i-1].size());
      Fl::focus(input);
    }
  }
}

void cb_help_related(Fl_Browser * b, void * v) {
  int i=b->value();
  if (i && i<=cur_aide.related.size())
   make_new_help(cur_aide.related[i-1].chaine.c_str());
}

int main(int argc, char **argv) {
  #ifdef HAVE_LIBGSL
    gsl_set_error_handler_off();
#endif
  secure_run=false;
  xcas_argc=argc; xcas_argv=argv;
  int errorcode=xcas_exec(argc,argv);
  Xcas_program_map[progfilename]=editor_string(Program_editor_value(),editor_changed,0,0);
  std::map<std::string,giac::editor_string>::iterator it=Xcas_program_map.begin(),itend=Xcas_program_map.end();
  for (;it!=itend;++it){
   if (it->second.changed){
   int i=fl_ask(((it->first+": ")+gettext("Save program changes?")).c_str());
   if (i==1){
    Program_editor->buffer()->text(it->second.s.c_str());
    save_current_program(it->first.c_str());
    cerr << "Program " << it->first << " saved " << endl;
   }
  }
 }
#ifdef HAVE_LIBFLVW
  save_current_xcas_matrix(matrixfilename);
  std::map<std::string,giac::xcas_matrix>::iterator jt=Xcas_matrix_map.begin(),jtend=Xcas_matrix_map.end();
  for (;jt!=jtend;++jt){
   if (jt->second.changed){
   int i=fl_ask(((jt->first+": ")+gettext("Save sheet changes?")).c_str());
   if (i==1){
     ofstream of(jt->first.c_str());
     if (jt->second.is_spreadsheet)
       of << gen(jt->second.m,_SPREAD__VECT) << endl;
     else
       of << gen(extractmatricefromsheet(jt->second.m)) << endl;
     cerr << "Sheet " << jt->first << " saved " << endl;
    }
   }
  }
#endif //
 ofstream of3("session.eqw");
 of3 << Eqw_eqw->get_data();
 cerr << "Current equation saved to session.eqw" << endl;
 if (!history_saved && !history_in.empty()){
   int i=1;
   if (strcmp(filename,"session.ar"))
     i=fl_ask(gettext("Save history changes?"));
   if (i==1){
     save_file(filename,0,true);
     cerr << "Current history saved to file " << filename << endl ;
   }
 } 
 if (!debug_infolevel){
    unlink(cas_entree_name().c_str());
    unlink(cas_sortie_name().c_str());
 }
 unlink_tmp_files();
 unlink(cas_recalc_name().c_str());
 kill_gnuplot(); 
 if (child_id>0)
   kill(child_id,SIGKILL); 
 if (in_texmacs){
      cout << GIAC_DATA_END;
      fflush (stdout);
      return errorcode;
 }
  return Fl::run();
}
