/*****************************************************************************
 * wmhooks.c: Some WindowManager specific stuff functions and definitions
 *****************************************************************************
 * $Id: wmhooks.h,v 1.5 2003/03/03 18:34:20 keuleu Exp $
 *****************************************************************************
 * Copyright (C) 2001 Keuleu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************
 *
 * This software was based on xawtv. Those portions are
 * Copyright (C) 1998 Gerd Knorr <kraxel@cs.tu-berlin.de>
 *
 *****************************************************************************/
#ifndef _WMHOOKS_H_
#define _WMHOOKS_H_

int wm_detect(Display *dpy);
void (*wm_stay_on_top)(Display *dpy, Window win, int state);
void (*wm_fullscreen)(Display *dpy, Window win, int state);
void wm_decoration(Widget w, int decorations);
#define STAYONTOP_ONBOTTOM  0 // -1
#define STAYONTOP_NORMAL    1 //  0
#define STAYONTOP_ONTOP     2 //  1

enum {
  WMHOOKS_NO = 0,
  WMHOOKS_YES
};

/*
#define STAYONTOP_YES       1
#define STAYONTOP_NO        0
*/
#endif // _WMHOOKS_H_
