/*
xkeymouse enables synthezing button events from keyboard events
Copyright (C) 2001 Henrik Sandklef

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
ERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/


#ifndef XKEYMOUSE_H
#define XKEYMOUSE_H

#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include <signal.h>
#include <unistd.h>
#include <stdlib.h>

#include <X11/Xlib.h>
#include <X11/extensions/XTest.h>



/*
 *  Error codes
 */
#define XKEYMOUSE_RC_ERROR            11 
#define XKEYMOUSE_ALLOC_FAILED        12 
#define XKEYMOUSE_DISPLAY_FAILED      13 
#define XKEYMOUSE_NOT_GRAB            14
#define XKEYMOUSE_BAD_MODIFIER        15


#define XKEYMOUSE_LOCAL_RC    ".xkmrc"
#define XKEYMOUSE_SYSTEM_RC   "/etc/xkmc"
#define XKEYMOUSE_NR_OF_KEYS  400 /* number of keys on keyboard, helps avoiding problem */
#define MAX_LINE_LENGTH 200     /*maximum length of line in rc files */
#define XKEYMOUSE_LINE_LENGTH 200 /*maximum length of rc line */

#define PROGRAM_NAME     "xkm"
#define PROGRAM_VERSION  "0.4.2"
#define PROGRAM_RC_ENV   "XKEYMOUSE_RC"
#define PROGRAM_DATE     "2002-05-14"
#define PROGRAM_URL      "http://www.sandklef.com/xkm/"
#define PROGRAM_MAIL     "xkm@sandklef.com"
#define PROGRAM_AUTHORS  "Henrik Sandklef"
#define GPL_URL          "http://www.fsf.org/copyleft/gpl.html"


#define XKEYMOUSE_PRESS 1
#define XKEYMOUSE_RELEASE 2

#define XKEYMOUSE_BUTTON               1
#define XKEYMOUSE_MOTION               2
#define XKEYMOUSE_EXEC                 3
#define XKEYMOUSE_KEY                  4

#define XKEYMOUSE_BUTTON_1             1
#define XKEYMOUSE_BUTTON_2             2
#define XKEYMOUSE_BUTTON_3             3
#define XKEYMOUSE_BUTTON_4             4
#define XKEYMOUSE_BUTTON_5             5

#define XKEYMOUSE_NO_MOTION           0
#define XKEYMOUSE_MOTION_LEFT        -1
#define XKEYMOUSE_MOTION_RIGHT        1
#define XKEYMOUSE_MOTION_UP          -1
#define XKEYMOUSE_MOTION_DOWN         1

#define XKEYMOUSE_REPEAT_ON     0
#define XKEYMOUSE_REPEAT_OFF    1

#define XKM_COMMAND_LINE_SIZE      300


#define XKEYMOUSE_SINGLE_CLICK       1
#define XKEYMOUSE_DOUBLE_CLICK       2

/*
 * Structure for Button actions
 */ 
struct _button_action
{
  int nr;
  int double_click;
} button_action;


/*
 * Structure for Motion actions
 */ 
struct _motion_action
{
  int x_direction;
  int y_direction;
  int speed;
} motion_action;


/*
 * Structure for Key actions
 */ 
struct _key_action
{
  int keycode;
} key_action;


/*
 * Structure for Exec actions
 */ 
struct _exec_action
{
  char command_line[XKM_COMMAND_LINE_SIZE];
} exec_action;


/*
 * Structure for holding XGrab data 
 */
typedef struct _grab_data
{
  int   code;      /* which key shall be grabbed  ... */
  int   modifier;  /* is there a modifier together with the above code/key */
  int   autorepeat; 
  int   type;      /* What to emulate :  XKEYMOUSE_BUTTON, XKEYMOUSE_MOTION, XKEYMOUSE_KEY, XKEYMOUSE_EXEC */

  
  union 
  {
    struct _button_action  ba;
    struct _motion_action  ma;
    struct _exec_action    ea;
    struct _key_action     ka;
  } xkm_action;

} grab_data; 




/*
 * Structure for holding xkm program data 
 */
typedef struct {
  char       *program;
  char       *version;

  char       *display_name;
  Display    *data_display;
  int         screen;
  Window      window;

  grab_data **grab_data_list;
  int         gdl_size;
  int         size;

  int         cli_rc;
  int         close_down;
  int         verbose;

  FILE       *fd;

} xkm_prog_data; 





void 
signal_handler(int );

int 
count_rc_lines (xkm_prog_data *xd);

void
add_all_data(xkm_prog_data *xd);

/*
 * Grabs or Ungrabs all data in xkm_prog_data
 *
 * int = 1      Grabs
 * int = 0      Ungrabs
 *
 */
int
grab_all_data (xkm_prog_data *xd,int);

int
rc_lines(xkm_prog_data *xd, int fill);

int
read_line (xkm_prog_data *xd,char *, grab_data *, int );

int 
is_comment_or_blank (char *str) ;

int 
xkm_strip(char *) ;

char*
str_strip(char *) ;

void 
xkm_close_down(xkm_prog_data *);


grab_data** 
new_grab_data_list();


grab_data** 
alloc_grab_data (grab_data **gd_list, xkm_prog_data *xd);

grab_data* 
new_grab_data();


void 
xkm_error (char *msg, ...);

void 
xkm_verbose ( char *msg, ...);



/*  
 *  Checks if the first argument is equals to any of the other two 
 *   and returns 1 if that's the case, else it returns 0            
 */
int 
xkm_check ( char *arg, char *long_arg , char *short_arg );


int 
xkm_parse_args ( xkm_prog_data *, int, char**);

int
xkm_init (xkm_prog_data *);

int 
xkm_open_rc_file (xkm_prog_data *);


void
xkm_version();

void 
set_no_repeat (int,int);


void
xkm_print_settings(xkm_prog_data*);



extern xkm_prog_data *xkm_data;




#endif
