/* XMMS Pipe Control Plugin
 * This is Jeremy Schaeffer's version
 * Use "make xmmspipe-js" to compile it
 */
/*
Copyright (C) 2002 Benjamin Lynn (blynn@cs.stanford.edu)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/


#ifndef XMMSPIPE_H
#define XMMSPIPE_H

typedef struct
{
 gint session;
 gint version;
 gint otime;
 gint playtime;
 gint playlist_length;
 gint playlist_pos;
 gint rate;
 gint freq;
 gint nch;
 gint lvolume;
 gint rvolume;
 gint balance;
 gchar playfile[2048];
 gchar playtitle[1024];
 gchar stat[8];
 gboolean playing;
 gboolean paused;
}
XmmsData;

typedef struct
{
 gboolean otime;
 gboolean playtime;
 gboolean playlist_length;
 gboolean playlist_pos;
 gboolean rate;
 gboolean freq;
 gboolean nch;
 gboolean lvolume;
 gboolean rvolume;
 gboolean balance;
 gboolean playfile;
 gboolean playtitle;
 gboolean stat;
}
XmmsChange;

typedef struct
{
 gboolean involfade;
 gboolean abortfade;
 gboolean incue;
 gboolean stopcue;
}
XmmsPipeStatus;

typedef struct
{
 gboolean cuemode;
 gboolean cuefade;
 gboolean cuewatching;
 gboolean mute_flag;
 gint statusmode;
 gint fadespeed;
 gint fadelevel;
 gint cuestarttime;
 gint cuestoptime;
 gdouble tickcal;
 gint last_vl;
 gint last_vr;
 gchar ackas[256];
 gchar next[2048];
}
XmmsPipeValues;

typedef struct
{
 int ipipe[2];
 int opipe[2];
 int spipe[2];
 gchar *ipipestr;
 gchar *opipestr;
 gchar *spipestr;
 gchar *idfile;
 gboolean opipestart;
 gboolean spipestart;
 gboolean setupid;
}
XmmsPipePipes;

typedef struct
{
 GtkWidget *inputfiletxt;
 GtkWidget *ackfiletxt;
 GtkWidget *ackfileauto;
 GtkWidget *ackstring;
 GtkWidget *statusfiletxt;
 GtkWidget *statusfileauto;
 GtkWidget *fadespeed;
 GtkWidget *fadelevel;
 GtkWidget *cueplay;
 GtkWidget *cuepause;
 GtkWidget *cuestart;
 GtkWidget *cuestop;
 GtkWidget *cuefade;
 GtkWidget *idfiletxt;
 GtkWidget *idfileauto;
}
ConfigWidgetValues;

#endif


