/* AbiSource
 * 
 * Copyright (C) 2002 Dom Lachowicz <cinamod@hotmail.com>
 * Copyright (C) 2005 Daniel d'Andrada T. de Carvalho
 * <daniel.carvalho@indt.org.br>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA.
 */


#ifndef _OO_LISTENER_H_
#define _OO_LISTENER_H_

// Internal includes
#include "OO_ListenerImpl.h"
#include "ie_exp_OpenDocument.h"

// Abiword includes
#include <pd_Document.h>

class OO_Listener : public PL_Listener
{
public:
    OO_Listener(PD_Document * pDocument, IE_Exp_OpenDocument * pie,
        OO_ListenerImpl *pListenerImpl);

    virtual bool populate(PL_StruxFmtHandle sfh, const PX_ChangeRecord * pcr);
    
    virtual bool populateStrux(PL_StruxDocHandle sdh,
        const PX_ChangeRecord * pcr, PL_StruxFmtHandle * psfh);
        
    virtual bool change(PL_StruxFmtHandle sfh, const PX_ChangeRecord * pcr);
    
    virtual bool insertStrux(PL_StruxFmtHandle sfh,
                const PX_ChangeRecord * pcr,
                PL_StruxDocHandle sdh,
                PL_ListenerId lid,
                void (* pfnBindHandles)(PL_StruxDocHandle sdhNew,
                            PL_ListenerId lid,
                            PL_StruxFmtHandle sfhNew));
                            
    virtual bool signal(UT_uint32 iSignal);

    void endDocument();

private:
    void _openSpan(PT_AttrPropIndex api);
    void _closeSpan();
    void _openBlock(PT_AttrPropIndex apiSpan);
    void _closeBlock();

    bool m_bInBlock;
    bool m_bInSpan;

    OO_ListenerImpl* m_pListenerImpl;
    PD_Document* m_pDocument;
    IE_Exp_OpenDocument* m_pie;

};

#endif //_OO_LISTENER_H_
