/* AbiSource Program Utilities
 * 
 * Copyright (C) 2002 Dom Lachowicz <cinamod@hotmail.com>
 * Copyright (C) 2005 Daniel d'Andrada T. de Carvalho
 * <daniel.carvalho@indt.org.br>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA.
 */
 
 
 
#include "OO_PageStyle.h"
#include <ut_assert.h>
#include <ut_misc.h>
#include <ut_units.h>
#include <ut_math.h>
#include <pd_Document.h>
 
 
 
/**
 * Parse attributes array and map keys and values
 * to Abi's.
 */
void OO_PageStyle::appendPageMaster(const XML_Char* pName,
                                    const XML_Char** ppAtts) 
{
    // FIXME ATM only one page setup per document can be imported
    if (m_name != "") {
        UT_ASSERT(UT_SHOULD_NOT_HAPPEN);
    }

    m_name = pName;
    parse(ppAtts);
}






/**
 * Returns the name of the current page setup style.
 */
const XML_Char* OO_PageStyle::getName() const 
{
    return reinterpret_cast<const XML_Char*>(m_name.c_str());
}










/**
 * Returns attribute array for the <pagesize> tag.
 */
const XML_Char** OO_PageStyle::getAbiPageAtts(const XML_Char* pMasterName)
{
    UT_return_val_if_fail(pMasterName != NULL, (const XML_Char**)m_pageAtts);

    if (UT_strcmp (m_name.c_str(), pMasterName)) {
        // FIXME can there be more than one master-page?
        UT_ASSERT(UT_SHOULD_NOT_HAPPEN);
    }
    
    return (const XML_Char **)m_pageAtts;
}









/**
 * Returns props string for the <section> tag.
 */
const XML_Char* OO_PageStyle::getAbiSectionProps() const
{
    return reinterpret_cast<const XML_Char*>(m_sectionProps.c_str());
}










/**
 * 
 */
void OO_PageStyle::parse (const XML_Char** pProps)
{
    const XML_Char* val = NULL;
    int propCtr = 0;
    double width = 0;
    double height = 0;

    // will go into the <pagesize> tag
    val = UT_getAttribute ("fo:page-width", pProps);
    if (val) {
        width = rint(UT_convertToDimension(val, DIM_MM));
        m_width = UT_String_sprintf("%f", width);
        m_pageAtts[propCtr++] = "width";
        m_pageAtts[propCtr++] = m_width.c_str();
    }

    val = UT_getAttribute ("fo:page-height", pProps);
    if (val) {
        height = rint(UT_convertToDimension(val, DIM_MM));
        m_height = UT_String_sprintf("%f", height);
        m_pageAtts[propCtr++] = "height";
        m_pageAtts[propCtr++] = m_height.c_str();
    }

    m_pageAtts[propCtr++] = "units";
    m_pageAtts[propCtr++] = "mm";

    val = UT_getAttribute ("style:print-orientation", pProps);
    if (val) {
        m_pageAtts[propCtr++] = "orientation";
        m_pageAtts[propCtr++] = strdup (val);
    }

    m_pageAtts[propCtr++] = "page-scale";
    m_pageAtts[propCtr++] = "1.0";

    // width and height are rounded to full mm because that's how they are
    // predefined in Abi and there seem to be rounding errors in oow's exporter
    fp_PageSize ps(width, height, DIM_MM);
    m_pageAtts[propCtr++] = "pagetype";
    m_pageAtts[propCtr++] = ps.getPredefinedName();

    m_pageAtts[propCtr] = 0;

    // will go as pProps into the <section> tag
    val = UT_getAttribute ("fo:margin-left", pProps);
    if (val)
        m_marginLeft = UT_String_sprintf("page-margin-left: %s;", val);

    val = UT_getAttribute ("fo:margin-top", pProps);
    if (val)
        m_marginTop = UT_String_sprintf("page-margin-top: %s;", val);

    val = UT_getAttribute ("fo:margin-right", pProps);
    if (val)
        m_marginRight = UT_String_sprintf("page-margin-right: %s;", val);

    val = UT_getAttribute ("fo:margin-bottom", pProps);
    if (val)
        m_marginBottom = UT_String_sprintf("page-margin-bottom: %s;", val);

#define APPEND_STYLE(sty) if (sty.size()) m_sectionProps += sty;
    APPEND_STYLE(m_marginLeft);
    APPEND_STYLE(m_marginTop);
    APPEND_STYLE(m_marginRight);
    APPEND_STYLE(m_marginBottom);
#undef APPEND_STYLE
    if (m_sectionProps.size () > 0)
        m_sectionProps [m_sectionProps.size()-1] = 0;
}
