/*
 *  $Id: arrows.c,v 1.13 2004/12/20 20:42:58 tom Exp $
 *
 *  arrows.c -- draw arrows to indicate end-of-range for lists
 *
 * Copyright 2000-2003,2004   Thomas E. Dickey
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "dialog.h"

#ifdef USE_WIDE_CURSES
#define add_acs(win, code) wadd_wch(win, W ## code)
#else
#define add_acs(win, code) waddch(win, code)
#endif

#ifdef HAVE_COLOR
static chtype
merge_colors(chtype foreground, chtype background)
{
    chtype result = foreground;
    if ((foreground & A_COLOR) != (background & A_COLOR)) {
	short fg_f, bg_f;
	short fg_b, bg_b;
	if (pair_content(PAIR_NUMBER(foreground), &fg_f, &bg_f) != ERR
	    && pair_content(PAIR_NUMBER(background), &fg_b, &bg_b) != ERR) {
	    result &= ~A_COLOR;
	    result |= dlg_color_pair(fg_f, bg_b);
	}
    }
    return result;
}
#else
#define merge_colors(f,b) (f)
#endif

void
dlg_draw_arrows2(WINDOW *dialog,
		 int top_arrow,
		 int bottom_arrow,
		 int x,
		 int top,
		 int bottom,
		 chtype attr,
		 chtype borderattr)
{
    chtype save = getattrs(dialog);
    int cur_x, cur_y;

    getyx(dialog, cur_y, cur_x);

    (void) wmove(dialog, top, x);
    if (top_arrow) {
	wattrset(dialog, merge_colors(uarrow_attr, attr));
	(void) add_acs(dialog, ACS_UARROW);
	(void) waddstr(dialog, "(+)");
    } else {
	wattrset(dialog, attr);
	(void) whline(dialog, ACS_HLINE, 4);
    }
    mouse_mkbutton(top, x - 1, 6, KEY_PPAGE);

    (void) wmove(dialog, bottom, x);
    if (bottom_arrow) {
	wattrset(dialog, merge_colors(darrow_attr, attr));
	(void) add_acs(dialog, ACS_DARROW);
	(void) waddstr(dialog, "(+)");
    } else {
	wattrset(dialog, borderattr);
	(void) whline(dialog, ACS_HLINE, 4);
    }
    mouse_mkbutton(bottom, x - 1, 6, KEY_NPAGE);

    (void) wmove(dialog, cur_y, cur_x);
    wrefresh(dialog);

    wattrset(dialog, save);
}

void
dlg_draw_arrows(WINDOW *dialog,
		int top_arrow,
		int bottom_arrow,
		int x,
		int top,
		int bottom)
{
    dlg_draw_arrows2(dialog,
		     top_arrow,
		     bottom_arrow,
		     x,
		     top,
		     bottom,
		     menubox_attr,
		     menubox_border_attr);
}
