/*  DUMB-XMMS - Plug-in to enable XMMS to use DUMB for IT/XM/S3M/MOD files
 *  Copyright (C) 2002-2003  Ben Davis
 *  Incorporates code from the wav plug-in,
 *  Copyright (C) 1998-2000  Peter Alm, Mikael Alm, Olle Hallnas, Thomas Nilsson and 4Front Technologies
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef INC_DUMB_XMMS_H
#define INC_DUMB_XMMS_H

#include <dumb.h>

#if DUMB_VERSION < 902
#error You must get DUMB v0.9.2 or later. Prior versions do
#error not have the thread safety required by this plug-in.
#endif

#define VERSIONSTRING DUMB_NAME ": IT/XM/S3M/MOD Player Plug-in v0.1"

#include <pthread.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include <xmms/plugin.h>
#include <xmms/util.h>
#include <xmms/titlestring.h>

extern InputPlugin duh_ip;

typedef struct
{
	DUH *duh;
	DUH_SIGRENDERER *file;
	short channels, bits_per_sample, eof, going;
	long samples_per_sec;
	unsigned long position, length;
	int seek_to;
	pid_t pid;
}
DuhFile;

static void duh_init(void);
static int is_our_file(char *filename);
static void play_file(char *filename);
static void stop(void);
static void seek(int time);
static void duh_pause(short p);
static int get_time(void);
static void get_song_info(char *filename, char **title, int *length);

#endif /* INC_DUMB_XMMS_H */
