/******************************************************************************
//             INTEL CORPORATION PROPRIETARY INFORMATION
//  This software is supplied under the terms of a license agreement or
//  nondisclosure agreement with Intel Corporation and may not be copied
//  or disclosed except in accordance with the terms of that agreement.
//        Copyright (c) 2001 Intel Corporation. All Rights Reserved.
//
//  VSS: 
//		$Workfile: vector.h $
//		$Revision: 1 $
//		$Date: 05-02-28 16:03 $
//
//  Description:
//		IPP vector manipulation example
******************************************************************************/

/* Standard IPP definitions */
#include <ippdefs.h>
#include <ippSP.h>

/* Signal types */
#define		TONE				0
#define		NOISE				1
#define		DEFAULT_TONE_AMP	16384		/* Q15 amplitude */
#define		DEFAULT_TONE_FRQ	100			/* Q15 frequency */

/* Interface */
void GenerateSignal(Ipp16s *signal, Ipp16s *noise, int length);
void SetNoiseSigma(int sigma);
void GetSNR(int *);
void SelectSignal(int type, int state);
void SetToneFrequency(Ipp16s frequency, int SampleRate);
void SetToneAmplitude(Ipp16s a);


