#ifndef _ZDBMANAGER_H_
#define _ZDBMANAGER_H_

#define		DATATYPE_TEXT		17
#define		DATATYPE_UCHAR		11
#define		DATATYPE_USHORT		8
#define		DATATYPE_ULONG		18
#define		DATATYPE_COLOR		13
#define		DATATYPE_TIME		4
#define		DATATYPE_BINARY		9
#define		DATATYPE_CATEGORY	0

#define		TYPE_ADDRESS		"address"
#define		TYPE_TODO			"todo"
#define		TYPE_DATEBOOK		"datebook"
#define		TYPE_MAILINBOX		"inbox"
#define		TYPE_MAILOUTBOX		"outbox"
#define		TYPE_MEMO			"memo"

#include <sl/slzdb.h>
#include <sl/slcategories.h>

#include <qpe/timeconversion.h>
#include <qpe/palmtoprecord.h>

#include <qtextcodec.h>
#include <qtextstream.h>
#include <qdir.h>

#include "CSVParser.h"

struct RecordInfoData {
	int type;
	int field;
};

typedef QMap<QString, RecordInfoData> RecordInfo;
typedef QMap<QString, QString> RecordData;

struct ZdbData {
	QStringList fields;
	QStringList sysfields;
	RecordInfo info;
	QValueList<RecordData> data;
};

class ZdbManager
{
public:
	ZdbManager();
	~ZdbManager();
	bool init(const QString& dbtype,
				const QString& basedir=QString::null,
				bool isReadOnly=true);
	int doInfo();
	int doRead(CardId id=0);
	int doWrite();
	int doDelete();

	void readInfo();
	void readData();
	void outputData();
	void outputInfo();

	void setCodec(const QString& codec){
		if(codec && QTextCodec::codecForName(codec)){
			m_codec = codec;
		}
	}

	void setFields(const QString& fields){
		QStringList list = CSVParser::parse(fields);
		setFields(list);
	}
	void setSysFields(const QString& fields){
		QStringList list = CSVParser::parse(fields);
		m_sysFields = list;
	}
	void setCategoryAddEnable(bool enable=false){
		m_addCategory = enable;
	}

private:
	SlZDataBase* m_pZdb;
	ZdbData m_dbData;
	QString m_codec;
	SlCategories* m_pCategories;
	QStringList m_sysFields;

	bool m_addCategory;

	QString typeName(int type);
	void setFields(const QStringList& fields);
	void readRecord(CardId id);
	bool makeRecord(const QStringList& fields,const QStringList& data,
		RecordData& record);
	CardId writeRecord(const RecordData& record);
	bool editRecord(CardId& id, const RecordData& record);
	QString readItem(const QString& name, CardId id, int type=0);
	bool writeItem(const QString& name, QString value, int type=0);
	QString readCategory(CardId id);
	bool deleteRecord(const RecordData& record);

	bool updateCategories(CardId id, const QString& categories);

	QCString toISO8601(const QDateTime &dt);
	QDateTime fromISO8601(const QCString& s);
};

#endif /* _ZDBMANAGER_H_ */
