/*  This file is part of the KDE project
    Copyright (C) 2000 Simon Hausmann <hausmann@kde.org>
    Copyright (C) 2003 Luciano Montanaro <mikelima@cirulla.net>
    Copyright (C) 2001 Dirk Mueller <mueller@kde.org>
    Copyright (C) 2004 Fastweb SpA

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/
#ifndef __kaction_h__
#define __kaction_h__

#include <qobject.h>
#include <qobjectlist.h>
#include <qguardedptr.h>
#include <qmap.h>

class QIconSet;
class KAction;
class QStringList;

class KPopupMenu;

// Needed by the KDE3 html part
class KShortcut
{
public:
    KShortcut(const char * = 0) {}
    KShortcut(int accel) { m_accel = accel; }
private:
    int m_accel;
};

class QAction;
class KActionSeparator;

class KActionCollection : public QObject
{
    Q_OBJECT
public:
    KActionCollection( QObject *parent = 0, const char *name = 0 )
        : QObject( parent, name ), m_timer( true ) {}

    KAction *action( const char *name );

    virtual void insertChild( QObject *obj );
    virtual void removeChild( QObject *obj );
    inline void insert( KAction *act ) { insertChild( (QObject*)act ); }
    inline void remove( KAction *act ) { removeChild( (QObject*)act ); }

    void qDisconnect();
    void clearNotifications() { m_newlyAdded.clear(); }

signals:
    void inserted( KAction* );
    void inserted( const char * );
    void removed( KAction* );
    void removed( const char * );

private slots:
    void insertNotify();

private:
    bool m_timer;
    QObjectList m_newlyAdded;
};

class KAction : public QObject
{
    Q_OBJECT
public:
    // Needed by KDE 3.5
    KAction( const QString &text, const KShortcut &cut,
             const QObject *receiver, const char *slot,
             KActionCollection *parent, const char *name );
    
    KAction( const QString &text, const KShortcut &cut, 
             const QObject *receiver, const char *slot,
             QObject *parent, const char *name, bool connectIt = true );

    KAction( const QString &text, const QString &icon, int accel, const QObject *receiver, const char *slot,
             QObject *parent, const char *name );

    KAction( const QString &text, const QIconSet &icon, int accel, const QObject *receiver, const char *slot,
             QObject *parent, const char *name );

    // Needed by kdelibs 3.2
    KAction( const QString& text, int accel, 
	     QObject* parent = 0, const char* name = 0 );
    
    KAction(QObject* parent = 0, const char* name = 0);

    virtual ~KAction();

    // Needed by kdelibs 3.2
    virtual void setWhatsThis( const QString& /*text*/ ) {}
    
    void setIcon( const QString & ) {};

    bool isEnabled() const { return m_enabled; }
    void setText( const QString& ) {};

    // assigns an icon name (used with setIcon) a specified iconset
    void assignIconSet( const QString &, const QIconSet & ) {};

    virtual void qConnect( QAction *action );
    virtual void qDisconnect();

public slots:
    virtual bool setShortcut( const KShortcut& ) { return false; }
    void setEnabled( bool enable );
    void activate() { emit activated(); }

private:
    QMap<QString,QIconSet> m_icons;

signals:
    void activated();
    void enabled( bool );

protected:
    bool m_enabled;
    QGuardedPtr<QAction> m_qConnected;
};

class KSelectAction : public KAction
{
public:
    KSelectAction( const QString &text, int accel, const QObject *receiver, const char *slot,
                   QObject *parent, const char *name )
	: KAction( text, accel, receiver, slot, parent, name ) {}

    // ###
    void setItems( const QStringList & ) {}
    void setCurrentItem( int ) {}

    int currentItem() { return 0; }
    QString currentText() { return QString::null; }
};

class KToggleAction : public KAction
{
    Q_OBJECT
public:
    KToggleAction( const QString &text, int accel,
		   const QObject *receiver, const char *slot,
        	   QObject *parent, const char *name, bool connectIt = true );

    KToggleAction( const QString &text, int accel,
        	   QObject *parent, const char *name );

    bool isChecked() const { return m_checked; }

    virtual void qConnect( QAction *action );
    virtual void qDisconnect();

public slots:
    void setChecked( bool checked );

signals:
    void toggled( bool );

protected slots:
    void slotChecked( bool checked );

protected:
    bool m_checked;
    bool m_reenter;
};

class KActionMenu : public KAction
{
public:
    KActionMenu(const QString& text, QObject* parent = 0, 
	    const char* name = 0) : KAction(text, 0, parent, name) {}

    KActionMenu(const QString &text, const QString & /* icon */, QObject* parent = 0, 
	    const char* name = 0 ) : KAction(text, 0, parent, name) {}

    void setDelayed(bool /* delayed */) {}
    
    KPopupMenu *popupMenu() const { return 0; }
    
    void insert(KAction*, int /* index */ = -1) {}
};

class KActionSeparator : public KAction
{
public:
    KActionSeparator(QObject* parent = 0, const char* name = 0) :
	KAction(parent, name) {}
};

#endif
