/*  This file is part of the KDE project
    Copyright (C) 2000 Simon Hausmann <hausmann@kde.org>
    Copyright (C) 2003 Luciano Montanaro <mikelima@cirulla.net>
    Copyright (C) 2002 Paul Chitescu <Paul.Chitescu@IMC-Group.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef __kfiledialog_h__
#define __kfiledialog_h__

#include <config.h>

#include <qfiledialog.h>
#include <kio/kmimetype.h>
#if defined(ENABLE_READWRITE)
#include <kurl.h>
#endif

class KFileDialog
{
public:
    static QString getOpenFileName( const QString &dir = QString::null,
                                    const QString &filter = QString::null,
                                    QWidget *parent = 0, const QString &caption = QString::null );
#if defined(ENABLE_READWRITE)
    static QString getSaveFileName( const QString &dir = QString::null, 
                                    const QString &filter = QString::null,
                                    QWidget *parent = 0, const QString &caption = QString::null );
    static KURL getSaveURL( const QString &dir= QString::null,
                            const QString &filter= QString::null,
                            QWidget *parent= 0, const QString &caption= QString::null )
	{ return getSaveFileName( dir, filter, parent, caption ); }
#endif
};

#if defined(_QT_QPE_) || defined(Q_WS_WIN32)

#if defined(_QT_QPE_)
#include <qpe/fileselector.h>
#else
struct DocLnk
{
    QString file() const { return QString::null; }
};
#endif

class QPEFileSelectorWrapper : public QDialog
{
    Q_OBJECT
public:
    QPEFileSelectorWrapper( QWidget *parent, const char *name = 0 );
    virtual ~QPEFileSelectorWrapper();

    QString selectedPath() const { return m_path; }

private slots:
    void fileSelected( const DocLnk &doc );

private:
    QString m_path;
};

#endif

#endif
