/*  This file is part of the KDE project
    Copyright (C) 2000 Simon Hausmann <hausmann@kde.org>
    Copyright (C) 2004 Fastweb SpA

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef __kglobalsettings_h__
#define __kglobalsettings_h__

#include <qfont.h>
#include <qrect.h>

#define KDE_DEFAULT_CHANGECURSOR true

class KGlobalSettings
{
public:

    static QFont generalFont();
    static QFont fixedFont();
    static QFont menuFont() { return generalFont(); }
    static QFont windowTitleFont() { return generalFont(); }

    static int dndEventDelay() { return 5; } // ###

    static int contrast() { return 7; } // ###

    // Required by kdelibs 3.2
    // XXX may need a proper implementation.
    static QRect desktopGeometry(QWidget * /* w */) { return QRect(0, 0, 160, 160); }

    static QString documentPath() { return "/tmp/"; }
    
    // Required by kdelibs 3.4
    static bool showIconsOnPushButtons() { return false; }
private:
    static QFont *s_generalFont;
    static QFont *s_fixedFont;
};

#endif
