#ifndef __kurifilter_h__
#define __kurifilter_h__ 

#include <qstringlist.h>
#include <kurl.h>


class KURIFilterData
{
public:
    enum URITypes { 
	    NET_PROTOCOL=0, 
	    LOCAL_FILE, 
	    LOCAL_DIR, 
	    EXECUTABLE, 
	    HELP, 
	    SHELL, 
	    BLOCKED, 
	    ERROR, 
	    UNKNOWN 
    };

    KURIFilterData() {}
    void setData(const QString& url) { m_pURI = url; }
    void setData(KURL &uri) { m_pURI = uri; }
    
    // Needed by kdelibs 3.2
    void setCheckForExecutables(bool check) {}
    // Needed by kdelibs 3.2
    bool checkForExecutables() { return false; }
    
    URITypes uriType() const { return UNKNOWN; }
    KURL uri() const { return m_pURI; }

    // Needed by kdelibs 3.2, XXX the error message should really be implemented
    QString errorMsg() const { return QString(); }
    
private:
    KURL m_pURI; 
};

class KURIFilter
{
public:
    // HACK!!! This could break stuff.  It works for now, since it is used as in
    // KURIFilter::self()->filterURI(...) which is probably optimized to false.
    static KURIFilter* self() { return 0; }

    bool filterURI(KURIFilterData& /*data*/, 
		   const QStringList & /* filters */ = QStringList()) const { 
	    return false; 
    }

    // Needed by kdelibs 3.2
    QStringList pluginNames() const { return QStringList(); }
};

#endif

